# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TargetArgs', 'Target']

@pulumi.input_type
class TargetArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 anthos_cluster: Optional[pulumi.Input['TargetAnthosClusterArgs']] = None,
                 associated_entities: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssociatedEntityArgs']]]] = None,
                 custom_target: Optional[pulumi.Input['TargetCustomTargetArgs']] = None,
                 deploy_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_configs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]] = None,
                 gke: Optional[pulumi.Input['TargetGkeArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 multi_target: Optional[pulumi.Input['TargetMultiTargetArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 require_approval: Optional[pulumi.Input[_builtins.bool]] = None,
                 run: Optional[pulumi.Input['TargetRunArgs']] = None):
        """
        The set of arguments for constructing a Target resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['TargetAnthosClusterArgs'] anthos_cluster: Information specifying an Anthos Cluster.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssociatedEntityArgs']]] associated_entities: Optional. Map of entity IDs to their associated entities. Associated entities allows specifying places other than the deployment target for specific features. For example, the Gateway API canary can be configured to deploy the HTTPRoute to a different cluster(s) than the deployment cluster using associated entities. An entity ID must consist of lower-case letters, numbers, and hyphens, start with a letter and end with a letter or a number, and have a max length of 63 characters. In other words, it must match the following regex: `^a-z?$`.
        :param pulumi.Input['TargetCustomTargetArgs'] custom_target: Optional. Information specifying a Custom Target.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] deploy_parameters: Optional. The deploy parameters to use for this target.
        :param pulumi.Input[_builtins.str] description: Optional. Description of the `Target`. Max length is 255 characters.
        :param pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]] execution_configs: Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        :param pulumi.Input['TargetGkeArgs'] gke: Information specifying a GKE Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['TargetMultiTargetArgs'] multi_target: Information specifying a multiTarget.
        :param pulumi.Input[_builtins.str] name: Name of the `Target`. Format is `a-z?`.
               
               
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[_builtins.bool] require_approval: Optional. Whether or not the `Target` requires approval.
        :param pulumi.Input['TargetRunArgs'] run: Information specifying a Cloud Run deployment target.
        """
        pulumi.set(__self__, "location", location)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if anthos_cluster is not None:
            pulumi.set(__self__, "anthos_cluster", anthos_cluster)
        if associated_entities is not None:
            pulumi.set(__self__, "associated_entities", associated_entities)
        if custom_target is not None:
            pulumi.set(__self__, "custom_target", custom_target)
        if deploy_parameters is not None:
            pulumi.set(__self__, "deploy_parameters", deploy_parameters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_configs is not None:
            pulumi.set(__self__, "execution_configs", execution_configs)
        if gke is not None:
            pulumi.set(__self__, "gke", gke)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if multi_target is not None:
            pulumi.set(__self__, "multi_target", multi_target)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if require_approval is not None:
            pulumi.set(__self__, "require_approval", require_approval)
        if run is not None:
            pulumi.set(__self__, "run", run)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="anthosCluster")
    def anthos_cluster(self) -> Optional[pulumi.Input['TargetAnthosClusterArgs']]:
        """
        Information specifying an Anthos Cluster.
        """
        return pulumi.get(self, "anthos_cluster")

    @anthos_cluster.setter
    def anthos_cluster(self, value: Optional[pulumi.Input['TargetAnthosClusterArgs']]):
        pulumi.set(self, "anthos_cluster", value)

    @_builtins.property
    @pulumi.getter(name="associatedEntities")
    def associated_entities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssociatedEntityArgs']]]]:
        """
        Optional. Map of entity IDs to their associated entities. Associated entities allows specifying places other than the deployment target for specific features. For example, the Gateway API canary can be configured to deploy the HTTPRoute to a different cluster(s) than the deployment cluster using associated entities. An entity ID must consist of lower-case letters, numbers, and hyphens, start with a letter and end with a letter or a number, and have a max length of 63 characters. In other words, it must match the following regex: `^a-z?$`.
        """
        return pulumi.get(self, "associated_entities")

    @associated_entities.setter
    def associated_entities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssociatedEntityArgs']]]]):
        pulumi.set(self, "associated_entities", value)

    @_builtins.property
    @pulumi.getter(name="customTarget")
    def custom_target(self) -> Optional[pulumi.Input['TargetCustomTargetArgs']]:
        """
        Optional. Information specifying a Custom Target.
        """
        return pulumi.get(self, "custom_target")

    @custom_target.setter
    def custom_target(self, value: Optional[pulumi.Input['TargetCustomTargetArgs']]):
        pulumi.set(self, "custom_target", value)

    @_builtins.property
    @pulumi.getter(name="deployParameters")
    def deploy_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. The deploy parameters to use for this target.
        """
        return pulumi.get(self, "deploy_parameters")

    @deploy_parameters.setter
    def deploy_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "deploy_parameters", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Description of the `Target`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executionConfigs")
    def execution_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]]:
        """
        Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        """
        return pulumi.get(self, "execution_configs")

    @execution_configs.setter
    def execution_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]]):
        pulumi.set(self, "execution_configs", value)

    @_builtins.property
    @pulumi.getter
    def gke(self) -> Optional[pulumi.Input['TargetGkeArgs']]:
        """
        Information specifying a GKE Cluster.
        """
        return pulumi.get(self, "gke")

    @gke.setter
    def gke(self, value: Optional[pulumi.Input['TargetGkeArgs']]):
        pulumi.set(self, "gke", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="multiTarget")
    def multi_target(self) -> Optional[pulumi.Input['TargetMultiTargetArgs']]:
        """
        Information specifying a multiTarget.
        """
        return pulumi.get(self, "multi_target")

    @multi_target.setter
    def multi_target(self, value: Optional[pulumi.Input['TargetMultiTargetArgs']]):
        pulumi.set(self, "multi_target", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the `Target`. Format is `a-z?`.



        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="requireApproval")
    def require_approval(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Whether or not the `Target` requires approval.
        """
        return pulumi.get(self, "require_approval")

    @require_approval.setter
    def require_approval(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_approval", value)

    @_builtins.property
    @pulumi.getter
    def run(self) -> Optional[pulumi.Input['TargetRunArgs']]:
        """
        Information specifying a Cloud Run deployment target.
        """
        return pulumi.get(self, "run")

    @run.setter
    def run(self, value: Optional[pulumi.Input['TargetRunArgs']]):
        pulumi.set(self, "run", value)


@pulumi.input_type
class _TargetState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 anthos_cluster: Optional[pulumi.Input['TargetAnthosClusterArgs']] = None,
                 associated_entities: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssociatedEntityArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_target: Optional[pulumi.Input['TargetCustomTargetArgs']] = None,
                 deploy_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_configs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]] = None,
                 gke: Optional[pulumi.Input['TargetGkeArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_target: Optional[pulumi.Input['TargetMultiTargetArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 require_approval: Optional[pulumi.Input[_builtins.bool]] = None,
                 run: Optional[pulumi.Input['TargetRunArgs']] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Target resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['TargetAnthosClusterArgs'] anthos_cluster: Information specifying an Anthos Cluster.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssociatedEntityArgs']]] associated_entities: Optional. Map of entity IDs to their associated entities. Associated entities allows specifying places other than the deployment target for specific features. For example, the Gateway API canary can be configured to deploy the HTTPRoute to a different cluster(s) than the deployment cluster using associated entities. An entity ID must consist of lower-case letters, numbers, and hyphens, start with a letter and end with a letter or a number, and have a max length of 63 characters. In other words, it must match the following regex: `^a-z?$`.
        :param pulumi.Input[_builtins.str] create_time: Output only. Time at which the `Target` was created.
        :param pulumi.Input['TargetCustomTargetArgs'] custom_target: Optional. Information specifying a Custom Target.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] deploy_parameters: Optional. The deploy parameters to use for this target.
        :param pulumi.Input[_builtins.str] description: Optional. Description of the `Target`. Max length is 255 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Optional. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]] execution_configs: Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        :param pulumi.Input['TargetGkeArgs'] gke: Information specifying a GKE Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input['TargetMultiTargetArgs'] multi_target: Information specifying a multiTarget.
        :param pulumi.Input[_builtins.str] name: Name of the `Target`. Format is `a-z?`.
               
               
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] require_approval: Optional. Whether or not the `Target` requires approval.
        :param pulumi.Input['TargetRunArgs'] run: Information specifying a Cloud Run deployment target.
        :param pulumi.Input[_builtins.str] target_id: Output only. Resource id of the `Target`.
        :param pulumi.Input[_builtins.str] uid: Output only. Unique identifier of the `Target`.
        :param pulumi.Input[_builtins.str] update_time: Output only. Most recent time at which the `Target` was updated.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if anthos_cluster is not None:
            pulumi.set(__self__, "anthos_cluster", anthos_cluster)
        if associated_entities is not None:
            pulumi.set(__self__, "associated_entities", associated_entities)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_target is not None:
            pulumi.set(__self__, "custom_target", custom_target)
        if deploy_parameters is not None:
            pulumi.set(__self__, "deploy_parameters", deploy_parameters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if execution_configs is not None:
            pulumi.set(__self__, "execution_configs", execution_configs)
        if gke is not None:
            pulumi.set(__self__, "gke", gke)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if multi_target is not None:
            pulumi.set(__self__, "multi_target", multi_target)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if require_approval is not None:
            pulumi.set(__self__, "require_approval", require_approval)
        if run is not None:
            pulumi.set(__self__, "run", run)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="anthosCluster")
    def anthos_cluster(self) -> Optional[pulumi.Input['TargetAnthosClusterArgs']]:
        """
        Information specifying an Anthos Cluster.
        """
        return pulumi.get(self, "anthos_cluster")

    @anthos_cluster.setter
    def anthos_cluster(self, value: Optional[pulumi.Input['TargetAnthosClusterArgs']]):
        pulumi.set(self, "anthos_cluster", value)

    @_builtins.property
    @pulumi.getter(name="associatedEntities")
    def associated_entities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssociatedEntityArgs']]]]:
        """
        Optional. Map of entity IDs to their associated entities. Associated entities allows specifying places other than the deployment target for specific features. For example, the Gateway API canary can be configured to deploy the HTTPRoute to a different cluster(s) than the deployment cluster using associated entities. An entity ID must consist of lower-case letters, numbers, and hyphens, start with a letter and end with a letter or a number, and have a max length of 63 characters. In other words, it must match the following regex: `^a-z?$`.
        """
        return pulumi.get(self, "associated_entities")

    @associated_entities.setter
    def associated_entities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssociatedEntityArgs']]]]):
        pulumi.set(self, "associated_entities", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Time at which the `Target` was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customTarget")
    def custom_target(self) -> Optional[pulumi.Input['TargetCustomTargetArgs']]:
        """
        Optional. Information specifying a Custom Target.
        """
        return pulumi.get(self, "custom_target")

    @custom_target.setter
    def custom_target(self, value: Optional[pulumi.Input['TargetCustomTargetArgs']]):
        pulumi.set(self, "custom_target", value)

    @_builtins.property
    @pulumi.getter(name="deployParameters")
    def deploy_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. The deploy parameters to use for this target.
        """
        return pulumi.get(self, "deploy_parameters")

    @deploy_parameters.setter
    def deploy_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "deploy_parameters", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Description of the `Target`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="executionConfigs")
    def execution_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]]:
        """
        Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        """
        return pulumi.get(self, "execution_configs")

    @execution_configs.setter
    def execution_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]]):
        pulumi.set(self, "execution_configs", value)

    @_builtins.property
    @pulumi.getter
    def gke(self) -> Optional[pulumi.Input['TargetGkeArgs']]:
        """
        Information specifying a GKE Cluster.
        """
        return pulumi.get(self, "gke")

    @gke.setter
    def gke(self, value: Optional[pulumi.Input['TargetGkeArgs']]):
        pulumi.set(self, "gke", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="multiTarget")
    def multi_target(self) -> Optional[pulumi.Input['TargetMultiTargetArgs']]:
        """
        Information specifying a multiTarget.
        """
        return pulumi.get(self, "multi_target")

    @multi_target.setter
    def multi_target(self, value: Optional[pulumi.Input['TargetMultiTargetArgs']]):
        pulumi.set(self, "multi_target", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the `Target`. Format is `a-z?`.



        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="requireApproval")
    def require_approval(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Whether or not the `Target` requires approval.
        """
        return pulumi.get(self, "require_approval")

    @require_approval.setter
    def require_approval(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_approval", value)

    @_builtins.property
    @pulumi.getter
    def run(self) -> Optional[pulumi.Input['TargetRunArgs']]:
        """
        Information specifying a Cloud Run deployment target.
        """
        return pulumi.get(self, "run")

    @run.setter
    def run(self, value: Optional[pulumi.Input['TargetRunArgs']]):
        pulumi.set(self, "run", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Resource id of the `Target`.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Unique identifier of the `Target`.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Most recent time at which the `Target` was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:clouddeploy/target:Target")
class Target(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 anthos_cluster: Optional[pulumi.Input[Union['TargetAnthosClusterArgs', 'TargetAnthosClusterArgsDict']]] = None,
                 associated_entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetAssociatedEntityArgs', 'TargetAssociatedEntityArgsDict']]]]] = None,
                 custom_target: Optional[pulumi.Input[Union['TargetCustomTargetArgs', 'TargetCustomTargetArgsDict']]] = None,
                 deploy_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetExecutionConfigArgs', 'TargetExecutionConfigArgsDict']]]]] = None,
                 gke: Optional[pulumi.Input[Union['TargetGkeArgs', 'TargetGkeArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_target: Optional[pulumi.Input[Union['TargetMultiTargetArgs', 'TargetMultiTargetArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 require_approval: Optional[pulumi.Input[_builtins.bool]] = None,
                 run: Optional[pulumi.Input[Union['TargetRunArgs', 'TargetRunArgsDict']]] = None,
                 __props__=None):
        """
        The Cloud Deploy `Target` resource

        ## Example Usage

        ### Multi_target
        tests creating and updating a multi-target
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.Target("primary",
            location="us-west1",
            name="target",
            deploy_parameters={},
            description="multi-target description",
            execution_configs=[{
                "usages": [
                    "RENDER",
                    "DEPLOY",
                ],
                "execution_timeout": "3600s",
            }],
            multi_target={
                "target_ids": [
                    "1",
                    "2",
                ],
            },
            project="my-project-name",
            require_approval=False,
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Run_target
        tests creating and updating a cloud run target
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.Target("primary",
            location="us-west1",
            name="target",
            deploy_parameters={},
            description="basic description",
            execution_configs=[{
                "usages": [
                    "RENDER",
                    "DEPLOY",
                ],
                "execution_timeout": "3600s",
            }],
            project="my-project-name",
            require_approval=False,
            run={
                "location": "projects/my-project-name/locations/us-west1",
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Target
        Creates a basic Cloud Deploy target
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.Target("primary",
            location="us-west1",
            name="target",
            deploy_parameters={
                "deployParameterKey": "deployParameterValue",
            },
            description="basic description",
            gke={
                "cluster": "projects/my-project-name/locations/us-west1/clusters/example-cluster-name",
            },
            project="my-project-name",
            require_approval=False,
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```

        ## Import

        Target can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/targets/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Target can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:clouddeploy/target:Target default projects/{{project}}/locations/{{location}}/targets/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/target:Target default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/target:Target default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['TargetAnthosClusterArgs', 'TargetAnthosClusterArgsDict']] anthos_cluster: Information specifying an Anthos Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetAssociatedEntityArgs', 'TargetAssociatedEntityArgsDict']]]] associated_entities: Optional. Map of entity IDs to their associated entities. Associated entities allows specifying places other than the deployment target for specific features. For example, the Gateway API canary can be configured to deploy the HTTPRoute to a different cluster(s) than the deployment cluster using associated entities. An entity ID must consist of lower-case letters, numbers, and hyphens, start with a letter and end with a letter or a number, and have a max length of 63 characters. In other words, it must match the following regex: `^a-z?$`.
        :param pulumi.Input[Union['TargetCustomTargetArgs', 'TargetCustomTargetArgsDict']] custom_target: Optional. Information specifying a Custom Target.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] deploy_parameters: Optional. The deploy parameters to use for this target.
        :param pulumi.Input[_builtins.str] description: Optional. Description of the `Target`. Max length is 255 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetExecutionConfigArgs', 'TargetExecutionConfigArgsDict']]]] execution_configs: Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        :param pulumi.Input[Union['TargetGkeArgs', 'TargetGkeArgsDict']] gke: Information specifying a GKE Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[Union['TargetMultiTargetArgs', 'TargetMultiTargetArgsDict']] multi_target: Information specifying a multiTarget.
        :param pulumi.Input[_builtins.str] name: Name of the `Target`. Format is `a-z?`.
               
               
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[_builtins.bool] require_approval: Optional. Whether or not the `Target` requires approval.
        :param pulumi.Input[Union['TargetRunArgs', 'TargetRunArgsDict']] run: Information specifying a Cloud Run deployment target.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Cloud Deploy `Target` resource

        ## Example Usage

        ### Multi_target
        tests creating and updating a multi-target
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.Target("primary",
            location="us-west1",
            name="target",
            deploy_parameters={},
            description="multi-target description",
            execution_configs=[{
                "usages": [
                    "RENDER",
                    "DEPLOY",
                ],
                "execution_timeout": "3600s",
            }],
            multi_target={
                "target_ids": [
                    "1",
                    "2",
                ],
            },
            project="my-project-name",
            require_approval=False,
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Run_target
        tests creating and updating a cloud run target
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.Target("primary",
            location="us-west1",
            name="target",
            deploy_parameters={},
            description="basic description",
            execution_configs=[{
                "usages": [
                    "RENDER",
                    "DEPLOY",
                ],
                "execution_timeout": "3600s",
            }],
            project="my-project-name",
            require_approval=False,
            run={
                "location": "projects/my-project-name/locations/us-west1",
            },
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```
        ### Target
        Creates a basic Cloud Deploy target
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.Target("primary",
            location="us-west1",
            name="target",
            deploy_parameters={
                "deployParameterKey": "deployParameterValue",
            },
            description="basic description",
            gke={
                "cluster": "projects/my-project-name/locations/us-west1/clusters/example-cluster-name",
            },
            project="my-project-name",
            require_approval=False,
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            })
        ```

        ## Import

        Target can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/targets/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Target can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:clouddeploy/target:Target default projects/{{project}}/locations/{{location}}/targets/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/target:Target default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/target:Target default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 anthos_cluster: Optional[pulumi.Input[Union['TargetAnthosClusterArgs', 'TargetAnthosClusterArgsDict']]] = None,
                 associated_entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetAssociatedEntityArgs', 'TargetAssociatedEntityArgsDict']]]]] = None,
                 custom_target: Optional[pulumi.Input[Union['TargetCustomTargetArgs', 'TargetCustomTargetArgsDict']]] = None,
                 deploy_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetExecutionConfigArgs', 'TargetExecutionConfigArgsDict']]]]] = None,
                 gke: Optional[pulumi.Input[Union['TargetGkeArgs', 'TargetGkeArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_target: Optional[pulumi.Input[Union['TargetMultiTargetArgs', 'TargetMultiTargetArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 require_approval: Optional[pulumi.Input[_builtins.bool]] = None,
                 run: Optional[pulumi.Input[Union['TargetRunArgs', 'TargetRunArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetArgs.__new__(TargetArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["anthos_cluster"] = anthos_cluster
            __props__.__dict__["associated_entities"] = associated_entities
            __props__.__dict__["custom_target"] = custom_target
            __props__.__dict__["deploy_parameters"] = deploy_parameters
            __props__.__dict__["description"] = description
            __props__.__dict__["execution_configs"] = execution_configs
            __props__.__dict__["gke"] = gke
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["multi_target"] = multi_target
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["require_approval"] = require_approval
            __props__.__dict__["run"] = run
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["target_id"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Target, __self__).__init__(
            'gcp:clouddeploy/target:Target',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            anthos_cluster: Optional[pulumi.Input[Union['TargetAnthosClusterArgs', 'TargetAnthosClusterArgsDict']]] = None,
            associated_entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetAssociatedEntityArgs', 'TargetAssociatedEntityArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            custom_target: Optional[pulumi.Input[Union['TargetCustomTargetArgs', 'TargetCustomTargetArgsDict']]] = None,
            deploy_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            execution_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetExecutionConfigArgs', 'TargetExecutionConfigArgsDict']]]]] = None,
            gke: Optional[pulumi.Input[Union['TargetGkeArgs', 'TargetGkeArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            multi_target: Optional[pulumi.Input[Union['TargetMultiTargetArgs', 'TargetMultiTargetArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            require_approval: Optional[pulumi.Input[_builtins.bool]] = None,
            run: Optional[pulumi.Input[Union['TargetRunArgs', 'TargetRunArgsDict']]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Target':
        """
        Get an existing Target resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['TargetAnthosClusterArgs', 'TargetAnthosClusterArgsDict']] anthos_cluster: Information specifying an Anthos Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetAssociatedEntityArgs', 'TargetAssociatedEntityArgsDict']]]] associated_entities: Optional. Map of entity IDs to their associated entities. Associated entities allows specifying places other than the deployment target for specific features. For example, the Gateway API canary can be configured to deploy the HTTPRoute to a different cluster(s) than the deployment cluster using associated entities. An entity ID must consist of lower-case letters, numbers, and hyphens, start with a letter and end with a letter or a number, and have a max length of 63 characters. In other words, it must match the following regex: `^a-z?$`.
        :param pulumi.Input[_builtins.str] create_time: Output only. Time at which the `Target` was created.
        :param pulumi.Input[Union['TargetCustomTargetArgs', 'TargetCustomTargetArgsDict']] custom_target: Optional. Information specifying a Custom Target.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] deploy_parameters: Optional. The deploy parameters to use for this target.
        :param pulumi.Input[_builtins.str] description: Optional. Description of the `Target`. Max length is 255 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Optional. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetExecutionConfigArgs', 'TargetExecutionConfigArgsDict']]]] execution_configs: Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        :param pulumi.Input[Union['TargetGkeArgs', 'TargetGkeArgsDict']] gke: Information specifying a GKE Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[Union['TargetMultiTargetArgs', 'TargetMultiTargetArgsDict']] multi_target: Information specifying a multiTarget.
        :param pulumi.Input[_builtins.str] name: Name of the `Target`. Format is `a-z?`.
               
               
               
               - - -
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] require_approval: Optional. Whether or not the `Target` requires approval.
        :param pulumi.Input[Union['TargetRunArgs', 'TargetRunArgsDict']] run: Information specifying a Cloud Run deployment target.
        :param pulumi.Input[_builtins.str] target_id: Output only. Resource id of the `Target`.
        :param pulumi.Input[_builtins.str] uid: Output only. Unique identifier of the `Target`.
        :param pulumi.Input[_builtins.str] update_time: Output only. Most recent time at which the `Target` was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetState.__new__(_TargetState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["anthos_cluster"] = anthos_cluster
        __props__.__dict__["associated_entities"] = associated_entities
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_target"] = custom_target
        __props__.__dict__["deploy_parameters"] = deploy_parameters
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["execution_configs"] = execution_configs
        __props__.__dict__["gke"] = gke
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["multi_target"] = multi_target
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["require_approval"] = require_approval
        __props__.__dict__["run"] = run
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Target(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="anthosCluster")
    def anthos_cluster(self) -> pulumi.Output[Optional['outputs.TargetAnthosCluster']]:
        """
        Information specifying an Anthos Cluster.
        """
        return pulumi.get(self, "anthos_cluster")

    @_builtins.property
    @pulumi.getter(name="associatedEntities")
    def associated_entities(self) -> pulumi.Output[Optional[Sequence['outputs.TargetAssociatedEntity']]]:
        """
        Optional. Map of entity IDs to their associated entities. Associated entities allows specifying places other than the deployment target for specific features. For example, the Gateway API canary can be configured to deploy the HTTPRoute to a different cluster(s) than the deployment cluster using associated entities. An entity ID must consist of lower-case letters, numbers, and hyphens, start with a letter and end with a letter or a number, and have a max length of 63 characters. In other words, it must match the following regex: `^a-z?$`.
        """
        return pulumi.get(self, "associated_entities")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Time at which the `Target` was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customTarget")
    def custom_target(self) -> pulumi.Output[Optional['outputs.TargetCustomTarget']]:
        """
        Optional. Information specifying a Custom Target.
        """
        return pulumi.get(self, "custom_target")

    @_builtins.property
    @pulumi.getter(name="deployParameters")
    def deploy_parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. The deploy parameters to use for this target.
        """
        return pulumi.get(self, "deploy_parameters")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. Description of the `Target`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="executionConfigs")
    def execution_configs(self) -> pulumi.Output[Sequence['outputs.TargetExecutionConfig']]:
        """
        Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        """
        return pulumi.get(self, "execution_configs")

    @_builtins.property
    @pulumi.getter
    def gke(self) -> pulumi.Output[Optional['outputs.TargetGke']]:
        """
        Information specifying a GKE Cluster.
        """
        return pulumi.get(self, "gke")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="multiTarget")
    def multi_target(self) -> pulumi.Output[Optional['outputs.TargetMultiTarget']]:
        """
        Information specifying a multiTarget.
        """
        return pulumi.get(self, "multi_target")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the `Target`. Format is `a-z?`.



        - - -
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="requireApproval")
    def require_approval(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Optional. Whether or not the `Target` requires approval.
        """
        return pulumi.get(self, "require_approval")

    @_builtins.property
    @pulumi.getter
    def run(self) -> pulumi.Output[Optional['outputs.TargetRun']]:
        """
        Information specifying a Cloud Run deployment target.
        """
        return pulumi.get(self, "run")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Resource id of the `Target`.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Unique identifier of the `Target`.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Most recent time at which the `Target` was updated.
        """
        return pulumi.get(self, "update_time")

