# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'EnvironmentConfig',
    'EnvironmentConfigDataRetentionConfig',
    'EnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfig',
    'EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig',
    'EnvironmentConfigDatabaseConfig',
    'EnvironmentConfigEncryptionConfig',
    'EnvironmentConfigMaintenanceWindow',
    'EnvironmentConfigMasterAuthorizedNetworksConfig',
    'EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlock',
    'EnvironmentConfigNodeConfig',
    'EnvironmentConfigNodeConfigIpAllocationPolicy',
    'EnvironmentConfigPrivateEnvironmentConfig',
    'EnvironmentConfigRecoveryConfig',
    'EnvironmentConfigRecoveryConfigScheduledSnapshotsConfig',
    'EnvironmentConfigSoftwareConfig',
    'EnvironmentConfigSoftwareConfigCloudDataLineageIntegration',
    'EnvironmentConfigWebServerConfig',
    'EnvironmentConfigWebServerNetworkAccessControl',
    'EnvironmentConfigWebServerNetworkAccessControlAllowedIpRange',
    'EnvironmentConfigWorkloadsConfig',
    'EnvironmentConfigWorkloadsConfigDagProcessor',
    'EnvironmentConfigWorkloadsConfigScheduler',
    'EnvironmentConfigWorkloadsConfigTriggerer',
    'EnvironmentConfigWorkloadsConfigWebServer',
    'EnvironmentConfigWorkloadsConfigWorker',
    'EnvironmentStorageConfig',
    'GetEnvironmentConfigResult',
    'GetEnvironmentConfigDataRetentionConfigResult',
    'GetEnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfigResult',
    'GetEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigResult',
    'GetEnvironmentConfigDatabaseConfigResult',
    'GetEnvironmentConfigEncryptionConfigResult',
    'GetEnvironmentConfigMaintenanceWindowResult',
    'GetEnvironmentConfigMasterAuthorizedNetworksConfigResult',
    'GetEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockResult',
    'GetEnvironmentConfigNodeConfigResult',
    'GetEnvironmentConfigNodeConfigIpAllocationPolicyResult',
    'GetEnvironmentConfigPrivateEnvironmentConfigResult',
    'GetEnvironmentConfigRecoveryConfigResult',
    'GetEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigResult',
    'GetEnvironmentConfigSoftwareConfigResult',
    'GetEnvironmentConfigSoftwareConfigCloudDataLineageIntegrationResult',
    'GetEnvironmentConfigWebServerConfigResult',
    'GetEnvironmentConfigWebServerNetworkAccessControlResult',
    'GetEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeResult',
    'GetEnvironmentConfigWorkloadsConfigResult',
    'GetEnvironmentConfigWorkloadsConfigDagProcessorResult',
    'GetEnvironmentConfigWorkloadsConfigSchedulerResult',
    'GetEnvironmentConfigWorkloadsConfigTriggererResult',
    'GetEnvironmentConfigWorkloadsConfigWebServerResult',
    'GetEnvironmentConfigWorkloadsConfigWorkerResult',
    'GetEnvironmentStorageConfigResult',
    'GetImageVersionsImageVersionResult',
]

@pulumi.output_type
class EnvironmentConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "airflowUri":
            suggest = "airflow_uri"
        elif key == "dagGcsPrefix":
            suggest = "dag_gcs_prefix"
        elif key == "dataRetentionConfig":
            suggest = "data_retention_config"
        elif key == "databaseConfig":
            suggest = "database_config"
        elif key == "enablePrivateBuildsOnly":
            suggest = "enable_private_builds_only"
        elif key == "enablePrivateEnvironment":
            suggest = "enable_private_environment"
        elif key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "environmentSize":
            suggest = "environment_size"
        elif key == "gkeCluster":
            suggest = "gke_cluster"
        elif key == "maintenanceWindow":
            suggest = "maintenance_window"
        elif key == "masterAuthorizedNetworksConfig":
            suggest = "master_authorized_networks_config"
        elif key == "nodeConfig":
            suggest = "node_config"
        elif key == "nodeCount":
            suggest = "node_count"
        elif key == "privateEnvironmentConfig":
            suggest = "private_environment_config"
        elif key == "recoveryConfig":
            suggest = "recovery_config"
        elif key == "resilienceMode":
            suggest = "resilience_mode"
        elif key == "softwareConfig":
            suggest = "software_config"
        elif key == "webServerConfig":
            suggest = "web_server_config"
        elif key == "webServerNetworkAccessControl":
            suggest = "web_server_network_access_control"
        elif key == "workloadsConfig":
            suggest = "workloads_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 airflow_uri: Optional[_builtins.str] = None,
                 dag_gcs_prefix: Optional[_builtins.str] = None,
                 data_retention_config: Optional['outputs.EnvironmentConfigDataRetentionConfig'] = None,
                 database_config: Optional['outputs.EnvironmentConfigDatabaseConfig'] = None,
                 enable_private_builds_only: Optional[_builtins.bool] = None,
                 enable_private_environment: Optional[_builtins.bool] = None,
                 encryption_config: Optional['outputs.EnvironmentConfigEncryptionConfig'] = None,
                 environment_size: Optional[_builtins.str] = None,
                 gke_cluster: Optional[_builtins.str] = None,
                 maintenance_window: Optional['outputs.EnvironmentConfigMaintenanceWindow'] = None,
                 master_authorized_networks_config: Optional['outputs.EnvironmentConfigMasterAuthorizedNetworksConfig'] = None,
                 node_config: Optional['outputs.EnvironmentConfigNodeConfig'] = None,
                 node_count: Optional[_builtins.int] = None,
                 private_environment_config: Optional['outputs.EnvironmentConfigPrivateEnvironmentConfig'] = None,
                 recovery_config: Optional['outputs.EnvironmentConfigRecoveryConfig'] = None,
                 resilience_mode: Optional[_builtins.str] = None,
                 software_config: Optional['outputs.EnvironmentConfigSoftwareConfig'] = None,
                 web_server_config: Optional['outputs.EnvironmentConfigWebServerConfig'] = None,
                 web_server_network_access_control: Optional['outputs.EnvironmentConfigWebServerNetworkAccessControl'] = None,
                 workloads_config: Optional['outputs.EnvironmentConfigWorkloadsConfig'] = None):
        """
        :param _builtins.str airflow_uri: The URI of the Apache Airflow Web UI hosted within this
               environment.
        :param _builtins.str dag_gcs_prefix: The Cloud Storage prefix of the DAGs for this environment.
               Although Cloud Storage objects reside in a flat namespace, a
               hierarchical file tree can be simulated using '/'-delimited
               object name prefixes. DAG objects for this environment
               reside in a simulated directory with this prefix.
        :param 'EnvironmentConfigDataRetentionConfigArgs' data_retention_config: The configuration setting for Airflow data retention mechanism. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4. or newer
        :param 'EnvironmentConfigDatabaseConfigArgs' database_config: The configuration of Cloud SQL instance that is used by the Apache Airflow software. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.bool enable_private_builds_only: Optional. If true, builds performed during operations that install Python packages have only private connectivity to Google services. If false, the builds also have access to the internet.
        :param _builtins.bool enable_private_environment: Optional. If true, a private Composer environment will be created.
        :param 'EnvironmentConfigEncryptionConfigArgs' encryption_config: The encryption options for the Composer environment and its dependencies.
        :param _builtins.str environment_size: The size of the Cloud Composer environment. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param _builtins.str gke_cluster: The Kubernetes Engine cluster used to run this environment.
        :param 'EnvironmentConfigMaintenanceWindowArgs' maintenance_window: The configuration for Cloud Composer maintenance window.
        :param 'EnvironmentConfigMasterAuthorizedNetworksConfigArgs' master_authorized_networks_config: Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
        :param 'EnvironmentConfigNodeConfigArgs' node_config: The configuration used for the Kubernetes Engine cluster.
        :param _builtins.int node_count: The number of nodes in the Kubernetes Engine cluster that will be used to run this environment. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param 'EnvironmentConfigPrivateEnvironmentConfigArgs' private_environment_config: The configuration used for the Private IP Cloud Composer environment.
        :param 'EnvironmentConfigRecoveryConfigArgs' recovery_config: The recovery configuration settings for the Cloud Composer environment
        :param _builtins.str resilience_mode: Whether high resilience is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.1.15-airflow-*.*.* and newer.
        :param 'EnvironmentConfigSoftwareConfigArgs' software_config: The configuration settings for software inside the environment.
        :param 'EnvironmentConfigWebServerConfigArgs' web_server_config: The configuration settings for the Airflow web server App Engine instance. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param 'EnvironmentConfigWebServerNetworkAccessControlArgs' web_server_network_access_control: Network-level access control policy for the Airflow web server.
        :param 'EnvironmentConfigWorkloadsConfigArgs' workloads_config: The workloads configuration settings for the GKE cluster associated with the Cloud Composer environment. Supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        if airflow_uri is not None:
            pulumi.set(__self__, "airflow_uri", airflow_uri)
        if dag_gcs_prefix is not None:
            pulumi.set(__self__, "dag_gcs_prefix", dag_gcs_prefix)
        if data_retention_config is not None:
            pulumi.set(__self__, "data_retention_config", data_retention_config)
        if database_config is not None:
            pulumi.set(__self__, "database_config", database_config)
        if enable_private_builds_only is not None:
            pulumi.set(__self__, "enable_private_builds_only", enable_private_builds_only)
        if enable_private_environment is not None:
            pulumi.set(__self__, "enable_private_environment", enable_private_environment)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if environment_size is not None:
            pulumi.set(__self__, "environment_size", environment_size)
        if gke_cluster is not None:
            pulumi.set(__self__, "gke_cluster", gke_cluster)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if master_authorized_networks_config is not None:
            pulumi.set(__self__, "master_authorized_networks_config", master_authorized_networks_config)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if private_environment_config is not None:
            pulumi.set(__self__, "private_environment_config", private_environment_config)
        if recovery_config is not None:
            pulumi.set(__self__, "recovery_config", recovery_config)
        if resilience_mode is not None:
            pulumi.set(__self__, "resilience_mode", resilience_mode)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if web_server_config is not None:
            pulumi.set(__self__, "web_server_config", web_server_config)
        if web_server_network_access_control is not None:
            pulumi.set(__self__, "web_server_network_access_control", web_server_network_access_control)
        if workloads_config is not None:
            pulumi.set(__self__, "workloads_config", workloads_config)

    @_builtins.property
    @pulumi.getter(name="airflowUri")
    def airflow_uri(self) -> Optional[_builtins.str]:
        """
        The URI of the Apache Airflow Web UI hosted within this
        environment.
        """
        return pulumi.get(self, "airflow_uri")

    @_builtins.property
    @pulumi.getter(name="dagGcsPrefix")
    def dag_gcs_prefix(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage prefix of the DAGs for this environment.
        Although Cloud Storage objects reside in a flat namespace, a
        hierarchical file tree can be simulated using '/'-delimited
        object name prefixes. DAG objects for this environment
        reside in a simulated directory with this prefix.
        """
        return pulumi.get(self, "dag_gcs_prefix")

    @_builtins.property
    @pulumi.getter(name="dataRetentionConfig")
    def data_retention_config(self) -> Optional['outputs.EnvironmentConfigDataRetentionConfig']:
        """
        The configuration setting for Airflow data retention mechanism. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4. or newer
        """
        return pulumi.get(self, "data_retention_config")

    @_builtins.property
    @pulumi.getter(name="databaseConfig")
    def database_config(self) -> Optional['outputs.EnvironmentConfigDatabaseConfig']:
        """
        The configuration of Cloud SQL instance that is used by the Apache Airflow software. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "database_config")

    @_builtins.property
    @pulumi.getter(name="enablePrivateBuildsOnly")
    def enable_private_builds_only(self) -> Optional[_builtins.bool]:
        """
        Optional. If true, builds performed during operations that install Python packages have only private connectivity to Google services. If false, the builds also have access to the internet.
        """
        return pulumi.get(self, "enable_private_builds_only")

    @_builtins.property
    @pulumi.getter(name="enablePrivateEnvironment")
    def enable_private_environment(self) -> Optional[_builtins.bool]:
        """
        Optional. If true, a private Composer environment will be created.
        """
        return pulumi.get(self, "enable_private_environment")

    @_builtins.property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.EnvironmentConfigEncryptionConfig']:
        """
        The encryption options for the Composer environment and its dependencies.
        """
        return pulumi.get(self, "encryption_config")

    @_builtins.property
    @pulumi.getter(name="environmentSize")
    def environment_size(self) -> Optional[_builtins.str]:
        """
        The size of the Cloud Composer environment. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "environment_size")

    @_builtins.property
    @pulumi.getter(name="gkeCluster")
    def gke_cluster(self) -> Optional[_builtins.str]:
        """
        The Kubernetes Engine cluster used to run this environment.
        """
        return pulumi.get(self, "gke_cluster")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional['outputs.EnvironmentConfigMaintenanceWindow']:
        """
        The configuration for Cloud Composer maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="masterAuthorizedNetworksConfig")
    def master_authorized_networks_config(self) -> Optional['outputs.EnvironmentConfigMasterAuthorizedNetworksConfig']:
        """
        Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
        """
        return pulumi.get(self, "master_authorized_networks_config")

    @_builtins.property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional['outputs.EnvironmentConfigNodeConfig']:
        """
        The configuration used for the Kubernetes Engine cluster.
        """
        return pulumi.get(self, "node_config")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[_builtins.int]:
        """
        The number of nodes in the Kubernetes Engine cluster that will be used to run this environment. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="privateEnvironmentConfig")
    def private_environment_config(self) -> Optional['outputs.EnvironmentConfigPrivateEnvironmentConfig']:
        """
        The configuration used for the Private IP Cloud Composer environment.
        """
        return pulumi.get(self, "private_environment_config")

    @_builtins.property
    @pulumi.getter(name="recoveryConfig")
    def recovery_config(self) -> Optional['outputs.EnvironmentConfigRecoveryConfig']:
        """
        The recovery configuration settings for the Cloud Composer environment
        """
        return pulumi.get(self, "recovery_config")

    @_builtins.property
    @pulumi.getter(name="resilienceMode")
    def resilience_mode(self) -> Optional[_builtins.str]:
        """
        Whether high resilience is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.1.15-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "resilience_mode")

    @_builtins.property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional['outputs.EnvironmentConfigSoftwareConfig']:
        """
        The configuration settings for software inside the environment.
        """
        return pulumi.get(self, "software_config")

    @_builtins.property
    @pulumi.getter(name="webServerConfig")
    def web_server_config(self) -> Optional['outputs.EnvironmentConfigWebServerConfig']:
        """
        The configuration settings for the Airflow web server App Engine instance. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "web_server_config")

    @_builtins.property
    @pulumi.getter(name="webServerNetworkAccessControl")
    def web_server_network_access_control(self) -> Optional['outputs.EnvironmentConfigWebServerNetworkAccessControl']:
        """
        Network-level access control policy for the Airflow web server.
        """
        return pulumi.get(self, "web_server_network_access_control")

    @_builtins.property
    @pulumi.getter(name="workloadsConfig")
    def workloads_config(self) -> Optional['outputs.EnvironmentConfigWorkloadsConfig']:
        """
        The workloads configuration settings for the GKE cluster associated with the Cloud Composer environment. Supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "workloads_config")


@pulumi.output_type
class EnvironmentConfigDataRetentionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "airflowMetadataRetentionConfigs":
            suggest = "airflow_metadata_retention_configs"
        elif key == "taskLogsRetentionConfigs":
            suggest = "task_logs_retention_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigDataRetentionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigDataRetentionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigDataRetentionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 airflow_metadata_retention_configs: Optional[Sequence['outputs.EnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfig']] = None,
                 task_logs_retention_configs: Optional[Sequence['outputs.EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig']] = None):
        """
        :param Sequence['EnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfigArgs'] airflow_metadata_retention_configs: Optional. The policy for airflow metadata database retention.
        :param Sequence['EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgs'] task_logs_retention_configs: Optional. The configuration setting for Task Logs.
        """
        if airflow_metadata_retention_configs is not None:
            pulumi.set(__self__, "airflow_metadata_retention_configs", airflow_metadata_retention_configs)
        if task_logs_retention_configs is not None:
            pulumi.set(__self__, "task_logs_retention_configs", task_logs_retention_configs)

    @_builtins.property
    @pulumi.getter(name="airflowMetadataRetentionConfigs")
    def airflow_metadata_retention_configs(self) -> Optional[Sequence['outputs.EnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfig']]:
        """
        Optional. The policy for airflow metadata database retention.
        """
        return pulumi.get(self, "airflow_metadata_retention_configs")

    @_builtins.property
    @pulumi.getter(name="taskLogsRetentionConfigs")
    def task_logs_retention_configs(self) -> Optional[Sequence['outputs.EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig']]:
        """
        Optional. The configuration setting for Task Logs.
        """
        return pulumi.get(self, "task_logs_retention_configs")


@pulumi.output_type
class EnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionDays":
            suggest = "retention_days"
        elif key == "retentionMode":
            suggest = "retention_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_days: Optional[_builtins.int] = None,
                 retention_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.int retention_days: How many days data should be retained for. This field is supported for Cloud Composer environments in composer 3 and newer.
        :param _builtins.str retention_mode: Whether database retention is enabled or not. This field is supported for Cloud Composer environments in composer 3 and newer.
        """
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if retention_mode is not None:
            pulumi.set(__self__, "retention_mode", retention_mode)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[_builtins.int]:
        """
        How many days data should be retained for. This field is supported for Cloud Composer environments in composer 3 and newer.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter(name="retentionMode")
    def retention_mode(self) -> Optional[_builtins.str]:
        """
        Whether database retention is enabled or not. This field is supported for Cloud Composer environments in composer 3 and newer.
        """
        return pulumi.get(self, "retention_mode")


@pulumi.output_type
class EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageMode":
            suggest = "storage_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str storage_mode: Whether logs in cloud logging only is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4 and newer but not in composer-3*
        """
        if storage_mode is not None:
            pulumi.set(__self__, "storage_mode", storage_mode)

    @_builtins.property
    @pulumi.getter(name="storageMode")
    def storage_mode(self) -> Optional[_builtins.str]:
        """
        Whether logs in cloud logging only is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4 and newer but not in composer-3*
        """
        return pulumi.get(self, "storage_mode")


@pulumi.output_type
class EnvironmentConfigDatabaseConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineType":
            suggest = "machine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigDatabaseConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigDatabaseConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigDatabaseConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_type: Optional[_builtins.str] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str machine_type: Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        :param _builtins.str zone: Optional. Cloud SQL database preferred zone.
        """
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        Optional. Cloud SQL database preferred zone.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class EnvironmentConfigEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: _builtins.str):
        """
        :param _builtins.str kms_key_name: Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class EnvironmentConfigMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: _builtins.str,
                 recurrence: _builtins.str,
                 start_time: _builtins.str):
        """
        :param _builtins.str end_time: Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end-time must be in the future, relative to 'start_time'.
        :param _builtins.str recurrence: Maintenance window recurrence. Format is a subset of RFC-5545 (https://tools.ietf.org/html/rfc5545) 'RRULE'. The only allowed values for 'FREQ' field are 'FREQ=DAILY' and 'FREQ=WEEKLY;BYDAY=...'. Example values: 'FREQ=WEEKLY;BYDAY=TU,WE', 'FREQ=DAILY'.
        :param _builtins.str start_time: Start time of the first recurrence of the maintenance window.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "recurrence", recurrence)
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end-time must be in the future, relative to 'start_time'.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def recurrence(self) -> _builtins.str:
        """
        Maintenance window recurrence. Format is a subset of RFC-5545 (https://tools.ietf.org/html/rfc5545) 'RRULE'. The only allowed values for 'FREQ' field are 'FREQ=DAILY' and 'FREQ=WEEKLY;BYDAY=...'. Example values: 'FREQ=WEEKLY;BYDAY=TU,WE', 'FREQ=DAILY'.
        """
        return pulumi.get(self, "recurrence")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Start time of the first recurrence of the maintenance window.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class EnvironmentConfigMasterAuthorizedNetworksConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlocks":
            suggest = "cidr_blocks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigMasterAuthorizedNetworksConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigMasterAuthorizedNetworksConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigMasterAuthorizedNetworksConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 cidr_blocks: Optional[Sequence['outputs.EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlock']] = None):
        """
        :param _builtins.bool enabled: Whether or not master authorized networks is enabled.
        :param Sequence['EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgs'] cidr_blocks: cidr_blocks define up to 50 external networks that could access Kubernetes master through HTTPS.
        """
        pulumi.set(__self__, "enabled", enabled)
        if cidr_blocks is not None:
            pulumi.set(__self__, "cidr_blocks", cidr_blocks)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether or not master authorized networks is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Optional[Sequence['outputs.EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlock']]:
        """
        cidr_blocks define up to 50 external networks that could access Kubernetes master through HTTPS.
        """
        return pulumi.get(self, "cidr_blocks")


@pulumi.output_type
class EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlock":
            suggest = "cidr_block"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 display_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str cidr_block: cidr_block must be specified in CIDR notation.
        :param _builtins.str display_name: display_name is a field for users to identify CIDR blocks.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        cidr_block must be specified in CIDR notation.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        display_name is a field for users to identify CIDR blocks.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class EnvironmentConfigNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "composerInternalIpv4CidrBlock":
            suggest = "composer_internal_ipv4_cidr_block"
        elif key == "composerNetworkAttachment":
            suggest = "composer_network_attachment"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "enableIpMasqAgent":
            suggest = "enable_ip_masq_agent"
        elif key == "ipAllocationPolicy":
            suggest = "ip_allocation_policy"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "maxPodsPerNode":
            suggest = "max_pods_per_node"
        elif key == "oauthScopes":
            suggest = "oauth_scopes"
        elif key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 composer_internal_ipv4_cidr_block: Optional[_builtins.str] = None,
                 composer_network_attachment: Optional[_builtins.str] = None,
                 disk_size_gb: Optional[_builtins.int] = None,
                 enable_ip_masq_agent: Optional[_builtins.bool] = None,
                 ip_allocation_policy: Optional['outputs.EnvironmentConfigNodeConfigIpAllocationPolicy'] = None,
                 machine_type: Optional[_builtins.str] = None,
                 max_pods_per_node: Optional[_builtins.int] = None,
                 network: Optional[_builtins.str] = None,
                 oauth_scopes: Optional[Sequence[_builtins.str]] = None,
                 service_account: Optional[_builtins.str] = None,
                 subnetwork: Optional[_builtins.str] = None,
                 tags: Optional[Sequence[_builtins.str]] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str composer_internal_ipv4_cidr_block: IPv4 cidr range that will be used by Composer internal components.
        :param _builtins.str composer_network_attachment: PSC (Private Service Connect) Network entry point. Customers can pre-create the Network Attachment and point Cloud Composer environment to use. It is possible to share network attachment among many environments, provided enough IP addresses are available.
        :param _builtins.int disk_size_gb: The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.bool enable_ip_masq_agent: Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for all destination addresses, except between pods traffic. See: https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
        :param 'EnvironmentConfigNodeConfigIpAllocationPolicyArgs' ip_allocation_policy: Configuration for controlling how IPs are allocated in the GKE cluster. Cannot be updated.
        :param _builtins.str machine_type: The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.int max_pods_per_node: The maximum pods per node in the GKE cluster allocated during environment creation. Lowering this value reduces IP address consumption by the Cloud Composer Kubernetes cluster. This value can only be set during environment creation, and only if the environment is VPC-Native. The range of possible values is 8-110, and the default is 32. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.str network: The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. The network must belong to the environment's project. If unspecified, the "default" network ID in the environment's project is used. If a Custom Subnet Network is provided, subnetwork must also be provided.
        :param Sequence[_builtins.str] oauth_scopes: The set of Google API scopes to be made available on all node VMs. Cannot be updated. If empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.str service_account: The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated. If given, note that the service account must have roles/composer.worker for any GCP resources created under the Cloud Composer Environment.
        :param _builtins.str subnetwork: The Compute Engine subnetwork to be used for machine communications, specified as a self-link, relative resource name (e.g. "projects/{project}/regions/{region}/subnetworks/{subnetwork}"), or by name. If subnetwork is provided, network must also be provided and the subnetwork must belong to the enclosing environment's project and region.
        :param Sequence[_builtins.str] tags: The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with RFC1035. Cannot be updated.
        :param _builtins.str zone: The Compute Engine zone in which to deploy the VMs running the Apache Airflow software, specified as the zone name or relative resource name (e.g. "projects/{project}/zones/{zone}"). Must belong to the enclosing environment's project and region. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        if composer_internal_ipv4_cidr_block is not None:
            pulumi.set(__self__, "composer_internal_ipv4_cidr_block", composer_internal_ipv4_cidr_block)
        if composer_network_attachment is not None:
            pulumi.set(__self__, "composer_network_attachment", composer_network_attachment)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if enable_ip_masq_agent is not None:
            pulumi.set(__self__, "enable_ip_masq_agent", enable_ip_masq_agent)
        if ip_allocation_policy is not None:
            pulumi.set(__self__, "ip_allocation_policy", ip_allocation_policy)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="composerInternalIpv4CidrBlock")
    def composer_internal_ipv4_cidr_block(self) -> Optional[_builtins.str]:
        """
        IPv4 cidr range that will be used by Composer internal components.
        """
        return pulumi.get(self, "composer_internal_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="composerNetworkAttachment")
    def composer_network_attachment(self) -> Optional[_builtins.str]:
        """
        PSC (Private Service Connect) Network entry point. Customers can pre-create the Network Attachment and point Cloud Composer environment to use. It is possible to share network attachment among many environments, provided enough IP addresses are available.
        """
        return pulumi.get(self, "composer_network_attachment")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="enableIpMasqAgent")
    def enable_ip_masq_agent(self) -> Optional[_builtins.bool]:
        """
        Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for all destination addresses, except between pods traffic. See: https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
        """
        return pulumi.get(self, "enable_ip_masq_agent")

    @_builtins.property
    @pulumi.getter(name="ipAllocationPolicy")
    def ip_allocation_policy(self) -> Optional['outputs.EnvironmentConfigNodeConfigIpAllocationPolicy']:
        """
        Configuration for controlling how IPs are allocated in the GKE cluster. Cannot be updated.
        """
        return pulumi.get(self, "ip_allocation_policy")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[_builtins.int]:
        """
        The maximum pods per node in the GKE cluster allocated during environment creation. Lowering this value reduces IP address consumption by the Cloud Composer Kubernetes cluster. This value can only be set during environment creation, and only if the environment is VPC-Native. The range of possible values is 8-110, and the default is 32. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "max_pods_per_node")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. The network must belong to the environment's project. If unspecified, the "default" network ID in the environment's project is used. If a Custom Subnet Network is provided, subnetwork must also be provided.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[Sequence[_builtins.str]]:
        """
        The set of Google API scopes to be made available on all node VMs. Cannot be updated. If empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "oauth_scopes")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated. If given, note that the service account must have roles/composer.worker for any GCP resources created under the Cloud Composer Environment.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[_builtins.str]:
        """
        The Compute Engine subnetwork to be used for machine communications, specified as a self-link, relative resource name (e.g. "projects/{project}/regions/{region}/subnetworks/{subnetwork}"), or by name. If subnetwork is provided, network must also be provided and the subnetwork must belong to the enclosing environment's project and region.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with RFC1035. Cannot be updated.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        The Compute Engine zone in which to deploy the VMs running the Apache Airflow software, specified as the zone name or relative resource name (e.g. "projects/{project}/zones/{zone}"). Must belong to the enclosing environment's project and region. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class EnvironmentConfigNodeConfigIpAllocationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterIpv4CidrBlock":
            suggest = "cluster_ipv4_cidr_block"
        elif key == "clusterSecondaryRangeName":
            suggest = "cluster_secondary_range_name"
        elif key == "servicesIpv4CidrBlock":
            suggest = "services_ipv4_cidr_block"
        elif key == "servicesSecondaryRangeName":
            suggest = "services_secondary_range_name"
        elif key == "useIpAliases":
            suggest = "use_ip_aliases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigNodeConfigIpAllocationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigNodeConfigIpAllocationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigNodeConfigIpAllocationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_ipv4_cidr_block: Optional[_builtins.str] = None,
                 cluster_secondary_range_name: Optional[_builtins.str] = None,
                 services_ipv4_cidr_block: Optional[_builtins.str] = None,
                 services_secondary_range_name: Optional[_builtins.str] = None,
                 use_ip_aliases: Optional[_builtins.bool] = None):
        """
        :param _builtins.str cluster_ipv4_cidr_block: The IP address range used to allocate IP addresses to pods in the cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both.
        :param _builtins.str cluster_secondary_range_name: The name of the cluster's secondary range used to allocate IP addresses to pods. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        :param _builtins.str services_ipv4_cidr_block: The IP address range used to allocate IP addresses in this cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both.
        :param _builtins.str services_secondary_range_name: The name of the services' secondary range used to allocate IP addresses to the cluster. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        :param _builtins.bool use_ip_aliases: Whether or not to enable Alias IPs in the GKE cluster. If true, a VPC-native cluster is created. Defaults to true if the ip_allocation_policy block is present in config. This field is only supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use VPC-native GKE clusters.
        """
        if cluster_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cluster_ipv4_cidr_block", cluster_ipv4_cidr_block)
        if cluster_secondary_range_name is not None:
            pulumi.set(__self__, "cluster_secondary_range_name", cluster_secondary_range_name)
        if services_ipv4_cidr_block is not None:
            pulumi.set(__self__, "services_ipv4_cidr_block", services_ipv4_cidr_block)
        if services_secondary_range_name is not None:
            pulumi.set(__self__, "services_secondary_range_name", services_secondary_range_name)
        if use_ip_aliases is not None:
            pulumi.set(__self__, "use_ip_aliases", use_ip_aliases)

    @_builtins.property
    @pulumi.getter(name="clusterIpv4CidrBlock")
    def cluster_ipv4_cidr_block(self) -> Optional[_builtins.str]:
        """
        The IP address range used to allocate IP addresses to pods in the cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="clusterSecondaryRangeName")
    def cluster_secondary_range_name(self) -> Optional[_builtins.str]:
        """
        The name of the cluster's secondary range used to allocate IP addresses to pods. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        """
        return pulumi.get(self, "cluster_secondary_range_name")

    @_builtins.property
    @pulumi.getter(name="servicesIpv4CidrBlock")
    def services_ipv4_cidr_block(self) -> Optional[_builtins.str]:
        """
        The IP address range used to allocate IP addresses in this cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both.
        """
        return pulumi.get(self, "services_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="servicesSecondaryRangeName")
    def services_secondary_range_name(self) -> Optional[_builtins.str]:
        """
        The name of the services' secondary range used to allocate IP addresses to the cluster. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        """
        return pulumi.get(self, "services_secondary_range_name")

    @_builtins.property
    @pulumi.getter(name="useIpAliases")
    def use_ip_aliases(self) -> Optional[_builtins.bool]:
        """
        Whether or not to enable Alias IPs in the GKE cluster. If true, a VPC-native cluster is created. Defaults to true if the ip_allocation_policy block is present in config. This field is only supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use VPC-native GKE clusters.
        """
        return pulumi.get(self, "use_ip_aliases")


@pulumi.output_type
class EnvironmentConfigPrivateEnvironmentConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudComposerConnectionSubnetwork":
            suggest = "cloud_composer_connection_subnetwork"
        elif key == "cloudComposerNetworkIpv4CidrBlock":
            suggest = "cloud_composer_network_ipv4_cidr_block"
        elif key == "cloudSqlIpv4CidrBlock":
            suggest = "cloud_sql_ipv4_cidr_block"
        elif key == "connectionType":
            suggest = "connection_type"
        elif key == "enablePrivateEndpoint":
            suggest = "enable_private_endpoint"
        elif key == "enablePrivatelyUsedPublicIps":
            suggest = "enable_privately_used_public_ips"
        elif key == "masterIpv4CidrBlock":
            suggest = "master_ipv4_cidr_block"
        elif key == "webServerIpv4CidrBlock":
            suggest = "web_server_ipv4_cidr_block"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigPrivateEnvironmentConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigPrivateEnvironmentConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigPrivateEnvironmentConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_composer_connection_subnetwork: Optional[_builtins.str] = None,
                 cloud_composer_network_ipv4_cidr_block: Optional[_builtins.str] = None,
                 cloud_sql_ipv4_cidr_block: Optional[_builtins.str] = None,
                 connection_type: Optional[_builtins.str] = None,
                 enable_private_endpoint: Optional[_builtins.bool] = None,
                 enable_privately_used_public_ips: Optional[_builtins.bool] = None,
                 master_ipv4_cidr_block: Optional[_builtins.str] = None,
                 web_server_ipv4_cidr_block: Optional[_builtins.str] = None):
        """
        :param _builtins.str cloud_composer_connection_subnetwork: When specified, the environment will use Private Service Connect instead of VPC peerings to connect to Cloud SQL in the Tenant Project, and the PSC endpoint in the Customer Project will use an IP address from this subnetwork. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param _builtins.str cloud_composer_network_ipv4_cidr_block: The CIDR block from which IP range for Cloud Composer Network in tenant project will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param _builtins.str cloud_sql_ipv4_cidr_block: The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block.
        :param _builtins.str connection_type: Mode of internal communication within the Composer environment. Must be one of "VPC_PEERING" or "PRIVATE_SERVICE_CONNECT".
        :param _builtins.bool enable_private_endpoint: If true, access to the public endpoint of the GKE cluster is denied. If this field is set to true, ip_allocation_policy.use_ip_aliases must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.bool enable_privately_used_public_ips: When enabled, IPs from public (non-RFC1918) ranges can be used for ip_allocation_policy.cluster_ipv4_cidr_block and ip_allocation_policy.service_ipv4_cidr_block.
        :param _builtins.str master_ipv4_cidr_block: The IP range in CIDR notation to use for the hosted master network. This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network. If left blank, the default value of '172.16.0.0/28' is used.
        :param _builtins.str web_server_ipv4_cidr_block: The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        if cloud_composer_connection_subnetwork is not None:
            pulumi.set(__self__, "cloud_composer_connection_subnetwork", cloud_composer_connection_subnetwork)
        if cloud_composer_network_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cloud_composer_network_ipv4_cidr_block", cloud_composer_network_ipv4_cidr_block)
        if cloud_sql_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cloud_sql_ipv4_cidr_block", cloud_sql_ipv4_cidr_block)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if enable_private_endpoint is not None:
            pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        if enable_privately_used_public_ips is not None:
            pulumi.set(__self__, "enable_privately_used_public_ips", enable_privately_used_public_ips)
        if master_ipv4_cidr_block is not None:
            pulumi.set(__self__, "master_ipv4_cidr_block", master_ipv4_cidr_block)
        if web_server_ipv4_cidr_block is not None:
            pulumi.set(__self__, "web_server_ipv4_cidr_block", web_server_ipv4_cidr_block)

    @_builtins.property
    @pulumi.getter(name="cloudComposerConnectionSubnetwork")
    def cloud_composer_connection_subnetwork(self) -> Optional[_builtins.str]:
        """
        When specified, the environment will use Private Service Connect instead of VPC peerings to connect to Cloud SQL in the Tenant Project, and the PSC endpoint in the Customer Project will use an IP address from this subnetwork. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "cloud_composer_connection_subnetwork")

    @_builtins.property
    @pulumi.getter(name="cloudComposerNetworkIpv4CidrBlock")
    def cloud_composer_network_ipv4_cidr_block(self) -> Optional[_builtins.str]:
        """
        The CIDR block from which IP range for Cloud Composer Network in tenant project will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "cloud_composer_network_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="cloudSqlIpv4CidrBlock")
    def cloud_sql_ipv4_cidr_block(self) -> Optional[_builtins.str]:
        """
        The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block.
        """
        return pulumi.get(self, "cloud_sql_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[_builtins.str]:
        """
        Mode of internal communication within the Composer environment. Must be one of "VPC_PEERING" or "PRIVATE_SERVICE_CONNECT".
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> Optional[_builtins.bool]:
        """
        If true, access to the public endpoint of the GKE cluster is denied. If this field is set to true, ip_allocation_policy.use_ip_aliases must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @_builtins.property
    @pulumi.getter(name="enablePrivatelyUsedPublicIps")
    def enable_privately_used_public_ips(self) -> Optional[_builtins.bool]:
        """
        When enabled, IPs from public (non-RFC1918) ranges can be used for ip_allocation_policy.cluster_ipv4_cidr_block and ip_allocation_policy.service_ipv4_cidr_block.
        """
        return pulumi.get(self, "enable_privately_used_public_ips")

    @_builtins.property
    @pulumi.getter(name="masterIpv4CidrBlock")
    def master_ipv4_cidr_block(self) -> Optional[_builtins.str]:
        """
        The IP range in CIDR notation to use for the hosted master network. This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network. If left blank, the default value of '172.16.0.0/28' is used.
        """
        return pulumi.get(self, "master_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="webServerIpv4CidrBlock")
    def web_server_ipv4_cidr_block(self) -> Optional[_builtins.str]:
        """
        The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "web_server_ipv4_cidr_block")


@pulumi.output_type
class EnvironmentConfigRecoveryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduledSnapshotsConfig":
            suggest = "scheduled_snapshots_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigRecoveryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigRecoveryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigRecoveryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scheduled_snapshots_config: Optional['outputs.EnvironmentConfigRecoveryConfigScheduledSnapshotsConfig'] = None):
        """
        :param 'EnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgs' scheduled_snapshots_config: The configuration settings for scheduled snapshots.
        """
        if scheduled_snapshots_config is not None:
            pulumi.set(__self__, "scheduled_snapshots_config", scheduled_snapshots_config)

    @_builtins.property
    @pulumi.getter(name="scheduledSnapshotsConfig")
    def scheduled_snapshots_config(self) -> Optional['outputs.EnvironmentConfigRecoveryConfigScheduledSnapshotsConfig']:
        """
        The configuration settings for scheduled snapshots.
        """
        return pulumi.get(self, "scheduled_snapshots_config")


@pulumi.output_type
class EnvironmentConfigRecoveryConfigScheduledSnapshotsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotCreationSchedule":
            suggest = "snapshot_creation_schedule"
        elif key == "snapshotLocation":
            suggest = "snapshot_location"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigRecoveryConfigScheduledSnapshotsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigRecoveryConfigScheduledSnapshotsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigRecoveryConfigScheduledSnapshotsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 snapshot_creation_schedule: Optional[_builtins.str] = None,
                 snapshot_location: Optional[_builtins.str] = None,
                 time_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: When enabled, Cloud Composer periodically saves snapshots of your environment to a Cloud Storage bucket.
        :param _builtins.str snapshot_creation_schedule: Snapshot schedule, in the unix-cron format.
        :param _builtins.str snapshot_location: the URI of a bucket folder where to save the snapshot.
        :param _builtins.str time_zone: A time zone for the schedule. This value is a time offset and does not take into account daylight saving time changes. Valid values are from UTC-12 to UTC+12. Examples: UTC, UTC-01, UTC+03.
        """
        pulumi.set(__self__, "enabled", enabled)
        if snapshot_creation_schedule is not None:
            pulumi.set(__self__, "snapshot_creation_schedule", snapshot_creation_schedule)
        if snapshot_location is not None:
            pulumi.set(__self__, "snapshot_location", snapshot_location)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        When enabled, Cloud Composer periodically saves snapshots of your environment to a Cloud Storage bucket.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="snapshotCreationSchedule")
    def snapshot_creation_schedule(self) -> Optional[_builtins.str]:
        """
        Snapshot schedule, in the unix-cron format.
        """
        return pulumi.get(self, "snapshot_creation_schedule")

    @_builtins.property
    @pulumi.getter(name="snapshotLocation")
    def snapshot_location(self) -> Optional[_builtins.str]:
        """
        the URI of a bucket folder where to save the snapshot.
        """
        return pulumi.get(self, "snapshot_location")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        A time zone for the schedule. This value is a time offset and does not take into account daylight saving time changes. Valid values are from UTC-12 to UTC+12. Examples: UTC, UTC-01, UTC+03.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class EnvironmentConfigSoftwareConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "airflowConfigOverrides":
            suggest = "airflow_config_overrides"
        elif key == "cloudDataLineageIntegration":
            suggest = "cloud_data_lineage_integration"
        elif key == "envVariables":
            suggest = "env_variables"
        elif key == "imageVersion":
            suggest = "image_version"
        elif key == "pypiPackages":
            suggest = "pypi_packages"
        elif key == "pythonVersion":
            suggest = "python_version"
        elif key == "schedulerCount":
            suggest = "scheduler_count"
        elif key == "webServerPluginsMode":
            suggest = "web_server_plugins_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigSoftwareConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigSoftwareConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigSoftwareConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 airflow_config_overrides: Optional[Mapping[str, _builtins.str]] = None,
                 cloud_data_lineage_integration: Optional['outputs.EnvironmentConfigSoftwareConfigCloudDataLineageIntegration'] = None,
                 env_variables: Optional[Mapping[str, _builtins.str]] = None,
                 image_version: Optional[_builtins.str] = None,
                 pypi_packages: Optional[Mapping[str, _builtins.str]] = None,
                 python_version: Optional[_builtins.str] = None,
                 scheduler_count: Optional[_builtins.int] = None,
                 web_server_plugins_mode: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] airflow_config_overrides: Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and cannot contain "=" or ";". Section and property names cannot contain characters: "." Apache Airflow configuration property names must be written in snake_case. Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are blacklisted, and cannot be overridden.
        :param 'EnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgs' cloud_data_lineage_integration: The configuration for Cloud Data Lineage integration. Supported for Cloud Composer environments in versions composer-2.1.2-airflow-*.*.* and newer
        :param Mapping[str, _builtins.str] env_variables: Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression [a-zA-Z_][a-zA-Z0-9_]*. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+), and they cannot match any of the following reserved names: AIRFLOW_HOME C_FORCE_ROOT CONTAINER_NAME DAGS_FOLDER GCP_PROJECT GCS_BUCKET GKE_CLUSTER_NAME SQL_DATABASE SQL_INSTANCE SQL_PASSWORD SQL_PROJECT SQL_REGION SQL_USER.
        :param _builtins.str image_version: The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression composer-([0-9]+(\\.[0-9]+\\.[0-9]+(-preview\\.[0-9]+)?)?|latest)-airflow-([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?). The Cloud Composer portion of the image version is a full semantic version, or an alias in the form of major version number or 'latest'. The Apache Airflow portion of the image version is a full semantic version that points to one of the supported Apache Airflow versions, or an alias in the form of only major or major.minor versions specified. See documentation for more details and version list.
        :param Mapping[str, _builtins.str] pypi_packages: Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name (e.g. "numpy"). Values are the lowercase extras and version specifier (e.g. "==1.12.0", "[devel,gcp_api]", "[devel]>=1.8.2, <1.9.2"). To specify a package without pinning it to a version specifier, use the empty string as the value.
        :param _builtins.str python_version: The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
        :param _builtins.int scheduler_count: The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
        :param _builtins.str web_server_plugins_mode: Should be either 'ENABLED' or 'DISABLED'. Defaults to 'ENABLED'. Used in Composer 3.
        """
        if airflow_config_overrides is not None:
            pulumi.set(__self__, "airflow_config_overrides", airflow_config_overrides)
        if cloud_data_lineage_integration is not None:
            pulumi.set(__self__, "cloud_data_lineage_integration", cloud_data_lineage_integration)
        if env_variables is not None:
            pulumi.set(__self__, "env_variables", env_variables)
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if pypi_packages is not None:
            pulumi.set(__self__, "pypi_packages", pypi_packages)
        if python_version is not None:
            pulumi.set(__self__, "python_version", python_version)
        if scheduler_count is not None:
            pulumi.set(__self__, "scheduler_count", scheduler_count)
        if web_server_plugins_mode is not None:
            pulumi.set(__self__, "web_server_plugins_mode", web_server_plugins_mode)

    @_builtins.property
    @pulumi.getter(name="airflowConfigOverrides")
    def airflow_config_overrides(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and cannot contain "=" or ";". Section and property names cannot contain characters: "." Apache Airflow configuration property names must be written in snake_case. Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are blacklisted, and cannot be overridden.
        """
        return pulumi.get(self, "airflow_config_overrides")

    @_builtins.property
    @pulumi.getter(name="cloudDataLineageIntegration")
    def cloud_data_lineage_integration(self) -> Optional['outputs.EnvironmentConfigSoftwareConfigCloudDataLineageIntegration']:
        """
        The configuration for Cloud Data Lineage integration. Supported for Cloud Composer environments in versions composer-2.1.2-airflow-*.*.* and newer
        """
        return pulumi.get(self, "cloud_data_lineage_integration")

    @_builtins.property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression [a-zA-Z_][a-zA-Z0-9_]*. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+), and they cannot match any of the following reserved names: AIRFLOW_HOME C_FORCE_ROOT CONTAINER_NAME DAGS_FOLDER GCP_PROJECT GCS_BUCKET GKE_CLUSTER_NAME SQL_DATABASE SQL_INSTANCE SQL_PASSWORD SQL_PROJECT SQL_REGION SQL_USER.
        """
        return pulumi.get(self, "env_variables")

    @_builtins.property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[_builtins.str]:
        """
        The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression composer-([0-9]+(\\.[0-9]+\\.[0-9]+(-preview\\.[0-9]+)?)?|latest)-airflow-([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?). The Cloud Composer portion of the image version is a full semantic version, or an alias in the form of major version number or 'latest'. The Apache Airflow portion of the image version is a full semantic version that points to one of the supported Apache Airflow versions, or an alias in the form of only major or major.minor versions specified. See documentation for more details and version list.
        """
        return pulumi.get(self, "image_version")

    @_builtins.property
    @pulumi.getter(name="pypiPackages")
    def pypi_packages(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name (e.g. "numpy"). Values are the lowercase extras and version specifier (e.g. "==1.12.0", "[devel,gcp_api]", "[devel]>=1.8.2, <1.9.2"). To specify a package without pinning it to a version specifier, use the empty string as the value.
        """
        return pulumi.get(self, "pypi_packages")

    @_builtins.property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> Optional[_builtins.str]:
        """
        The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
        """
        return pulumi.get(self, "python_version")

    @_builtins.property
    @pulumi.getter(name="schedulerCount")
    def scheduler_count(self) -> Optional[_builtins.int]:
        """
        The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
        """
        return pulumi.get(self, "scheduler_count")

    @_builtins.property
    @pulumi.getter(name="webServerPluginsMode")
    def web_server_plugins_mode(self) -> Optional[_builtins.str]:
        """
        Should be either 'ENABLED' or 'DISABLED'. Defaults to 'ENABLED'. Used in Composer 3.
        """
        return pulumi.get(self, "web_server_plugins_mode")


@pulumi.output_type
class EnvironmentConfigSoftwareConfigCloudDataLineageIntegration(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Whether or not Cloud Data Lineage integration is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether or not Cloud Data Lineage integration is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class EnvironmentConfigWebServerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineType":
            suggest = "machine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigWebServerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigWebServerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigWebServerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_type: _builtins.str):
        """
        :param _builtins.str machine_type: Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        pulumi.set(__self__, "machine_type", machine_type)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> _builtins.str:
        """
        Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        return pulumi.get(self, "machine_type")


@pulumi.output_type
class EnvironmentConfigWebServerNetworkAccessControl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedIpRanges":
            suggest = "allowed_ip_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigWebServerNetworkAccessControl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigWebServerNetworkAccessControl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigWebServerNetworkAccessControl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_ip_ranges: Optional[Sequence['outputs.EnvironmentConfigWebServerNetworkAccessControlAllowedIpRange']] = None):
        """
        :param Sequence['EnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgs'] allowed_ip_ranges: A collection of allowed IP ranges with descriptions.
        """
        if allowed_ip_ranges is not None:
            pulumi.set(__self__, "allowed_ip_ranges", allowed_ip_ranges)

    @_builtins.property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> Optional[Sequence['outputs.EnvironmentConfigWebServerNetworkAccessControlAllowedIpRange']]:
        """
        A collection of allowed IP ranges with descriptions.
        """
        return pulumi.get(self, "allowed_ip_ranges")


@pulumi.output_type
class EnvironmentConfigWebServerNetworkAccessControlAllowedIpRange(dict):
    def __init__(__self__, *,
                 value: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. IP range prefixes should be properly truncated. For example, 1.2.3.4/24 should be truncated to 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 should be truncated to 2001:db8::/32.
        :param _builtins.str description: A description of this ip range.
        """
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. IP range prefixes should be properly truncated. For example, 1.2.3.4/24 should be truncated to 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 should be truncated to 2001:db8::/32.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A description of this ip range.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class EnvironmentConfigWorkloadsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dagProcessor":
            suggest = "dag_processor"
        elif key == "webServer":
            suggest = "web_server"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigWorkloadsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigWorkloadsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigWorkloadsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dag_processor: Optional['outputs.EnvironmentConfigWorkloadsConfigDagProcessor'] = None,
                 scheduler: Optional['outputs.EnvironmentConfigWorkloadsConfigScheduler'] = None,
                 triggerer: Optional['outputs.EnvironmentConfigWorkloadsConfigTriggerer'] = None,
                 web_server: Optional['outputs.EnvironmentConfigWorkloadsConfigWebServer'] = None,
                 worker: Optional['outputs.EnvironmentConfigWorkloadsConfigWorker'] = None):
        """
        :param 'EnvironmentConfigWorkloadsConfigDagProcessorArgs' dag_processor: Configuration for resources used by DAG processor.
        :param 'EnvironmentConfigWorkloadsConfigSchedulerArgs' scheduler: Configuration for resources used by Airflow schedulers.
        :param 'EnvironmentConfigWorkloadsConfigTriggererArgs' triggerer: Configuration for resources used by Airflow triggerers.
        :param 'EnvironmentConfigWorkloadsConfigWebServerArgs' web_server: Configuration for resources used by Airflow web server.
        :param 'EnvironmentConfigWorkloadsConfigWorkerArgs' worker: Configuration for resources used by Airflow workers.
        """
        if dag_processor is not None:
            pulumi.set(__self__, "dag_processor", dag_processor)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if triggerer is not None:
            pulumi.set(__self__, "triggerer", triggerer)
        if web_server is not None:
            pulumi.set(__self__, "web_server", web_server)
        if worker is not None:
            pulumi.set(__self__, "worker", worker)

    @_builtins.property
    @pulumi.getter(name="dagProcessor")
    def dag_processor(self) -> Optional['outputs.EnvironmentConfigWorkloadsConfigDagProcessor']:
        """
        Configuration for resources used by DAG processor.
        """
        return pulumi.get(self, "dag_processor")

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> Optional['outputs.EnvironmentConfigWorkloadsConfigScheduler']:
        """
        Configuration for resources used by Airflow schedulers.
        """
        return pulumi.get(self, "scheduler")

    @_builtins.property
    @pulumi.getter
    def triggerer(self) -> Optional['outputs.EnvironmentConfigWorkloadsConfigTriggerer']:
        """
        Configuration for resources used by Airflow triggerers.
        """
        return pulumi.get(self, "triggerer")

    @_builtins.property
    @pulumi.getter(name="webServer")
    def web_server(self) -> Optional['outputs.EnvironmentConfigWorkloadsConfigWebServer']:
        """
        Configuration for resources used by Airflow web server.
        """
        return pulumi.get(self, "web_server")

    @_builtins.property
    @pulumi.getter
    def worker(self) -> Optional['outputs.EnvironmentConfigWorkloadsConfigWorker']:
        """
        Configuration for resources used by Airflow workers.
        """
        return pulumi.get(self, "worker")


@pulumi.output_type
class EnvironmentConfigWorkloadsConfigDagProcessor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryGb":
            suggest = "memory_gb"
        elif key == "storageGb":
            suggest = "storage_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigWorkloadsConfigDagProcessor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigWorkloadsConfigDagProcessor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigWorkloadsConfigDagProcessor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 cpu: Optional[_builtins.float] = None,
                 memory_gb: Optional[_builtins.float] = None,
                 storage_gb: Optional[_builtins.float] = None):
        """
        :param _builtins.int count: Number of DAG processors.
        :param _builtins.float cpu: CPU request and limit for DAG processor.
        :param _builtins.float memory_gb: Memory (GB) request and limit for DAG processor.
        :param _builtins.float storage_gb: Storage (GB) request and limit for DAG processor.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        Number of DAG processors.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.float]:
        """
        CPU request and limit for DAG processor.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[_builtins.float]:
        """
        Memory (GB) request and limit for DAG processor.
        """
        return pulumi.get(self, "memory_gb")

    @_builtins.property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[_builtins.float]:
        """
        Storage (GB) request and limit for DAG processor.
        """
        return pulumi.get(self, "storage_gb")


@pulumi.output_type
class EnvironmentConfigWorkloadsConfigScheduler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryGb":
            suggest = "memory_gb"
        elif key == "storageGb":
            suggest = "storage_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigWorkloadsConfigScheduler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigWorkloadsConfigScheduler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigWorkloadsConfigScheduler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 cpu: Optional[_builtins.float] = None,
                 memory_gb: Optional[_builtins.float] = None,
                 storage_gb: Optional[_builtins.float] = None):
        """
        :param _builtins.int count: The number of schedulers.
        :param _builtins.float cpu: CPU request and limit for a single Airflow scheduler replica
        :param _builtins.float memory_gb: Memory (GB) request and limit for a single Airflow scheduler replica.
        :param _builtins.float storage_gb: Storage (GB) request and limit for a single Airflow scheduler replica.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        The number of schedulers.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.float]:
        """
        CPU request and limit for a single Airflow scheduler replica
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[_builtins.float]:
        """
        Memory (GB) request and limit for a single Airflow scheduler replica.
        """
        return pulumi.get(self, "memory_gb")

    @_builtins.property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[_builtins.float]:
        """
        Storage (GB) request and limit for a single Airflow scheduler replica.
        """
        return pulumi.get(self, "storage_gb")


@pulumi.output_type
class EnvironmentConfigWorkloadsConfigTriggerer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryGb":
            suggest = "memory_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigWorkloadsConfigTriggerer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigWorkloadsConfigTriggerer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigWorkloadsConfigTriggerer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: _builtins.int,
                 cpu: _builtins.float,
                 memory_gb: _builtins.float):
        """
        :param _builtins.int count: The number of triggerers.
        :param _builtins.float cpu: CPU request and limit for a single Airflow triggerer replica.
        :param _builtins.float memory_gb: Memory (GB) request and limit for a single Airflow triggerer replica.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory_gb", memory_gb)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The number of triggerers.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        CPU request and limit for a single Airflow triggerer replica.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> _builtins.float:
        """
        Memory (GB) request and limit for a single Airflow triggerer replica.
        """
        return pulumi.get(self, "memory_gb")


@pulumi.output_type
class EnvironmentConfigWorkloadsConfigWebServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryGb":
            suggest = "memory_gb"
        elif key == "storageGb":
            suggest = "storage_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigWorkloadsConfigWebServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigWorkloadsConfigWebServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigWorkloadsConfigWebServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[_builtins.float] = None,
                 memory_gb: Optional[_builtins.float] = None,
                 storage_gb: Optional[_builtins.float] = None):
        """
        :param _builtins.float cpu: CPU request and limit for Airflow web server.
        :param _builtins.float memory_gb: Memory (GB) request and limit for Airflow web server.
        :param _builtins.float storage_gb: Storage (GB) request and limit for Airflow web server.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.float]:
        """
        CPU request and limit for Airflow web server.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[_builtins.float]:
        """
        Memory (GB) request and limit for Airflow web server.
        """
        return pulumi.get(self, "memory_gb")

    @_builtins.property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[_builtins.float]:
        """
        Storage (GB) request and limit for Airflow web server.
        """
        return pulumi.get(self, "storage_gb")


@pulumi.output_type
class EnvironmentConfigWorkloadsConfigWorker(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCount":
            suggest = "max_count"
        elif key == "memoryGb":
            suggest = "memory_gb"
        elif key == "minCount":
            suggest = "min_count"
        elif key == "storageGb":
            suggest = "storage_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigWorkloadsConfigWorker. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigWorkloadsConfigWorker.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigWorkloadsConfigWorker.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[_builtins.float] = None,
                 max_count: Optional[_builtins.int] = None,
                 memory_gb: Optional[_builtins.float] = None,
                 min_count: Optional[_builtins.int] = None,
                 storage_gb: Optional[_builtins.float] = None):
        """
        :param _builtins.float cpu: CPU request and limit for a single Airflow worker replica.
        :param _builtins.int max_count: Maximum number of workers for autoscaling.
        :param _builtins.float memory_gb: Memory (GB) request and limit for a single Airflow worker replica.
        :param _builtins.int min_count: Minimum number of workers for autoscaling.
        :param _builtins.float storage_gb: Storage (GB) request and limit for a single Airflow worker replica.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.float]:
        """
        CPU request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[_builtins.int]:
        """
        Maximum number of workers for autoscaling.
        """
        return pulumi.get(self, "max_count")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[_builtins.float]:
        """
        Memory (GB) request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "memory_gb")

    @_builtins.property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[_builtins.int]:
        """
        Minimum number of workers for autoscaling.
        """
        return pulumi.get(self, "min_count")

    @_builtins.property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[_builtins.float]:
        """
        Storage (GB) request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "storage_gb")


@pulumi.output_type
class EnvironmentStorageConfig(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str):
        """
        :param _builtins.str bucket: Optional. Name of an existing Cloud Storage bucket to be used by the environment.
        """
        pulumi.set(__self__, "bucket", bucket)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Optional. Name of an existing Cloud Storage bucket to be used by the environment.
        """
        return pulumi.get(self, "bucket")


@pulumi.output_type
class GetEnvironmentConfigResult(dict):
    def __init__(__self__, *,
                 airflow_uri: _builtins.str,
                 dag_gcs_prefix: _builtins.str,
                 data_retention_configs: Sequence['outputs.GetEnvironmentConfigDataRetentionConfigResult'],
                 database_configs: Sequence['outputs.GetEnvironmentConfigDatabaseConfigResult'],
                 enable_private_builds_only: _builtins.bool,
                 enable_private_environment: _builtins.bool,
                 encryption_configs: Sequence['outputs.GetEnvironmentConfigEncryptionConfigResult'],
                 environment_size: _builtins.str,
                 gke_cluster: _builtins.str,
                 maintenance_windows: Sequence['outputs.GetEnvironmentConfigMaintenanceWindowResult'],
                 master_authorized_networks_configs: Sequence['outputs.GetEnvironmentConfigMasterAuthorizedNetworksConfigResult'],
                 node_configs: Sequence['outputs.GetEnvironmentConfigNodeConfigResult'],
                 node_count: _builtins.int,
                 private_environment_configs: Sequence['outputs.GetEnvironmentConfigPrivateEnvironmentConfigResult'],
                 recovery_configs: Sequence['outputs.GetEnvironmentConfigRecoveryConfigResult'],
                 resilience_mode: _builtins.str,
                 software_configs: Sequence['outputs.GetEnvironmentConfigSoftwareConfigResult'],
                 web_server_configs: Sequence['outputs.GetEnvironmentConfigWebServerConfigResult'],
                 web_server_network_access_controls: Sequence['outputs.GetEnvironmentConfigWebServerNetworkAccessControlResult'],
                 workloads_configs: Sequence['outputs.GetEnvironmentConfigWorkloadsConfigResult']):
        """
        :param _builtins.str airflow_uri: The URI of the Apache Airflow Web UI hosted within the
               environment.
        :param _builtins.str dag_gcs_prefix: The Cloud Storage prefix of the DAGs for the environment.
        :param Sequence['GetEnvironmentConfigDataRetentionConfigArgs'] data_retention_configs: The configuration setting for Airflow data retention mechanism. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4. or newer
        :param Sequence['GetEnvironmentConfigDatabaseConfigArgs'] database_configs: The configuration of Cloud SQL instance that is used by the Apache Airflow software. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.bool enable_private_builds_only: Optional. If true, builds performed during operations that install Python packages have only private connectivity to Google services. If false, the builds also have access to the internet.
        :param _builtins.bool enable_private_environment: Optional. If true, a private Composer environment will be created.
        :param Sequence['GetEnvironmentConfigEncryptionConfigArgs'] encryption_configs: The encryption options for the Composer environment and its dependencies.
        :param _builtins.str environment_size: The size of the Cloud Composer environment. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param _builtins.str gke_cluster: The Kubernetes Engine cluster used to run the environment.
        :param Sequence['GetEnvironmentConfigMaintenanceWindowArgs'] maintenance_windows: The configuration for Cloud Composer maintenance window.
        :param Sequence['GetEnvironmentConfigMasterAuthorizedNetworksConfigArgs'] master_authorized_networks_configs: Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
        :param Sequence['GetEnvironmentConfigNodeConfigArgs'] node_configs: The configuration used for the Kubernetes Engine cluster.
        :param _builtins.int node_count: The number of nodes in the Kubernetes Engine cluster that will be used to run this environment. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param Sequence['GetEnvironmentConfigPrivateEnvironmentConfigArgs'] private_environment_configs: The configuration used for the Private IP Cloud Composer environment.
        :param Sequence['GetEnvironmentConfigRecoveryConfigArgs'] recovery_configs: The recovery configuration settings for the Cloud Composer environment
        :param _builtins.str resilience_mode: Whether high resilience is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.1.15-airflow-*.*.* and newer.
        :param Sequence['GetEnvironmentConfigSoftwareConfigArgs'] software_configs: The configuration settings for software inside the environment.
        :param Sequence['GetEnvironmentConfigWebServerConfigArgs'] web_server_configs: The configuration settings for the Airflow web server App Engine instance. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param Sequence['GetEnvironmentConfigWebServerNetworkAccessControlArgs'] web_server_network_access_controls: Network-level access control policy for the Airflow web server.
        :param Sequence['GetEnvironmentConfigWorkloadsConfigArgs'] workloads_configs: The workloads configuration settings for the GKE cluster associated with the Cloud Composer environment. Supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        pulumi.set(__self__, "airflow_uri", airflow_uri)
        pulumi.set(__self__, "dag_gcs_prefix", dag_gcs_prefix)
        pulumi.set(__self__, "data_retention_configs", data_retention_configs)
        pulumi.set(__self__, "database_configs", database_configs)
        pulumi.set(__self__, "enable_private_builds_only", enable_private_builds_only)
        pulumi.set(__self__, "enable_private_environment", enable_private_environment)
        pulumi.set(__self__, "encryption_configs", encryption_configs)
        pulumi.set(__self__, "environment_size", environment_size)
        pulumi.set(__self__, "gke_cluster", gke_cluster)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "master_authorized_networks_configs", master_authorized_networks_configs)
        pulumi.set(__self__, "node_configs", node_configs)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "private_environment_configs", private_environment_configs)
        pulumi.set(__self__, "recovery_configs", recovery_configs)
        pulumi.set(__self__, "resilience_mode", resilience_mode)
        pulumi.set(__self__, "software_configs", software_configs)
        pulumi.set(__self__, "web_server_configs", web_server_configs)
        pulumi.set(__self__, "web_server_network_access_controls", web_server_network_access_controls)
        pulumi.set(__self__, "workloads_configs", workloads_configs)

    @_builtins.property
    @pulumi.getter(name="airflowUri")
    def airflow_uri(self) -> _builtins.str:
        """
        The URI of the Apache Airflow Web UI hosted within the
        environment.
        """
        return pulumi.get(self, "airflow_uri")

    @_builtins.property
    @pulumi.getter(name="dagGcsPrefix")
    def dag_gcs_prefix(self) -> _builtins.str:
        """
        The Cloud Storage prefix of the DAGs for the environment.
        """
        return pulumi.get(self, "dag_gcs_prefix")

    @_builtins.property
    @pulumi.getter(name="dataRetentionConfigs")
    def data_retention_configs(self) -> Sequence['outputs.GetEnvironmentConfigDataRetentionConfigResult']:
        """
        The configuration setting for Airflow data retention mechanism. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4. or newer
        """
        return pulumi.get(self, "data_retention_configs")

    @_builtins.property
    @pulumi.getter(name="databaseConfigs")
    def database_configs(self) -> Sequence['outputs.GetEnvironmentConfigDatabaseConfigResult']:
        """
        The configuration of Cloud SQL instance that is used by the Apache Airflow software. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "database_configs")

    @_builtins.property
    @pulumi.getter(name="enablePrivateBuildsOnly")
    def enable_private_builds_only(self) -> _builtins.bool:
        """
        Optional. If true, builds performed during operations that install Python packages have only private connectivity to Google services. If false, the builds also have access to the internet.
        """
        return pulumi.get(self, "enable_private_builds_only")

    @_builtins.property
    @pulumi.getter(name="enablePrivateEnvironment")
    def enable_private_environment(self) -> _builtins.bool:
        """
        Optional. If true, a private Composer environment will be created.
        """
        return pulumi.get(self, "enable_private_environment")

    @_builtins.property
    @pulumi.getter(name="encryptionConfigs")
    def encryption_configs(self) -> Sequence['outputs.GetEnvironmentConfigEncryptionConfigResult']:
        """
        The encryption options for the Composer environment and its dependencies.
        """
        return pulumi.get(self, "encryption_configs")

    @_builtins.property
    @pulumi.getter(name="environmentSize")
    def environment_size(self) -> _builtins.str:
        """
        The size of the Cloud Composer environment. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "environment_size")

    @_builtins.property
    @pulumi.getter(name="gkeCluster")
    def gke_cluster(self) -> _builtins.str:
        """
        The Kubernetes Engine cluster used to run the environment.
        """
        return pulumi.get(self, "gke_cluster")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetEnvironmentConfigMaintenanceWindowResult']:
        """
        The configuration for Cloud Composer maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @_builtins.property
    @pulumi.getter(name="masterAuthorizedNetworksConfigs")
    def master_authorized_networks_configs(self) -> Sequence['outputs.GetEnvironmentConfigMasterAuthorizedNetworksConfigResult']:
        """
        Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
        """
        return pulumi.get(self, "master_authorized_networks_configs")

    @_builtins.property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Sequence['outputs.GetEnvironmentConfigNodeConfigResult']:
        """
        The configuration used for the Kubernetes Engine cluster.
        """
        return pulumi.get(self, "node_configs")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> _builtins.int:
        """
        The number of nodes in the Kubernetes Engine cluster that will be used to run this environment. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="privateEnvironmentConfigs")
    def private_environment_configs(self) -> Sequence['outputs.GetEnvironmentConfigPrivateEnvironmentConfigResult']:
        """
        The configuration used for the Private IP Cloud Composer environment.
        """
        return pulumi.get(self, "private_environment_configs")

    @_builtins.property
    @pulumi.getter(name="recoveryConfigs")
    def recovery_configs(self) -> Sequence['outputs.GetEnvironmentConfigRecoveryConfigResult']:
        """
        The recovery configuration settings for the Cloud Composer environment
        """
        return pulumi.get(self, "recovery_configs")

    @_builtins.property
    @pulumi.getter(name="resilienceMode")
    def resilience_mode(self) -> _builtins.str:
        """
        Whether high resilience is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.1.15-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "resilience_mode")

    @_builtins.property
    @pulumi.getter(name="softwareConfigs")
    def software_configs(self) -> Sequence['outputs.GetEnvironmentConfigSoftwareConfigResult']:
        """
        The configuration settings for software inside the environment.
        """
        return pulumi.get(self, "software_configs")

    @_builtins.property
    @pulumi.getter(name="webServerConfigs")
    def web_server_configs(self) -> Sequence['outputs.GetEnvironmentConfigWebServerConfigResult']:
        """
        The configuration settings for the Airflow web server App Engine instance. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "web_server_configs")

    @_builtins.property
    @pulumi.getter(name="webServerNetworkAccessControls")
    def web_server_network_access_controls(self) -> Sequence['outputs.GetEnvironmentConfigWebServerNetworkAccessControlResult']:
        """
        Network-level access control policy for the Airflow web server.
        """
        return pulumi.get(self, "web_server_network_access_controls")

    @_builtins.property
    @pulumi.getter(name="workloadsConfigs")
    def workloads_configs(self) -> Sequence['outputs.GetEnvironmentConfigWorkloadsConfigResult']:
        """
        The workloads configuration settings for the GKE cluster associated with the Cloud Composer environment. Supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "workloads_configs")


@pulumi.output_type
class GetEnvironmentConfigDataRetentionConfigResult(dict):
    def __init__(__self__, *,
                 airflow_metadata_retention_configs: Sequence['outputs.GetEnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfigResult'],
                 task_logs_retention_configs: Sequence['outputs.GetEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigResult']):
        """
        :param Sequence['GetEnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfigArgs'] airflow_metadata_retention_configs: Optional. The policy for airflow metadata database retention.
        :param Sequence['GetEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgs'] task_logs_retention_configs: Optional. The configuration setting for Task Logs.
        """
        pulumi.set(__self__, "airflow_metadata_retention_configs", airflow_metadata_retention_configs)
        pulumi.set(__self__, "task_logs_retention_configs", task_logs_retention_configs)

    @_builtins.property
    @pulumi.getter(name="airflowMetadataRetentionConfigs")
    def airflow_metadata_retention_configs(self) -> Sequence['outputs.GetEnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfigResult']:
        """
        Optional. The policy for airflow metadata database retention.
        """
        return pulumi.get(self, "airflow_metadata_retention_configs")

    @_builtins.property
    @pulumi.getter(name="taskLogsRetentionConfigs")
    def task_logs_retention_configs(self) -> Sequence['outputs.GetEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigResult']:
        """
        Optional. The configuration setting for Task Logs.
        """
        return pulumi.get(self, "task_logs_retention_configs")


@pulumi.output_type
class GetEnvironmentConfigDataRetentionConfigAirflowMetadataRetentionConfigResult(dict):
    def __init__(__self__, *,
                 retention_days: _builtins.int,
                 retention_mode: _builtins.str):
        """
        :param _builtins.int retention_days: How many days data should be retained for. This field is supported for Cloud Composer environments in composer 3 and newer.
        :param _builtins.str retention_mode: Whether database retention is enabled or not. This field is supported for Cloud Composer environments in composer 3 and newer.
        """
        pulumi.set(__self__, "retention_days", retention_days)
        pulumi.set(__self__, "retention_mode", retention_mode)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> _builtins.int:
        """
        How many days data should be retained for. This field is supported for Cloud Composer environments in composer 3 and newer.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter(name="retentionMode")
    def retention_mode(self) -> _builtins.str:
        """
        Whether database retention is enabled or not. This field is supported for Cloud Composer environments in composer 3 and newer.
        """
        return pulumi.get(self, "retention_mode")


@pulumi.output_type
class GetEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigResult(dict):
    def __init__(__self__, *,
                 storage_mode: _builtins.str):
        """
        :param _builtins.str storage_mode: Whether logs in cloud logging only is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4 and newer but not in composer-3*
        """
        pulumi.set(__self__, "storage_mode", storage_mode)

    @_builtins.property
    @pulumi.getter(name="storageMode")
    def storage_mode(self) -> _builtins.str:
        """
        Whether logs in cloud logging only is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4 and newer but not in composer-3*
        """
        return pulumi.get(self, "storage_mode")


@pulumi.output_type
class GetEnvironmentConfigDatabaseConfigResult(dict):
    def __init__(__self__, *,
                 machine_type: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str machine_type: Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        :param _builtins.str zone: Optional. Cloud SQL database preferred zone.
        """
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> _builtins.str:
        """
        Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        Optional. Cloud SQL database preferred zone.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetEnvironmentConfigEncryptionConfigResult(dict):
    def __init__(__self__, *,
                 kms_key_name: _builtins.str):
        """
        :param _builtins.str kms_key_name: Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetEnvironmentConfigMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 end_time: _builtins.str,
                 recurrence: _builtins.str,
                 start_time: _builtins.str):
        """
        :param _builtins.str end_time: Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end-time must be in the future, relative to 'start_time'.
        :param _builtins.str recurrence: Maintenance window recurrence. Format is a subset of RFC-5545 (https://tools.ietf.org/html/rfc5545) 'RRULE'. The only allowed values for 'FREQ' field are 'FREQ=DAILY' and 'FREQ=WEEKLY;BYDAY=...'. Example values: 'FREQ=WEEKLY;BYDAY=TU,WE', 'FREQ=DAILY'.
        :param _builtins.str start_time: Start time of the first recurrence of the maintenance window.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "recurrence", recurrence)
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end-time must be in the future, relative to 'start_time'.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def recurrence(self) -> _builtins.str:
        """
        Maintenance window recurrence. Format is a subset of RFC-5545 (https://tools.ietf.org/html/rfc5545) 'RRULE'. The only allowed values for 'FREQ' field are 'FREQ=DAILY' and 'FREQ=WEEKLY;BYDAY=...'. Example values: 'FREQ=WEEKLY;BYDAY=TU,WE', 'FREQ=DAILY'.
        """
        return pulumi.get(self, "recurrence")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Start time of the first recurrence of the maintenance window.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetEnvironmentConfigMasterAuthorizedNetworksConfigResult(dict):
    def __init__(__self__, *,
                 cidr_blocks: Sequence['outputs.GetEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockResult'],
                 enabled: _builtins.bool):
        """
        :param Sequence['GetEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgs'] cidr_blocks: cidr_blocks define up to 50 external networks that could access Kubernetes master through HTTPS.
        :param _builtins.bool enabled: Whether or not master authorized networks is enabled.
        """
        pulumi.set(__self__, "cidr_blocks", cidr_blocks)
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Sequence['outputs.GetEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockResult']:
        """
        cidr_blocks define up to 50 external networks that could access Kubernetes master through HTTPS.
        """
        return pulumi.get(self, "cidr_blocks")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether or not master authorized networks is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockResult(dict):
    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 display_name: _builtins.str):
        """
        :param _builtins.str cidr_block: cidr_block must be specified in CIDR notation.
        :param _builtins.str display_name: display_name is a field for users to identify CIDR blocks.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        cidr_block must be specified in CIDR notation.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        display_name is a field for users to identify CIDR blocks.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class GetEnvironmentConfigNodeConfigResult(dict):
    def __init__(__self__, *,
                 composer_internal_ipv4_cidr_block: _builtins.str,
                 composer_network_attachment: _builtins.str,
                 disk_size_gb: _builtins.int,
                 enable_ip_masq_agent: _builtins.bool,
                 ip_allocation_policies: Sequence['outputs.GetEnvironmentConfigNodeConfigIpAllocationPolicyResult'],
                 machine_type: _builtins.str,
                 max_pods_per_node: _builtins.int,
                 network: _builtins.str,
                 oauth_scopes: Sequence[_builtins.str],
                 service_account: _builtins.str,
                 subnetwork: _builtins.str,
                 tags: Sequence[_builtins.str],
                 zone: _builtins.str):
        """
        :param _builtins.str composer_internal_ipv4_cidr_block: IPv4 cidr range that will be used by Composer internal components.
        :param _builtins.str composer_network_attachment: PSC (Private Service Connect) Network entry point. Customers can pre-create the Network Attachment and point Cloud Composer environment to use. It is possible to share network attachment among many environments, provided enough IP addresses are available.
        :param _builtins.int disk_size_gb: The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.bool enable_ip_masq_agent: Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for all destination addresses, except between pods traffic. See: https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
        :param Sequence['GetEnvironmentConfigNodeConfigIpAllocationPolicyArgs'] ip_allocation_policies: Configuration for controlling how IPs are allocated in the GKE cluster. Cannot be updated.
        :param _builtins.str machine_type: The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.int max_pods_per_node: The maximum pods per node in the GKE cluster allocated during environment creation. Lowering this value reduces IP address consumption by the Cloud Composer Kubernetes cluster. This value can only be set during environment creation, and only if the environment is VPC-Native. The range of possible values is 8-110, and the default is 32. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.str network: The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. The network must belong to the environment's project. If unspecified, the "default" network ID in the environment's project is used. If a Custom Subnet Network is provided, subnetwork must also be provided.
        :param Sequence[_builtins.str] oauth_scopes: The set of Google API scopes to be made available on all node VMs. Cannot be updated. If empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.str service_account: The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated. If given, note that the service account must have roles/composer.worker for any GCP resources created under the Cloud Composer Environment.
        :param _builtins.str subnetwork: The Compute Engine subnetwork to be used for machine communications, specified as a self-link, relative resource name (e.g. "projects/{project}/regions/{region}/subnetworks/{subnetwork}"), or by name. If subnetwork is provided, network must also be provided and the subnetwork must belong to the enclosing environment's project and region.
        :param Sequence[_builtins.str] tags: The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with RFC1035. Cannot be updated.
        :param _builtins.str zone: The Compute Engine zone in which to deploy the VMs running the Apache Airflow software, specified as the zone name or relative resource name (e.g. "projects/{project}/zones/{zone}"). Must belong to the enclosing environment's project and region. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        pulumi.set(__self__, "composer_internal_ipv4_cidr_block", composer_internal_ipv4_cidr_block)
        pulumi.set(__self__, "composer_network_attachment", composer_network_attachment)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "enable_ip_masq_agent", enable_ip_masq_agent)
        pulumi.set(__self__, "ip_allocation_policies", ip_allocation_policies)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="composerInternalIpv4CidrBlock")
    def composer_internal_ipv4_cidr_block(self) -> _builtins.str:
        """
        IPv4 cidr range that will be used by Composer internal components.
        """
        return pulumi.get(self, "composer_internal_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="composerNetworkAttachment")
    def composer_network_attachment(self) -> _builtins.str:
        """
        PSC (Private Service Connect) Network entry point. Customers can pre-create the Network Attachment and point Cloud Composer environment to use. It is possible to share network attachment among many environments, provided enough IP addresses are available.
        """
        return pulumi.get(self, "composer_network_attachment")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> _builtins.int:
        """
        The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="enableIpMasqAgent")
    def enable_ip_masq_agent(self) -> _builtins.bool:
        """
        Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for all destination addresses, except between pods traffic. See: https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
        """
        return pulumi.get(self, "enable_ip_masq_agent")

    @_builtins.property
    @pulumi.getter(name="ipAllocationPolicies")
    def ip_allocation_policies(self) -> Sequence['outputs.GetEnvironmentConfigNodeConfigIpAllocationPolicyResult']:
        """
        Configuration for controlling how IPs are allocated in the GKE cluster. Cannot be updated.
        """
        return pulumi.get(self, "ip_allocation_policies")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> _builtins.str:
        """
        The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> _builtins.int:
        """
        The maximum pods per node in the GKE cluster allocated during environment creation. Lowering this value reduces IP address consumption by the Cloud Composer Kubernetes cluster. This value can only be set during environment creation, and only if the environment is VPC-Native. The range of possible values is 8-110, and the default is 32. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "max_pods_per_node")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. The network must belong to the environment's project. If unspecified, the "default" network ID in the environment's project is used. If a Custom Subnet Network is provided, subnetwork must also be provided.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Sequence[_builtins.str]:
        """
        The set of Google API scopes to be made available on all node VMs. Cannot be updated. If empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "oauth_scopes")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated. If given, note that the service account must have roles/composer.worker for any GCP resources created under the Cloud Composer Environment.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> _builtins.str:
        """
        The Compute Engine subnetwork to be used for machine communications, specified as a self-link, relative resource name (e.g. "projects/{project}/regions/{region}/subnetworks/{subnetwork}"), or by name. If subnetwork is provided, network must also be provided and the subnetwork must belong to the enclosing environment's project and region.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with RFC1035. Cannot be updated.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        The Compute Engine zone in which to deploy the VMs running the Apache Airflow software, specified as the zone name or relative resource name (e.g. "projects/{project}/zones/{zone}"). Must belong to the enclosing environment's project and region. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetEnvironmentConfigNodeConfigIpAllocationPolicyResult(dict):
    def __init__(__self__, *,
                 cluster_ipv4_cidr_block: _builtins.str,
                 cluster_secondary_range_name: _builtins.str,
                 services_ipv4_cidr_block: _builtins.str,
                 services_secondary_range_name: _builtins.str,
                 use_ip_aliases: _builtins.bool):
        """
        :param _builtins.str cluster_ipv4_cidr_block: The IP address range used to allocate IP addresses to pods in the cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both.
        :param _builtins.str cluster_secondary_range_name: The name of the cluster's secondary range used to allocate IP addresses to pods. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        :param _builtins.str services_ipv4_cidr_block: The IP address range used to allocate IP addresses in this cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both.
        :param _builtins.str services_secondary_range_name: The name of the services' secondary range used to allocate IP addresses to the cluster. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        :param _builtins.bool use_ip_aliases: Whether or not to enable Alias IPs in the GKE cluster. If true, a VPC-native cluster is created. Defaults to true if the ip_allocation_policy block is present in config. This field is only supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use VPC-native GKE clusters.
        """
        pulumi.set(__self__, "cluster_ipv4_cidr_block", cluster_ipv4_cidr_block)
        pulumi.set(__self__, "cluster_secondary_range_name", cluster_secondary_range_name)
        pulumi.set(__self__, "services_ipv4_cidr_block", services_ipv4_cidr_block)
        pulumi.set(__self__, "services_secondary_range_name", services_secondary_range_name)
        pulumi.set(__self__, "use_ip_aliases", use_ip_aliases)

    @_builtins.property
    @pulumi.getter(name="clusterIpv4CidrBlock")
    def cluster_ipv4_cidr_block(self) -> _builtins.str:
        """
        The IP address range used to allocate IP addresses to pods in the cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="clusterSecondaryRangeName")
    def cluster_secondary_range_name(self) -> _builtins.str:
        """
        The name of the cluster's secondary range used to allocate IP addresses to pods. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        """
        return pulumi.get(self, "cluster_secondary_range_name")

    @_builtins.property
    @pulumi.getter(name="servicesIpv4CidrBlock")
    def services_ipv4_cidr_block(self) -> _builtins.str:
        """
        The IP address range used to allocate IP addresses in this cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both.
        """
        return pulumi.get(self, "services_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="servicesSecondaryRangeName")
    def services_secondary_range_name(self) -> _builtins.str:
        """
        The name of the services' secondary range used to allocate IP addresses to the cluster. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        """
        return pulumi.get(self, "services_secondary_range_name")

    @_builtins.property
    @pulumi.getter(name="useIpAliases")
    def use_ip_aliases(self) -> _builtins.bool:
        """
        Whether or not to enable Alias IPs in the GKE cluster. If true, a VPC-native cluster is created. Defaults to true if the ip_allocation_policy block is present in config. This field is only supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use VPC-native GKE clusters.
        """
        return pulumi.get(self, "use_ip_aliases")


@pulumi.output_type
class GetEnvironmentConfigPrivateEnvironmentConfigResult(dict):
    def __init__(__self__, *,
                 cloud_composer_connection_subnetwork: _builtins.str,
                 cloud_composer_network_ipv4_cidr_block: _builtins.str,
                 cloud_sql_ipv4_cidr_block: _builtins.str,
                 connection_type: _builtins.str,
                 enable_private_endpoint: _builtins.bool,
                 enable_privately_used_public_ips: _builtins.bool,
                 master_ipv4_cidr_block: _builtins.str,
                 web_server_ipv4_cidr_block: _builtins.str):
        """
        :param _builtins.str cloud_composer_connection_subnetwork: When specified, the environment will use Private Service Connect instead of VPC peerings to connect to Cloud SQL in the Tenant Project, and the PSC endpoint in the Customer Project will use an IP address from this subnetwork. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param _builtins.str cloud_composer_network_ipv4_cidr_block: The CIDR block from which IP range for Cloud Composer Network in tenant project will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param _builtins.str cloud_sql_ipv4_cidr_block: The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block.
        :param _builtins.str connection_type: Mode of internal communication within the Composer environment. Must be one of "VPC_PEERING" or "PRIVATE_SERVICE_CONNECT".
        :param _builtins.bool enable_private_endpoint: If true, access to the public endpoint of the GKE cluster is denied. If this field is set to true, ip_allocation_policy.use_ip_aliases must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param _builtins.bool enable_privately_used_public_ips: When enabled, IPs from public (non-RFC1918) ranges can be used for ip_allocation_policy.cluster_ipv4_cidr_block and ip_allocation_policy.service_ipv4_cidr_block.
        :param _builtins.str master_ipv4_cidr_block: The IP range in CIDR notation to use for the hosted master network. This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network. If left blank, the default value of '172.16.0.0/28' is used.
        :param _builtins.str web_server_ipv4_cidr_block: The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        pulumi.set(__self__, "cloud_composer_connection_subnetwork", cloud_composer_connection_subnetwork)
        pulumi.set(__self__, "cloud_composer_network_ipv4_cidr_block", cloud_composer_network_ipv4_cidr_block)
        pulumi.set(__self__, "cloud_sql_ipv4_cidr_block", cloud_sql_ipv4_cidr_block)
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        pulumi.set(__self__, "enable_privately_used_public_ips", enable_privately_used_public_ips)
        pulumi.set(__self__, "master_ipv4_cidr_block", master_ipv4_cidr_block)
        pulumi.set(__self__, "web_server_ipv4_cidr_block", web_server_ipv4_cidr_block)

    @_builtins.property
    @pulumi.getter(name="cloudComposerConnectionSubnetwork")
    def cloud_composer_connection_subnetwork(self) -> _builtins.str:
        """
        When specified, the environment will use Private Service Connect instead of VPC peerings to connect to Cloud SQL in the Tenant Project, and the PSC endpoint in the Customer Project will use an IP address from this subnetwork. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "cloud_composer_connection_subnetwork")

    @_builtins.property
    @pulumi.getter(name="cloudComposerNetworkIpv4CidrBlock")
    def cloud_composer_network_ipv4_cidr_block(self) -> _builtins.str:
        """
        The CIDR block from which IP range for Cloud Composer Network in tenant project will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "cloud_composer_network_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="cloudSqlIpv4CidrBlock")
    def cloud_sql_ipv4_cidr_block(self) -> _builtins.str:
        """
        The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block.
        """
        return pulumi.get(self, "cloud_sql_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> _builtins.str:
        """
        Mode of internal communication within the Composer environment. Must be one of "VPC_PEERING" or "PRIVATE_SERVICE_CONNECT".
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> _builtins.bool:
        """
        If true, access to the public endpoint of the GKE cluster is denied. If this field is set to true, ip_allocation_policy.use_ip_aliases must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @_builtins.property
    @pulumi.getter(name="enablePrivatelyUsedPublicIps")
    def enable_privately_used_public_ips(self) -> _builtins.bool:
        """
        When enabled, IPs from public (non-RFC1918) ranges can be used for ip_allocation_policy.cluster_ipv4_cidr_block and ip_allocation_policy.service_ipv4_cidr_block.
        """
        return pulumi.get(self, "enable_privately_used_public_ips")

    @_builtins.property
    @pulumi.getter(name="masterIpv4CidrBlock")
    def master_ipv4_cidr_block(self) -> _builtins.str:
        """
        The IP range in CIDR notation to use for the hosted master network. This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network. If left blank, the default value of '172.16.0.0/28' is used.
        """
        return pulumi.get(self, "master_ipv4_cidr_block")

    @_builtins.property
    @pulumi.getter(name="webServerIpv4CidrBlock")
    def web_server_ipv4_cidr_block(self) -> _builtins.str:
        """
        The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "web_server_ipv4_cidr_block")


@pulumi.output_type
class GetEnvironmentConfigRecoveryConfigResult(dict):
    def __init__(__self__, *,
                 scheduled_snapshots_configs: Sequence['outputs.GetEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigResult']):
        """
        :param Sequence['GetEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgs'] scheduled_snapshots_configs: The configuration settings for scheduled snapshots.
        """
        pulumi.set(__self__, "scheduled_snapshots_configs", scheduled_snapshots_configs)

    @_builtins.property
    @pulumi.getter(name="scheduledSnapshotsConfigs")
    def scheduled_snapshots_configs(self) -> Sequence['outputs.GetEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigResult']:
        """
        The configuration settings for scheduled snapshots.
        """
        return pulumi.get(self, "scheduled_snapshots_configs")


@pulumi.output_type
class GetEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 snapshot_creation_schedule: _builtins.str,
                 snapshot_location: _builtins.str,
                 time_zone: _builtins.str):
        """
        :param _builtins.bool enabled: When enabled, Cloud Composer periodically saves snapshots of your environment to a Cloud Storage bucket.
        :param _builtins.str snapshot_creation_schedule: Snapshot schedule, in the unix-cron format.
        :param _builtins.str snapshot_location: the URI of a bucket folder where to save the snapshot.
        :param _builtins.str time_zone: A time zone for the schedule. This value is a time offset and does not take into account daylight saving time changes. Valid values are from UTC-12 to UTC+12. Examples: UTC, UTC-01, UTC+03.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "snapshot_creation_schedule", snapshot_creation_schedule)
        pulumi.set(__self__, "snapshot_location", snapshot_location)
        pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        When enabled, Cloud Composer periodically saves snapshots of your environment to a Cloud Storage bucket.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="snapshotCreationSchedule")
    def snapshot_creation_schedule(self) -> _builtins.str:
        """
        Snapshot schedule, in the unix-cron format.
        """
        return pulumi.get(self, "snapshot_creation_schedule")

    @_builtins.property
    @pulumi.getter(name="snapshotLocation")
    def snapshot_location(self) -> _builtins.str:
        """
        the URI of a bucket folder where to save the snapshot.
        """
        return pulumi.get(self, "snapshot_location")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        A time zone for the schedule. This value is a time offset and does not take into account daylight saving time changes. Valid values are from UTC-12 to UTC+12. Examples: UTC, UTC-01, UTC+03.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GetEnvironmentConfigSoftwareConfigResult(dict):
    def __init__(__self__, *,
                 airflow_config_overrides: Mapping[str, _builtins.str],
                 cloud_data_lineage_integrations: Sequence['outputs.GetEnvironmentConfigSoftwareConfigCloudDataLineageIntegrationResult'],
                 env_variables: Mapping[str, _builtins.str],
                 image_version: _builtins.str,
                 pypi_packages: Mapping[str, _builtins.str],
                 python_version: _builtins.str,
                 scheduler_count: _builtins.int,
                 web_server_plugins_mode: _builtins.str):
        """
        :param Mapping[str, _builtins.str] airflow_config_overrides: Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and cannot contain "=" or ";". Section and property names cannot contain characters: "." Apache Airflow configuration property names must be written in snake_case. Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are blacklisted, and cannot be overridden.
        :param Sequence['GetEnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgs'] cloud_data_lineage_integrations: The configuration for Cloud Data Lineage integration. Supported for Cloud Composer environments in versions composer-2.1.2-airflow-*.*.* and newer
        :param Mapping[str, _builtins.str] env_variables: Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression [a-zA-Z_][a-zA-Z0-9_]*. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+), and they cannot match any of the following reserved names: AIRFLOW_HOME C_FORCE_ROOT CONTAINER_NAME DAGS_FOLDER GCP_PROJECT GCS_BUCKET GKE_CLUSTER_NAME SQL_DATABASE SQL_INSTANCE SQL_PASSWORD SQL_PROJECT SQL_REGION SQL_USER.
        :param _builtins.str image_version: The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression composer-([0-9]+(\\.[0-9]+\\.[0-9]+(-preview\\.[0-9]+)?)?|latest)-airflow-([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?). The Cloud Composer portion of the image version is a full semantic version, or an alias in the form of major version number or 'latest'. The Apache Airflow portion of the image version is a full semantic version that points to one of the supported Apache Airflow versions, or an alias in the form of only major or major.minor versions specified. See documentation for more details and version list.
        :param Mapping[str, _builtins.str] pypi_packages: Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name (e.g. "numpy"). Values are the lowercase extras and version specifier (e.g. "==1.12.0", "[devel,gcp_api]", "[devel]>=1.8.2, <1.9.2"). To specify a package without pinning it to a version specifier, use the empty string as the value.
        :param _builtins.str python_version: The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
        :param _builtins.int scheduler_count: The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
        :param _builtins.str web_server_plugins_mode: Should be either 'ENABLED' or 'DISABLED'. Defaults to 'ENABLED'. Used in Composer 3.
        """
        pulumi.set(__self__, "airflow_config_overrides", airflow_config_overrides)
        pulumi.set(__self__, "cloud_data_lineage_integrations", cloud_data_lineage_integrations)
        pulumi.set(__self__, "env_variables", env_variables)
        pulumi.set(__self__, "image_version", image_version)
        pulumi.set(__self__, "pypi_packages", pypi_packages)
        pulumi.set(__self__, "python_version", python_version)
        pulumi.set(__self__, "scheduler_count", scheduler_count)
        pulumi.set(__self__, "web_server_plugins_mode", web_server_plugins_mode)

    @_builtins.property
    @pulumi.getter(name="airflowConfigOverrides")
    def airflow_config_overrides(self) -> Mapping[str, _builtins.str]:
        """
        Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and cannot contain "=" or ";". Section and property names cannot contain characters: "." Apache Airflow configuration property names must be written in snake_case. Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are blacklisted, and cannot be overridden.
        """
        return pulumi.get(self, "airflow_config_overrides")

    @_builtins.property
    @pulumi.getter(name="cloudDataLineageIntegrations")
    def cloud_data_lineage_integrations(self) -> Sequence['outputs.GetEnvironmentConfigSoftwareConfigCloudDataLineageIntegrationResult']:
        """
        The configuration for Cloud Data Lineage integration. Supported for Cloud Composer environments in versions composer-2.1.2-airflow-*.*.* and newer
        """
        return pulumi.get(self, "cloud_data_lineage_integrations")

    @_builtins.property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Mapping[str, _builtins.str]:
        """
        Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression [a-zA-Z_][a-zA-Z0-9_]*. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+), and they cannot match any of the following reserved names: AIRFLOW_HOME C_FORCE_ROOT CONTAINER_NAME DAGS_FOLDER GCP_PROJECT GCS_BUCKET GKE_CLUSTER_NAME SQL_DATABASE SQL_INSTANCE SQL_PASSWORD SQL_PROJECT SQL_REGION SQL_USER.
        """
        return pulumi.get(self, "env_variables")

    @_builtins.property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> _builtins.str:
        """
        The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression composer-([0-9]+(\\.[0-9]+\\.[0-9]+(-preview\\.[0-9]+)?)?|latest)-airflow-([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?). The Cloud Composer portion of the image version is a full semantic version, or an alias in the form of major version number or 'latest'. The Apache Airflow portion of the image version is a full semantic version that points to one of the supported Apache Airflow versions, or an alias in the form of only major or major.minor versions specified. See documentation for more details and version list.
        """
        return pulumi.get(self, "image_version")

    @_builtins.property
    @pulumi.getter(name="pypiPackages")
    def pypi_packages(self) -> Mapping[str, _builtins.str]:
        """
        Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name (e.g. "numpy"). Values are the lowercase extras and version specifier (e.g. "==1.12.0", "[devel,gcp_api]", "[devel]>=1.8.2, <1.9.2"). To specify a package without pinning it to a version specifier, use the empty string as the value.
        """
        return pulumi.get(self, "pypi_packages")

    @_builtins.property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> _builtins.str:
        """
        The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
        """
        return pulumi.get(self, "python_version")

    @_builtins.property
    @pulumi.getter(name="schedulerCount")
    def scheduler_count(self) -> _builtins.int:
        """
        The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
        """
        return pulumi.get(self, "scheduler_count")

    @_builtins.property
    @pulumi.getter(name="webServerPluginsMode")
    def web_server_plugins_mode(self) -> _builtins.str:
        """
        Should be either 'ENABLED' or 'DISABLED'. Defaults to 'ENABLED'. Used in Composer 3.
        """
        return pulumi.get(self, "web_server_plugins_mode")


@pulumi.output_type
class GetEnvironmentConfigSoftwareConfigCloudDataLineageIntegrationResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Whether or not Cloud Data Lineage integration is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether or not Cloud Data Lineage integration is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetEnvironmentConfigWebServerConfigResult(dict):
    def __init__(__self__, *,
                 machine_type: _builtins.str):
        """
        :param _builtins.str machine_type: Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        pulumi.set(__self__, "machine_type", machine_type)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> _builtins.str:
        """
        Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        return pulumi.get(self, "machine_type")


@pulumi.output_type
class GetEnvironmentConfigWebServerNetworkAccessControlResult(dict):
    def __init__(__self__, *,
                 allowed_ip_ranges: Sequence['outputs.GetEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeResult']):
        """
        :param Sequence['GetEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgs'] allowed_ip_ranges: A collection of allowed IP ranges with descriptions.
        """
        pulumi.set(__self__, "allowed_ip_ranges", allowed_ip_ranges)

    @_builtins.property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> Sequence['outputs.GetEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeResult']:
        """
        A collection of allowed IP ranges with descriptions.
        """
        return pulumi.get(self, "allowed_ip_ranges")


@pulumi.output_type
class GetEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str description: A description of this ip range.
        :param _builtins.str value: IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. IP range prefixes should be properly truncated. For example, 1.2.3.4/24 should be truncated to 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 should be truncated to 2001:db8::/32.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of this ip range.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. IP range prefixes should be properly truncated. For example, 1.2.3.4/24 should be truncated to 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 should be truncated to 2001:db8::/32.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetEnvironmentConfigWorkloadsConfigResult(dict):
    def __init__(__self__, *,
                 dag_processors: Sequence['outputs.GetEnvironmentConfigWorkloadsConfigDagProcessorResult'],
                 schedulers: Sequence['outputs.GetEnvironmentConfigWorkloadsConfigSchedulerResult'],
                 triggerers: Sequence['outputs.GetEnvironmentConfigWorkloadsConfigTriggererResult'],
                 web_servers: Sequence['outputs.GetEnvironmentConfigWorkloadsConfigWebServerResult'],
                 workers: Sequence['outputs.GetEnvironmentConfigWorkloadsConfigWorkerResult']):
        """
        :param Sequence['GetEnvironmentConfigWorkloadsConfigDagProcessorArgs'] dag_processors: Configuration for resources used by DAG processor.
        :param Sequence['GetEnvironmentConfigWorkloadsConfigSchedulerArgs'] schedulers: Configuration for resources used by Airflow schedulers.
        :param Sequence['GetEnvironmentConfigWorkloadsConfigTriggererArgs'] triggerers: Configuration for resources used by Airflow triggerers.
        :param Sequence['GetEnvironmentConfigWorkloadsConfigWebServerArgs'] web_servers: Configuration for resources used by Airflow web server.
        :param Sequence['GetEnvironmentConfigWorkloadsConfigWorkerArgs'] workers: Configuration for resources used by Airflow workers.
        """
        pulumi.set(__self__, "dag_processors", dag_processors)
        pulumi.set(__self__, "schedulers", schedulers)
        pulumi.set(__self__, "triggerers", triggerers)
        pulumi.set(__self__, "web_servers", web_servers)
        pulumi.set(__self__, "workers", workers)

    @_builtins.property
    @pulumi.getter(name="dagProcessors")
    def dag_processors(self) -> Sequence['outputs.GetEnvironmentConfigWorkloadsConfigDagProcessorResult']:
        """
        Configuration for resources used by DAG processor.
        """
        return pulumi.get(self, "dag_processors")

    @_builtins.property
    @pulumi.getter
    def schedulers(self) -> Sequence['outputs.GetEnvironmentConfigWorkloadsConfigSchedulerResult']:
        """
        Configuration for resources used by Airflow schedulers.
        """
        return pulumi.get(self, "schedulers")

    @_builtins.property
    @pulumi.getter
    def triggerers(self) -> Sequence['outputs.GetEnvironmentConfigWorkloadsConfigTriggererResult']:
        """
        Configuration for resources used by Airflow triggerers.
        """
        return pulumi.get(self, "triggerers")

    @_builtins.property
    @pulumi.getter(name="webServers")
    def web_servers(self) -> Sequence['outputs.GetEnvironmentConfigWorkloadsConfigWebServerResult']:
        """
        Configuration for resources used by Airflow web server.
        """
        return pulumi.get(self, "web_servers")

    @_builtins.property
    @pulumi.getter
    def workers(self) -> Sequence['outputs.GetEnvironmentConfigWorkloadsConfigWorkerResult']:
        """
        Configuration for resources used by Airflow workers.
        """
        return pulumi.get(self, "workers")


@pulumi.output_type
class GetEnvironmentConfigWorkloadsConfigDagProcessorResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 cpu: _builtins.float,
                 memory_gb: _builtins.float,
                 storage_gb: _builtins.float):
        """
        :param _builtins.int count: Number of DAG processors.
        :param _builtins.float cpu: CPU request and limit for DAG processor.
        :param _builtins.float memory_gb: Memory (GB) request and limit for DAG processor.
        :param _builtins.float storage_gb: Storage (GB) request and limit for DAG processor.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory_gb", memory_gb)
        pulumi.set(__self__, "storage_gb", storage_gb)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        Number of DAG processors.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        CPU request and limit for DAG processor.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> _builtins.float:
        """
        Memory (GB) request and limit for DAG processor.
        """
        return pulumi.get(self, "memory_gb")

    @_builtins.property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> _builtins.float:
        """
        Storage (GB) request and limit for DAG processor.
        """
        return pulumi.get(self, "storage_gb")


@pulumi.output_type
class GetEnvironmentConfigWorkloadsConfigSchedulerResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 cpu: _builtins.float,
                 memory_gb: _builtins.float,
                 storage_gb: _builtins.float):
        """
        :param _builtins.int count: The number of schedulers.
        :param _builtins.float cpu: CPU request and limit for a single Airflow scheduler replica
        :param _builtins.float memory_gb: Memory (GB) request and limit for a single Airflow scheduler replica.
        :param _builtins.float storage_gb: Storage (GB) request and limit for a single Airflow scheduler replica.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory_gb", memory_gb)
        pulumi.set(__self__, "storage_gb", storage_gb)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The number of schedulers.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        CPU request and limit for a single Airflow scheduler replica
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> _builtins.float:
        """
        Memory (GB) request and limit for a single Airflow scheduler replica.
        """
        return pulumi.get(self, "memory_gb")

    @_builtins.property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> _builtins.float:
        """
        Storage (GB) request and limit for a single Airflow scheduler replica.
        """
        return pulumi.get(self, "storage_gb")


@pulumi.output_type
class GetEnvironmentConfigWorkloadsConfigTriggererResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 cpu: _builtins.float,
                 memory_gb: _builtins.float):
        """
        :param _builtins.int count: The number of triggerers.
        :param _builtins.float cpu: CPU request and limit for a single Airflow triggerer replica.
        :param _builtins.float memory_gb: Memory (GB) request and limit for a single Airflow triggerer replica.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory_gb", memory_gb)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The number of triggerers.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        CPU request and limit for a single Airflow triggerer replica.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> _builtins.float:
        """
        Memory (GB) request and limit for a single Airflow triggerer replica.
        """
        return pulumi.get(self, "memory_gb")


@pulumi.output_type
class GetEnvironmentConfigWorkloadsConfigWebServerResult(dict):
    def __init__(__self__, *,
                 cpu: _builtins.float,
                 memory_gb: _builtins.float,
                 storage_gb: _builtins.float):
        """
        :param _builtins.float cpu: CPU request and limit for Airflow web server.
        :param _builtins.float memory_gb: Memory (GB) request and limit for Airflow web server.
        :param _builtins.float storage_gb: Storage (GB) request and limit for Airflow web server.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory_gb", memory_gb)
        pulumi.set(__self__, "storage_gb", storage_gb)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        CPU request and limit for Airflow web server.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> _builtins.float:
        """
        Memory (GB) request and limit for Airflow web server.
        """
        return pulumi.get(self, "memory_gb")

    @_builtins.property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> _builtins.float:
        """
        Storage (GB) request and limit for Airflow web server.
        """
        return pulumi.get(self, "storage_gb")


@pulumi.output_type
class GetEnvironmentConfigWorkloadsConfigWorkerResult(dict):
    def __init__(__self__, *,
                 cpu: _builtins.float,
                 max_count: _builtins.int,
                 memory_gb: _builtins.float,
                 min_count: _builtins.int,
                 storage_gb: _builtins.float):
        """
        :param _builtins.float cpu: CPU request and limit for a single Airflow worker replica.
        :param _builtins.int max_count: Maximum number of workers for autoscaling.
        :param _builtins.float memory_gb: Memory (GB) request and limit for a single Airflow worker replica.
        :param _builtins.int min_count: Minimum number of workers for autoscaling.
        :param _builtins.float storage_gb: Storage (GB) request and limit for a single Airflow worker replica.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "max_count", max_count)
        pulumi.set(__self__, "memory_gb", memory_gb)
        pulumi.set(__self__, "min_count", min_count)
        pulumi.set(__self__, "storage_gb", storage_gb)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        CPU request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> _builtins.int:
        """
        Maximum number of workers for autoscaling.
        """
        return pulumi.get(self, "max_count")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> _builtins.float:
        """
        Memory (GB) request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "memory_gb")

    @_builtins.property
    @pulumi.getter(name="minCount")
    def min_count(self) -> _builtins.int:
        """
        Minimum number of workers for autoscaling.
        """
        return pulumi.get(self, "min_count")

    @_builtins.property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> _builtins.float:
        """
        Storage (GB) request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "storage_gb")


@pulumi.output_type
class GetEnvironmentStorageConfigResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str):
        """
        :param _builtins.str bucket: Optional. Name of an existing Cloud Storage bucket to be used by the environment.
        """
        pulumi.set(__self__, "bucket", bucket)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Optional. Name of an existing Cloud Storage bucket to be used by the environment.
        """
        return pulumi.get(self, "bucket")


@pulumi.output_type
class GetImageVersionsImageVersionResult(dict):
    def __init__(__self__, *,
                 image_version_id: _builtins.str,
                 supported_python_versions: Sequence[_builtins.str]):
        """
        :param _builtins.str image_version_id: The string identifier of the image version, in the form: "composer-x.y.z-airflow-a.b.c"
        :param Sequence[_builtins.str] supported_python_versions: Supported python versions for this image version
        """
        pulumi.set(__self__, "image_version_id", image_version_id)
        pulumi.set(__self__, "supported_python_versions", supported_python_versions)

    @_builtins.property
    @pulumi.getter(name="imageVersionId")
    def image_version_id(self) -> _builtins.str:
        """
        The string identifier of the image version, in the form: "composer-x.y.z-airflow-a.b.c"
        """
        return pulumi.get(self, "image_version_id")

    @_builtins.property
    @pulumi.getter(name="supportedPythonVersions")
    def supported_python_versions(self) -> Sequence[_builtins.str]:
        """
        Supported python versions for this image version
        """
        return pulumi.get(self, "supported_python_versions")


