# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetHcVpnGatewayResult',
    'AwaitableGetHcVpnGatewayResult',
    'get_hc_vpn_gateway',
    'get_hc_vpn_gateway_output',
]

@pulumi.output_type
class GetHcVpnGatewayResult:
    """
    A collection of values returned by getHcVpnGateway.
    """
    def __init__(__self__, description=None, effective_labels=None, gateway_ip_version=None, id=None, label_fingerprint=None, labels=None, name=None, network=None, project=None, pulumi_labels=None, region=None, self_link=None, stack_type=None, vpn_interfaces=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if gateway_ip_version and not isinstance(gateway_ip_version, str):
            raise TypeError("Expected argument 'gateway_ip_version' to be a str")
        pulumi.set(__self__, "gateway_ip_version", gateway_ip_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label_fingerprint and not isinstance(label_fingerprint, str):
            raise TypeError("Expected argument 'label_fingerprint' to be a str")
        pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, str):
            raise TypeError("Expected argument 'network' to be a str")
        pulumi.set(__self__, "network", network)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if stack_type and not isinstance(stack_type, str):
            raise TypeError("Expected argument 'stack_type' to be a str")
        pulumi.set(__self__, "stack_type", stack_type)
        if vpn_interfaces and not isinstance(vpn_interfaces, list):
            raise TypeError("Expected argument 'vpn_interfaces' to be a list")
        pulumi.set(__self__, "vpn_interfaces", vpn_interfaces)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="gatewayIpVersion")
    def gateway_ip_version(self) -> _builtins.str:
        return pulumi.get(self, "gateway_ip_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> _builtins.str:
        return pulumi.get(self, "label_fingerprint")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> _builtins.str:
        return pulumi.get(self, "stack_type")

    @_builtins.property
    @pulumi.getter(name="vpnInterfaces")
    def vpn_interfaces(self) -> Sequence['outputs.GetHcVpnGatewayVpnInterfaceResult']:
        return pulumi.get(self, "vpn_interfaces")


class AwaitableGetHcVpnGatewayResult(GetHcVpnGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHcVpnGatewayResult(
            description=self.description,
            effective_labels=self.effective_labels,
            gateway_ip_version=self.gateway_ip_version,
            id=self.id,
            label_fingerprint=self.label_fingerprint,
            labels=self.labels,
            name=self.name,
            network=self.network,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            region=self.region,
            self_link=self.self_link,
            stack_type=self.stack_type,
            vpn_interfaces=self.vpn_interfaces)


def get_hc_vpn_gateway(name: Optional[_builtins.str] = None,
                       project: Optional[_builtins.str] = None,
                       region: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHcVpnGatewayResult:
    """
    Get a HA VPN Gateway within GCE from its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    gateway = gcp.compute.get_hc_vpn_gateway(name="foobar")
    ```


    :param _builtins.str name: The name of the forwarding rule.
           
           
           - - -
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param _builtins.str region: The region in which the resource belongs. If it
           is not provided, the project region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getHcVpnGateway:getHcVpnGateway', __args__, opts=opts, typ=GetHcVpnGatewayResult).value

    return AwaitableGetHcVpnGatewayResult(
        description=pulumi.get(__ret__, 'description'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        gateway_ip_version=pulumi.get(__ret__, 'gateway_ip_version'),
        id=pulumi.get(__ret__, 'id'),
        label_fingerprint=pulumi.get(__ret__, 'label_fingerprint'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        network=pulumi.get(__ret__, 'network'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        region=pulumi.get(__ret__, 'region'),
        self_link=pulumi.get(__ret__, 'self_link'),
        stack_type=pulumi.get(__ret__, 'stack_type'),
        vpn_interfaces=pulumi.get(__ret__, 'vpn_interfaces'))
def get_hc_vpn_gateway_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                              project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHcVpnGatewayResult]:
    """
    Get a HA VPN Gateway within GCE from its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    gateway = gcp.compute.get_hc_vpn_gateway(name="foobar")
    ```


    :param _builtins.str name: The name of the forwarding rule.
           
           
           - - -
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param _builtins.str region: The region in which the resource belongs. If it
           is not provided, the project region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getHcVpnGateway:getHcVpnGateway', __args__, opts=opts, typ=GetHcVpnGatewayResult)
    return __ret__.apply(lambda __response__: GetHcVpnGatewayResult(
        description=pulumi.get(__response__, 'description'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        gateway_ip_version=pulumi.get(__response__, 'gateway_ip_version'),
        id=pulumi.get(__response__, 'id'),
        label_fingerprint=pulumi.get(__response__, 'label_fingerprint'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        network=pulumi.get(__response__, 'network'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        region=pulumi.get(__response__, 'region'),
        self_link=pulumi.get(__response__, 'self_link'),
        stack_type=pulumi.get(__response__, 'stack_type'),
        vpn_interfaces=pulumi.get(__response__, 'vpn_interfaces')))
