# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionInstanceTemplateArgs', 'RegionInstanceTemplate']

@pulumi.input_type
class RegionInstanceTemplateArgs:
    def __init__(__self__, *,
                 disks: pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateDiskArgs']]],
                 machine_type: pulumi.Input[_builtins.str],
                 advanced_machine_features: Optional[pulumi.Input['RegionInstanceTemplateAdvancedMachineFeaturesArgs']] = None,
                 can_ip_forward: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input['RegionInstanceTemplateConfidentialInstanceConfigArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_display: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateGuestAcceleratorArgs']]]] = None,
                 instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_revocation_action_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[_builtins.str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateNetworkInterfaceArgs']]]] = None,
                 network_performance_config: Optional[pulumi.Input['RegionInstanceTemplateNetworkPerformanceConfigArgs']] = None,
                 partner_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_affinity: Optional[pulumi.Input['RegionInstanceTemplateReservationAffinityArgs']] = None,
                 resource_manager_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling: Optional[pulumi.Input['RegionInstanceTemplateSchedulingArgs']] = None,
                 service_account: Optional[pulumi.Input['RegionInstanceTemplateServiceAccountArgs']] = None,
                 shielded_instance_config: Optional[pulumi.Input['RegionInstanceTemplateShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RegionInstanceTemplate resource.
        :param pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateDiskArgs']]] disks: Disks to attach to instances created from this template.
               This can be specified multiple times for multiple disks. Structure is
               documented below.
        :param pulumi.Input[_builtins.str] machine_type: The machine type to create.
               
               To create a machine with a [custom type](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) (such as extended memory), format the value like `custom-VCPUS-MEM_IN_MB` like `custom-6-20480` for 6 vCPU and 20GB of RAM.
               
               - - -
        :param pulumi.Input['RegionInstanceTemplateAdvancedMachineFeaturesArgs'] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        :param pulumi.Input[_builtins.bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs. This defaults to false.
        :param pulumi.Input['RegionInstanceTemplateConfidentialInstanceConfigArgs'] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[_builtins.str] description: A brief description of this resource.
        :param pulumi.Input[_builtins.bool] enable_display: Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateGuestAcceleratorArgs']]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
        :param pulumi.Input[_builtins.str] instance_description: A brief description to use for instances
               created from this template.
        :param pulumi.Input[_builtins.str] key_revocation_action_type: Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to instances
               created from this template.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key/value pairs to make available from
               within instances created from this template.
        :param pulumi.Input[_builtins.str] metadata_startup_script: An alternative to using the
               startup-script metadata key, mostly to match the compute_instance resource.
               This replaces the startup-script metadata key on the created instance and
               thus the two mechanisms are not allowed to be used simultaneously.
        :param pulumi.Input[_builtins.str] min_cpu_platform: Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`. Max length is 54 characters.
               Prefixes with lengths longer than 37 characters will use a shortened
               UUID that will be more prone to collisions.
               
               Resulting name for a `name_prefix` <= 37 characters:
               `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
               Resulting name for a `name_prefix` 38 - 54 characters:
               `name_prefix` + YYmmdd + 3 digit incremental counter
        :param pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateNetworkInterfaceArgs']]] network_interfaces: Networks to attach to instances created from
               this template. This can be specified multiple times for multiple networks.
               Structure is documented below.
        :param pulumi.Input['RegionInstanceTemplateNetworkPerformanceConfigArgs'] network_performance_config: Configures network performance settings for the instance created from the
               template. Structure is documented below. **Note**: `machine_type`
               must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] partner_metadata: Beta key/value pair represents partner metadata assigned to instance template where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The Region in which the resource belongs.
               If region is not provided, the provider region is used.
        :param pulumi.Input['RegionInstanceTemplateReservationAffinityArgs'] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_manager_tags: A set of key/value resource manager tag pairs to bind to the instance. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456.
        :param pulumi.Input[_builtins.str] resource_policies: - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        :param pulumi.Input['RegionInstanceTemplateSchedulingArgs'] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input['RegionInstanceTemplateServiceAccountArgs'] service_account: Service account to attach to the instance. Structure is documented below.
        :param pulumi.Input['RegionInstanceTemplateShieldedInstanceConfigArgs'] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to attach to the instance.
        """
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "machine_type", machine_type)
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_display is not None:
            pulumi.set(__self__, "enable_display", enable_display)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if instance_description is not None:
            pulumi.set(__self__, "instance_description", instance_description)
        if key_revocation_action_type is not None:
            pulumi.set(__self__, "key_revocation_action_type", key_revocation_action_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_startup_script is not None:
            pulumi.set(__self__, "metadata_startup_script", metadata_startup_script)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_performance_config is not None:
            pulumi.set(__self__, "network_performance_config", network_performance_config)
        if partner_metadata is not None:
            pulumi.set(__self__, "partner_metadata", partner_metadata)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if resource_manager_tags is not None:
            pulumi.set(__self__, "resource_manager_tags", resource_manager_tags)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateDiskArgs']]]:
        """
        Disks to attach to instances created from this template.
        This can be specified multiple times for multiple disks. Structure is
        documented below.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateDiskArgs']]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Input[_builtins.str]:
        """
        The machine type to create.

        To create a machine with a [custom type](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) (such as extended memory), format the value like `custom-VCPUS-MEM_IN_MB` like `custom-6-20480` for 6 vCPU and 20GB of RAM.

        - - -
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional[pulumi.Input['RegionInstanceTemplateAdvancedMachineFeaturesArgs']]:
        """
        Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        """
        return pulumi.get(self, "advanced_machine_features")

    @advanced_machine_features.setter
    def advanced_machine_features(self, value: Optional[pulumi.Input['RegionInstanceTemplateAdvancedMachineFeaturesArgs']]):
        pulumi.set(self, "advanced_machine_features", value)

    @_builtins.property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow sending and receiving of
        packets with non-matching source or destination IPs. This defaults to false.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @_builtins.property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional[pulumi.Input['RegionInstanceTemplateConfidentialInstanceConfigArgs']]:
        """
        Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        """
        return pulumi.get(self, "confidential_instance_config")

    @confidential_instance_config.setter
    def confidential_instance_config(self, value: Optional[pulumi.Input['RegionInstanceTemplateConfidentialInstanceConfigArgs']]):
        pulumi.set(self, "confidential_instance_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A brief description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
        **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        """
        return pulumi.get(self, "enable_display")

    @enable_display.setter
    def enable_display(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_display", value)

    @_builtins.property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateGuestAcceleratorArgs']]]]:
        """
        List of the type and count of accelerator cards attached to the instance. Structure documented below.
        """
        return pulumi.get(self, "guest_accelerators")

    @guest_accelerators.setter
    def guest_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateGuestAcceleratorArgs']]]]):
        pulumi.set(self, "guest_accelerators", value)

    @_builtins.property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A brief description to use for instances
        created from this template.
        """
        return pulumi.get(self, "instance_description")

    @instance_description.setter
    def instance_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_description", value)

    @_builtins.property
    @pulumi.getter(name="keyRevocationActionType")
    def key_revocation_action_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        """
        return pulumi.get(self, "key_revocation_action_type")

    @key_revocation_action_type.setter
    def key_revocation_action_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_revocation_action_type", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to instances
        created from this template.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata key/value pairs to make available from
        within instances created from this template.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An alternative to using the
        startup-script metadata key, mostly to match the compute_instance resource.
        This replaces the startup-script metadata key on the created instance and
        thus the two mechanisms are not allowed to be used simultaneously.
        """
        return pulumi.get(self, "metadata_startup_script")

    @metadata_startup_script.setter
    def metadata_startup_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata_startup_script", value)

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
        `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`. Max length is 54 characters.
        Prefixes with lengths longer than 37 characters will use a shortened
        UUID that will be more prone to collisions.

        Resulting name for a `name_prefix` <= 37 characters:
        `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
        Resulting name for a `name_prefix` 38 - 54 characters:
        `name_prefix` + YYmmdd + 3 digit incremental counter
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateNetworkInterfaceArgs']]]]:
        """
        Networks to attach to instances created from
        this template. This can be specified multiple times for multiple networks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> Optional[pulumi.Input['RegionInstanceTemplateNetworkPerformanceConfigArgs']]:
        """
        Configures network performance settings for the instance created from the
        template. Structure is documented below. **Note**: `machine_type`
        must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
        the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
        in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
        in order for this setting to take effect.
        """
        return pulumi.get(self, "network_performance_config")

    @network_performance_config.setter
    def network_performance_config(self, value: Optional[pulumi.Input['RegionInstanceTemplateNetworkPerformanceConfigArgs']]):
        pulumi.set(self, "network_performance_config", value)

    @_builtins.property
    @pulumi.getter(name="partnerMetadata")
    def partner_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Beta key/value pair represents partner metadata assigned to instance template where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        """
        return pulumi.get(self, "partner_metadata")

    @partner_metadata.setter
    def partner_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "partner_metadata", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Region in which the resource belongs.
        If region is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['RegionInstanceTemplateReservationAffinityArgs']]:
        """
        Specifies the reservations that this instance can consume from.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['RegionInstanceTemplateReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @_builtins.property
    @pulumi.getter(name="resourceManagerTags")
    def resource_manager_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value resource manager tag pairs to bind to the instance. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456.
        """
        return pulumi.get(self, "resource_manager_tags")

    @resource_manager_tags.setter
    def resource_manager_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_manager_tags", value)

    @_builtins.property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_policies", value)

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['RegionInstanceTemplateSchedulingArgs']]:
        """
        The scheduling strategy to use. More details about
        this configuration option are detailed below.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['RegionInstanceTemplateSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['RegionInstanceTemplateServiceAccountArgs']]:
        """
        Service account to attach to the instance. Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['RegionInstanceTemplateServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['RegionInstanceTemplateShieldedInstanceConfigArgs']]:
        """
        Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
        **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['RegionInstanceTemplateShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to attach to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RegionInstanceTemplateState:
    def __init__(__self__, *,
                 advanced_machine_features: Optional[pulumi.Input['RegionInstanceTemplateAdvancedMachineFeaturesArgs']] = None,
                 can_ip_forward: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input['RegionInstanceTemplateConfidentialInstanceConfigArgs']] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateDiskArgs']]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enable_display: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateGuestAcceleratorArgs']]]] = None,
                 instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_revocation_action_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_startup_script: Optional[pulumi.Input[_builtins.str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateNetworkInterfaceArgs']]]] = None,
                 network_performance_config: Optional[pulumi.Input['RegionInstanceTemplateNetworkPerformanceConfigArgs']] = None,
                 numeric_id: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_affinity: Optional[pulumi.Input['RegionInstanceTemplateReservationAffinityArgs']] = None,
                 resource_manager_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling: Optional[pulumi.Input['RegionInstanceTemplateSchedulingArgs']] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input['RegionInstanceTemplateServiceAccountArgs']] = None,
                 shielded_instance_config: Optional[pulumi.Input['RegionInstanceTemplateShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags_fingerprint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegionInstanceTemplate resources.
        :param pulumi.Input['RegionInstanceTemplateAdvancedMachineFeaturesArgs'] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        :param pulumi.Input[_builtins.bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs. This defaults to false.
        :param pulumi.Input['RegionInstanceTemplateConfidentialInstanceConfigArgs'] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: A brief description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateDiskArgs']]] disks: Disks to attach to instances created from this template.
               This can be specified multiple times for multiple disks. Structure is
               documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.bool] enable_display: Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateGuestAcceleratorArgs']]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
        :param pulumi.Input[_builtins.str] instance_description: A brief description to use for instances
               created from this template.
        :param pulumi.Input[_builtins.str] key_revocation_action_type: Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to instances
               created from this template.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] machine_type: The machine type to create.
               
               To create a machine with a [custom type](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) (such as extended memory), format the value like `custom-VCPUS-MEM_IN_MB` like `custom-6-20480` for 6 vCPU and 20GB of RAM.
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key/value pairs to make available from
               within instances created from this template.
        :param pulumi.Input[_builtins.str] metadata_fingerprint: The unique fingerprint of the metadata.
        :param pulumi.Input[_builtins.str] metadata_startup_script: An alternative to using the
               startup-script metadata key, mostly to match the compute_instance resource.
               This replaces the startup-script metadata key on the created instance and
               thus the two mechanisms are not allowed to be used simultaneously.
        :param pulumi.Input[_builtins.str] min_cpu_platform: Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`. Max length is 54 characters.
               Prefixes with lengths longer than 37 characters will use a shortened
               UUID that will be more prone to collisions.
               
               Resulting name for a `name_prefix` <= 37 characters:
               `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
               Resulting name for a `name_prefix` 38 - 54 characters:
               `name_prefix` + YYmmdd + 3 digit incremental counter
        :param pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateNetworkInterfaceArgs']]] network_interfaces: Networks to attach to instances created from
               this template. This can be specified multiple times for multiple networks.
               Structure is documented below.
        :param pulumi.Input['RegionInstanceTemplateNetworkPerformanceConfigArgs'] network_performance_config: Configures network performance settings for the instance created from the
               template. Structure is documented below. **Note**: `machine_type`
               must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input[_builtins.str] numeric_id: numeric identifier of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] partner_metadata: Beta key/value pair represents partner metadata assigned to instance template where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: The Region in which the resource belongs.
               If region is not provided, the provider region is used.
        :param pulumi.Input['RegionInstanceTemplateReservationAffinityArgs'] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_manager_tags: A set of key/value resource manager tag pairs to bind to the instance. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456.
        :param pulumi.Input[_builtins.str] resource_policies: - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        :param pulumi.Input['RegionInstanceTemplateSchedulingArgs'] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input['RegionInstanceTemplateServiceAccountArgs'] service_account: Service account to attach to the instance. Structure is documented below.
        :param pulumi.Input['RegionInstanceTemplateShieldedInstanceConfigArgs'] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to attach to the instance.
        :param pulumi.Input[_builtins.str] tags_fingerprint: The unique fingerprint of the tags.
        """
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_display is not None:
            pulumi.set(__self__, "enable_display", enable_display)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if instance_description is not None:
            pulumi.set(__self__, "instance_description", instance_description)
        if key_revocation_action_type is not None:
            pulumi.set(__self__, "key_revocation_action_type", key_revocation_action_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_fingerprint is not None:
            pulumi.set(__self__, "metadata_fingerprint", metadata_fingerprint)
        if metadata_startup_script is not None:
            pulumi.set(__self__, "metadata_startup_script", metadata_startup_script)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_performance_config is not None:
            pulumi.set(__self__, "network_performance_config", network_performance_config)
        if numeric_id is not None:
            pulumi.set(__self__, "numeric_id", numeric_id)
        if partner_metadata is not None:
            pulumi.set(__self__, "partner_metadata", partner_metadata)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if resource_manager_tags is not None:
            pulumi.set(__self__, "resource_manager_tags", resource_manager_tags)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_fingerprint is not None:
            pulumi.set(__self__, "tags_fingerprint", tags_fingerprint)

    @_builtins.property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional[pulumi.Input['RegionInstanceTemplateAdvancedMachineFeaturesArgs']]:
        """
        Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        """
        return pulumi.get(self, "advanced_machine_features")

    @advanced_machine_features.setter
    def advanced_machine_features(self, value: Optional[pulumi.Input['RegionInstanceTemplateAdvancedMachineFeaturesArgs']]):
        pulumi.set(self, "advanced_machine_features", value)

    @_builtins.property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow sending and receiving of
        packets with non-matching source or destination IPs. This defaults to false.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @_builtins.property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional[pulumi.Input['RegionInstanceTemplateConfidentialInstanceConfigArgs']]:
        """
        Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        """
        return pulumi.get(self, "confidential_instance_config")

    @confidential_instance_config.setter
    def confidential_instance_config(self, value: Optional[pulumi.Input['RegionInstanceTemplateConfidentialInstanceConfigArgs']]):
        pulumi.set(self, "confidential_instance_config", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A brief description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateDiskArgs']]]]:
        """
        Disks to attach to instances created from this template.
        This can be specified multiple times for multiple disks. Structure is
        documented below.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
        **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        """
        return pulumi.get(self, "enable_display")

    @enable_display.setter
    def enable_display(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_display", value)

    @_builtins.property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateGuestAcceleratorArgs']]]]:
        """
        List of the type and count of accelerator cards attached to the instance. Structure documented below.
        """
        return pulumi.get(self, "guest_accelerators")

    @guest_accelerators.setter
    def guest_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateGuestAcceleratorArgs']]]]):
        pulumi.set(self, "guest_accelerators", value)

    @_builtins.property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A brief description to use for instances
        created from this template.
        """
        return pulumi.get(self, "instance_description")

    @instance_description.setter
    def instance_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_description", value)

    @_builtins.property
    @pulumi.getter(name="keyRevocationActionType")
    def key_revocation_action_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        """
        return pulumi.get(self, "key_revocation_action_type")

    @key_revocation_action_type.setter
    def key_revocation_action_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_revocation_action_type", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to instances
        created from this template.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The machine type to create.

        To create a machine with a [custom type](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) (such as extended memory), format the value like `custom-VCPUS-MEM_IN_MB` like `custom-6-20480` for 6 vCPU and 20GB of RAM.

        - - -
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata key/value pairs to make available from
        within instances created from this template.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="metadataFingerprint")
    def metadata_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique fingerprint of the metadata.
        """
        return pulumi.get(self, "metadata_fingerprint")

    @metadata_fingerprint.setter
    def metadata_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata_fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An alternative to using the
        startup-script metadata key, mostly to match the compute_instance resource.
        This replaces the startup-script metadata key on the created instance and
        thus the two mechanisms are not allowed to be used simultaneously.
        """
        return pulumi.get(self, "metadata_startup_script")

    @metadata_startup_script.setter
    def metadata_startup_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata_startup_script", value)

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
        `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`. Max length is 54 characters.
        Prefixes with lengths longer than 37 characters will use a shortened
        UUID that will be more prone to collisions.

        Resulting name for a `name_prefix` <= 37 characters:
        `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
        Resulting name for a `name_prefix` 38 - 54 characters:
        `name_prefix` + YYmmdd + 3 digit incremental counter
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateNetworkInterfaceArgs']]]]:
        """
        Networks to attach to instances created from
        this template. This can be specified multiple times for multiple networks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionInstanceTemplateNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> Optional[pulumi.Input['RegionInstanceTemplateNetworkPerformanceConfigArgs']]:
        """
        Configures network performance settings for the instance created from the
        template. Structure is documented below. **Note**: `machine_type`
        must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
        the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
        in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
        in order for this setting to take effect.
        """
        return pulumi.get(self, "network_performance_config")

    @network_performance_config.setter
    def network_performance_config(self, value: Optional[pulumi.Input['RegionInstanceTemplateNetworkPerformanceConfigArgs']]):
        pulumi.set(self, "network_performance_config", value)

    @_builtins.property
    @pulumi.getter(name="numericId")
    def numeric_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        numeric identifier of the resource.
        """
        return pulumi.get(self, "numeric_id")

    @numeric_id.setter
    def numeric_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "numeric_id", value)

    @_builtins.property
    @pulumi.getter(name="partnerMetadata")
    def partner_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Beta key/value pair represents partner metadata assigned to instance template where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        """
        return pulumi.get(self, "partner_metadata")

    @partner_metadata.setter
    def partner_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "partner_metadata", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Region in which the resource belongs.
        If region is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['RegionInstanceTemplateReservationAffinityArgs']]:
        """
        Specifies the reservations that this instance can consume from.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['RegionInstanceTemplateReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @_builtins.property
    @pulumi.getter(name="resourceManagerTags")
    def resource_manager_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value resource manager tag pairs to bind to the instance. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456.
        """
        return pulumi.get(self, "resource_manager_tags")

    @resource_manager_tags.setter
    def resource_manager_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_manager_tags", value)

    @_builtins.property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_policies", value)

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['RegionInstanceTemplateSchedulingArgs']]:
        """
        The scheduling strategy to use. More details about
        this configuration option are detailed below.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['RegionInstanceTemplateSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['RegionInstanceTemplateServiceAccountArgs']]:
        """
        Service account to attach to the instance. Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['RegionInstanceTemplateServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['RegionInstanceTemplateShieldedInstanceConfigArgs']]:
        """
        Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
        **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['RegionInstanceTemplateShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to attach to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsFingerprint")
    def tags_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique fingerprint of the tags.
        """
        return pulumi.get(self, "tags_fingerprint")

    @tags_fingerprint.setter
    def tags_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags_fingerprint", value)


@pulumi.type_token("gcp:compute/regionInstanceTemplate:RegionInstanceTemplate")
class RegionInstanceTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_machine_features: Optional[pulumi.Input[Union['RegionInstanceTemplateAdvancedMachineFeaturesArgs', 'RegionInstanceTemplateAdvancedMachineFeaturesArgsDict']]] = None,
                 can_ip_forward: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input[Union['RegionInstanceTemplateConfidentialInstanceConfigArgs', 'RegionInstanceTemplateConfidentialInstanceConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateDiskArgs', 'RegionInstanceTemplateDiskArgsDict']]]]] = None,
                 enable_display: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateGuestAcceleratorArgs', 'RegionInstanceTemplateGuestAcceleratorArgsDict']]]]] = None,
                 instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_revocation_action_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[_builtins.str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateNetworkInterfaceArgs', 'RegionInstanceTemplateNetworkInterfaceArgsDict']]]]] = None,
                 network_performance_config: Optional[pulumi.Input[Union['RegionInstanceTemplateNetworkPerformanceConfigArgs', 'RegionInstanceTemplateNetworkPerformanceConfigArgsDict']]] = None,
                 partner_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_affinity: Optional[pulumi.Input[Union['RegionInstanceTemplateReservationAffinityArgs', 'RegionInstanceTemplateReservationAffinityArgsDict']]] = None,
                 resource_manager_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling: Optional[pulumi.Input[Union['RegionInstanceTemplateSchedulingArgs', 'RegionInstanceTemplateSchedulingArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[Union['RegionInstanceTemplateServiceAccountArgs', 'RegionInstanceTemplateServiceAccountArgsDict']]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['RegionInstanceTemplateShieldedInstanceConfigArgs', 'RegionInstanceTemplateShieldedInstanceConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Import

        Instance templates can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/instanceTemplates/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, instance templates can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionInstanceTemplate:RegionInstanceTemplate default projects/{{project}}/regions/{{region}}/instanceTemplates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionInstanceTemplate:RegionInstanceTemplate default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionInstanceTemplate:RegionInstanceTemplate default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RegionInstanceTemplateAdvancedMachineFeaturesArgs', 'RegionInstanceTemplateAdvancedMachineFeaturesArgsDict']] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        :param pulumi.Input[_builtins.bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs. This defaults to false.
        :param pulumi.Input[Union['RegionInstanceTemplateConfidentialInstanceConfigArgs', 'RegionInstanceTemplateConfidentialInstanceConfigArgsDict']] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[_builtins.str] description: A brief description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateDiskArgs', 'RegionInstanceTemplateDiskArgsDict']]]] disks: Disks to attach to instances created from this template.
               This can be specified multiple times for multiple disks. Structure is
               documented below.
        :param pulumi.Input[_builtins.bool] enable_display: Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateGuestAcceleratorArgs', 'RegionInstanceTemplateGuestAcceleratorArgsDict']]]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
        :param pulumi.Input[_builtins.str] instance_description: A brief description to use for instances
               created from this template.
        :param pulumi.Input[_builtins.str] key_revocation_action_type: Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to instances
               created from this template.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] machine_type: The machine type to create.
               
               To create a machine with a [custom type](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) (such as extended memory), format the value like `custom-VCPUS-MEM_IN_MB` like `custom-6-20480` for 6 vCPU and 20GB of RAM.
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key/value pairs to make available from
               within instances created from this template.
        :param pulumi.Input[_builtins.str] metadata_startup_script: An alternative to using the
               startup-script metadata key, mostly to match the compute_instance resource.
               This replaces the startup-script metadata key on the created instance and
               thus the two mechanisms are not allowed to be used simultaneously.
        :param pulumi.Input[_builtins.str] min_cpu_platform: Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`. Max length is 54 characters.
               Prefixes with lengths longer than 37 characters will use a shortened
               UUID that will be more prone to collisions.
               
               Resulting name for a `name_prefix` <= 37 characters:
               `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
               Resulting name for a `name_prefix` 38 - 54 characters:
               `name_prefix` + YYmmdd + 3 digit incremental counter
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateNetworkInterfaceArgs', 'RegionInstanceTemplateNetworkInterfaceArgsDict']]]] network_interfaces: Networks to attach to instances created from
               this template. This can be specified multiple times for multiple networks.
               Structure is documented below.
        :param pulumi.Input[Union['RegionInstanceTemplateNetworkPerformanceConfigArgs', 'RegionInstanceTemplateNetworkPerformanceConfigArgsDict']] network_performance_config: Configures network performance settings for the instance created from the
               template. Structure is documented below. **Note**: `machine_type`
               must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] partner_metadata: Beta key/value pair represents partner metadata assigned to instance template where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The Region in which the resource belongs.
               If region is not provided, the provider region is used.
        :param pulumi.Input[Union['RegionInstanceTemplateReservationAffinityArgs', 'RegionInstanceTemplateReservationAffinityArgsDict']] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_manager_tags: A set of key/value resource manager tag pairs to bind to the instance. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456.
        :param pulumi.Input[_builtins.str] resource_policies: - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        :param pulumi.Input[Union['RegionInstanceTemplateSchedulingArgs', 'RegionInstanceTemplateSchedulingArgsDict']] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input[Union['RegionInstanceTemplateServiceAccountArgs', 'RegionInstanceTemplateServiceAccountArgsDict']] service_account: Service account to attach to the instance. Structure is documented below.
        :param pulumi.Input[Union['RegionInstanceTemplateShieldedInstanceConfigArgs', 'RegionInstanceTemplateShieldedInstanceConfigArgsDict']] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to attach to the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionInstanceTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Instance templates can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/instanceTemplates/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, instance templates can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionInstanceTemplate:RegionInstanceTemplate default projects/{{project}}/regions/{{region}}/instanceTemplates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionInstanceTemplate:RegionInstanceTemplate default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionInstanceTemplate:RegionInstanceTemplate default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionInstanceTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionInstanceTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_machine_features: Optional[pulumi.Input[Union['RegionInstanceTemplateAdvancedMachineFeaturesArgs', 'RegionInstanceTemplateAdvancedMachineFeaturesArgsDict']]] = None,
                 can_ip_forward: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input[Union['RegionInstanceTemplateConfidentialInstanceConfigArgs', 'RegionInstanceTemplateConfidentialInstanceConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateDiskArgs', 'RegionInstanceTemplateDiskArgsDict']]]]] = None,
                 enable_display: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateGuestAcceleratorArgs', 'RegionInstanceTemplateGuestAcceleratorArgsDict']]]]] = None,
                 instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_revocation_action_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[_builtins.str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateNetworkInterfaceArgs', 'RegionInstanceTemplateNetworkInterfaceArgsDict']]]]] = None,
                 network_performance_config: Optional[pulumi.Input[Union['RegionInstanceTemplateNetworkPerformanceConfigArgs', 'RegionInstanceTemplateNetworkPerformanceConfigArgsDict']]] = None,
                 partner_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_affinity: Optional[pulumi.Input[Union['RegionInstanceTemplateReservationAffinityArgs', 'RegionInstanceTemplateReservationAffinityArgsDict']]] = None,
                 resource_manager_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling: Optional[pulumi.Input[Union['RegionInstanceTemplateSchedulingArgs', 'RegionInstanceTemplateSchedulingArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[Union['RegionInstanceTemplateServiceAccountArgs', 'RegionInstanceTemplateServiceAccountArgsDict']]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['RegionInstanceTemplateShieldedInstanceConfigArgs', 'RegionInstanceTemplateShieldedInstanceConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionInstanceTemplateArgs.__new__(RegionInstanceTemplateArgs)

            __props__.__dict__["advanced_machine_features"] = advanced_machine_features
            __props__.__dict__["can_ip_forward"] = can_ip_forward
            __props__.__dict__["confidential_instance_config"] = confidential_instance_config
            __props__.__dict__["description"] = description
            if disks is None and not opts.urn:
                raise TypeError("Missing required property 'disks'")
            __props__.__dict__["disks"] = disks
            __props__.__dict__["enable_display"] = enable_display
            __props__.__dict__["guest_accelerators"] = guest_accelerators
            __props__.__dict__["instance_description"] = instance_description
            __props__.__dict__["key_revocation_action_type"] = key_revocation_action_type
            __props__.__dict__["labels"] = labels
            if machine_type is None and not opts.urn:
                raise TypeError("Missing required property 'machine_type'")
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["metadata_startup_script"] = metadata_startup_script
            __props__.__dict__["min_cpu_platform"] = min_cpu_platform
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["network_performance_config"] = network_performance_config
            __props__.__dict__["partner_metadata"] = partner_metadata
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["reservation_affinity"] = reservation_affinity
            __props__.__dict__["resource_manager_tags"] = resource_manager_tags
            __props__.__dict__["resource_policies"] = resource_policies
            __props__.__dict__["scheduling"] = scheduling
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["shielded_instance_config"] = shielded_instance_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["metadata_fingerprint"] = None
            __props__.__dict__["numeric_id"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["tags_fingerprint"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RegionInstanceTemplate, __self__).__init__(
            'gcp:compute/regionInstanceTemplate:RegionInstanceTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_machine_features: Optional[pulumi.Input[Union['RegionInstanceTemplateAdvancedMachineFeaturesArgs', 'RegionInstanceTemplateAdvancedMachineFeaturesArgsDict']]] = None,
            can_ip_forward: Optional[pulumi.Input[_builtins.bool]] = None,
            confidential_instance_config: Optional[pulumi.Input[Union['RegionInstanceTemplateConfidentialInstanceConfigArgs', 'RegionInstanceTemplateConfidentialInstanceConfigArgsDict']]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateDiskArgs', 'RegionInstanceTemplateDiskArgsDict']]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            enable_display: Optional[pulumi.Input[_builtins.bool]] = None,
            guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateGuestAcceleratorArgs', 'RegionInstanceTemplateGuestAcceleratorArgsDict']]]]] = None,
            instance_description: Optional[pulumi.Input[_builtins.str]] = None,
            key_revocation_action_type: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            machine_type: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            metadata_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            metadata_startup_script: Optional[pulumi.Input[_builtins.str]] = None,
            min_cpu_platform: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateNetworkInterfaceArgs', 'RegionInstanceTemplateNetworkInterfaceArgsDict']]]]] = None,
            network_performance_config: Optional[pulumi.Input[Union['RegionInstanceTemplateNetworkPerformanceConfigArgs', 'RegionInstanceTemplateNetworkPerformanceConfigArgsDict']]] = None,
            numeric_id: Optional[pulumi.Input[_builtins.str]] = None,
            partner_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            reservation_affinity: Optional[pulumi.Input[Union['RegionInstanceTemplateReservationAffinityArgs', 'RegionInstanceTemplateReservationAffinityArgsDict']]] = None,
            resource_manager_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            resource_policies: Optional[pulumi.Input[_builtins.str]] = None,
            scheduling: Optional[pulumi.Input[Union['RegionInstanceTemplateSchedulingArgs', 'RegionInstanceTemplateSchedulingArgsDict']]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            service_account: Optional[pulumi.Input[Union['RegionInstanceTemplateServiceAccountArgs', 'RegionInstanceTemplateServiceAccountArgsDict']]] = None,
            shielded_instance_config: Optional[pulumi.Input[Union['RegionInstanceTemplateShieldedInstanceConfigArgs', 'RegionInstanceTemplateShieldedInstanceConfigArgsDict']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags_fingerprint: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegionInstanceTemplate':
        """
        Get an existing RegionInstanceTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RegionInstanceTemplateAdvancedMachineFeaturesArgs', 'RegionInstanceTemplateAdvancedMachineFeaturesArgsDict']] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        :param pulumi.Input[_builtins.bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs. This defaults to false.
        :param pulumi.Input[Union['RegionInstanceTemplateConfidentialInstanceConfigArgs', 'RegionInstanceTemplateConfidentialInstanceConfigArgsDict']] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: A brief description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateDiskArgs', 'RegionInstanceTemplateDiskArgsDict']]]] disks: Disks to attach to instances created from this template.
               This can be specified multiple times for multiple disks. Structure is
               documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.bool] enable_display: Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateGuestAcceleratorArgs', 'RegionInstanceTemplateGuestAcceleratorArgsDict']]]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
        :param pulumi.Input[_builtins.str] instance_description: A brief description to use for instances
               created from this template.
        :param pulumi.Input[_builtins.str] key_revocation_action_type: Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to instances
               created from this template.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] machine_type: The machine type to create.
               
               To create a machine with a [custom type](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) (such as extended memory), format the value like `custom-VCPUS-MEM_IN_MB` like `custom-6-20480` for 6 vCPU and 20GB of RAM.
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key/value pairs to make available from
               within instances created from this template.
        :param pulumi.Input[_builtins.str] metadata_fingerprint: The unique fingerprint of the metadata.
        :param pulumi.Input[_builtins.str] metadata_startup_script: An alternative to using the
               startup-script metadata key, mostly to match the compute_instance resource.
               This replaces the startup-script metadata key on the created instance and
               thus the two mechanisms are not allowed to be used simultaneously.
        :param pulumi.Input[_builtins.str] min_cpu_platform: Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`. Max length is 54 characters.
               Prefixes with lengths longer than 37 characters will use a shortened
               UUID that will be more prone to collisions.
               
               Resulting name for a `name_prefix` <= 37 characters:
               `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
               Resulting name for a `name_prefix` 38 - 54 characters:
               `name_prefix` + YYmmdd + 3 digit incremental counter
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionInstanceTemplateNetworkInterfaceArgs', 'RegionInstanceTemplateNetworkInterfaceArgsDict']]]] network_interfaces: Networks to attach to instances created from
               this template. This can be specified multiple times for multiple networks.
               Structure is documented below.
        :param pulumi.Input[Union['RegionInstanceTemplateNetworkPerformanceConfigArgs', 'RegionInstanceTemplateNetworkPerformanceConfigArgsDict']] network_performance_config: Configures network performance settings for the instance created from the
               template. Structure is documented below. **Note**: `machine_type`
               must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input[_builtins.str] numeric_id: numeric identifier of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] partner_metadata: Beta key/value pair represents partner metadata assigned to instance template where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: The Region in which the resource belongs.
               If region is not provided, the provider region is used.
        :param pulumi.Input[Union['RegionInstanceTemplateReservationAffinityArgs', 'RegionInstanceTemplateReservationAffinityArgsDict']] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_manager_tags: A set of key/value resource manager tag pairs to bind to the instance. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456.
        :param pulumi.Input[_builtins.str] resource_policies: - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        :param pulumi.Input[Union['RegionInstanceTemplateSchedulingArgs', 'RegionInstanceTemplateSchedulingArgsDict']] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['RegionInstanceTemplateServiceAccountArgs', 'RegionInstanceTemplateServiceAccountArgsDict']] service_account: Service account to attach to the instance. Structure is documented below.
        :param pulumi.Input[Union['RegionInstanceTemplateShieldedInstanceConfigArgs', 'RegionInstanceTemplateShieldedInstanceConfigArgsDict']] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to attach to the instance.
        :param pulumi.Input[_builtins.str] tags_fingerprint: The unique fingerprint of the tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionInstanceTemplateState.__new__(_RegionInstanceTemplateState)

        __props__.__dict__["advanced_machine_features"] = advanced_machine_features
        __props__.__dict__["can_ip_forward"] = can_ip_forward
        __props__.__dict__["confidential_instance_config"] = confidential_instance_config
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["disks"] = disks
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_display"] = enable_display
        __props__.__dict__["guest_accelerators"] = guest_accelerators
        __props__.__dict__["instance_description"] = instance_description
        __props__.__dict__["key_revocation_action_type"] = key_revocation_action_type
        __props__.__dict__["labels"] = labels
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metadata_fingerprint"] = metadata_fingerprint
        __props__.__dict__["metadata_startup_script"] = metadata_startup_script
        __props__.__dict__["min_cpu_platform"] = min_cpu_platform
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["network_performance_config"] = network_performance_config
        __props__.__dict__["numeric_id"] = numeric_id
        __props__.__dict__["partner_metadata"] = partner_metadata
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["reservation_affinity"] = reservation_affinity
        __props__.__dict__["resource_manager_tags"] = resource_manager_tags
        __props__.__dict__["resource_policies"] = resource_policies
        __props__.__dict__["scheduling"] = scheduling
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["shielded_instance_config"] = shielded_instance_config
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_fingerprint"] = tags_fingerprint
        return RegionInstanceTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> pulumi.Output[Optional['outputs.RegionInstanceTemplateAdvancedMachineFeatures']]:
        """
        Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        """
        return pulumi.get(self, "advanced_machine_features")

    @_builtins.property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to allow sending and receiving of
        packets with non-matching source or destination IPs. This defaults to false.
        """
        return pulumi.get(self, "can_ip_forward")

    @_builtins.property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> pulumi.Output['outputs.RegionInstanceTemplateConfidentialInstanceConfig']:
        """
        Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        """
        return pulumi.get(self, "confidential_instance_config")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A brief description of this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Sequence['outputs.RegionInstanceTemplateDisk']]:
        """
        Disks to attach to instances created from this template.
        This can be specified multiple times for multiple disks. Structure is
        documented below.
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
        **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        """
        return pulumi.get(self, "enable_display")

    @_builtins.property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> pulumi.Output[Optional[Sequence['outputs.RegionInstanceTemplateGuestAccelerator']]]:
        """
        List of the type and count of accelerator cards attached to the instance. Structure documented below.
        """
        return pulumi.get(self, "guest_accelerators")

    @_builtins.property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A brief description to use for instances
        created from this template.
        """
        return pulumi.get(self, "instance_description")

    @_builtins.property
    @pulumi.getter(name="keyRevocationActionType")
    def key_revocation_action_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        """
        return pulumi.get(self, "key_revocation_action_type")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs to assign to instances
        created from this template.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[_builtins.str]:
        """
        The machine type to create.

        To create a machine with a [custom type](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) (such as extended memory), format the value like `custom-VCPUS-MEM_IN_MB` like `custom-6-20480` for 6 vCPU and 20GB of RAM.

        - - -
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Metadata key/value pairs to make available from
        within instances created from this template.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="metadataFingerprint")
    def metadata_fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The unique fingerprint of the metadata.
        """
        return pulumi.get(self, "metadata_fingerprint")

    @_builtins.property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An alternative to using the
        startup-script metadata key, mostly to match the compute_instance resource.
        This replaces the startup-script metadata key on the created instance and
        thus the two mechanisms are not allowed to be used simultaneously.
        """
        return pulumi.get(self, "metadata_startup_script")

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
        `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        """
        return pulumi.get(self, "min_cpu_platform")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`. Max length is 54 characters.
        Prefixes with lengths longer than 37 characters will use a shortened
        UUID that will be more prone to collisions.

        Resulting name for a `name_prefix` <= 37 characters:
        `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
        Resulting name for a `name_prefix` 38 - 54 characters:
        `name_prefix` + YYmmdd + 3 digit incremental counter
        """
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.RegionInstanceTemplateNetworkInterface']]]:
        """
        Networks to attach to instances created from
        this template. This can be specified multiple times for multiple networks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> pulumi.Output[Optional['outputs.RegionInstanceTemplateNetworkPerformanceConfig']]:
        """
        Configures network performance settings for the instance created from the
        template. Structure is documented below. **Note**: `machine_type`
        must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
        the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
        in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
        in order for this setting to take effect.
        """
        return pulumi.get(self, "network_performance_config")

    @_builtins.property
    @pulumi.getter(name="numericId")
    def numeric_id(self) -> pulumi.Output[_builtins.str]:
        """
        numeric identifier of the resource.
        """
        return pulumi.get(self, "numeric_id")

    @_builtins.property
    @pulumi.getter(name="partnerMetadata")
    def partner_metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Beta key/value pair represents partner metadata assigned to instance template where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        """
        return pulumi.get(self, "partner_metadata")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The Region in which the resource belongs.
        If region is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> pulumi.Output[Optional['outputs.RegionInstanceTemplateReservationAffinity']]:
        """
        Specifies the reservations that this instance can consume from.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_affinity")

    @_builtins.property
    @pulumi.getter(name="resourceManagerTags")
    def resource_manager_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value resource manager tag pairs to bind to the instance. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456.
        """
        return pulumi.get(self, "resource_manager_tags")

    @_builtins.property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        """
        return pulumi.get(self, "resource_policies")

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output['outputs.RegionInstanceTemplateScheduling']:
        """
        The scheduling strategy to use. More details about
        this configuration option are detailed below.
        """
        return pulumi.get(self, "scheduling")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional['outputs.RegionInstanceTemplateServiceAccount']]:
        """
        Service account to attach to the instance. Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output['outputs.RegionInstanceTemplateShieldedInstanceConfig']:
        """
        Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
        **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        """
        return pulumi.get(self, "shielded_instance_config")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to attach to the instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsFingerprint")
    def tags_fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The unique fingerprint of the tags.
        """
        return pulumi.get(self, "tags_fingerprint")

