# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnapshotArgs', 'Snapshot']

@pulumi.input_type
class SnapshotArgs:
    def __init__(__self__, *,
                 source_disk: pulumi.Input[_builtins.str],
                 chain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_encryption_key: Optional[pulumi.Input['SnapshotSnapshotEncryptionKeyArgs']] = None,
                 source_disk_encryption_key: Optional[pulumi.Input['SnapshotSourceDiskEncryptionKeyArgs']] = None,
                 storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Snapshot resource.
        :param pulumi.Input[_builtins.str] source_disk: A reference to the disk used to create this snapshot.
        :param pulumi.Input[_builtins.str] chain_name: Creates the new snapshot in the snapshot chain labeled with the
               specified name. The chain name must be 1-63 characters long and
               comply with RFC1035. This is an uncommon option only for advanced
               service owners who needs to create separate snapshot chains, for
               example, for chargeback tracking.  When you describe your snapshot
               resource, this field is visible only if it has a non-empty value.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this Snapshot.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['SnapshotSnapshotEncryptionKeyArgs'] snapshot_encryption_key: Encrypts the snapshot using a customer-supplied encryption key.
               After you encrypt a snapshot using a customer-supplied key, you must
               provide the same key if you use the snapshot later. For example, you
               must provide the encryption key when you create a disk from the
               encrypted snapshot in a future request.
               Customer-supplied encryption keys do not protect access to metadata of
               the snapshot.
               If you do not provide an encryption key when creating the snapshot,
               then the snapshot will be encrypted using an automatically generated
               key and you do not need to provide a key to use the snapshot later.
               Structure is documented below.
        :param pulumi.Input['SnapshotSourceDiskEncryptionKeyArgs'] source_disk_encryption_key: The customer-supplied encryption key of the source snapshot. Required
               if the source snapshot is protected by a customer-supplied encryption
               key.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_locations: Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
        :param pulumi.Input[_builtins.str] zone: A reference to the zone where the disk is hosted.
        """
        pulumi.set(__self__, "source_disk", source_disk)
        if chain_name is not None:
            pulumi.set(__self__, "chain_name", chain_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if snapshot_encryption_key is not None:
            pulumi.set(__self__, "snapshot_encryption_key", snapshot_encryption_key)
        if source_disk_encryption_key is not None:
            pulumi.set(__self__, "source_disk_encryption_key", source_disk_encryption_key)
        if storage_locations is not None:
            pulumi.set(__self__, "storage_locations", storage_locations)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> pulumi.Input[_builtins.str]:
        """
        A reference to the disk used to create this snapshot.
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_disk", value)

    @_builtins.property
    @pulumi.getter(name="chainName")
    def chain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates the new snapshot in the snapshot chain labeled with the
        specified name. The chain name must be 1-63 characters long and
        comply with RFC1035. This is an uncommon option only for advanced
        service owners who needs to create separate snapshot chains, for
        example, for chargeback tracking.  When you describe your snapshot
        resource, this field is visible only if it has a non-empty value.
        """
        return pulumi.get(self, "chain_name")

    @chain_name.setter
    def chain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chain_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to apply to this Snapshot.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="snapshotEncryptionKey")
    def snapshot_encryption_key(self) -> Optional[pulumi.Input['SnapshotSnapshotEncryptionKeyArgs']]:
        """
        Encrypts the snapshot using a customer-supplied encryption key.
        After you encrypt a snapshot using a customer-supplied key, you must
        provide the same key if you use the snapshot later. For example, you
        must provide the encryption key when you create a disk from the
        encrypted snapshot in a future request.
        Customer-supplied encryption keys do not protect access to metadata of
        the snapshot.
        If you do not provide an encryption key when creating the snapshot,
        then the snapshot will be encrypted using an automatically generated
        key and you do not need to provide a key to use the snapshot later.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_encryption_key")

    @snapshot_encryption_key.setter
    def snapshot_encryption_key(self, value: Optional[pulumi.Input['SnapshotSnapshotEncryptionKeyArgs']]):
        pulumi.set(self, "snapshot_encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="sourceDiskEncryptionKey")
    def source_disk_encryption_key(self) -> Optional[pulumi.Input['SnapshotSourceDiskEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source snapshot. Required
        if the source snapshot is protected by a customer-supplied encryption
        key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_disk_encryption_key")

    @source_disk_encryption_key.setter
    def source_disk_encryption_key(self, value: Optional[pulumi.Input['SnapshotSourceDiskEncryptionKeyArgs']]):
        pulumi.set(self, "source_disk_encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="storageLocations")
    def storage_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
        """
        return pulumi.get(self, "storage_locations")

    @storage_locations.setter
    def storage_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "storage_locations", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the zone where the disk is hosted.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _SnapshotState:
    def __init__(__self__, *,
                 chain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 label_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_encryption_key: Optional[pulumi.Input['SnapshotSnapshotEncryptionKeyArgs']] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.int]] = None,
                 source_disk: Optional[pulumi.Input[_builtins.str]] = None,
                 source_disk_encryption_key: Optional[pulumi.Input['SnapshotSourceDiskEncryptionKeyArgs']] = None,
                 storage_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Snapshot resources.
        :param pulumi.Input[_builtins.str] chain_name: Creates the new snapshot in the snapshot chain labeled with the
               specified name. The chain name must be 1-63 characters long and
               comply with RFC1035. This is an uncommon option only for advanced
               service owners who needs to create separate snapshot chains, for
               example, for chargeback tracking.  When you describe your snapshot
               resource, this field is visible only if it has a non-empty value.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.int] disk_size_gb: Size of the snapshot, specified in GB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource. Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this Snapshot.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] licenses: A list of public visible licenses that apply to this snapshot. This
               can be because the original image had licenses attached (such as a
               Windows image).  snapshotEncryptionKey nested object Encrypts the
               snapshot using a customer-supplied encryption key.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input['SnapshotSnapshotEncryptionKeyArgs'] snapshot_encryption_key: Encrypts the snapshot using a customer-supplied encryption key.
               After you encrypt a snapshot using a customer-supplied key, you must
               provide the same key if you use the snapshot later. For example, you
               must provide the encryption key when you create a disk from the
               encrypted snapshot in a future request.
               Customer-supplied encryption keys do not protect access to metadata of
               the snapshot.
               If you do not provide an encryption key when creating the snapshot,
               then the snapshot will be encrypted using an automatically generated
               key and you do not need to provide a key to use the snapshot later.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] snapshot_id: The unique identifier for the resource.
        :param pulumi.Input[_builtins.str] source_disk: A reference to the disk used to create this snapshot.
        :param pulumi.Input['SnapshotSourceDiskEncryptionKeyArgs'] source_disk_encryption_key: The customer-supplied encryption key of the source snapshot. Required
               if the source snapshot is protected by a customer-supplied encryption
               key.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] storage_bytes: A size of the storage used by the snapshot. As snapshots share
               storage, this number is expected to change with snapshot
               creation/deletion.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_locations: Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
        :param pulumi.Input[_builtins.str] zone: A reference to the zone where the disk is hosted.
        """
        if chain_name is not None:
            pulumi.set(__self__, "chain_name", chain_name)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if licenses is not None:
            pulumi.set(__self__, "licenses", licenses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if snapshot_encryption_key is not None:
            pulumi.set(__self__, "snapshot_encryption_key", snapshot_encryption_key)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)
        if source_disk_encryption_key is not None:
            pulumi.set(__self__, "source_disk_encryption_key", source_disk_encryption_key)
        if storage_bytes is not None:
            pulumi.set(__self__, "storage_bytes", storage_bytes)
        if storage_locations is not None:
            pulumi.set(__self__, "storage_locations", storage_locations)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="chainName")
    def chain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates the new snapshot in the snapshot chain labeled with the
        specified name. The chain name must be 1-63 characters long and
        comply with RFC1035. This is an uncommon option only for advanced
        service owners who needs to create separate snapshot chains, for
        example, for chargeback tracking.  When you describe your snapshot
        resource, this field is visible only if it has a non-empty value.
        """
        return pulumi.get(self, "chain_name")

    @chain_name.setter
    def chain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chain_name", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the snapshot, specified in GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fingerprint used for optimistic locking of this resource. Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label_fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to apply to this Snapshot.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of public visible licenses that apply to this snapshot. This
        can be because the original image had licenses attached (such as a
        Windows image).  snapshotEncryptionKey nested object Encrypts the
        snapshot using a customer-supplied encryption key.
        """
        return pulumi.get(self, "licenses")

    @licenses.setter
    def licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "licenses", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="snapshotEncryptionKey")
    def snapshot_encryption_key(self) -> Optional[pulumi.Input['SnapshotSnapshotEncryptionKeyArgs']]:
        """
        Encrypts the snapshot using a customer-supplied encryption key.
        After you encrypt a snapshot using a customer-supplied key, you must
        provide the same key if you use the snapshot later. For example, you
        must provide the encryption key when you create a disk from the
        encrypted snapshot in a future request.
        Customer-supplied encryption keys do not protect access to metadata of
        the snapshot.
        If you do not provide an encryption key when creating the snapshot,
        then the snapshot will be encrypted using an automatically generated
        key and you do not need to provide a key to use the snapshot later.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_encryption_key")

    @snapshot_encryption_key.setter
    def snapshot_encryption_key(self, value: Optional[pulumi.Input['SnapshotSnapshotEncryptionKeyArgs']]):
        pulumi.set(self, "snapshot_encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the disk used to create this snapshot.
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_disk", value)

    @_builtins.property
    @pulumi.getter(name="sourceDiskEncryptionKey")
    def source_disk_encryption_key(self) -> Optional[pulumi.Input['SnapshotSourceDiskEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source snapshot. Required
        if the source snapshot is protected by a customer-supplied encryption
        key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_disk_encryption_key")

    @source_disk_encryption_key.setter
    def source_disk_encryption_key(self, value: Optional[pulumi.Input['SnapshotSourceDiskEncryptionKeyArgs']]):
        pulumi.set(self, "source_disk_encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="storageBytes")
    def storage_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A size of the storage used by the snapshot. As snapshots share
        storage, this number is expected to change with snapshot
        creation/deletion.
        """
        return pulumi.get(self, "storage_bytes")

    @storage_bytes.setter
    def storage_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_bytes", value)

    @_builtins.property
    @pulumi.getter(name="storageLocations")
    def storage_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
        """
        return pulumi.get(self, "storage_locations")

    @storage_locations.setter
    def storage_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "storage_locations", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the zone where the disk is hosted.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:compute/snapshot:Snapshot")
class Snapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 chain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_encryption_key: Optional[pulumi.Input[Union['SnapshotSnapshotEncryptionKeyArgs', 'SnapshotSnapshotEncryptionKeyArgsDict']]] = None,
                 source_disk: Optional[pulumi.Input[_builtins.str]] = None,
                 source_disk_encryption_key: Optional[pulumi.Input[Union['SnapshotSourceDiskEncryptionKeyArgs', 'SnapshotSourceDiskEncryptionKeyArgsDict']]] = None,
                 storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents a Persistent Disk Snapshot resource.

        Use snapshots to back up data from your persistent disks. Snapshots are
        different from public images and custom images, which are used primarily
        to create instances or configure instance templates. Snapshots are useful
        for periodic backup of the data on your persistent disks. You can create
        snapshots from persistent disks even while they are attached to running
        instances.

        Snapshots are incremental, so you can create regular snapshots on a
        persistent disk faster and at a much lower cost than if you regularly
        created a full image of the disk.

        To get more information about Snapshot, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/snapshots)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/disks/create-snapshots)

        > **Warning:** All arguments including the following potentially sensitive
        values will be stored in the raw state as plain text: `snapshot_encryption_key.raw_key`, `snapshot_encryption_key.rsa_encrypted_key`, `source_disk_encryption_key.raw_key`, `source_disk_encryption_key.rsa_encrypted_key`.

        ## Example Usage

        ### Snapshot Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        persistent = gcp.compute.Disk("persistent",
            name="debian-disk",
            image=debian.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        snapshot = gcp.compute.Snapshot("snapshot",
            name="my-snapshot",
            source_disk=persistent.id,
            zone="us-central1-a",
            labels={
                "my_label": "value",
            },
            storage_locations=["us-central1"])
        ```
        ### Snapshot Chainname

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        persistent = gcp.compute.Disk("persistent",
            name="debian-disk",
            image=debian.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        snapshot = gcp.compute.Snapshot("snapshot",
            name="my-snapshot",
            source_disk=persistent.id,
            zone="us-central1-a",
            chain_name="snapshot-chain",
            labels={
                "my_label": "value",
            },
            storage_locations=["us-central1"])
        ```

        ## Import

        Snapshot can be imported using any of these accepted formats:

        * `projects/{{project}}/global/snapshots/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Snapshot can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/snapshot:Snapshot default projects/{{project}}/global/snapshots/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/snapshot:Snapshot default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/snapshot:Snapshot default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] chain_name: Creates the new snapshot in the snapshot chain labeled with the
               specified name. The chain name must be 1-63 characters long and
               comply with RFC1035. This is an uncommon option only for advanced
               service owners who needs to create separate snapshot chains, for
               example, for chargeback tracking.  When you describe your snapshot
               resource, this field is visible only if it has a non-empty value.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this Snapshot.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SnapshotSnapshotEncryptionKeyArgs', 'SnapshotSnapshotEncryptionKeyArgsDict']] snapshot_encryption_key: Encrypts the snapshot using a customer-supplied encryption key.
               After you encrypt a snapshot using a customer-supplied key, you must
               provide the same key if you use the snapshot later. For example, you
               must provide the encryption key when you create a disk from the
               encrypted snapshot in a future request.
               Customer-supplied encryption keys do not protect access to metadata of
               the snapshot.
               If you do not provide an encryption key when creating the snapshot,
               then the snapshot will be encrypted using an automatically generated
               key and you do not need to provide a key to use the snapshot later.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] source_disk: A reference to the disk used to create this snapshot.
        :param pulumi.Input[Union['SnapshotSourceDiskEncryptionKeyArgs', 'SnapshotSourceDiskEncryptionKeyArgsDict']] source_disk_encryption_key: The customer-supplied encryption key of the source snapshot. Required
               if the source snapshot is protected by a customer-supplied encryption
               key.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_locations: Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
        :param pulumi.Input[_builtins.str] zone: A reference to the zone where the disk is hosted.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Persistent Disk Snapshot resource.

        Use snapshots to back up data from your persistent disks. Snapshots are
        different from public images and custom images, which are used primarily
        to create instances or configure instance templates. Snapshots are useful
        for periodic backup of the data on your persistent disks. You can create
        snapshots from persistent disks even while they are attached to running
        instances.

        Snapshots are incremental, so you can create regular snapshots on a
        persistent disk faster and at a much lower cost than if you regularly
        created a full image of the disk.

        To get more information about Snapshot, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/snapshots)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/disks/create-snapshots)

        > **Warning:** All arguments including the following potentially sensitive
        values will be stored in the raw state as plain text: `snapshot_encryption_key.raw_key`, `snapshot_encryption_key.rsa_encrypted_key`, `source_disk_encryption_key.raw_key`, `source_disk_encryption_key.rsa_encrypted_key`.

        ## Example Usage

        ### Snapshot Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        persistent = gcp.compute.Disk("persistent",
            name="debian-disk",
            image=debian.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        snapshot = gcp.compute.Snapshot("snapshot",
            name="my-snapshot",
            source_disk=persistent.id,
            zone="us-central1-a",
            labels={
                "my_label": "value",
            },
            storage_locations=["us-central1"])
        ```
        ### Snapshot Chainname

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        persistent = gcp.compute.Disk("persistent",
            name="debian-disk",
            image=debian.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        snapshot = gcp.compute.Snapshot("snapshot",
            name="my-snapshot",
            source_disk=persistent.id,
            zone="us-central1-a",
            chain_name="snapshot-chain",
            labels={
                "my_label": "value",
            },
            storage_locations=["us-central1"])
        ```

        ## Import

        Snapshot can be imported using any of these accepted formats:

        * `projects/{{project}}/global/snapshots/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Snapshot can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/snapshot:Snapshot default projects/{{project}}/global/snapshots/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/snapshot:Snapshot default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/snapshot:Snapshot default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 chain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_encryption_key: Optional[pulumi.Input[Union['SnapshotSnapshotEncryptionKeyArgs', 'SnapshotSnapshotEncryptionKeyArgsDict']]] = None,
                 source_disk: Optional[pulumi.Input[_builtins.str]] = None,
                 source_disk_encryption_key: Optional[pulumi.Input[Union['SnapshotSourceDiskEncryptionKeyArgs', 'SnapshotSourceDiskEncryptionKeyArgsDict']]] = None,
                 storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotArgs.__new__(SnapshotArgs)

            __props__.__dict__["chain_name"] = chain_name
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["snapshot_encryption_key"] = snapshot_encryption_key
            if source_disk is None and not opts.urn:
                raise TypeError("Missing required property 'source_disk'")
            __props__.__dict__["source_disk"] = source_disk
            __props__.__dict__["source_disk_encryption_key"] = source_disk_encryption_key
            __props__.__dict__["storage_locations"] = storage_locations
            __props__.__dict__["zone"] = zone
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["disk_size_gb"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["licenses"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["snapshot_id"] = None
            __props__.__dict__["storage_bytes"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Snapshot, __self__).__init__(
            'gcp:compute/snapshot:Snapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            chain_name: Optional[pulumi.Input[_builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            label_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            licenses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_encryption_key: Optional[pulumi.Input[Union['SnapshotSnapshotEncryptionKeyArgs', 'SnapshotSnapshotEncryptionKeyArgsDict']]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.int]] = None,
            source_disk: Optional[pulumi.Input[_builtins.str]] = None,
            source_disk_encryption_key: Optional[pulumi.Input[Union['SnapshotSourceDiskEncryptionKeyArgs', 'SnapshotSourceDiskEncryptionKeyArgsDict']]] = None,
            storage_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'Snapshot':
        """
        Get an existing Snapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] chain_name: Creates the new snapshot in the snapshot chain labeled with the
               specified name. The chain name must be 1-63 characters long and
               comply with RFC1035. This is an uncommon option only for advanced
               service owners who needs to create separate snapshot chains, for
               example, for chargeback tracking.  When you describe your snapshot
               resource, this field is visible only if it has a non-empty value.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.int] disk_size_gb: Size of the snapshot, specified in GB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource. Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this Snapshot.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] licenses: A list of public visible licenses that apply to this snapshot. This
               can be because the original image had licenses attached (such as a
               Windows image).  snapshotEncryptionKey nested object Encrypts the
               snapshot using a customer-supplied encryption key.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['SnapshotSnapshotEncryptionKeyArgs', 'SnapshotSnapshotEncryptionKeyArgsDict']] snapshot_encryption_key: Encrypts the snapshot using a customer-supplied encryption key.
               After you encrypt a snapshot using a customer-supplied key, you must
               provide the same key if you use the snapshot later. For example, you
               must provide the encryption key when you create a disk from the
               encrypted snapshot in a future request.
               Customer-supplied encryption keys do not protect access to metadata of
               the snapshot.
               If you do not provide an encryption key when creating the snapshot,
               then the snapshot will be encrypted using an automatically generated
               key and you do not need to provide a key to use the snapshot later.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] snapshot_id: The unique identifier for the resource.
        :param pulumi.Input[_builtins.str] source_disk: A reference to the disk used to create this snapshot.
        :param pulumi.Input[Union['SnapshotSourceDiskEncryptionKeyArgs', 'SnapshotSourceDiskEncryptionKeyArgsDict']] source_disk_encryption_key: The customer-supplied encryption key of the source snapshot. Required
               if the source snapshot is protected by a customer-supplied encryption
               key.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] storage_bytes: A size of the storage used by the snapshot. As snapshots share
               storage, this number is expected to change with snapshot
               creation/deletion.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_locations: Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
        :param pulumi.Input[_builtins.str] zone: A reference to the zone where the disk is hosted.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotState.__new__(_SnapshotState)

        __props__.__dict__["chain_name"] = chain_name
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_size_gb"] = disk_size_gb
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["licenses"] = licenses
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["snapshot_encryption_key"] = snapshot_encryption_key
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["source_disk"] = source_disk
        __props__.__dict__["source_disk_encryption_key"] = source_disk_encryption_key
        __props__.__dict__["storage_bytes"] = storage_bytes
        __props__.__dict__["storage_locations"] = storage_locations
        __props__.__dict__["zone"] = zone
        return Snapshot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="chainName")
    def chain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Creates the new snapshot in the snapshot chain labeled with the
        specified name. The chain name must be 1-63 characters long and
        comply with RFC1035. This is an uncommon option only for advanced
        service owners who needs to create separate snapshot chains, for
        example, for chargeback tracking.  When you describe your snapshot
        resource, this field is visible only if it has a non-empty value.
        """
        return pulumi.get(self, "chain_name")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> pulumi.Output[_builtins.int]:
        """
        Size of the snapshot, specified in GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The fingerprint used for optimistic locking of this resource. Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels to apply to this Snapshot.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def licenses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of public visible licenses that apply to this snapshot. This
        can be because the original image had licenses attached (such as a
        Windows image).  snapshotEncryptionKey nested object Encrypts the
        snapshot using a customer-supplied encryption key.
        """
        return pulumi.get(self, "licenses")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="snapshotEncryptionKey")
    def snapshot_encryption_key(self) -> pulumi.Output[Optional['outputs.SnapshotSnapshotEncryptionKey']]:
        """
        Encrypts the snapshot using a customer-supplied encryption key.
        After you encrypt a snapshot using a customer-supplied key, you must
        provide the same key if you use the snapshot later. For example, you
        must provide the encryption key when you create a disk from the
        encrypted snapshot in a future request.
        Customer-supplied encryption keys do not protect access to metadata of
        the snapshot.
        If you do not provide an encryption key when creating the snapshot,
        then the snapshot will be encrypted using an automatically generated
        key and you do not need to provide a key to use the snapshot later.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_encryption_key")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> pulumi.Output[_builtins.str]:
        """
        A reference to the disk used to create this snapshot.
        """
        return pulumi.get(self, "source_disk")

    @_builtins.property
    @pulumi.getter(name="sourceDiskEncryptionKey")
    def source_disk_encryption_key(self) -> pulumi.Output[Optional['outputs.SnapshotSourceDiskEncryptionKey']]:
        """
        The customer-supplied encryption key of the source snapshot. Required
        if the source snapshot is protected by a customer-supplied encryption
        key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_disk_encryption_key")

    @_builtins.property
    @pulumi.getter(name="storageBytes")
    def storage_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        A size of the storage used by the snapshot. As snapshots share
        storage, this number is expected to change with snapshot
        creation/deletion.
        """
        return pulumi.get(self, "storage_bytes")

    @_builtins.property
    @pulumi.getter(name="storageLocations")
    def storage_locations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
        """
        return pulumi.get(self, "storage_locations")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        A reference to the zone where the disk is hosted.
        """
        return pulumi.get(self, "zone")

