# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StoragePoolArgs', 'StoragePool']

@pulumi.input_type
class StoragePoolArgs:
    def __init__(__self__, *,
                 pool_provisioned_capacity_gb: pulumi.Input[_builtins.str],
                 pool_provisioned_throughput: pulumi.Input[_builtins.str],
                 storage_pool_type: pulumi.Input[_builtins.str],
                 capacity_provisioning_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_provisioning_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_provisioned_iops: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StoragePool resource.
        :param pulumi.Input[_builtins.str] pool_provisioned_capacity_gb: Size, in GiB, of the storage pool. For more information about the size limits,
               see https://cloud.google.com/compute/docs/disks/storage-pools.
        :param pulumi.Input[_builtins.str] pool_provisioned_throughput: Provisioned throughput, in MB/s, of the storage pool.
               Only relevant if the storage pool type is `hyperdisk-balanced` or `hyperdisk-throughput`.
        :param pulumi.Input[_builtins.str] storage_pool_type: Type of the storage pool. For example, the
               following are valid values:
               * `https://www.googleapis.com/compute/v1/projects/{project_id}/zones/{zone}/storagePoolTypes/hyperdisk-balanced`
               * `hyperdisk-throughput`
        :param pulumi.Input[_builtins.str] capacity_provisioning_type: Provisioning type of the byte capacity of the pool.
               Possible values are: `STANDARD`, `ADVANCED`.
        :param pulumi.Input[_builtins.str] description: A description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this storage pool. These can be later modified by the setLabels method.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with RFC1035.
               Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?`
               which means the first character must be a lowercase letter,
               and all following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] performance_provisioning_type: Provisioning type of the performance-related parameters of the pool, such as throughput and IOPS.
               Possible values are: `STANDARD`, `ADVANCED`.
        :param pulumi.Input[_builtins.str] pool_provisioned_iops: Provisioned IOPS of the storage pool.
               Only relevant if the storage pool type is `hyperdisk-balanced`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] zone: A reference to the zone where the storage pool resides.
        """
        pulumi.set(__self__, "pool_provisioned_capacity_gb", pool_provisioned_capacity_gb)
        pulumi.set(__self__, "pool_provisioned_throughput", pool_provisioned_throughput)
        pulumi.set(__self__, "storage_pool_type", storage_pool_type)
        if capacity_provisioning_type is not None:
            pulumi.set(__self__, "capacity_provisioning_type", capacity_provisioning_type)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_provisioning_type is not None:
            pulumi.set(__self__, "performance_provisioning_type", performance_provisioning_type)
        if pool_provisioned_iops is not None:
            pulumi.set(__self__, "pool_provisioned_iops", pool_provisioned_iops)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="poolProvisionedCapacityGb")
    def pool_provisioned_capacity_gb(self) -> pulumi.Input[_builtins.str]:
        """
        Size, in GiB, of the storage pool. For more information about the size limits,
        see https://cloud.google.com/compute/docs/disks/storage-pools.
        """
        return pulumi.get(self, "pool_provisioned_capacity_gb")

    @pool_provisioned_capacity_gb.setter
    def pool_provisioned_capacity_gb(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pool_provisioned_capacity_gb", value)

    @_builtins.property
    @pulumi.getter(name="poolProvisionedThroughput")
    def pool_provisioned_throughput(self) -> pulumi.Input[_builtins.str]:
        """
        Provisioned throughput, in MB/s, of the storage pool.
        Only relevant if the storage pool type is `hyperdisk-balanced` or `hyperdisk-throughput`.
        """
        return pulumi.get(self, "pool_provisioned_throughput")

    @pool_provisioned_throughput.setter
    def pool_provisioned_throughput(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pool_provisioned_throughput", value)

    @_builtins.property
    @pulumi.getter(name="storagePoolType")
    def storage_pool_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the storage pool. For example, the
        following are valid values:
        * `https://www.googleapis.com/compute/v1/projects/{project_id}/zones/{zone}/storagePoolTypes/hyperdisk-balanced`
        * `hyperdisk-throughput`
        """
        return pulumi.get(self, "storage_pool_type")

    @storage_pool_type.setter
    def storage_pool_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_pool_type", value)

    @_builtins.property
    @pulumi.getter(name="capacityProvisioningType")
    def capacity_provisioning_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning type of the byte capacity of the pool.
        Possible values are: `STANDARD`, `ADVANCED`.
        """
        return pulumi.get(self, "capacity_provisioning_type")

    @capacity_provisioning_type.setter
    def capacity_provisioning_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_provisioning_type", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to apply to this storage pool. These can be later modified by the setLabels method.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with RFC1035.
        Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?`
        which means the first character must be a lowercase letter,
        and all following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="performanceProvisioningType")
    def performance_provisioning_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning type of the performance-related parameters of the pool, such as throughput and IOPS.
        Possible values are: `STANDARD`, `ADVANCED`.
        """
        return pulumi.get(self, "performance_provisioning_type")

    @performance_provisioning_type.setter
    def performance_provisioning_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_provisioning_type", value)

    @_builtins.property
    @pulumi.getter(name="poolProvisionedIops")
    def pool_provisioned_iops(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioned IOPS of the storage pool.
        Only relevant if the storage pool type is `hyperdisk-balanced`.
        """
        return pulumi.get(self, "pool_provisioned_iops")

    @pool_provisioned_iops.setter
    def pool_provisioned_iops(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_provisioned_iops", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the zone where the storage pool resides.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _StoragePoolState:
    def __init__(__self__, *,
                 capacity_provisioning_type: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 label_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_provisioning_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_provisioned_capacity_gb: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_provisioned_iops: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_provisioned_throughput: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['StoragePoolResourceStatusArgs']]]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['StoragePoolStatusArgs']]]] = None,
                 storage_pool_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StoragePool resources.
        :param pulumi.Input[_builtins.str] capacity_provisioning_type: Provisioning type of the byte capacity of the pool.
               Possible values are: `STANDARD`, `ADVANCED`.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: A description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] kind: Type of the resource.
        :param pulumi.Input[_builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource.
               Used internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this storage pool. These can be later modified by the setLabels method.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with RFC1035.
               Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?`
               which means the first character must be a lowercase letter,
               and all following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] performance_provisioning_type: Provisioning type of the performance-related parameters of the pool, such as throughput and IOPS.
               Possible values are: `STANDARD`, `ADVANCED`.
        :param pulumi.Input[_builtins.str] pool_provisioned_capacity_gb: Size, in GiB, of the storage pool. For more information about the size limits,
               see https://cloud.google.com/compute/docs/disks/storage-pools.
        :param pulumi.Input[_builtins.str] pool_provisioned_iops: Provisioned IOPS of the storage pool.
               Only relevant if the storage pool type is `hyperdisk-balanced`.
        :param pulumi.Input[_builtins.str] pool_provisioned_throughput: Provisioned throughput, in MB/s, of the storage pool.
               Only relevant if the storage pool type is `hyperdisk-balanced` or `hyperdisk-throughput`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input['StoragePoolResourceStatusArgs']]] resource_statuses: Status information for the storage pool resource.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['StoragePoolStatusArgs']]] statuses: Status information for the storage pool resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] storage_pool_type: Type of the storage pool. For example, the
               following are valid values:
               * `https://www.googleapis.com/compute/v1/projects/{project_id}/zones/{zone}/storagePoolTypes/hyperdisk-balanced`
               * `hyperdisk-throughput`
        :param pulumi.Input[_builtins.str] zone: A reference to the zone where the storage pool resides.
        """
        if capacity_provisioning_type is not None:
            pulumi.set(__self__, "capacity_provisioning_type", capacity_provisioning_type)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_provisioning_type is not None:
            pulumi.set(__self__, "performance_provisioning_type", performance_provisioning_type)
        if pool_provisioned_capacity_gb is not None:
            pulumi.set(__self__, "pool_provisioned_capacity_gb", pool_provisioned_capacity_gb)
        if pool_provisioned_iops is not None:
            pulumi.set(__self__, "pool_provisioned_iops", pool_provisioned_iops)
        if pool_provisioned_throughput is not None:
            pulumi.set(__self__, "pool_provisioned_throughput", pool_provisioned_throughput)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if resource_statuses is not None:
            pulumi.set(__self__, "resource_statuses", resource_statuses)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if storage_pool_type is not None:
            pulumi.set(__self__, "storage_pool_type", storage_pool_type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="capacityProvisioningType")
    def capacity_provisioning_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning type of the byte capacity of the pool.
        Possible values are: `STANDARD`, `ADVANCED`.
        """
        return pulumi.get(self, "capacity_provisioning_type")

    @capacity_provisioning_type.setter
    def capacity_provisioning_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_provisioning_type", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fingerprint used for optimistic locking of this resource.
        Used internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label_fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to apply to this storage pool. These can be later modified by the setLabels method.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with RFC1035.
        Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?`
        which means the first character must be a lowercase letter,
        and all following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="performanceProvisioningType")
    def performance_provisioning_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning type of the performance-related parameters of the pool, such as throughput and IOPS.
        Possible values are: `STANDARD`, `ADVANCED`.
        """
        return pulumi.get(self, "performance_provisioning_type")

    @performance_provisioning_type.setter
    def performance_provisioning_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_provisioning_type", value)

    @_builtins.property
    @pulumi.getter(name="poolProvisionedCapacityGb")
    def pool_provisioned_capacity_gb(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Size, in GiB, of the storage pool. For more information about the size limits,
        see https://cloud.google.com/compute/docs/disks/storage-pools.
        """
        return pulumi.get(self, "pool_provisioned_capacity_gb")

    @pool_provisioned_capacity_gb.setter
    def pool_provisioned_capacity_gb(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_provisioned_capacity_gb", value)

    @_builtins.property
    @pulumi.getter(name="poolProvisionedIops")
    def pool_provisioned_iops(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioned IOPS of the storage pool.
        Only relevant if the storage pool type is `hyperdisk-balanced`.
        """
        return pulumi.get(self, "pool_provisioned_iops")

    @pool_provisioned_iops.setter
    def pool_provisioned_iops(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_provisioned_iops", value)

    @_builtins.property
    @pulumi.getter(name="poolProvisionedThroughput")
    def pool_provisioned_throughput(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioned throughput, in MB/s, of the storage pool.
        Only relevant if the storage pool type is `hyperdisk-balanced` or `hyperdisk-throughput`.
        """
        return pulumi.get(self, "pool_provisioned_throughput")

    @pool_provisioned_throughput.setter
    def pool_provisioned_throughput(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_provisioned_throughput", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="resourceStatuses")
    def resource_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StoragePoolResourceStatusArgs']]]]:
        """
        Status information for the storage pool resource.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_statuses")

    @resource_statuses.setter
    def resource_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StoragePoolResourceStatusArgs']]]]):
        pulumi.set(self, "resource_statuses", value)

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StoragePoolStatusArgs']]]]:
        """
        Status information for the storage pool resource.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StoragePoolStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @_builtins.property
    @pulumi.getter(name="storagePoolType")
    def storage_pool_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the storage pool. For example, the
        following are valid values:
        * `https://www.googleapis.com/compute/v1/projects/{project_id}/zones/{zone}/storagePoolTypes/hyperdisk-balanced`
        * `hyperdisk-throughput`
        """
        return pulumi.get(self, "storage_pool_type")

    @storage_pool_type.setter
    def storage_pool_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_pool_type", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the zone where the storage pool resides.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:compute/storagePool:StoragePool")
class StoragePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_provisioning_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_provisioning_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_provisioned_capacity_gb: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_provisioned_iops: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_provisioned_throughput: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_pool_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Hyperdisk Storage Pool is a pre-purchased collection of capacity, throughput, and IOPS
        which you can then provision to your applications as needed.
        You can use Hyperdisk Storage Pools to create and manage disks in pools and use the disks across multiple workloads.

        To get more information about StoragePool, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/storagePools)
        * How-to Guides
            * [Create Hyperdisk Storage Pools](https://cloud.google.com/compute/docs/disks/create-storage-pools)

        ## Example Usage

        ### Compute Storage Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_storage_pool_basic = gcp.compute.StoragePool("test-storage-pool-basic",
            name="storage-pool-basic",
            pool_provisioned_capacity_gb="10240",
            pool_provisioned_throughput="100",
            storage_pool_type="hyperdisk-throughput",
            zone="us-central1-a",
            labels={
                "environment": "test",
                "purpose": "storage-pool-testing",
                "team": "infrastructure",
                "cost_center": "engineering",
            },
            deletion_protection=False)
        project = gcp.organizations.get_project()
        ```
        ### Compute Storage Pool Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        balanced = gcp.compute.get_storage_pool_types(zone="us-central1-a",
            storage_pool_type="hyperdisk-balanced")
        test_storage_pool_full = gcp.compute.StoragePool("test-storage-pool-full",
            name="storage-pool-full",
            description="Hyperdisk Balanced storage pool",
            capacity_provisioning_type="STANDARD",
            pool_provisioned_capacity_gb="10240",
            performance_provisioning_type="STANDARD",
            pool_provisioned_iops="10000",
            pool_provisioned_throughput="1024",
            storage_pool_type=balanced.self_link,
            labels={
                "environment": "test",
                "purpose": "storage-pool-testing",
                "team": "infrastructure",
                "cost_center": "engineering",
            },
            deletion_protection=False,
            zone="us-central1-a")
        project = gcp.organizations.get_project()
        ```

        ## Import

        StoragePool can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/storagePools/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, StoragePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/storagePool:StoragePool default projects/{{project}}/zones/{{zone}}/storagePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/storagePool:StoragePool default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/storagePool:StoragePool default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/storagePool:StoragePool default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] capacity_provisioning_type: Provisioning type of the byte capacity of the pool.
               Possible values are: `STANDARD`, `ADVANCED`.
        :param pulumi.Input[_builtins.str] description: A description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this storage pool. These can be later modified by the setLabels method.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with RFC1035.
               Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?`
               which means the first character must be a lowercase letter,
               and all following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] performance_provisioning_type: Provisioning type of the performance-related parameters of the pool, such as throughput and IOPS.
               Possible values are: `STANDARD`, `ADVANCED`.
        :param pulumi.Input[_builtins.str] pool_provisioned_capacity_gb: Size, in GiB, of the storage pool. For more information about the size limits,
               see https://cloud.google.com/compute/docs/disks/storage-pools.
        :param pulumi.Input[_builtins.str] pool_provisioned_iops: Provisioned IOPS of the storage pool.
               Only relevant if the storage pool type is `hyperdisk-balanced`.
        :param pulumi.Input[_builtins.str] pool_provisioned_throughput: Provisioned throughput, in MB/s, of the storage pool.
               Only relevant if the storage pool type is `hyperdisk-balanced` or `hyperdisk-throughput`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] storage_pool_type: Type of the storage pool. For example, the
               following are valid values:
               * `https://www.googleapis.com/compute/v1/projects/{project_id}/zones/{zone}/storagePoolTypes/hyperdisk-balanced`
               * `hyperdisk-throughput`
        :param pulumi.Input[_builtins.str] zone: A reference to the zone where the storage pool resides.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StoragePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Hyperdisk Storage Pool is a pre-purchased collection of capacity, throughput, and IOPS
        which you can then provision to your applications as needed.
        You can use Hyperdisk Storage Pools to create and manage disks in pools and use the disks across multiple workloads.

        To get more information about StoragePool, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/storagePools)
        * How-to Guides
            * [Create Hyperdisk Storage Pools](https://cloud.google.com/compute/docs/disks/create-storage-pools)

        ## Example Usage

        ### Compute Storage Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_storage_pool_basic = gcp.compute.StoragePool("test-storage-pool-basic",
            name="storage-pool-basic",
            pool_provisioned_capacity_gb="10240",
            pool_provisioned_throughput="100",
            storage_pool_type="hyperdisk-throughput",
            zone="us-central1-a",
            labels={
                "environment": "test",
                "purpose": "storage-pool-testing",
                "team": "infrastructure",
                "cost_center": "engineering",
            },
            deletion_protection=False)
        project = gcp.organizations.get_project()
        ```
        ### Compute Storage Pool Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        balanced = gcp.compute.get_storage_pool_types(zone="us-central1-a",
            storage_pool_type="hyperdisk-balanced")
        test_storage_pool_full = gcp.compute.StoragePool("test-storage-pool-full",
            name="storage-pool-full",
            description="Hyperdisk Balanced storage pool",
            capacity_provisioning_type="STANDARD",
            pool_provisioned_capacity_gb="10240",
            performance_provisioning_type="STANDARD",
            pool_provisioned_iops="10000",
            pool_provisioned_throughput="1024",
            storage_pool_type=balanced.self_link,
            labels={
                "environment": "test",
                "purpose": "storage-pool-testing",
                "team": "infrastructure",
                "cost_center": "engineering",
            },
            deletion_protection=False,
            zone="us-central1-a")
        project = gcp.organizations.get_project()
        ```

        ## Import

        StoragePool can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/storagePools/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, StoragePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/storagePool:StoragePool default projects/{{project}}/zones/{{zone}}/storagePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/storagePool:StoragePool default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/storagePool:StoragePool default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/storagePool:StoragePool default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param StoragePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StoragePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_provisioning_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_provisioning_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_provisioned_capacity_gb: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_provisioned_iops: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_provisioned_throughput: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_pool_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StoragePoolArgs.__new__(StoragePoolArgs)

            __props__.__dict__["capacity_provisioning_type"] = capacity_provisioning_type
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["performance_provisioning_type"] = performance_provisioning_type
            if pool_provisioned_capacity_gb is None and not opts.urn:
                raise TypeError("Missing required property 'pool_provisioned_capacity_gb'")
            __props__.__dict__["pool_provisioned_capacity_gb"] = pool_provisioned_capacity_gb
            __props__.__dict__["pool_provisioned_iops"] = pool_provisioned_iops
            if pool_provisioned_throughput is None and not opts.urn:
                raise TypeError("Missing required property 'pool_provisioned_throughput'")
            __props__.__dict__["pool_provisioned_throughput"] = pool_provisioned_throughput
            __props__.__dict__["project"] = project
            if storage_pool_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_pool_type'")
            __props__.__dict__["storage_pool_type"] = storage_pool_type
            __props__.__dict__["zone"] = zone
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["resource_statuses"] = None
            __props__.__dict__["statuses"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(StoragePool, __self__).__init__(
            'gcp:compute/storagePool:StoragePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity_provisioning_type: Optional[pulumi.Input[_builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            label_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            performance_provisioning_type: Optional[pulumi.Input[_builtins.str]] = None,
            pool_provisioned_capacity_gb: Optional[pulumi.Input[_builtins.str]] = None,
            pool_provisioned_iops: Optional[pulumi.Input[_builtins.str]] = None,
            pool_provisioned_throughput: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            resource_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StoragePoolResourceStatusArgs', 'StoragePoolResourceStatusArgsDict']]]]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StoragePoolStatusArgs', 'StoragePoolStatusArgsDict']]]]] = None,
            storage_pool_type: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'StoragePool':
        """
        Get an existing StoragePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] capacity_provisioning_type: Provisioning type of the byte capacity of the pool.
               Possible values are: `STANDARD`, `ADVANCED`.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: A description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] kind: Type of the resource.
        :param pulumi.Input[_builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource.
               Used internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to apply to this storage pool. These can be later modified by the setLabels method.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created.
               The name must be 1-63 characters long, and comply with RFC1035.
               Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?`
               which means the first character must be a lowercase letter,
               and all following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] performance_provisioning_type: Provisioning type of the performance-related parameters of the pool, such as throughput and IOPS.
               Possible values are: `STANDARD`, `ADVANCED`.
        :param pulumi.Input[_builtins.str] pool_provisioned_capacity_gb: Size, in GiB, of the storage pool. For more information about the size limits,
               see https://cloud.google.com/compute/docs/disks/storage-pools.
        :param pulumi.Input[_builtins.str] pool_provisioned_iops: Provisioned IOPS of the storage pool.
               Only relevant if the storage pool type is `hyperdisk-balanced`.
        :param pulumi.Input[_builtins.str] pool_provisioned_throughput: Provisioned throughput, in MB/s, of the storage pool.
               Only relevant if the storage pool type is `hyperdisk-balanced` or `hyperdisk-throughput`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StoragePoolResourceStatusArgs', 'StoragePoolResourceStatusArgsDict']]]] resource_statuses: Status information for the storage pool resource.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StoragePoolStatusArgs', 'StoragePoolStatusArgsDict']]]] statuses: Status information for the storage pool resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] storage_pool_type: Type of the storage pool. For example, the
               following are valid values:
               * `https://www.googleapis.com/compute/v1/projects/{project_id}/zones/{zone}/storagePoolTypes/hyperdisk-balanced`
               * `hyperdisk-throughput`
        :param pulumi.Input[_builtins.str] zone: A reference to the zone where the storage pool resides.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StoragePoolState.__new__(_StoragePoolState)

        __props__.__dict__["capacity_provisioning_type"] = capacity_provisioning_type
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["kind"] = kind
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["performance_provisioning_type"] = performance_provisioning_type
        __props__.__dict__["pool_provisioned_capacity_gb"] = pool_provisioned_capacity_gb
        __props__.__dict__["pool_provisioned_iops"] = pool_provisioned_iops
        __props__.__dict__["pool_provisioned_throughput"] = pool_provisioned_throughput
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["resource_statuses"] = resource_statuses
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["storage_pool_type"] = storage_pool_type
        __props__.__dict__["zone"] = zone
        return StoragePool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="capacityProvisioningType")
    def capacity_provisioning_type(self) -> pulumi.Output[_builtins.str]:
        """
        Provisioning type of the byte capacity of the pool.
        Possible values are: `STANDARD`, `ADVANCED`.
        """
        return pulumi.get(self, "capacity_provisioning_type")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The fingerprint used for optimistic locking of this resource.
        Used internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels to apply to this storage pool. These can be later modified by the setLabels method.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is created.
        The name must be 1-63 characters long, and comply with RFC1035.
        Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?`
        which means the first character must be a lowercase letter,
        and all following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="performanceProvisioningType")
    def performance_provisioning_type(self) -> pulumi.Output[_builtins.str]:
        """
        Provisioning type of the performance-related parameters of the pool, such as throughput and IOPS.
        Possible values are: `STANDARD`, `ADVANCED`.
        """
        return pulumi.get(self, "performance_provisioning_type")

    @_builtins.property
    @pulumi.getter(name="poolProvisionedCapacityGb")
    def pool_provisioned_capacity_gb(self) -> pulumi.Output[_builtins.str]:
        """
        Size, in GiB, of the storage pool. For more information about the size limits,
        see https://cloud.google.com/compute/docs/disks/storage-pools.
        """
        return pulumi.get(self, "pool_provisioned_capacity_gb")

    @_builtins.property
    @pulumi.getter(name="poolProvisionedIops")
    def pool_provisioned_iops(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provisioned IOPS of the storage pool.
        Only relevant if the storage pool type is `hyperdisk-balanced`.
        """
        return pulumi.get(self, "pool_provisioned_iops")

    @_builtins.property
    @pulumi.getter(name="poolProvisionedThroughput")
    def pool_provisioned_throughput(self) -> pulumi.Output[_builtins.str]:
        """
        Provisioned throughput, in MB/s, of the storage pool.
        Only relevant if the storage pool type is `hyperdisk-balanced` or `hyperdisk-throughput`.
        """
        return pulumi.get(self, "pool_provisioned_throughput")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="resourceStatuses")
    def resource_statuses(self) -> pulumi.Output[Sequence['outputs.StoragePoolResourceStatus']]:
        """
        Status information for the storage pool resource.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_statuses")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.StoragePoolStatus']]:
        """
        Status information for the storage pool resource.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @_builtins.property
    @pulumi.getter(name="storagePoolType")
    def storage_pool_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the storage pool. For example, the
        following are valid values:
        * `https://www.googleapis.com/compute/v1/projects/{project_id}/zones/{zone}/storagePoolTypes/hyperdisk-balanced`
        * `hyperdisk-throughput`
        """
        return pulumi.get(self, "storage_pool_type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        A reference to the zone where the storage pool resides.
        """
        return pulumi.get(self, "zone")

