# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TagTemplateArgs', 'TagTemplate']

@pulumi.input_type
class TagTemplateArgs:
    def __init__(__self__, *,
                 fields: pulumi.Input[Sequence[pulumi.Input['TagTemplateFieldArgs']]],
                 tag_template_id: pulumi.Input[_builtins.str],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TagTemplate resource.
        :param pulumi.Input[Sequence[pulumi.Input['TagTemplateFieldArgs']]] fields: Set of tag template field IDs and the settings for the field. This set is an exhaustive list of the allowed fields. This set must contain at least one field and at most 500 fields. The change of field_id will be resulting in re-creating of field. The change of primitive_type will be resulting in re-creating of field, however if the field is a required, you cannot update it.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] tag_template_id: The id of the tag template to create.
        :param pulumi.Input[_builtins.str] display_name: The display name for this template.
        :param pulumi.Input[_builtins.bool] force_delete: This confirms the deletion of any possible tags using this template. Must be set to true in order to delete the tag template.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Template location region.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "tag_template_id", tag_template_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def fields(self) -> pulumi.Input[Sequence[pulumi.Input['TagTemplateFieldArgs']]]:
        """
        Set of tag template field IDs and the settings for the field. This set is an exhaustive list of the allowed fields. This set must contain at least one field and at most 500 fields. The change of field_id will be resulting in re-creating of field. The change of primitive_type will be resulting in re-creating of field, however if the field is a required, you cannot update it.
        Structure is documented below.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: pulumi.Input[Sequence[pulumi.Input['TagTemplateFieldArgs']]]):
        pulumi.set(self, "fields", value)

    @_builtins.property
    @pulumi.getter(name="tagTemplateId")
    def tag_template_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the tag template to create.
        """
        return pulumi.get(self, "tag_template_id")

    @tag_template_id.setter
    def tag_template_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tag_template_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for this template.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This confirms the deletion of any possible tags using this template. Must be set to true in order to delete the tag template.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Template location region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _TagTemplateState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['TagTemplateFieldArgs']]]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_template_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TagTemplate resources.
        :param pulumi.Input[_builtins.str] display_name: The display name for this template.
        :param pulumi.Input[Sequence[pulumi.Input['TagTemplateFieldArgs']]] fields: Set of tag template field IDs and the settings for the field. This set is an exhaustive list of the allowed fields. This set must contain at least one field and at most 500 fields. The change of field_id will be resulting in re-creating of field. The change of primitive_type will be resulting in re-creating of field, however if the field is a required, you cannot update it.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] force_delete: This confirms the deletion of any possible tags using this template. Must be set to true in order to delete the tag template.
        :param pulumi.Input[_builtins.str] name: The resource name of the tag template in URL format. Example: projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Template location region.
        :param pulumi.Input[_builtins.str] tag_template_id: The id of the tag template to create.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tag_template_id is not None:
            pulumi.set(__self__, "tag_template_id", tag_template_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for this template.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TagTemplateFieldArgs']]]]:
        """
        Set of tag template field IDs and the settings for the field. This set is an exhaustive list of the allowed fields. This set must contain at least one field and at most 500 fields. The change of field_id will be resulting in re-creating of field. The change of primitive_type will be resulting in re-creating of field, however if the field is a required, you cannot update it.
        Structure is documented below.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TagTemplateFieldArgs']]]]):
        pulumi.set(self, "fields", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This confirms the deletion of any possible tags using this template. Must be set to true in order to delete the tag template.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the tag template in URL format. Example: projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Template location region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tagTemplateId")
    def tag_template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the tag template to create.
        """
        return pulumi.get(self, "tag_template_id")

    @tag_template_id.setter
    def tag_template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_template_id", value)


@pulumi.type_token("gcp:datacatalog/tagTemplate:TagTemplate")
class TagTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagTemplateFieldArgs', 'TagTemplateFieldArgsDict']]]]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **Warning:** `datacatalog.TagTemplate` is deprecated and will be removed in a future major release. Use `dataplex.AspectType` instead. For steps to transition your Data Catalog users, workloads, and content to Dataplex Catalog, see https://cloud.google.com/dataplex/docs/transition-to-dataplex-catalog.

        A tag template defines a tag, which can have one or more typed fields.
        The template is used to create and attach the tag to GCP resources.

        To get more information about TagTemplate, see:

        * [API documentation](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/data-catalog/docs)

        ## Example Usage

        ### Data Catalog Tag Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_tag_template = gcp.datacatalog.TagTemplate("basic_tag_template",
            tag_template_id="my_template",
            region="us-central1",
            display_name="Demo Tag Template",
            fields=[
                {
                    "field_id": "source",
                    "display_name": "Source of data asset",
                    "type": {
                        "primitive_type": "STRING",
                    },
                    "is_required": True,
                },
                {
                    "field_id": "num_rows",
                    "display_name": "Number of rows in the data asset",
                    "type": {
                        "primitive_type": "DOUBLE",
                    },
                },
                {
                    "field_id": "pii_type",
                    "display_name": "PII type",
                    "type": {
                        "enum_type": {
                            "allowed_values": [
                                {
                                    "display_name": "EMAIL",
                                },
                                {
                                    "display_name": "SOCIAL SECURITY NUMBER",
                                },
                                {
                                    "display_name": "NONE",
                                },
                            ],
                        },
                    },
                },
            ],
            force_delete=False)
        ```

        ## Import

        TagTemplate can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, TagTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:datacatalog/tagTemplate:TagTemplate default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The display name for this template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TagTemplateFieldArgs', 'TagTemplateFieldArgsDict']]]] fields: Set of tag template field IDs and the settings for the field. This set is an exhaustive list of the allowed fields. This set must contain at least one field and at most 500 fields. The change of field_id will be resulting in re-creating of field. The change of primitive_type will be resulting in re-creating of field, however if the field is a required, you cannot update it.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] force_delete: This confirms the deletion of any possible tags using this template. Must be set to true in order to delete the tag template.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Template location region.
        :param pulumi.Input[_builtins.str] tag_template_id: The id of the tag template to create.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TagTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Warning:** `datacatalog.TagTemplate` is deprecated and will be removed in a future major release. Use `dataplex.AspectType` instead. For steps to transition your Data Catalog users, workloads, and content to Dataplex Catalog, see https://cloud.google.com/dataplex/docs/transition-to-dataplex-catalog.

        A tag template defines a tag, which can have one or more typed fields.
        The template is used to create and attach the tag to GCP resources.

        To get more information about TagTemplate, see:

        * [API documentation](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/data-catalog/docs)

        ## Example Usage

        ### Data Catalog Tag Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_tag_template = gcp.datacatalog.TagTemplate("basic_tag_template",
            tag_template_id="my_template",
            region="us-central1",
            display_name="Demo Tag Template",
            fields=[
                {
                    "field_id": "source",
                    "display_name": "Source of data asset",
                    "type": {
                        "primitive_type": "STRING",
                    },
                    "is_required": True,
                },
                {
                    "field_id": "num_rows",
                    "display_name": "Number of rows in the data asset",
                    "type": {
                        "primitive_type": "DOUBLE",
                    },
                },
                {
                    "field_id": "pii_type",
                    "display_name": "PII type",
                    "type": {
                        "enum_type": {
                            "allowed_values": [
                                {
                                    "display_name": "EMAIL",
                                },
                                {
                                    "display_name": "SOCIAL SECURITY NUMBER",
                                },
                                {
                                    "display_name": "NONE",
                                },
                            ],
                        },
                    },
                },
            ],
            force_delete=False)
        ```

        ## Import

        TagTemplate can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, TagTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:datacatalog/tagTemplate:TagTemplate default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TagTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TagTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagTemplateFieldArgs', 'TagTemplateFieldArgsDict']]]]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TagTemplateArgs.__new__(TagTemplateArgs)

            __props__.__dict__["display_name"] = display_name
            if fields is None and not opts.urn:
                raise TypeError("Missing required property 'fields'")
            __props__.__dict__["fields"] = fields
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if tag_template_id is None and not opts.urn:
                raise TypeError("Missing required property 'tag_template_id'")
            __props__.__dict__["tag_template_id"] = tag_template_id
            __props__.__dict__["name"] = None
        super(TagTemplate, __self__).__init__(
            'gcp:datacatalog/tagTemplate:TagTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagTemplateFieldArgs', 'TagTemplateFieldArgsDict']]]]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tag_template_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TagTemplate':
        """
        Get an existing TagTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The display name for this template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TagTemplateFieldArgs', 'TagTemplateFieldArgsDict']]]] fields: Set of tag template field IDs and the settings for the field. This set is an exhaustive list of the allowed fields. This set must contain at least one field and at most 500 fields. The change of field_id will be resulting in re-creating of field. The change of primitive_type will be resulting in re-creating of field, however if the field is a required, you cannot update it.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] force_delete: This confirms the deletion of any possible tags using this template. Must be set to true in order to delete the tag template.
        :param pulumi.Input[_builtins.str] name: The resource name of the tag template in URL format. Example: projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Template location region.
        :param pulumi.Input[_builtins.str] tag_template_id: The id of the tag template to create.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TagTemplateState.__new__(_TagTemplateState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fields"] = fields
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["tag_template_id"] = tag_template_id
        return TagTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The display name for this template.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Sequence['outputs.TagTemplateField']]:
        """
        Set of tag template field IDs and the settings for the field. This set is an exhaustive list of the allowed fields. This set must contain at least one field and at most 500 fields. The change of field_id will be resulting in re-creating of field. The change of primitive_type will be resulting in re-creating of field, however if the field is a required, you cannot update it.
        Structure is documented below.
        """
        return pulumi.get(self, "fields")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This confirms the deletion of any possible tags using this template. Must be set to true in order to delete the tag template.
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the tag template in URL format. Example: projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Template location region.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="tagTemplateId")
    def tag_template_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the tag template to create.
        """
        return pulumi.get(self, "tag_template_id")

