# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FlexTemplateJobArgs', 'FlexTemplateJob']

@pulumi.input_type
class FlexTemplateJobArgs:
    def __init__(__self__, *,
                 container_spec_gcs_path: pulumi.Input[_builtins.str],
                 additional_experiments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 additional_pipeline_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 autoscaling_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_streaming_engine: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launcher_machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 num_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 on_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sdk_container_image: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wait_on_job_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 staging_location: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 temp_location: Optional[pulumi.Input[_builtins.str]] = None,
                 transform_name_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a FlexTemplateJob resource.
        :param pulumi.Input[_builtins.str] container_spec_gcs_path: The GCS path to the Dataflow job Flex
               Template.
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_experiments: List of experiments that should be used by the job. An example value is `["enable_stackdriver_agent_metrics"]`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_pipeline_options: List of pipeline options that should be used by the job. An example value is `["numberOfWorkerHarnessThreads=20"]`.
        :param pulumi.Input[_builtins.str] autoscaling_algorithm: The algorithm to use for autoscaling.
        :param pulumi.Input[_builtins.bool] enable_streaming_engine: Immutable. Indicates if the job should use the streaming engine feature.
        :param pulumi.Input[_builtins.str] ip_configuration: The configuration for VM IPs.  Options are `"WORKER_IP_PUBLIC"` or `"WORKER_IP_PRIVATE"`.
        :param pulumi.Input[_builtins.str] kms_key_name: The name for the Cloud KMS key for the job. Key format is: `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User labels to be specified for the job. Keys and values
               should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
               page. **Note**: This field is marked as deprecated as the API does not currently
               support adding labels.
               **NOTE**: Google-provided Dataflow templates often provide default labels
               that begin with `goog-dataflow-provided`. Unless explicitly set in config, these
               labels will be ignored to prevent diffs on re-apply.
        :param pulumi.Input[_builtins.str] launcher_machine_type: The machine type to use for launching the job. The default is n1-standard-1.
        :param pulumi.Input[_builtins.str] machine_type: The machine type to use for the job.
        :param pulumi.Input[_builtins.int] max_workers: Immutable. The maximum number of Google Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param pulumi.Input[_builtins.str] name: Immutable. A unique name for the resource, required by Dataflow.
        :param pulumi.Input[_builtins.str] network: The network to which VMs will be assigned. If it is not provided, "default" will be used.
        :param pulumi.Input[_builtins.int] num_workers: Immutable. The initial number of Google Compute Engine instances for the job.
        :param pulumi.Input[_builtins.str] on_delete: One of "drain" or "cancel". Specifies behavior of
               deletion during `pulumi destroy`.  See above note.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: **Template specific** Key/Value pairs to be forwarded to the pipeline's options; keys are
               case-sensitive based on the language on which the pipeline is coded, mostly Java.
               **Note**: do not configure Dataflow options here in parameters.
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it is not
               provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Immutable. The region in which the created job should run.
        :param pulumi.Input[_builtins.str] sdk_container_image: Docker registry location of container image to use for the 'worker harness. Default is the container for the version of the SDK. Note this field is only valid for portable pipelines.
        :param pulumi.Input[_builtins.str] service_account_email: Service account email to run the workers as. This should be just an email e.g. `myserviceaccount@myproject.iam.gserviceaccount.com`. Do not include any `serviceAccount:` or other prefix.
        :param pulumi.Input[_builtins.str] staging_location: The Cloud Storage path to use for staging files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param pulumi.Input[_builtins.str] subnetwork: The subnetwork to which VMs will be assigned. Should be of the form "regions/REGION/subnetworks/SUBNETWORK".
        :param pulumi.Input[_builtins.str] temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] transform_name_mapping: Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.
        """
        pulumi.set(__self__, "container_spec_gcs_path", container_spec_gcs_path)
        if additional_experiments is not None:
            pulumi.set(__self__, "additional_experiments", additional_experiments)
        if additional_pipeline_options is not None:
            pulumi.set(__self__, "additional_pipeline_options", additional_pipeline_options)
        if autoscaling_algorithm is not None:
            pulumi.set(__self__, "autoscaling_algorithm", autoscaling_algorithm)
        if enable_streaming_engine is not None:
            pulumi.set(__self__, "enable_streaming_engine", enable_streaming_engine)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launcher_machine_type is not None:
            pulumi.set(__self__, "launcher_machine_type", launcher_machine_type)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if on_delete is not None:
            pulumi.set(__self__, "on_delete", on_delete)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sdk_container_image is not None:
            pulumi.set(__self__, "sdk_container_image", sdk_container_image)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if skip_wait_on_job_termination is not None:
            pulumi.set(__self__, "skip_wait_on_job_termination", skip_wait_on_job_termination)
        if staging_location is not None:
            pulumi.set(__self__, "staging_location", staging_location)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if temp_location is not None:
            pulumi.set(__self__, "temp_location", temp_location)
        if transform_name_mapping is not None:
            pulumi.set(__self__, "transform_name_mapping", transform_name_mapping)

    @_builtins.property
    @pulumi.getter(name="containerSpecGcsPath")
    def container_spec_gcs_path(self) -> pulumi.Input[_builtins.str]:
        """
        The GCS path to the Dataflow job Flex
        Template.

        - - -
        """
        return pulumi.get(self, "container_spec_gcs_path")

    @container_spec_gcs_path.setter
    def container_spec_gcs_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_spec_gcs_path", value)

    @_builtins.property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of experiments that should be used by the job. An example value is `["enable_stackdriver_agent_metrics"]`.
        """
        return pulumi.get(self, "additional_experiments")

    @additional_experiments.setter
    def additional_experiments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_experiments", value)

    @_builtins.property
    @pulumi.getter(name="additionalPipelineOptions")
    def additional_pipeline_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of pipeline options that should be used by the job. An example value is `["numberOfWorkerHarnessThreads=20"]`.
        """
        return pulumi.get(self, "additional_pipeline_options")

    @additional_pipeline_options.setter
    def additional_pipeline_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_pipeline_options", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingAlgorithm")
    def autoscaling_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm to use for autoscaling.
        """
        return pulumi.get(self, "autoscaling_algorithm")

    @autoscaling_algorithm.setter
    def autoscaling_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autoscaling_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Immutable. Indicates if the job should use the streaming engine feature.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @enable_streaming_engine.setter
    def enable_streaming_engine(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_streaming_engine", value)

    @_builtins.property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration for VM IPs.  Options are `"WORKER_IP_PUBLIC"` or `"WORKER_IP_PRIVATE"`.
        """
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_configuration", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the Cloud KMS key for the job. Key format is: `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User labels to be specified for the job. Keys and values
        should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
        page. **Note**: This field is marked as deprecated as the API does not currently
        support adding labels.
        **NOTE**: Google-provided Dataflow templates often provide default labels
        that begin with `goog-dataflow-provided`. Unless explicitly set in config, these
        labels will be ignored to prevent diffs on re-apply.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="launcherMachineType")
    def launcher_machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The machine type to use for launching the job. The default is n1-standard-1.
        """
        return pulumi.get(self, "launcher_machine_type")

    @launcher_machine_type.setter
    def launcher_machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launcher_machine_type", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The machine type to use for the job.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Immutable. The maximum number of Google Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @max_workers.setter
    def max_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_workers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Immutable. A unique name for the resource, required by Dataflow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network to which VMs will be assigned. If it is not provided, "default" will be used.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Immutable. The initial number of Google Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @num_workers.setter
    def num_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_workers", value)

    @_builtins.property
    @pulumi.getter(name="onDelete")
    def on_delete(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        One of "drain" or "cancel". Specifies behavior of
        deletion during `pulumi destroy`.  See above note.
        """
        return pulumi.get(self, "on_delete")

    @on_delete.setter
    def on_delete(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_delete", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        **Template specific** Key/Value pairs to be forwarded to the pipeline's options; keys are
        case-sensitive based on the language on which the pipeline is coded, mostly Java.
        **Note**: do not configure Dataflow options here in parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project in which the resource belongs. If it is not
        provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Immutable. The region in which the created job should run.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sdkContainerImage")
    def sdk_container_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Docker registry location of container image to use for the 'worker harness. Default is the container for the version of the SDK. Note this field is only valid for portable pipelines.
        """
        return pulumi.get(self, "sdk_container_image")

    @sdk_container_image.setter
    def sdk_container_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sdk_container_image", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account email to run the workers as. This should be just an email e.g. `myserviceaccount@myproject.iam.gserviceaccount.com`. Do not include any `serviceAccount:` or other prefix.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter(name="skipWaitOnJobTermination")
    def skip_wait_on_job_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "skip_wait_on_job_termination")

    @skip_wait_on_job_termination.setter
    def skip_wait_on_job_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_wait_on_job_termination", value)

    @_builtins.property
    @pulumi.getter(name="stagingLocation")
    def staging_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Cloud Storage path to use for staging files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        return pulumi.get(self, "staging_location")

    @staging_location.setter
    def staging_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "staging_location", value)

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnetwork to which VMs will be assigned. Should be of the form "regions/REGION/subnetworks/SUBNETWORK".
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @_builtins.property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        return pulumi.get(self, "temp_location")

    @temp_location.setter
    def temp_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "temp_location", value)

    @_builtins.property
    @pulumi.getter(name="transformNameMapping")
    def transform_name_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.
        """
        return pulumi.get(self, "transform_name_mapping")

    @transform_name_mapping.setter
    def transform_name_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "transform_name_mapping", value)


@pulumi.input_type
class _FlexTemplateJobState:
    def __init__(__self__, *,
                 additional_experiments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 additional_pipeline_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 autoscaling_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 container_spec_gcs_path: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enable_streaming_engine: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launcher_machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 num_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 on_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sdk_container_image: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wait_on_job_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 staging_location: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 temp_location: Optional[pulumi.Input[_builtins.str]] = None,
                 transform_name_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlexTemplateJob resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_experiments: List of experiments that should be used by the job. An example value is `["enable_stackdriver_agent_metrics"]`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_pipeline_options: List of pipeline options that should be used by the job. An example value is `["numberOfWorkerHarnessThreads=20"]`.
        :param pulumi.Input[_builtins.str] autoscaling_algorithm: The algorithm to use for autoscaling.
        :param pulumi.Input[_builtins.str] container_spec_gcs_path: The GCS path to the Dataflow job Flex
               Template.
               
               - - -
        :param pulumi.Input[_builtins.bool] enable_streaming_engine: Immutable. Indicates if the job should use the streaming engine feature.
        :param pulumi.Input[_builtins.str] ip_configuration: The configuration for VM IPs.  Options are `"WORKER_IP_PUBLIC"` or `"WORKER_IP_PRIVATE"`.
        :param pulumi.Input[_builtins.str] job_id: The unique ID of this job.
        :param pulumi.Input[_builtins.str] kms_key_name: The name for the Cloud KMS key for the job. Key format is: `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User labels to be specified for the job. Keys and values
               should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
               page. **Note**: This field is marked as deprecated as the API does not currently
               support adding labels.
               **NOTE**: Google-provided Dataflow templates often provide default labels
               that begin with `goog-dataflow-provided`. Unless explicitly set in config, these
               labels will be ignored to prevent diffs on re-apply.
        :param pulumi.Input[_builtins.str] launcher_machine_type: The machine type to use for launching the job. The default is n1-standard-1.
        :param pulumi.Input[_builtins.str] machine_type: The machine type to use for the job.
        :param pulumi.Input[_builtins.int] max_workers: Immutable. The maximum number of Google Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param pulumi.Input[_builtins.str] name: Immutable. A unique name for the resource, required by Dataflow.
        :param pulumi.Input[_builtins.str] network: The network to which VMs will be assigned. If it is not provided, "default" will be used.
        :param pulumi.Input[_builtins.int] num_workers: Immutable. The initial number of Google Compute Engine instances for the job.
        :param pulumi.Input[_builtins.str] on_delete: One of "drain" or "cancel". Specifies behavior of
               deletion during `pulumi destroy`.  See above note.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: **Template specific** Key/Value pairs to be forwarded to the pipeline's options; keys are
               case-sensitive based on the language on which the pipeline is coded, mostly Java.
               **Note**: do not configure Dataflow options here in parameters.
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it is not
               provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: Immutable. The region in which the created job should run.
        :param pulumi.Input[_builtins.str] sdk_container_image: Docker registry location of container image to use for the 'worker harness. Default is the container for the version of the SDK. Note this field is only valid for portable pipelines.
        :param pulumi.Input[_builtins.str] service_account_email: Service account email to run the workers as. This should be just an email e.g. `myserviceaccount@myproject.iam.gserviceaccount.com`. Do not include any `serviceAccount:` or other prefix.
        :param pulumi.Input[_builtins.str] staging_location: The Cloud Storage path to use for staging files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param pulumi.Input[_builtins.str] state: The current state of the resource, selected from the [JobState enum](https://cloud.google.com/dataflow/docs/reference/rest/v1b3/projects.jobs#Job.JobState)
        :param pulumi.Input[_builtins.str] subnetwork: The subnetwork to which VMs will be assigned. Should be of the form "regions/REGION/subnetworks/SUBNETWORK".
        :param pulumi.Input[_builtins.str] temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] transform_name_mapping: Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.
        :param pulumi.Input[_builtins.str] type: The type of this job, selected from the JobType enum.
        """
        if additional_experiments is not None:
            pulumi.set(__self__, "additional_experiments", additional_experiments)
        if additional_pipeline_options is not None:
            pulumi.set(__self__, "additional_pipeline_options", additional_pipeline_options)
        if autoscaling_algorithm is not None:
            pulumi.set(__self__, "autoscaling_algorithm", autoscaling_algorithm)
        if container_spec_gcs_path is not None:
            pulumi.set(__self__, "container_spec_gcs_path", container_spec_gcs_path)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_streaming_engine is not None:
            pulumi.set(__self__, "enable_streaming_engine", enable_streaming_engine)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launcher_machine_type is not None:
            pulumi.set(__self__, "launcher_machine_type", launcher_machine_type)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if on_delete is not None:
            pulumi.set(__self__, "on_delete", on_delete)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sdk_container_image is not None:
            pulumi.set(__self__, "sdk_container_image", sdk_container_image)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if skip_wait_on_job_termination is not None:
            pulumi.set(__self__, "skip_wait_on_job_termination", skip_wait_on_job_termination)
        if staging_location is not None:
            pulumi.set(__self__, "staging_location", staging_location)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if temp_location is not None:
            pulumi.set(__self__, "temp_location", temp_location)
        if transform_name_mapping is not None:
            pulumi.set(__self__, "transform_name_mapping", transform_name_mapping)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of experiments that should be used by the job. An example value is `["enable_stackdriver_agent_metrics"]`.
        """
        return pulumi.get(self, "additional_experiments")

    @additional_experiments.setter
    def additional_experiments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_experiments", value)

    @_builtins.property
    @pulumi.getter(name="additionalPipelineOptions")
    def additional_pipeline_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of pipeline options that should be used by the job. An example value is `["numberOfWorkerHarnessThreads=20"]`.
        """
        return pulumi.get(self, "additional_pipeline_options")

    @additional_pipeline_options.setter
    def additional_pipeline_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_pipeline_options", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingAlgorithm")
    def autoscaling_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm to use for autoscaling.
        """
        return pulumi.get(self, "autoscaling_algorithm")

    @autoscaling_algorithm.setter
    def autoscaling_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autoscaling_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="containerSpecGcsPath")
    def container_spec_gcs_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCS path to the Dataflow job Flex
        Template.

        - - -
        """
        return pulumi.get(self, "container_spec_gcs_path")

    @container_spec_gcs_path.setter
    def container_spec_gcs_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_spec_gcs_path", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Immutable. Indicates if the job should use the streaming engine feature.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @enable_streaming_engine.setter
    def enable_streaming_engine(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_streaming_engine", value)

    @_builtins.property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration for VM IPs.  Options are `"WORKER_IP_PUBLIC"` or `"WORKER_IP_PRIVATE"`.
        """
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_configuration", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID of this job.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the Cloud KMS key for the job. Key format is: `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User labels to be specified for the job. Keys and values
        should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
        page. **Note**: This field is marked as deprecated as the API does not currently
        support adding labels.
        **NOTE**: Google-provided Dataflow templates often provide default labels
        that begin with `goog-dataflow-provided`. Unless explicitly set in config, these
        labels will be ignored to prevent diffs on re-apply.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="launcherMachineType")
    def launcher_machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The machine type to use for launching the job. The default is n1-standard-1.
        """
        return pulumi.get(self, "launcher_machine_type")

    @launcher_machine_type.setter
    def launcher_machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launcher_machine_type", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The machine type to use for the job.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Immutable. The maximum number of Google Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @max_workers.setter
    def max_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_workers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Immutable. A unique name for the resource, required by Dataflow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network to which VMs will be assigned. If it is not provided, "default" will be used.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Immutable. The initial number of Google Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @num_workers.setter
    def num_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_workers", value)

    @_builtins.property
    @pulumi.getter(name="onDelete")
    def on_delete(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        One of "drain" or "cancel". Specifies behavior of
        deletion during `pulumi destroy`.  See above note.
        """
        return pulumi.get(self, "on_delete")

    @on_delete.setter
    def on_delete(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_delete", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        **Template specific** Key/Value pairs to be forwarded to the pipeline's options; keys are
        case-sensitive based on the language on which the pipeline is coded, mostly Java.
        **Note**: do not configure Dataflow options here in parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project in which the resource belongs. If it is not
        provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Immutable. The region in which the created job should run.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sdkContainerImage")
    def sdk_container_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Docker registry location of container image to use for the 'worker harness. Default is the container for the version of the SDK. Note this field is only valid for portable pipelines.
        """
        return pulumi.get(self, "sdk_container_image")

    @sdk_container_image.setter
    def sdk_container_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sdk_container_image", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account email to run the workers as. This should be just an email e.g. `myserviceaccount@myproject.iam.gserviceaccount.com`. Do not include any `serviceAccount:` or other prefix.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter(name="skipWaitOnJobTermination")
    def skip_wait_on_job_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "skip_wait_on_job_termination")

    @skip_wait_on_job_termination.setter
    def skip_wait_on_job_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_wait_on_job_termination", value)

    @_builtins.property
    @pulumi.getter(name="stagingLocation")
    def staging_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Cloud Storage path to use for staging files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        return pulumi.get(self, "staging_location")

    @staging_location.setter
    def staging_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "staging_location", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the resource, selected from the [JobState enum](https://cloud.google.com/dataflow/docs/reference/rest/v1b3/projects.jobs#Job.JobState)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnetwork to which VMs will be assigned. Should be of the form "regions/REGION/subnetworks/SUBNETWORK".
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnetwork", value)

    @_builtins.property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        return pulumi.get(self, "temp_location")

    @temp_location.setter
    def temp_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "temp_location", value)

    @_builtins.property
    @pulumi.getter(name="transformNameMapping")
    def transform_name_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.
        """
        return pulumi.get(self, "transform_name_mapping")

    @transform_name_mapping.setter
    def transform_name_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "transform_name_mapping", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of this job, selected from the JobType enum.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("gcp:dataflow/flexTemplateJob:FlexTemplateJob")
class FlexTemplateJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_experiments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 additional_pipeline_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 autoscaling_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 container_spec_gcs_path: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_streaming_engine: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launcher_machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 num_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 on_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sdk_container_image: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wait_on_job_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 staging_location: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 temp_location: Optional[pulumi.Input[_builtins.str]] = None,
                 transform_name_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Creates a [Flex Template](https://cloud.google.com/dataflow/docs/guides/templates/using-flex-templates)
        job on Dataflow, which is an implementation of Apache Beam running on Google
        Compute Engine. For more information see the official documentation for [Beam](https://beam.apache.org)
        and [Dataflow](https://cloud.google.com/dataflow/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        big_data_job = gcp.dataflow.FlexTemplateJob("big_data_job",
            name="dataflow-flextemplates-job",
            container_spec_gcs_path="gs://my-bucket/templates/template.json",
            parameters={
                "inputSubscription": "messages",
            })
        ```

        ## Note on "destroy" / "apply"

        There are many types of Dataflow jobs.  Some Dataflow jobs run constantly,
        getting new data from (e.g.) a GCS bucket, and outputting data continuously.
        Some jobs process a set amount of data then terminate. All jobs can fail while
        running due to programming errors or other issues. In this way, Dataflow jobs
        are different from most other provider / Google resources.

        The Dataflow resource is considered 'existing' while it is in a nonterminal
        state.  If it reaches a terminal state (e.g. 'FAILED', 'COMPLETE',
        'CANCELLED'), it will be recreated on the next 'apply'.  This is as expected for
        jobs which run continuously, but may surprise users who use this resource for
        other kinds of Dataflow jobs.

        A Dataflow job which is 'destroyed' may be "cancelled" or "drained".  If
        "cancelled", the job terminates - any data written remains where it is, but no
        new data will be processed.  If "drained", no new data will enter the pipeline,
        but any data currently in the pipeline will finish being processed.  The default
        is "cancelled", but if a user sets `on_delete` to `"drain"` in the
        configuration, you may experience a long wait for your `pulumi destroy` to
        complete.

        You can potentially short-circuit the wait by setting `skip_wait_on_job_termination`
        to `true`, but beware that unless you take active steps to ensure that the job
        `name` parameter changes between instances, the name will conflict and the launch
        of the new job will fail. One way to do this is with a
        random_id
        resource, for example:

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        config = pulumi.Config()
        big_data_job_subscription_id = config.get("bigDataJobSubscriptionId")
        if big_data_job_subscription_id is None:
            big_data_job_subscription_id = "projects/myproject/subscriptions/messages"
        big_data_job_name_suffix = random.RandomId("big_data_job_name_suffix",
            byte_length=4,
            keepers={
                "region": region,
                "subscription_id": big_data_job_subscription_id,
            })
        big_data_job = gcp.dataflow.FlexTemplateJob("big_data_job",
            name=big_data_job_name_suffix.dec.apply(lambda dec: f"dataflow-flextemplates-job-{dec}"),
            region=region,
            container_spec_gcs_path="gs://my-bucket/templates/template.json",
            skip_wait_on_job_termination=True,
            parameters={
                "inputSubscription": big_data_job_subscription_id,
            })
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_experiments: List of experiments that should be used by the job. An example value is `["enable_stackdriver_agent_metrics"]`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_pipeline_options: List of pipeline options that should be used by the job. An example value is `["numberOfWorkerHarnessThreads=20"]`.
        :param pulumi.Input[_builtins.str] autoscaling_algorithm: The algorithm to use for autoscaling.
        :param pulumi.Input[_builtins.str] container_spec_gcs_path: The GCS path to the Dataflow job Flex
               Template.
               
               - - -
        :param pulumi.Input[_builtins.bool] enable_streaming_engine: Immutable. Indicates if the job should use the streaming engine feature.
        :param pulumi.Input[_builtins.str] ip_configuration: The configuration for VM IPs.  Options are `"WORKER_IP_PUBLIC"` or `"WORKER_IP_PRIVATE"`.
        :param pulumi.Input[_builtins.str] kms_key_name: The name for the Cloud KMS key for the job. Key format is: `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User labels to be specified for the job. Keys and values
               should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
               page. **Note**: This field is marked as deprecated as the API does not currently
               support adding labels.
               **NOTE**: Google-provided Dataflow templates often provide default labels
               that begin with `goog-dataflow-provided`. Unless explicitly set in config, these
               labels will be ignored to prevent diffs on re-apply.
        :param pulumi.Input[_builtins.str] launcher_machine_type: The machine type to use for launching the job. The default is n1-standard-1.
        :param pulumi.Input[_builtins.str] machine_type: The machine type to use for the job.
        :param pulumi.Input[_builtins.int] max_workers: Immutable. The maximum number of Google Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param pulumi.Input[_builtins.str] name: Immutable. A unique name for the resource, required by Dataflow.
        :param pulumi.Input[_builtins.str] network: The network to which VMs will be assigned. If it is not provided, "default" will be used.
        :param pulumi.Input[_builtins.int] num_workers: Immutable. The initial number of Google Compute Engine instances for the job.
        :param pulumi.Input[_builtins.str] on_delete: One of "drain" or "cancel". Specifies behavior of
               deletion during `pulumi destroy`.  See above note.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: **Template specific** Key/Value pairs to be forwarded to the pipeline's options; keys are
               case-sensitive based on the language on which the pipeline is coded, mostly Java.
               **Note**: do not configure Dataflow options here in parameters.
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it is not
               provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Immutable. The region in which the created job should run.
        :param pulumi.Input[_builtins.str] sdk_container_image: Docker registry location of container image to use for the 'worker harness. Default is the container for the version of the SDK. Note this field is only valid for portable pipelines.
        :param pulumi.Input[_builtins.str] service_account_email: Service account email to run the workers as. This should be just an email e.g. `myserviceaccount@myproject.iam.gserviceaccount.com`. Do not include any `serviceAccount:` or other prefix.
        :param pulumi.Input[_builtins.str] staging_location: The Cloud Storage path to use for staging files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param pulumi.Input[_builtins.str] subnetwork: The subnetwork to which VMs will be assigned. Should be of the form "regions/REGION/subnetworks/SUBNETWORK".
        :param pulumi.Input[_builtins.str] temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] transform_name_mapping: Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlexTemplateJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a [Flex Template](https://cloud.google.com/dataflow/docs/guides/templates/using-flex-templates)
        job on Dataflow, which is an implementation of Apache Beam running on Google
        Compute Engine. For more information see the official documentation for [Beam](https://beam.apache.org)
        and [Dataflow](https://cloud.google.com/dataflow/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        big_data_job = gcp.dataflow.FlexTemplateJob("big_data_job",
            name="dataflow-flextemplates-job",
            container_spec_gcs_path="gs://my-bucket/templates/template.json",
            parameters={
                "inputSubscription": "messages",
            })
        ```

        ## Note on "destroy" / "apply"

        There are many types of Dataflow jobs.  Some Dataflow jobs run constantly,
        getting new data from (e.g.) a GCS bucket, and outputting data continuously.
        Some jobs process a set amount of data then terminate. All jobs can fail while
        running due to programming errors or other issues. In this way, Dataflow jobs
        are different from most other provider / Google resources.

        The Dataflow resource is considered 'existing' while it is in a nonterminal
        state.  If it reaches a terminal state (e.g. 'FAILED', 'COMPLETE',
        'CANCELLED'), it will be recreated on the next 'apply'.  This is as expected for
        jobs which run continuously, but may surprise users who use this resource for
        other kinds of Dataflow jobs.

        A Dataflow job which is 'destroyed' may be "cancelled" or "drained".  If
        "cancelled", the job terminates - any data written remains where it is, but no
        new data will be processed.  If "drained", no new data will enter the pipeline,
        but any data currently in the pipeline will finish being processed.  The default
        is "cancelled", but if a user sets `on_delete` to `"drain"` in the
        configuration, you may experience a long wait for your `pulumi destroy` to
        complete.

        You can potentially short-circuit the wait by setting `skip_wait_on_job_termination`
        to `true`, but beware that unless you take active steps to ensure that the job
        `name` parameter changes between instances, the name will conflict and the launch
        of the new job will fail. One way to do this is with a
        random_id
        resource, for example:

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        config = pulumi.Config()
        big_data_job_subscription_id = config.get("bigDataJobSubscriptionId")
        if big_data_job_subscription_id is None:
            big_data_job_subscription_id = "projects/myproject/subscriptions/messages"
        big_data_job_name_suffix = random.RandomId("big_data_job_name_suffix",
            byte_length=4,
            keepers={
                "region": region,
                "subscription_id": big_data_job_subscription_id,
            })
        big_data_job = gcp.dataflow.FlexTemplateJob("big_data_job",
            name=big_data_job_name_suffix.dec.apply(lambda dec: f"dataflow-flextemplates-job-{dec}"),
            region=region,
            container_spec_gcs_path="gs://my-bucket/templates/template.json",
            skip_wait_on_job_termination=True,
            parameters={
                "inputSubscription": big_data_job_subscription_id,
            })
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param FlexTemplateJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlexTemplateJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_experiments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 additional_pipeline_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 autoscaling_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 container_spec_gcs_path: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_streaming_engine: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launcher_machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 num_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 on_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sdk_container_image: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wait_on_job_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 staging_location: Optional[pulumi.Input[_builtins.str]] = None,
                 subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 temp_location: Optional[pulumi.Input[_builtins.str]] = None,
                 transform_name_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlexTemplateJobArgs.__new__(FlexTemplateJobArgs)

            __props__.__dict__["additional_experiments"] = additional_experiments
            __props__.__dict__["additional_pipeline_options"] = additional_pipeline_options
            __props__.__dict__["autoscaling_algorithm"] = autoscaling_algorithm
            if container_spec_gcs_path is None and not opts.urn:
                raise TypeError("Missing required property 'container_spec_gcs_path'")
            __props__.__dict__["container_spec_gcs_path"] = container_spec_gcs_path
            __props__.__dict__["enable_streaming_engine"] = enable_streaming_engine
            __props__.__dict__["ip_configuration"] = ip_configuration
            __props__.__dict__["kms_key_name"] = kms_key_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launcher_machine_type"] = launcher_machine_type
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["max_workers"] = max_workers
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["num_workers"] = num_workers
            __props__.__dict__["on_delete"] = on_delete
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["sdk_container_image"] = sdk_container_image
            __props__.__dict__["service_account_email"] = service_account_email
            __props__.__dict__["skip_wait_on_job_termination"] = skip_wait_on_job_termination
            __props__.__dict__["staging_location"] = staging_location
            __props__.__dict__["subnetwork"] = subnetwork
            __props__.__dict__["temp_location"] = temp_location
            __props__.__dict__["transform_name_mapping"] = transform_name_mapping
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["job_id"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FlexTemplateJob, __self__).__init__(
            'gcp:dataflow/flexTemplateJob:FlexTemplateJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_experiments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            additional_pipeline_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            autoscaling_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            container_spec_gcs_path: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            enable_streaming_engine: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_configuration: Optional[pulumi.Input[_builtins.str]] = None,
            job_id: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            launcher_machine_type: Optional[pulumi.Input[_builtins.str]] = None,
            machine_type: Optional[pulumi.Input[_builtins.str]] = None,
            max_workers: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            num_workers: Optional[pulumi.Input[_builtins.int]] = None,
            on_delete: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            sdk_container_image: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
            skip_wait_on_job_termination: Optional[pulumi.Input[_builtins.bool]] = None,
            staging_location: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subnetwork: Optional[pulumi.Input[_builtins.str]] = None,
            temp_location: Optional[pulumi.Input[_builtins.str]] = None,
            transform_name_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlexTemplateJob':
        """
        Get an existing FlexTemplateJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_experiments: List of experiments that should be used by the job. An example value is `["enable_stackdriver_agent_metrics"]`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_pipeline_options: List of pipeline options that should be used by the job. An example value is `["numberOfWorkerHarnessThreads=20"]`.
        :param pulumi.Input[_builtins.str] autoscaling_algorithm: The algorithm to use for autoscaling.
        :param pulumi.Input[_builtins.str] container_spec_gcs_path: The GCS path to the Dataflow job Flex
               Template.
               
               - - -
        :param pulumi.Input[_builtins.bool] enable_streaming_engine: Immutable. Indicates if the job should use the streaming engine feature.
        :param pulumi.Input[_builtins.str] ip_configuration: The configuration for VM IPs.  Options are `"WORKER_IP_PUBLIC"` or `"WORKER_IP_PRIVATE"`.
        :param pulumi.Input[_builtins.str] job_id: The unique ID of this job.
        :param pulumi.Input[_builtins.str] kms_key_name: The name for the Cloud KMS key for the job. Key format is: `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User labels to be specified for the job. Keys and values
               should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
               page. **Note**: This field is marked as deprecated as the API does not currently
               support adding labels.
               **NOTE**: Google-provided Dataflow templates often provide default labels
               that begin with `goog-dataflow-provided`. Unless explicitly set in config, these
               labels will be ignored to prevent diffs on re-apply.
        :param pulumi.Input[_builtins.str] launcher_machine_type: The machine type to use for launching the job. The default is n1-standard-1.
        :param pulumi.Input[_builtins.str] machine_type: The machine type to use for the job.
        :param pulumi.Input[_builtins.int] max_workers: Immutable. The maximum number of Google Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param pulumi.Input[_builtins.str] name: Immutable. A unique name for the resource, required by Dataflow.
        :param pulumi.Input[_builtins.str] network: The network to which VMs will be assigned. If it is not provided, "default" will be used.
        :param pulumi.Input[_builtins.int] num_workers: Immutable. The initial number of Google Compute Engine instances for the job.
        :param pulumi.Input[_builtins.str] on_delete: One of "drain" or "cancel". Specifies behavior of
               deletion during `pulumi destroy`.  See above note.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: **Template specific** Key/Value pairs to be forwarded to the pipeline's options; keys are
               case-sensitive based on the language on which the pipeline is coded, mostly Java.
               **Note**: do not configure Dataflow options here in parameters.
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it is not
               provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: Immutable. The region in which the created job should run.
        :param pulumi.Input[_builtins.str] sdk_container_image: Docker registry location of container image to use for the 'worker harness. Default is the container for the version of the SDK. Note this field is only valid for portable pipelines.
        :param pulumi.Input[_builtins.str] service_account_email: Service account email to run the workers as. This should be just an email e.g. `myserviceaccount@myproject.iam.gserviceaccount.com`. Do not include any `serviceAccount:` or other prefix.
        :param pulumi.Input[_builtins.str] staging_location: The Cloud Storage path to use for staging files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param pulumi.Input[_builtins.str] state: The current state of the resource, selected from the [JobState enum](https://cloud.google.com/dataflow/docs/reference/rest/v1b3/projects.jobs#Job.JobState)
        :param pulumi.Input[_builtins.str] subnetwork: The subnetwork to which VMs will be assigned. Should be of the form "regions/REGION/subnetworks/SUBNETWORK".
        :param pulumi.Input[_builtins.str] temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] transform_name_mapping: Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.
        :param pulumi.Input[_builtins.str] type: The type of this job, selected from the JobType enum.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlexTemplateJobState.__new__(_FlexTemplateJobState)

        __props__.__dict__["additional_experiments"] = additional_experiments
        __props__.__dict__["additional_pipeline_options"] = additional_pipeline_options
        __props__.__dict__["autoscaling_algorithm"] = autoscaling_algorithm
        __props__.__dict__["container_spec_gcs_path"] = container_spec_gcs_path
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_streaming_engine"] = enable_streaming_engine
        __props__.__dict__["ip_configuration"] = ip_configuration
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["kms_key_name"] = kms_key_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["launcher_machine_type"] = launcher_machine_type
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["max_workers"] = max_workers
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["num_workers"] = num_workers
        __props__.__dict__["on_delete"] = on_delete
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["sdk_container_image"] = sdk_container_image
        __props__.__dict__["service_account_email"] = service_account_email
        __props__.__dict__["skip_wait_on_job_termination"] = skip_wait_on_job_termination
        __props__.__dict__["staging_location"] = staging_location
        __props__.__dict__["state"] = state
        __props__.__dict__["subnetwork"] = subnetwork
        __props__.__dict__["temp_location"] = temp_location
        __props__.__dict__["transform_name_mapping"] = transform_name_mapping
        __props__.__dict__["type"] = type
        return FlexTemplateJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of experiments that should be used by the job. An example value is `["enable_stackdriver_agent_metrics"]`.
        """
        return pulumi.get(self, "additional_experiments")

    @_builtins.property
    @pulumi.getter(name="additionalPipelineOptions")
    def additional_pipeline_options(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of pipeline options that should be used by the job. An example value is `["numberOfWorkerHarnessThreads=20"]`.
        """
        return pulumi.get(self, "additional_pipeline_options")

    @_builtins.property
    @pulumi.getter(name="autoscalingAlgorithm")
    def autoscaling_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The algorithm to use for autoscaling.
        """
        return pulumi.get(self, "autoscaling_algorithm")

    @_builtins.property
    @pulumi.getter(name="containerSpecGcsPath")
    def container_spec_gcs_path(self) -> pulumi.Output[_builtins.str]:
        """
        The GCS path to the Dataflow job Flex
        Template.

        - - -
        """
        return pulumi.get(self, "container_spec_gcs_path")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Immutable. Indicates if the job should use the streaming engine feature.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @_builtins.property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The configuration for VM IPs.  Options are `"WORKER_IP_PUBLIC"` or `"WORKER_IP_PRIVATE"`.
        """
        return pulumi.get(self, "ip_configuration")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique ID of this job.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the Cloud KMS key for the job. Key format is: `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User labels to be specified for the job. Keys and values
        should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
        page. **Note**: This field is marked as deprecated as the API does not currently
        support adding labels.
        **NOTE**: Google-provided Dataflow templates often provide default labels
        that begin with `goog-dataflow-provided`. Unless explicitly set in config, these
        labels will be ignored to prevent diffs on re-apply.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="launcherMachineType")
    def launcher_machine_type(self) -> pulumi.Output[_builtins.str]:
        """
        The machine type to use for launching the job. The default is n1-standard-1.
        """
        return pulumi.get(self, "launcher_machine_type")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[_builtins.str]:
        """
        The machine type to use for the job.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> pulumi.Output[_builtins.int]:
        """
        Immutable. The maximum number of Google Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Immutable. A unique name for the resource, required by Dataflow.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The network to which VMs will be assigned. If it is not provided, "default" will be used.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> pulumi.Output[_builtins.int]:
        """
        Immutable. The initial number of Google Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @_builtins.property
    @pulumi.getter(name="onDelete")
    def on_delete(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        One of "drain" or "cancel". Specifies behavior of
        deletion during `pulumi destroy`.  See above note.
        """
        return pulumi.get(self, "on_delete")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        **Template specific** Key/Value pairs to be forwarded to the pipeline's options; keys are
        case-sensitive based on the language on which the pipeline is coded, mostly Java.
        **Note**: do not configure Dataflow options here in parameters.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The project in which the resource belongs. If it is not
        provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Immutable. The region in which the created job should run.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sdkContainerImage")
    def sdk_container_image(self) -> pulumi.Output[_builtins.str]:
        """
        Docker registry location of container image to use for the 'worker harness. Default is the container for the version of the SDK. Note this field is only valid for portable pipelines.
        """
        return pulumi.get(self, "sdk_container_image")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[_builtins.str]:
        """
        Service account email to run the workers as. This should be just an email e.g. `myserviceaccount@myproject.iam.gserviceaccount.com`. Do not include any `serviceAccount:` or other prefix.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter(name="skipWaitOnJobTermination")
    def skip_wait_on_job_termination(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "skip_wait_on_job_termination")

    @_builtins.property
    @pulumi.getter(name="stagingLocation")
    def staging_location(self) -> pulumi.Output[_builtins.str]:
        """
        The Cloud Storage path to use for staging files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        return pulumi.get(self, "staging_location")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the resource, selected from the [JobState enum](https://cloud.google.com/dataflow/docs/reference/rest/v1b3/projects.jobs#Job.JobState)
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Output[_builtins.str]:
        """
        The subnetwork to which VMs will be assigned. Should be of the form "regions/REGION/subnetworks/SUBNETWORK".
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> pulumi.Output[_builtins.str]:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        return pulumi.get(self, "temp_location")

    @_builtins.property
    @pulumi.getter(name="transformNameMapping")
    def transform_name_mapping(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.
        """
        return pulumi.get(self, "transform_name_mapping")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of this job, selected from the JobType enum.
        """
        return pulumi.get(self, "type")

