# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PreventionDeidentifyTemplateArgs', 'PreventionDeidentifyTemplate']

@pulumi.input_type
class PreventionDeidentifyTemplateArgs:
    def __init__(__self__, *,
                 deidentify_config: pulumi.Input['PreventionDeidentifyTemplateDeidentifyConfigArgs'],
                 parent: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PreventionDeidentifyTemplate resource.
        :param pulumi.Input['PreventionDeidentifyTemplateDeidentifyConfigArgs'] deidentify_config: Configuration of the deidentify template
               Structure is documented below.
        :param pulumi.Input[_builtins.str] parent: The parent of the template in any of the following formats:
               * `projects/{{project}}`
               * `projects/{{project}}/locations/{{location}}`
               * `organizations/{{organization_id}}`
               * `organizations/{{organization_id}}/locations/{{location}}`
        :param pulumi.Input[_builtins.str] description: A description of the template.
        :param pulumi.Input[_builtins.str] display_name: User set display name of the template.
        :param pulumi.Input[_builtins.str] template_id: The template id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
               100 characters. Can be empty to allow the system to generate one.
        """
        pulumi.set(__self__, "deidentify_config", deidentify_config)
        pulumi.set(__self__, "parent", parent)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @_builtins.property
    @pulumi.getter(name="deidentifyConfig")
    def deidentify_config(self) -> pulumi.Input['PreventionDeidentifyTemplateDeidentifyConfigArgs']:
        """
        Configuration of the deidentify template
        Structure is documented below.
        """
        return pulumi.get(self, "deidentify_config")

    @deidentify_config.setter
    def deidentify_config(self, value: pulumi.Input['PreventionDeidentifyTemplateDeidentifyConfigArgs']):
        pulumi.set(self, "deidentify_config", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Input[_builtins.str]:
        """
        The parent of the template in any of the following formats:
        * `projects/{{project}}`
        * `projects/{{project}}/locations/{{location}}`
        * `organizations/{{organization_id}}`
        * `organizations/{{organization_id}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User set display name of the template.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template id can contain uppercase and lowercase letters, numbers, and hyphens;
        that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
        100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_id", value)


@pulumi.input_type
class _PreventionDeidentifyTemplateState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deidentify_config: Optional[pulumi.Input['PreventionDeidentifyTemplateDeidentifyConfigArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PreventionDeidentifyTemplate resources.
        :param pulumi.Input[_builtins.str] create_time: The creation timestamp of an deidentifyTemplate. Set by the server.
        :param pulumi.Input['PreventionDeidentifyTemplateDeidentifyConfigArgs'] deidentify_config: Configuration of the deidentify template
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A description of the template.
        :param pulumi.Input[_builtins.str] display_name: User set display name of the template.
        :param pulumi.Input[_builtins.str] name: The resource name of the template. Set by the server.
        :param pulumi.Input[_builtins.str] parent: The parent of the template in any of the following formats:
               * `projects/{{project}}`
               * `projects/{{project}}/locations/{{location}}`
               * `organizations/{{organization_id}}`
               * `organizations/{{organization_id}}/locations/{{location}}`
        :param pulumi.Input[_builtins.str] template_id: The template id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
               100 characters. Can be empty to allow the system to generate one.
        :param pulumi.Input[_builtins.str] update_time: The last update timestamp of an deidentifyTemplate. Set by the server.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deidentify_config is not None:
            pulumi.set(__self__, "deidentify_config", deidentify_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of an deidentifyTemplate. Set by the server.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deidentifyConfig")
    def deidentify_config(self) -> Optional[pulumi.Input['PreventionDeidentifyTemplateDeidentifyConfigArgs']]:
        """
        Configuration of the deidentify template
        Structure is documented below.
        """
        return pulumi.get(self, "deidentify_config")

    @deidentify_config.setter
    def deidentify_config(self, value: Optional[pulumi.Input['PreventionDeidentifyTemplateDeidentifyConfigArgs']]):
        pulumi.set(self, "deidentify_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User set display name of the template.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the template. Set by the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parent of the template in any of the following formats:
        * `projects/{{project}}`
        * `projects/{{project}}/locations/{{location}}`
        * `organizations/{{organization_id}}`
        * `organizations/{{organization_id}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template id can contain uppercase and lowercase letters, numbers, and hyphens;
        that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
        100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_id", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last update timestamp of an deidentifyTemplate. Set by the server.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:dataloss/preventionDeidentifyTemplate:PreventionDeidentifyTemplate")
class PreventionDeidentifyTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deidentify_config: Optional[pulumi.Input[Union['PreventionDeidentifyTemplateDeidentifyConfigArgs', 'PreventionDeidentifyTemplateDeidentifyConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows creation of templates to de-identify content.

        To get more information about DeidentifyTemplate, see:

        * [API documentation](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.deidentifyTemplates)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dlp/docs/concepts-templates)

        ## Example Usage

        ### Dlp Deidentify Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionDeidentifyTemplate("basic",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            deidentify_config={
                "info_type_transformations": {
                    "transformations": [
                        {
                            "info_types": [{
                                "name": "FIRST_NAME",
                            }],
                            "primitive_transformation": {
                                "replace_with_info_type_config": True,
                            },
                        },
                        {
                            "info_types": [
                                {
                                    "name": "PHONE_NUMBER",
                                },
                                {
                                    "name": "AGE",
                                },
                            ],
                            "primitive_transformation": {
                                "replace_config": {
                                    "new_value": {
                                        "integer_value": 9,
                                    },
                                },
                            },
                        },
                        {
                            "info_types": [
                                {
                                    "name": "EMAIL_ADDRESS",
                                },
                                {
                                    "name": "LAST_NAME",
                                },
                            ],
                            "primitive_transformation": {
                                "character_mask_config": {
                                    "masking_character": "X",
                                    "number_to_mask": 4,
                                    "reverse_order": True,
                                    "characters_to_ignores": [{
                                        "common_characters_to_ignore": "PUNCTUATION",
                                    }],
                                },
                            },
                        },
                        {
                            "info_types": [{
                                "name": "DATE_OF_BIRTH",
                            }],
                            "primitive_transformation": {
                                "replace_config": {
                                    "new_value": {
                                        "date_value": {
                                            "year": 2020,
                                            "month": 1,
                                            "day": 1,
                                        },
                                    },
                                },
                            },
                        },
                        {
                            "info_types": [{
                                "name": "CREDIT_CARD_NUMBER",
                            }],
                            "primitive_transformation": {
                                "crypto_deterministic_config": {
                                    "context": {
                                        "name": "sometweak",
                                    },
                                    "crypto_key": {
                                        "transient": {
                                            "name": "beep",
                                        },
                                    },
                                    "surrogate_info_type": {
                                        "name": "abc",
                                    },
                                },
                            },
                        },
                    ],
                },
            })
        ```
        ### Dlp Deidentify Template Image Transformations

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionDeidentifyTemplate("basic",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            deidentify_config={
                "image_transformations": {
                    "transforms": [
                        {
                            "redaction_color": {
                                "red": 0.5,
                                "blue": 1,
                                "green": 0.2,
                            },
                            "selected_info_types": {
                                "info_types": [{
                                    "name": "COLOR_INFO",
                                    "version": "latest",
                                }],
                            },
                        },
                        {
                            "all_info_types": {},
                        },
                        {
                            "all_text": {},
                        },
                    ],
                },
            })
        ```

        ## Import

        DeidentifyTemplate can be imported using any of these accepted formats:

        * `{{parent}}/deidentifyTemplates/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, DeidentifyTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataloss/preventionDeidentifyTemplate:PreventionDeidentifyTemplate default {{parent}}/deidentifyTemplates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataloss/preventionDeidentifyTemplate:PreventionDeidentifyTemplate default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PreventionDeidentifyTemplateDeidentifyConfigArgs', 'PreventionDeidentifyTemplateDeidentifyConfigArgsDict']] deidentify_config: Configuration of the deidentify template
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A description of the template.
        :param pulumi.Input[_builtins.str] display_name: User set display name of the template.
        :param pulumi.Input[_builtins.str] parent: The parent of the template in any of the following formats:
               * `projects/{{project}}`
               * `projects/{{project}}/locations/{{location}}`
               * `organizations/{{organization_id}}`
               * `organizations/{{organization_id}}/locations/{{location}}`
        :param pulumi.Input[_builtins.str] template_id: The template id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
               100 characters. Can be empty to allow the system to generate one.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PreventionDeidentifyTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows creation of templates to de-identify content.

        To get more information about DeidentifyTemplate, see:

        * [API documentation](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.deidentifyTemplates)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dlp/docs/concepts-templates)

        ## Example Usage

        ### Dlp Deidentify Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionDeidentifyTemplate("basic",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            deidentify_config={
                "info_type_transformations": {
                    "transformations": [
                        {
                            "info_types": [{
                                "name": "FIRST_NAME",
                            }],
                            "primitive_transformation": {
                                "replace_with_info_type_config": True,
                            },
                        },
                        {
                            "info_types": [
                                {
                                    "name": "PHONE_NUMBER",
                                },
                                {
                                    "name": "AGE",
                                },
                            ],
                            "primitive_transformation": {
                                "replace_config": {
                                    "new_value": {
                                        "integer_value": 9,
                                    },
                                },
                            },
                        },
                        {
                            "info_types": [
                                {
                                    "name": "EMAIL_ADDRESS",
                                },
                                {
                                    "name": "LAST_NAME",
                                },
                            ],
                            "primitive_transformation": {
                                "character_mask_config": {
                                    "masking_character": "X",
                                    "number_to_mask": 4,
                                    "reverse_order": True,
                                    "characters_to_ignores": [{
                                        "common_characters_to_ignore": "PUNCTUATION",
                                    }],
                                },
                            },
                        },
                        {
                            "info_types": [{
                                "name": "DATE_OF_BIRTH",
                            }],
                            "primitive_transformation": {
                                "replace_config": {
                                    "new_value": {
                                        "date_value": {
                                            "year": 2020,
                                            "month": 1,
                                            "day": 1,
                                        },
                                    },
                                },
                            },
                        },
                        {
                            "info_types": [{
                                "name": "CREDIT_CARD_NUMBER",
                            }],
                            "primitive_transformation": {
                                "crypto_deterministic_config": {
                                    "context": {
                                        "name": "sometweak",
                                    },
                                    "crypto_key": {
                                        "transient": {
                                            "name": "beep",
                                        },
                                    },
                                    "surrogate_info_type": {
                                        "name": "abc",
                                    },
                                },
                            },
                        },
                    ],
                },
            })
        ```
        ### Dlp Deidentify Template Image Transformations

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionDeidentifyTemplate("basic",
            parent="projects/my-project-name",
            description="Description",
            display_name="Displayname",
            deidentify_config={
                "image_transformations": {
                    "transforms": [
                        {
                            "redaction_color": {
                                "red": 0.5,
                                "blue": 1,
                                "green": 0.2,
                            },
                            "selected_info_types": {
                                "info_types": [{
                                    "name": "COLOR_INFO",
                                    "version": "latest",
                                }],
                            },
                        },
                        {
                            "all_info_types": {},
                        },
                        {
                            "all_text": {},
                        },
                    ],
                },
            })
        ```

        ## Import

        DeidentifyTemplate can be imported using any of these accepted formats:

        * `{{parent}}/deidentifyTemplates/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, DeidentifyTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataloss/preventionDeidentifyTemplate:PreventionDeidentifyTemplate default {{parent}}/deidentifyTemplates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataloss/preventionDeidentifyTemplate:PreventionDeidentifyTemplate default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PreventionDeidentifyTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PreventionDeidentifyTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deidentify_config: Optional[pulumi.Input[Union['PreventionDeidentifyTemplateDeidentifyConfigArgs', 'PreventionDeidentifyTemplateDeidentifyConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PreventionDeidentifyTemplateArgs.__new__(PreventionDeidentifyTemplateArgs)

            if deidentify_config is None and not opts.urn:
                raise TypeError("Missing required property 'deidentify_config'")
            __props__.__dict__["deidentify_config"] = deidentify_config
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(PreventionDeidentifyTemplate, __self__).__init__(
            'gcp:dataloss/preventionDeidentifyTemplate:PreventionDeidentifyTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deidentify_config: Optional[pulumi.Input[Union['PreventionDeidentifyTemplateDeidentifyConfigArgs', 'PreventionDeidentifyTemplateDeidentifyConfigArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            template_id: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'PreventionDeidentifyTemplate':
        """
        Get an existing PreventionDeidentifyTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation timestamp of an deidentifyTemplate. Set by the server.
        :param pulumi.Input[Union['PreventionDeidentifyTemplateDeidentifyConfigArgs', 'PreventionDeidentifyTemplateDeidentifyConfigArgsDict']] deidentify_config: Configuration of the deidentify template
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A description of the template.
        :param pulumi.Input[_builtins.str] display_name: User set display name of the template.
        :param pulumi.Input[_builtins.str] name: The resource name of the template. Set by the server.
        :param pulumi.Input[_builtins.str] parent: The parent of the template in any of the following formats:
               * `projects/{{project}}`
               * `projects/{{project}}/locations/{{location}}`
               * `organizations/{{organization_id}}`
               * `organizations/{{organization_id}}/locations/{{location}}`
        :param pulumi.Input[_builtins.str] template_id: The template id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
               100 characters. Can be empty to allow the system to generate one.
        :param pulumi.Input[_builtins.str] update_time: The last update timestamp of an deidentifyTemplate. Set by the server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PreventionDeidentifyTemplateState.__new__(_PreventionDeidentifyTemplateState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deidentify_config"] = deidentify_config
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["template_id"] = template_id
        __props__.__dict__["update_time"] = update_time
        return PreventionDeidentifyTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of an deidentifyTemplate. Set by the server.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deidentifyConfig")
    def deidentify_config(self) -> pulumi.Output['outputs.PreventionDeidentifyTemplateDeidentifyConfig']:
        """
        Configuration of the deidentify template
        Structure is documented below.
        """
        return pulumi.get(self, "deidentify_config")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the template.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User set display name of the template.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the template. Set by the server.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[_builtins.str]:
        """
        The parent of the template in any of the following formats:
        * `projects/{{project}}`
        * `projects/{{project}}/locations/{{location}}`
        * `organizations/{{organization_id}}`
        * `organizations/{{organization_id}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[_builtins.str]:
        """
        The template id can contain uppercase and lowercase letters, numbers, and hyphens;
        that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
        100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The last update timestamp of an deidentifyTemplate. Set by the server.
        """
        return pulumi.get(self, "update_time")

