# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AspectTypeArgs', 'AspectType']

@pulumi.input_type
class AspectTypeArgs:
    def __init__(__self__, *,
                 aspect_type_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_template: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AspectType resource.
        :param pulumi.Input[_builtins.str] aspect_type_id: The aspect type id of the aspect type.
        :param pulumi.Input[_builtins.str] description: Description of the AspectType.
        :param pulumi.Input[_builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels for the AspectType.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location where aspect type will be created in.
        :param pulumi.Input[_builtins.str] metadata_template: MetadataTemplate of the Aspect.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if aspect_type_id is not None:
            pulumi.set(__self__, "aspect_type_id", aspect_type_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metadata_template is not None:
            pulumi.set(__self__, "metadata_template", metadata_template)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="aspectTypeId")
    def aspect_type_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The aspect type id of the aspect type.
        """
        return pulumi.get(self, "aspect_type_id")

    @aspect_type_id.setter
    def aspect_type_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aspect_type_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the AspectType.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined labels for the AspectType.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where aspect type will be created in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="metadataTemplate")
    def metadata_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MetadataTemplate of the Aspect.
        """
        return pulumi.get(self, "metadata_template")

    @metadata_template.setter
    def metadata_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata_template", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AspectTypeState:
    def __init__(__self__, *,
                 aspect_type_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_template: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transfer_status: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AspectType resources.
        :param pulumi.Input[_builtins.str] aspect_type_id: The aspect type id of the aspect type.
        :param pulumi.Input[_builtins.str] create_time: The time when the AspectType was created.
        :param pulumi.Input[_builtins.str] description: Description of the AspectType.
        :param pulumi.Input[_builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels for the AspectType.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location where aspect type will be created in.
        :param pulumi.Input[_builtins.str] metadata_template: MetadataTemplate of the Aspect.
        :param pulumi.Input[_builtins.str] name: The relative resource name of the AspectType, of the form: projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] transfer_status: Denotes the transfer status of the Aspect Type. It is unspecified
               for Aspect Type created from Dataplex API.
        :param pulumi.Input[_builtins.str] uid: System generated globally unique ID for the AspectType. This ID will be different if the AspectType is deleted and re-created with the same name.
        :param pulumi.Input[_builtins.str] update_time: The time when the AspectType was last updated.
        """
        if aspect_type_id is not None:
            pulumi.set(__self__, "aspect_type_id", aspect_type_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metadata_template is not None:
            pulumi.set(__self__, "metadata_template", metadata_template)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if transfer_status is not None:
            pulumi.set(__self__, "transfer_status", transfer_status)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="aspectTypeId")
    def aspect_type_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The aspect type id of the aspect type.
        """
        return pulumi.get(self, "aspect_type_id")

    @aspect_type_id.setter
    def aspect_type_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aspect_type_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the AspectType was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the AspectType.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined labels for the AspectType.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where aspect type will be created in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="metadataTemplate")
    def metadata_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MetadataTemplate of the Aspect.
        """
        return pulumi.get(self, "metadata_template")

    @metadata_template.setter
    def metadata_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata_template", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The relative resource name of the AspectType, of the form: projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="transferStatus")
    def transfer_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Denotes the transfer status of the Aspect Type. It is unspecified
        for Aspect Type created from Dataplex API.
        """
        return pulumi.get(self, "transfer_status")

    @transfer_status.setter
    def transfer_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transfer_status", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System generated globally unique ID for the AspectType. This ID will be different if the AspectType is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the AspectType was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:dataplex/aspectType:AspectType")
class AspectType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aspect_type_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_template: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An Aspect Type is a template for creating Aspects.

        ## Example Usage

        ### Dataplex Aspect Type Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_aspect_type_basic = gcp.dataplex.AspectType("test_aspect_type_basic",
            aspect_type_id="aspect-type-basic",
            project="my-project-name",
            location="us-central1",
            metadata_template=\"\"\"{
          "name": "tf-test-template",
          "type": "record",
          "recordFields": [
            {
              "name": "type",
              "type": "enum",
              "annotations": {
                "displayName": "Type",
                "description": "Specifies the type of view represented by the entry."
              },
              "index": 1,
              "constraints": {
                "required": true
              },
              "enumValues": [
                {
                  "name": "VIEW",
                  "index": 1
                }
              ]
            }
          ]
        }
        \"\"\")
        ```
        ### Dataplex Aspect Type Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_aspect_type_full = gcp.dataplex.AspectType("test_aspect_type_full",
            aspect_type_id="aspect-type-full",
            project="my-project-name",
            location="us-central1",
            labels={
                "tag": "test-tf",
            },
            display_name="terraform aspect type",
            description="aspect type created by Terraform",
            metadata_template=\"\"\"{
          "type": "record",
          "name": "Schema",
          "recordFields": [
            {
              "name": "fields",
              "type": "array",
              "index": 1,
              "arrayItems": {
                "name": "field",
                "type": "record",
                "typeId": "field",
                "recordFields": [
                  {
                    "name": "name",
                    "type": "string",
                    "index": 1,
                    "constraints": {
                      "required": true
                    }
                  },
                  {
                    "name": "description",
                    "type": "string",
                    "index": 2
                  },
                  {
                    "name": "dataType",
                    "type": "string",
                    "index": 3,
                    "constraints": {
                      "required": true
                    }
                  },
                  {
                    "name": "metadataType",
                    "type": "enum",
                    "index": 4,
                    "constraints": {
                      "required": true
                    },
                    "enumValues": [
                      {
                        "name": "BOOLEAN",
                        "index": 1
                      },
                      {
                        "name": "NUMBER",
                        "index": 2
                      },
                      {
                        "name": "STRING",
                        "index": 3
                      },
                      {
                        "name": "BYTES",
                        "index": 4
                      },
                      {
                        "name": "DATETIME",
                        "index": 5
                      },
                      {
                        "name": "TIMESTAMP",
                        "index": 6
                      },
                      {
                        "name": "GEOSPATIAL",
                        "index": 7
                      },
                      {
                        "name": "STRUCT",
                        "index": 8
                      },
                      {
                        "name": "OTHER",
                        "index": 100
                      }
                    ]
                  },
                  {
                    "name": "mode",
                    "type": "enum",
                    "index": 5,
                    "enumValues": [
                      {
                        "name": "NULLABLE",
                        "index": 1
                      },
                      {
                        "name": "REPEATED",
                        "index": 2
                      },
                      {
                        "name": "REQUIRED",
                        "index": 3
                      }
                    ]
                  },
                  {
                    "name": "defaultValue",
                    "type": "string",
                    "index": 6
                  },
                  {
                    "name": "annotations",
                    "type": "map",
                    "index": 7,
                    "mapItems": {
                      "name": "label",
                      "type": "string"
                    }
                  },
                  {
                    "name": "fields",
                    "type": "array",
                    "index": 20,
                    "arrayItems": {
                      "name": "field",
                      "type": "record",
                      "typeRef": "field"
                    }
                  }
                ]
              }
            }
          ]
        }
        \"\"\")
        ```

        ## Import

        AspectType can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/aspectTypes/{{aspect_type_id}}`

        * `{{project}}/{{location}}/{{aspect_type_id}}`

        * `{{location}}/{{aspect_type_id}}`

        When using the `pulumi import` command, AspectType can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/aspectType:AspectType default projects/{{project}}/locations/{{location}}/aspectTypes/{{aspect_type_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/aspectType:AspectType default {{project}}/{{location}}/{{aspect_type_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/aspectType:AspectType default {{location}}/{{aspect_type_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aspect_type_id: The aspect type id of the aspect type.
        :param pulumi.Input[_builtins.str] description: Description of the AspectType.
        :param pulumi.Input[_builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels for the AspectType.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location where aspect type will be created in.
        :param pulumi.Input[_builtins.str] metadata_template: MetadataTemplate of the Aspect.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AspectTypeArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Aspect Type is a template for creating Aspects.

        ## Example Usage

        ### Dataplex Aspect Type Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_aspect_type_basic = gcp.dataplex.AspectType("test_aspect_type_basic",
            aspect_type_id="aspect-type-basic",
            project="my-project-name",
            location="us-central1",
            metadata_template=\"\"\"{
          "name": "tf-test-template",
          "type": "record",
          "recordFields": [
            {
              "name": "type",
              "type": "enum",
              "annotations": {
                "displayName": "Type",
                "description": "Specifies the type of view represented by the entry."
              },
              "index": 1,
              "constraints": {
                "required": true
              },
              "enumValues": [
                {
                  "name": "VIEW",
                  "index": 1
                }
              ]
            }
          ]
        }
        \"\"\")
        ```
        ### Dataplex Aspect Type Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_aspect_type_full = gcp.dataplex.AspectType("test_aspect_type_full",
            aspect_type_id="aspect-type-full",
            project="my-project-name",
            location="us-central1",
            labels={
                "tag": "test-tf",
            },
            display_name="terraform aspect type",
            description="aspect type created by Terraform",
            metadata_template=\"\"\"{
          "type": "record",
          "name": "Schema",
          "recordFields": [
            {
              "name": "fields",
              "type": "array",
              "index": 1,
              "arrayItems": {
                "name": "field",
                "type": "record",
                "typeId": "field",
                "recordFields": [
                  {
                    "name": "name",
                    "type": "string",
                    "index": 1,
                    "constraints": {
                      "required": true
                    }
                  },
                  {
                    "name": "description",
                    "type": "string",
                    "index": 2
                  },
                  {
                    "name": "dataType",
                    "type": "string",
                    "index": 3,
                    "constraints": {
                      "required": true
                    }
                  },
                  {
                    "name": "metadataType",
                    "type": "enum",
                    "index": 4,
                    "constraints": {
                      "required": true
                    },
                    "enumValues": [
                      {
                        "name": "BOOLEAN",
                        "index": 1
                      },
                      {
                        "name": "NUMBER",
                        "index": 2
                      },
                      {
                        "name": "STRING",
                        "index": 3
                      },
                      {
                        "name": "BYTES",
                        "index": 4
                      },
                      {
                        "name": "DATETIME",
                        "index": 5
                      },
                      {
                        "name": "TIMESTAMP",
                        "index": 6
                      },
                      {
                        "name": "GEOSPATIAL",
                        "index": 7
                      },
                      {
                        "name": "STRUCT",
                        "index": 8
                      },
                      {
                        "name": "OTHER",
                        "index": 100
                      }
                    ]
                  },
                  {
                    "name": "mode",
                    "type": "enum",
                    "index": 5,
                    "enumValues": [
                      {
                        "name": "NULLABLE",
                        "index": 1
                      },
                      {
                        "name": "REPEATED",
                        "index": 2
                      },
                      {
                        "name": "REQUIRED",
                        "index": 3
                      }
                    ]
                  },
                  {
                    "name": "defaultValue",
                    "type": "string",
                    "index": 6
                  },
                  {
                    "name": "annotations",
                    "type": "map",
                    "index": 7,
                    "mapItems": {
                      "name": "label",
                      "type": "string"
                    }
                  },
                  {
                    "name": "fields",
                    "type": "array",
                    "index": 20,
                    "arrayItems": {
                      "name": "field",
                      "type": "record",
                      "typeRef": "field"
                    }
                  }
                ]
              }
            }
          ]
        }
        \"\"\")
        ```

        ## Import

        AspectType can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/aspectTypes/{{aspect_type_id}}`

        * `{{project}}/{{location}}/{{aspect_type_id}}`

        * `{{location}}/{{aspect_type_id}}`

        When using the `pulumi import` command, AspectType can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/aspectType:AspectType default projects/{{project}}/locations/{{location}}/aspectTypes/{{aspect_type_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/aspectType:AspectType default {{project}}/{{location}}/{{aspect_type_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/aspectType:AspectType default {{location}}/{{aspect_type_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AspectTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AspectTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aspect_type_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_template: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AspectTypeArgs.__new__(AspectTypeArgs)

            __props__.__dict__["aspect_type_id"] = aspect_type_id
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["metadata_template"] = metadata_template
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["transfer_status"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AspectType, __self__).__init__(
            'gcp:dataplex/aspectType:AspectType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aspect_type_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            metadata_template: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transfer_status: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'AspectType':
        """
        Get an existing AspectType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aspect_type_id: The aspect type id of the aspect type.
        :param pulumi.Input[_builtins.str] create_time: The time when the AspectType was created.
        :param pulumi.Input[_builtins.str] description: Description of the AspectType.
        :param pulumi.Input[_builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels for the AspectType.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location where aspect type will be created in.
        :param pulumi.Input[_builtins.str] metadata_template: MetadataTemplate of the Aspect.
        :param pulumi.Input[_builtins.str] name: The relative resource name of the AspectType, of the form: projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] transfer_status: Denotes the transfer status of the Aspect Type. It is unspecified
               for Aspect Type created from Dataplex API.
        :param pulumi.Input[_builtins.str] uid: System generated globally unique ID for the AspectType. This ID will be different if the AspectType is deleted and re-created with the same name.
        :param pulumi.Input[_builtins.str] update_time: The time when the AspectType was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AspectTypeState.__new__(_AspectTypeState)

        __props__.__dict__["aspect_type_id"] = aspect_type_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["metadata_template"] = metadata_template
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["transfer_status"] = transfer_status
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return AspectType(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aspectTypeId")
    def aspect_type_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The aspect type id of the aspect type.
        """
        return pulumi.get(self, "aspect_type_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the AspectType was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the AspectType.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User-defined labels for the AspectType.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The location where aspect type will be created in.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="metadataTemplate")
    def metadata_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        MetadataTemplate of the Aspect.
        """
        return pulumi.get(self, "metadata_template")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The relative resource name of the AspectType, of the form: projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="transferStatus")
    def transfer_status(self) -> pulumi.Output[_builtins.str]:
        """
        Denotes the transfer status of the Aspect Type. It is unspecified
        for Aspect Type created from Dataplex API.
        """
        return pulumi.get(self, "transfer_status")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        System generated globally unique ID for the AspectType. This ID will be different if the AspectType is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the AspectType was last updated.
        """
        return pulumi.get(self, "update_time")

