# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMetastoreTableIamPolicyResult',
    'AwaitableGetMetastoreTableIamPolicyResult',
    'get_metastore_table_iam_policy',
    'get_metastore_table_iam_policy_output',
]

@pulumi.output_type
class GetMetastoreTableIamPolicyResult:
    """
    A collection of values returned by getMetastoreTableIamPolicy.
    """
    def __init__(__self__, database_id=None, etag=None, id=None, location=None, policy_data=None, project=None, service_id=None, table=None):
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if table and not isinstance(table, str):
            raise TypeError("Expected argument 'table' to be a str")
        pulumi.set(__self__, "table", table)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> _builtins.str:
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Required only by `dataproc.MetastoreTableIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> _builtins.str:
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter
    def table(self) -> _builtins.str:
        return pulumi.get(self, "table")


class AwaitableGetMetastoreTableIamPolicyResult(GetMetastoreTableIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetastoreTableIamPolicyResult(
            database_id=self.database_id,
            etag=self.etag,
            id=self.id,
            location=self.location,
            policy_data=self.policy_data,
            project=self.project,
            service_id=self.service_id,
            table=self.table)


def get_metastore_table_iam_policy(database_id: Optional[_builtins.str] = None,
                                   location: Optional[_builtins.str] = None,
                                   project: Optional[_builtins.str] = None,
                                   service_id: Optional[_builtins.str] = None,
                                   table: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetastoreTableIamPolicyResult:
    """
    Retrieves the current IAM policy data for table

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataproc.get_metastore_table_iam_policy(project=dpms_service["project"],
        location=dpms_service["location"],
        service_id=dpms_service["serviceId"],
        database_id=hive["hiveConfig"][0]["properties"]["database"],
        table=hive["hiveConfig"][0]["properties"]["table"])
    ```


    :param _builtins.str database_id: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str location: Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str service_id: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str table: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['serviceId'] = service_id
    __args__['table'] = table
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:dataproc/getMetastoreTableIamPolicy:getMetastoreTableIamPolicy', __args__, opts=opts, typ=GetMetastoreTableIamPolicyResult).value

    return AwaitableGetMetastoreTableIamPolicyResult(
        database_id=pulumi.get(__ret__, 'database_id'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        service_id=pulumi.get(__ret__, 'service_id'),
        table=pulumi.get(__ret__, 'table'))
def get_metastore_table_iam_policy_output(database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          location: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          service_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          table: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMetastoreTableIamPolicyResult]:
    """
    Retrieves the current IAM policy data for table

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataproc.get_metastore_table_iam_policy(project=dpms_service["project"],
        location=dpms_service["location"],
        service_id=dpms_service["serviceId"],
        database_id=hive["hiveConfig"][0]["properties"]["database"],
        table=hive["hiveConfig"][0]["properties"]["table"])
    ```


    :param _builtins.str database_id: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str location: Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str service_id: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str table: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['serviceId'] = service_id
    __args__['table'] = table
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:dataproc/getMetastoreTableIamPolicy:getMetastoreTableIamPolicy', __args__, opts=opts, typ=GetMetastoreTableIamPolicyResult)
    return __ret__.apply(lambda __response__: GetMetastoreTableIamPolicyResult(
        database_id=pulumi.get(__response__, 'database_id'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project'),
        service_id=pulumi.get(__response__, 'service_id'),
        table=pulumi.get(__response__, 'table')))
