# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InsightsConfigArgs', 'InsightsConfig']

@pulumi.input_type
class InsightsConfigArgs:
    def __init__(__self__, *,
                 app_hub_application: pulumi.Input[_builtins.str],
                 insights_config_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 artifact_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigArtifactConfigArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InsightsConfig resource.
        :param pulumi.Input[_builtins.str] app_hub_application: The name of the App Hub Application.
               Format:
               projects/{project}/locations/{location}/applications/{application}
        :param pulumi.Input[_builtins.str] insights_config_id: ID of the requesting InsightsConfig.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User specified annotations. See https://google.aip.dev/148#annotations
               for more details such as format and size limitations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input['InsightsConfigArtifactConfigArgs']]] artifact_configs: The artifact configurations of the artifacts that are deployed.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with an InsightsConfig.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "app_hub_application", app_hub_application)
        pulumi.set(__self__, "insights_config_id", insights_config_id)
        pulumi.set(__self__, "location", location)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if artifact_configs is not None:
            pulumi.set(__self__, "artifact_configs", artifact_configs)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="appHubApplication")
    def app_hub_application(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the App Hub Application.
        Format:
        projects/{project}/locations/{location}/applications/{application}
        """
        return pulumi.get(self, "app_hub_application")

    @app_hub_application.setter
    def app_hub_application(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_hub_application", value)

    @_builtins.property
    @pulumi.getter(name="insightsConfigId")
    def insights_config_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the requesting InsightsConfig.
        """
        return pulumi.get(self, "insights_config_id")

    @insights_config_id.setter
    def insights_config_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "insights_config_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User specified annotations. See https://google.aip.dev/148#annotations
        for more details such as format and size limitations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="artifactConfigs")
    def artifact_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigArtifactConfigArgs']]]]:
        """
        The artifact configurations of the artifacts that are deployed.
        Structure is documented below.
        """
        return pulumi.get(self, "artifact_configs")

    @artifact_configs.setter
    def artifact_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigArtifactConfigArgs']]]]):
        pulumi.set(self, "artifact_configs", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of labels associated with an InsightsConfig.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _InsightsConfigState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 app_hub_application: Optional[pulumi.Input[_builtins.str]] = None,
                 artifact_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigArtifactConfigArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigErrorArgs']]]] = None,
                 insights_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 runtime_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigRuntimeConfigArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InsightsConfig resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User specified annotations. See https://google.aip.dev/148#annotations
               for more details such as format and size limitations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] app_hub_application: The name of the App Hub Application.
               Format:
               projects/{project}/locations/{location}/applications/{application}
        :param pulumi.Input[Sequence[pulumi.Input['InsightsConfigArtifactConfigArgs']]] artifact_configs: The artifact configurations of the artifacts that are deployed.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: [Output only] Create timestamp
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input['InsightsConfigErrorArgs']]] errors: Any errors that occurred while setting up the InsightsConfig.
               Each error will be in the format: `field_name: error_message`, e.g.
               GetAppHubApplication: Permission denied while getting App Hub
               application. Please grant permissions to the P4SA.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] insights_config_id: ID of the requesting InsightsConfig.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with an InsightsConfig.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the InsightsConfig.
               Format:
               projects/{project}/locations/{location}/insightsConfigs/{insightsConfig}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Reconciling (https://google.aip.dev/128#reconciliation).
               Set to true if the current state of InsightsConfig does not match the
               user's intended state, and the service is actively updating the resource to
               reconcile them. This can happen due to user-triggered updates or
               system actions like failover or maintenance.
        :param pulumi.Input[Sequence[pulumi.Input['InsightsConfigRuntimeConfigArgs']]] runtime_configs: The runtime configurations where the application is deployed.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: (Output)
               The state of the Runtime.
               Possible values:
               STATE_UNSPECIFIED
               LINKED
               UNLINKED
        :param pulumi.Input[_builtins.str] update_time: [Output only] Update timestamp
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if app_hub_application is not None:
            pulumi.set(__self__, "app_hub_application", app_hub_application)
        if artifact_configs is not None:
            pulumi.set(__self__, "artifact_configs", artifact_configs)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if insights_config_id is not None:
            pulumi.set(__self__, "insights_config_id", insights_config_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if runtime_configs is not None:
            pulumi.set(__self__, "runtime_configs", runtime_configs)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User specified annotations. See https://google.aip.dev/148#annotations
        for more details such as format and size limitations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="appHubApplication")
    def app_hub_application(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the App Hub Application.
        Format:
        projects/{project}/locations/{location}/applications/{application}
        """
        return pulumi.get(self, "app_hub_application")

    @app_hub_application.setter
    def app_hub_application(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_hub_application", value)

    @_builtins.property
    @pulumi.getter(name="artifactConfigs")
    def artifact_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigArtifactConfigArgs']]]]:
        """
        The artifact configurations of the artifacts that are deployed.
        Structure is documented below.
        """
        return pulumi.get(self, "artifact_configs")

    @artifact_configs.setter
    def artifact_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigArtifactConfigArgs']]]]):
        pulumi.set(self, "artifact_configs", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Output only] Create timestamp
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigErrorArgs']]]]:
        """
        Any errors that occurred while setting up the InsightsConfig.
        Each error will be in the format: `field_name: error_message`, e.g.
        GetAppHubApplication: Permission denied while getting App Hub
        application. Please grant permissions to the P4SA.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigErrorArgs']]]]):
        pulumi.set(self, "errors", value)

    @_builtins.property
    @pulumi.getter(name="insightsConfigId")
    def insights_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the requesting InsightsConfig.
        """
        return pulumi.get(self, "insights_config_id")

    @insights_config_id.setter
    def insights_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "insights_config_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of labels associated with an InsightsConfig.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The name of the InsightsConfig.
        Format:
        projects/{project}/locations/{location}/insightsConfigs/{insightsConfig}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Reconciling (https://google.aip.dev/128#reconciliation).
        Set to true if the current state of InsightsConfig does not match the
        user's intended state, and the service is actively updating the resource to
        reconcile them. This can happen due to user-triggered updates or
        system actions like failover or maintenance.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter(name="runtimeConfigs")
    def runtime_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigRuntimeConfigArgs']]]]:
        """
        The runtime configurations where the application is deployed.
        Structure is documented below.
        """
        return pulumi.get(self, "runtime_configs")

    @runtime_configs.setter
    def runtime_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InsightsConfigRuntimeConfigArgs']]]]):
        pulumi.set(self, "runtime_configs", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The state of the Runtime.
        Possible values:
        STATE_UNSPECIFIED
        LINKED
        UNLINKED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Output only] Update timestamp
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:developerconnect/insightsConfig:InsightsConfig")
class InsightsConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 app_hub_application: Optional[pulumi.Input[_builtins.str]] = None,
                 artifact_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InsightsConfigArtifactConfigArgs', 'InsightsConfigArtifactConfigArgsDict']]]]] = None,
                 insights_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Description

        ## Example Usage

        ## Import

        InsightsConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/insightsConfigs/{{insights_config_id}}`

        * `{{project}}/{{location}}/{{insights_config_id}}`

        * `{{location}}/{{insights_config_id}}`

        When using the `pulumi import` command, InsightsConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:developerconnect/insightsConfig:InsightsConfig default projects/{{project}}/locations/{{location}}/insightsConfigs/{{insights_config_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/insightsConfig:InsightsConfig default {{project}}/{{location}}/{{insights_config_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/insightsConfig:InsightsConfig default {{location}}/{{insights_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User specified annotations. See https://google.aip.dev/148#annotations
               for more details such as format and size limitations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] app_hub_application: The name of the App Hub Application.
               Format:
               projects/{project}/locations/{location}/applications/{application}
        :param pulumi.Input[Sequence[pulumi.Input[Union['InsightsConfigArtifactConfigArgs', 'InsightsConfigArtifactConfigArgsDict']]]] artifact_configs: The artifact configurations of the artifacts that are deployed.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] insights_config_id: ID of the requesting InsightsConfig.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with an InsightsConfig.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InsightsConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Description

        ## Example Usage

        ## Import

        InsightsConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/insightsConfigs/{{insights_config_id}}`

        * `{{project}}/{{location}}/{{insights_config_id}}`

        * `{{location}}/{{insights_config_id}}`

        When using the `pulumi import` command, InsightsConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:developerconnect/insightsConfig:InsightsConfig default projects/{{project}}/locations/{{location}}/insightsConfigs/{{insights_config_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/insightsConfig:InsightsConfig default {{project}}/{{location}}/{{insights_config_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/insightsConfig:InsightsConfig default {{location}}/{{insights_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param InsightsConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InsightsConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 app_hub_application: Optional[pulumi.Input[_builtins.str]] = None,
                 artifact_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InsightsConfigArtifactConfigArgs', 'InsightsConfigArtifactConfigArgsDict']]]]] = None,
                 insights_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InsightsConfigArgs.__new__(InsightsConfigArgs)

            __props__.__dict__["annotations"] = annotations
            if app_hub_application is None and not opts.urn:
                raise TypeError("Missing required property 'app_hub_application'")
            __props__.__dict__["app_hub_application"] = app_hub_application
            __props__.__dict__["artifact_configs"] = artifact_configs
            if insights_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'insights_config_id'")
            __props__.__dict__["insights_config_id"] = insights_config_id
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["errors"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["runtime_configs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(InsightsConfig, __self__).__init__(
            'gcp:developerconnect/insightsConfig:InsightsConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            app_hub_application: Optional[pulumi.Input[_builtins.str]] = None,
            artifact_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InsightsConfigArtifactConfigArgs', 'InsightsConfigArtifactConfigArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InsightsConfigErrorArgs', 'InsightsConfigErrorArgsDict']]]]] = None,
            insights_config_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            runtime_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InsightsConfigRuntimeConfigArgs', 'InsightsConfigRuntimeConfigArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'InsightsConfig':
        """
        Get an existing InsightsConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User specified annotations. See https://google.aip.dev/148#annotations
               for more details such as format and size limitations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] app_hub_application: The name of the App Hub Application.
               Format:
               projects/{project}/locations/{location}/applications/{application}
        :param pulumi.Input[Sequence[pulumi.Input[Union['InsightsConfigArtifactConfigArgs', 'InsightsConfigArtifactConfigArgsDict']]]] artifact_configs: The artifact configurations of the artifacts that are deployed.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: [Output only] Create timestamp
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InsightsConfigErrorArgs', 'InsightsConfigErrorArgsDict']]]] errors: Any errors that occurred while setting up the InsightsConfig.
               Each error will be in the format: `field_name: error_message`, e.g.
               GetAppHubApplication: Permission denied while getting App Hub
               application. Please grant permissions to the P4SA.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] insights_config_id: ID of the requesting InsightsConfig.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with an InsightsConfig.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the InsightsConfig.
               Format:
               projects/{project}/locations/{location}/insightsConfigs/{insightsConfig}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Reconciling (https://google.aip.dev/128#reconciliation).
               Set to true if the current state of InsightsConfig does not match the
               user's intended state, and the service is actively updating the resource to
               reconcile them. This can happen due to user-triggered updates or
               system actions like failover or maintenance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InsightsConfigRuntimeConfigArgs', 'InsightsConfigRuntimeConfigArgsDict']]]] runtime_configs: The runtime configurations where the application is deployed.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: (Output)
               The state of the Runtime.
               Possible values:
               STATE_UNSPECIFIED
               LINKED
               UNLINKED
        :param pulumi.Input[_builtins.str] update_time: [Output only] Update timestamp
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InsightsConfigState.__new__(_InsightsConfigState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["app_hub_application"] = app_hub_application
        __props__.__dict__["artifact_configs"] = artifact_configs
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["errors"] = errors
        __props__.__dict__["insights_config_id"] = insights_config_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["runtime_configs"] = runtime_configs
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return InsightsConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User specified annotations. See https://google.aip.dev/148#annotations
        for more details such as format and size limitations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="appHubApplication")
    def app_hub_application(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the App Hub Application.
        Format:
        projects/{project}/locations/{location}/applications/{application}
        """
        return pulumi.get(self, "app_hub_application")

    @_builtins.property
    @pulumi.getter(name="artifactConfigs")
    def artifact_configs(self) -> pulumi.Output[Optional[Sequence['outputs.InsightsConfigArtifactConfig']]]:
        """
        The artifact configurations of the artifacts that are deployed.
        Structure is documented below.
        """
        return pulumi.get(self, "artifact_configs")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        [Output only] Create timestamp
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence['outputs.InsightsConfigError']]:
        """
        Any errors that occurred while setting up the InsightsConfig.
        Each error will be in the format: `field_name: error_message`, e.g.
        GetAppHubApplication: Permission denied while getting App Hub
        application. Please grant permissions to the P4SA.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter(name="insightsConfigId")
    def insights_config_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the requesting InsightsConfig.
        """
        return pulumi.get(self, "insights_config_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Set of labels associated with an InsightsConfig.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The name of the InsightsConfig.
        Format:
        projects/{project}/locations/{location}/insightsConfigs/{insightsConfig}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        Reconciling (https://google.aip.dev/128#reconciliation).
        Set to true if the current state of InsightsConfig does not match the
        user's intended state, and the service is actively updating the resource to
        reconcile them. This can happen due to user-triggered updates or
        system actions like failover or maintenance.
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter(name="runtimeConfigs")
    def runtime_configs(self) -> pulumi.Output[Sequence['outputs.InsightsConfigRuntimeConfig']]:
        """
        The runtime configurations where the application is deployed.
        Structure is documented below.
        """
        return pulumi.get(self, "runtime_configs")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (Output)
        The state of the Runtime.
        Possible values:
        STATE_UNSPECIFIED
        LINKED
        UNLINKED
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        [Output only] Update timestamp
        """
        return pulumi.get(self, "update_time")

