# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxGeneratorArgs', 'CxGenerator']

@pulumi.input_type
class CxGeneratorArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 prompt_text: pulumi.Input['CxGeneratorPromptTextArgs'],
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 llm_model_settings: Optional[pulumi.Input['CxGeneratorLlmModelSettingsArgs']] = None,
                 model_parameter: Optional[pulumi.Input['CxGeneratorModelParameterArgs']] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 placeholders: Optional[pulumi.Input[Sequence[pulumi.Input['CxGeneratorPlaceholderArgs']]]] = None):
        """
        The set of arguments for constructing a CxGenerator resource.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the generator, unique within the agent.
        :param pulumi.Input['CxGeneratorPromptTextArgs'] prompt_text: Prompt for the LLM model.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] language_code: The language to create generators for the following fields:
               * Generator.prompt_text.text
               If not specified, the agent's default language is used.
        :param pulumi.Input['CxGeneratorLlmModelSettingsArgs'] llm_model_settings: The LLM model settings.
               Structure is documented below.
        :param pulumi.Input['CxGeneratorModelParameterArgs'] model_parameter: Parameters passed to the LLM to configure its behavior.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] parent: The agent to create a Generator for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input['CxGeneratorPlaceholderArgs']]] placeholders: List of custom placeholders in the prompt text.
               Structure is documented below.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "prompt_text", prompt_text)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if llm_model_settings is not None:
            pulumi.set(__self__, "llm_model_settings", llm_model_settings)
        if model_parameter is not None:
            pulumi.set(__self__, "model_parameter", model_parameter)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if placeholders is not None:
            pulumi.set(__self__, "placeholders", placeholders)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The human-readable name of the generator, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="promptText")
    def prompt_text(self) -> pulumi.Input['CxGeneratorPromptTextArgs']:
        """
        Prompt for the LLM model.
        Structure is documented below.
        """
        return pulumi.get(self, "prompt_text")

    @prompt_text.setter
    def prompt_text(self, value: pulumi.Input['CxGeneratorPromptTextArgs']):
        pulumi.set(self, "prompt_text", value)

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language to create generators for the following fields:
        * Generator.prompt_text.text
        If not specified, the agent's default language is used.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language_code", value)

    @_builtins.property
    @pulumi.getter(name="llmModelSettings")
    def llm_model_settings(self) -> Optional[pulumi.Input['CxGeneratorLlmModelSettingsArgs']]:
        """
        The LLM model settings.
        Structure is documented below.
        """
        return pulumi.get(self, "llm_model_settings")

    @llm_model_settings.setter
    def llm_model_settings(self, value: Optional[pulumi.Input['CxGeneratorLlmModelSettingsArgs']]):
        pulumi.set(self, "llm_model_settings", value)

    @_builtins.property
    @pulumi.getter(name="modelParameter")
    def model_parameter(self) -> Optional[pulumi.Input['CxGeneratorModelParameterArgs']]:
        """
        Parameters passed to the LLM to configure its behavior.
        Structure is documented below.
        """
        return pulumi.get(self, "model_parameter")

    @model_parameter.setter
    def model_parameter(self, value: Optional[pulumi.Input['CxGeneratorModelParameterArgs']]):
        pulumi.set(self, "model_parameter", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent to create a Generator for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def placeholders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxGeneratorPlaceholderArgs']]]]:
        """
        List of custom placeholders in the prompt text.
        Structure is documented below.
        """
        return pulumi.get(self, "placeholders")

    @placeholders.setter
    def placeholders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxGeneratorPlaceholderArgs']]]]):
        pulumi.set(self, "placeholders", value)


@pulumi.input_type
class _CxGeneratorState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 llm_model_settings: Optional[pulumi.Input['CxGeneratorLlmModelSettingsArgs']] = None,
                 model_parameter: Optional[pulumi.Input['CxGeneratorModelParameterArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 placeholders: Optional[pulumi.Input[Sequence[pulumi.Input['CxGeneratorPlaceholderArgs']]]] = None,
                 prompt_text: Optional[pulumi.Input['CxGeneratorPromptTextArgs']] = None):
        """
        Input properties used for looking up and filtering CxGenerator resources.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the generator, unique within the agent.
        :param pulumi.Input[_builtins.str] language_code: The language to create generators for the following fields:
               * Generator.prompt_text.text
               If not specified, the agent's default language is used.
        :param pulumi.Input['CxGeneratorLlmModelSettingsArgs'] llm_model_settings: The LLM model settings.
               Structure is documented below.
        :param pulumi.Input['CxGeneratorModelParameterArgs'] model_parameter: Parameters passed to the LLM to configure its behavior.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the Generator.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/generators/<Generator ID>.
        :param pulumi.Input[_builtins.str] parent: The agent to create a Generator for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input['CxGeneratorPlaceholderArgs']]] placeholders: List of custom placeholders in the prompt text.
               Structure is documented below.
        :param pulumi.Input['CxGeneratorPromptTextArgs'] prompt_text: Prompt for the LLM model.
               Structure is documented below.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if llm_model_settings is not None:
            pulumi.set(__self__, "llm_model_settings", llm_model_settings)
        if model_parameter is not None:
            pulumi.set(__self__, "model_parameter", model_parameter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if placeholders is not None:
            pulumi.set(__self__, "placeholders", placeholders)
        if prompt_text is not None:
            pulumi.set(__self__, "prompt_text", prompt_text)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable name of the generator, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language to create generators for the following fields:
        * Generator.prompt_text.text
        If not specified, the agent's default language is used.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language_code", value)

    @_builtins.property
    @pulumi.getter(name="llmModelSettings")
    def llm_model_settings(self) -> Optional[pulumi.Input['CxGeneratorLlmModelSettingsArgs']]:
        """
        The LLM model settings.
        Structure is documented below.
        """
        return pulumi.get(self, "llm_model_settings")

    @llm_model_settings.setter
    def llm_model_settings(self, value: Optional[pulumi.Input['CxGeneratorLlmModelSettingsArgs']]):
        pulumi.set(self, "llm_model_settings", value)

    @_builtins.property
    @pulumi.getter(name="modelParameter")
    def model_parameter(self) -> Optional[pulumi.Input['CxGeneratorModelParameterArgs']]:
        """
        Parameters passed to the LLM to configure its behavior.
        Structure is documented below.
        """
        return pulumi.get(self, "model_parameter")

    @model_parameter.setter
    def model_parameter(self, value: Optional[pulumi.Input['CxGeneratorModelParameterArgs']]):
        pulumi.set(self, "model_parameter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the Generator.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/generators/<Generator ID>.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent to create a Generator for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def placeholders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxGeneratorPlaceholderArgs']]]]:
        """
        List of custom placeholders in the prompt text.
        Structure is documented below.
        """
        return pulumi.get(self, "placeholders")

    @placeholders.setter
    def placeholders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxGeneratorPlaceholderArgs']]]]):
        pulumi.set(self, "placeholders", value)

    @_builtins.property
    @pulumi.getter(name="promptText")
    def prompt_text(self) -> Optional[pulumi.Input['CxGeneratorPromptTextArgs']]:
        """
        Prompt for the LLM model.
        Structure is documented below.
        """
        return pulumi.get(self, "prompt_text")

    @prompt_text.setter
    def prompt_text(self, value: Optional[pulumi.Input['CxGeneratorPromptTextArgs']]):
        pulumi.set(self, "prompt_text", value)


@pulumi.type_token("gcp:diagflow/cxGenerator:CxGenerator")
class CxGenerator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 llm_model_settings: Optional[pulumi.Input[Union['CxGeneratorLlmModelSettingsArgs', 'CxGeneratorLlmModelSettingsArgsDict']]] = None,
                 model_parameter: Optional[pulumi.Input[Union['CxGeneratorModelParameterArgs', 'CxGeneratorModelParameterArgsDict']]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 placeholders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxGeneratorPlaceholderArgs', 'CxGeneratorPlaceholderArgsDict']]]]] = None,
                 prompt_text: Optional[pulumi.Input[Union['CxGeneratorPromptTextArgs', 'CxGeneratorPromptTextArgsDict']]] = None,
                 __props__=None):
        """
        Generators contain prompt to be sent to the LLM model to generate text. The prompt can contain parameters which will be resolved before calling the model. It can optionally contain banned phrases to ensure the model responses are safe.

        To get more information about Generator, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.generators)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Generator Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent-fucntion",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.")
        generator = gcp.diagflow.CxGenerator("generator",
            parent=agent.id,
            language_code="fr",
            display_name="TF Prompt generator",
            llm_model_settings={
                "model": "gemini-2.0-flash-001",
                "prompt_text": "Return me some great results",
            },
            prompt_text={
                "text": "Send me great results in french",
            },
            model_parameter={
                "temperature": 0.55,
            })
        ```

        ## Import

        Generator can be imported using any of these accepted formats:

        * `{{parent}}/generators/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Generator can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxGenerator:CxGenerator default {{parent}}/generators/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxGenerator:CxGenerator default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the generator, unique within the agent.
        :param pulumi.Input[_builtins.str] language_code: The language to create generators for the following fields:
               * Generator.prompt_text.text
               If not specified, the agent's default language is used.
        :param pulumi.Input[Union['CxGeneratorLlmModelSettingsArgs', 'CxGeneratorLlmModelSettingsArgsDict']] llm_model_settings: The LLM model settings.
               Structure is documented below.
        :param pulumi.Input[Union['CxGeneratorModelParameterArgs', 'CxGeneratorModelParameterArgsDict']] model_parameter: Parameters passed to the LLM to configure its behavior.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] parent: The agent to create a Generator for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxGeneratorPlaceholderArgs', 'CxGeneratorPlaceholderArgsDict']]]] placeholders: List of custom placeholders in the prompt text.
               Structure is documented below.
        :param pulumi.Input[Union['CxGeneratorPromptTextArgs', 'CxGeneratorPromptTextArgsDict']] prompt_text: Prompt for the LLM model.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxGeneratorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Generators contain prompt to be sent to the LLM model to generate text. The prompt can contain parameters which will be resolved before calling the model. It can optionally contain banned phrases to ensure the model responses are safe.

        To get more information about Generator, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.generators)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Generator Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent-fucntion",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.")
        generator = gcp.diagflow.CxGenerator("generator",
            parent=agent.id,
            language_code="fr",
            display_name="TF Prompt generator",
            llm_model_settings={
                "model": "gemini-2.0-flash-001",
                "prompt_text": "Return me some great results",
            },
            prompt_text={
                "text": "Send me great results in french",
            },
            model_parameter={
                "temperature": 0.55,
            })
        ```

        ## Import

        Generator can be imported using any of these accepted formats:

        * `{{parent}}/generators/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Generator can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxGenerator:CxGenerator default {{parent}}/generators/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxGenerator:CxGenerator default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxGeneratorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxGeneratorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 llm_model_settings: Optional[pulumi.Input[Union['CxGeneratorLlmModelSettingsArgs', 'CxGeneratorLlmModelSettingsArgsDict']]] = None,
                 model_parameter: Optional[pulumi.Input[Union['CxGeneratorModelParameterArgs', 'CxGeneratorModelParameterArgsDict']]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 placeholders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxGeneratorPlaceholderArgs', 'CxGeneratorPlaceholderArgsDict']]]]] = None,
                 prompt_text: Optional[pulumi.Input[Union['CxGeneratorPromptTextArgs', 'CxGeneratorPromptTextArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxGeneratorArgs.__new__(CxGeneratorArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["llm_model_settings"] = llm_model_settings
            __props__.__dict__["model_parameter"] = model_parameter
            __props__.__dict__["parent"] = parent
            __props__.__dict__["placeholders"] = placeholders
            if prompt_text is None and not opts.urn:
                raise TypeError("Missing required property 'prompt_text'")
            __props__.__dict__["prompt_text"] = prompt_text
            __props__.__dict__["name"] = None
        super(CxGenerator, __self__).__init__(
            'gcp:diagflow/cxGenerator:CxGenerator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            language_code: Optional[pulumi.Input[_builtins.str]] = None,
            llm_model_settings: Optional[pulumi.Input[Union['CxGeneratorLlmModelSettingsArgs', 'CxGeneratorLlmModelSettingsArgsDict']]] = None,
            model_parameter: Optional[pulumi.Input[Union['CxGeneratorModelParameterArgs', 'CxGeneratorModelParameterArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            placeholders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxGeneratorPlaceholderArgs', 'CxGeneratorPlaceholderArgsDict']]]]] = None,
            prompt_text: Optional[pulumi.Input[Union['CxGeneratorPromptTextArgs', 'CxGeneratorPromptTextArgsDict']]] = None) -> 'CxGenerator':
        """
        Get an existing CxGenerator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the generator, unique within the agent.
        :param pulumi.Input[_builtins.str] language_code: The language to create generators for the following fields:
               * Generator.prompt_text.text
               If not specified, the agent's default language is used.
        :param pulumi.Input[Union['CxGeneratorLlmModelSettingsArgs', 'CxGeneratorLlmModelSettingsArgsDict']] llm_model_settings: The LLM model settings.
               Structure is documented below.
        :param pulumi.Input[Union['CxGeneratorModelParameterArgs', 'CxGeneratorModelParameterArgsDict']] model_parameter: Parameters passed to the LLM to configure its behavior.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the Generator.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/generators/<Generator ID>.
        :param pulumi.Input[_builtins.str] parent: The agent to create a Generator for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxGeneratorPlaceholderArgs', 'CxGeneratorPlaceholderArgsDict']]]] placeholders: List of custom placeholders in the prompt text.
               Structure is documented below.
        :param pulumi.Input[Union['CxGeneratorPromptTextArgs', 'CxGeneratorPromptTextArgsDict']] prompt_text: Prompt for the LLM model.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxGeneratorState.__new__(_CxGeneratorState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["llm_model_settings"] = llm_model_settings
        __props__.__dict__["model_parameter"] = model_parameter
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["placeholders"] = placeholders
        __props__.__dict__["prompt_text"] = prompt_text
        return CxGenerator(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The human-readable name of the generator, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The language to create generators for the following fields:
        * Generator.prompt_text.text
        If not specified, the agent's default language is used.
        """
        return pulumi.get(self, "language_code")

    @_builtins.property
    @pulumi.getter(name="llmModelSettings")
    def llm_model_settings(self) -> pulumi.Output[Optional['outputs.CxGeneratorLlmModelSettings']]:
        """
        The LLM model settings.
        Structure is documented below.
        """
        return pulumi.get(self, "llm_model_settings")

    @_builtins.property
    @pulumi.getter(name="modelParameter")
    def model_parameter(self) -> pulumi.Output[Optional['outputs.CxGeneratorModelParameter']]:
        """
        Parameters passed to the LLM to configure its behavior.
        Structure is documented below.
        """
        return pulumi.get(self, "model_parameter")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the Generator.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/generators/<Generator ID>.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The agent to create a Generator for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter
    def placeholders(self) -> pulumi.Output[Optional[Sequence['outputs.CxGeneratorPlaceholder']]]:
        """
        List of custom placeholders in the prompt text.
        Structure is documented below.
        """
        return pulumi.get(self, "placeholders")

    @_builtins.property
    @pulumi.getter(name="promptText")
    def prompt_text(self) -> pulumi.Output['outputs.CxGeneratorPromptText']:
        """
        Prompt for the LLM model.
        Structure is documented below.
        """
        return pulumi.get(self, "prompt_text")

