# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CmekConfigArgs', 'CmekConfig']

@pulumi.input_type
class CmekConfigArgs:
    def __init__(__self__, *,
                 kms_key: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 cmek_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 set_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 single_region_keys: Optional[pulumi.Input[Sequence[pulumi.Input['CmekConfigSingleRegionKeyArgs']]]] = None):
        """
        The set of arguments for constructing a CmekConfig resource.
        :param pulumi.Input[_builtins.str] kms_key: KMS key resource name which will be used to encrypt resources
               `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
        :param pulumi.Input[_builtins.str] location: The geographic location where the CMEK config should reside. The value can
               only be one of "us" and "eu".
        :param pulumi.Input[_builtins.str] cmek_config_id: The unique id of the cmek config.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] set_default: Set the following CmekConfig as the default to be used for child resources
               if one is not specified. The default value is true.
        :param pulumi.Input[Sequence[pulumi.Input['CmekConfigSingleRegionKeyArgs']]] single_region_keys: Single-regional CMEKs that are required for some VAIS features.
               Structure is documented below.
        """
        pulumi.set(__self__, "kms_key", kms_key)
        pulumi.set(__self__, "location", location)
        if cmek_config_id is not None:
            pulumi.set(__self__, "cmek_config_id", cmek_config_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if set_default is not None:
            pulumi.set(__self__, "set_default", set_default)
        if single_region_keys is not None:
            pulumi.set(__self__, "single_region_keys", single_region_keys)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Input[_builtins.str]:
        """
        KMS key resource name which will be used to encrypt resources
        `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The geographic location where the CMEK config should reside. The value can
        only be one of "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="cmekConfigId")
    def cmek_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique id of the cmek config.
        """
        return pulumi.get(self, "cmek_config_id")

    @cmek_config_id.setter
    def cmek_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cmek_config_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="setDefault")
    def set_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set the following CmekConfig as the default to be used for child resources
        if one is not specified. The default value is true.
        """
        return pulumi.get(self, "set_default")

    @set_default.setter
    def set_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "set_default", value)

    @_builtins.property
    @pulumi.getter(name="singleRegionKeys")
    def single_region_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CmekConfigSingleRegionKeyArgs']]]]:
        """
        Single-regional CMEKs that are required for some VAIS features.
        Structure is documented below.
        """
        return pulumi.get(self, "single_region_keys")

    @single_region_keys.setter
    def single_region_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CmekConfigSingleRegionKeyArgs']]]]):
        pulumi.set(self, "single_region_keys", value)


@pulumi.input_type
class _CmekConfigState:
    def __init__(__self__, *,
                 cmek_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_version: Optional[pulumi.Input[_builtins.str]] = None,
                 last_rotation_timestamp_micros: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notebooklm_state: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 set_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 single_region_keys: Optional[pulumi.Input[Sequence[pulumi.Input['CmekConfigSingleRegionKeyArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CmekConfig resources.
        :param pulumi.Input[_builtins.str] cmek_config_id: The unique id of the cmek config.
        :param pulumi.Input[_builtins.bool] is_default: The default CmekConfig for the Customer.
        :param pulumi.Input[_builtins.str] kms_key: KMS key resource name which will be used to encrypt resources
               `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
        :param pulumi.Input[_builtins.str] kms_key_version: KMS key version resource name which will be used to encrypt resources
               `<kms_key>/cryptoKeyVersions/{keyVersion}`.
        :param pulumi.Input[_builtins.int] last_rotation_timestamp_micros: The timestamp of the last key rotation.
        :param pulumi.Input[_builtins.str] location: The geographic location where the CMEK config should reside. The value can
               only be one of "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the cmek config. Values are of the format
               `projects/{project}/locations/{location}/cmekConfigs/{cmek_config_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[_builtins.str] notebooklm_state: Whether the NotebookLM Corpus is ready to be used.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] set_default: Set the following CmekConfig as the default to be used for child resources
               if one is not specified. The default value is true.
        :param pulumi.Input[Sequence[pulumi.Input['CmekConfigSingleRegionKeyArgs']]] single_region_keys: Single-regional CMEKs that are required for some VAIS features.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The state of the CmekConfig.
        """
        if cmek_config_id is not None:
            pulumi.set(__self__, "cmek_config_id", cmek_config_id)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if kms_key_version is not None:
            pulumi.set(__self__, "kms_key_version", kms_key_version)
        if last_rotation_timestamp_micros is not None:
            pulumi.set(__self__, "last_rotation_timestamp_micros", last_rotation_timestamp_micros)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notebooklm_state is not None:
            pulumi.set(__self__, "notebooklm_state", notebooklm_state)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if set_default is not None:
            pulumi.set(__self__, "set_default", set_default)
        if single_region_keys is not None:
            pulumi.set(__self__, "single_region_keys", single_region_keys)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="cmekConfigId")
    def cmek_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique id of the cmek config.
        """
        return pulumi.get(self, "cmek_config_id")

    @cmek_config_id.setter
    def cmek_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cmek_config_id", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The default CmekConfig for the Customer.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KMS key resource name which will be used to encrypt resources
        `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersion")
    def kms_key_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KMS key version resource name which will be used to encrypt resources
        `<kms_key>/cryptoKeyVersions/{keyVersion}`.
        """
        return pulumi.get(self, "kms_key_version")

    @kms_key_version.setter
    def kms_key_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_version", value)

    @_builtins.property
    @pulumi.getter(name="lastRotationTimestampMicros")
    def last_rotation_timestamp_micros(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timestamp of the last key rotation.
        """
        return pulumi.get(self, "last_rotation_timestamp_micros")

    @last_rotation_timestamp_micros.setter
    def last_rotation_timestamp_micros(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "last_rotation_timestamp_micros", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the CMEK config should reside. The value can
        only be one of "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique full resource name of the cmek config. Values are of the format
        `projects/{project}/locations/{location}/cmekConfigs/{cmek_config_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notebooklmState")
    def notebooklm_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the NotebookLM Corpus is ready to be used.
        """
        return pulumi.get(self, "notebooklm_state")

    @notebooklm_state.setter
    def notebooklm_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notebooklm_state", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="setDefault")
    def set_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set the following CmekConfig as the default to be used for child resources
        if one is not specified. The default value is true.
        """
        return pulumi.get(self, "set_default")

    @set_default.setter
    def set_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "set_default", value)

    @_builtins.property
    @pulumi.getter(name="singleRegionKeys")
    def single_region_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CmekConfigSingleRegionKeyArgs']]]]:
        """
        Single-regional CMEKs that are required for some VAIS features.
        Structure is documented below.
        """
        return pulumi.get(self, "single_region_keys")

    @single_region_keys.setter
    def single_region_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CmekConfigSingleRegionKeyArgs']]]]):
        pulumi.set(self, "single_region_keys", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the CmekConfig.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:discoveryengine/cmekConfig:CmekConfig")
class CmekConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cmek_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 set_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 single_region_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CmekConfigSingleRegionKeyArgs', 'CmekConfigSingleRegionKeyArgsDict']]]]] = None,
                 __props__=None):
        """
        CmekConfig represents configurations used to enable CMEK data encryption with
        Cloud KMS keys.

        To get more information about CmekConfig, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.cmekConfigs)

        ## Example Usage

        ### Discoveryengine Cmekconfig Default

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        crypto_key = gcp.kms.CryptoKeyIAMMember("crypto_key",
            crypto_key_id="kms-key-name",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-discoveryengine.iam.gserviceaccount.com")
        default = gcp.discoveryengine.CmekConfig("default",
            location="us",
            cmek_config_id="cmek-config-id",
            kms_key="kms-key-name",
            opts = pulumi.ResourceOptions(depends_on=[crypto_key]))
        ```

        ## Import

        CmekConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/cmekConfigs/{{cmek_config_id}}`

        * `{{project}}/{{location}}/{{cmek_config_id}}`

        * `{{location}}/{{cmek_config_id}}`

        When using the `pulumi import` command, CmekConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/cmekConfig:CmekConfig default projects/{{project}}/locations/{{location}}/cmekConfigs/{{cmek_config_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/cmekConfig:CmekConfig default {{project}}/{{location}}/{{cmek_config_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/cmekConfig:CmekConfig default {{location}}/{{cmek_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cmek_config_id: The unique id of the cmek config.
        :param pulumi.Input[_builtins.str] kms_key: KMS key resource name which will be used to encrypt resources
               `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
        :param pulumi.Input[_builtins.str] location: The geographic location where the CMEK config should reside. The value can
               only be one of "us" and "eu".
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] set_default: Set the following CmekConfig as the default to be used for child resources
               if one is not specified. The default value is true.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CmekConfigSingleRegionKeyArgs', 'CmekConfigSingleRegionKeyArgsDict']]]] single_region_keys: Single-regional CMEKs that are required for some VAIS features.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CmekConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        CmekConfig represents configurations used to enable CMEK data encryption with
        Cloud KMS keys.

        To get more information about CmekConfig, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.cmekConfigs)

        ## Example Usage

        ### Discoveryengine Cmekconfig Default

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        crypto_key = gcp.kms.CryptoKeyIAMMember("crypto_key",
            crypto_key_id="kms-key-name",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-discoveryengine.iam.gserviceaccount.com")
        default = gcp.discoveryengine.CmekConfig("default",
            location="us",
            cmek_config_id="cmek-config-id",
            kms_key="kms-key-name",
            opts = pulumi.ResourceOptions(depends_on=[crypto_key]))
        ```

        ## Import

        CmekConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/cmekConfigs/{{cmek_config_id}}`

        * `{{project}}/{{location}}/{{cmek_config_id}}`

        * `{{location}}/{{cmek_config_id}}`

        When using the `pulumi import` command, CmekConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/cmekConfig:CmekConfig default projects/{{project}}/locations/{{location}}/cmekConfigs/{{cmek_config_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/cmekConfig:CmekConfig default {{project}}/{{location}}/{{cmek_config_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/cmekConfig:CmekConfig default {{location}}/{{cmek_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param CmekConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CmekConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cmek_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 set_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 single_region_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CmekConfigSingleRegionKeyArgs', 'CmekConfigSingleRegionKeyArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CmekConfigArgs.__new__(CmekConfigArgs)

            __props__.__dict__["cmek_config_id"] = cmek_config_id
            if kms_key is None and not opts.urn:
                raise TypeError("Missing required property 'kms_key'")
            __props__.__dict__["kms_key"] = kms_key
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["set_default"] = set_default
            __props__.__dict__["single_region_keys"] = single_region_keys
            __props__.__dict__["is_default"] = None
            __props__.__dict__["kms_key_version"] = None
            __props__.__dict__["last_rotation_timestamp_micros"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["notebooklm_state"] = None
            __props__.__dict__["state"] = None
        super(CmekConfig, __self__).__init__(
            'gcp:discoveryengine/cmekConfig:CmekConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cmek_config_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            kms_key: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_version: Optional[pulumi.Input[_builtins.str]] = None,
            last_rotation_timestamp_micros: Optional[pulumi.Input[_builtins.int]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notebooklm_state: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            set_default: Optional[pulumi.Input[_builtins.bool]] = None,
            single_region_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CmekConfigSingleRegionKeyArgs', 'CmekConfigSingleRegionKeyArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'CmekConfig':
        """
        Get an existing CmekConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cmek_config_id: The unique id of the cmek config.
        :param pulumi.Input[_builtins.bool] is_default: The default CmekConfig for the Customer.
        :param pulumi.Input[_builtins.str] kms_key: KMS key resource name which will be used to encrypt resources
               `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
        :param pulumi.Input[_builtins.str] kms_key_version: KMS key version resource name which will be used to encrypt resources
               `<kms_key>/cryptoKeyVersions/{keyVersion}`.
        :param pulumi.Input[_builtins.int] last_rotation_timestamp_micros: The timestamp of the last key rotation.
        :param pulumi.Input[_builtins.str] location: The geographic location where the CMEK config should reside. The value can
               only be one of "us" and "eu".
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the cmek config. Values are of the format
               `projects/{project}/locations/{location}/cmekConfigs/{cmek_config_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[_builtins.str] notebooklm_state: Whether the NotebookLM Corpus is ready to be used.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] set_default: Set the following CmekConfig as the default to be used for child resources
               if one is not specified. The default value is true.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CmekConfigSingleRegionKeyArgs', 'CmekConfigSingleRegionKeyArgsDict']]]] single_region_keys: Single-regional CMEKs that are required for some VAIS features.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The state of the CmekConfig.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CmekConfigState.__new__(_CmekConfigState)

        __props__.__dict__["cmek_config_id"] = cmek_config_id
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["kms_key"] = kms_key
        __props__.__dict__["kms_key_version"] = kms_key_version
        __props__.__dict__["last_rotation_timestamp_micros"] = last_rotation_timestamp_micros
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["notebooklm_state"] = notebooklm_state
        __props__.__dict__["project"] = project
        __props__.__dict__["set_default"] = set_default
        __props__.__dict__["single_region_keys"] = single_region_keys
        __props__.__dict__["state"] = state
        return CmekConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cmekConfigId")
    def cmek_config_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique id of the cmek config.
        """
        return pulumi.get(self, "cmek_config_id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[_builtins.bool]:
        """
        The default CmekConfig for the Customer.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[_builtins.str]:
        """
        KMS key resource name which will be used to encrypt resources
        `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersion")
    def kms_key_version(self) -> pulumi.Output[_builtins.str]:
        """
        KMS key version resource name which will be used to encrypt resources
        `<kms_key>/cryptoKeyVersions/{keyVersion}`.
        """
        return pulumi.get(self, "kms_key_version")

    @_builtins.property
    @pulumi.getter(name="lastRotationTimestampMicros")
    def last_rotation_timestamp_micros(self) -> pulumi.Output[_builtins.int]:
        """
        The timestamp of the last key rotation.
        """
        return pulumi.get(self, "last_rotation_timestamp_micros")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographic location where the CMEK config should reside. The value can
        only be one of "us" and "eu".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique full resource name of the cmek config. Values are of the format
        `projects/{project}/locations/{location}/cmekConfigs/{cmek_config_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notebooklmState")
    def notebooklm_state(self) -> pulumi.Output[_builtins.str]:
        """
        Whether the NotebookLM Corpus is ready to be used.
        """
        return pulumi.get(self, "notebooklm_state")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="setDefault")
    def set_default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set the following CmekConfig as the default to be used for child resources
        if one is not specified. The default value is true.
        """
        return pulumi.get(self, "set_default")

    @_builtins.property
    @pulumi.getter(name="singleRegionKeys")
    def single_region_keys(self) -> pulumi.Output[Optional[Sequence['outputs.CmekConfigSingleRegionKey']]]:
        """
        Single-regional CMEKs that are required for some VAIS features.
        Structure is documented below.
        """
        return pulumi.get(self, "single_region_keys")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the CmekConfig.
        """
        return pulumi.get(self, "state")

