# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AppCheckDeviceCheckConfigArgs', 'AppCheckDeviceCheckConfig']

@pulumi.input_type
class AppCheckDeviceCheckConfigArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[_builtins.str],
                 key_id: pulumi.Input[_builtins.str],
                 private_key: pulumi.Input[_builtins.str],
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppCheckDeviceCheckConfig resource.
        :param pulumi.Input[_builtins.str] app_id: The ID of an
               [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        :param pulumi.Input[_builtins.str] key_id: The key identifier of a private key enabled with DeviceCheck, created in your Apple Developer account.
        :param pulumi.Input[_builtins.str] private_key: The contents of the private key (.p8) file associated with the key specified by keyId.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] token_ttl: Specifies the duration for which App Check tokens exchanged from DeviceCheck artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "private_key", private_key)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of an
        [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The key identifier of a private key enabled with DeviceCheck, created in your Apple Developer account.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[_builtins.str]:
        """
        The contents of the private key (.p8) file associated with the key specified by keyId.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the duration for which App Check tokens exchanged from DeviceCheck artifacts will be valid.
        If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_ttl", value)


@pulumi.input_type
class _AppCheckDeviceCheckConfigState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_set: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppCheckDeviceCheckConfig resources.
        :param pulumi.Input[_builtins.str] app_id: The ID of an
               [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        :param pulumi.Input[_builtins.str] key_id: The key identifier of a private key enabled with DeviceCheck, created in your Apple Developer account.
        :param pulumi.Input[_builtins.str] name: The relative resource name of the DeviceCheck configuration object
        :param pulumi.Input[_builtins.str] private_key: The contents of the private key (.p8) file associated with the key specified by keyId.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.bool] private_key_set: Whether the privateKey field was previously set. Since App Check will never return the
               privateKey field, this field is the only way to find out whether it was previously set.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] token_ttl: Specifies the duration for which App Check tokens exchanged from DeviceCheck artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_set is not None:
            pulumi.set(__self__, "private_key_set", private_key_set)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an
        [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key identifier of a private key enabled with DeviceCheck, created in your Apple Developer account.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The relative resource name of the DeviceCheck configuration object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The contents of the private key (.p8) file associated with the key specified by keyId.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeySet")
    def private_key_set(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the privateKey field was previously set. Since App Check will never return the
        privateKey field, this field is the only way to find out whether it was previously set.
        """
        return pulumi.get(self, "private_key_set")

    @private_key_set.setter
    def private_key_set(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_key_set", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the duration for which App Check tokens exchanged from DeviceCheck artifacts will be valid.
        If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_ttl", value)


@pulumi.type_token("gcp:firebase/appCheckDeviceCheckConfig:AppCheckDeviceCheckConfig")
class AppCheckDeviceCheckConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An app's DeviceCheck configuration object. Note that the Team ID registered with your
        app is used as part of the validation process. Make sure your `firebase.AppleApp` has a team_id present.

        To get more information about DeviceCheckConfig, see:

        * [API documentation](https://firebase.google.com/docs/reference/appcheck/rest/v1/projects.apps.deviceCheckConfig)
        * How-to Guides
            * [Official Documentation](https://firebase.google.com/docs/app-check)

        ## Example Usage

        ### Firebase App Check Device Check Config Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std
        import pulumi_time as time

        default = gcp.firebase.AppleApp("default",
            project="my-project-name",
            display_name="Apple app",
            bundle_id="bundle.id.devicecheck",
            team_id="9987654321")
        # It takes a while for App Check to recognize the new app
        # If your app already exists, you don't have to wait 30 seconds.
        wait30s = time.index.Sleep("wait_30s", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[default]))
        default_app_check_device_check_config = gcp.firebase.AppCheckDeviceCheckConfig("default",
            project="my-project-name",
            app_id=default.app_id,
            token_ttl="7200s",
            key_id="Key ID",
            private_key=std.file(input="path/to/private-key.p8").result,
            opts = pulumi.ResourceOptions(depends_on=[wait30s]))
        ```

        ## Import

        DeviceCheckConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/apps/{{app_id}}/deviceCheckConfig`

        * `{{project}}/{{app_id}}`

        * `{{app_id}}`

        When using the `pulumi import` command, DeviceCheckConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appCheckDeviceCheckConfig:AppCheckDeviceCheckConfig default projects/{{project}}/apps/{{app_id}}/deviceCheckConfig
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckDeviceCheckConfig:AppCheckDeviceCheckConfig default {{project}}/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckDeviceCheckConfig:AppCheckDeviceCheckConfig default {{app_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The ID of an
               [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        :param pulumi.Input[_builtins.str] key_id: The key identifier of a private key enabled with DeviceCheck, created in your Apple Developer account.
        :param pulumi.Input[_builtins.str] private_key: The contents of the private key (.p8) file associated with the key specified by keyId.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] token_ttl: Specifies the duration for which App Check tokens exchanged from DeviceCheck artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppCheckDeviceCheckConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An app's DeviceCheck configuration object. Note that the Team ID registered with your
        app is used as part of the validation process. Make sure your `firebase.AppleApp` has a team_id present.

        To get more information about DeviceCheckConfig, see:

        * [API documentation](https://firebase.google.com/docs/reference/appcheck/rest/v1/projects.apps.deviceCheckConfig)
        * How-to Guides
            * [Official Documentation](https://firebase.google.com/docs/app-check)

        ## Example Usage

        ### Firebase App Check Device Check Config Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std
        import pulumi_time as time

        default = gcp.firebase.AppleApp("default",
            project="my-project-name",
            display_name="Apple app",
            bundle_id="bundle.id.devicecheck",
            team_id="9987654321")
        # It takes a while for App Check to recognize the new app
        # If your app already exists, you don't have to wait 30 seconds.
        wait30s = time.index.Sleep("wait_30s", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[default]))
        default_app_check_device_check_config = gcp.firebase.AppCheckDeviceCheckConfig("default",
            project="my-project-name",
            app_id=default.app_id,
            token_ttl="7200s",
            key_id="Key ID",
            private_key=std.file(input="path/to/private-key.p8").result,
            opts = pulumi.ResourceOptions(depends_on=[wait30s]))
        ```

        ## Import

        DeviceCheckConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/apps/{{app_id}}/deviceCheckConfig`

        * `{{project}}/{{app_id}}`

        * `{{app_id}}`

        When using the `pulumi import` command, DeviceCheckConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appCheckDeviceCheckConfig:AppCheckDeviceCheckConfig default projects/{{project}}/apps/{{app_id}}/deviceCheckConfig
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckDeviceCheckConfig:AppCheckDeviceCheckConfig default {{project}}/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appCheckDeviceCheckConfig:AppCheckDeviceCheckConfig default {{app_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AppCheckDeviceCheckConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppCheckDeviceCheckConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppCheckDeviceCheckConfigArgs.__new__(AppCheckDeviceCheckConfigArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            if key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_id'")
            __props__.__dict__["key_id"] = key_id
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["project"] = project
            __props__.__dict__["token_ttl"] = token_ttl
            __props__.__dict__["name"] = None
            __props__.__dict__["private_key_set"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AppCheckDeviceCheckConfig, __self__).__init__(
            'gcp:firebase/appCheckDeviceCheckConfig:AppCheckDeviceCheckConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_set: Optional[pulumi.Input[_builtins.bool]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            token_ttl: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppCheckDeviceCheckConfig':
        """
        Get an existing AppCheckDeviceCheckConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The ID of an
               [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        :param pulumi.Input[_builtins.str] key_id: The key identifier of a private key enabled with DeviceCheck, created in your Apple Developer account.
        :param pulumi.Input[_builtins.str] name: The relative resource name of the DeviceCheck configuration object
        :param pulumi.Input[_builtins.str] private_key: The contents of the private key (.p8) file associated with the key specified by keyId.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.bool] private_key_set: Whether the privateKey field was previously set. Since App Check will never return the
               privateKey field, this field is the only way to find out whether it was previously set.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] token_ttl: Specifies the duration for which App Check tokens exchanged from DeviceCheck artifacts will be valid.
               If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppCheckDeviceCheckConfigState.__new__(_AppCheckDeviceCheckConfigState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["name"] = name
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_set"] = private_key_set
        __props__.__dict__["project"] = project
        __props__.__dict__["token_ttl"] = token_ttl
        return AppCheckDeviceCheckConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of an
        [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The key identifier of a private key enabled with DeviceCheck, created in your Apple Developer account.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The relative resource name of the DeviceCheck configuration object
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The contents of the private key (.p8) file associated with the key specified by keyId.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeySet")
    def private_key_set(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the privateKey field was previously set. Since App Check will never return the
        privateKey field, this field is the only way to find out whether it was previously set.
        """
        return pulumi.get(self, "private_key_set")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the duration for which App Check tokens exchanged from DeviceCheck artifacts will be valid.
        If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "token_ttl")

