# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AppleAppArgs', 'AppleApp']

@pulumi.input_type
class AppleAppArgs:
    def __init__(__self__, *,
                 bundle_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 api_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppleApp resource.
        :param pulumi.Input[_builtins.str] bundle_id: The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        :param pulumi.Input[_builtins.str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[_builtins.str] api_key_id: The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the AppleApp.
               If apiKeyId is not set during creation, then Firebase automatically associates an apiKeyId with the AppleApp.
               This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned.
        :param pulumi.Input[_builtins.str] app_store_id: The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] team_id: The Apple Developer Team ID associated with the App in the App Store.
        """
        pulumi.set(__self__, "bundle_id", bundle_id)
        pulumi.set(__self__, "display_name", display_name)
        if api_key_id is not None:
            pulumi.set(__self__, "api_key_id", api_key_id)
        if app_store_id is not None:
            pulumi.set(__self__, "app_store_id", app_store_id)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @_builtins.property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Input[_builtins.str]:
        """
        The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bundle_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The user-assigned display name of the App.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the AppleApp.
        If apiKeyId is not set during creation, then Firebase automatically associates an apiKeyId with the AppleApp.
        This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned.
        """
        return pulumi.get(self, "api_key_id")

    @api_key_id.setter
    def api_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key_id", value)

    @_builtins.property
    @pulumi.getter(name="appStoreId")
    def app_store_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        """
        return pulumi.get(self, "app_store_id")

    @app_store_id.setter
    def app_store_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_store_id", value)

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apple Developer Team ID associated with the App in the App Store.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _AppleAppState:
    def __init__(__self__, *,
                 api_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppleApp resources.
        :param pulumi.Input[_builtins.str] api_key_id: The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the AppleApp.
               If apiKeyId is not set during creation, then Firebase automatically associates an apiKeyId with the AppleApp.
               This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned.
        :param pulumi.Input[_builtins.str] app_id: The globally unique, Firebase-assigned identifier of the App.
               This identifier should be treated as an opaque token, as the data format is not specified.
        :param pulumi.Input[_builtins.str] app_store_id: The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        :param pulumi.Input[_builtins.str] bundle_id: The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        :param pulumi.Input[_builtins.str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[_builtins.str] name: The fully qualified resource name of the App, for example:
               projects/projectId/iosApps/appId
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] team_id: The Apple Developer Team ID associated with the App in the App Store.
        """
        if api_key_id is not None:
            pulumi.set(__self__, "api_key_id", api_key_id)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_store_id is not None:
            pulumi.set(__self__, "app_store_id", app_store_id)
        if bundle_id is not None:
            pulumi.set(__self__, "bundle_id", bundle_id)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @_builtins.property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the AppleApp.
        If apiKeyId is not set during creation, then Firebase automatically associates an apiKeyId with the AppleApp.
        This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned.
        """
        return pulumi.get(self, "api_key_id")

    @api_key_id.setter
    def api_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key_id", value)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique, Firebase-assigned identifier of the App.
        This identifier should be treated as an opaque token, as the data format is not specified.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="appStoreId")
    def app_store_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        """
        return pulumi.get(self, "app_store_id")

    @app_store_id.setter
    def app_store_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_store_id", value)

    @_builtins.property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bundle_id", value)

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-assigned display name of the App.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified resource name of the App, for example:
        projects/projectId/iosApps/appId
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apple Developer Team ID associated with the App in the App Store.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)


@pulumi.type_token("gcp:firebase/appleApp:AppleApp")
class AppleApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Google Cloud Firebase Apple application instance

        To get more information about AppleApp, see:

        * [API documentation](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps)
        * How-to Guides
            * [Official Documentation](https://firebase.google.com/docs/ios/setup)

        ## Example Usage

        ### Firebase Apple App Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.AppleApp("default",
            project="my-project-name",
            display_name="Display Name Basic",
            bundle_id="apple.app.12345")
        ```
        ### Firebase Apple App Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apple = gcp.projects.ApiKey("apple",
            name="api-key",
            display_name="Display Name Full",
            project="my-project-name",
            restrictions={
                "ios_key_restrictions": {
                    "allowed_bundle_ids": ["apple.app.12345"],
                },
            })
        full = gcp.firebase.AppleApp("full",
            project="my-project-name",
            display_name="Display Name Full",
            bundle_id="apple.app.12345",
            app_store_id="12345",
            team_id="9987654321",
            api_key_id=apple.uid)
        ```

        ## Import

        AppleApp can be imported using any of these accepted formats:

        * `{{project}} projects/{{project}}/iosApps/{{app_id}}`

        * `projects/{{project}}/iosApps/{{app_id}}`

        * `{{project}}/{{project}}/{{app_id}}`

        * `iosApps/{{app_id}}`

        * `{{app_id}}`

        When using the `pulumi import` command, AppleApp can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appleApp:AppleApp default "{{project}} projects/{{project}}/iosApps/{{app_id}}"
        ```

        ```sh
        $ pulumi import gcp:firebase/appleApp:AppleApp default projects/{{project}}/iosApps/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appleApp:AppleApp default {{project}}/{{project}}/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appleApp:AppleApp default iosApps/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appleApp:AppleApp default {{app_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key_id: The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the AppleApp.
               If apiKeyId is not set during creation, then Firebase automatically associates an apiKeyId with the AppleApp.
               This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned.
        :param pulumi.Input[_builtins.str] app_store_id: The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        :param pulumi.Input[_builtins.str] bundle_id: The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        :param pulumi.Input[_builtins.str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] team_id: The Apple Developer Team ID associated with the App in the App Store.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppleAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Cloud Firebase Apple application instance

        To get more information about AppleApp, see:

        * [API documentation](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps)
        * How-to Guides
            * [Official Documentation](https://firebase.google.com/docs/ios/setup)

        ## Example Usage

        ### Firebase Apple App Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.AppleApp("default",
            project="my-project-name",
            display_name="Display Name Basic",
            bundle_id="apple.app.12345")
        ```
        ### Firebase Apple App Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apple = gcp.projects.ApiKey("apple",
            name="api-key",
            display_name="Display Name Full",
            project="my-project-name",
            restrictions={
                "ios_key_restrictions": {
                    "allowed_bundle_ids": ["apple.app.12345"],
                },
            })
        full = gcp.firebase.AppleApp("full",
            project="my-project-name",
            display_name="Display Name Full",
            bundle_id="apple.app.12345",
            app_store_id="12345",
            team_id="9987654321",
            api_key_id=apple.uid)
        ```

        ## Import

        AppleApp can be imported using any of these accepted formats:

        * `{{project}} projects/{{project}}/iosApps/{{app_id}}`

        * `projects/{{project}}/iosApps/{{app_id}}`

        * `{{project}}/{{project}}/{{app_id}}`

        * `iosApps/{{app_id}}`

        * `{{app_id}}`

        When using the `pulumi import` command, AppleApp can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appleApp:AppleApp default "{{project}} projects/{{project}}/iosApps/{{app_id}}"
        ```

        ```sh
        $ pulumi import gcp:firebase/appleApp:AppleApp default projects/{{project}}/iosApps/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appleApp:AppleApp default {{project}}/{{project}}/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appleApp:AppleApp default iosApps/{{app_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appleApp:AppleApp default {{app_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AppleAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppleAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppleAppArgs.__new__(AppleAppArgs)

            __props__.__dict__["api_key_id"] = api_key_id
            __props__.__dict__["app_store_id"] = app_store_id
            if bundle_id is None and not opts.urn:
                raise TypeError("Missing required property 'bundle_id'")
            __props__.__dict__["bundle_id"] = bundle_id
            __props__.__dict__["deletion_policy"] = deletion_policy
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["project"] = project
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["app_id"] = None
            __props__.__dict__["name"] = None
        super(AppleApp, __self__).__init__(
            'gcp:firebase/appleApp:AppleApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            app_id: Optional[pulumi.Input[_builtins.str]] = None,
            app_store_id: Optional[pulumi.Input[_builtins.str]] = None,
            bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            team_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppleApp':
        """
        Get an existing AppleApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key_id: The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the AppleApp.
               If apiKeyId is not set during creation, then Firebase automatically associates an apiKeyId with the AppleApp.
               This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned.
        :param pulumi.Input[_builtins.str] app_id: The globally unique, Firebase-assigned identifier of the App.
               This identifier should be treated as an opaque token, as the data format is not specified.
        :param pulumi.Input[_builtins.str] app_store_id: The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        :param pulumi.Input[_builtins.str] bundle_id: The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        :param pulumi.Input[_builtins.str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[_builtins.str] name: The fully qualified resource name of the App, for example:
               projects/projectId/iosApps/appId
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] team_id: The Apple Developer Team ID associated with the App in the App Store.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppleAppState.__new__(_AppleAppState)

        __props__.__dict__["api_key_id"] = api_key_id
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["app_store_id"] = app_store_id
        __props__.__dict__["bundle_id"] = bundle_id
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["team_id"] = team_id
        return AppleApp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the AppleApp.
        If apiKeyId is not set during creation, then Firebase automatically associates an apiKeyId with the AppleApp.
        This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned.
        """
        return pulumi.get(self, "api_key_id")

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The globally unique, Firebase-assigned identifier of the App.
        This identifier should be treated as an opaque token, as the data format is not specified.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="appStoreId")
    def app_store_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        """
        return pulumi.get(self, "app_store_id")

    @_builtins.property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Output[_builtins.str]:
        """
        The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        """
        return pulumi.get(self, "bundle_id")

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "deletion_policy")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-assigned display name of the App.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified resource name of the App, for example:
        projects/projectId/iosApps/appId
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Apple Developer Team ID associated with the App in the App Store.
        """
        return pulumi.get(self, "team_id")

