# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAppleAppResult',
    'AwaitableGetAppleAppResult',
    'get_apple_app',
    'get_apple_app_output',
]

@pulumi.output_type
class GetAppleAppResult:
    """
    A collection of values returned by getAppleApp.
    """
    def __init__(__self__, api_key_id=None, app_id=None, app_store_id=None, bundle_id=None, deletion_policy=None, display_name=None, id=None, name=None, project=None, team_id=None):
        if api_key_id and not isinstance(api_key_id, str):
            raise TypeError("Expected argument 'api_key_id' to be a str")
        pulumi.set(__self__, "api_key_id", api_key_id)
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if app_store_id and not isinstance(app_store_id, str):
            raise TypeError("Expected argument 'app_store_id' to be a str")
        pulumi.set(__self__, "app_store_id", app_store_id)
        if bundle_id and not isinstance(bundle_id, str):
            raise TypeError("Expected argument 'bundle_id' to be a str")
        pulumi.set(__self__, "bundle_id", bundle_id)
        if deletion_policy and not isinstance(deletion_policy, str):
            raise TypeError("Expected argument 'deletion_policy' to be a str")
        pulumi.set(__self__, "deletion_policy", deletion_policy)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)

    @_builtins.property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> _builtins.str:
        return pulumi.get(self, "api_key_id")

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        """
        Immutable. The globally unique, Firebase-assigned identifier of the App.
        This identifier should be treated as an opaque token, as the data format is not specified.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="appStoreId")
    def app_store_id(self) -> _builtins.str:
        """
        The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        """
        return pulumi.get(self, "app_store_id")

    @_builtins.property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> _builtins.str:
        """
        The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        """
        return pulumi.get(self, "bundle_id")

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> _builtins.str:
        return pulumi.get(self, "deletion_policy")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-assigned display name of the App.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The fully qualified resource name of the App, for example:
        projects/projectId/iosApps/appId
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> _builtins.str:
        """
        The Apple Developer Team ID associated with the App in the App Store.
        """
        return pulumi.get(self, "team_id")


class AwaitableGetAppleAppResult(GetAppleAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppleAppResult(
            api_key_id=self.api_key_id,
            app_id=self.app_id,
            app_store_id=self.app_store_id,
            bundle_id=self.bundle_id,
            deletion_policy=self.deletion_policy,
            display_name=self.display_name,
            id=self.id,
            name=self.name,
            project=self.project,
            team_id=self.team_id)


def get_apple_app(app_id: Optional[_builtins.str] = None,
                  project: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppleAppResult:
    """
    A Google Cloud Firebase Apple application instance


    :param _builtins.str app_id: The app_id of name of the Firebase iosApp.
           
           
           - - -
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:firebase/getAppleApp:getAppleApp', __args__, opts=opts, typ=GetAppleAppResult).value

    return AwaitableGetAppleAppResult(
        api_key_id=pulumi.get(__ret__, 'api_key_id'),
        app_id=pulumi.get(__ret__, 'app_id'),
        app_store_id=pulumi.get(__ret__, 'app_store_id'),
        bundle_id=pulumi.get(__ret__, 'bundle_id'),
        deletion_policy=pulumi.get(__ret__, 'deletion_policy'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        team_id=pulumi.get(__ret__, 'team_id'))
def get_apple_app_output(app_id: Optional[pulumi.Input[_builtins.str]] = None,
                         project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppleAppResult]:
    """
    A Google Cloud Firebase Apple application instance


    :param _builtins.str app_id: The app_id of name of the Firebase iosApp.
           
           
           - - -
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:firebase/getAppleApp:getAppleApp', __args__, opts=opts, typ=GetAppleAppResult)
    return __ret__.apply(lambda __response__: GetAppleAppResult(
        api_key_id=pulumi.get(__response__, 'api_key_id'),
        app_id=pulumi.get(__response__, 'app_id'),
        app_store_id=pulumi.get(__response__, 'app_store_id'),
        bundle_id=pulumi.get(__response__, 'bundle_id'),
        deletion_policy=pulumi.get(__response__, 'deletion_policy'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        team_id=pulumi.get(__response__, 'team_id')))
