# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LoggingSettingArgs', 'LoggingSetting']

@pulumi.input_type
class LoggingSettingArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 logging_setting_id: pulumi.Input[_builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_prompts_and_responses: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoggingSetting resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] logging_setting_id: Id of the Logging Setting.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.bool] log_metadata: Whether to log metadata.
        :param pulumi.Input[_builtins.bool] log_prompts_and_responses: Whether to log prompts and responses.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "logging_setting_id", logging_setting_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_metadata is not None:
            pulumi.set(__self__, "log_metadata", log_metadata)
        if log_prompts_and_responses is not None:
            pulumi.set(__self__, "log_prompts_and_responses", log_prompts_and_responses)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="loggingSettingId")
    def logging_setting_id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of the Logging Setting.
        """
        return pulumi.get(self, "logging_setting_id")

    @logging_setting_id.setter
    def logging_setting_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "logging_setting_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logMetadata")
    def log_metadata(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to log metadata.
        """
        return pulumi.get(self, "log_metadata")

    @log_metadata.setter
    def log_metadata(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_metadata", value)

    @_builtins.property
    @pulumi.getter(name="logPromptsAndResponses")
    def log_prompts_and_responses(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to log prompts and responses.
        """
        return pulumi.get(self, "log_prompts_and_responses")

    @log_prompts_and_responses.setter
    def log_prompts_and_responses(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_prompts_and_responses", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _LoggingSettingState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_prompts_and_responses: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging_setting_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoggingSetting resources.
        :param pulumi.Input[_builtins.str] create_time: Create time stamp.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.bool] log_metadata: Whether to log metadata.
        :param pulumi.Input[_builtins.bool] log_prompts_and_responses: Whether to log prompts and responses.
        :param pulumi.Input[_builtins.str] logging_setting_id: Id of the Logging Setting.
        :param pulumi.Input[_builtins.str] name: Identifier. Name of the resource.
               Format:projects/{project}/locations/{location}/loggingsettings/{loggingsetting}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] update_time: Update time stamp.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_metadata is not None:
            pulumi.set(__self__, "log_metadata", log_metadata)
        if log_prompts_and_responses is not None:
            pulumi.set(__self__, "log_prompts_and_responses", log_prompts_and_responses)
        if logging_setting_id is not None:
            pulumi.set(__self__, "logging_setting_id", logging_setting_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create time stamp.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logMetadata")
    def log_metadata(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to log metadata.
        """
        return pulumi.get(self, "log_metadata")

    @log_metadata.setter
    def log_metadata(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_metadata", value)

    @_builtins.property
    @pulumi.getter(name="logPromptsAndResponses")
    def log_prompts_and_responses(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to log prompts and responses.
        """
        return pulumi.get(self, "log_prompts_and_responses")

    @log_prompts_and_responses.setter
    def log_prompts_and_responses(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_prompts_and_responses", value)

    @_builtins.property
    @pulumi.getter(name="loggingSettingId")
    def logging_setting_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the Logging Setting.
        """
        return pulumi.get(self, "logging_setting_id")

    @logging_setting_id.setter
    def logging_setting_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logging_setting_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. Name of the resource.
        Format:projects/{project}/locations/{location}/loggingsettings/{loggingsetting}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Update time stamp.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:gemini/loggingSetting:LoggingSetting")
class LoggingSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_prompts_and_responses: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging_setting_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The resource for managing Logging settings for Admin Control.

        ## Example Usage

        ### Gemini Logging Setting Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.gemini.LoggingSetting("example",
            logging_setting_id="ls1-tf",
            location="global",
            labels={
                "my_key": "my_value",
            },
            log_prompts_and_responses=True,
            log_metadata=True)
        ```

        ## Import

        LoggingSetting can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/loggingSettings/{{logging_setting_id}}`

        * `{{project}}/{{location}}/{{logging_setting_id}}`

        * `{{location}}/{{logging_setting_id}}`

        When using the `pulumi import` command, LoggingSetting can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gemini/loggingSetting:LoggingSetting default projects/{{project}}/locations/{{location}}/loggingSettings/{{logging_setting_id}}
        ```

        ```sh
        $ pulumi import gcp:gemini/loggingSetting:LoggingSetting default {{project}}/{{location}}/{{logging_setting_id}}
        ```

        ```sh
        $ pulumi import gcp:gemini/loggingSetting:LoggingSetting default {{location}}/{{logging_setting_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.bool] log_metadata: Whether to log metadata.
        :param pulumi.Input[_builtins.bool] log_prompts_and_responses: Whether to log prompts and responses.
        :param pulumi.Input[_builtins.str] logging_setting_id: Id of the Logging Setting.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoggingSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The resource for managing Logging settings for Admin Control.

        ## Example Usage

        ### Gemini Logging Setting Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.gemini.LoggingSetting("example",
            logging_setting_id="ls1-tf",
            location="global",
            labels={
                "my_key": "my_value",
            },
            log_prompts_and_responses=True,
            log_metadata=True)
        ```

        ## Import

        LoggingSetting can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/loggingSettings/{{logging_setting_id}}`

        * `{{project}}/{{location}}/{{logging_setting_id}}`

        * `{{location}}/{{logging_setting_id}}`

        When using the `pulumi import` command, LoggingSetting can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gemini/loggingSetting:LoggingSetting default projects/{{project}}/locations/{{location}}/loggingSettings/{{logging_setting_id}}
        ```

        ```sh
        $ pulumi import gcp:gemini/loggingSetting:LoggingSetting default {{project}}/{{location}}/{{logging_setting_id}}
        ```

        ```sh
        $ pulumi import gcp:gemini/loggingSetting:LoggingSetting default {{location}}/{{logging_setting_id}}
        ```

        :param str resource_name: The name of the resource.
        :param LoggingSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoggingSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_prompts_and_responses: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging_setting_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoggingSettingArgs.__new__(LoggingSettingArgs)

            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["log_metadata"] = log_metadata
            __props__.__dict__["log_prompts_and_responses"] = log_prompts_and_responses
            if logging_setting_id is None and not opts.urn:
                raise TypeError("Missing required property 'logging_setting_id'")
            __props__.__dict__["logging_setting_id"] = logging_setting_id
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LoggingSetting, __self__).__init__(
            'gcp:gemini/loggingSetting:LoggingSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            log_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
            log_prompts_and_responses: Optional[pulumi.Input[_builtins.bool]] = None,
            logging_setting_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoggingSetting':
        """
        Get an existing LoggingSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Create time stamp.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.bool] log_metadata: Whether to log metadata.
        :param pulumi.Input[_builtins.bool] log_prompts_and_responses: Whether to log prompts and responses.
        :param pulumi.Input[_builtins.str] logging_setting_id: Id of the Logging Setting.
        :param pulumi.Input[_builtins.str] name: Identifier. Name of the resource.
               Format:projects/{project}/locations/{location}/loggingsettings/{loggingsetting}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] update_time: Update time stamp.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoggingSettingState.__new__(_LoggingSettingState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["log_metadata"] = log_metadata
        __props__.__dict__["log_prompts_and_responses"] = log_prompts_and_responses
        __props__.__dict__["logging_setting_id"] = logging_setting_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["update_time"] = update_time
        return LoggingSetting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Create time stamp.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels as key value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="logMetadata")
    def log_metadata(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to log metadata.
        """
        return pulumi.get(self, "log_metadata")

    @_builtins.property
    @pulumi.getter(name="logPromptsAndResponses")
    def log_prompts_and_responses(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to log prompts and responses.
        """
        return pulumi.get(self, "log_prompts_and_responses")

    @_builtins.property
    @pulumi.getter(name="loggingSettingId")
    def logging_setting_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the Logging Setting.
        """
        return pulumi.get(self, "logging_setting_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. Name of the resource.
        Format:projects/{project}/locations/{location}/loggingsettings/{loggingsetting}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Update time stamp.
        """
        return pulumi.get(self, "update_time")

