# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CodeToolsSettingEnabledTool',
    'CodeToolsSettingEnabledToolConfig',
    'RepositoryGroupIamBindingCondition',
    'RepositoryGroupIamMemberCondition',
    'RepositoryGroupRepository',
]

@pulumi.output_type
class CodeToolsSettingEnabledTool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountConnector":
            suggest = "account_connector"
        elif key == "uriOverride":
            suggest = "uri_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeToolsSettingEnabledTool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeToolsSettingEnabledTool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeToolsSettingEnabledTool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 handle: _builtins.str,
                 tool: _builtins.str,
                 account_connector: Optional[_builtins.str] = None,
                 configs: Optional[Sequence['outputs.CodeToolsSettingEnabledToolConfig']] = None,
                 uri_override: Optional[_builtins.str] = None):
        """
        :param _builtins.str handle: Handle used to invoke the tool.
        :param _builtins.str tool: Link to the Tool
        :param _builtins.str account_connector: Link to the Dev Connect Account Connector that holds the user credentials.
               projects/{project}/locations/{location}/accountConnectors/{account_connector_id}
        :param Sequence['CodeToolsSettingEnabledToolConfigArgs'] configs: Configuration parameters for the tool.
               Structure is documented below.
        :param _builtins.str uri_override: Overridden URI, if allowed by Tool.
        """
        pulumi.set(__self__, "handle", handle)
        pulumi.set(__self__, "tool", tool)
        if account_connector is not None:
            pulumi.set(__self__, "account_connector", account_connector)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if uri_override is not None:
            pulumi.set(__self__, "uri_override", uri_override)

    @_builtins.property
    @pulumi.getter
    def handle(self) -> _builtins.str:
        """
        Handle used to invoke the tool.
        """
        return pulumi.get(self, "handle")

    @_builtins.property
    @pulumi.getter
    def tool(self) -> _builtins.str:
        """
        Link to the Tool
        """
        return pulumi.get(self, "tool")

    @_builtins.property
    @pulumi.getter(name="accountConnector")
    def account_connector(self) -> Optional[_builtins.str]:
        """
        Link to the Dev Connect Account Connector that holds the user credentials.
        projects/{project}/locations/{location}/accountConnectors/{account_connector_id}
        """
        return pulumi.get(self, "account_connector")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[Sequence['outputs.CodeToolsSettingEnabledToolConfig']]:
        """
        Configuration parameters for the tool.
        Structure is documented below.
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="uriOverride")
    def uri_override(self) -> Optional[_builtins.str]:
        """
        Overridden URI, if allowed by Tool.
        """
        return pulumi.get(self, "uri_override")


@pulumi.output_type
class CodeToolsSettingEnabledToolConfig(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: Key of the configuration item.
        :param _builtins.str value: Value of the configuration item.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key of the configuration item.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the configuration item.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RepositoryGroupIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RepositoryGroupIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RepositoryGroupRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchPattern":
            suggest = "branch_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryGroupRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryGroupRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryGroupRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_pattern: _builtins.str,
                 resource: _builtins.str):
        """
        :param _builtins.str branch_pattern: Required. The Git branch pattern used for indexing in RE2 syntax.
               See https://github.com/google/re2/wiki/syntax for syntax.
        :param _builtins.str resource: Required. The DeveloperConnect repository full resource name, relative resource name
               or resource URL to be indexed.
        """
        pulumi.set(__self__, "branch_pattern", branch_pattern)
        pulumi.set(__self__, "resource", resource)

    @_builtins.property
    @pulumi.getter(name="branchPattern")
    def branch_pattern(self) -> _builtins.str:
        """
        Required. The Git branch pattern used for indexing in RE2 syntax.
        See https://github.com/google/re2/wiki/syntax for syntax.
        """
        return pulumi.get(self, "branch_pattern")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> _builtins.str:
        """
        Required. The DeveloperConnect repository full resource name, relative resource name
        or resource URL to be indexed.
        """
        return pulumi.get(self, "resource")


