# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMembershipResult',
    'AwaitableGetMembershipResult',
    'get_membership',
    'get_membership_output',
]

@pulumi.output_type
class GetMembershipResult:
    """
    A collection of values returned by getMembership.
    """
    def __init__(__self__, authorities=None, effective_labels=None, endpoints=None, id=None, labels=None, location=None, membership_id=None, name=None, project=None, pulumi_labels=None):
        if authorities and not isinstance(authorities, list):
            raise TypeError("Expected argument 'authorities' to be a list")
        pulumi.set(__self__, "authorities", authorities)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if membership_id and not isinstance(membership_id, str):
            raise TypeError("Expected argument 'membership_id' to be a str")
        pulumi.set(__self__, "membership_id", membership_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)

    @_builtins.property
    @pulumi.getter
    def authorities(self) -> Sequence['outputs.GetMembershipAuthorityResult']:
        return pulumi.get(self, "authorities")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetMembershipEndpointResult']:
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="membershipId")
    def membership_id(self) -> _builtins.str:
        return pulumi.get(self, "membership_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "pulumi_labels")


class AwaitableGetMembershipResult(GetMembershipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMembershipResult(
            authorities=self.authorities,
            effective_labels=self.effective_labels,
            endpoints=self.endpoints,
            id=self.id,
            labels=self.labels,
            location=self.location,
            membership_id=self.membership_id,
            name=self.name,
            project=self.project,
            pulumi_labels=self.pulumi_labels)


def get_membership(location: Optional[_builtins.str] = None,
                   membership_id: Optional[_builtins.str] = None,
                   project: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMembershipResult:
    """
    Retrieves the details of a specific GKE Hub Membership. Use this data source to retrieve the membership's configuration and state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.gkehub.get_membership(project="my-project-id",
        location="global",
        membership_id="my-membership-id")
    ```


    :param _builtins.str location: The location for the GKE Hub Membership.
           Currently only `global` is supported.
    :param _builtins.str membership_id: The GKE Hub Membership id or GKE Cluster's name.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['membershipId'] = membership_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:gkehub/getMembership:getMembership', __args__, opts=opts, typ=GetMembershipResult).value

    return AwaitableGetMembershipResult(
        authorities=pulumi.get(__ret__, 'authorities'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        membership_id=pulumi.get(__ret__, 'membership_id'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'))
def get_membership_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                          membership_id: Optional[pulumi.Input[_builtins.str]] = None,
                          project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMembershipResult]:
    """
    Retrieves the details of a specific GKE Hub Membership. Use this data source to retrieve the membership's configuration and state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.gkehub.get_membership(project="my-project-id",
        location="global",
        membership_id="my-membership-id")
    ```


    :param _builtins.str location: The location for the GKE Hub Membership.
           Currently only `global` is supported.
    :param _builtins.str membership_id: The GKE Hub Membership id or GKE Cluster's name.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['membershipId'] = membership_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:gkehub/getMembership:getMembership', __args__, opts=opts, typ=GetMembershipResult)
    return __ret__.apply(lambda __response__: GetMembershipResult(
        authorities=pulumi.get(__response__, 'authorities'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        endpoints=pulumi.get(__response__, 'endpoints'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        location=pulumi.get(__response__, 'location'),
        membership_id=pulumi.get(__response__, 'membership_id'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels')))
