# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OauthClientCredentialArgs', 'OauthClientCredential']

@pulumi.input_type
class OauthClientCredentialArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 oauth_client_credential_id: pulumi.Input[_builtins.str],
                 oauthclient: pulumi.Input[_builtins.str],
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OauthClientCredential resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] oauth_client_credential_id: Required. The ID to use for the OauthClientCredential, which becomes the
               final component of the resource name. This value should be 4-32 characters,
               and may contain the characters [a-z0-9-]. The prefix `gcp-` is
               reserved for use by Google, and may not be specified.
        :param pulumi.Input[_builtins.str] oauthclient: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.bool] disabled: Whether the OauthClientCredential is disabled. You cannot use a
               disabled OauthClientCredential.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name of the OauthClientCredential.
               Cannot exceed 32 characters.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "oauth_client_credential_id", oauth_client_credential_id)
        pulumi.set(__self__, "oauthclient", oauthclient)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="oauthClientCredentialId")
    def oauth_client_credential_id(self) -> pulumi.Input[_builtins.str]:
        """
        Required. The ID to use for the OauthClientCredential, which becomes the
        final component of the resource name. This value should be 4-32 characters,
        and may contain the characters [a-z0-9-]. The prefix `gcp-` is
        reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "oauth_client_credential_id")

    @oauth_client_credential_id.setter
    def oauth_client_credential_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oauth_client_credential_id", value)

    @_builtins.property
    @pulumi.getter
    def oauthclient(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "oauthclient")

    @oauthclient.setter
    def oauthclient(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oauthclient", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the OauthClientCredential is disabled. You cannot use a
        disabled OauthClientCredential.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-specified display name of the OauthClientCredential.
        Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _OauthClientCredentialState:
    def __init__(__self__, *,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oauthclient: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OauthClientCredential resources.
        :param pulumi.Input[_builtins.str] client_secret: The system-generated OAuth client secret.
               The client secret must be stored securely. If the client secret is
               leaked, you must delete and re-create the client credential. To learn
               more, see [OAuth client and credential security risks and
               mitigations](https://cloud.google.com/iam/docs/workforce-oauth-app#security)
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.bool] disabled: Whether the OauthClientCredential is disabled. You cannot use a
               disabled OauthClientCredential.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name of the OauthClientCredential.
               Cannot exceed 32 characters.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Immutable. Identifier. The resource name of the OauthClientCredential.
               Format:
               `projects/{project}/locations/{location}/oauthClients/{oauth_client}/credentials/{credential}`
        :param pulumi.Input[_builtins.str] oauth_client_credential_id: Required. The ID to use for the OauthClientCredential, which becomes the
               final component of the resource name. This value should be 4-32 characters,
               and may contain the characters [a-z0-9-]. The prefix `gcp-` is
               reserved for use by Google, and may not be specified.
        :param pulumi.Input[_builtins.str] oauthclient: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_client_credential_id is not None:
            pulumi.set(__self__, "oauth_client_credential_id", oauth_client_credential_id)
        if oauthclient is not None:
            pulumi.set(__self__, "oauthclient", oauthclient)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system-generated OAuth client secret.
        The client secret must be stored securely. If the client secret is
        leaked, you must delete and re-create the client credential. To learn
        more, see [OAuth client and credential security risks and
        mitigations](https://cloud.google.com/iam/docs/workforce-oauth-app#security)
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the OauthClientCredential is disabled. You cannot use a
        disabled OauthClientCredential.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-specified display name of the OauthClientCredential.
        Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Immutable. Identifier. The resource name of the OauthClientCredential.
        Format:
        `projects/{project}/locations/{location}/oauthClients/{oauth_client}/credentials/{credential}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oauthClientCredentialId")
    def oauth_client_credential_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The ID to use for the OauthClientCredential, which becomes the
        final component of the resource name. This value should be 4-32 characters,
        and may contain the characters [a-z0-9-]. The prefix `gcp-` is
        reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "oauth_client_credential_id")

    @oauth_client_credential_id.setter
    def oauth_client_credential_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_client_credential_id", value)

    @_builtins.property
    @pulumi.getter
    def oauthclient(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "oauthclient")

    @oauthclient.setter
    def oauthclient(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauthclient", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:iam/oauthClientCredential:OauthClientCredential")
class OauthClientCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oauthclient: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents an OAuth Client Credential. Used to authenticate an OAuth Client
        while accessing Google Cloud resources on behalf of a Workforce Identity Federation user
        by using OAuth 2.0 Protocol.

        To get more information about OauthClientCredential, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/projects.locations.oauthClients.credentials)
        * How-to Guides
            * [Managing OAuth clients](https://cloud.google.com/iam/docs/workforce-manage-oauth-app#manage-clients)

        ## Example Usage

        ### Iam Oauth Client Credential Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        oauth_client = gcp.iam.OauthClient("oauth_client",
            oauth_client_id="example-client-id",
            location="global",
            allowed_grant_types=["AUTHORIZATION_CODE_GRANT"],
            allowed_redirect_uris=["https://www.example.com"],
            allowed_scopes=["https://www.googleapis.com/auth/cloud-platform"],
            client_type="CONFIDENTIAL_CLIENT")
        example = gcp.iam.OauthClientCredential("example",
            oauthclient=oauth_client.oauth_client_id,
            location=oauth_client.location,
            oauth_client_credential_id="cred-id",
            disabled=True,
            display_name="Display Name of credential")
        ```

        ## Import

        OauthClientCredential can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/oauthClients/{{oauthclient}}/credentials/{{oauth_client_credential_id}}`

        * `{{project}}/{{location}}/{{oauthclient}}/{{oauth_client_credential_id}}`

        * `{{location}}/{{oauthclient}}/{{oauth_client_credential_id}}`

        When using the `pulumi import` command, OauthClientCredential can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/oauthClientCredential:OauthClientCredential default projects/{{project}}/locations/{{location}}/oauthClients/{{oauthclient}}/credentials/{{oauth_client_credential_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/oauthClientCredential:OauthClientCredential default {{project}}/{{location}}/{{oauthclient}}/{{oauth_client_credential_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/oauthClientCredential:OauthClientCredential default {{location}}/{{oauthclient}}/{{oauth_client_credential_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disabled: Whether the OauthClientCredential is disabled. You cannot use a
               disabled OauthClientCredential.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name of the OauthClientCredential.
               Cannot exceed 32 characters.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] oauth_client_credential_id: Required. The ID to use for the OauthClientCredential, which becomes the
               final component of the resource name. This value should be 4-32 characters,
               and may contain the characters [a-z0-9-]. The prefix `gcp-` is
               reserved for use by Google, and may not be specified.
        :param pulumi.Input[_builtins.str] oauthclient: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OauthClientCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an OAuth Client Credential. Used to authenticate an OAuth Client
        while accessing Google Cloud resources on behalf of a Workforce Identity Federation user
        by using OAuth 2.0 Protocol.

        To get more information about OauthClientCredential, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/projects.locations.oauthClients.credentials)
        * How-to Guides
            * [Managing OAuth clients](https://cloud.google.com/iam/docs/workforce-manage-oauth-app#manage-clients)

        ## Example Usage

        ### Iam Oauth Client Credential Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        oauth_client = gcp.iam.OauthClient("oauth_client",
            oauth_client_id="example-client-id",
            location="global",
            allowed_grant_types=["AUTHORIZATION_CODE_GRANT"],
            allowed_redirect_uris=["https://www.example.com"],
            allowed_scopes=["https://www.googleapis.com/auth/cloud-platform"],
            client_type="CONFIDENTIAL_CLIENT")
        example = gcp.iam.OauthClientCredential("example",
            oauthclient=oauth_client.oauth_client_id,
            location=oauth_client.location,
            oauth_client_credential_id="cred-id",
            disabled=True,
            display_name="Display Name of credential")
        ```

        ## Import

        OauthClientCredential can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/oauthClients/{{oauthclient}}/credentials/{{oauth_client_credential_id}}`

        * `{{project}}/{{location}}/{{oauthclient}}/{{oauth_client_credential_id}}`

        * `{{location}}/{{oauthclient}}/{{oauth_client_credential_id}}`

        When using the `pulumi import` command, OauthClientCredential can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/oauthClientCredential:OauthClientCredential default projects/{{project}}/locations/{{location}}/oauthClients/{{oauthclient}}/credentials/{{oauth_client_credential_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/oauthClientCredential:OauthClientCredential default {{project}}/{{location}}/{{oauthclient}}/{{oauth_client_credential_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/oauthClientCredential:OauthClientCredential default {{location}}/{{oauthclient}}/{{oauth_client_credential_id}}
        ```

        :param str resource_name: The name of the resource.
        :param OauthClientCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OauthClientCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oauthclient: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OauthClientCredentialArgs.__new__(OauthClientCredentialArgs)

            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if oauth_client_credential_id is None and not opts.urn:
                raise TypeError("Missing required property 'oauth_client_credential_id'")
            __props__.__dict__["oauth_client_credential_id"] = oauth_client_credential_id
            if oauthclient is None and not opts.urn:
                raise TypeError("Missing required property 'oauthclient'")
            __props__.__dict__["oauthclient"] = oauthclient
            __props__.__dict__["project"] = project
            __props__.__dict__["client_secret"] = None
            __props__.__dict__["name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OauthClientCredential, __self__).__init__(
            'gcp:iam/oauthClientCredential:OauthClientCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_client_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
            oauthclient: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None) -> 'OauthClientCredential':
        """
        Get an existing OauthClientCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_secret: The system-generated OAuth client secret.
               The client secret must be stored securely. If the client secret is
               leaked, you must delete and re-create the client credential. To learn
               more, see [OAuth client and credential security risks and
               mitigations](https://cloud.google.com/iam/docs/workforce-oauth-app#security)
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.bool] disabled: Whether the OauthClientCredential is disabled. You cannot use a
               disabled OauthClientCredential.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name of the OauthClientCredential.
               Cannot exceed 32 characters.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Immutable. Identifier. The resource name of the OauthClientCredential.
               Format:
               `projects/{project}/locations/{location}/oauthClients/{oauth_client}/credentials/{credential}`
        :param pulumi.Input[_builtins.str] oauth_client_credential_id: Required. The ID to use for the OauthClientCredential, which becomes the
               final component of the resource name. This value should be 4-32 characters,
               and may contain the characters [a-z0-9-]. The prefix `gcp-` is
               reserved for use by Google, and may not be specified.
        :param pulumi.Input[_builtins.str] oauthclient: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OauthClientCredentialState.__new__(_OauthClientCredentialState)

        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth_client_credential_id"] = oauth_client_credential_id
        __props__.__dict__["oauthclient"] = oauthclient
        __props__.__dict__["project"] = project
        return OauthClientCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[_builtins.str]:
        """
        The system-generated OAuth client secret.
        The client secret must be stored securely. If the client secret is
        leaked, you must delete and re-create the client credential. To learn
        more, see [OAuth client and credential security risks and
        mitigations](https://cloud.google.com/iam/docs/workforce-oauth-app#security)
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the OauthClientCredential is disabled. You cannot use a
        disabled OauthClientCredential.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A user-specified display name of the OauthClientCredential.
        Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Immutable. Identifier. The resource name of the OauthClientCredential.
        Format:
        `projects/{project}/locations/{location}/oauthClients/{oauth_client}/credentials/{credential}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oauthClientCredentialId")
    def oauth_client_credential_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The ID to use for the OauthClientCredential, which becomes the
        final component of the resource name. This value should be 4-32 characters,
        and may contain the characters [a-z0-9-]. The prefix `gcp-` is
        reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "oauth_client_credential_id")

    @_builtins.property
    @pulumi.getter
    def oauthclient(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "oauthclient")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

