# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkforcePoolIamPolicyArgs', 'WorkforcePoolIamPolicy']

@pulumi.input_type
class WorkforcePoolIamPolicyArgs:
    def __init__(__self__, *,
                 policy_data: pulumi.Input[_builtins.str],
                 workforce_pool_id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkforcePoolIamPolicy resource.
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] workforce_pool_id: Used to find the parent resource to bind the IAM policy to
        :param pulumi.Input[_builtins.str] location: The location for the resource. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        """
        pulumi.set(__self__, "policy_data", policy_data)
        pulumi.set(__self__, "workforce_pool_id", workforce_pool_id)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Input[_builtins.str]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_data", value)

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "workforce_pool_id")

    @workforce_pool_id.setter
    def workforce_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workforce_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the resource. Used to find the parent resource to bind the IAM policy to. If not specified,
        the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
        location is specified, it is taken from the provider configuration.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class _WorkforcePoolIamPolicyState:
    def __init__(__self__, *,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkforcePoolIamPolicy resources.
        :param pulumi.Input[_builtins.str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[_builtins.str] location: The location for the resource. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] workforce_pool_id: Used to find the parent resource to bind the IAM policy to
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if policy_data is not None:
            pulumi.set(__self__, "policy_data", policy_data)
        if workforce_pool_id is not None:
            pulumi.set(__self__, "workforce_pool_id", workforce_pool_id)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the resource. Used to find the parent resource to bind the IAM policy to. If not specified,
        the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
        location is specified, it is taken from the provider configuration.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_data", value)

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "workforce_pool_id")

    @workforce_pool_id.setter
    def workforce_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workforce_pool_id", value)


@pulumi.type_token("gcp:iam/workforcePoolIamPolicy:WorkforcePoolIamPolicy")
class WorkforcePoolIamPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Three different resources help you manage your IAM policy for Cloud IAM WorkforcePool. Each of these resources serves a different use case:

        * `iam.WorkforcePoolIamPolicy`: Authoritative. Sets the IAM policy for the workforcepool and replaces any existing policy already attached.
        * `iam.WorkforcePoolIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the workforcepool are preserved.
        * `iam.WorkforcePoolIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the workforcepool are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `iam.WorkforcePoolIamPolicy`: Retrieves the IAM policy for the workforcepool

        > **Note:** `iam.WorkforcePoolIamPolicy` **cannot** be used in conjunction with `iam.WorkforcePoolIamBinding` and `iam.WorkforcePoolIamMember` or they will fight over what your policy should be.

        > **Note:** `iam.WorkforcePoolIamBinding` resources **can be** used in conjunction with `iam.WorkforcePoolIamMember` resources **only if** they do not grant privilege to the same role.

        ## iam.WorkforcePoolIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iam.workforcePoolAdmin",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.iam.WorkforcePoolIamPolicy("policy",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            policy_data=admin.policy_data)
        ```

        ## iam.WorkforcePoolIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iam.WorkforcePoolIamBinding("binding",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            role="roles/iam.workforcePoolAdmin",
            members=["user:jane@example.com"])
        ```

        ## iam.WorkforcePoolIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iam.WorkforcePoolIamMember("member",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            role="roles/iam.workforcePoolAdmin",
            member="user:jane@example.com")
        ```

        ## > **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

        full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.
        ---

        # IAM policy for Cloud IAM WorkforcePool

        Three different resources help you manage your IAM policy for Cloud IAM WorkforcePool. Each of these resources serves a different use case:

        * `iam.WorkforcePoolIamPolicy`: Authoritative. Sets the IAM policy for the workforcepool and replaces any existing policy already attached.
        * `iam.WorkforcePoolIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the workforcepool are preserved.
        * `iam.WorkforcePoolIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the workforcepool are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `iam.WorkforcePoolIamPolicy`: Retrieves the IAM policy for the workforcepool

        > **Note:** `iam.WorkforcePoolIamPolicy` **cannot** be used in conjunction with `iam.WorkforcePoolIamBinding` and `iam.WorkforcePoolIamMember` or they will fight over what your policy should be.

        > **Note:** `iam.WorkforcePoolIamBinding` resources **can be** used in conjunction with `iam.WorkforcePoolIamMember` resources **only if** they do not grant privilege to the same role.

        ## iam.WorkforcePoolIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iam.workforcePoolAdmin",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.iam.WorkforcePoolIamPolicy("policy",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            policy_data=admin.policy_data)
        ```

        ## iam.WorkforcePoolIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iam.WorkforcePoolIamBinding("binding",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            role="roles/iam.workforcePoolAdmin",
            members=["user:jane@example.com"])
        ```

        ## iam.WorkforcePoolIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iam.WorkforcePoolIamMember("member",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            role="roles/iam.workforcePoolAdmin",
            member="user:jane@example.com")
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms:

        * locations/{{location}}/workforcePools/{{workforce_pool_id}}

        * {{location}}/{{workforce_pool_id}}

        * {{workforce_pool_id}}

        Any variables not passed in the import command will be taken from the provider configuration.

        Cloud IAM workforcepool IAM resources can be imported using the resource identifiers, role, and member.

        IAM member imports use space-delimited identifiers: the resource in question, the role, and the member identity, e.g.

        ```sh
        $ pulumi import gcp:iam/workforcePoolIamPolicy:WorkforcePoolIamPolicy editor "locations/{{location}}/workforcePools/{{workforce_pool_id}} roles/iam.workforcePoolViewer user:jane@example.com"
        ```

        IAM binding imports use space-delimited identifiers: the resource in question and the role, e.g.

        ```sh
        $ pulumi import gcp:iam/workforcePoolIamPolicy:WorkforcePoolIamPolicy editor "locations/{{location}}/workforcePools/{{workforce_pool_id}} roles/iam.workforcePoolViewer"
        ```

        IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
        $ pulumi import gcp:iam/workforcePoolIamPolicy:WorkforcePoolIamPolicy editor locations/{{location}}/workforcePools/{{workforce_pool_id}}
        ```

        -> **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

         full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] workforce_pool_id: Used to find the parent resource to bind the IAM policy to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkforcePoolIamPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Three different resources help you manage your IAM policy for Cloud IAM WorkforcePool. Each of these resources serves a different use case:

        * `iam.WorkforcePoolIamPolicy`: Authoritative. Sets the IAM policy for the workforcepool and replaces any existing policy already attached.
        * `iam.WorkforcePoolIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the workforcepool are preserved.
        * `iam.WorkforcePoolIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the workforcepool are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `iam.WorkforcePoolIamPolicy`: Retrieves the IAM policy for the workforcepool

        > **Note:** `iam.WorkforcePoolIamPolicy` **cannot** be used in conjunction with `iam.WorkforcePoolIamBinding` and `iam.WorkforcePoolIamMember` or they will fight over what your policy should be.

        > **Note:** `iam.WorkforcePoolIamBinding` resources **can be** used in conjunction with `iam.WorkforcePoolIamMember` resources **only if** they do not grant privilege to the same role.

        ## iam.WorkforcePoolIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iam.workforcePoolAdmin",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.iam.WorkforcePoolIamPolicy("policy",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            policy_data=admin.policy_data)
        ```

        ## iam.WorkforcePoolIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iam.WorkforcePoolIamBinding("binding",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            role="roles/iam.workforcePoolAdmin",
            members=["user:jane@example.com"])
        ```

        ## iam.WorkforcePoolIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iam.WorkforcePoolIamMember("member",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            role="roles/iam.workforcePoolAdmin",
            member="user:jane@example.com")
        ```

        ## > **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

        full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.
        ---

        # IAM policy for Cloud IAM WorkforcePool

        Three different resources help you manage your IAM policy for Cloud IAM WorkforcePool. Each of these resources serves a different use case:

        * `iam.WorkforcePoolIamPolicy`: Authoritative. Sets the IAM policy for the workforcepool and replaces any existing policy already attached.
        * `iam.WorkforcePoolIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the workforcepool are preserved.
        * `iam.WorkforcePoolIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the workforcepool are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `iam.WorkforcePoolIamPolicy`: Retrieves the IAM policy for the workforcepool

        > **Note:** `iam.WorkforcePoolIamPolicy` **cannot** be used in conjunction with `iam.WorkforcePoolIamBinding` and `iam.WorkforcePoolIamMember` or they will fight over what your policy should be.

        > **Note:** `iam.WorkforcePoolIamBinding` resources **can be** used in conjunction with `iam.WorkforcePoolIamMember` resources **only if** they do not grant privilege to the same role.

        ## iam.WorkforcePoolIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/iam.workforcePoolAdmin",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.iam.WorkforcePoolIamPolicy("policy",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            policy_data=admin.policy_data)
        ```

        ## iam.WorkforcePoolIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.iam.WorkforcePoolIamBinding("binding",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            role="roles/iam.workforcePoolAdmin",
            members=["user:jane@example.com"])
        ```

        ## iam.WorkforcePoolIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.iam.WorkforcePoolIamMember("member",
            location=example["location"],
            workforce_pool_id=example["workforcePoolId"],
            role="roles/iam.workforcePoolAdmin",
            member="user:jane@example.com")
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms:

        * locations/{{location}}/workforcePools/{{workforce_pool_id}}

        * {{location}}/{{workforce_pool_id}}

        * {{workforce_pool_id}}

        Any variables not passed in the import command will be taken from the provider configuration.

        Cloud IAM workforcepool IAM resources can be imported using the resource identifiers, role, and member.

        IAM member imports use space-delimited identifiers: the resource in question, the role, and the member identity, e.g.

        ```sh
        $ pulumi import gcp:iam/workforcePoolIamPolicy:WorkforcePoolIamPolicy editor "locations/{{location}}/workforcePools/{{workforce_pool_id}} roles/iam.workforcePoolViewer user:jane@example.com"
        ```

        IAM binding imports use space-delimited identifiers: the resource in question and the role, e.g.

        ```sh
        $ pulumi import gcp:iam/workforcePoolIamPolicy:WorkforcePoolIamPolicy editor "locations/{{location}}/workforcePools/{{workforce_pool_id}} roles/iam.workforcePoolViewer"
        ```

        IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
        $ pulumi import gcp:iam/workforcePoolIamPolicy:WorkforcePoolIamPolicy editor locations/{{location}}/workforcePools/{{workforce_pool_id}}
        ```

        -> **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

         full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param WorkforcePoolIamPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkforcePoolIamPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkforcePoolIamPolicyArgs.__new__(WorkforcePoolIamPolicyArgs)

            __props__.__dict__["location"] = location
            if policy_data is None and not opts.urn:
                raise TypeError("Missing required property 'policy_data'")
            __props__.__dict__["policy_data"] = policy_data
            if workforce_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'workforce_pool_id'")
            __props__.__dict__["workforce_pool_id"] = workforce_pool_id
            __props__.__dict__["etag"] = None
        super(WorkforcePoolIamPolicy, __self__).__init__(
            'gcp:iam/workforcePoolIamPolicy:WorkforcePoolIamPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            policy_data: Optional[pulumi.Input[_builtins.str]] = None,
            workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkforcePoolIamPolicy':
        """
        Get an existing WorkforcePoolIamPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[_builtins.str] location: The location for the resource. Used to find the parent resource to bind the IAM policy to. If not specified,
               the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
               location is specified, it is taken from the provider configuration.
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] workforce_pool_id: Used to find the parent resource to bind the IAM policy to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkforcePoolIamPolicyState.__new__(_WorkforcePoolIamPolicyState)

        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["policy_data"] = policy_data
        __props__.__dict__["workforce_pool_id"] = workforce_pool_id
        return WorkforcePoolIamPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the resource. Used to find the parent resource to bind the IAM policy to. If not specified,
        the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
        location is specified, it is taken from the provider configuration.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Output[_builtins.str]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "workforce_pool_id")

