# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkforcePoolProviderKeyArgs', 'WorkforcePoolProviderKey']

@pulumi.input_type
class WorkforcePoolProviderKeyArgs:
    def __init__(__self__, *,
                 key_data: pulumi.Input['WorkforcePoolProviderKeyKeyDataArgs'],
                 key_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 provider_id: pulumi.Input[_builtins.str],
                 use: pulumi.Input[_builtins.str],
                 workforce_pool_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a WorkforcePoolProviderKey resource.
        :param pulumi.Input['WorkforcePoolProviderKeyKeyDataArgs'] key_data: Immutable. Public half of the asymmetric key.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] key_id: The ID to use for the key, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[_builtins.str] provider_id: The ID of the provider.
        :param pulumi.Input[_builtins.str] use: The purpose of the key.
               Possible values are: `ENCRYPTION`.
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID of the workforce pool.
        """
        pulumi.set(__self__, "key_data", key_data)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "provider_id", provider_id)
        pulumi.set(__self__, "use", use)
        pulumi.set(__self__, "workforce_pool_id", workforce_pool_id)

    @_builtins.property
    @pulumi.getter(name="keyData")
    def key_data(self) -> pulumi.Input['WorkforcePoolProviderKeyKeyDataArgs']:
        """
        Immutable. Public half of the asymmetric key.
        Structure is documented below.
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: pulumi.Input['WorkforcePoolProviderKeyKeyDataArgs']):
        pulumi.set(self, "key_data", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the key, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the provider.
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_id", value)

    @_builtins.property
    @pulumi.getter
    def use(self) -> pulumi.Input[_builtins.str]:
        """
        The purpose of the key.
        Possible values are: `ENCRYPTION`.
        """
        return pulumi.get(self, "use")

    @use.setter
    def use(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "use", value)

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workforce pool.
        """
        return pulumi.get(self, "workforce_pool_id")

    @workforce_pool_id.setter
    def workforce_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workforce_pool_id", value)


@pulumi.input_type
class _WorkforcePoolProviderKeyState:
    def __init__(__self__, *,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 key_data: Optional[pulumi.Input['WorkforcePoolProviderKeyKeyDataArgs']] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 use: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkforcePoolProviderKey resources.
        :param pulumi.Input[_builtins.str] expire_time: The time after which the key will be permanently deleted and cannot be recovered.
               Note that the key may get purged before this time if the total limit of keys per provider is exceeded.
        :param pulumi.Input['WorkforcePoolProviderKeyKeyDataArgs'] key_data: Immutable. Public half of the asymmetric key.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] key_id: The ID to use for the key, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the key.
               Format: `locations/{location}/workforcePools/{workforcePoolId}/providers/{providerId}/keys/{keyId}`
        :param pulumi.Input[_builtins.str] provider_id: The ID of the provider.
        :param pulumi.Input[_builtins.str] state: The state of the key.
        :param pulumi.Input[_builtins.str] use: The purpose of the key.
               Possible values are: `ENCRYPTION`.
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID of the workforce pool.
        """
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provider_id is not None:
            pulumi.set(__self__, "provider_id", provider_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if use is not None:
            pulumi.set(__self__, "use", use)
        if workforce_pool_id is not None:
            pulumi.set(__self__, "workforce_pool_id", workforce_pool_id)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time after which the key will be permanently deleted and cannot be recovered.
        Note that the key may get purged before this time if the total limit of keys per provider is exceeded.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[pulumi.Input['WorkforcePoolProviderKeyKeyDataArgs']]:
        """
        Immutable. Public half of the asymmetric key.
        Structure is documented below.
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: Optional[pulumi.Input['WorkforcePoolProviderKeyKeyDataArgs']]):
        pulumi.set(self, "key_data", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the key, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name of the key.
        Format: `locations/{location}/workforcePools/{workforcePoolId}/providers/{providerId}/keys/{keyId}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the provider.
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the key.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def use(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The purpose of the key.
        Possible values are: `ENCRYPTION`.
        """
        return pulumi.get(self, "use")

    @use.setter
    def use(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "use", value)

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workforce pool.
        """
        return pulumi.get(self, "workforce_pool_id")

    @workforce_pool_id.setter
    def workforce_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workforce_pool_id", value)


@pulumi.type_token("gcp:iam/workforcePoolProviderKey:WorkforcePoolProviderKey")
class WorkforcePoolProviderKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_data: Optional[pulumi.Input[Union['WorkforcePoolProviderKeyKeyDataArgs', 'WorkforcePoolProviderKeyKeyDataArgsDict']]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents a public key configuration for a Workforce Pool Provider. The key can be configured in your identity provider to encrypt SAML assertions.
        Google holds the corresponding private key, which it uses to decrypt encrypted tokens.

        To get more information about WorkforcePoolProviderKey, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/locations.workforcePools.providers.keys)
        * How-to Guides
            * [Configure a provider within the workforce pool](https://cloud.google.com/iam/docs/manage-workforce-identity-pools-providers#configure_a_provider_within_the_workforce_pool)
            * [Workforce Identity Federation Overview](https://cloud.google.com/iam/docs/workforce-identity-federation)

        ## Example Usage

        ### Iam Workforce Pool Provider Saml Key Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        provider = gcp.iam.WorkforcePoolProvider("provider",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            saml={
                "idp_metadata_xml": "<?xml version=\\"1.0\\"?><md:EntityDescriptor xmlns:md=\\"urn:oasis:names:tc:SAML:2.0:metadata\\" entityID=\\"https://test.com\\"><md:IDPSSODescriptor protocolSupportEnumeration=\\"urn:oasis:names:tc:SAML:2.0:protocol\\"> <md:KeyDescriptor use=\\"signing\\"><ds:KeyInfo xmlns:ds=\\"http://www.w3.org/2000/09/xmldsig#\\"><ds:X509Data><ds:X509Certificate>MIIDpDCCAoygAwIBAgIGAX7/5qPhMA0GCSqGSIb3DQEBCwUAMIGSMQswCQYDVQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEWMBQGA1UEBwwNU2FuIEZyYW5jaXNjbzENMAsGA1UECgwET2t0YTEUMBIGA1UECwwLU1NPUHJvdmlkZXIxEzARBgNVBAMMCmRldi00NTg0MjExHDAaBgkqhkiG9w0BCQEWDWluZm9Ab2t0YS5jb20wHhcNMjIwMjE2MDAxOTEyWhcNMzIwMjE2MDAyMDEyWjCBkjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNVBAcMDVNhbiBGcmFuY2lzY28xDTALBgNVBAoMBE9rdGExFDASBgNVBAsMC1NTT1Byb3ZpZGVyMRMwEQYDVQQDDApkZXYtNDU4NDIxMRwwGgYJKoZIhvcNAQkBFg1pbmZvQG9rdGEuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxrBl7GKz52cRpxF9xCsirnRuMxnhFBaUrsHqAQrLqWmdlpNYZTVg+T9iQ+aq/iE68L+BRZcZniKIvW58wqqS0ltXVvIkXuDSvnvnkkI5yMIVErR20K8jSOKQm1FmK+fgAJ4koshFiu9oLiqu0Ejc0DuL3/XRsb4RuxjktKTb1khgBBtb+7idEk0sFR0RPefAweXImJkDHDm7SxjDwGJUubbqpdTxasPr0W+AHI1VUzsUsTiHAoyb0XDkYqHfDzhj/ZdIEl4zHQ3bEZvlD984ztAnmX2SuFLLKfXeAAGHei8MMixJvwxYkkPeYZ/5h8WgBZPP4heS2CPjwYExt29L8QIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQARjJFz++a9Z5IQGFzsZMrX2EDR5ML4xxUiQkbhld1S1PljOLcYFARDmUC2YYHOueU4ee8Jid9nPGEUebV/4Jok+b+oQh+dWMgiWjSLI7h5q4OYZ3VJtdlVwgMFt2iz+/4yBKMUZ50g3Qgg36vE34us+eKitg759JgCNsibxn0qtJgSPm0sgP2L6yTaLnoEUbXBRxCwynTSkp9ZijZqEzbhN0e2dWv7Rx/nfpohpDP6vEiFImKFHpDSv3M/5de1ytQzPFrZBYt9WlzlYwE1aD9FHCxdd+rWgYMVVoRaRmndpV/Rq3QUuDuFJtaoX11bC7ExkOpg9KstZzA63i3VcfYv</ds:X509Certificate></ds:X509Data></ds:KeyInfo></md:KeyDescriptor><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\\" Location=\\"https://test.com/sso\\"/></md:IDPSSODescriptor></md:EntityDescriptor>",
            })
        example = gcp.iam.WorkforcePoolProviderKey("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id=provider.provider_id,
            key_id="example-key",
            key_data={
                "key_spec": "RSA_2048",
            },
            use="ENCRYPTION")
        ```

        ## Import

        WorkforcePoolProviderKey can be imported using any of these accepted formats:

        * `locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}/keys/{{key_id}}`

        * `{{location}}/{{workforce_pool_id}}/{{provider_id}}/{{key_id}}`

        When using the `pulumi import` command, WorkforcePoolProviderKey can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workforcePoolProviderKey:WorkforcePoolProviderKey default locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}/keys/{{key_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workforcePoolProviderKey:WorkforcePoolProviderKey default {{location}}/{{workforce_pool_id}}/{{provider_id}}/{{key_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WorkforcePoolProviderKeyKeyDataArgs', 'WorkforcePoolProviderKeyKeyDataArgsDict']] key_data: Immutable. Public half of the asymmetric key.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] key_id: The ID to use for the key, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[_builtins.str] provider_id: The ID of the provider.
        :param pulumi.Input[_builtins.str] use: The purpose of the key.
               Possible values are: `ENCRYPTION`.
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID of the workforce pool.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkforcePoolProviderKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a public key configuration for a Workforce Pool Provider. The key can be configured in your identity provider to encrypt SAML assertions.
        Google holds the corresponding private key, which it uses to decrypt encrypted tokens.

        To get more information about WorkforcePoolProviderKey, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/locations.workforcePools.providers.keys)
        * How-to Guides
            * [Configure a provider within the workforce pool](https://cloud.google.com/iam/docs/manage-workforce-identity-pools-providers#configure_a_provider_within_the_workforce_pool)
            * [Workforce Identity Federation Overview](https://cloud.google.com/iam/docs/workforce-identity-federation)

        ## Example Usage

        ### Iam Workforce Pool Provider Saml Key Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        provider = gcp.iam.WorkforcePoolProvider("provider",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            saml={
                "idp_metadata_xml": "<?xml version=\\"1.0\\"?><md:EntityDescriptor xmlns:md=\\"urn:oasis:names:tc:SAML:2.0:metadata\\" entityID=\\"https://test.com\\"><md:IDPSSODescriptor protocolSupportEnumeration=\\"urn:oasis:names:tc:SAML:2.0:protocol\\"> <md:KeyDescriptor use=\\"signing\\"><ds:KeyInfo xmlns:ds=\\"http://www.w3.org/2000/09/xmldsig#\\"><ds:X509Data><ds:X509Certificate>MIIDpDCCAoygAwIBAgIGAX7/5qPhMA0GCSqGSIb3DQEBCwUAMIGSMQswCQYDVQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEWMBQGA1UEBwwNU2FuIEZyYW5jaXNjbzENMAsGA1UECgwET2t0YTEUMBIGA1UECwwLU1NPUHJvdmlkZXIxEzARBgNVBAMMCmRldi00NTg0MjExHDAaBgkqhkiG9w0BCQEWDWluZm9Ab2t0YS5jb20wHhcNMjIwMjE2MDAxOTEyWhcNMzIwMjE2MDAyMDEyWjCBkjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNVBAcMDVNhbiBGcmFuY2lzY28xDTALBgNVBAoMBE9rdGExFDASBgNVBAsMC1NTT1Byb3ZpZGVyMRMwEQYDVQQDDApkZXYtNDU4NDIxMRwwGgYJKoZIhvcNAQkBFg1pbmZvQG9rdGEuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxrBl7GKz52cRpxF9xCsirnRuMxnhFBaUrsHqAQrLqWmdlpNYZTVg+T9iQ+aq/iE68L+BRZcZniKIvW58wqqS0ltXVvIkXuDSvnvnkkI5yMIVErR20K8jSOKQm1FmK+fgAJ4koshFiu9oLiqu0Ejc0DuL3/XRsb4RuxjktKTb1khgBBtb+7idEk0sFR0RPefAweXImJkDHDm7SxjDwGJUubbqpdTxasPr0W+AHI1VUzsUsTiHAoyb0XDkYqHfDzhj/ZdIEl4zHQ3bEZvlD984ztAnmX2SuFLLKfXeAAGHei8MMixJvwxYkkPeYZ/5h8WgBZPP4heS2CPjwYExt29L8QIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQARjJFz++a9Z5IQGFzsZMrX2EDR5ML4xxUiQkbhld1S1PljOLcYFARDmUC2YYHOueU4ee8Jid9nPGEUebV/4Jok+b+oQh+dWMgiWjSLI7h5q4OYZ3VJtdlVwgMFt2iz+/4yBKMUZ50g3Qgg36vE34us+eKitg759JgCNsibxn0qtJgSPm0sgP2L6yTaLnoEUbXBRxCwynTSkp9ZijZqEzbhN0e2dWv7Rx/nfpohpDP6vEiFImKFHpDSv3M/5de1ytQzPFrZBYt9WlzlYwE1aD9FHCxdd+rWgYMVVoRaRmndpV/Rq3QUuDuFJtaoX11bC7ExkOpg9KstZzA63i3VcfYv</ds:X509Certificate></ds:X509Data></ds:KeyInfo></md:KeyDescriptor><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\\" Location=\\"https://test.com/sso\\"/></md:IDPSSODescriptor></md:EntityDescriptor>",
            })
        example = gcp.iam.WorkforcePoolProviderKey("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id=provider.provider_id,
            key_id="example-key",
            key_data={
                "key_spec": "RSA_2048",
            },
            use="ENCRYPTION")
        ```

        ## Import

        WorkforcePoolProviderKey can be imported using any of these accepted formats:

        * `locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}/keys/{{key_id}}`

        * `{{location}}/{{workforce_pool_id}}/{{provider_id}}/{{key_id}}`

        When using the `pulumi import` command, WorkforcePoolProviderKey can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workforcePoolProviderKey:WorkforcePoolProviderKey default locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}/keys/{{key_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workforcePoolProviderKey:WorkforcePoolProviderKey default {{location}}/{{workforce_pool_id}}/{{provider_id}}/{{key_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkforcePoolProviderKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkforcePoolProviderKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_data: Optional[pulumi.Input[Union['WorkforcePoolProviderKeyKeyDataArgs', 'WorkforcePoolProviderKeyKeyDataArgsDict']]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkforcePoolProviderKeyArgs.__new__(WorkforcePoolProviderKeyArgs)

            if key_data is None and not opts.urn:
                raise TypeError("Missing required property 'key_data'")
            __props__.__dict__["key_data"] = key_data
            if key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_id'")
            __props__.__dict__["key_id"] = key_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if provider_id is None and not opts.urn:
                raise TypeError("Missing required property 'provider_id'")
            __props__.__dict__["provider_id"] = provider_id
            if use is None and not opts.urn:
                raise TypeError("Missing required property 'use'")
            __props__.__dict__["use"] = use
            if workforce_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'workforce_pool_id'")
            __props__.__dict__["workforce_pool_id"] = workforce_pool_id
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(WorkforcePoolProviderKey, __self__).__init__(
            'gcp:iam/workforcePoolProviderKey:WorkforcePoolProviderKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            key_data: Optional[pulumi.Input[Union['WorkforcePoolProviderKeyKeyDataArgs', 'WorkforcePoolProviderKeyKeyDataArgsDict']]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            provider_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            use: Optional[pulumi.Input[_builtins.str]] = None,
            workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkforcePoolProviderKey':
        """
        Get an existing WorkforcePoolProviderKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] expire_time: The time after which the key will be permanently deleted and cannot be recovered.
               Note that the key may get purged before this time if the total limit of keys per provider is exceeded.
        :param pulumi.Input[Union['WorkforcePoolProviderKeyKeyDataArgs', 'WorkforcePoolProviderKeyKeyDataArgsDict']] key_data: Immutable. Public half of the asymmetric key.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] key_id: The ID to use for the key, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the key.
               Format: `locations/{location}/workforcePools/{workforcePoolId}/providers/{providerId}/keys/{keyId}`
        :param pulumi.Input[_builtins.str] provider_id: The ID of the provider.
        :param pulumi.Input[_builtins.str] state: The state of the key.
        :param pulumi.Input[_builtins.str] use: The purpose of the key.
               Possible values are: `ENCRYPTION`.
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID of the workforce pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkforcePoolProviderKeyState.__new__(_WorkforcePoolProviderKeyState)

        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["key_data"] = key_data
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["provider_id"] = provider_id
        __props__.__dict__["state"] = state
        __props__.__dict__["use"] = use
        __props__.__dict__["workforce_pool_id"] = workforce_pool_id
        return WorkforcePoolProviderKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time after which the key will be permanently deleted and cannot be recovered.
        Note that the key may get purged before this time if the total limit of keys per provider is exceeded.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter(name="keyData")
    def key_data(self) -> pulumi.Output['outputs.WorkforcePoolProviderKeyKeyData']:
        """
        Immutable. Public half of the asymmetric key.
        Structure is documented below.
        """
        return pulumi.get(self, "key_data")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the key, which becomes the final component of the resource name. This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the resource.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name of the key.
        Format: `locations/{location}/workforcePools/{workforcePoolId}/providers/{providerId}/keys/{keyId}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the provider.
        """
        return pulumi.get(self, "provider_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the key.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def use(self) -> pulumi.Output[_builtins.str]:
        """
        The purpose of the key.
        Possible values are: `ENCRYPTION`.
        """
        return pulumi.get(self, "use")

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workforce pool.
        """
        return pulumi.get(self, "workforce_pool_id")

