# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAppEngineServiceIamPolicyResult',
    'AwaitableGetAppEngineServiceIamPolicyResult',
    'get_app_engine_service_iam_policy',
    'get_app_engine_service_iam_policy_output',
]

@pulumi.output_type
class GetAppEngineServiceIamPolicyResult:
    """
    A collection of values returned by getAppEngineServiceIamPolicy.
    """
    def __init__(__self__, app_id=None, etag=None, id=None, policy_data=None, project=None, service=None):
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service and not isinstance(service, str):
            raise TypeError("Expected argument 'service' to be a str")
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Required only by `iap.AppEngineServiceIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        return pulumi.get(self, "service")


class AwaitableGetAppEngineServiceIamPolicyResult(GetAppEngineServiceIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppEngineServiceIamPolicyResult(
            app_id=self.app_id,
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data,
            project=self.project,
            service=self.service)


def get_app_engine_service_iam_policy(app_id: Optional[_builtins.str] = None,
                                      project: Optional[_builtins.str] = None,
                                      service: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppEngineServiceIamPolicyResult:
    """
    Retrieves the current IAM policy data for appengineservice

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.iap.get_app_engine_service_iam_policy(project=version["project"],
        app_id=version["project"],
        service=version["service"])
    ```


    :param _builtins.str app_id: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str service: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['project'] = project
    __args__['service'] = service
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:iap/getAppEngineServiceIamPolicy:getAppEngineServiceIamPolicy', __args__, opts=opts, typ=GetAppEngineServiceIamPolicyResult).value

    return AwaitableGetAppEngineServiceIamPolicyResult(
        app_id=pulumi.get(__ret__, 'app_id'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        service=pulumi.get(__ret__, 'service'))
def get_app_engine_service_iam_policy_output(app_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             service: Optional[pulumi.Input[_builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppEngineServiceIamPolicyResult]:
    """
    Retrieves the current IAM policy data for appengineservice

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.iap.get_app_engine_service_iam_policy(project=version["project"],
        app_id=version["project"],
        service=version["service"])
    ```


    :param _builtins.str app_id: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str service: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['project'] = project
    __args__['service'] = service
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:iap/getAppEngineServiceIamPolicy:getAppEngineServiceIamPolicy', __args__, opts=opts, typ=GetAppEngineServiceIamPolicyResult)
    return __ret__.apply(lambda __response__: GetAppEngineServiceIamPolicyResult(
        app_id=pulumi.get(__response__, 'app_id'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project'),
        service=pulumi.get(__response__, 'service')))
