# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKeyHandleResult',
    'AwaitableGetKeyHandleResult',
    'get_key_handle',
    'get_key_handle_output',
]

@pulumi.output_type
class GetKeyHandleResult:
    """
    A collection of values returned by getKeyHandle.
    """
    def __init__(__self__, id=None, kms_key=None, location=None, name=None, project=None, resource_type_selector=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key and not isinstance(kms_key, str):
            raise TypeError("Expected argument 'kms_key' to be a str")
        pulumi.set(__self__, "kms_key", kms_key)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if resource_type_selector and not isinstance(resource_type_selector, str):
            raise TypeError("Expected argument 'resource_type_selector' to be a str")
        pulumi.set(__self__, "resource_type_selector", resource_type_selector)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> _builtins.str:
        """
        The identifier of the KMS Key created for the KeyHandle. Its format is `projects/{projectId}/locations/{location}/keyRings/{keyRingName}/cryptoKeys/{cryptoKeyName}`.
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The location of the KMS Key and KeyHandle.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        """
        The identifier of the project where KMS KeyHandle is created.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="resourceTypeSelector")
    def resource_type_selector(self) -> _builtins.str:
        """
        Indicates the resource type that the resulting CryptoKey is meant to protect, e.g. {SERVICE}.googleapis.com/{TYPE}. See documentation for supported resource types.
        """
        return pulumi.get(self, "resource_type_selector")


class AwaitableGetKeyHandleResult(GetKeyHandleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyHandleResult(
            id=self.id,
            kms_key=self.kms_key,
            location=self.location,
            name=self.name,
            project=self.project,
            resource_type_selector=self.resource_type_selector)


def get_key_handle(location: Optional[_builtins.str] = None,
                   name: Optional[_builtins.str] = None,
                   project: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyHandleResult:
    """
    Provides access to Google Cloud Platform KMS KeyHandle. A key handle is a Cloud KMS resource that helps you safely span the separation of duties to create new Cloud KMS keys for CMEK using Autokey.

    For more information see
    [the official documentation](https://cloud.google.com/kms/docs/resource-hierarchy#key_handles)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyHandles).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_handle = gcp.kms.get_key_handle(name="eed58b7b-20ad-4da8-ad85-ba78a0d5ab87",
        location="us-central1")
    ```


    :param _builtins.str location: The Google Cloud Platform location for the KeyHandle.
           A full list of valid locations can be found by running `gcloud kms locations list`.
           
           - - -
    :param _builtins.str name: The KeyHandle's name.
           A KeyHandle name must exist within the provided location and must be valid UUID.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:kms/getKeyHandle:getKeyHandle', __args__, opts=opts, typ=GetKeyHandleResult).value

    return AwaitableGetKeyHandleResult(
        id=pulumi.get(__ret__, 'id'),
        kms_key=pulumi.get(__ret__, 'kms_key'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        resource_type_selector=pulumi.get(__ret__, 'resource_type_selector'))
def get_key_handle_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                          name: Optional[pulumi.Input[_builtins.str]] = None,
                          project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyHandleResult]:
    """
    Provides access to Google Cloud Platform KMS KeyHandle. A key handle is a Cloud KMS resource that helps you safely span the separation of duties to create new Cloud KMS keys for CMEK using Autokey.

    For more information see
    [the official documentation](https://cloud.google.com/kms/docs/resource-hierarchy#key_handles)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyHandles).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_handle = gcp.kms.get_key_handle(name="eed58b7b-20ad-4da8-ad85-ba78a0d5ab87",
        location="us-central1")
    ```


    :param _builtins.str location: The Google Cloud Platform location for the KeyHandle.
           A full list of valid locations can be found by running `gcloud kms locations list`.
           
           - - -
    :param _builtins.str name: The KeyHandle's name.
           A KeyHandle name must exist within the provided location and must be valid UUID.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:kms/getKeyHandle:getKeyHandle', __args__, opts=opts, typ=GetKeyHandleResult)
    return __ret__.apply(lambda __response__: GetKeyHandleResult(
        id=pulumi.get(__response__, 'id'),
        kms_key=pulumi.get(__response__, 'kms_key'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        resource_type_selector=pulumi.get(__response__, 'resource_type_selector')))
