# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetKeyRingsResult',
    'AwaitableGetKeyRingsResult',
    'get_key_rings',
    'get_key_rings_output',
]

@pulumi.output_type
class GetKeyRingsResult:
    """
    A collection of values returned by getKeyRings.
    """
    def __init__(__self__, filter=None, id=None, key_rings=None, location=None, project=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_rings and not isinstance(key_rings, list):
            raise TypeError("Expected argument 'key_rings' to be a list")
        pulumi.set(__self__, "key_rings", key_rings)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyRings")
    def key_rings(self) -> Sequence['outputs.GetKeyRingsKeyRingResult']:
        """
        A list of all the retrieved key rings from the provided location. This list is influenced by the provided filter argument.
        """
        return pulumi.get(self, "key_rings")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")


class AwaitableGetKeyRingsResult(GetKeyRingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyRingsResult(
            filter=self.filter,
            id=self.id,
            key_rings=self.key_rings,
            location=self.location,
            project=self.project)


def get_key_rings(filter: Optional[_builtins.str] = None,
                  location: Optional[_builtins.str] = None,
                  project: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyRingsResult:
    """
    Provides access to all Google Cloud Platform KMS CryptoKeyRings in a set location. For more information see
    [the official documentation](https://cloud.google.com/kms/docs/resource-hierarchy#key_rings)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings).

    A key ring organizes keys in a specific Google Cloud location and lets you manage access control on groups of keys. A key ring's name does not need to be unique across a Google Cloud project, but must be unique within a given location. After creation, a key ring cannot be deleted. Key rings don't incur any costs.


    :param _builtins.str filter: The filter argument is used to add a filter query parameter that limits which key rings are retrieved by the data source: ?filter={{filter}}. When no value is provided there is no filtering.
           
           Example filter values if filtering on name. Note: names take the form projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}.
           
           * `"name:my-key-"` will retrieve key rings that contain "my-key-" anywhere in their name.
           * `"name=projects/my-project/locations/global/keyRings/my-key-ring"` will only retrieve a key with that exact name.
           
           [See the documentation about using filters](https://cloud.google.com/kms/docs/sorting-and-filtering)
    :param _builtins.str location: The location that the underlying key ring resides in. e.g us-west1
    :param _builtins.str project: The Project ID of the project.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:kms/getKeyRings:getKeyRings', __args__, opts=opts, typ=GetKeyRingsResult).value

    return AwaitableGetKeyRingsResult(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        key_rings=pulumi.get(__ret__, 'key_rings'),
        location=pulumi.get(__ret__, 'location'),
        project=pulumi.get(__ret__, 'project'))
def get_key_rings_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         location: Optional[pulumi.Input[_builtins.str]] = None,
                         project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyRingsResult]:
    """
    Provides access to all Google Cloud Platform KMS CryptoKeyRings in a set location. For more information see
    [the official documentation](https://cloud.google.com/kms/docs/resource-hierarchy#key_rings)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings).

    A key ring organizes keys in a specific Google Cloud location and lets you manage access control on groups of keys. A key ring's name does not need to be unique across a Google Cloud project, but must be unique within a given location. After creation, a key ring cannot be deleted. Key rings don't incur any costs.


    :param _builtins.str filter: The filter argument is used to add a filter query parameter that limits which key rings are retrieved by the data source: ?filter={{filter}}. When no value is provided there is no filtering.
           
           Example filter values if filtering on name. Note: names take the form projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}.
           
           * `"name:my-key-"` will retrieve key rings that contain "my-key-" anywhere in their name.
           * `"name=projects/my-project/locations/global/keyRings/my-key-ring"` will only retrieve a key with that exact name.
           
           [See the documentation about using filters](https://cloud.google.com/kms/docs/sorting-and-filtering)
    :param _builtins.str location: The location that the underlying key ring resides in. e.g us-west1
    :param _builtins.str project: The Project ID of the project.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:kms/getKeyRings:getKeyRings', __args__, opts=opts, typ=GetKeyRingsResult)
    return __ret__.apply(lambda __response__: GetKeyRingsResult(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        key_rings=pulumi.get(__response__, 'key_rings'),
        location=pulumi.get(__response__, 'location'),
        project=pulumi.get(__response__, 'project')))
