# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectBucketConfigArgs', 'ProjectBucketConfig']

@pulumi.input_type
class ProjectBucketConfigArgs:
    def __init__(__self__, *,
                 bucket_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 cmek_settings: Optional[pulumi.Input['ProjectBucketConfigCmekSettingsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_analytics: Optional[pulumi.Input[_builtins.bool]] = None,
                 index_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectBucketConfigIndexConfigArgs']]]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ProjectBucketConfig resource.
        :param pulumi.Input[_builtins.str] bucket_id: The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        :param pulumi.Input[_builtins.str] location: The location of the bucket.
        :param pulumi.Input[_builtins.str] project: The parent resource that contains the logging bucket.
        :param pulumi.Input['ProjectBucketConfigCmekSettingsArgs'] cmek_settings: The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by updating the log bucket. Changing the KMS key is allowed. Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Describes this bucket.
        :param pulumi.Input[_builtins.bool] enable_analytics: Whether or not Log Analytics is enabled. Logs for buckets with Log Analytics enabled can be queried in the **Log Analytics** page using SQL queries. Cannot be disabled once enabled.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectBucketConfigIndexConfigArgs']]] index_configs: A list of indexed fields and related configuration data. Structure is documented below.
        :param pulumi.Input[_builtins.bool] locked: Whether the bucket is locked. The retention period on a locked bucket cannot be changed. Locked buckets may only be deleted if they are empty.
        :param pulumi.Input[_builtins.int] retention_days: Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
        """
        pulumi.set(__self__, "bucket_id", bucket_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "project", project)
        if cmek_settings is not None:
            pulumi.set(__self__, "cmek_settings", cmek_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_analytics is not None:
            pulumi.set(__self__, "enable_analytics", enable_analytics)
        if index_configs is not None:
            pulumi.set(__self__, "index_configs", index_configs)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @_builtins.property
    @pulumi.getter(name="bucketId")
    def bucket_id(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        """
        return pulumi.get(self, "bucket_id")

    @bucket_id.setter
    def bucket_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the bucket.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The parent resource that contains the logging bucket.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="cmekSettings")
    def cmek_settings(self) -> Optional[pulumi.Input['ProjectBucketConfigCmekSettingsArgs']]:
        """
        The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by updating the log bucket. Changing the KMS key is allowed. Structure is documented below.
        """
        return pulumi.get(self, "cmek_settings")

    @cmek_settings.setter
    def cmek_settings(self, value: Optional[pulumi.Input['ProjectBucketConfigCmekSettingsArgs']]):
        pulumi.set(self, "cmek_settings", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes this bucket.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableAnalytics")
    def enable_analytics(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not Log Analytics is enabled. Logs for buckets with Log Analytics enabled can be queried in the **Log Analytics** page using SQL queries. Cannot be disabled once enabled.
        """
        return pulumi.get(self, "enable_analytics")

    @enable_analytics.setter
    def enable_analytics(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_analytics", value)

    @_builtins.property
    @pulumi.getter(name="indexConfigs")
    def index_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectBucketConfigIndexConfigArgs']]]]:
        """
        A list of indexed fields and related configuration data. Structure is documented below.
        """
        return pulumi.get(self, "index_configs")

    @index_configs.setter
    def index_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectBucketConfigIndexConfigArgs']]]]):
        pulumi.set(self, "index_configs", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the bucket is locked. The retention period on a locked bucket cannot be changed. Locked buckets may only be deleted if they are empty.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)


@pulumi.input_type
class _ProjectBucketConfigState:
    def __init__(__self__, *,
                 bucket_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cmek_settings: Optional[pulumi.Input['ProjectBucketConfigCmekSettingsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_analytics: Optional[pulumi.Input[_builtins.bool]] = None,
                 index_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectBucketConfigIndexConfigArgs']]]] = None,
                 lifecycle_state: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ProjectBucketConfig resources.
        :param pulumi.Input[_builtins.str] bucket_id: The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        :param pulumi.Input['ProjectBucketConfigCmekSettingsArgs'] cmek_settings: The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by updating the log bucket. Changing the KMS key is allowed. Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Describes this bucket.
        :param pulumi.Input[_builtins.bool] enable_analytics: Whether or not Log Analytics is enabled. Logs for buckets with Log Analytics enabled can be queried in the **Log Analytics** page using SQL queries. Cannot be disabled once enabled.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectBucketConfigIndexConfigArgs']]] index_configs: A list of indexed fields and related configuration data. Structure is documented below.
        :param pulumi.Input[_builtins.str] lifecycle_state: The bucket's lifecycle such as active or deleted. See [LifecycleState](https://cloud.google.com/logging/docs/reference/v2/rest/v2/billingAccounts.buckets#LogBucket.LifecycleState).
        :param pulumi.Input[_builtins.str] location: The location of the bucket.
        :param pulumi.Input[_builtins.bool] locked: Whether the bucket is locked. The retention period on a locked bucket cannot be changed. Locked buckets may only be deleted if they are empty.
        :param pulumi.Input[_builtins.str] name: The resource name of the bucket. For example: "projects/my-project-id/locations/my-location/buckets/my-bucket-id"
        :param pulumi.Input[_builtins.str] project: The parent resource that contains the logging bucket.
        :param pulumi.Input[_builtins.int] retention_days: Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
        """
        if bucket_id is not None:
            pulumi.set(__self__, "bucket_id", bucket_id)
        if cmek_settings is not None:
            pulumi.set(__self__, "cmek_settings", cmek_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_analytics is not None:
            pulumi.set(__self__, "enable_analytics", enable_analytics)
        if index_configs is not None:
            pulumi.set(__self__, "index_configs", index_configs)
        if lifecycle_state is not None:
            pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @_builtins.property
    @pulumi.getter(name="bucketId")
    def bucket_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        """
        return pulumi.get(self, "bucket_id")

    @bucket_id.setter
    def bucket_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_id", value)

    @_builtins.property
    @pulumi.getter(name="cmekSettings")
    def cmek_settings(self) -> Optional[pulumi.Input['ProjectBucketConfigCmekSettingsArgs']]:
        """
        The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by updating the log bucket. Changing the KMS key is allowed. Structure is documented below.
        """
        return pulumi.get(self, "cmek_settings")

    @cmek_settings.setter
    def cmek_settings(self, value: Optional[pulumi.Input['ProjectBucketConfigCmekSettingsArgs']]):
        pulumi.set(self, "cmek_settings", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes this bucket.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableAnalytics")
    def enable_analytics(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not Log Analytics is enabled. Logs for buckets with Log Analytics enabled can be queried in the **Log Analytics** page using SQL queries. Cannot be disabled once enabled.
        """
        return pulumi.get(self, "enable_analytics")

    @enable_analytics.setter
    def enable_analytics(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_analytics", value)

    @_builtins.property
    @pulumi.getter(name="indexConfigs")
    def index_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectBucketConfigIndexConfigArgs']]]]:
        """
        A list of indexed fields and related configuration data. Structure is documented below.
        """
        return pulumi.get(self, "index_configs")

    @index_configs.setter
    def index_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectBucketConfigIndexConfigArgs']]]]):
        pulumi.set(self, "index_configs", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bucket's lifecycle such as active or deleted. See [LifecycleState](https://cloud.google.com/logging/docs/reference/v2/rest/v2/billingAccounts.buckets#LogBucket.LifecycleState).
        """
        return pulumi.get(self, "lifecycle_state")

    @lifecycle_state.setter
    def lifecycle_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_state", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the bucket.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the bucket is locked. The retention period on a locked bucket cannot be changed. Locked buckets may only be deleted if they are empty.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the bucket. For example: "projects/my-project-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parent resource that contains the logging bucket.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)


@pulumi.type_token("gcp:logging/projectBucketConfig:ProjectBucketConfig")
class ProjectBucketConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cmek_settings: Optional[pulumi.Input[Union['ProjectBucketConfigCmekSettingsArgs', 'ProjectBucketConfigCmekSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_analytics: Optional[pulumi.Input[_builtins.bool]] = None,
                 index_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectBucketConfigIndexConfigArgs', 'ProjectBucketConfigIndexConfigArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a project-level logging bucket config. For more information see
        [the official logging documentation](https://cloud.google.com/logging/docs/) and
        [Storing Logs](https://cloud.google.com/logging/docs/storage).

        > **Note:** Logging buckets are automatically created for a given folder, project, organization, billingAccount and cannot be deleted. Creating a resource of this type will acquire and update the resource that already exists at the desired location. These buckets cannot be removed so deleting this resource will remove the bucket config from your state but will leave the logging bucket unchanged. The buckets that are currently automatically created are "_Default" and "_Required".

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.organizations.Project("default",
            project_id="your-project-id",
            name="your-project-id",
            org_id="123456789")
        basic = gcp.logging.ProjectBucketConfig("basic",
            project=default.project_id,
            location="global",
            retention_days=30,
            bucket_id="_Default")
        ```

        Create logging bucket with customId

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.logging.ProjectBucketConfig("basic",
            project="project_id",
            location="global",
            retention_days=30,
            bucket_id="custom-bucket")
        ```

        Create logging bucket with Log Analytics enabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        analytics_enabled_bucket = gcp.logging.ProjectBucketConfig("analytics-enabled-bucket",
            project="project_id",
            location="global",
            retention_days=30,
            enable_analytics=True,
            bucket_id="custom-bucket")
        ```

        Create logging bucket with customId and cmekSettings

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cmek_settings = gcp.logging.get_project_cmek_settings(project="project_id")
        keyring = gcp.kms.KeyRing("keyring",
            name="keyring-example",
            location="us-central1")
        key = gcp.kms.CryptoKey("key",
            name="crypto-key-example",
            key_ring=keyring.id,
            rotation_period="7776000s")
        crypto_key_binding = gcp.kms.CryptoKeyIAMBinding("crypto_key_binding",
            crypto_key_id=key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[f"serviceAccount:{cmek_settings.service_account_id}"])
        example_project_bucket_cmek_settings = gcp.logging.ProjectBucketConfig("example-project-bucket-cmek-settings",
            project="project_id",
            location="us-central1",
            retention_days=30,
            bucket_id="custom-bucket",
            cmek_settings={
                "kms_key_name": key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key_binding]))
        ```

        Create logging bucket with index configs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_project_bucket_index_configs = gcp.logging.ProjectBucketConfig("example-project-bucket-index-configs",
            project="project_id",
            location="global",
            retention_days=30,
            bucket_id="custom-bucket",
            index_configs=[{
                "field_path": "jsonPayload.request.status",
                "type": "INDEX_TYPE_STRING",
            }])
        ```

        ## Import

        This resource can be imported using the following format:

        * `projects/{{project}}/locations/{{location}}/buckets/{{bucket_id}}`

        When using the `pulumi import` command, this resource can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/projectBucketConfig:ProjectBucketConfig default projects/{{project}}/locations/{{location}}/buckets/{{bucket_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket_id: The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        :param pulumi.Input[Union['ProjectBucketConfigCmekSettingsArgs', 'ProjectBucketConfigCmekSettingsArgsDict']] cmek_settings: The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by updating the log bucket. Changing the KMS key is allowed. Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Describes this bucket.
        :param pulumi.Input[_builtins.bool] enable_analytics: Whether or not Log Analytics is enabled. Logs for buckets with Log Analytics enabled can be queried in the **Log Analytics** page using SQL queries. Cannot be disabled once enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectBucketConfigIndexConfigArgs', 'ProjectBucketConfigIndexConfigArgsDict']]]] index_configs: A list of indexed fields and related configuration data. Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location of the bucket.
        :param pulumi.Input[_builtins.bool] locked: Whether the bucket is locked. The retention period on a locked bucket cannot be changed. Locked buckets may only be deleted if they are empty.
        :param pulumi.Input[_builtins.str] project: The parent resource that contains the logging bucket.
        :param pulumi.Input[_builtins.int] retention_days: Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectBucketConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a project-level logging bucket config. For more information see
        [the official logging documentation](https://cloud.google.com/logging/docs/) and
        [Storing Logs](https://cloud.google.com/logging/docs/storage).

        > **Note:** Logging buckets are automatically created for a given folder, project, organization, billingAccount and cannot be deleted. Creating a resource of this type will acquire and update the resource that already exists at the desired location. These buckets cannot be removed so deleting this resource will remove the bucket config from your state but will leave the logging bucket unchanged. The buckets that are currently automatically created are "_Default" and "_Required".

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.organizations.Project("default",
            project_id="your-project-id",
            name="your-project-id",
            org_id="123456789")
        basic = gcp.logging.ProjectBucketConfig("basic",
            project=default.project_id,
            location="global",
            retention_days=30,
            bucket_id="_Default")
        ```

        Create logging bucket with customId

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.logging.ProjectBucketConfig("basic",
            project="project_id",
            location="global",
            retention_days=30,
            bucket_id="custom-bucket")
        ```

        Create logging bucket with Log Analytics enabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        analytics_enabled_bucket = gcp.logging.ProjectBucketConfig("analytics-enabled-bucket",
            project="project_id",
            location="global",
            retention_days=30,
            enable_analytics=True,
            bucket_id="custom-bucket")
        ```

        Create logging bucket with customId and cmekSettings

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cmek_settings = gcp.logging.get_project_cmek_settings(project="project_id")
        keyring = gcp.kms.KeyRing("keyring",
            name="keyring-example",
            location="us-central1")
        key = gcp.kms.CryptoKey("key",
            name="crypto-key-example",
            key_ring=keyring.id,
            rotation_period="7776000s")
        crypto_key_binding = gcp.kms.CryptoKeyIAMBinding("crypto_key_binding",
            crypto_key_id=key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[f"serviceAccount:{cmek_settings.service_account_id}"])
        example_project_bucket_cmek_settings = gcp.logging.ProjectBucketConfig("example-project-bucket-cmek-settings",
            project="project_id",
            location="us-central1",
            retention_days=30,
            bucket_id="custom-bucket",
            cmek_settings={
                "kms_key_name": key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key_binding]))
        ```

        Create logging bucket with index configs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_project_bucket_index_configs = gcp.logging.ProjectBucketConfig("example-project-bucket-index-configs",
            project="project_id",
            location="global",
            retention_days=30,
            bucket_id="custom-bucket",
            index_configs=[{
                "field_path": "jsonPayload.request.status",
                "type": "INDEX_TYPE_STRING",
            }])
        ```

        ## Import

        This resource can be imported using the following format:

        * `projects/{{project}}/locations/{{location}}/buckets/{{bucket_id}}`

        When using the `pulumi import` command, this resource can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/projectBucketConfig:ProjectBucketConfig default projects/{{project}}/locations/{{location}}/buckets/{{bucket_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ProjectBucketConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectBucketConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cmek_settings: Optional[pulumi.Input[Union['ProjectBucketConfigCmekSettingsArgs', 'ProjectBucketConfigCmekSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_analytics: Optional[pulumi.Input[_builtins.bool]] = None,
                 index_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectBucketConfigIndexConfigArgs', 'ProjectBucketConfigIndexConfigArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectBucketConfigArgs.__new__(ProjectBucketConfigArgs)

            if bucket_id is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_id'")
            __props__.__dict__["bucket_id"] = bucket_id
            __props__.__dict__["cmek_settings"] = cmek_settings
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_analytics"] = enable_analytics
            __props__.__dict__["index_configs"] = index_configs
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["locked"] = locked
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["retention_days"] = retention_days
            __props__.__dict__["lifecycle_state"] = None
            __props__.__dict__["name"] = None
        super(ProjectBucketConfig, __self__).__init__(
            'gcp:logging/projectBucketConfig:ProjectBucketConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket_id: Optional[pulumi.Input[_builtins.str]] = None,
            cmek_settings: Optional[pulumi.Input[Union['ProjectBucketConfigCmekSettingsArgs', 'ProjectBucketConfigCmekSettingsArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_analytics: Optional[pulumi.Input[_builtins.bool]] = None,
            index_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectBucketConfigIndexConfigArgs', 'ProjectBucketConfigIndexConfigArgsDict']]]]] = None,
            lifecycle_state: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            locked: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            retention_days: Optional[pulumi.Input[_builtins.int]] = None) -> 'ProjectBucketConfig':
        """
        Get an existing ProjectBucketConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket_id: The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        :param pulumi.Input[Union['ProjectBucketConfigCmekSettingsArgs', 'ProjectBucketConfigCmekSettingsArgsDict']] cmek_settings: The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by updating the log bucket. Changing the KMS key is allowed. Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Describes this bucket.
        :param pulumi.Input[_builtins.bool] enable_analytics: Whether or not Log Analytics is enabled. Logs for buckets with Log Analytics enabled can be queried in the **Log Analytics** page using SQL queries. Cannot be disabled once enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectBucketConfigIndexConfigArgs', 'ProjectBucketConfigIndexConfigArgsDict']]]] index_configs: A list of indexed fields and related configuration data. Structure is documented below.
        :param pulumi.Input[_builtins.str] lifecycle_state: The bucket's lifecycle such as active or deleted. See [LifecycleState](https://cloud.google.com/logging/docs/reference/v2/rest/v2/billingAccounts.buckets#LogBucket.LifecycleState).
        :param pulumi.Input[_builtins.str] location: The location of the bucket.
        :param pulumi.Input[_builtins.bool] locked: Whether the bucket is locked. The retention period on a locked bucket cannot be changed. Locked buckets may only be deleted if they are empty.
        :param pulumi.Input[_builtins.str] name: The resource name of the bucket. For example: "projects/my-project-id/locations/my-location/buckets/my-bucket-id"
        :param pulumi.Input[_builtins.str] project: The parent resource that contains the logging bucket.
        :param pulumi.Input[_builtins.int] retention_days: Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectBucketConfigState.__new__(_ProjectBucketConfigState)

        __props__.__dict__["bucket_id"] = bucket_id
        __props__.__dict__["cmek_settings"] = cmek_settings
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_analytics"] = enable_analytics
        __props__.__dict__["index_configs"] = index_configs
        __props__.__dict__["lifecycle_state"] = lifecycle_state
        __props__.__dict__["location"] = location
        __props__.__dict__["locked"] = locked
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["retention_days"] = retention_days
        return ProjectBucketConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bucketId")
    def bucket_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        """
        return pulumi.get(self, "bucket_id")

    @_builtins.property
    @pulumi.getter(name="cmekSettings")
    def cmek_settings(self) -> pulumi.Output[Optional['outputs.ProjectBucketConfigCmekSettings']]:
        """
        The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by updating the log bucket. Changing the KMS key is allowed. Structure is documented below.
        """
        return pulumi.get(self, "cmek_settings")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Describes this bucket.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableAnalytics")
    def enable_analytics(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not Log Analytics is enabled. Logs for buckets with Log Analytics enabled can be queried in the **Log Analytics** page using SQL queries. Cannot be disabled once enabled.
        """
        return pulumi.get(self, "enable_analytics")

    @_builtins.property
    @pulumi.getter(name="indexConfigs")
    def index_configs(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectBucketConfigIndexConfig']]]:
        """
        A list of indexed fields and related configuration data. Structure is documented below.
        """
        return pulumi.get(self, "index_configs")

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> pulumi.Output[_builtins.str]:
        """
        The bucket's lifecycle such as active or deleted. See [LifecycleState](https://cloud.google.com/logging/docs/reference/v2/rest/v2/billingAccounts.buckets#LogBucket.LifecycleState).
        """
        return pulumi.get(self, "lifecycle_state")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the bucket.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def locked(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the bucket is locked. The retention period on a locked bucket cannot be changed. Locked buckets may only be deleted if they are empty.
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the bucket. For example: "projects/my-project-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The parent resource that contains the logging bucket.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
        """
        return pulumi.get(self, "retention_days")

