# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceAutomatedBackupConfig',
    'InstanceAutomatedBackupConfigFixedFrequencySchedule',
    'InstanceAutomatedBackupConfigFixedFrequencyScheduleStartTime',
    'InstanceCrossInstanceReplicationConfig',
    'InstanceCrossInstanceReplicationConfigMembership',
    'InstanceCrossInstanceReplicationConfigMembershipPrimaryInstance',
    'InstanceCrossInstanceReplicationConfigMembershipSecondaryInstance',
    'InstanceCrossInstanceReplicationConfigPrimaryInstance',
    'InstanceCrossInstanceReplicationConfigSecondaryInstance',
    'InstanceDesiredAutoCreatedEndpoint',
    'InstanceDesiredPscAutoConnection',
    'InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpoint',
    'InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnection',
    'InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnectionPscConnection',
    'InstanceDiscoveryEndpoint',
    'InstanceEndpoint',
    'InstanceEndpointConnection',
    'InstanceEndpointConnectionPscAutoConnection',
    'InstanceGcsSource',
    'InstanceMaintenancePolicy',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindow',
    'InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime',
    'InstanceMaintenanceSchedule',
    'InstanceManagedBackupSource',
    'InstanceManagedServerCa',
    'InstanceManagedServerCaCaCert',
    'InstanceNodeConfig',
    'InstancePersistenceConfig',
    'InstancePersistenceConfigAofConfig',
    'InstancePersistenceConfigRdbConfig',
    'InstancePscAttachmentDetail',
    'InstancePscAutoConnection',
    'InstanceStateInfo',
    'InstanceStateInfoUpdateInfo',
    'InstanceZoneDistributionConfig',
    'GetInstanceAutomatedBackupConfigResult',
    'GetInstanceAutomatedBackupConfigFixedFrequencyScheduleResult',
    'GetInstanceAutomatedBackupConfigFixedFrequencyScheduleStartTimeResult',
    'GetInstanceCrossInstanceReplicationConfigResult',
    'GetInstanceCrossInstanceReplicationConfigMembershipResult',
    'GetInstanceCrossInstanceReplicationConfigMembershipPrimaryInstanceResult',
    'GetInstanceCrossInstanceReplicationConfigMembershipSecondaryInstanceResult',
    'GetInstanceCrossInstanceReplicationConfigPrimaryInstanceResult',
    'GetInstanceCrossInstanceReplicationConfigSecondaryInstanceResult',
    'GetInstanceDesiredAutoCreatedEndpointResult',
    'GetInstanceDesiredPscAutoConnectionResult',
    'GetInstanceDiscoveryEndpointResult',
    'GetInstanceEndpointResult',
    'GetInstanceEndpointConnectionResult',
    'GetInstanceEndpointConnectionPscAutoConnectionResult',
    'GetInstanceGcsSourceResult',
    'GetInstanceMaintenancePolicyResult',
    'GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult',
    'GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult',
    'GetInstanceMaintenanceScheduleResult',
    'GetInstanceManagedBackupSourceResult',
    'GetInstanceManagedServerCaResult',
    'GetInstanceManagedServerCaCaCertResult',
    'GetInstanceNodeConfigResult',
    'GetInstancePersistenceConfigResult',
    'GetInstancePersistenceConfigAofConfigResult',
    'GetInstancePersistenceConfigRdbConfigResult',
    'GetInstancePscAttachmentDetailResult',
    'GetInstancePscAutoConnectionResult',
    'GetInstanceStateInfoResult',
    'GetInstanceStateInfoUpdateInfoResult',
    'GetInstanceZoneDistributionConfigResult',
]

@pulumi.output_type
class InstanceAutomatedBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedFrequencySchedule":
            suggest = "fixed_frequency_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAutomatedBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAutomatedBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAutomatedBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_frequency_schedule: 'outputs.InstanceAutomatedBackupConfigFixedFrequencySchedule',
                 retention: _builtins.str):
        """
        :param 'InstanceAutomatedBackupConfigFixedFrequencyScheduleArgs' fixed_frequency_schedule: Trigger automated backups at a fixed frequency.
               Structure is documented below.
        :param _builtins.str retention: How long to keep automated backups before the backups are deleted.
               The value should be between 1 day and 365 days. If not specified, the default value is 35 days.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s". The default_value is "3024000s"
        """
        pulumi.set(__self__, "fixed_frequency_schedule", fixed_frequency_schedule)
        pulumi.set(__self__, "retention", retention)

    @_builtins.property
    @pulumi.getter(name="fixedFrequencySchedule")
    def fixed_frequency_schedule(self) -> 'outputs.InstanceAutomatedBackupConfigFixedFrequencySchedule':
        """
        Trigger automated backups at a fixed frequency.
        Structure is documented below.
        """
        return pulumi.get(self, "fixed_frequency_schedule")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.str:
        """
        How long to keep automated backups before the backups are deleted.
        The value should be between 1 day and 365 days. If not specified, the default value is 35 days.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s". The default_value is "3024000s"
        """
        return pulumi.get(self, "retention")


@pulumi.output_type
class InstanceAutomatedBackupConfigFixedFrequencySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAutomatedBackupConfigFixedFrequencySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAutomatedBackupConfigFixedFrequencySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAutomatedBackupConfigFixedFrequencySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: 'outputs.InstanceAutomatedBackupConfigFixedFrequencyScheduleStartTime'):
        """
        :param 'InstanceAutomatedBackupConfigFixedFrequencyScheduleStartTimeArgs' start_time: The start time of every automated backup in UTC.
               It must be set to the start of an hour. This field is required.
               Structure is documented below.
        """
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.InstanceAutomatedBackupConfigFixedFrequencyScheduleStartTime':
        """
        The start time of every automated backup in UTC.
        It must be set to the start of an hour. This field is required.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class InstanceAutomatedBackupConfigFixedFrequencyScheduleStartTime(dict):
    def __init__(__self__, *,
                 hours: _builtins.int):
        """
        :param _builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        pulumi.set(__self__, "hours", hours)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> _builtins.int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")


@pulumi.output_type
class InstanceCrossInstanceReplicationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceRole":
            suggest = "instance_role"
        elif key == "primaryInstance":
            suggest = "primary_instance"
        elif key == "secondaryInstances":
            suggest = "secondary_instances"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceCrossInstanceReplicationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceCrossInstanceReplicationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceCrossInstanceReplicationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_role: Optional[_builtins.str] = None,
                 memberships: Optional[Sequence['outputs.InstanceCrossInstanceReplicationConfigMembership']] = None,
                 primary_instance: Optional['outputs.InstanceCrossInstanceReplicationConfigPrimaryInstance'] = None,
                 secondary_instances: Optional[Sequence['outputs.InstanceCrossInstanceReplicationConfigSecondaryInstance']] = None,
                 update_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance_role: The instance role supports the following values:
               1. `INSTANCE_ROLE_UNSPECIFIED`: This is an independent instance that has never participated in cross instance replication. It allows both reads and writes.
               2. `NONE`: This is an independent instance that previously participated in cross instance replication(either as a `PRIMARY` or `SECONDARY` cluster). It allows both reads and writes.
               3. `PRIMARY`: This instance serves as the replication source for secondary instance that are replicating from it. Any data written to it is automatically replicated to its secondary clusters. It allows both reads and writes.
               4. `SECONDARY`: This instance replicates data from the primary instance. It allows only reads.
               Possible values are: `INSTANCE_ROLE_UNSPECIFIED`, `NONE`, `PRIMARY`, `SECONDARY`.
        :param Sequence['InstanceCrossInstanceReplicationConfigMembershipArgs'] memberships: (Output)
               An output only view of all the member instance participating in cross instance replication. This field is populated for all the member clusters irrespective of their cluster role.
               Structure is documented below.
        :param 'InstanceCrossInstanceReplicationConfigPrimaryInstanceArgs' primary_instance: This field is only set for a secondary instance. Details of the primary instance that is used as the replication source for this secondary instance. This is allowed to be set only for clusters whose cluster role is of type `SECONDARY`.
               Structure is documented below.
        :param Sequence['InstanceCrossInstanceReplicationConfigSecondaryInstanceArgs'] secondary_instances: List of secondary instances that are replicating from this primary cluster. This is allowed to be set only for instances whose cluster role is of type `PRIMARY`.
               Structure is documented below.
        :param _builtins.str update_time: (Output)
               The last time cross instance replication config was updated.
        """
        if instance_role is not None:
            pulumi.set(__self__, "instance_role", instance_role)
        if memberships is not None:
            pulumi.set(__self__, "memberships", memberships)
        if primary_instance is not None:
            pulumi.set(__self__, "primary_instance", primary_instance)
        if secondary_instances is not None:
            pulumi.set(__self__, "secondary_instances", secondary_instances)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="instanceRole")
    def instance_role(self) -> Optional[_builtins.str]:
        """
        The instance role supports the following values:
        1. `INSTANCE_ROLE_UNSPECIFIED`: This is an independent instance that has never participated in cross instance replication. It allows both reads and writes.
        2. `NONE`: This is an independent instance that previously participated in cross instance replication(either as a `PRIMARY` or `SECONDARY` cluster). It allows both reads and writes.
        3. `PRIMARY`: This instance serves as the replication source for secondary instance that are replicating from it. Any data written to it is automatically replicated to its secondary clusters. It allows both reads and writes.
        4. `SECONDARY`: This instance replicates data from the primary instance. It allows only reads.
        Possible values are: `INSTANCE_ROLE_UNSPECIFIED`, `NONE`, `PRIMARY`, `SECONDARY`.
        """
        return pulumi.get(self, "instance_role")

    @_builtins.property
    @pulumi.getter
    def memberships(self) -> Optional[Sequence['outputs.InstanceCrossInstanceReplicationConfigMembership']]:
        """
        (Output)
        An output only view of all the member instance participating in cross instance replication. This field is populated for all the member clusters irrespective of their cluster role.
        Structure is documented below.
        """
        return pulumi.get(self, "memberships")

    @_builtins.property
    @pulumi.getter(name="primaryInstance")
    def primary_instance(self) -> Optional['outputs.InstanceCrossInstanceReplicationConfigPrimaryInstance']:
        """
        This field is only set for a secondary instance. Details of the primary instance that is used as the replication source for this secondary instance. This is allowed to be set only for clusters whose cluster role is of type `SECONDARY`.
        Structure is documented below.
        """
        return pulumi.get(self, "primary_instance")

    @_builtins.property
    @pulumi.getter(name="secondaryInstances")
    def secondary_instances(self) -> Optional[Sequence['outputs.InstanceCrossInstanceReplicationConfigSecondaryInstance']]:
        """
        List of secondary instances that are replicating from this primary cluster. This is allowed to be set only for instances whose cluster role is of type `PRIMARY`.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_instances")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The last time cross instance replication config was updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class InstanceCrossInstanceReplicationConfigMembership(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryInstances":
            suggest = "primary_instances"
        elif key == "secondaryInstances":
            suggest = "secondary_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceCrossInstanceReplicationConfigMembership. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceCrossInstanceReplicationConfigMembership.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceCrossInstanceReplicationConfigMembership.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_instances: Optional[Sequence['outputs.InstanceCrossInstanceReplicationConfigMembershipPrimaryInstance']] = None,
                 secondary_instances: Optional[Sequence['outputs.InstanceCrossInstanceReplicationConfigMembershipSecondaryInstance']] = None):
        """
        :param Sequence['InstanceCrossInstanceReplicationConfigMembershipPrimaryInstanceArgs'] primary_instances: Details of the primary instance that is used as the replication source for all the secondary instances.
        :param Sequence['InstanceCrossInstanceReplicationConfigMembershipSecondaryInstanceArgs'] secondary_instances: List of secondary instances that are replicating from the primary instance.
        """
        if primary_instances is not None:
            pulumi.set(__self__, "primary_instances", primary_instances)
        if secondary_instances is not None:
            pulumi.set(__self__, "secondary_instances", secondary_instances)

    @_builtins.property
    @pulumi.getter(name="primaryInstances")
    def primary_instances(self) -> Optional[Sequence['outputs.InstanceCrossInstanceReplicationConfigMembershipPrimaryInstance']]:
        """
        Details of the primary instance that is used as the replication source for all the secondary instances.
        """
        return pulumi.get(self, "primary_instances")

    @_builtins.property
    @pulumi.getter(name="secondaryInstances")
    def secondary_instances(self) -> Optional[Sequence['outputs.InstanceCrossInstanceReplicationConfigMembershipSecondaryInstance']]:
        """
        List of secondary instances that are replicating from the primary instance.
        """
        return pulumi.get(self, "secondary_instances")


@pulumi.output_type
class InstanceCrossInstanceReplicationConfigMembershipPrimaryInstance(dict):
    def __init__(__self__, *,
                 instance: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance: The full resource path of the primary instance in the format: projects/{project}/locations/{region}/instances/{instance-id}
        :param _builtins.str uid: (Output)
               The unique id of the primary instance.
        """
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[_builtins.str]:
        """
        The full resource path of the primary instance in the format: projects/{project}/locations/{region}/instances/{instance-id}
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        (Output)
        The unique id of the primary instance.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class InstanceCrossInstanceReplicationConfigMembershipSecondaryInstance(dict):
    def __init__(__self__, *,
                 instance: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance: The full resource path of the secondary instance in the format: projects/{project}/locations/{region}/instance/{instance-id}
        :param _builtins.str uid: Output only. System assigned, unique identifier for the instance.
        """
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[_builtins.str]:
        """
        The full resource path of the secondary instance in the format: projects/{project}/locations/{region}/instance/{instance-id}
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        Output only. System assigned, unique identifier for the instance.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class InstanceCrossInstanceReplicationConfigPrimaryInstance(dict):
    def __init__(__self__, *,
                 instance: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance: The full resource path of the primary instance in the format: projects/{project}/locations/{region}/instances/{instance-id}
        :param _builtins.str uid: (Output)
               The unique id of the primary instance.
        """
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[_builtins.str]:
        """
        The full resource path of the primary instance in the format: projects/{project}/locations/{region}/instances/{instance-id}
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        (Output)
        The unique id of the primary instance.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class InstanceCrossInstanceReplicationConfigSecondaryInstance(dict):
    def __init__(__self__, *,
                 instance: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance: (Output)
               The full resource path of the secondary instance in the format: projects/{project}/locations/{region}/instance/{instance-id}
        :param _builtins.str uid: (Output)
               The unique id of the secondary instance.
        """
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[_builtins.str]:
        """
        (Output)
        The full resource path of the secondary instance in the format: projects/{project}/locations/{region}/instance/{instance-id}
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        (Output)
        The unique id of the secondary instance.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class InstanceDesiredAutoCreatedEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDesiredAutoCreatedEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDesiredAutoCreatedEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDesiredAutoCreatedEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network: _builtins.str,
                 project_id: _builtins.str):
        """
        :param _builtins.str network: (Output)
               Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param _builtins.str project_id: (Output)
               Output only. The consumer project_id where the forwarding rule is created from.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        (Output)
        Output only. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class InstanceDesiredPscAutoConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDesiredPscAutoConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDesiredPscAutoConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDesiredPscAutoConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network: _builtins.str,
                 project_id: _builtins.str):
        """
        :param _builtins.str network: (Output)
               Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param _builtins.str project_id: (Output)
               Output only. The consumer project_id where the forwarding rule is created from.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        (Output)
        Output only. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpoint(dict):
    def __init__(__self__, *,
                 connections: Optional[Sequence['outputs.InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnection']] = None):
        """
        :param Sequence['InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnectionArgs'] connections: Structure is documented below.
        """
        if connections is not None:
            pulumi.set(__self__, "connections", connections)

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Optional[Sequence['outputs.InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnection']]:
        """
        Structure is documented below.
        """
        return pulumi.get(self, "connections")


@pulumi.output_type
class InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pscConnection":
            suggest = "psc_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 psc_connection: Optional['outputs.InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnectionPscConnection'] = None):
        """
        :param 'InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnectionPscConnectionArgs' psc_connection: Detailed information of a PSC connection that is created by the customer
               who owns the cluster.
               Structure is documented below.
        """
        if psc_connection is not None:
            pulumi.set(__self__, "psc_connection", psc_connection)

    @_builtins.property
    @pulumi.getter(name="pscConnection")
    def psc_connection(self) -> Optional['outputs.InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnectionPscConnection']:
        """
        Detailed information of a PSC connection that is created by the customer
        who owns the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_connection")


@pulumi.output_type
class InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnectionPscConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardingRule":
            suggest = "forwarding_rule"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "pscConnectionId":
            suggest = "psc_connection_id"
        elif key == "serviceAttachment":
            suggest = "service_attachment"
        elif key == "connectionType":
            suggest = "connection_type"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "pscConnectionStatus":
            suggest = "psc_connection_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnectionPscConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnectionPscConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDesiredUserCreatedEndpointsDesiredUserCreatedEndpointConnectionPscConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forwarding_rule: _builtins.str,
                 ip_address: _builtins.str,
                 network: _builtins.str,
                 psc_connection_id: _builtins.str,
                 service_attachment: _builtins.str,
                 connection_type: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 psc_connection_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str forwarding_rule: The URI of the consumer side forwarding rule.
               Format:
               projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        :param _builtins.str ip_address: The IP allocated on the consumer network for the PSC forwarding rule.
        :param _builtins.str network: The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param _builtins.str psc_connection_id: The PSC connection id of the forwarding rule connected to the
               service attachment.
        :param _builtins.str service_attachment: The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        :param _builtins.str connection_type: (Output)
               Output Only. Type of a PSC Connection.
               Possible values:
               CONNECTION_TYPE_DISCOVERY
               CONNECTION_TYPE_PRIMARY
               CONNECTION_TYPE_READER
        :param _builtins.str project_id: The consumer project_id where the forwarding rule is created from.
        :param _builtins.str psc_connection_status: (Output)
               Output Only. The status of the PSC connection: whether a connection exists and ACTIVE or it no longer exists.
               Possible values:
               ACTIVE
               NOT_FOUND
        """
        pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "psc_connection_id", psc_connection_id)
        pulumi.set(__self__, "service_attachment", service_attachment)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if psc_connection_status is not None:
            pulumi.set(__self__, "psc_connection_status", psc_connection_status)

    @_builtins.property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> _builtins.str:
        """
        The URI of the consumer side forwarding rule.
        Format:
        projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        """
        return pulumi.get(self, "forwarding_rule")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> _builtins.str:
        """
        The PSC connection id of the forwarding rule connected to the
        service attachment.
        """
        return pulumi.get(self, "psc_connection_id")

    @_builtins.property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> _builtins.str:
        """
        The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        return pulumi.get(self, "service_attachment")

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output Only. Type of a PSC Connection.
        Possible values:
        CONNECTION_TYPE_DISCOVERY
        CONNECTION_TYPE_PRIMARY
        CONNECTION_TYPE_READER
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pscConnectionStatus")
    def psc_connection_status(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output Only. The status of the PSC connection: whether a connection exists and ACTIVE or it no longer exists.
        Possible values:
        ACTIVE
        NOT_FOUND
        """
        return pulumi.get(self, "psc_connection_status")


@pulumi.output_type
class InstanceDiscoveryEndpoint(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 network: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str address: (Output)
               Output only. IP address of the exposed endpoint clients connect to.
        :param _builtins.str network: (Output)
               Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param _builtins.int port: (Output)
               Output only. Ports of the exposed endpoint.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. IP address of the exposed endpoint clients connect to.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        (Output)
        Output only. Ports of the exposed endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class InstanceEndpoint(dict):
    def __init__(__self__, *,
                 connections: Optional[Sequence['outputs.InstanceEndpointConnection']] = None):
        """
        :param Sequence['InstanceEndpointConnectionArgs'] connections: A group of PSC connections. They are created in the same VPC network, one for each service attachment in the cluster.
               Structure is documented below.
        """
        if connections is not None:
            pulumi.set(__self__, "connections", connections)

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Optional[Sequence['outputs.InstanceEndpointConnection']]:
        """
        A group of PSC connections. They are created in the same VPC network, one for each service attachment in the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "connections")


@pulumi.output_type
class InstanceEndpointConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pscAutoConnection":
            suggest = "psc_auto_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceEndpointConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceEndpointConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceEndpointConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 psc_auto_connection: Optional['outputs.InstanceEndpointConnectionPscAutoConnection'] = None):
        """
        :param 'InstanceEndpointConnectionPscAutoConnectionArgs' psc_auto_connection: Detailed information of a PSC connection that is created through service connectivity automation.
               Structure is documented below.
        """
        if psc_auto_connection is not None:
            pulumi.set(__self__, "psc_auto_connection", psc_auto_connection)

    @_builtins.property
    @pulumi.getter(name="pscAutoConnection")
    def psc_auto_connection(self) -> Optional['outputs.InstanceEndpointConnectionPscAutoConnection']:
        """
        Detailed information of a PSC connection that is created through service connectivity automation.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_auto_connection")


@pulumi.output_type
class InstanceEndpointConnectionPscAutoConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionType":
            suggest = "connection_type"
        elif key == "forwardingRule":
            suggest = "forwarding_rule"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "pscConnectionId":
            suggest = "psc_connection_id"
        elif key == "serviceAttachment":
            suggest = "service_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceEndpointConnectionPscAutoConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceEndpointConnectionPscAutoConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceEndpointConnectionPscAutoConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_type: Optional[_builtins.str] = None,
                 forwarding_rule: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 network: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 project_id: Optional[_builtins.str] = None,
                 psc_connection_id: Optional[_builtins.str] = None,
                 service_attachment: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_type: (Output)
               Output Only. Type of a PSC Connection.
               Possible values:
               CONNECTION_TYPE_DISCOVERY
               CONNECTION_TYPE_PRIMARY
               CONNECTION_TYPE_READER
        :param _builtins.str forwarding_rule: (Output)
               Output only. The URI of the consumer side forwarding rule.
               Format:
               projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        :param _builtins.str ip_address: (Output)
               Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        :param _builtins.str network: (Output)
               Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param _builtins.int port: (Output)
               Output only. Ports of the exposed endpoint.
        :param _builtins.str project_id: (Output)
               Output only. The consumer project_id where the forwarding rule is created from.
        :param _builtins.str psc_connection_id: (Output)
               Output only. The PSC connection id of the forwarding rule connected to the
               service attachment.
        :param _builtins.str service_attachment: (Output)
               Output only. The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if forwarding_rule is not None:
            pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if psc_connection_id is not None:
            pulumi.set(__self__, "psc_connection_id", psc_connection_id)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output Only. Type of a PSC Connection.
        Possible values:
        CONNECTION_TYPE_DISCOVERY
        CONNECTION_TYPE_PRIMARY
        CONNECTION_TYPE_READER
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The URI of the consumer side forwarding rule.
        Format:
        projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        """
        return pulumi.get(self, "forwarding_rule")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        (Output)
        Output only. Ports of the exposed endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The PSC connection id of the forwarding rule connected to the
        service attachment.
        """
        return pulumi.get(self, "psc_connection_id")

    @_builtins.property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class InstanceGcsSource(dict):
    def __init__(__self__, *,
                 uris: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] uris: URIs of the GCS objects to import.
               Example: gs://bucket1/object1, gs://bucket2/folder2/object2
        """
        pulumi.set(__self__, "uris", uris)

    @_builtins.property
    @pulumi.getter
    def uris(self) -> Sequence[_builtins.str]:
        """
        URIs of the GCS objects to import.
        Example: gs://bucket1/object1, gs://bucket2/folder2/object2
        """
        return pulumi.get(self, "uris")


@pulumi.output_type
class InstanceMaintenancePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "updateTime":
            suggest = "update_time"
        elif key == "weeklyMaintenanceWindows":
            suggest = "weekly_maintenance_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenancePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenancePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenancePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: Optional[_builtins.str] = None,
                 update_time: Optional[_builtins.str] = None,
                 weekly_maintenance_windows: Optional[Sequence['outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindow']] = None):
        """
        :param _builtins.str create_time: (Output)
               The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param _builtins.str update_time: (Output)
               The time when the policy was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param Sequence['InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs'] weekly_maintenance_windows: Optional. Maintenance window that is applied to resources covered by this policy.
               Minimum 1. For the current version, the maximum number
               of weekly_window is expected to be one.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if weekly_maintenance_windows is not None:
            pulumi.set(__self__, "weekly_maintenance_windows", weekly_maintenance_windows)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The time when the policy was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="weeklyMaintenanceWindows")
    def weekly_maintenance_windows(self) -> Optional[Sequence['outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindow']]:
        """
        Optional. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number
        of weekly_window is expected to be one.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_maintenance_windows")


@pulumi.output_type
class InstanceMaintenancePolicyWeeklyMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenancePolicyWeeklyMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenancePolicyWeeklyMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenancePolicyWeeklyMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: _builtins.str,
                 start_time: 'outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime',
                 duration: Optional[_builtins.str] = None):
        """
        :param _builtins.str day: The day of week that maintenance updates occur.
               - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
               - MONDAY: Monday
               - TUESDAY: Tuesday
               - WEDNESDAY: Wednesday
               - THURSDAY: Thursday
               - FRIDAY: Friday
               - SATURDAY: Saturday
               - SUNDAY: Sunday
               Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param 'InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs' start_time: Start time of the window in UTC time.
               Structure is documented below.
        :param _builtins.str duration: (Output)
               Duration of the maintenance window.
               The current window is fixed at 1 hour.
               A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "start_time", start_time)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.str:
        """
        The day of week that maintenance updates occur.
        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday
        Possible values are: `DAY_OF_WEEK_UNSPECIFIED`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime':
        """
        Start time of the window in UTC time.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        (Output)
        Duration of the maintenance window.
        The current window is fixed at 1 hour.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime(dict):
    def __init__(__self__, *,
                 hours: Optional[_builtins.int] = None,
                 minutes: Optional[_builtins.int] = None,
                 nanos: Optional[_builtins.int] = None,
                 seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param _builtins.int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param _builtins.int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param _builtins.int seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
               An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> Optional[_builtins.int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> Optional[_builtins.int]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def nanos(self) -> Optional[_builtins.int]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @_builtins.property
    @pulumi.getter
    def seconds(self) -> Optional[_builtins.int]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class InstanceMaintenanceSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "scheduleDeadlineTime":
            suggest = "schedule_deadline_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenanceSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenanceSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenanceSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[_builtins.str] = None,
                 schedule_deadline_time: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str end_time: (Output)
               The end time of any upcoming scheduled maintenance for this cluster.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param _builtins.str schedule_deadline_time: (Output)
               The deadline that the maintenance schedule start time
               can not go beyond, including reschedule.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param _builtins.str start_time: (Output)
               The start time of any upcoming scheduled maintenance for this cluster.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if schedule_deadline_time is not None:
            pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The end time of any upcoming scheduled maintenance for this cluster.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The start time of any upcoming scheduled maintenance for this cluster.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class InstanceManagedBackupSource(dict):
    def __init__(__self__, *,
                 backup: _builtins.str):
        """
        :param _builtins.str backup: Example: `projects/{project}/locations/{location}/backupCollections/{collection}/backups/{backup}`.
        """
        pulumi.set(__self__, "backup", backup)

    @_builtins.property
    @pulumi.getter
    def backup(self) -> _builtins.str:
        """
        Example: `projects/{project}/locations/{location}/backupCollections/{collection}/backups/{backup}`.
        """
        return pulumi.get(self, "backup")


@pulumi.output_type
class InstanceManagedServerCa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCerts":
            suggest = "ca_certs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceManagedServerCa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceManagedServerCa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceManagedServerCa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certs: Optional[Sequence['outputs.InstanceManagedServerCaCaCert']] = None):
        """
        :param Sequence['InstanceManagedServerCaCaCertArgs'] ca_certs: (Output)
               The PEM encoded CA certificate chains for managed server authentication
               Structure is documented below.
        """
        if ca_certs is not None:
            pulumi.set(__self__, "ca_certs", ca_certs)

    @_builtins.property
    @pulumi.getter(name="caCerts")
    def ca_certs(self) -> Optional[Sequence['outputs.InstanceManagedServerCaCaCert']]:
        """
        (Output)
        The PEM encoded CA certificate chains for managed server authentication
        Structure is documented below.
        """
        return pulumi.get(self, "ca_certs")


@pulumi.output_type
class InstanceManagedServerCaCaCert(dict):
    def __init__(__self__, *,
                 certificates: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] certificates: (Output)
               The certificates that form the CA chain, from leaf to root order
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        The certificates that form the CA chain, from leaf to root order
        """
        return pulumi.get(self, "certificates")


@pulumi.output_type
class InstanceNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeGb":
            suggest = "size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_gb: Optional[_builtins.float] = None):
        """
        :param _builtins.float size_gb: (Output)
               Output only. Memory size in GB of the node.
        """
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[_builtins.float]:
        """
        (Output)
        Output only. Memory size in GB of the node.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class InstancePersistenceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aofConfig":
            suggest = "aof_config"
        elif key == "rdbConfig":
            suggest = "rdb_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePersistenceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePersistenceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePersistenceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aof_config: Optional['outputs.InstancePersistenceConfigAofConfig'] = None,
                 mode: Optional[_builtins.str] = None,
                 rdb_config: Optional['outputs.InstancePersistenceConfigRdbConfig'] = None):
        """
        :param 'InstancePersistenceConfigAofConfigArgs' aof_config: Configuration for AOF based persistence.
               Structure is documented below.
        :param _builtins.str mode: Optional. Current persistence mode.
               Possible values:
               DISABLED
               RDB
               AOF
               Possible values are: `DISABLED`, `RDB`, `AOF`.
        :param 'InstancePersistenceConfigRdbConfigArgs' rdb_config: Configuration for RDB based persistence.
               Structure is documented below.
        """
        if aof_config is not None:
            pulumi.set(__self__, "aof_config", aof_config)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if rdb_config is not None:
            pulumi.set(__self__, "rdb_config", rdb_config)

    @_builtins.property
    @pulumi.getter(name="aofConfig")
    def aof_config(self) -> Optional['outputs.InstancePersistenceConfigAofConfig']:
        """
        Configuration for AOF based persistence.
        Structure is documented below.
        """
        return pulumi.get(self, "aof_config")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        Optional. Current persistence mode.
        Possible values:
        DISABLED
        RDB
        AOF
        Possible values are: `DISABLED`, `RDB`, `AOF`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="rdbConfig")
    def rdb_config(self) -> Optional['outputs.InstancePersistenceConfigRdbConfig']:
        """
        Configuration for RDB based persistence.
        Structure is documented below.
        """
        return pulumi.get(self, "rdb_config")


@pulumi.output_type
class InstancePersistenceConfigAofConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appendFsync":
            suggest = "append_fsync"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePersistenceConfigAofConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePersistenceConfigAofConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePersistenceConfigAofConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 append_fsync: Optional[_builtins.str] = None):
        """
        :param _builtins.str append_fsync: Optional. The fsync mode.
               Possible values:
               NEVER
               EVERY_SEC
               ALWAYS
        """
        if append_fsync is not None:
            pulumi.set(__self__, "append_fsync", append_fsync)

    @_builtins.property
    @pulumi.getter(name="appendFsync")
    def append_fsync(self) -> Optional[_builtins.str]:
        """
        Optional. The fsync mode.
        Possible values:
        NEVER
        EVERY_SEC
        ALWAYS
        """
        return pulumi.get(self, "append_fsync")


@pulumi.output_type
class InstancePersistenceConfigRdbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rdbSnapshotPeriod":
            suggest = "rdb_snapshot_period"
        elif key == "rdbSnapshotStartTime":
            suggest = "rdb_snapshot_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePersistenceConfigRdbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePersistenceConfigRdbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePersistenceConfigRdbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rdb_snapshot_period: Optional[_builtins.str] = None,
                 rdb_snapshot_start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str rdb_snapshot_period: Optional. Period between RDB snapshots.
               Possible values:
               ONE_HOUR
               SIX_HOURS
               TWELVE_HOURS
               TWENTY_FOUR_HOURS
        :param _builtins.str rdb_snapshot_start_time: Optional. Time that the first snapshot was/will be attempted, and to which future
               snapshots will be aligned. If not provided, the current time will be
               used.
        """
        if rdb_snapshot_period is not None:
            pulumi.set(__self__, "rdb_snapshot_period", rdb_snapshot_period)
        if rdb_snapshot_start_time is not None:
            pulumi.set(__self__, "rdb_snapshot_start_time", rdb_snapshot_start_time)

    @_builtins.property
    @pulumi.getter(name="rdbSnapshotPeriod")
    def rdb_snapshot_period(self) -> Optional[_builtins.str]:
        """
        Optional. Period between RDB snapshots.
        Possible values:
        ONE_HOUR
        SIX_HOURS
        TWELVE_HOURS
        TWENTY_FOUR_HOURS
        """
        return pulumi.get(self, "rdb_snapshot_period")

    @_builtins.property
    @pulumi.getter(name="rdbSnapshotStartTime")
    def rdb_snapshot_start_time(self) -> Optional[_builtins.str]:
        """
        Optional. Time that the first snapshot was/will be attempted, and to which future
        snapshots will be aligned. If not provided, the current time will be
        used.
        """
        return pulumi.get(self, "rdb_snapshot_start_time")


@pulumi.output_type
class InstancePscAttachmentDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionType":
            suggest = "connection_type"
        elif key == "serviceAttachment":
            suggest = "service_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePscAttachmentDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePscAttachmentDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePscAttachmentDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_type: Optional[_builtins.str] = None,
                 service_attachment: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_type: (Output)
               Output Only. Type of a PSC Connection.
               Possible values:
               CONNECTION_TYPE_DISCOVERY
               CONNECTION_TYPE_PRIMARY
               CONNECTION_TYPE_READER
        :param _builtins.str service_attachment: (Output)
               Output only. The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output Only. Type of a PSC Connection.
        Possible values:
        CONNECTION_TYPE_DISCOVERY
        CONNECTION_TYPE_PRIMARY
        CONNECTION_TYPE_READER
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class InstancePscAutoConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionType":
            suggest = "connection_type"
        elif key == "forwardingRule":
            suggest = "forwarding_rule"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "pscConnectionId":
            suggest = "psc_connection_id"
        elif key == "pscConnectionStatus":
            suggest = "psc_connection_status"
        elif key == "serviceAttachment":
            suggest = "service_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePscAutoConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePscAutoConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePscAutoConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_type: Optional[_builtins.str] = None,
                 forwarding_rule: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 network: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 project_id: Optional[_builtins.str] = None,
                 psc_connection_id: Optional[_builtins.str] = None,
                 psc_connection_status: Optional[_builtins.str] = None,
                 service_attachment: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_type: (Output)
               Output Only. Type of a PSC Connection.
               Possible values:
               CONNECTION_TYPE_DISCOVERY
               CONNECTION_TYPE_PRIMARY
               CONNECTION_TYPE_READER
        :param _builtins.str forwarding_rule: (Output)
               Output only. The URI of the consumer side forwarding rule.
               Format:
               projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        :param _builtins.str ip_address: (Output)
               Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        :param _builtins.str network: (Output)
               Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param _builtins.int port: (Output)
               Output only. Ports of the exposed endpoint.
        :param _builtins.str project_id: (Output)
               Output only. The consumer project_id where the forwarding rule is created from.
        :param _builtins.str psc_connection_id: (Output)
               Output only. The PSC connection id of the forwarding rule connected to the
               service attachment.
        :param _builtins.str psc_connection_status: (Output)
               Output Only. The status of the PSC connection: whether a connection exists and ACTIVE or it no longer exists.
               Possible values:
               ACTIVE
               NOT_FOUND
        :param _builtins.str service_attachment: (Output)
               Output only. The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if forwarding_rule is not None:
            pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if psc_connection_id is not None:
            pulumi.set(__self__, "psc_connection_id", psc_connection_id)
        if psc_connection_status is not None:
            pulumi.set(__self__, "psc_connection_status", psc_connection_status)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output Only. Type of a PSC Connection.
        Possible values:
        CONNECTION_TYPE_DISCOVERY
        CONNECTION_TYPE_PRIMARY
        CONNECTION_TYPE_READER
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The URI of the consumer side forwarding rule.
        Format:
        projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        """
        return pulumi.get(self, "forwarding_rule")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        (Output)
        Output only. Ports of the exposed endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The PSC connection id of the forwarding rule connected to the
        service attachment.
        """
        return pulumi.get(self, "psc_connection_id")

    @_builtins.property
    @pulumi.getter(name="pscConnectionStatus")
    def psc_connection_status(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output Only. The status of the PSC connection: whether a connection exists and ACTIVE or it no longer exists.
        Possible values:
        ACTIVE
        NOT_FOUND
        """
        return pulumi.get(self, "psc_connection_status")

    @_builtins.property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class InstanceStateInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateInfos":
            suggest = "update_infos"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceStateInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceStateInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceStateInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 update_infos: Optional[Sequence['outputs.InstanceStateInfoUpdateInfo']] = None):
        """
        :param Sequence['InstanceStateInfoUpdateInfoArgs'] update_infos: (Output)
               Represents information about instance with state UPDATING.
               Structure is documented below.
        """
        if update_infos is not None:
            pulumi.set(__self__, "update_infos", update_infos)

    @_builtins.property
    @pulumi.getter(name="updateInfos")
    def update_infos(self) -> Optional[Sequence['outputs.InstanceStateInfoUpdateInfo']]:
        """
        (Output)
        Represents information about instance with state UPDATING.
        Structure is documented below.
        """
        return pulumi.get(self, "update_infos")


@pulumi.output_type
class InstanceStateInfoUpdateInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetEngineVersion":
            suggest = "target_engine_version"
        elif key == "targetNodeType":
            suggest = "target_node_type"
        elif key == "targetReplicaCount":
            suggest = "target_replica_count"
        elif key == "targetShardCount":
            suggest = "target_shard_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceStateInfoUpdateInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceStateInfoUpdateInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceStateInfoUpdateInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_engine_version: Optional[_builtins.str] = None,
                 target_node_type: Optional[_builtins.str] = None,
                 target_replica_count: Optional[_builtins.int] = None,
                 target_shard_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str target_engine_version: (Output)
               Output only. Target engine version for the instance.
        :param _builtins.str target_node_type: (Output)
               Output only. Target node type for the instance.
        :param _builtins.int target_replica_count: (Output)
               Output only. Target number of replica nodes per shard for the instance.
        :param _builtins.int target_shard_count: (Output)
               Output only. Target number of shards for the instance.
        """
        if target_engine_version is not None:
            pulumi.set(__self__, "target_engine_version", target_engine_version)
        if target_node_type is not None:
            pulumi.set(__self__, "target_node_type", target_node_type)
        if target_replica_count is not None:
            pulumi.set(__self__, "target_replica_count", target_replica_count)
        if target_shard_count is not None:
            pulumi.set(__self__, "target_shard_count", target_shard_count)

    @_builtins.property
    @pulumi.getter(name="targetEngineVersion")
    def target_engine_version(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. Target engine version for the instance.
        """
        return pulumi.get(self, "target_engine_version")

    @_builtins.property
    @pulumi.getter(name="targetNodeType")
    def target_node_type(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. Target node type for the instance.
        """
        return pulumi.get(self, "target_node_type")

    @_builtins.property
    @pulumi.getter(name="targetReplicaCount")
    def target_replica_count(self) -> Optional[_builtins.int]:
        """
        (Output)
        Output only. Target number of replica nodes per shard for the instance.
        """
        return pulumi.get(self, "target_replica_count")

    @_builtins.property
    @pulumi.getter(name="targetShardCount")
    def target_shard_count(self) -> Optional[_builtins.int]:
        """
        (Output)
        Output only. Target number of shards for the instance.
        """
        return pulumi.get(self, "target_shard_count")


@pulumi.output_type
class InstanceZoneDistributionConfig(dict):
    def __init__(__self__, *,
                 mode: Optional[_builtins.str] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str mode: Optional. Current zone distribution mode. Defaults to MULTI_ZONE.
               Possible values:
               MULTI_ZONE
               SINGLE_ZONE
               Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        :param _builtins.str zone: Optional. Defines zone where all resources will be allocated with SINGLE_ZONE mode.
               Ignored for MULTI_ZONE mode.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        Optional. Current zone distribution mode. Defaults to MULTI_ZONE.
        Possible values:
        MULTI_ZONE
        SINGLE_ZONE
        Possible values are: `MULTI_ZONE`, `SINGLE_ZONE`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        Optional. Defines zone where all resources will be allocated with SINGLE_ZONE mode.
        Ignored for MULTI_ZONE mode.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetInstanceAutomatedBackupConfigResult(dict):
    def __init__(__self__, *,
                 fixed_frequency_schedules: Sequence['outputs.GetInstanceAutomatedBackupConfigFixedFrequencyScheduleResult'],
                 retention: _builtins.str):
        """
        :param Sequence['GetInstanceAutomatedBackupConfigFixedFrequencyScheduleArgs'] fixed_frequency_schedules: Trigger automated backups at a fixed frequency.
        :param _builtins.str retention: How long to keep automated backups before the backups are deleted.
               The value should be between 1 day and 365 days. If not specified, the default value is 35 days.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s". The default_value is "3024000s"
        """
        pulumi.set(__self__, "fixed_frequency_schedules", fixed_frequency_schedules)
        pulumi.set(__self__, "retention", retention)

    @_builtins.property
    @pulumi.getter(name="fixedFrequencySchedules")
    def fixed_frequency_schedules(self) -> Sequence['outputs.GetInstanceAutomatedBackupConfigFixedFrequencyScheduleResult']:
        """
        Trigger automated backups at a fixed frequency.
        """
        return pulumi.get(self, "fixed_frequency_schedules")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.str:
        """
        How long to keep automated backups before the backups are deleted.
        The value should be between 1 day and 365 days. If not specified, the default value is 35 days.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s". The default_value is "3024000s"
        """
        return pulumi.get(self, "retention")


@pulumi.output_type
class GetInstanceAutomatedBackupConfigFixedFrequencyScheduleResult(dict):
    def __init__(__self__, *,
                 start_times: Sequence['outputs.GetInstanceAutomatedBackupConfigFixedFrequencyScheduleStartTimeResult']):
        """
        :param Sequence['GetInstanceAutomatedBackupConfigFixedFrequencyScheduleStartTimeArgs'] start_times: The start time of every automated backup in UTC.
               It must be set to the start of an hour. This field is required.
        """
        pulumi.set(__self__, "start_times", start_times)

    @_builtins.property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.GetInstanceAutomatedBackupConfigFixedFrequencyScheduleStartTimeResult']:
        """
        The start time of every automated backup in UTC.
        It must be set to the start of an hour. This field is required.
        """
        return pulumi.get(self, "start_times")


@pulumi.output_type
class GetInstanceAutomatedBackupConfigFixedFrequencyScheduleStartTimeResult(dict):
    def __init__(__self__, *,
                 hours: _builtins.int):
        """
        :param _builtins.int hours: Hours of a day in 24 hour format. Must be greater than or equal to 0 and typically must be less than or equal to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        pulumi.set(__self__, "hours", hours)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> _builtins.int:
        """
        Hours of a day in 24 hour format. Must be greater than or equal to 0 and typically must be less than or equal to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")


@pulumi.output_type
class GetInstanceCrossInstanceReplicationConfigResult(dict):
    def __init__(__self__, *,
                 instance_role: _builtins.str,
                 memberships: Sequence['outputs.GetInstanceCrossInstanceReplicationConfigMembershipResult'],
                 primary_instances: Sequence['outputs.GetInstanceCrossInstanceReplicationConfigPrimaryInstanceResult'],
                 secondary_instances: Sequence['outputs.GetInstanceCrossInstanceReplicationConfigSecondaryInstanceResult'],
                 update_time: _builtins.str):
        """
        :param _builtins.str instance_role: The instance role supports the following values:
               1. 'INSTANCE_ROLE_UNSPECIFIED': This is an independent instance that has never participated in cross instance replication. It allows both reads and writes.
               2. 'NONE': This is an independent instance that previously participated in cross instance replication(either as a 'PRIMARY' or 'SECONDARY' cluster). It allows both reads and writes.
               3. 'PRIMARY': This instance serves as the replication source for secondary instance that are replicating from it. Any data written to it is automatically replicated to its secondary clusters. It allows both reads and writes.
               4. 'SECONDARY': This instance replicates data from the primary instance. It allows only reads. Possible values: ["INSTANCE_ROLE_UNSPECIFIED", "NONE", "PRIMARY", "SECONDARY"]
        :param Sequence['GetInstanceCrossInstanceReplicationConfigMembershipArgs'] memberships: An output only view of all the member instance participating in cross instance replication. This field is populated for all the member clusters irrespective of their cluster role.
        :param Sequence['GetInstanceCrossInstanceReplicationConfigPrimaryInstanceArgs'] primary_instances: This field is only set for a secondary instance. Details of the primary instance that is used as the replication source for this secondary instance. This is allowed to be set only for clusters whose cluster role is of type 'SECONDARY'.
        :param Sequence['GetInstanceCrossInstanceReplicationConfigSecondaryInstanceArgs'] secondary_instances: List of secondary instances that are replicating from this primary cluster. This is allowed to be set only for instances whose cluster role is of type 'PRIMARY'.
        :param _builtins.str update_time: The last time cross instance replication config was updated.
        """
        pulumi.set(__self__, "instance_role", instance_role)
        pulumi.set(__self__, "memberships", memberships)
        pulumi.set(__self__, "primary_instances", primary_instances)
        pulumi.set(__self__, "secondary_instances", secondary_instances)
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="instanceRole")
    def instance_role(self) -> _builtins.str:
        """
        The instance role supports the following values:
        1. 'INSTANCE_ROLE_UNSPECIFIED': This is an independent instance that has never participated in cross instance replication. It allows both reads and writes.
        2. 'NONE': This is an independent instance that previously participated in cross instance replication(either as a 'PRIMARY' or 'SECONDARY' cluster). It allows both reads and writes.
        3. 'PRIMARY': This instance serves as the replication source for secondary instance that are replicating from it. Any data written to it is automatically replicated to its secondary clusters. It allows both reads and writes.
        4. 'SECONDARY': This instance replicates data from the primary instance. It allows only reads. Possible values: ["INSTANCE_ROLE_UNSPECIFIED", "NONE", "PRIMARY", "SECONDARY"]
        """
        return pulumi.get(self, "instance_role")

    @_builtins.property
    @pulumi.getter
    def memberships(self) -> Sequence['outputs.GetInstanceCrossInstanceReplicationConfigMembershipResult']:
        """
        An output only view of all the member instance participating in cross instance replication. This field is populated for all the member clusters irrespective of their cluster role.
        """
        return pulumi.get(self, "memberships")

    @_builtins.property
    @pulumi.getter(name="primaryInstances")
    def primary_instances(self) -> Sequence['outputs.GetInstanceCrossInstanceReplicationConfigPrimaryInstanceResult']:
        """
        This field is only set for a secondary instance. Details of the primary instance that is used as the replication source for this secondary instance. This is allowed to be set only for clusters whose cluster role is of type 'SECONDARY'.
        """
        return pulumi.get(self, "primary_instances")

    @_builtins.property
    @pulumi.getter(name="secondaryInstances")
    def secondary_instances(self) -> Sequence['outputs.GetInstanceCrossInstanceReplicationConfigSecondaryInstanceResult']:
        """
        List of secondary instances that are replicating from this primary cluster. This is allowed to be set only for instances whose cluster role is of type 'PRIMARY'.
        """
        return pulumi.get(self, "secondary_instances")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The last time cross instance replication config was updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetInstanceCrossInstanceReplicationConfigMembershipResult(dict):
    def __init__(__self__, *,
                 primary_instances: Sequence['outputs.GetInstanceCrossInstanceReplicationConfigMembershipPrimaryInstanceResult'],
                 secondary_instances: Sequence['outputs.GetInstanceCrossInstanceReplicationConfigMembershipSecondaryInstanceResult']):
        """
        :param Sequence['GetInstanceCrossInstanceReplicationConfigMembershipPrimaryInstanceArgs'] primary_instances: Details of the primary instance that is used as the replication source for all the secondary instances.
        :param Sequence['GetInstanceCrossInstanceReplicationConfigMembershipSecondaryInstanceArgs'] secondary_instances: List of secondary instances that are replicating from the primary instance.
        """
        pulumi.set(__self__, "primary_instances", primary_instances)
        pulumi.set(__self__, "secondary_instances", secondary_instances)

    @_builtins.property
    @pulumi.getter(name="primaryInstances")
    def primary_instances(self) -> Sequence['outputs.GetInstanceCrossInstanceReplicationConfigMembershipPrimaryInstanceResult']:
        """
        Details of the primary instance that is used as the replication source for all the secondary instances.
        """
        return pulumi.get(self, "primary_instances")

    @_builtins.property
    @pulumi.getter(name="secondaryInstances")
    def secondary_instances(self) -> Sequence['outputs.GetInstanceCrossInstanceReplicationConfigMembershipSecondaryInstanceResult']:
        """
        List of secondary instances that are replicating from the primary instance.
        """
        return pulumi.get(self, "secondary_instances")


@pulumi.output_type
class GetInstanceCrossInstanceReplicationConfigMembershipPrimaryInstanceResult(dict):
    def __init__(__self__, *,
                 instance: _builtins.str,
                 uid: _builtins.str):
        """
        :param _builtins.str instance: The full resource path of the primary instance in the format: projects/{project}/locations/{region}/instance/{instance-id}
        :param _builtins.str uid: The unique id of the primary instance.
        """
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> _builtins.str:
        """
        The full resource path of the primary instance in the format: projects/{project}/locations/{region}/instance/{instance-id}
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        The unique id of the primary instance.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetInstanceCrossInstanceReplicationConfigMembershipSecondaryInstanceResult(dict):
    def __init__(__self__, *,
                 instance: _builtins.str,
                 uid: _builtins.str):
        """
        :param _builtins.str instance: The full resource path of the secondary instance in the format: projects/{project}/locations/{region}/instance/{instance-id}
        :param _builtins.str uid: The unique id of the secondary instance.
        """
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> _builtins.str:
        """
        The full resource path of the secondary instance in the format: projects/{project}/locations/{region}/instance/{instance-id}
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        The unique id of the secondary instance.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetInstanceCrossInstanceReplicationConfigPrimaryInstanceResult(dict):
    def __init__(__self__, *,
                 instance: _builtins.str,
                 uid: _builtins.str):
        """
        :param _builtins.str instance: The full resource path of the primary instance in the format: projects/{project}/locations/{region}/instances/{instance-id}
        :param _builtins.str uid: The unique id of the primary instance.
        """
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> _builtins.str:
        """
        The full resource path of the primary instance in the format: projects/{project}/locations/{region}/instances/{instance-id}
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        The unique id of the primary instance.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetInstanceCrossInstanceReplicationConfigSecondaryInstanceResult(dict):
    def __init__(__self__, *,
                 instance: _builtins.str,
                 uid: _builtins.str):
        """
        :param _builtins.str instance: The full resource path of the Nth instance in the format: projects/{project}/locations/{region}/instance/{instance-id}
        :param _builtins.str uid: The unique id of the Nth instance.
        """
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> _builtins.str:
        """
        The full resource path of the Nth instance in the format: projects/{project}/locations/{region}/instance/{instance-id}
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        The unique id of the Nth instance.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetInstanceDesiredAutoCreatedEndpointResult(dict):
    def __init__(__self__, *,
                 network: _builtins.str,
                 project_id: _builtins.str):
        """
        :param _builtins.str network: Required. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param _builtins.str project_id: Required. The consumer project_id where the forwarding rule is created from.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        Required. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Required. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class GetInstanceDesiredPscAutoConnectionResult(dict):
    def __init__(__self__, *,
                 network: _builtins.str,
                 project_id: _builtins.str):
        """
        :param _builtins.str network: Required. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param _builtins.str project_id: Required. The consumer project_id where the forwarding rule is created from.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        Required. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Required. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class GetInstanceDiscoveryEndpointResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 network: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str address: Output only. IP address of the exposed endpoint clients connect to.
        :param _builtins.str network: Output only. The network where the IP address of the discovery endpoint will be
               reserved, in the form of
               projects/{network_project}/global/networks/{network_id}.
        :param _builtins.int port: Output only. The port number of the exposed endpoint.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Output only. IP address of the exposed endpoint clients connect to.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        Output only. The network where the IP address of the discovery endpoint will be
        reserved, in the form of
        projects/{network_project}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Output only. The port number of the exposed endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetInstanceEndpointResult(dict):
    def __init__(__self__, *,
                 connections: Sequence['outputs.GetInstanceEndpointConnectionResult']):
        """
        :param Sequence['GetInstanceEndpointConnectionArgs'] connections: A group of PSC connections. They are created in the same VPC network, one for each service attachment in the cluster.
        """
        pulumi.set(__self__, "connections", connections)

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetInstanceEndpointConnectionResult']:
        """
        A group of PSC connections. They are created in the same VPC network, one for each service attachment in the cluster.
        """
        return pulumi.get(self, "connections")


@pulumi.output_type
class GetInstanceEndpointConnectionResult(dict):
    def __init__(__self__, *,
                 psc_auto_connections: Sequence['outputs.GetInstanceEndpointConnectionPscAutoConnectionResult']):
        """
        :param Sequence['GetInstanceEndpointConnectionPscAutoConnectionArgs'] psc_auto_connections: Detailed information of a PSC connection that is created through service connectivity automation.
        """
        pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)

    @_builtins.property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> Sequence['outputs.GetInstanceEndpointConnectionPscAutoConnectionResult']:
        """
        Detailed information of a PSC connection that is created through service connectivity automation.
        """
        return pulumi.get(self, "psc_auto_connections")


@pulumi.output_type
class GetInstanceEndpointConnectionPscAutoConnectionResult(dict):
    def __init__(__self__, *,
                 connection_type: _builtins.str,
                 forwarding_rule: _builtins.str,
                 ip_address: _builtins.str,
                 network: _builtins.str,
                 port: _builtins.int,
                 project_id: _builtins.str,
                 psc_connection_id: _builtins.str,
                 service_attachment: _builtins.str):
        """
        :param _builtins.str connection_type: Output Only. Type of a PSC Connection. 
                Possible values:
                CONNECTION_TYPE_DISCOVERY 
                CONNECTION_TYPE_PRIMARY 
                CONNECTION_TYPE_READER
        :param _builtins.str forwarding_rule: Output only. The URI of the consumer side forwarding rule.
               Format:
               projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        :param _builtins.str ip_address: Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        :param _builtins.str network: Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param _builtins.int port: Output only. Ports of the exposed endpoint.
        :param _builtins.str project_id: Output only. The consumer project_id where the forwarding rule is created from.
        :param _builtins.str psc_connection_id: Output only. The PSC connection id of the forwarding rule connected to the
               service attachment.
        :param _builtins.str service_attachment: Output only. The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "psc_connection_id", psc_connection_id)
        pulumi.set(__self__, "service_attachment", service_attachment)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> _builtins.str:
        """
        Output Only. Type of a PSC Connection. 
         Possible values:
         CONNECTION_TYPE_DISCOVERY 
         CONNECTION_TYPE_PRIMARY 
         CONNECTION_TYPE_READER
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> _builtins.str:
        """
        Output only. The URI of the consumer side forwarding rule.
        Format:
        projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        """
        return pulumi.get(self, "forwarding_rule")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Output only. Ports of the exposed endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Output only. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> _builtins.str:
        """
        Output only. The PSC connection id of the forwarding rule connected to the
        service attachment.
        """
        return pulumi.get(self, "psc_connection_id")

    @_builtins.property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> _builtins.str:
        """
        Output only. The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class GetInstanceGcsSourceResult(dict):
    def __init__(__self__, *,
                 uris: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] uris: URIs of the GCS objects to import.
               Example: gs://bucket1/object1, gs://bucket2/folder2/object2
        """
        pulumi.set(__self__, "uris", uris)

    @_builtins.property
    @pulumi.getter
    def uris(self) -> Sequence[_builtins.str]:
        """
        URIs of the GCS objects to import.
        Example: gs://bucket1/object1, gs://bucket2/folder2/object2
        """
        return pulumi.get(self, "uris")


@pulumi.output_type
class GetInstanceMaintenancePolicyResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 update_time: _builtins.str,
                 weekly_maintenance_windows: Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult']):
        """
        :param _builtins.str create_time: The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param _builtins.str update_time: The time when the policy was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param Sequence['GetInstanceMaintenancePolicyWeeklyMaintenanceWindowArgs'] weekly_maintenance_windows: Optional. Maintenance window that is applied to resources covered by this policy.
               Minimum 1. For the current version, the maximum number
               of weekly_window is expected to be one.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "weekly_maintenance_windows", weekly_maintenance_windows)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time when the policy was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="weeklyMaintenanceWindows")
    def weekly_maintenance_windows(self) -> Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult']:
        """
        Optional. Maintenance window that is applied to resources covered by this policy.
        Minimum 1. For the current version, the maximum number
        of weekly_window is expected to be one.
        """
        return pulumi.get(self, "weekly_maintenance_windows")


@pulumi.output_type
class GetInstanceMaintenancePolicyWeeklyMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: _builtins.str,
                 duration: _builtins.str,
                 start_times: Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult']):
        """
        :param _builtins.str day: The day of week that maintenance updates occur.
               
               - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
               - MONDAY: Monday
               - TUESDAY: Tuesday
               - WEDNESDAY: Wednesday
               - THURSDAY: Thursday
               - FRIDAY: Friday
               - SATURDAY: Saturday
               - SUNDAY: Sunday Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        :param _builtins.str duration: Duration of the maintenance window.
               The current window is fixed at 1 hour.
               A duration in seconds with up to nine fractional digits,
               terminated by 's'. Example: "3.5s".
        :param Sequence['GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs'] start_times: Start time of the window in UTC time.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_times", start_times)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.str:
        """
        The day of week that maintenance updates occur.

        - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
        - MONDAY: Monday
        - TUESDAY: Tuesday
        - WEDNESDAY: Wednesday
        - THURSDAY: Thursday
        - FRIDAY: Friday
        - SATURDAY: Saturday
        - SUNDAY: Sunday Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        Duration of the maintenance window.
        The current window is fixed at 1 hour.
        A duration in seconds with up to nine fractional digits,
        terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult']:
        """
        Start time of the window in UTC time.
        """
        return pulumi.get(self, "start_times")


@pulumi.output_type
class GetInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeResult(dict):
    def __init__(__self__, *,
                 hours: _builtins.int,
                 minutes: _builtins.int,
                 nanos: _builtins.int,
                 seconds: _builtins.int):
        """
        :param _builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param _builtins.int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param _builtins.int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param _builtins.int seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
               An API may allow the value 60 if it allows leap-seconds.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> _builtins.int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> _builtins.int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def nanos(self) -> _builtins.int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @_builtins.property
    @pulumi.getter
    def seconds(self) -> _builtins.int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class GetInstanceMaintenanceScheduleResult(dict):
    def __init__(__self__, *,
                 end_time: _builtins.str,
                 schedule_deadline_time: _builtins.str,
                 start_time: _builtins.str):
        """
        :param _builtins.str end_time: The end time of any upcoming scheduled maintenance for this cluster.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param _builtins.str schedule_deadline_time: The deadline that the maintenance schedule start time
               can not go beyond, including reschedule.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param _builtins.str start_time: The start time of any upcoming scheduled maintenance for this cluster.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        The end time of any upcoming scheduled maintenance for this cluster.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> _builtins.str:
        """
        The deadline that the maintenance schedule start time
        can not go beyond, including reschedule.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        The start time of any upcoming scheduled maintenance for this cluster.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetInstanceManagedBackupSourceResult(dict):
    def __init__(__self__, *,
                 backup: _builtins.str):
        """
        :param _builtins.str backup: Example: 'projects/{project}/locations/{location}/backupCollections/{collection}/backups/{backup}'.
        """
        pulumi.set(__self__, "backup", backup)

    @_builtins.property
    @pulumi.getter
    def backup(self) -> _builtins.str:
        """
        Example: 'projects/{project}/locations/{location}/backupCollections/{collection}/backups/{backup}'.
        """
        return pulumi.get(self, "backup")


@pulumi.output_type
class GetInstanceManagedServerCaResult(dict):
    def __init__(__self__, *,
                 ca_certs: Sequence['outputs.GetInstanceManagedServerCaCaCertResult']):
        """
        :param Sequence['GetInstanceManagedServerCaCaCertArgs'] ca_certs: The PEM encoded CA certificate chains for managed server authentication
        """
        pulumi.set(__self__, "ca_certs", ca_certs)

    @_builtins.property
    @pulumi.getter(name="caCerts")
    def ca_certs(self) -> Sequence['outputs.GetInstanceManagedServerCaCaCertResult']:
        """
        The PEM encoded CA certificate chains for managed server authentication
        """
        return pulumi.get(self, "ca_certs")


@pulumi.output_type
class GetInstanceManagedServerCaCaCertResult(dict):
    def __init__(__self__, *,
                 certificates: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] certificates: The certificates that form the CA chain, from leaf to root order
        """
        pulumi.set(__self__, "certificates", certificates)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence[_builtins.str]:
        """
        The certificates that form the CA chain, from leaf to root order
        """
        return pulumi.get(self, "certificates")


@pulumi.output_type
class GetInstanceNodeConfigResult(dict):
    def __init__(__self__, *,
                 size_gb: _builtins.float):
        """
        :param _builtins.float size_gb: Output only. Memory size in GB of the node.
        """
        pulumi.set(__self__, "size_gb", size_gb)

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> _builtins.float:
        """
        Output only. Memory size in GB of the node.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class GetInstancePersistenceConfigResult(dict):
    def __init__(__self__, *,
                 aof_configs: Sequence['outputs.GetInstancePersistenceConfigAofConfigResult'],
                 mode: _builtins.str,
                 rdb_configs: Sequence['outputs.GetInstancePersistenceConfigRdbConfigResult']):
        """
        :param Sequence['GetInstancePersistenceConfigAofConfigArgs'] aof_configs: Configuration for AOF based persistence.
        :param _builtins.str mode: Optional. Current persistence mode. 
                Possible values:
               DISABLED
               RDB
               AOF Possible values: ["DISABLED", "RDB", "AOF"]
        :param Sequence['GetInstancePersistenceConfigRdbConfigArgs'] rdb_configs: Configuration for RDB based persistence.
        """
        pulumi.set(__self__, "aof_configs", aof_configs)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "rdb_configs", rdb_configs)

    @_builtins.property
    @pulumi.getter(name="aofConfigs")
    def aof_configs(self) -> Sequence['outputs.GetInstancePersistenceConfigAofConfigResult']:
        """
        Configuration for AOF based persistence.
        """
        return pulumi.get(self, "aof_configs")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        Optional. Current persistence mode. 
         Possible values:
        DISABLED
        RDB
        AOF Possible values: ["DISABLED", "RDB", "AOF"]
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="rdbConfigs")
    def rdb_configs(self) -> Sequence['outputs.GetInstancePersistenceConfigRdbConfigResult']:
        """
        Configuration for RDB based persistence.
        """
        return pulumi.get(self, "rdb_configs")


@pulumi.output_type
class GetInstancePersistenceConfigAofConfigResult(dict):
    def __init__(__self__, *,
                 append_fsync: _builtins.str):
        """
        :param _builtins.str append_fsync: Optional. The fsync mode. 
                Possible values:
                NEVER
               EVERY_SEC
               ALWAYS
        """
        pulumi.set(__self__, "append_fsync", append_fsync)

    @_builtins.property
    @pulumi.getter(name="appendFsync")
    def append_fsync(self) -> _builtins.str:
        """
        Optional. The fsync mode. 
         Possible values:
         NEVER
        EVERY_SEC
        ALWAYS
        """
        return pulumi.get(self, "append_fsync")


@pulumi.output_type
class GetInstancePersistenceConfigRdbConfigResult(dict):
    def __init__(__self__, *,
                 rdb_snapshot_period: _builtins.str,
                 rdb_snapshot_start_time: _builtins.str):
        """
        :param _builtins.str rdb_snapshot_period: Optional. Period between RDB snapshots. 
                Possible values:
                ONE_HOUR
               SIX_HOURS
               TWELVE_HOURS
               TWENTY_FOUR_HOURS
        :param _builtins.str rdb_snapshot_start_time: Optional. Time that the first snapshot was/will be attempted, and to which future
               snapshots will be aligned. If not provided, the current time will be
               used.
        """
        pulumi.set(__self__, "rdb_snapshot_period", rdb_snapshot_period)
        pulumi.set(__self__, "rdb_snapshot_start_time", rdb_snapshot_start_time)

    @_builtins.property
    @pulumi.getter(name="rdbSnapshotPeriod")
    def rdb_snapshot_period(self) -> _builtins.str:
        """
        Optional. Period between RDB snapshots. 
         Possible values:
         ONE_HOUR
        SIX_HOURS
        TWELVE_HOURS
        TWENTY_FOUR_HOURS
        """
        return pulumi.get(self, "rdb_snapshot_period")

    @_builtins.property
    @pulumi.getter(name="rdbSnapshotStartTime")
    def rdb_snapshot_start_time(self) -> _builtins.str:
        """
        Optional. Time that the first snapshot was/will be attempted, and to which future
        snapshots will be aligned. If not provided, the current time will be
        used.
        """
        return pulumi.get(self, "rdb_snapshot_start_time")


@pulumi.output_type
class GetInstancePscAttachmentDetailResult(dict):
    def __init__(__self__, *,
                 connection_type: _builtins.str,
                 service_attachment: _builtins.str):
        """
        :param _builtins.str connection_type: Service attachment URI which your self-created PscConnection should use as target.
        :param _builtins.str service_attachment: Service attachment URI which your self-created PscConnection should use as target.
        """
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "service_attachment", service_attachment)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> _builtins.str:
        """
        Service attachment URI which your self-created PscConnection should use as target.
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> _builtins.str:
        """
        Service attachment URI which your self-created PscConnection should use as target.
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class GetInstancePscAutoConnectionResult(dict):
    def __init__(__self__, *,
                 connection_type: _builtins.str,
                 forwarding_rule: _builtins.str,
                 ip_address: _builtins.str,
                 network: _builtins.str,
                 port: _builtins.int,
                 project_id: _builtins.str,
                 psc_connection_id: _builtins.str,
                 psc_connection_status: _builtins.str,
                 service_attachment: _builtins.str):
        """
        :param _builtins.str connection_type: Output Only. Type of a PSC Connection. 
                Possible values:
                CONNECTION_TYPE_DISCOVERY 
                CONNECTION_TYPE_PRIMARY 
                CONNECTION_TYPE_READER
        :param _builtins.str forwarding_rule: Output only. The URI of the consumer side forwarding rule.
               Format:
               projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        :param _builtins.str ip_address: Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        :param _builtins.str network: Output only. The consumer network where the IP address resides, in the form of
               projects/{project_id}/global/networks/{network_id}.
        :param _builtins.int port: Output only. Ports of the exposed endpoint.
        :param _builtins.str project_id: Output only. The consumer project_id where the forwarding rule is created from.
        :param _builtins.str psc_connection_id: Output only. The PSC connection id of the forwarding rule connected to the
               service attachment.
        :param _builtins.str psc_connection_status: Output Only. The status of the PSC connection: whether a connection exists and ACTIVE or it no longer exists. 
                Possible values:
                ACTIVE 
                NOT_FOUND
        :param _builtins.str service_attachment: Output only. The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "forwarding_rule", forwarding_rule)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "psc_connection_id", psc_connection_id)
        pulumi.set(__self__, "psc_connection_status", psc_connection_status)
        pulumi.set(__self__, "service_attachment", service_attachment)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> _builtins.str:
        """
        Output Only. Type of a PSC Connection. 
         Possible values:
         CONNECTION_TYPE_DISCOVERY 
         CONNECTION_TYPE_PRIMARY 
         CONNECTION_TYPE_READER
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="forwardingRule")
    def forwarding_rule(self) -> _builtins.str:
        """
        Output only. The URI of the consumer side forwarding rule.
        Format:
        projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
        """
        return pulumi.get(self, "forwarding_rule")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        Output only. The IP allocated on the consumer network for the PSC forwarding rule.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        Output only. The consumer network where the IP address resides, in the form of
        projects/{project_id}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Output only. Ports of the exposed endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Output only. The consumer project_id where the forwarding rule is created from.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> _builtins.str:
        """
        Output only. The PSC connection id of the forwarding rule connected to the
        service attachment.
        """
        return pulumi.get(self, "psc_connection_id")

    @_builtins.property
    @pulumi.getter(name="pscConnectionStatus")
    def psc_connection_status(self) -> _builtins.str:
        """
        Output Only. The status of the PSC connection: whether a connection exists and ACTIVE or it no longer exists. 
         Possible values:
         ACTIVE 
         NOT_FOUND
        """
        return pulumi.get(self, "psc_connection_status")

    @_builtins.property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> _builtins.str:
        """
        Output only. The service attachment which is the target of the PSC connection, in the form of projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class GetInstanceStateInfoResult(dict):
    def __init__(__self__, *,
                 update_infos: Sequence['outputs.GetInstanceStateInfoUpdateInfoResult']):
        """
        :param Sequence['GetInstanceStateInfoUpdateInfoArgs'] update_infos: Represents information about instance with state UPDATING.
        """
        pulumi.set(__self__, "update_infos", update_infos)

    @_builtins.property
    @pulumi.getter(name="updateInfos")
    def update_infos(self) -> Sequence['outputs.GetInstanceStateInfoUpdateInfoResult']:
        """
        Represents information about instance with state UPDATING.
        """
        return pulumi.get(self, "update_infos")


@pulumi.output_type
class GetInstanceStateInfoUpdateInfoResult(dict):
    def __init__(__self__, *,
                 target_engine_version: _builtins.str,
                 target_node_type: _builtins.str,
                 target_replica_count: _builtins.int,
                 target_shard_count: _builtins.int):
        """
        :param _builtins.str target_engine_version: Output only. Target engine version for the instance.
        :param _builtins.str target_node_type: Output only. Target node type for the instance.
        :param _builtins.int target_replica_count: Output only. Target number of replica nodes per shard for the instance.
        :param _builtins.int target_shard_count: Output only. Target number of shards for the instance.
        """
        pulumi.set(__self__, "target_engine_version", target_engine_version)
        pulumi.set(__self__, "target_node_type", target_node_type)
        pulumi.set(__self__, "target_replica_count", target_replica_count)
        pulumi.set(__self__, "target_shard_count", target_shard_count)

    @_builtins.property
    @pulumi.getter(name="targetEngineVersion")
    def target_engine_version(self) -> _builtins.str:
        """
        Output only. Target engine version for the instance.
        """
        return pulumi.get(self, "target_engine_version")

    @_builtins.property
    @pulumi.getter(name="targetNodeType")
    def target_node_type(self) -> _builtins.str:
        """
        Output only. Target node type for the instance.
        """
        return pulumi.get(self, "target_node_type")

    @_builtins.property
    @pulumi.getter(name="targetReplicaCount")
    def target_replica_count(self) -> _builtins.int:
        """
        Output only. Target number of replica nodes per shard for the instance.
        """
        return pulumi.get(self, "target_replica_count")

    @_builtins.property
    @pulumi.getter(name="targetShardCount")
    def target_shard_count(self) -> _builtins.int:
        """
        Output only. Target number of shards for the instance.
        """
        return pulumi.get(self, "target_shard_count")


@pulumi.output_type
class GetInstanceZoneDistributionConfigResult(dict):
    def __init__(__self__, *,
                 mode: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str mode: Optional. Current zone distribution mode. Defaults to MULTI_ZONE. 
                Possible values:
                MULTI_ZONE
               SINGLE_ZONE Possible values: ["MULTI_ZONE", "SINGLE_ZONE"]
        :param _builtins.str zone: Optional. Defines zone where all resources will be allocated with SINGLE_ZONE mode.
               Ignored for MULTI_ZONE mode.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        Optional. Current zone distribution mode. Defaults to MULTI_ZONE. 
         Possible values:
         MULTI_ZONE
        SINGLE_ZONE Possible values: ["MULTI_ZONE", "SINGLE_ZONE"]
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        Optional. Defines zone where all resources will be allocated with SINGLE_ZONE mode.
        Ignored for MULTI_ZONE mode.
        """
        return pulumi.get(self, "zone")


