# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterIstioServiceResult',
    'AwaitableGetClusterIstioServiceResult',
    'get_cluster_istio_service',
    'get_cluster_istio_service_output',
]

@pulumi.output_type
class GetClusterIstioServiceResult:
    """
    A collection of values returned by getClusterIstioService.
    """
    def __init__(__self__, cluster_name=None, display_name=None, id=None, location=None, name=None, project=None, service_id=None, service_name=None, service_namespace=None, telemetries=None, user_labels=None):
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if service_namespace and not isinstance(service_namespace, str):
            raise TypeError("Expected argument 'service_namespace' to be a str")
        pulumi.set(__self__, "service_namespace", service_namespace)
        if telemetries and not isinstance(telemetries, list):
            raise TypeError("Expected argument 'telemetries' to be a list")
        pulumi.set(__self__, "telemetries", telemetries)
        if user_labels and not isinstance(user_labels, dict):
            raise TypeError("Expected argument 'user_labels' to be a dict")
        pulumi.set(__self__, "user_labels", user_labels)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Name used for UI elements listing this (Monitoring) Service.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The full REST resource name for this channel. The syntax is:
        `projects/[PROJECT_ID]/services/[SERVICE_ID]`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> _builtins.str:
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> _builtins.str:
        return pulumi.get(self, "service_namespace")

    @_builtins.property
    @pulumi.getter
    def telemetries(self) -> Sequence['outputs.GetClusterIstioServiceTelemetryResult']:
        """
        Configuration for how to query telemetry on the Service. Structure is documented below.
        """
        return pulumi.get(self, "telemetries")

    @_builtins.property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "user_labels")


class AwaitableGetClusterIstioServiceResult(GetClusterIstioServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterIstioServiceResult(
            cluster_name=self.cluster_name,
            display_name=self.display_name,
            id=self.id,
            location=self.location,
            name=self.name,
            project=self.project,
            service_id=self.service_id,
            service_name=self.service_name,
            service_namespace=self.service_namespace,
            telemetries=self.telemetries,
            user_labels=self.user_labels)


def get_cluster_istio_service(cluster_name: Optional[_builtins.str] = None,
                              location: Optional[_builtins.str] = None,
                              project: Optional[_builtins.str] = None,
                              service_name: Optional[_builtins.str] = None,
                              service_namespace: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterIstioServiceResult:
    """
    A Monitoring Service is the root resource under which operational aspects of a
    generic service are accessible. A service is some discrete, autonomous, and
    network-accessible unit, designed to solve an individual concern

    An Cluster Istio monitoring service is automatically created by GCP to monitor
    Cluster Istio services.

    To get more information about Service, see:

    * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services)
    * How-to Guides
        * [Service Monitoring](https://cloud.google.com/monitoring/service-monitoring)
        * [Monitoring API Documentation](https://cloud.google.com/monitoring/api/v3/)

    ## Example Usage

    ### Monitoring Cluster Istio Service

    ```python
    import pulumi
    import pulumi_gcp as gcp

    # Monitors the default ClusterIstio service
    default = gcp.monitoring.get_cluster_istio_service(location="us-west2-a",
        cluster_name="west",
        service_namespace="istio-system",
        service_name="istio-policy")
    ```


    :param _builtins.str cluster_name: The name of the Kubernetes cluster in which this Istio service 
           is defined. Corresponds to the clusterName resource label in k8s_cluster resources.
    :param _builtins.str location: The location of the Kubernetes cluster in which this Istio service 
           is defined. Corresponds to the location resource label in k8s_cluster resources.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param _builtins.str service_name: The name of the Istio service underlying this service.
           Corresponds to the destination_service_name metric label in Istio metrics.
           
           - - -
           
           Other optional fields include:
    :param _builtins.str service_namespace: The namespace of the Istio service underlying this service.
           Corresponds to the destination_service_namespace metric label in Istio metrics.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['location'] = location
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['serviceNamespace'] = service_namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:monitoring/getClusterIstioService:getClusterIstioService', __args__, opts=opts, typ=GetClusterIstioServiceResult).value

    return AwaitableGetClusterIstioServiceResult(
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        service_id=pulumi.get(__ret__, 'service_id'),
        service_name=pulumi.get(__ret__, 'service_name'),
        service_namespace=pulumi.get(__ret__, 'service_namespace'),
        telemetries=pulumi.get(__ret__, 'telemetries'),
        user_labels=pulumi.get(__ret__, 'user_labels'))
def get_cluster_istio_service_output(cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                                     location: Optional[pulumi.Input[_builtins.str]] = None,
                                     project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                     service_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterIstioServiceResult]:
    """
    A Monitoring Service is the root resource under which operational aspects of a
    generic service are accessible. A service is some discrete, autonomous, and
    network-accessible unit, designed to solve an individual concern

    An Cluster Istio monitoring service is automatically created by GCP to monitor
    Cluster Istio services.

    To get more information about Service, see:

    * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services)
    * How-to Guides
        * [Service Monitoring](https://cloud.google.com/monitoring/service-monitoring)
        * [Monitoring API Documentation](https://cloud.google.com/monitoring/api/v3/)

    ## Example Usage

    ### Monitoring Cluster Istio Service

    ```python
    import pulumi
    import pulumi_gcp as gcp

    # Monitors the default ClusterIstio service
    default = gcp.monitoring.get_cluster_istio_service(location="us-west2-a",
        cluster_name="west",
        service_namespace="istio-system",
        service_name="istio-policy")
    ```


    :param _builtins.str cluster_name: The name of the Kubernetes cluster in which this Istio service 
           is defined. Corresponds to the clusterName resource label in k8s_cluster resources.
    :param _builtins.str location: The location of the Kubernetes cluster in which this Istio service 
           is defined. Corresponds to the location resource label in k8s_cluster resources.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param _builtins.str service_name: The name of the Istio service underlying this service.
           Corresponds to the destination_service_name metric label in Istio metrics.
           
           - - -
           
           Other optional fields include:
    :param _builtins.str service_namespace: The namespace of the Istio service underlying this service.
           Corresponds to the destination_service_namespace metric label in Istio metrics.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['location'] = location
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['serviceNamespace'] = service_namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:monitoring/getClusterIstioService:getClusterIstioService', __args__, opts=opts, typ=GetClusterIstioServiceResult)
    return __ret__.apply(lambda __response__: GetClusterIstioServiceResult(
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        service_id=pulumi.get(__response__, 'service_id'),
        service_name=pulumi.get(__response__, 'service_name'),
        service_namespace=pulumi.get(__response__, 'service_namespace'),
        telemetries=pulumi.get(__response__, 'telemetries'),
        user_labels=pulumi.get(__response__, 'user_labels')))
