# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AlertPolicyAlertStrategy',
    'AlertPolicyAlertStrategyNotificationChannelStrategy',
    'AlertPolicyAlertStrategyNotificationRateLimit',
    'AlertPolicyCondition',
    'AlertPolicyConditionConditionAbsent',
    'AlertPolicyConditionConditionAbsentAggregation',
    'AlertPolicyConditionConditionAbsentTrigger',
    'AlertPolicyConditionConditionMatchedLog',
    'AlertPolicyConditionConditionMonitoringQueryLanguage',
    'AlertPolicyConditionConditionMonitoringQueryLanguageTrigger',
    'AlertPolicyConditionConditionPrometheusQueryLanguage',
    'AlertPolicyConditionConditionSql',
    'AlertPolicyConditionConditionSqlBooleanTest',
    'AlertPolicyConditionConditionSqlDaily',
    'AlertPolicyConditionConditionSqlDailyExecutionTime',
    'AlertPolicyConditionConditionSqlHourly',
    'AlertPolicyConditionConditionSqlMinutes',
    'AlertPolicyConditionConditionSqlRowCountTest',
    'AlertPolicyConditionConditionThreshold',
    'AlertPolicyConditionConditionThresholdAggregation',
    'AlertPolicyConditionConditionThresholdDenominatorAggregation',
    'AlertPolicyConditionConditionThresholdForecastOptions',
    'AlertPolicyConditionConditionThresholdTrigger',
    'AlertPolicyCreationRecord',
    'AlertPolicyDocumentation',
    'AlertPolicyDocumentationLink',
    'CustomServiceTelemetry',
    'GenericServiceBasicService',
    'GenericServiceTelemetry',
    'MetricDescriptorLabel',
    'MetricDescriptorMetadata',
    'NotificationChannelSensitiveLabels',
    'SloBasicSli',
    'SloBasicSliAvailability',
    'SloBasicSliLatency',
    'SloRequestBasedSli',
    'SloRequestBasedSliDistributionCut',
    'SloRequestBasedSliDistributionCutRange',
    'SloRequestBasedSliGoodTotalRatio',
    'SloWindowsBasedSli',
    'SloWindowsBasedSliGoodTotalRatioThreshold',
    'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance',
    'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability',
    'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency',
    'SloWindowsBasedSliGoodTotalRatioThresholdPerformance',
    'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut',
    'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange',
    'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio',
    'SloWindowsBasedSliMetricMeanInRange',
    'SloWindowsBasedSliMetricMeanInRangeRange',
    'SloWindowsBasedSliMetricSumInRange',
    'SloWindowsBasedSliMetricSumInRangeRange',
    'UptimeCheckConfigContentMatcher',
    'UptimeCheckConfigContentMatcherJsonPathMatcher',
    'UptimeCheckConfigHttpCheck',
    'UptimeCheckConfigHttpCheckAcceptedResponseStatusCode',
    'UptimeCheckConfigHttpCheckAuthInfo',
    'UptimeCheckConfigHttpCheckPingConfig',
    'UptimeCheckConfigHttpCheckServiceAgentAuthentication',
    'UptimeCheckConfigMonitoredResource',
    'UptimeCheckConfigResourceGroup',
    'UptimeCheckConfigSyntheticMonitor',
    'UptimeCheckConfigSyntheticMonitorCloudFunctionV2',
    'UptimeCheckConfigTcpCheck',
    'UptimeCheckConfigTcpCheckPingConfig',
    'GetAppEngineServiceTelemetryResult',
    'GetClusterIstioServiceTelemetryResult',
    'GetIstioCanonicalServiceTelemetryResult',
    'GetMeshIstioServiceTelemetryResult',
    'GetNotificationChannelSensitiveLabelResult',
    'GetUptimeCheckIPsUptimeCheckIpResult',
]

@pulumi.output_type
class AlertPolicyAlertStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoClose":
            suggest = "auto_close"
        elif key == "notificationChannelStrategies":
            suggest = "notification_channel_strategies"
        elif key == "notificationPrompts":
            suggest = "notification_prompts"
        elif key == "notificationRateLimit":
            suggest = "notification_rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyAlertStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyAlertStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyAlertStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_close: Optional[_builtins.str] = None,
                 notification_channel_strategies: Optional[Sequence['outputs.AlertPolicyAlertStrategyNotificationChannelStrategy']] = None,
                 notification_prompts: Optional[Sequence[_builtins.str]] = None,
                 notification_rate_limit: Optional['outputs.AlertPolicyAlertStrategyNotificationRateLimit'] = None):
        """
        :param _builtins.str auto_close: If an alert policy that was active has no data for this long, any open incidents will close.
        :param Sequence['AlertPolicyAlertStrategyNotificationChannelStrategyArgs'] notification_channel_strategies: Control over how the notification channels in `notification_channels`
               are notified when this alert fires, on a per-channel basis.
               Structure is documented below.
        :param Sequence[_builtins.str] notification_prompts: Control when notifications will be sent out.
               Each value may be one of: `NOTIFICATION_PROMPT_UNSPECIFIED`, `OPENED`, `CLOSED`.
        :param 'AlertPolicyAlertStrategyNotificationRateLimitArgs' notification_rate_limit: Required for alert policies with a LogMatch condition.
               This limit is not implemented for alert policies that are not log-based.
               Structure is documented below.
        """
        if auto_close is not None:
            pulumi.set(__self__, "auto_close", auto_close)
        if notification_channel_strategies is not None:
            pulumi.set(__self__, "notification_channel_strategies", notification_channel_strategies)
        if notification_prompts is not None:
            pulumi.set(__self__, "notification_prompts", notification_prompts)
        if notification_rate_limit is not None:
            pulumi.set(__self__, "notification_rate_limit", notification_rate_limit)

    @_builtins.property
    @pulumi.getter(name="autoClose")
    def auto_close(self) -> Optional[_builtins.str]:
        """
        If an alert policy that was active has no data for this long, any open incidents will close.
        """
        return pulumi.get(self, "auto_close")

    @_builtins.property
    @pulumi.getter(name="notificationChannelStrategies")
    def notification_channel_strategies(self) -> Optional[Sequence['outputs.AlertPolicyAlertStrategyNotificationChannelStrategy']]:
        """
        Control over how the notification channels in `notification_channels`
        are notified when this alert fires, on a per-channel basis.
        Structure is documented below.
        """
        return pulumi.get(self, "notification_channel_strategies")

    @_builtins.property
    @pulumi.getter(name="notificationPrompts")
    def notification_prompts(self) -> Optional[Sequence[_builtins.str]]:
        """
        Control when notifications will be sent out.
        Each value may be one of: `NOTIFICATION_PROMPT_UNSPECIFIED`, `OPENED`, `CLOSED`.
        """
        return pulumi.get(self, "notification_prompts")

    @_builtins.property
    @pulumi.getter(name="notificationRateLimit")
    def notification_rate_limit(self) -> Optional['outputs.AlertPolicyAlertStrategyNotificationRateLimit']:
        """
        Required for alert policies with a LogMatch condition.
        This limit is not implemented for alert policies that are not log-based.
        Structure is documented below.
        """
        return pulumi.get(self, "notification_rate_limit")


@pulumi.output_type
class AlertPolicyAlertStrategyNotificationChannelStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notificationChannelNames":
            suggest = "notification_channel_names"
        elif key == "renotifyInterval":
            suggest = "renotify_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyAlertStrategyNotificationChannelStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyAlertStrategyNotificationChannelStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyAlertStrategyNotificationChannelStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notification_channel_names: Optional[Sequence[_builtins.str]] = None,
                 renotify_interval: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] notification_channel_names: The notification channels that these settings apply to. Each of these
               correspond to the name field in one of the NotificationChannel objects
               referenced in the notification_channels field of this AlertPolicy. The format is
               `projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]`
        :param _builtins.str renotify_interval: The frequency at which to send reminder notifications for open incidents.
        """
        if notification_channel_names is not None:
            pulumi.set(__self__, "notification_channel_names", notification_channel_names)
        if renotify_interval is not None:
            pulumi.set(__self__, "renotify_interval", renotify_interval)

    @_builtins.property
    @pulumi.getter(name="notificationChannelNames")
    def notification_channel_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        The notification channels that these settings apply to. Each of these
        correspond to the name field in one of the NotificationChannel objects
        referenced in the notification_channels field of this AlertPolicy. The format is
        `projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]`
        """
        return pulumi.get(self, "notification_channel_names")

    @_builtins.property
    @pulumi.getter(name="renotifyInterval")
    def renotify_interval(self) -> Optional[_builtins.str]:
        """
        The frequency at which to send reminder notifications for open incidents.
        """
        return pulumi.get(self, "renotify_interval")


@pulumi.output_type
class AlertPolicyAlertStrategyNotificationRateLimit(dict):
    def __init__(__self__, *,
                 period: Optional[_builtins.str] = None):
        """
        :param _builtins.str period: Not more than one notification per period.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example "60.5s".
        """
        if period is not None:
            pulumi.set(__self__, "period", period)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.str]:
        """
        Not more than one notification per period.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example "60.5s".
        """
        return pulumi.get(self, "period")


@pulumi.output_type
class AlertPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "conditionAbsent":
            suggest = "condition_absent"
        elif key == "conditionMatchedLog":
            suggest = "condition_matched_log"
        elif key == "conditionMonitoringQueryLanguage":
            suggest = "condition_monitoring_query_language"
        elif key == "conditionPrometheusQueryLanguage":
            suggest = "condition_prometheus_query_language"
        elif key == "conditionSql":
            suggest = "condition_sql"
        elif key == "conditionThreshold":
            suggest = "condition_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: _builtins.str,
                 condition_absent: Optional['outputs.AlertPolicyConditionConditionAbsent'] = None,
                 condition_matched_log: Optional['outputs.AlertPolicyConditionConditionMatchedLog'] = None,
                 condition_monitoring_query_language: Optional['outputs.AlertPolicyConditionConditionMonitoringQueryLanguage'] = None,
                 condition_prometheus_query_language: Optional['outputs.AlertPolicyConditionConditionPrometheusQueryLanguage'] = None,
                 condition_sql: Optional['outputs.AlertPolicyConditionConditionSql'] = None,
                 condition_threshold: Optional['outputs.AlertPolicyConditionConditionThreshold'] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: A short name or phrase used to identify the
               condition in dashboards, notifications, and
               incidents. To avoid confusion, don't use the same
               display name for multiple conditions in the same
               policy.
        :param 'AlertPolicyConditionConditionAbsentArgs' condition_absent: A condition that checks that a time series
               continues to receive new data points.
               Structure is documented below.
        :param 'AlertPolicyConditionConditionMatchedLogArgs' condition_matched_log: A condition that checks for log messages matching given constraints.
               If set, no other conditions can be present.
               Structure is documented below.
        :param 'AlertPolicyConditionConditionMonitoringQueryLanguageArgs' condition_monitoring_query_language: A Monitoring Query Language query that outputs a boolean stream
               Structure is documented below.
        :param 'AlertPolicyConditionConditionPrometheusQueryLanguageArgs' condition_prometheus_query_language: A condition type that allows alert policies to be defined using
               Prometheus Query Language (PromQL).
               The PrometheusQueryLanguageCondition message contains information
               from a Prometheus alerting rule and its associated rule group.
               Structure is documented below.
        :param 'AlertPolicyConditionConditionSqlArgs' condition_sql: A condition that allows alerting policies to be defined using GoogleSQL.
               SQL conditions examine a sliding window of logs using GoogleSQL.
               Alert policies with SQL conditions may incur additional billing.
               Structure is documented below.
        :param 'AlertPolicyConditionConditionThresholdArgs' condition_threshold: A condition that compares a time series against a
               threshold.
               Structure is documented below.
        :param _builtins.str name: (Output)
               The unique resource name for this condition.
               Its syntax is:
               projects/[PROJECT_ID]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
               [CONDITION_ID] is assigned by Stackdriver Monitoring when
               the condition is created as part of a new or updated alerting
               policy.
        """
        pulumi.set(__self__, "display_name", display_name)
        if condition_absent is not None:
            pulumi.set(__self__, "condition_absent", condition_absent)
        if condition_matched_log is not None:
            pulumi.set(__self__, "condition_matched_log", condition_matched_log)
        if condition_monitoring_query_language is not None:
            pulumi.set(__self__, "condition_monitoring_query_language", condition_monitoring_query_language)
        if condition_prometheus_query_language is not None:
            pulumi.set(__self__, "condition_prometheus_query_language", condition_prometheus_query_language)
        if condition_sql is not None:
            pulumi.set(__self__, "condition_sql", condition_sql)
        if condition_threshold is not None:
            pulumi.set(__self__, "condition_threshold", condition_threshold)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A short name or phrase used to identify the
        condition in dashboards, notifications, and
        incidents. To avoid confusion, don't use the same
        display name for multiple conditions in the same
        policy.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="conditionAbsent")
    def condition_absent(self) -> Optional['outputs.AlertPolicyConditionConditionAbsent']:
        """
        A condition that checks that a time series
        continues to receive new data points.
        Structure is documented below.
        """
        return pulumi.get(self, "condition_absent")

    @_builtins.property
    @pulumi.getter(name="conditionMatchedLog")
    def condition_matched_log(self) -> Optional['outputs.AlertPolicyConditionConditionMatchedLog']:
        """
        A condition that checks for log messages matching given constraints.
        If set, no other conditions can be present.
        Structure is documented below.
        """
        return pulumi.get(self, "condition_matched_log")

    @_builtins.property
    @pulumi.getter(name="conditionMonitoringQueryLanguage")
    def condition_monitoring_query_language(self) -> Optional['outputs.AlertPolicyConditionConditionMonitoringQueryLanguage']:
        """
        A Monitoring Query Language query that outputs a boolean stream
        Structure is documented below.
        """
        return pulumi.get(self, "condition_monitoring_query_language")

    @_builtins.property
    @pulumi.getter(name="conditionPrometheusQueryLanguage")
    def condition_prometheus_query_language(self) -> Optional['outputs.AlertPolicyConditionConditionPrometheusQueryLanguage']:
        """
        A condition type that allows alert policies to be defined using
        Prometheus Query Language (PromQL).
        The PrometheusQueryLanguageCondition message contains information
        from a Prometheus alerting rule and its associated rule group.
        Structure is documented below.
        """
        return pulumi.get(self, "condition_prometheus_query_language")

    @_builtins.property
    @pulumi.getter(name="conditionSql")
    def condition_sql(self) -> Optional['outputs.AlertPolicyConditionConditionSql']:
        """
        A condition that allows alerting policies to be defined using GoogleSQL.
        SQL conditions examine a sliding window of logs using GoogleSQL.
        Alert policies with SQL conditions may incur additional billing.
        Structure is documented below.
        """
        return pulumi.get(self, "condition_sql")

    @_builtins.property
    @pulumi.getter(name="conditionThreshold")
    def condition_threshold(self) -> Optional['outputs.AlertPolicyConditionConditionThreshold']:
        """
        A condition that compares a time series against a
        threshold.
        Structure is documented below.
        """
        return pulumi.get(self, "condition_threshold")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Output)
        The unique resource name for this condition.
        Its syntax is:
        projects/[PROJECT_ID]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
        [CONDITION_ID] is assigned by Stackdriver Monitoring when
        the condition is created as part of a new or updated alerting
        policy.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AlertPolicyConditionConditionAbsent(dict):
    def __init__(__self__, *,
                 duration: _builtins.str,
                 aggregations: Optional[Sequence['outputs.AlertPolicyConditionConditionAbsentAggregation']] = None,
                 filter: Optional[_builtins.str] = None,
                 trigger: Optional['outputs.AlertPolicyConditionConditionAbsentTrigger'] = None):
        """
        :param _builtins.str duration: The amount of time that a time series must
               fail to report new data to be considered
               failing. Currently, only values that are a
               multiple of a minute--e.g. 60s, 120s, or 300s
               --are supported.
        :param Sequence['AlertPolicyConditionConditionAbsentAggregationArgs'] aggregations: Specifies the alignment of data points in
               individual time series as well as how to
               combine the retrieved time series together
               (such as when aggregating multiple streams
               on each resource to a single stream for each
               resource or when aggregating streams across
               all members of a group of resources).
               Multiple aggregations are applied in the
               order specified.
               Structure is documented below.
        :param _builtins.str filter: A filter that identifies which time series
               should be compared with the threshold.The
               filter is similar to the one that is
               specified in the
               MetricService.ListTimeSeries request (that
               call is useful to verify the time series
               that will be retrieved / processed) and must
               specify the metric type and optionally may
               contain restrictions on resource type,
               resource labels, and metric labels. This
               field may not exceed 2048 Unicode characters
               in length.
        :param 'AlertPolicyConditionConditionAbsentTriggerArgs' trigger: The number/percent of time series for which
               the comparison must hold in order for the
               condition to trigger. If unspecified, then
               the condition will trigger if the comparison
               is true for any of the time series that have
               been identified by filter and aggregations.
               Structure is documented below.
        """
        pulumi.set(__self__, "duration", duration)
        if aggregations is not None:
            pulumi.set(__self__, "aggregations", aggregations)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The amount of time that a time series must
        fail to report new data to be considered
        failing. Currently, only values that are a
        multiple of a minute--e.g. 60s, 120s, or 300s
        --are supported.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def aggregations(self) -> Optional[Sequence['outputs.AlertPolicyConditionConditionAbsentAggregation']]:
        """
        Specifies the alignment of data points in
        individual time series as well as how to
        combine the retrieved time series together
        (such as when aggregating multiple streams
        on each resource to a single stream for each
        resource or when aggregating streams across
        all members of a group of resources).
        Multiple aggregations are applied in the
        order specified.
        Structure is documented below.
        """
        return pulumi.get(self, "aggregations")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        """
        A filter that identifies which time series
        should be compared with the threshold.The
        filter is similar to the one that is
        specified in the
        MetricService.ListTimeSeries request (that
        call is useful to verify the time series
        that will be retrieved / processed) and must
        specify the metric type and optionally may
        contain restrictions on resource type,
        resource labels, and metric labels. This
        field may not exceed 2048 Unicode characters
        in length.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> Optional['outputs.AlertPolicyConditionConditionAbsentTrigger']:
        """
        The number/percent of time series for which
        the comparison must hold in order for the
        condition to trigger. If unspecified, then
        the condition will trigger if the comparison
        is true for any of the time series that have
        been identified by filter and aggregations.
        Structure is documented below.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class AlertPolicyConditionConditionAbsentAggregation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alignmentPeriod":
            suggest = "alignment_period"
        elif key == "crossSeriesReducer":
            suggest = "cross_series_reducer"
        elif key == "groupByFields":
            suggest = "group_by_fields"
        elif key == "perSeriesAligner":
            suggest = "per_series_aligner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionAbsentAggregation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionAbsentAggregation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionAbsentAggregation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alignment_period: Optional[_builtins.str] = None,
                 cross_series_reducer: Optional[_builtins.str] = None,
                 group_by_fields: Optional[Sequence[_builtins.str]] = None,
                 per_series_aligner: Optional[_builtins.str] = None):
        """
        :param _builtins.str alignment_period: The alignment period for per-time
               series alignment. If present,
               alignmentPeriod must be at least
               60 seconds. After per-time series
               alignment, each time series will
               contain data points only on the
               period boundaries. If
               perSeriesAligner is not specified
               or equals ALIGN_NONE, then this
               field is ignored. If
               perSeriesAligner is specified and
               does not equal ALIGN_NONE, then
               this field must be defined;
               otherwise an error is returned.
        :param _builtins.str cross_series_reducer: The approach to be used to combine
               time series. Not all reducer
               functions may be applied to all
               time series, depending on the
               metric type and the value type of
               the original time series.
               Reduction may change the metric
               type of value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are: `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, `REDUCE_PERCENTILE_05`.
        :param Sequence[_builtins.str] group_by_fields: The set of fields to preserve when
               crossSeriesReducer is specified.
               The groupByFields determine how
               the time series are partitioned
               into subsets prior to applying the
               aggregation function. Each subset
               contains time series that have the
               same value for each of the
               grouping fields. Each individual
               time series is a member of exactly
               one subset. The crossSeriesReducer
               is applied to each subset of time
               series. It is not possible to
               reduce across different resource
               types, so this field implicitly
               contains resource.type. Fields not
               specified in groupByFields are
               aggregated away. If groupByFields
               is not specified and all the time
               series have the same resource
               type, then the time series are
               aggregated into a single output
               time series. If crossSeriesReducer
               is not defined, this field is
               ignored.
        :param _builtins.str per_series_aligner: The approach to be used to align
               individual time series. Not all
               alignment functions may be applied
               to all time series, depending on
               the metric type and value type of
               the original time series.
               Alignment may change the metric
               type or the value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are: `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, `ALIGN_PERCENT_CHANGE`.
        """
        if alignment_period is not None:
            pulumi.set(__self__, "alignment_period", alignment_period)
        if cross_series_reducer is not None:
            pulumi.set(__self__, "cross_series_reducer", cross_series_reducer)
        if group_by_fields is not None:
            pulumi.set(__self__, "group_by_fields", group_by_fields)
        if per_series_aligner is not None:
            pulumi.set(__self__, "per_series_aligner", per_series_aligner)

    @_builtins.property
    @pulumi.getter(name="alignmentPeriod")
    def alignment_period(self) -> Optional[_builtins.str]:
        """
        The alignment period for per-time
        series alignment. If present,
        alignmentPeriod must be at least
        60 seconds. After per-time series
        alignment, each time series will
        contain data points only on the
        period boundaries. If
        perSeriesAligner is not specified
        or equals ALIGN_NONE, then this
        field is ignored. If
        perSeriesAligner is specified and
        does not equal ALIGN_NONE, then
        this field must be defined;
        otherwise an error is returned.
        """
        return pulumi.get(self, "alignment_period")

    @_builtins.property
    @pulumi.getter(name="crossSeriesReducer")
    def cross_series_reducer(self) -> Optional[_builtins.str]:
        """
        The approach to be used to combine
        time series. Not all reducer
        functions may be applied to all
        time series, depending on the
        metric type and the value type of
        the original time series.
        Reduction may change the metric
        type of value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are: `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, `REDUCE_PERCENTILE_05`.
        """
        return pulumi.get(self, "cross_series_reducer")

    @_builtins.property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[Sequence[_builtins.str]]:
        """
        The set of fields to preserve when
        crossSeriesReducer is specified.
        The groupByFields determine how
        the time series are partitioned
        into subsets prior to applying the
        aggregation function. Each subset
        contains time series that have the
        same value for each of the
        grouping fields. Each individual
        time series is a member of exactly
        one subset. The crossSeriesReducer
        is applied to each subset of time
        series. It is not possible to
        reduce across different resource
        types, so this field implicitly
        contains resource.type. Fields not
        specified in groupByFields are
        aggregated away. If groupByFields
        is not specified and all the time
        series have the same resource
        type, then the time series are
        aggregated into a single output
        time series. If crossSeriesReducer
        is not defined, this field is
        ignored.
        """
        return pulumi.get(self, "group_by_fields")

    @_builtins.property
    @pulumi.getter(name="perSeriesAligner")
    def per_series_aligner(self) -> Optional[_builtins.str]:
        """
        The approach to be used to align
        individual time series. Not all
        alignment functions may be applied
        to all time series, depending on
        the metric type and value type of
        the original time series.
        Alignment may change the metric
        type or the value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are: `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, `ALIGN_PERCENT_CHANGE`.
        """
        return pulumi.get(self, "per_series_aligner")


@pulumi.output_type
class AlertPolicyConditionConditionAbsentTrigger(dict):
    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 percent: Optional[_builtins.float] = None):
        """
        :param _builtins.int count: The absolute number of time series
               that must fail the predicate for the
               condition to be triggered.
        :param _builtins.float percent: The percentage of time series that
               must fail the predicate for the
               condition to be triggered.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        The absolute number of time series
        that must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def percent(self) -> Optional[_builtins.float]:
        """
        The percentage of time series that
        must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class AlertPolicyConditionConditionMatchedLog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelExtractors":
            suggest = "label_extractors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionMatchedLog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionMatchedLog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionMatchedLog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: _builtins.str,
                 label_extractors: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str filter: A logs-based filter.
        :param Mapping[str, _builtins.str] label_extractors: A map from a label key to an extractor expression, which is used to
               extract the value for this label key. Each entry in this map is
               a specification for how data should be extracted from log entries that
               match filter. Each combination of extracted values is treated as
               a separate rule for the purposes of triggering notifications.
               Label keys and corresponding values can be used in notifications
               generated by this condition.
        """
        pulumi.set(__self__, "filter", filter)
        if label_extractors is not None:
            pulumi.set(__self__, "label_extractors", label_extractors)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> _builtins.str:
        """
        A logs-based filter.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="labelExtractors")
    def label_extractors(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map from a label key to an extractor expression, which is used to
        extract the value for this label key. Each entry in this map is
        a specification for how data should be extracted from log entries that
        match filter. Each combination of extracted values is treated as
        a separate rule for the purposes of triggering notifications.
        Label keys and corresponding values can be used in notifications
        generated by this condition.
        """
        return pulumi.get(self, "label_extractors")


@pulumi.output_type
class AlertPolicyConditionConditionMonitoringQueryLanguage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationMissingData":
            suggest = "evaluation_missing_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionMonitoringQueryLanguage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionMonitoringQueryLanguage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionMonitoringQueryLanguage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 query: _builtins.str,
                 evaluation_missing_data: Optional[_builtins.str] = None,
                 trigger: Optional['outputs.AlertPolicyConditionConditionMonitoringQueryLanguageTrigger'] = None):
        """
        :param _builtins.str duration: The amount of time that a time series must
               violate the threshold to be considered
               failing. Currently, only values that are a
               multiple of a minute--e.g., 0, 60, 120, or
               300 seconds--are supported. If an invalid
               value is given, an error will be returned.
               When choosing a duration, it is useful to
               keep in mind the frequency of the underlying
               time series data (which may also be affected
               by any alignments specified in the
               aggregations field); a good duration is long
               enough so that a single outlier does not
               generate spurious alerts, but short enough
               that unhealthy states are detected and
               alerted on quickly.
        :param _builtins.str query: Monitoring Query Language query that outputs a boolean stream.
        :param _builtins.str evaluation_missing_data: A condition control that determines how
               metric-threshold conditions are evaluated when
               data stops arriving.
               Possible values are: `EVALUATION_MISSING_DATA_INACTIVE`, `EVALUATION_MISSING_DATA_ACTIVE`, `EVALUATION_MISSING_DATA_NO_OP`.
        :param 'AlertPolicyConditionConditionMonitoringQueryLanguageTriggerArgs' trigger: The number/percent of time series for which
               the comparison must hold in order for the
               condition to trigger. If unspecified, then
               the condition will trigger if the comparison
               is true for any of the time series that have
               been identified by filter and aggregations,
               or by the ratio, if denominator_filter and
               denominator_aggregations are specified.
               Structure is documented below.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "query", query)
        if evaluation_missing_data is not None:
            pulumi.set(__self__, "evaluation_missing_data", evaluation_missing_data)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The amount of time that a time series must
        violate the threshold to be considered
        failing. Currently, only values that are a
        multiple of a minute--e.g., 0, 60, 120, or
        300 seconds--are supported. If an invalid
        value is given, an error will be returned.
        When choosing a duration, it is useful to
        keep in mind the frequency of the underlying
        time series data (which may also be affected
        by any alignments specified in the
        aggregations field); a good duration is long
        enough so that a single outlier does not
        generate spurious alerts, but short enough
        that unhealthy states are detected and
        alerted on quickly.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        Monitoring Query Language query that outputs a boolean stream.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="evaluationMissingData")
    def evaluation_missing_data(self) -> Optional[_builtins.str]:
        """
        A condition control that determines how
        metric-threshold conditions are evaluated when
        data stops arriving.
        Possible values are: `EVALUATION_MISSING_DATA_INACTIVE`, `EVALUATION_MISSING_DATA_ACTIVE`, `EVALUATION_MISSING_DATA_NO_OP`.
        """
        return pulumi.get(self, "evaluation_missing_data")

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> Optional['outputs.AlertPolicyConditionConditionMonitoringQueryLanguageTrigger']:
        """
        The number/percent of time series for which
        the comparison must hold in order for the
        condition to trigger. If unspecified, then
        the condition will trigger if the comparison
        is true for any of the time series that have
        been identified by filter and aggregations,
        or by the ratio, if denominator_filter and
        denominator_aggregations are specified.
        Structure is documented below.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class AlertPolicyConditionConditionMonitoringQueryLanguageTrigger(dict):
    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 percent: Optional[_builtins.float] = None):
        """
        :param _builtins.int count: The absolute number of time series
               that must fail the predicate for the
               condition to be triggered.
        :param _builtins.float percent: The percentage of time series that
               must fail the predicate for the
               condition to be triggered.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        The absolute number of time series
        that must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def percent(self) -> Optional[_builtins.float]:
        """
        The percentage of time series that
        must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class AlertPolicyConditionConditionPrometheusQueryLanguage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertRule":
            suggest = "alert_rule"
        elif key == "disableMetricValidation":
            suggest = "disable_metric_validation"
        elif key == "evaluationInterval":
            suggest = "evaluation_interval"
        elif key == "ruleGroup":
            suggest = "rule_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionPrometheusQueryLanguage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionPrometheusQueryLanguage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionPrometheusQueryLanguage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query: _builtins.str,
                 alert_rule: Optional[_builtins.str] = None,
                 disable_metric_validation: Optional[_builtins.bool] = None,
                 duration: Optional[_builtins.str] = None,
                 evaluation_interval: Optional[_builtins.str] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 rule_group: Optional[_builtins.str] = None):
        """
        :param _builtins.str query: The PromQL expression to evaluate. Every evaluation cycle this
               expression is evaluated at the current time, and all resultant time
               series become pending/firing alerts. This field must not be empty.
        :param _builtins.str alert_rule: The alerting rule name of this alert in the corresponding Prometheus
               configuration file.
               Some external tools may require this field to be populated correctly
               in order to refer to the original Prometheus configuration file.
               The rule group name and the alert name are necessary to update the
               relevant AlertPolicies in case the definition of the rule group changes
               in the future.
               This field is optional. If this field is not empty, then it must be a
               valid Prometheus label name.
        :param _builtins.str duration: Alerts are considered firing once their PromQL expression evaluated
               to be "true" for this long. Alerts whose PromQL expression was not
               evaluated to be "true" for long enough are considered pending. The
               default value is zero. Must be zero or positive.
        :param _builtins.str evaluation_interval: How often this rule should be evaluated. Must be a positive multiple
               of 30 seconds or missing. The default value is 30 seconds. If this
               PrometheusQueryLanguageCondition was generated from a Prometheus
               alerting rule, then this value should be taken from the enclosing
               rule group.
        :param Mapping[str, _builtins.str] labels: Labels to add to or overwrite in the PromQL query result. Label names
               must be valid.
               Label values can be templatized by using variables. The only available
               variable names are the names of the labels in the PromQL result,
               although label names beginning with \\_\\_ (two "\\_") are reserved for
               internal use. "labels" may be empty. This field is intended to be used
               for organizing and identifying the AlertPolicy.
        :param _builtins.str rule_group: The rule group name of this alert in the corresponding Prometheus
               configuration file.
               Some external tools may require this field to be populated correctly
               in order to refer to the original Prometheus configuration file.
               The rule group name and the alert name are necessary to update the
               relevant AlertPolicies in case the definition of the rule group changes
               in the future. This field is optional.
        """
        pulumi.set(__self__, "query", query)
        if alert_rule is not None:
            pulumi.set(__self__, "alert_rule", alert_rule)
        if disable_metric_validation is not None:
            pulumi.set(__self__, "disable_metric_validation", disable_metric_validation)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if rule_group is not None:
            pulumi.set(__self__, "rule_group", rule_group)

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        The PromQL expression to evaluate. Every evaluation cycle this
        expression is evaluated at the current time, and all resultant time
        series become pending/firing alerts. This field must not be empty.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="alertRule")
    def alert_rule(self) -> Optional[_builtins.str]:
        """
        The alerting rule name of this alert in the corresponding Prometheus
        configuration file.
        Some external tools may require this field to be populated correctly
        in order to refer to the original Prometheus configuration file.
        The rule group name and the alert name are necessary to update the
        relevant AlertPolicies in case the definition of the rule group changes
        in the future.
        This field is optional. If this field is not empty, then it must be a
        valid Prometheus label name.
        """
        return pulumi.get(self, "alert_rule")

    @_builtins.property
    @pulumi.getter(name="disableMetricValidation")
    def disable_metric_validation(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "disable_metric_validation")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        Alerts are considered firing once their PromQL expression evaluated
        to be "true" for this long. Alerts whose PromQL expression was not
        evaluated to be "true" for long enough are considered pending. The
        default value is zero. Must be zero or positive.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[_builtins.str]:
        """
        How often this rule should be evaluated. Must be a positive multiple
        of 30 seconds or missing. The default value is 30 seconds. If this
        PrometheusQueryLanguageCondition was generated from a Prometheus
        alerting rule, then this value should be taken from the enclosing
        rule group.
        """
        return pulumi.get(self, "evaluation_interval")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Labels to add to or overwrite in the PromQL query result. Label names
        must be valid.
        Label values can be templatized by using variables. The only available
        variable names are the names of the labels in the PromQL result,
        although label names beginning with \\_\\_ (two "\\_") are reserved for
        internal use. "labels" may be empty. This field is intended to be used
        for organizing and identifying the AlertPolicy.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="ruleGroup")
    def rule_group(self) -> Optional[_builtins.str]:
        """
        The rule group name of this alert in the corresponding Prometheus
        configuration file.
        Some external tools may require this field to be populated correctly
        in order to refer to the original Prometheus configuration file.
        The rule group name and the alert name are necessary to update the
        relevant AlertPolicies in case the definition of the rule group changes
        in the future. This field is optional.
        """
        return pulumi.get(self, "rule_group")


@pulumi.output_type
class AlertPolicyConditionConditionSql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanTest":
            suggest = "boolean_test"
        elif key == "rowCountTest":
            suggest = "row_count_test"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionSql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionSql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionSql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query: _builtins.str,
                 boolean_test: Optional['outputs.AlertPolicyConditionConditionSqlBooleanTest'] = None,
                 daily: Optional['outputs.AlertPolicyConditionConditionSqlDaily'] = None,
                 hourly: Optional['outputs.AlertPolicyConditionConditionSqlHourly'] = None,
                 minutes: Optional['outputs.AlertPolicyConditionConditionSqlMinutes'] = None,
                 row_count_test: Optional['outputs.AlertPolicyConditionConditionSqlRowCountTest'] = None):
        """
        :param _builtins.str query: The Log Analytics SQL query to run, as a string.  The query must
               conform to the required shape. Specifically, the query must not try to
               filter the input by time.  A filter will automatically be applied
               to filter the input so that the query receives all rows received
               since the last time the query was run.
        :param 'AlertPolicyConditionConditionSqlBooleanTestArgs' boolean_test: A test that uses an alerting result in a boolean column produced by the SQL query.
               Structure is documented below.
        :param 'AlertPolicyConditionConditionSqlDailyArgs' daily: Used to schedule the query to run every so many days.
               Structure is documented below.
        :param 'AlertPolicyConditionConditionSqlHourlyArgs' hourly: Used to schedule the query to run every so many hours.
               Structure is documented below.
        :param 'AlertPolicyConditionConditionSqlMinutesArgs' minutes: Used to schedule the query to run every so many minutes.
               Structure is documented below.
        :param 'AlertPolicyConditionConditionSqlRowCountTestArgs' row_count_test: A test that checks if the number of rows in the result set violates some threshold.
               Structure is documented below.
        """
        pulumi.set(__self__, "query", query)
        if boolean_test is not None:
            pulumi.set(__self__, "boolean_test", boolean_test)
        if daily is not None:
            pulumi.set(__self__, "daily", daily)
        if hourly is not None:
            pulumi.set(__self__, "hourly", hourly)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if row_count_test is not None:
            pulumi.set(__self__, "row_count_test", row_count_test)

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        The Log Analytics SQL query to run, as a string.  The query must
        conform to the required shape. Specifically, the query must not try to
        filter the input by time.  A filter will automatically be applied
        to filter the input so that the query receives all rows received
        since the last time the query was run.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="booleanTest")
    def boolean_test(self) -> Optional['outputs.AlertPolicyConditionConditionSqlBooleanTest']:
        """
        A test that uses an alerting result in a boolean column produced by the SQL query.
        Structure is documented below.
        """
        return pulumi.get(self, "boolean_test")

    @_builtins.property
    @pulumi.getter
    def daily(self) -> Optional['outputs.AlertPolicyConditionConditionSqlDaily']:
        """
        Used to schedule the query to run every so many days.
        Structure is documented below.
        """
        return pulumi.get(self, "daily")

    @_builtins.property
    @pulumi.getter
    def hourly(self) -> Optional['outputs.AlertPolicyConditionConditionSqlHourly']:
        """
        Used to schedule the query to run every so many hours.
        Structure is documented below.
        """
        return pulumi.get(self, "hourly")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> Optional['outputs.AlertPolicyConditionConditionSqlMinutes']:
        """
        Used to schedule the query to run every so many minutes.
        Structure is documented below.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter(name="rowCountTest")
    def row_count_test(self) -> Optional['outputs.AlertPolicyConditionConditionSqlRowCountTest']:
        """
        A test that checks if the number of rows in the result set violates some threshold.
        Structure is documented below.
        """
        return pulumi.get(self, "row_count_test")


@pulumi.output_type
class AlertPolicyConditionConditionSqlBooleanTest(dict):
    def __init__(__self__, *,
                 column: _builtins.str):
        """
        :param _builtins.str column: The name of the column containing the boolean value. If the value in a row is
               NULL, that row is ignored.
        """
        pulumi.set(__self__, "column", column)

    @_builtins.property
    @pulumi.getter
    def column(self) -> _builtins.str:
        """
        The name of the column containing the boolean value. If the value in a row is
        NULL, that row is ignored.
        """
        return pulumi.get(self, "column")


@pulumi.output_type
class AlertPolicyConditionConditionSqlDaily(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionTime":
            suggest = "execution_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionSqlDaily. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionSqlDaily.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionSqlDaily.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 periodicity: _builtins.int,
                 execution_time: Optional['outputs.AlertPolicyConditionConditionSqlDailyExecutionTime'] = None):
        """
        :param _builtins.int periodicity: The number of days between runs. Must be greater than or equal
               to 1 day and less than or equal to 30 days.
        :param 'AlertPolicyConditionConditionSqlDailyExecutionTimeArgs' execution_time: The time of day (in UTC) at which the query should run. If left
               unspecified, the server picks an arbitrary time of day and runs
               the query at the same time each day.
               Structure is documented below.
        """
        pulumi.set(__self__, "periodicity", periodicity)
        if execution_time is not None:
            pulumi.set(__self__, "execution_time", execution_time)

    @_builtins.property
    @pulumi.getter
    def periodicity(self) -> _builtins.int:
        """
        The number of days between runs. Must be greater than or equal
        to 1 day and less than or equal to 30 days.
        """
        return pulumi.get(self, "periodicity")

    @_builtins.property
    @pulumi.getter(name="executionTime")
    def execution_time(self) -> Optional['outputs.AlertPolicyConditionConditionSqlDailyExecutionTime']:
        """
        The time of day (in UTC) at which the query should run. If left
        unspecified, the server picks an arbitrary time of day and runs
        the query at the same time each day.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_time")


@pulumi.output_type
class AlertPolicyConditionConditionSqlDailyExecutionTime(dict):
    def __init__(__self__, *,
                 hours: Optional[_builtins.int] = None,
                 minutes: Optional[_builtins.int] = None,
                 nanos: Optional[_builtins.int] = None,
                 seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.int hours: Hours of a day in 24 hour format. Must be greater than or equal
               to 0 and typically must be less than or equal to 23. An API may
               choose to allow the value "24:00:00" for scenarios like business
               closing time.
        :param _builtins.int minutes: Minutes of an hour. Must be greater than or equal to 0 and
               less than or equal to 59.
        :param _builtins.int nanos: Fractions of seconds, in nanoseconds. Must be greater than or
               equal to 0 and less than or equal to 999,999,999.
        :param _builtins.int seconds: Seconds of a minute. Must be greater than or equal to 0 and
               typically must be less than or equal to 59. An API may allow the
               value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> Optional[_builtins.int]:
        """
        Hours of a day in 24 hour format. Must be greater than or equal
        to 0 and typically must be less than or equal to 23. An API may
        choose to allow the value "24:00:00" for scenarios like business
        closing time.
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> Optional[_builtins.int]:
        """
        Minutes of an hour. Must be greater than or equal to 0 and
        less than or equal to 59.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def nanos(self) -> Optional[_builtins.int]:
        """
        Fractions of seconds, in nanoseconds. Must be greater than or
        equal to 0 and less than or equal to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @_builtins.property
    @pulumi.getter
    def seconds(self) -> Optional[_builtins.int]:
        """
        Seconds of a minute. Must be greater than or equal to 0 and
        typically must be less than or equal to 59. An API may allow the
        value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class AlertPolicyConditionConditionSqlHourly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minuteOffset":
            suggest = "minute_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionSqlHourly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionSqlHourly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionSqlHourly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 periodicity: _builtins.int,
                 minute_offset: Optional[_builtins.int] = None):
        """
        :param _builtins.int periodicity: Number of hours between runs. The interval must be greater than or
               equal to 1 hour and less than or equal to 48 hours.
        :param _builtins.int minute_offset: The number of minutes after the hour (in UTC) to run the query.
               Must be greater than or equal to 0 minutes and less than or equal to
               59 minutes.  If left unspecified, then an arbitrary offset is used.
        """
        pulumi.set(__self__, "periodicity", periodicity)
        if minute_offset is not None:
            pulumi.set(__self__, "minute_offset", minute_offset)

    @_builtins.property
    @pulumi.getter
    def periodicity(self) -> _builtins.int:
        """
        Number of hours between runs. The interval must be greater than or
        equal to 1 hour and less than or equal to 48 hours.
        """
        return pulumi.get(self, "periodicity")

    @_builtins.property
    @pulumi.getter(name="minuteOffset")
    def minute_offset(self) -> Optional[_builtins.int]:
        """
        The number of minutes after the hour (in UTC) to run the query.
        Must be greater than or equal to 0 minutes and less than or equal to
        59 minutes.  If left unspecified, then an arbitrary offset is used.
        """
        return pulumi.get(self, "minute_offset")


@pulumi.output_type
class AlertPolicyConditionConditionSqlMinutes(dict):
    def __init__(__self__, *,
                 periodicity: _builtins.int):
        """
        :param _builtins.int periodicity: Number of minutes between runs. The interval must be greater than or
               equal to 5 minutes and less than or equal to 1440 minutes.
        """
        pulumi.set(__self__, "periodicity", periodicity)

    @_builtins.property
    @pulumi.getter
    def periodicity(self) -> _builtins.int:
        """
        Number of minutes between runs. The interval must be greater than or
        equal to 5 minutes and less than or equal to 1440 minutes.
        """
        return pulumi.get(self, "periodicity")


@pulumi.output_type
class AlertPolicyConditionConditionSqlRowCountTest(dict):
    def __init__(__self__, *,
                 comparison: _builtins.str,
                 threshold: _builtins.int):
        """
        :param _builtins.str comparison: The comparison to apply between the time
               series (indicated by filter and aggregation)
               and the threshold (indicated by
               threshold_value). The comparison is applied
               on each time series, with the time series on
               the left-hand side and the threshold on the
               right-hand side. Only COMPARISON_LT and
               COMPARISON_GT are supported currently.
               Possible values are: `COMPARISON_GT`, `COMPARISON_GE`, `COMPARISON_LT`, `COMPARISON_LE`, `COMPARISON_EQ`, `COMPARISON_NE`.
        :param _builtins.int threshold: The value against which to compare the row count.
        """
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def comparison(self) -> _builtins.str:
        """
        The comparison to apply between the time
        series (indicated by filter and aggregation)
        and the threshold (indicated by
        threshold_value). The comparison is applied
        on each time series, with the time series on
        the left-hand side and the threshold on the
        right-hand side. Only COMPARISON_LT and
        COMPARISON_GT are supported currently.
        Possible values are: `COMPARISON_GT`, `COMPARISON_GE`, `COMPARISON_LT`, `COMPARISON_LE`, `COMPARISON_EQ`, `COMPARISON_NE`.
        """
        return pulumi.get(self, "comparison")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.int:
        """
        The value against which to compare the row count.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class AlertPolicyConditionConditionThreshold(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "denominatorAggregations":
            suggest = "denominator_aggregations"
        elif key == "denominatorFilter":
            suggest = "denominator_filter"
        elif key == "evaluationMissingData":
            suggest = "evaluation_missing_data"
        elif key == "forecastOptions":
            suggest = "forecast_options"
        elif key == "thresholdValue":
            suggest = "threshold_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionThreshold. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionThreshold.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionThreshold.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparison: _builtins.str,
                 duration: _builtins.str,
                 aggregations: Optional[Sequence['outputs.AlertPolicyConditionConditionThresholdAggregation']] = None,
                 denominator_aggregations: Optional[Sequence['outputs.AlertPolicyConditionConditionThresholdDenominatorAggregation']] = None,
                 denominator_filter: Optional[_builtins.str] = None,
                 evaluation_missing_data: Optional[_builtins.str] = None,
                 filter: Optional[_builtins.str] = None,
                 forecast_options: Optional['outputs.AlertPolicyConditionConditionThresholdForecastOptions'] = None,
                 threshold_value: Optional[_builtins.float] = None,
                 trigger: Optional['outputs.AlertPolicyConditionConditionThresholdTrigger'] = None):
        """
        :param _builtins.str comparison: The comparison to apply between the time
               series (indicated by filter and aggregation)
               and the threshold (indicated by
               threshold_value). The comparison is applied
               on each time series, with the time series on
               the left-hand side and the threshold on the
               right-hand side. Only COMPARISON_LT and
               COMPARISON_GT are supported currently.
               Possible values are: `COMPARISON_GT`, `COMPARISON_GE`, `COMPARISON_LT`, `COMPARISON_LE`, `COMPARISON_EQ`, `COMPARISON_NE`.
        :param _builtins.str duration: The amount of time that a time series must
               violate the threshold to be considered
               failing. Currently, only values that are a
               multiple of a minute--e.g., 0, 60, 120, or
               300 seconds--are supported. If an invalid
               value is given, an error will be returned.
               When choosing a duration, it is useful to
               keep in mind the frequency of the underlying
               time series data (which may also be affected
               by any alignments specified in the
               aggregations field); a good duration is long
               enough so that a single outlier does not
               generate spurious alerts, but short enough
               that unhealthy states are detected and
               alerted on quickly.
        :param Sequence['AlertPolicyConditionConditionThresholdAggregationArgs'] aggregations: Specifies the alignment of data points in
               individual time series as well as how to
               combine the retrieved time series together
               (such as when aggregating multiple streams
               on each resource to a single stream for each
               resource or when aggregating streams across
               all members of a group of resources).
               Multiple aggregations are applied in the
               order specified.This field is similar to the
               one in the MetricService.ListTimeSeries
               request. It is advisable to use the
               ListTimeSeries method when debugging this
               field.
               Structure is documented below.
        :param Sequence['AlertPolicyConditionConditionThresholdDenominatorAggregationArgs'] denominator_aggregations: Specifies the alignment of data points in
               individual time series selected by
               denominatorFilter as well as how to combine
               the retrieved time series together (such as
               when aggregating multiple streams on each
               resource to a single stream for each
               resource or when aggregating streams across
               all members of a group of resources).When
               computing ratios, the aggregations and
               denominator_aggregations fields must use the
               same alignment period and produce time
               series that have the same periodicity and
               labels.This field is similar to the one in
               the MetricService.ListTimeSeries request. It
               is advisable to use the ListTimeSeries
               method when debugging this field.
               Structure is documented below.
        :param _builtins.str denominator_filter: A filter that identifies a time series that
               should be used as the denominator of a ratio
               that will be compared with the threshold. If
               a denominator_filter is specified, the time
               series specified by the filter field will be
               used as the numerator.The filter is similar
               to the one that is specified in the
               MetricService.ListTimeSeries request (that
               call is useful to verify the time series
               that will be retrieved / processed) and must
               specify the metric type and optionally may
               contain restrictions on resource type,
               resource labels, and metric labels. This
               field may not exceed 2048 Unicode characters
               in length.
        :param _builtins.str evaluation_missing_data: A condition control that determines how
               metric-threshold conditions are evaluated when
               data stops arriving.
               Possible values are: `EVALUATION_MISSING_DATA_INACTIVE`, `EVALUATION_MISSING_DATA_ACTIVE`, `EVALUATION_MISSING_DATA_NO_OP`.
        :param _builtins.str filter: A filter that identifies which time series
               should be compared with the threshold.The
               filter is similar to the one that is
               specified in the
               MetricService.ListTimeSeries request (that
               call is useful to verify the time series
               that will be retrieved / processed) and must
               specify the metric type and optionally may
               contain restrictions on resource type,
               resource labels, and metric labels. This
               field may not exceed 2048 Unicode characters
               in length.
        :param 'AlertPolicyConditionConditionThresholdForecastOptionsArgs' forecast_options: When this field is present, the `MetricThreshold`
               condition forecasts whether the time series is
               predicted to violate the threshold within the
               `forecastHorizon`. When this field is not set, the
               `MetricThreshold` tests the current value of the
               timeseries against the threshold.
               Structure is documented below.
        :param _builtins.float threshold_value: A value against which to compare the time
               series.
        :param 'AlertPolicyConditionConditionThresholdTriggerArgs' trigger: The number/percent of time series for which
               the comparison must hold in order for the
               condition to trigger. If unspecified, then
               the condition will trigger if the comparison
               is true for any of the time series that have
               been identified by filter and aggregations,
               or by the ratio, if denominator_filter and
               denominator_aggregations are specified.
               Structure is documented below.
        """
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "duration", duration)
        if aggregations is not None:
            pulumi.set(__self__, "aggregations", aggregations)
        if denominator_aggregations is not None:
            pulumi.set(__self__, "denominator_aggregations", denominator_aggregations)
        if denominator_filter is not None:
            pulumi.set(__self__, "denominator_filter", denominator_filter)
        if evaluation_missing_data is not None:
            pulumi.set(__self__, "evaluation_missing_data", evaluation_missing_data)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if forecast_options is not None:
            pulumi.set(__self__, "forecast_options", forecast_options)
        if threshold_value is not None:
            pulumi.set(__self__, "threshold_value", threshold_value)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @_builtins.property
    @pulumi.getter
    def comparison(self) -> _builtins.str:
        """
        The comparison to apply between the time
        series (indicated by filter and aggregation)
        and the threshold (indicated by
        threshold_value). The comparison is applied
        on each time series, with the time series on
        the left-hand side and the threshold on the
        right-hand side. Only COMPARISON_LT and
        COMPARISON_GT are supported currently.
        Possible values are: `COMPARISON_GT`, `COMPARISON_GE`, `COMPARISON_LT`, `COMPARISON_LE`, `COMPARISON_EQ`, `COMPARISON_NE`.
        """
        return pulumi.get(self, "comparison")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The amount of time that a time series must
        violate the threshold to be considered
        failing. Currently, only values that are a
        multiple of a minute--e.g., 0, 60, 120, or
        300 seconds--are supported. If an invalid
        value is given, an error will be returned.
        When choosing a duration, it is useful to
        keep in mind the frequency of the underlying
        time series data (which may also be affected
        by any alignments specified in the
        aggregations field); a good duration is long
        enough so that a single outlier does not
        generate spurious alerts, but short enough
        that unhealthy states are detected and
        alerted on quickly.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def aggregations(self) -> Optional[Sequence['outputs.AlertPolicyConditionConditionThresholdAggregation']]:
        """
        Specifies the alignment of data points in
        individual time series as well as how to
        combine the retrieved time series together
        (such as when aggregating multiple streams
        on each resource to a single stream for each
        resource or when aggregating streams across
        all members of a group of resources).
        Multiple aggregations are applied in the
        order specified.This field is similar to the
        one in the MetricService.ListTimeSeries
        request. It is advisable to use the
        ListTimeSeries method when debugging this
        field.
        Structure is documented below.
        """
        return pulumi.get(self, "aggregations")

    @_builtins.property
    @pulumi.getter(name="denominatorAggregations")
    def denominator_aggregations(self) -> Optional[Sequence['outputs.AlertPolicyConditionConditionThresholdDenominatorAggregation']]:
        """
        Specifies the alignment of data points in
        individual time series selected by
        denominatorFilter as well as how to combine
        the retrieved time series together (such as
        when aggregating multiple streams on each
        resource to a single stream for each
        resource or when aggregating streams across
        all members of a group of resources).When
        computing ratios, the aggregations and
        denominator_aggregations fields must use the
        same alignment period and produce time
        series that have the same periodicity and
        labels.This field is similar to the one in
        the MetricService.ListTimeSeries request. It
        is advisable to use the ListTimeSeries
        method when debugging this field.
        Structure is documented below.
        """
        return pulumi.get(self, "denominator_aggregations")

    @_builtins.property
    @pulumi.getter(name="denominatorFilter")
    def denominator_filter(self) -> Optional[_builtins.str]:
        """
        A filter that identifies a time series that
        should be used as the denominator of a ratio
        that will be compared with the threshold. If
        a denominator_filter is specified, the time
        series specified by the filter field will be
        used as the numerator.The filter is similar
        to the one that is specified in the
        MetricService.ListTimeSeries request (that
        call is useful to verify the time series
        that will be retrieved / processed) and must
        specify the metric type and optionally may
        contain restrictions on resource type,
        resource labels, and metric labels. This
        field may not exceed 2048 Unicode characters
        in length.
        """
        return pulumi.get(self, "denominator_filter")

    @_builtins.property
    @pulumi.getter(name="evaluationMissingData")
    def evaluation_missing_data(self) -> Optional[_builtins.str]:
        """
        A condition control that determines how
        metric-threshold conditions are evaluated when
        data stops arriving.
        Possible values are: `EVALUATION_MISSING_DATA_INACTIVE`, `EVALUATION_MISSING_DATA_ACTIVE`, `EVALUATION_MISSING_DATA_NO_OP`.
        """
        return pulumi.get(self, "evaluation_missing_data")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        """
        A filter that identifies which time series
        should be compared with the threshold.The
        filter is similar to the one that is
        specified in the
        MetricService.ListTimeSeries request (that
        call is useful to verify the time series
        that will be retrieved / processed) and must
        specify the metric type and optionally may
        contain restrictions on resource type,
        resource labels, and metric labels. This
        field may not exceed 2048 Unicode characters
        in length.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="forecastOptions")
    def forecast_options(self) -> Optional['outputs.AlertPolicyConditionConditionThresholdForecastOptions']:
        """
        When this field is present, the `MetricThreshold`
        condition forecasts whether the time series is
        predicted to violate the threshold within the
        `forecastHorizon`. When this field is not set, the
        `MetricThreshold` tests the current value of the
        timeseries against the threshold.
        Structure is documented below.
        """
        return pulumi.get(self, "forecast_options")

    @_builtins.property
    @pulumi.getter(name="thresholdValue")
    def threshold_value(self) -> Optional[_builtins.float]:
        """
        A value against which to compare the time
        series.
        """
        return pulumi.get(self, "threshold_value")

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> Optional['outputs.AlertPolicyConditionConditionThresholdTrigger']:
        """
        The number/percent of time series for which
        the comparison must hold in order for the
        condition to trigger. If unspecified, then
        the condition will trigger if the comparison
        is true for any of the time series that have
        been identified by filter and aggregations,
        or by the ratio, if denominator_filter and
        denominator_aggregations are specified.
        Structure is documented below.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class AlertPolicyConditionConditionThresholdAggregation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alignmentPeriod":
            suggest = "alignment_period"
        elif key == "crossSeriesReducer":
            suggest = "cross_series_reducer"
        elif key == "groupByFields":
            suggest = "group_by_fields"
        elif key == "perSeriesAligner":
            suggest = "per_series_aligner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionThresholdAggregation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionThresholdAggregation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionThresholdAggregation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alignment_period: Optional[_builtins.str] = None,
                 cross_series_reducer: Optional[_builtins.str] = None,
                 group_by_fields: Optional[Sequence[_builtins.str]] = None,
                 per_series_aligner: Optional[_builtins.str] = None):
        """
        :param _builtins.str alignment_period: The alignment period for per-time
               series alignment. If present,
               alignmentPeriod must be at least
               60 seconds. After per-time series
               alignment, each time series will
               contain data points only on the
               period boundaries. If
               perSeriesAligner is not specified
               or equals ALIGN_NONE, then this
               field is ignored. If
               perSeriesAligner is specified and
               does not equal ALIGN_NONE, then
               this field must be defined;
               otherwise an error is returned.
        :param _builtins.str cross_series_reducer: The approach to be used to combine
               time series. Not all reducer
               functions may be applied to all
               time series, depending on the
               metric type and the value type of
               the original time series.
               Reduction may change the metric
               type of value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are: `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, `REDUCE_PERCENTILE_05`.
        :param Sequence[_builtins.str] group_by_fields: The set of fields to preserve when
               crossSeriesReducer is specified.
               The groupByFields determine how
               the time series are partitioned
               into subsets prior to applying the
               aggregation function. Each subset
               contains time series that have the
               same value for each of the
               grouping fields. Each individual
               time series is a member of exactly
               one subset. The crossSeriesReducer
               is applied to each subset of time
               series. It is not possible to
               reduce across different resource
               types, so this field implicitly
               contains resource.type. Fields not
               specified in groupByFields are
               aggregated away. If groupByFields
               is not specified and all the time
               series have the same resource
               type, then the time series are
               aggregated into a single output
               time series. If crossSeriesReducer
               is not defined, this field is
               ignored.
        :param _builtins.str per_series_aligner: The approach to be used to align
               individual time series. Not all
               alignment functions may be applied
               to all time series, depending on
               the metric type and value type of
               the original time series.
               Alignment may change the metric
               type or the value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are: `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, `ALIGN_PERCENT_CHANGE`.
        """
        if alignment_period is not None:
            pulumi.set(__self__, "alignment_period", alignment_period)
        if cross_series_reducer is not None:
            pulumi.set(__self__, "cross_series_reducer", cross_series_reducer)
        if group_by_fields is not None:
            pulumi.set(__self__, "group_by_fields", group_by_fields)
        if per_series_aligner is not None:
            pulumi.set(__self__, "per_series_aligner", per_series_aligner)

    @_builtins.property
    @pulumi.getter(name="alignmentPeriod")
    def alignment_period(self) -> Optional[_builtins.str]:
        """
        The alignment period for per-time
        series alignment. If present,
        alignmentPeriod must be at least
        60 seconds. After per-time series
        alignment, each time series will
        contain data points only on the
        period boundaries. If
        perSeriesAligner is not specified
        or equals ALIGN_NONE, then this
        field is ignored. If
        perSeriesAligner is specified and
        does not equal ALIGN_NONE, then
        this field must be defined;
        otherwise an error is returned.
        """
        return pulumi.get(self, "alignment_period")

    @_builtins.property
    @pulumi.getter(name="crossSeriesReducer")
    def cross_series_reducer(self) -> Optional[_builtins.str]:
        """
        The approach to be used to combine
        time series. Not all reducer
        functions may be applied to all
        time series, depending on the
        metric type and the value type of
        the original time series.
        Reduction may change the metric
        type of value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are: `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, `REDUCE_PERCENTILE_05`.
        """
        return pulumi.get(self, "cross_series_reducer")

    @_builtins.property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[Sequence[_builtins.str]]:
        """
        The set of fields to preserve when
        crossSeriesReducer is specified.
        The groupByFields determine how
        the time series are partitioned
        into subsets prior to applying the
        aggregation function. Each subset
        contains time series that have the
        same value for each of the
        grouping fields. Each individual
        time series is a member of exactly
        one subset. The crossSeriesReducer
        is applied to each subset of time
        series. It is not possible to
        reduce across different resource
        types, so this field implicitly
        contains resource.type. Fields not
        specified in groupByFields are
        aggregated away. If groupByFields
        is not specified and all the time
        series have the same resource
        type, then the time series are
        aggregated into a single output
        time series. If crossSeriesReducer
        is not defined, this field is
        ignored.
        """
        return pulumi.get(self, "group_by_fields")

    @_builtins.property
    @pulumi.getter(name="perSeriesAligner")
    def per_series_aligner(self) -> Optional[_builtins.str]:
        """
        The approach to be used to align
        individual time series. Not all
        alignment functions may be applied
        to all time series, depending on
        the metric type and value type of
        the original time series.
        Alignment may change the metric
        type or the value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are: `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, `ALIGN_PERCENT_CHANGE`.
        """
        return pulumi.get(self, "per_series_aligner")


@pulumi.output_type
class AlertPolicyConditionConditionThresholdDenominatorAggregation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alignmentPeriod":
            suggest = "alignment_period"
        elif key == "crossSeriesReducer":
            suggest = "cross_series_reducer"
        elif key == "groupByFields":
            suggest = "group_by_fields"
        elif key == "perSeriesAligner":
            suggest = "per_series_aligner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionThresholdDenominatorAggregation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionThresholdDenominatorAggregation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionThresholdDenominatorAggregation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alignment_period: Optional[_builtins.str] = None,
                 cross_series_reducer: Optional[_builtins.str] = None,
                 group_by_fields: Optional[Sequence[_builtins.str]] = None,
                 per_series_aligner: Optional[_builtins.str] = None):
        """
        :param _builtins.str alignment_period: The alignment period for per-time
               series alignment. If present,
               alignmentPeriod must be at least
               60 seconds. After per-time series
               alignment, each time series will
               contain data points only on the
               period boundaries. If
               perSeriesAligner is not specified
               or equals ALIGN_NONE, then this
               field is ignored. If
               perSeriesAligner is specified and
               does not equal ALIGN_NONE, then
               this field must be defined;
               otherwise an error is returned.
        :param _builtins.str cross_series_reducer: The approach to be used to combine
               time series. Not all reducer
               functions may be applied to all
               time series, depending on the
               metric type and the value type of
               the original time series.
               Reduction may change the metric
               type of value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are: `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, `REDUCE_PERCENTILE_05`.
        :param Sequence[_builtins.str] group_by_fields: The set of fields to preserve when
               crossSeriesReducer is specified.
               The groupByFields determine how
               the time series are partitioned
               into subsets prior to applying the
               aggregation function. Each subset
               contains time series that have the
               same value for each of the
               grouping fields. Each individual
               time series is a member of exactly
               one subset. The crossSeriesReducer
               is applied to each subset of time
               series. It is not possible to
               reduce across different resource
               types, so this field implicitly
               contains resource.type. Fields not
               specified in groupByFields are
               aggregated away. If groupByFields
               is not specified and all the time
               series have the same resource
               type, then the time series are
               aggregated into a single output
               time series. If crossSeriesReducer
               is not defined, this field is
               ignored.
        :param _builtins.str per_series_aligner: The approach to be used to align
               individual time series. Not all
               alignment functions may be applied
               to all time series, depending on
               the metric type and value type of
               the original time series.
               Alignment may change the metric
               type or the value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are: `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, `ALIGN_PERCENT_CHANGE`.
        """
        if alignment_period is not None:
            pulumi.set(__self__, "alignment_period", alignment_period)
        if cross_series_reducer is not None:
            pulumi.set(__self__, "cross_series_reducer", cross_series_reducer)
        if group_by_fields is not None:
            pulumi.set(__self__, "group_by_fields", group_by_fields)
        if per_series_aligner is not None:
            pulumi.set(__self__, "per_series_aligner", per_series_aligner)

    @_builtins.property
    @pulumi.getter(name="alignmentPeriod")
    def alignment_period(self) -> Optional[_builtins.str]:
        """
        The alignment period for per-time
        series alignment. If present,
        alignmentPeriod must be at least
        60 seconds. After per-time series
        alignment, each time series will
        contain data points only on the
        period boundaries. If
        perSeriesAligner is not specified
        or equals ALIGN_NONE, then this
        field is ignored. If
        perSeriesAligner is specified and
        does not equal ALIGN_NONE, then
        this field must be defined;
        otherwise an error is returned.
        """
        return pulumi.get(self, "alignment_period")

    @_builtins.property
    @pulumi.getter(name="crossSeriesReducer")
    def cross_series_reducer(self) -> Optional[_builtins.str]:
        """
        The approach to be used to combine
        time series. Not all reducer
        functions may be applied to all
        time series, depending on the
        metric type and the value type of
        the original time series.
        Reduction may change the metric
        type of value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are: `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, `REDUCE_PERCENTILE_05`.
        """
        return pulumi.get(self, "cross_series_reducer")

    @_builtins.property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[Sequence[_builtins.str]]:
        """
        The set of fields to preserve when
        crossSeriesReducer is specified.
        The groupByFields determine how
        the time series are partitioned
        into subsets prior to applying the
        aggregation function. Each subset
        contains time series that have the
        same value for each of the
        grouping fields. Each individual
        time series is a member of exactly
        one subset. The crossSeriesReducer
        is applied to each subset of time
        series. It is not possible to
        reduce across different resource
        types, so this field implicitly
        contains resource.type. Fields not
        specified in groupByFields are
        aggregated away. If groupByFields
        is not specified and all the time
        series have the same resource
        type, then the time series are
        aggregated into a single output
        time series. If crossSeriesReducer
        is not defined, this field is
        ignored.
        """
        return pulumi.get(self, "group_by_fields")

    @_builtins.property
    @pulumi.getter(name="perSeriesAligner")
    def per_series_aligner(self) -> Optional[_builtins.str]:
        """
        The approach to be used to align
        individual time series. Not all
        alignment functions may be applied
        to all time series, depending on
        the metric type and value type of
        the original time series.
        Alignment may change the metric
        type or the value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are: `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, `ALIGN_PERCENT_CHANGE`.
        """
        return pulumi.get(self, "per_series_aligner")


@pulumi.output_type
class AlertPolicyConditionConditionThresholdForecastOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forecastHorizon":
            suggest = "forecast_horizon"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionThresholdForecastOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionThresholdForecastOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionThresholdForecastOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forecast_horizon: _builtins.str):
        """
        :param _builtins.str forecast_horizon: The length of time into the future to forecast
               whether a timeseries will violate the threshold.
               If the predicted value is found to violate the
               threshold, and the violation is observed in all
               forecasts made for the Configured `duration`,
               then the timeseries is considered to be failing.
        """
        pulumi.set(__self__, "forecast_horizon", forecast_horizon)

    @_builtins.property
    @pulumi.getter(name="forecastHorizon")
    def forecast_horizon(self) -> _builtins.str:
        """
        The length of time into the future to forecast
        whether a timeseries will violate the threshold.
        If the predicted value is found to violate the
        threshold, and the violation is observed in all
        forecasts made for the Configured `duration`,
        then the timeseries is considered to be failing.
        """
        return pulumi.get(self, "forecast_horizon")


@pulumi.output_type
class AlertPolicyConditionConditionThresholdTrigger(dict):
    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 percent: Optional[_builtins.float] = None):
        """
        :param _builtins.int count: The absolute number of time series
               that must fail the predicate for the
               condition to be triggered.
        :param _builtins.float percent: The percentage of time series that
               must fail the predicate for the
               condition to be triggered.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        The absolute number of time series
        that must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def percent(self) -> Optional[_builtins.float]:
        """
        The percentage of time series that
        must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class AlertPolicyCreationRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mutateTime":
            suggest = "mutate_time"
        elif key == "mutatedBy":
            suggest = "mutated_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyCreationRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyCreationRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyCreationRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mutate_time: Optional[_builtins.str] = None,
                 mutated_by: Optional[_builtins.str] = None):
        """
        :param _builtins.str mutate_time: (Output)
               When the change occurred.
        :param _builtins.str mutated_by: (Output)
               The email address of the user making the change.
        """
        if mutate_time is not None:
            pulumi.set(__self__, "mutate_time", mutate_time)
        if mutated_by is not None:
            pulumi.set(__self__, "mutated_by", mutated_by)

    @_builtins.property
    @pulumi.getter(name="mutateTime")
    def mutate_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        When the change occurred.
        """
        return pulumi.get(self, "mutate_time")

    @_builtins.property
    @pulumi.getter(name="mutatedBy")
    def mutated_by(self) -> Optional[_builtins.str]:
        """
        (Output)
        The email address of the user making the change.
        """
        return pulumi.get(self, "mutated_by")


@pulumi.output_type
class AlertPolicyDocumentation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mimeType":
            suggest = "mime_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyDocumentation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyDocumentation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyDocumentation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: Optional[_builtins.str] = None,
                 links: Optional[Sequence['outputs.AlertPolicyDocumentationLink']] = None,
                 mime_type: Optional[_builtins.str] = None,
                 subject: Optional[_builtins.str] = None):
        """
        :param _builtins.str content: The text of the documentation, interpreted according to mimeType.
               The content may not exceed 8,192 Unicode characters and may not
               exceed more than 10,240 bytes when encoded in UTF-8 format,
               whichever is smaller.
        :param Sequence['AlertPolicyDocumentationLinkArgs'] links: Links to content such as playbooks, repositories, and other resources. This field can contain up to 3 entries.
               Structure is documented below.
        :param _builtins.str mime_type: The format of the content field. Presently, only the value
               "text/markdown" is supported.
        :param _builtins.str subject: The subject line of the notification. The subject line may not
               exceed 10,240 bytes. In notifications generated by this policy the contents
               of the subject line after variable expansion will be truncated to 255 bytes
               or shorter at the latest UTF-8 character boundary.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[_builtins.str]:
        """
        The text of the documentation, interpreted according to mimeType.
        The content may not exceed 8,192 Unicode characters and may not
        exceed more than 10,240 bytes when encoded in UTF-8 format,
        whichever is smaller.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[Sequence['outputs.AlertPolicyDocumentationLink']]:
        """
        Links to content such as playbooks, repositories, and other resources. This field can contain up to 3 entries.
        Structure is documented below.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[_builtins.str]:
        """
        The format of the content field. Presently, only the value
        "text/markdown" is supported.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[_builtins.str]:
        """
        The subject line of the notification. The subject line may not
        exceed 10,240 bytes. In notifications generated by this policy the contents
        of the subject line after variable expansion will be truncated to 255 bytes
        or shorter at the latest UTF-8 character boundary.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class AlertPolicyDocumentationLink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyDocumentationLink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyDocumentationLink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyDocumentationLink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: A short display name for the link. The display name must not be empty or exceed 63 characters. Example: "playbook".
        :param _builtins.str url: The url of a webpage. A url can be templatized by using variables in the path or the query parameters. The total length of a URL should not exceed 2083 characters before and after variable expansion. Example: "https://my_domain.com/playbook?name=${resource.name}".
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A short display name for the link. The display name must not be empty or exceed 63 characters. Example: "playbook".
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        The url of a webpage. A url can be templatized by using variables in the path or the query parameters. The total length of a URL should not exceed 2083 characters before and after variable expansion. Example: "https://my_domain.com/playbook?name=${resource.name}".
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class CustomServiceTelemetry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceName":
            suggest = "resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomServiceTelemetry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomServiceTelemetry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomServiceTelemetry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_name: The full name of the resource that defines this service.
               Formatted as described in
               https://cloud.google.com/apis/design/resource_names.
        """
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[_builtins.str]:
        """
        The full name of the resource that defines this service.
        Formatted as described in
        https://cloud.google.com/apis/design/resource_names.
        """
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class GenericServiceBasicService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceLabels":
            suggest = "service_labels"
        elif key == "serviceType":
            suggest = "service_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GenericServiceBasicService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GenericServiceBasicService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GenericServiceBasicService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_labels: Optional[Mapping[str, _builtins.str]] = None,
                 service_type: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] service_labels: Labels that specify the resource that emits the monitoring data
               which is used for SLO reporting of this `Service`.
        :param _builtins.str service_type: The type of service that this basic service defines, e.g.
               APP_ENGINE service type
        """
        if service_labels is not None:
            pulumi.set(__self__, "service_labels", service_labels)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)

    @_builtins.property
    @pulumi.getter(name="serviceLabels")
    def service_labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Labels that specify the resource that emits the monitoring data
        which is used for SLO reporting of this `Service`.
        """
        return pulumi.get(self, "service_labels")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[_builtins.str]:
        """
        The type of service that this basic service defines, e.g.
        APP_ENGINE service type
        """
        return pulumi.get(self, "service_type")


@pulumi.output_type
class GenericServiceTelemetry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceName":
            suggest = "resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GenericServiceTelemetry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GenericServiceTelemetry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GenericServiceTelemetry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_name: The full name of the resource that defines this service.
               Formatted as described in
               https://cloud.google.com/apis/design/resource_names.
        """
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[_builtins.str]:
        """
        The full name of the resource that defines this service.
        Formatted as described in
        https://cloud.google.com/apis/design/resource_names.
        """
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class MetricDescriptorLabel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricDescriptorLabel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricDescriptorLabel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricDescriptorLabel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 value_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The key for this label. The key must not exceed 100 characters. The first character of the key must be an upper- or lower-case letter, the remaining characters must be letters, digits or underscores, and the key must match the regular expression [a-zA-Z][a-zA-Z0-9_]*
        :param _builtins.str description: A human-readable description for the label.
        :param _builtins.str value_type: The type of data that can be assigned to the label.
               Default value is `STRING`.
               Possible values are: `STRING`, `BOOL`, `INT64`.
        """
        pulumi.set(__self__, "key", key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key for this label. The key must not exceed 100 characters. The first character of the key must be an upper- or lower-case letter, the remaining characters must be letters, digits or underscores, and the key must match the regular expression [a-zA-Z][a-zA-Z0-9_]*
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A human-readable description for the label.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[_builtins.str]:
        """
        The type of data that can be assigned to the label.
        Default value is `STRING`.
        Possible values are: `STRING`, `BOOL`, `INT64`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class MetricDescriptorMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingestDelay":
            suggest = "ingest_delay"
        elif key == "samplePeriod":
            suggest = "sample_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricDescriptorMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricDescriptorMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricDescriptorMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingest_delay: Optional[_builtins.str] = None,
                 sample_period: Optional[_builtins.str] = None):
        """
        :param _builtins.str ingest_delay: The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors. In `[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)`.
        :param _builtins.str sample_period: The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period. In `[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)`.
        """
        if ingest_delay is not None:
            pulumi.set(__self__, "ingest_delay", ingest_delay)
        if sample_period is not None:
            pulumi.set(__self__, "sample_period", sample_period)

    @_builtins.property
    @pulumi.getter(name="ingestDelay")
    def ingest_delay(self) -> Optional[_builtins.str]:
        """
        The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors. In `[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)`.
        """
        return pulumi.get(self, "ingest_delay")

    @_builtins.property
    @pulumi.getter(name="samplePeriod")
    def sample_period(self) -> Optional[_builtins.str]:
        """
        The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period. In `[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)`.
        """
        return pulumi.get(self, "sample_period")


@pulumi.output_type
class NotificationChannelSensitiveLabels(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authToken":
            suggest = "auth_token"
        elif key == "serviceKey":
            suggest = "service_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationChannelSensitiveLabels. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationChannelSensitiveLabels.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationChannelSensitiveLabels.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_token: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 service_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_token: An authorization token for a notification channel. Channel types that support this field include: slack
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param _builtins.str password: An password for a notification channel. Channel types that support this field include: webhook_basicauth
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param _builtins.str service_key: An servicekey token for a notification channel. Channel types that support this field include: pagerduty
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if service_key is not None:
            pulumi.set(__self__, "service_key", service_key)

    @_builtins.property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[_builtins.str]:
        """
        An authorization token for a notification channel. Channel types that support this field include: slack
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "auth_token")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        An password for a notification channel. Channel types that support this field include: webhook_basicauth
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> Optional[_builtins.str]:
        """
        An servicekey token for a notification channel. Channel types that support this field include: pagerduty
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "service_key")


@pulumi.output_type
class SloBasicSli(dict):
    def __init__(__self__, *,
                 availability: Optional['outputs.SloBasicSliAvailability'] = None,
                 latency: Optional['outputs.SloBasicSliLatency'] = None,
                 locations: Optional[Sequence[_builtins.str]] = None,
                 methods: Optional[Sequence[_builtins.str]] = None,
                 versions: Optional[Sequence[_builtins.str]] = None):
        """
        :param 'SloBasicSliAvailabilityArgs' availability: Availability based SLI, dervied from count of requests made to this service that return successfully.
               Structure is documented below.
        :param 'SloBasicSliLatencyArgs' latency: Parameters for a latency threshold SLI.
               Structure is documented below.
        :param Sequence[_builtins.str] locations: An optional set of locations to which this SLI is relevant.
               Telemetry from other locations will not be used to calculate
               performance for this SLI. If omitted, this SLI applies to all
               locations in which the Service has activity. For service types
               that don't support breaking down by location, setting this
               field will result in an error.
        :param Sequence[_builtins.str] methods: An optional set of RPCs to which this SLI is relevant.
               Telemetry from other methods will not be used to calculate
               performance for this SLI. If omitted, this SLI applies to all
               the Service's methods. For service types that don't support
               breaking down by method, setting this field will result in an
               error.
        :param Sequence[_builtins.str] versions: The set of API versions to which this SLI is relevant.
               Telemetry from other API versions will not be used to
               calculate performance for this SLI. If omitted,
               this SLI applies to all API versions. For service types
               that don't support breaking down by version, setting this
               field will result in an error.
        """
        if availability is not None:
            pulumi.set(__self__, "availability", availability)
        if latency is not None:
            pulumi.set(__self__, "latency", latency)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter
    def availability(self) -> Optional['outputs.SloBasicSliAvailability']:
        """
        Availability based SLI, dervied from count of requests made to this service that return successfully.
        Structure is documented below.
        """
        return pulumi.get(self, "availability")

    @_builtins.property
    @pulumi.getter
    def latency(self) -> Optional['outputs.SloBasicSliLatency']:
        """
        Parameters for a latency threshold SLI.
        Structure is documented below.
        """
        return pulumi.get(self, "latency")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[_builtins.str]]:
        """
        An optional set of locations to which this SLI is relevant.
        Telemetry from other locations will not be used to calculate
        performance for this SLI. If omitted, this SLI applies to all
        locations in which the Service has activity. For service types
        that don't support breaking down by location, setting this
        field will result in an error.
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[_builtins.str]]:
        """
        An optional set of RPCs to which this SLI is relevant.
        Telemetry from other methods will not be used to calculate
        performance for this SLI. If omitted, this SLI applies to all
        the Service's methods. For service types that don't support
        breaking down by method, setting this field will result in an
        error.
        """
        return pulumi.get(self, "methods")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        The set of API versions to which this SLI is relevant.
        Telemetry from other API versions will not be used to
        calculate performance for this SLI. If omitted,
        this SLI applies to all API versions. For service types
        that don't support breaking down by version, setting this
        field will result in an error.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class SloBasicSliAvailability(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: Whether an availability SLI is enabled or not. Must be set to `true. Defaults to `true`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether an availability SLI is enabled or not. Must be set to `true. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class SloBasicSliLatency(dict):
    def __init__(__self__, *,
                 threshold: _builtins.str):
        """
        :param _builtins.str threshold: A duration string, e.g. 10s.
               Good service is defined to be the count of requests made to
               this service that return in no more than threshold.
        """
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.str:
        """
        A duration string, e.g. 10s.
        Good service is defined to be the count of requests made to
        this service that return in no more than threshold.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class SloRequestBasedSli(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionCut":
            suggest = "distribution_cut"
        elif key == "goodTotalRatio":
            suggest = "good_total_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloRequestBasedSli. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloRequestBasedSli.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloRequestBasedSli.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_cut: Optional['outputs.SloRequestBasedSliDistributionCut'] = None,
                 good_total_ratio: Optional['outputs.SloRequestBasedSliGoodTotalRatio'] = None):
        """
        :param 'SloRequestBasedSliDistributionCutArgs' distribution_cut: Used when good_service is defined by a count of values aggregated in a
               Distribution that fall into a good range. The total_service is the
               total count of all values aggregated in the Distribution.
               Defines a distribution TimeSeries filter and thresholds used for
               measuring good service and total service.
               Exactly one of `distribution_cut` or `good_total_ratio` can be set.
               Structure is documented below.
        :param 'SloRequestBasedSliGoodTotalRatioArgs' good_total_ratio: A means to compute a ratio of `good_service` to `total_service`.
               Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
               Must specify exactly two of good, bad, and total service filters.
               The relationship good_service + bad_service = total_service
               will be assumed.
               Exactly one of `distribution_cut` or `good_total_ratio` can be set.
               Structure is documented below.
        """
        if distribution_cut is not None:
            pulumi.set(__self__, "distribution_cut", distribution_cut)
        if good_total_ratio is not None:
            pulumi.set(__self__, "good_total_ratio", good_total_ratio)

    @_builtins.property
    @pulumi.getter(name="distributionCut")
    def distribution_cut(self) -> Optional['outputs.SloRequestBasedSliDistributionCut']:
        """
        Used when good_service is defined by a count of values aggregated in a
        Distribution that fall into a good range. The total_service is the
        total count of all values aggregated in the Distribution.
        Defines a distribution TimeSeries filter and thresholds used for
        measuring good service and total service.
        Exactly one of `distribution_cut` or `good_total_ratio` can be set.
        Structure is documented below.
        """
        return pulumi.get(self, "distribution_cut")

    @_builtins.property
    @pulumi.getter(name="goodTotalRatio")
    def good_total_ratio(self) -> Optional['outputs.SloRequestBasedSliGoodTotalRatio']:
        """
        A means to compute a ratio of `good_service` to `total_service`.
        Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
        Must specify exactly two of good, bad, and total service filters.
        The relationship good_service + bad_service = total_service
        will be assumed.
        Exactly one of `distribution_cut` or `good_total_ratio` can be set.
        Structure is documented below.
        """
        return pulumi.get(self, "good_total_ratio")


@pulumi.output_type
class SloRequestBasedSliDistributionCut(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionFilter":
            suggest = "distribution_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloRequestBasedSliDistributionCut. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloRequestBasedSliDistributionCut.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloRequestBasedSliDistributionCut.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_filter: _builtins.str,
                 range: 'outputs.SloRequestBasedSliDistributionCutRange'):
        """
        :param _builtins.str distribution_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               aggregating values to quantify the good service provided.
               Must have ValueType = DISTRIBUTION and
               MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param 'SloRequestBasedSliDistributionCutRangeArgs' range: Range of numerical values. The computed good_service
               will be the count of values x in the Distribution such
               that range.min <= x <= range.max. inclusive of min and
               max. Open ranges can be defined by setting
               just one of min or max.
               Structure is documented below.
        """
        pulumi.set(__self__, "distribution_filter", distribution_filter)
        pulumi.set(__self__, "range", range)

    @_builtins.property
    @pulumi.getter(name="distributionFilter")
    def distribution_filter(self) -> _builtins.str:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        aggregating values to quantify the good service provided.
        Must have ValueType = DISTRIBUTION and
        MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "distribution_filter")

    @_builtins.property
    @pulumi.getter
    def range(self) -> 'outputs.SloRequestBasedSliDistributionCutRange':
        """
        Range of numerical values. The computed good_service
        will be the count of values x in the Distribution such
        that range.min <= x <= range.max. inclusive of min and
        max. Open ranges can be defined by setting
        just one of min or max.
        Structure is documented below.
        """
        return pulumi.get(self, "range")


@pulumi.output_type
class SloRequestBasedSliDistributionCutRange(dict):
    def __init__(__self__, *,
                 max: Optional[_builtins.float] = None,
                 min: Optional[_builtins.float] = None):
        """
        :param _builtins.float max: max value for the range (inclusive). If not given,
               will be set to "infinity", defining an open range
               ">= range.min"
        :param _builtins.float min: Min value for the range (inclusive). If not given,
               will be set to "-infinity", defining an open range
               "< range.max"
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[_builtins.float]:
        """
        max value for the range (inclusive). If not given,
        will be set to "infinity", defining an open range
        ">= range.min"
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[_builtins.float]:
        """
        Min value for the range (inclusive). If not given,
        will be set to "-infinity", defining an open range
        "< range.max"
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class SloRequestBasedSliGoodTotalRatio(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "badServiceFilter":
            suggest = "bad_service_filter"
        elif key == "goodServiceFilter":
            suggest = "good_service_filter"
        elif key == "totalServiceFilter":
            suggest = "total_service_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloRequestBasedSliGoodTotalRatio. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloRequestBasedSliGoodTotalRatio.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloRequestBasedSliGoodTotalRatio.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bad_service_filter: Optional[_builtins.str] = None,
                 good_service_filter: Optional[_builtins.str] = None,
                 total_service_filter: Optional[_builtins.str] = None):
        """
        :param _builtins.str bad_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying bad service provided, either demanded service that
               was not provided or demanded service that was of inadequate
               quality. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param _builtins.str good_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying good service provided. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param _builtins.str total_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying total demanded service. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        if bad_service_filter is not None:
            pulumi.set(__self__, "bad_service_filter", bad_service_filter)
        if good_service_filter is not None:
            pulumi.set(__self__, "good_service_filter", good_service_filter)
        if total_service_filter is not None:
            pulumi.set(__self__, "total_service_filter", total_service_filter)

    @_builtins.property
    @pulumi.getter(name="badServiceFilter")
    def bad_service_filter(self) -> Optional[_builtins.str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying bad service provided, either demanded service that
        was not provided or demanded service that was of inadequate
        quality. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "bad_service_filter")

    @_builtins.property
    @pulumi.getter(name="goodServiceFilter")
    def good_service_filter(self) -> Optional[_builtins.str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying good service provided. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "good_service_filter")

    @_builtins.property
    @pulumi.getter(name="totalServiceFilter")
    def total_service_filter(self) -> Optional[_builtins.str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying total demanded service. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "total_service_filter")


@pulumi.output_type
class SloWindowsBasedSli(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "goodBadMetricFilter":
            suggest = "good_bad_metric_filter"
        elif key == "goodTotalRatioThreshold":
            suggest = "good_total_ratio_threshold"
        elif key == "metricMeanInRange":
            suggest = "metric_mean_in_range"
        elif key == "metricSumInRange":
            suggest = "metric_sum_in_range"
        elif key == "windowPeriod":
            suggest = "window_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSli. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSli.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSli.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 good_bad_metric_filter: Optional[_builtins.str] = None,
                 good_total_ratio_threshold: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThreshold'] = None,
                 metric_mean_in_range: Optional['outputs.SloWindowsBasedSliMetricMeanInRange'] = None,
                 metric_sum_in_range: Optional['outputs.SloWindowsBasedSliMetricSumInRange'] = None,
                 window_period: Optional[_builtins.str] = None):
        """
        :param _builtins.str good_bad_metric_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               with ValueType = BOOL. The window is good if any true values
               appear in the window. One of `good_bad_metric_filter`,
               `good_total_ratio_threshold`, `metric_mean_in_range`,
               `metric_sum_in_range` must be set for `windows_based_sli`.
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdArgs' good_total_ratio_threshold: Criterion that describes a window as good if its performance is
               high enough. One of `good_bad_metric_filter`,
               `good_total_ratio_threshold`, `metric_mean_in_range`,
               `metric_sum_in_range` must be set for `windows_based_sli`.
               Structure is documented below.
        :param 'SloWindowsBasedSliMetricMeanInRangeArgs' metric_mean_in_range: Criterion that describes a window as good if the metric's value
               is in a good range, *averaged* across returned streams.
               One of `good_bad_metric_filter`,
               `good_total_ratio_threshold`, `metric_mean_in_range`,
               `metric_sum_in_range` must be set for `windows_based_sli`.
               Average value X of `time_series` should satisfy
               `range.min <= X <= range.max` for a good window.
               Structure is documented below.
        :param 'SloWindowsBasedSliMetricSumInRangeArgs' metric_sum_in_range: Criterion that describes a window as good if the metric's value
               is in a good range, *summed* across returned streams.
               Summed value `X` of `time_series` should satisfy
               `range.min <= X <= range.max` for a good window.
               One of `good_bad_metric_filter`,
               `good_total_ratio_threshold`, `metric_mean_in_range`,
               `metric_sum_in_range` must be set for `windows_based_sli`.
               Structure is documented below.
        :param _builtins.str window_period: Duration over which window quality is evaluated, given as a
               duration string "{X}s" representing X seconds. Must be an
               integer fraction of a day and at least 60s.
        """
        if good_bad_metric_filter is not None:
            pulumi.set(__self__, "good_bad_metric_filter", good_bad_metric_filter)
        if good_total_ratio_threshold is not None:
            pulumi.set(__self__, "good_total_ratio_threshold", good_total_ratio_threshold)
        if metric_mean_in_range is not None:
            pulumi.set(__self__, "metric_mean_in_range", metric_mean_in_range)
        if metric_sum_in_range is not None:
            pulumi.set(__self__, "metric_sum_in_range", metric_sum_in_range)
        if window_period is not None:
            pulumi.set(__self__, "window_period", window_period)

    @_builtins.property
    @pulumi.getter(name="goodBadMetricFilter")
    def good_bad_metric_filter(self) -> Optional[_builtins.str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        with ValueType = BOOL. The window is good if any true values
        appear in the window. One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.
        """
        return pulumi.get(self, "good_bad_metric_filter")

    @_builtins.property
    @pulumi.getter(name="goodTotalRatioThreshold")
    def good_total_ratio_threshold(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThreshold']:
        """
        Criterion that describes a window as good if its performance is
        high enough. One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.
        Structure is documented below.
        """
        return pulumi.get(self, "good_total_ratio_threshold")

    @_builtins.property
    @pulumi.getter(name="metricMeanInRange")
    def metric_mean_in_range(self) -> Optional['outputs.SloWindowsBasedSliMetricMeanInRange']:
        """
        Criterion that describes a window as good if the metric's value
        is in a good range, *averaged* across returned streams.
        One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.
        Average value X of `time_series` should satisfy
        `range.min <= X <= range.max` for a good window.
        Structure is documented below.
        """
        return pulumi.get(self, "metric_mean_in_range")

    @_builtins.property
    @pulumi.getter(name="metricSumInRange")
    def metric_sum_in_range(self) -> Optional['outputs.SloWindowsBasedSliMetricSumInRange']:
        """
        Criterion that describes a window as good if the metric's value
        is in a good range, *summed* across returned streams.
        Summed value `X` of `time_series` should satisfy
        `range.min <= X <= range.max` for a good window.
        One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.
        Structure is documented below.
        """
        return pulumi.get(self, "metric_sum_in_range")

    @_builtins.property
    @pulumi.getter(name="windowPeriod")
    def window_period(self) -> Optional[_builtins.str]:
        """
        Duration over which window quality is evaluated, given as a
        duration string "{X}s" representing X seconds. Must be an
        integer fraction of a day and at least 60s.
        """
        return pulumi.get(self, "window_period")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThreshold(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicSliPerformance":
            suggest = "basic_sli_performance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliGoodTotalRatioThreshold. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliGoodTotalRatioThreshold.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliGoodTotalRatioThreshold.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_sli_performance: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance'] = None,
                 performance: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformance'] = None,
                 threshold: Optional[_builtins.float] = None):
        """
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceArgs' basic_sli_performance: Basic SLI to evaluate to judge window quality.
               Structure is documented below.
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceArgs' performance: Request-based SLI to evaluate to judge window quality.
               Structure is documented below.
        :param _builtins.float threshold: If window performance >= threshold, the window is counted
               as good.
        """
        if basic_sli_performance is not None:
            pulumi.set(__self__, "basic_sli_performance", basic_sli_performance)
        if performance is not None:
            pulumi.set(__self__, "performance", performance)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter(name="basicSliPerformance")
    def basic_sli_performance(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance']:
        """
        Basic SLI to evaluate to judge window quality.
        Structure is documented below.
        """
        return pulumi.get(self, "basic_sli_performance")

    @_builtins.property
    @pulumi.getter
    def performance(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformance']:
        """
        Request-based SLI to evaluate to judge window quality.
        Structure is documented below.
        """
        return pulumi.get(self, "performance")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[_builtins.float]:
        """
        If window performance >= threshold, the window is counted
        as good.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance(dict):
    def __init__(__self__, *,
                 availability: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability'] = None,
                 latency: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency'] = None,
                 locations: Optional[Sequence[_builtins.str]] = None,
                 methods: Optional[Sequence[_builtins.str]] = None,
                 versions: Optional[Sequence[_builtins.str]] = None):
        """
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityArgs' availability: Availability based SLI, dervied from count of requests made to this service that return successfully.
               Structure is documented below.
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyArgs' latency: Parameters for a latency threshold SLI.
               Structure is documented below.
        :param Sequence[_builtins.str] locations: An optional set of locations to which this SLI is relevant.
               Telemetry from other locations will not be used to calculate
               performance for this SLI. If omitted, this SLI applies to all
               locations in which the Service has activity. For service types
               that don't support breaking down by location, setting this
               field will result in an error.
        :param Sequence[_builtins.str] methods: An optional set of RPCs to which this SLI is relevant.
               Telemetry from other methods will not be used to calculate
               performance for this SLI. If omitted, this SLI applies to all
               the Service's methods. For service types that don't support
               breaking down by method, setting this field will result in an
               error.
        :param Sequence[_builtins.str] versions: The set of API versions to which this SLI is relevant.
               Telemetry from other API versions will not be used to
               calculate performance for this SLI. If omitted,
               this SLI applies to all API versions. For service types
               that don't support breaking down by version, setting this
               field will result in an error.
        """
        if availability is not None:
            pulumi.set(__self__, "availability", availability)
        if latency is not None:
            pulumi.set(__self__, "latency", latency)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter
    def availability(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability']:
        """
        Availability based SLI, dervied from count of requests made to this service that return successfully.
        Structure is documented below.
        """
        return pulumi.get(self, "availability")

    @_builtins.property
    @pulumi.getter
    def latency(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency']:
        """
        Parameters for a latency threshold SLI.
        Structure is documented below.
        """
        return pulumi.get(self, "latency")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[_builtins.str]]:
        """
        An optional set of locations to which this SLI is relevant.
        Telemetry from other locations will not be used to calculate
        performance for this SLI. If omitted, this SLI applies to all
        locations in which the Service has activity. For service types
        that don't support breaking down by location, setting this
        field will result in an error.
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[_builtins.str]]:
        """
        An optional set of RPCs to which this SLI is relevant.
        Telemetry from other methods will not be used to calculate
        performance for this SLI. If omitted, this SLI applies to all
        the Service's methods. For service types that don't support
        breaking down by method, setting this field will result in an
        error.
        """
        return pulumi.get(self, "methods")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        The set of API versions to which this SLI is relevant.
        Telemetry from other API versions will not be used to
        calculate performance for this SLI. If omitted,
        this SLI applies to all API versions. For service types
        that don't support breaking down by version, setting this
        field will result in an error.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: Whether an availability SLI is enabled or not. Must be set to `true. Defaults to `true`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether an availability SLI is enabled or not. Must be set to `true. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency(dict):
    def __init__(__self__, *,
                 threshold: _builtins.str):
        """
        :param _builtins.str threshold: A duration string, e.g. 10s.
               Good service is defined to be the count of requests made to
               this service that return in no more than threshold.
        """
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.str:
        """
        A duration string, e.g. 10s.
        Good service is defined to be the count of requests made to
        this service that return in no more than threshold.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdPerformance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionCut":
            suggest = "distribution_cut"
        elif key == "goodTotalRatio":
            suggest = "good_total_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliGoodTotalRatioThresholdPerformance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_cut: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut'] = None,
                 good_total_ratio: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio'] = None):
        """
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutArgs' distribution_cut: Used when good_service is defined by a count of values aggregated in a
               Distribution that fall into a good range. The total_service is the
               total count of all values aggregated in the Distribution.
               Defines a distribution TimeSeries filter and thresholds used for
               measuring good service and total service.
               Structure is documented below.
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioArgs' good_total_ratio: A means to compute a ratio of `good_service` to `total_service`.
               Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
               Must specify exactly two of good, bad, and total service filters.
               The relationship good_service + bad_service = total_service
               will be assumed.
               Structure is documented below.
        """
        if distribution_cut is not None:
            pulumi.set(__self__, "distribution_cut", distribution_cut)
        if good_total_ratio is not None:
            pulumi.set(__self__, "good_total_ratio", good_total_ratio)

    @_builtins.property
    @pulumi.getter(name="distributionCut")
    def distribution_cut(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut']:
        """
        Used when good_service is defined by a count of values aggregated in a
        Distribution that fall into a good range. The total_service is the
        total count of all values aggregated in the Distribution.
        Defines a distribution TimeSeries filter and thresholds used for
        measuring good service and total service.
        Structure is documented below.
        """
        return pulumi.get(self, "distribution_cut")

    @_builtins.property
    @pulumi.getter(name="goodTotalRatio")
    def good_total_ratio(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio']:
        """
        A means to compute a ratio of `good_service` to `total_service`.
        Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
        Must specify exactly two of good, bad, and total service filters.
        The relationship good_service + bad_service = total_service
        will be assumed.
        Structure is documented below.
        """
        return pulumi.get(self, "good_total_ratio")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionFilter":
            suggest = "distribution_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_filter: _builtins.str,
                 range: 'outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange'):
        """
        :param _builtins.str distribution_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               aggregating values to quantify the good service provided.
               Must have ValueType = DISTRIBUTION and
               MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeArgs' range: Range of numerical values. The computed good_service
               will be the count of values x in the Distribution such
               that range.min <= x <= range.max. inclusive of min and
               max. Open ranges can be defined by setting
               just one of min or max.
               Structure is documented below.
        """
        pulumi.set(__self__, "distribution_filter", distribution_filter)
        pulumi.set(__self__, "range", range)

    @_builtins.property
    @pulumi.getter(name="distributionFilter")
    def distribution_filter(self) -> _builtins.str:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        aggregating values to quantify the good service provided.
        Must have ValueType = DISTRIBUTION and
        MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "distribution_filter")

    @_builtins.property
    @pulumi.getter
    def range(self) -> 'outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange':
        """
        Range of numerical values. The computed good_service
        will be the count of values x in the Distribution such
        that range.min <= x <= range.max. inclusive of min and
        max. Open ranges can be defined by setting
        just one of min or max.
        Structure is documented below.
        """
        return pulumi.get(self, "range")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange(dict):
    def __init__(__self__, *,
                 max: Optional[_builtins.float] = None,
                 min: Optional[_builtins.float] = None):
        """
        :param _builtins.float max: max value for the range (inclusive). If not given,
               will be set to "infinity", defining an open range
               ">= range.min"
        :param _builtins.float min: Min value for the range (inclusive). If not given,
               will be set to "-infinity", defining an open range
               "< range.max"
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[_builtins.float]:
        """
        max value for the range (inclusive). If not given,
        will be set to "infinity", defining an open range
        ">= range.min"
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[_builtins.float]:
        """
        Min value for the range (inclusive). If not given,
        will be set to "-infinity", defining an open range
        "< range.max"
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "badServiceFilter":
            suggest = "bad_service_filter"
        elif key == "goodServiceFilter":
            suggest = "good_service_filter"
        elif key == "totalServiceFilter":
            suggest = "total_service_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bad_service_filter: Optional[_builtins.str] = None,
                 good_service_filter: Optional[_builtins.str] = None,
                 total_service_filter: Optional[_builtins.str] = None):
        """
        :param _builtins.str bad_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying bad service provided, either demanded service that
               was not provided or demanded service that was of inadequate
               quality. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param _builtins.str good_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying good service provided. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param _builtins.str total_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying total demanded service. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        if bad_service_filter is not None:
            pulumi.set(__self__, "bad_service_filter", bad_service_filter)
        if good_service_filter is not None:
            pulumi.set(__self__, "good_service_filter", good_service_filter)
        if total_service_filter is not None:
            pulumi.set(__self__, "total_service_filter", total_service_filter)

    @_builtins.property
    @pulumi.getter(name="badServiceFilter")
    def bad_service_filter(self) -> Optional[_builtins.str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying bad service provided, either demanded service that
        was not provided or demanded service that was of inadequate
        quality. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "bad_service_filter")

    @_builtins.property
    @pulumi.getter(name="goodServiceFilter")
    def good_service_filter(self) -> Optional[_builtins.str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying good service provided. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "good_service_filter")

    @_builtins.property
    @pulumi.getter(name="totalServiceFilter")
    def total_service_filter(self) -> Optional[_builtins.str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying total demanded service. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "total_service_filter")


@pulumi.output_type
class SloWindowsBasedSliMetricMeanInRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeSeries":
            suggest = "time_series"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliMetricMeanInRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliMetricMeanInRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliMetricMeanInRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 range: 'outputs.SloWindowsBasedSliMetricMeanInRangeRange',
                 time_series: _builtins.str):
        """
        :param 'SloWindowsBasedSliMetricMeanInRangeRangeArgs' range: Range of numerical values. The computed good_service
               will be the count of values x in the Distribution such
               that range.min <= x <= range.max. inclusive of min and
               max. Open ranges can be defined by setting
               just one of min or max. Mean value `X` of `time_series`
               values should satisfy `range.min <= X <= range.max` for a
               good service.
               Structure is documented below.
        :param _builtins.str time_series: A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               specifying the TimeSeries to use for evaluating window
               The provided TimeSeries must have ValueType = INT64 or
               ValueType = DOUBLE and MetricKind = GAUGE. Mean value `X`
               should satisfy `range.min <= X <= range.max`
               under good service.
        """
        pulumi.set(__self__, "range", range)
        pulumi.set(__self__, "time_series", time_series)

    @_builtins.property
    @pulumi.getter
    def range(self) -> 'outputs.SloWindowsBasedSliMetricMeanInRangeRange':
        """
        Range of numerical values. The computed good_service
        will be the count of values x in the Distribution such
        that range.min <= x <= range.max. inclusive of min and
        max. Open ranges can be defined by setting
        just one of min or max. Mean value `X` of `time_series`
        values should satisfy `range.min <= X <= range.max` for a
        good service.
        Structure is documented below.
        """
        return pulumi.get(self, "range")

    @_builtins.property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> _builtins.str:
        """
        A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        specifying the TimeSeries to use for evaluating window
        The provided TimeSeries must have ValueType = INT64 or
        ValueType = DOUBLE and MetricKind = GAUGE. Mean value `X`
        should satisfy `range.min <= X <= range.max`
        under good service.
        """
        return pulumi.get(self, "time_series")


@pulumi.output_type
class SloWindowsBasedSliMetricMeanInRangeRange(dict):
    def __init__(__self__, *,
                 max: Optional[_builtins.float] = None,
                 min: Optional[_builtins.float] = None):
        """
        :param _builtins.float max: max value for the range (inclusive). If not given,
               will be set to "infinity", defining an open range
               ">= range.min"
        :param _builtins.float min: Min value for the range (inclusive). If not given,
               will be set to "-infinity", defining an open range
               "< range.max"
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[_builtins.float]:
        """
        max value for the range (inclusive). If not given,
        will be set to "infinity", defining an open range
        ">= range.min"
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[_builtins.float]:
        """
        Min value for the range (inclusive). If not given,
        will be set to "-infinity", defining an open range
        "< range.max"
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class SloWindowsBasedSliMetricSumInRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeSeries":
            suggest = "time_series"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliMetricSumInRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliMetricSumInRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliMetricSumInRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 range: 'outputs.SloWindowsBasedSliMetricSumInRangeRange',
                 time_series: _builtins.str):
        """
        :param 'SloWindowsBasedSliMetricSumInRangeRangeArgs' range: Range of numerical values. The computed good_service
               will be the count of values x in the Distribution such
               that range.min <= x <= range.max. inclusive of min and
               max. Open ranges can be defined by setting
               just one of min or max. Summed value `X` should satisfy
               `range.min <= X <= range.max` for a good window.
               Structure is documented below.
        :param _builtins.str time_series: A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               specifying the TimeSeries to use for evaluating window
               quality. The provided TimeSeries must have
               ValueType = INT64 or ValueType = DOUBLE and
               MetricKind = GAUGE.
               Summed value `X` should satisfy
               `range.min <= X <= range.max` for a good window.
        """
        pulumi.set(__self__, "range", range)
        pulumi.set(__self__, "time_series", time_series)

    @_builtins.property
    @pulumi.getter
    def range(self) -> 'outputs.SloWindowsBasedSliMetricSumInRangeRange':
        """
        Range of numerical values. The computed good_service
        will be the count of values x in the Distribution such
        that range.min <= x <= range.max. inclusive of min and
        max. Open ranges can be defined by setting
        just one of min or max. Summed value `X` should satisfy
        `range.min <= X <= range.max` for a good window.
        Structure is documented below.
        """
        return pulumi.get(self, "range")

    @_builtins.property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> _builtins.str:
        """
        A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        specifying the TimeSeries to use for evaluating window
        quality. The provided TimeSeries must have
        ValueType = INT64 or ValueType = DOUBLE and
        MetricKind = GAUGE.
        Summed value `X` should satisfy
        `range.min <= X <= range.max` for a good window.
        """
        return pulumi.get(self, "time_series")


@pulumi.output_type
class SloWindowsBasedSliMetricSumInRangeRange(dict):
    def __init__(__self__, *,
                 max: Optional[_builtins.float] = None,
                 min: Optional[_builtins.float] = None):
        """
        :param _builtins.float max: max value for the range (inclusive). If not given,
               will be set to "infinity", defining an open range
               ">= range.min"
        :param _builtins.float min: Min value for the range (inclusive). If not given,
               will be set to "-infinity", defining an open range
               "< range.max"
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[_builtins.float]:
        """
        max value for the range (inclusive). If not given,
        will be set to "infinity", defining an open range
        ">= range.min"
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[_builtins.float]:
        """
        Min value for the range (inclusive). If not given,
        will be set to "-infinity", defining an open range
        "< range.max"
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class UptimeCheckConfigContentMatcher(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPathMatcher":
            suggest = "json_path_matcher"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigContentMatcher. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigContentMatcher.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigContentMatcher.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: _builtins.str,
                 json_path_matcher: Optional['outputs.UptimeCheckConfigContentMatcherJsonPathMatcher'] = None,
                 matcher: Optional[_builtins.str] = None):
        """
        :param _builtins.str content: String or regex content to match (max 1024 bytes)
        :param 'UptimeCheckConfigContentMatcherJsonPathMatcherArgs' json_path_matcher: Information needed to perform a JSONPath content match. Used for `ContentMatcherOption::MATCHES_JSON_PATH` and `ContentMatcherOption::NOT_MATCHES_JSON_PATH`.
               Structure is documented below.
        :param _builtins.str matcher: The type of content matcher that will be applied to the server output, compared to the content string when the check is run.
               Default value is `CONTAINS_STRING`.
               Possible values are: `CONTAINS_STRING`, `NOT_CONTAINS_STRING`, `MATCHES_REGEX`, `NOT_MATCHES_REGEX`, `MATCHES_JSON_PATH`, `NOT_MATCHES_JSON_PATH`.
        """
        pulumi.set(__self__, "content", content)
        if json_path_matcher is not None:
            pulumi.set(__self__, "json_path_matcher", json_path_matcher)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        String or regex content to match (max 1024 bytes)
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="jsonPathMatcher")
    def json_path_matcher(self) -> Optional['outputs.UptimeCheckConfigContentMatcherJsonPathMatcher']:
        """
        Information needed to perform a JSONPath content match. Used for `ContentMatcherOption::MATCHES_JSON_PATH` and `ContentMatcherOption::NOT_MATCHES_JSON_PATH`.
        Structure is documented below.
        """
        return pulumi.get(self, "json_path_matcher")

    @_builtins.property
    @pulumi.getter
    def matcher(self) -> Optional[_builtins.str]:
        """
        The type of content matcher that will be applied to the server output, compared to the content string when the check is run.
        Default value is `CONTAINS_STRING`.
        Possible values are: `CONTAINS_STRING`, `NOT_CONTAINS_STRING`, `MATCHES_REGEX`, `NOT_MATCHES_REGEX`, `MATCHES_JSON_PATH`, `NOT_MATCHES_JSON_PATH`.
        """
        return pulumi.get(self, "matcher")


@pulumi.output_type
class UptimeCheckConfigContentMatcherJsonPathMatcher(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPath":
            suggest = "json_path"
        elif key == "jsonMatcher":
            suggest = "json_matcher"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigContentMatcherJsonPathMatcher. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigContentMatcherJsonPathMatcher.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigContentMatcherJsonPathMatcher.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_path: _builtins.str,
                 json_matcher: Optional[_builtins.str] = None):
        """
        :param _builtins.str json_path: JSONPath within the response output pointing to the expected `ContentMatcher::content` to match against.
        :param _builtins.str json_matcher: Options to perform JSONPath content matching.
               Default value is `EXACT_MATCH`.
               Possible values are: `EXACT_MATCH`, `REGEX_MATCH`.
        """
        pulumi.set(__self__, "json_path", json_path)
        if json_matcher is not None:
            pulumi.set(__self__, "json_matcher", json_matcher)

    @_builtins.property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> _builtins.str:
        """
        JSONPath within the response output pointing to the expected `ContentMatcher::content` to match against.
        """
        return pulumi.get(self, "json_path")

    @_builtins.property
    @pulumi.getter(name="jsonMatcher")
    def json_matcher(self) -> Optional[_builtins.str]:
        """
        Options to perform JSONPath content matching.
        Default value is `EXACT_MATCH`.
        Possible values are: `EXACT_MATCH`, `REGEX_MATCH`.
        """
        return pulumi.get(self, "json_matcher")


@pulumi.output_type
class UptimeCheckConfigHttpCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceptedResponseStatusCodes":
            suggest = "accepted_response_status_codes"
        elif key == "authInfo":
            suggest = "auth_info"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "customContentType":
            suggest = "custom_content_type"
        elif key == "maskHeaders":
            suggest = "mask_headers"
        elif key == "pingConfig":
            suggest = "ping_config"
        elif key == "requestMethod":
            suggest = "request_method"
        elif key == "serviceAgentAuthentication":
            suggest = "service_agent_authentication"
        elif key == "useSsl":
            suggest = "use_ssl"
        elif key == "validateSsl":
            suggest = "validate_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigHttpCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigHttpCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigHttpCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accepted_response_status_codes: Optional[Sequence['outputs.UptimeCheckConfigHttpCheckAcceptedResponseStatusCode']] = None,
                 auth_info: Optional['outputs.UptimeCheckConfigHttpCheckAuthInfo'] = None,
                 body: Optional[_builtins.str] = None,
                 content_type: Optional[_builtins.str] = None,
                 custom_content_type: Optional[_builtins.str] = None,
                 headers: Optional[Mapping[str, _builtins.str]] = None,
                 mask_headers: Optional[_builtins.bool] = None,
                 path: Optional[_builtins.str] = None,
                 ping_config: Optional['outputs.UptimeCheckConfigHttpCheckPingConfig'] = None,
                 port: Optional[_builtins.int] = None,
                 request_method: Optional[_builtins.str] = None,
                 service_agent_authentication: Optional['outputs.UptimeCheckConfigHttpCheckServiceAgentAuthentication'] = None,
                 use_ssl: Optional[_builtins.bool] = None,
                 validate_ssl: Optional[_builtins.bool] = None):
        """
        :param Sequence['UptimeCheckConfigHttpCheckAcceptedResponseStatusCodeArgs'] accepted_response_status_codes: If present, the check will only pass if the HTTP response status code is in this set of status codes. If empty, the HTTP status code will only pass if the HTTP status code is 200-299.
               Structure is documented below.
        :param 'UptimeCheckConfigHttpCheckAuthInfoArgs' auth_info: The authentication information using username and password. Optional when creating an HTTP check; defaults to empty. Do not use with other authentication fields.
               Structure is documented below.
        :param _builtins.str body: The request body associated with the HTTP POST request. If `content_type` is `URL_ENCODED`, the body passed in must be URL-encoded. Users can provide a `Content-Length` header via the `headers` field or the API will do so. If the `request_method` is `GET` and `body` is not empty, the API will return an error. The maximum byte size is 1 megabyte. Note - As with all bytes fields JSON representations are base64 encoded. e.g. `foo=bar` in URL-encoded form is `foo%3Dbar` and in base64 encoding is `Zm9vJTI1M0RiYXI=`.
        :param _builtins.str content_type: The content type to use for the check.
               Possible values are: `TYPE_UNSPECIFIED`, `URL_ENCODED`, `USER_PROVIDED`.
        :param _builtins.str custom_content_type: A user provided content type header to use for the check. The invalid configurations outlined in the `content_type` field apply to custom_content_type`, as well as the following 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set. 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not set.
        :param Mapping[str, _builtins.str] headers: The list of headers to send as part of the uptime check request. If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described in [RFC 2616 (page 31)](https://www.w3.org/Protocols/rfc2616/rfc2616.txt). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
        :param _builtins.bool mask_headers: Boolean specifying whether to encrypt the header information. Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if `mask_headers` is set to `true` then the headers will be obscured with `******`.
        :param _builtins.str path: The path to the page to run the check against. Will be combined with the host (specified within the MonitoredResource) and port to construct the full URL. If the provided path does not begin with `/`, a `/` will be prepended automatically. Optional (defaults to `/`).
        :param 'UptimeCheckConfigHttpCheckPingConfigArgs' ping_config: Contains information needed to add pings to an HTTP check.
               Structure is documented below.
        :param _builtins.int port: The port to the page to run the check against. Will be combined with `host` (specified within the `monitored_resource`) and path to construct the full URL. Optional (defaults to 80 without SSL, or 443 with SSL).
        :param _builtins.str request_method: The HTTP request method to use for the check. If set to `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
               Default value is `GET`.
               Possible values are: `METHOD_UNSPECIFIED`, `GET`, `POST`.
        :param 'UptimeCheckConfigHttpCheckServiceAgentAuthenticationArgs' service_agent_authentication: The authentication information using the Monitoring Service Agent. Optional when creating an HTTPS check; defaults to empty. Do not use with other authentication fields.
               Structure is documented below.
        :param _builtins.bool use_ssl: If true, use HTTPS instead of HTTP to run the check.
        :param _builtins.bool validate_ssl: Boolean specifying whether to include SSL certificate validation as a part of the Uptime check. Only applies to checks where `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`, setting `validate_ssl` to `true` has no effect.
        """
        if accepted_response_status_codes is not None:
            pulumi.set(__self__, "accepted_response_status_codes", accepted_response_status_codes)
        if auth_info is not None:
            pulumi.set(__self__, "auth_info", auth_info)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if custom_content_type is not None:
            pulumi.set(__self__, "custom_content_type", custom_content_type)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if mask_headers is not None:
            pulumi.set(__self__, "mask_headers", mask_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if ping_config is not None:
            pulumi.set(__self__, "ping_config", ping_config)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_method is not None:
            pulumi.set(__self__, "request_method", request_method)
        if service_agent_authentication is not None:
            pulumi.set(__self__, "service_agent_authentication", service_agent_authentication)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if validate_ssl is not None:
            pulumi.set(__self__, "validate_ssl", validate_ssl)

    @_builtins.property
    @pulumi.getter(name="acceptedResponseStatusCodes")
    def accepted_response_status_codes(self) -> Optional[Sequence['outputs.UptimeCheckConfigHttpCheckAcceptedResponseStatusCode']]:
        """
        If present, the check will only pass if the HTTP response status code is in this set of status codes. If empty, the HTTP status code will only pass if the HTTP status code is 200-299.
        Structure is documented below.
        """
        return pulumi.get(self, "accepted_response_status_codes")

    @_builtins.property
    @pulumi.getter(name="authInfo")
    def auth_info(self) -> Optional['outputs.UptimeCheckConfigHttpCheckAuthInfo']:
        """
        The authentication information using username and password. Optional when creating an HTTP check; defaults to empty. Do not use with other authentication fields.
        Structure is documented below.
        """
        return pulumi.get(self, "auth_info")

    @_builtins.property
    @pulumi.getter
    def body(self) -> Optional[_builtins.str]:
        """
        The request body associated with the HTTP POST request. If `content_type` is `URL_ENCODED`, the body passed in must be URL-encoded. Users can provide a `Content-Length` header via the `headers` field or the API will do so. If the `request_method` is `GET` and `body` is not empty, the API will return an error. The maximum byte size is 1 megabyte. Note - As with all bytes fields JSON representations are base64 encoded. e.g. `foo=bar` in URL-encoded form is `foo%3Dbar` and in base64 encoding is `Zm9vJTI1M0RiYXI=`.
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[_builtins.str]:
        """
        The content type to use for the check.
        Possible values are: `TYPE_UNSPECIFIED`, `URL_ENCODED`, `USER_PROVIDED`.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="customContentType")
    def custom_content_type(self) -> Optional[_builtins.str]:
        """
        A user provided content type header to use for the check. The invalid configurations outlined in the `content_type` field apply to custom_content_type`, as well as the following 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set. 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not set.
        """
        return pulumi.get(self, "custom_content_type")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The list of headers to send as part of the uptime check request. If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described in [RFC 2616 (page 31)](https://www.w3.org/Protocols/rfc2616/rfc2616.txt). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter(name="maskHeaders")
    def mask_headers(self) -> Optional[_builtins.bool]:
        """
        Boolean specifying whether to encrypt the header information. Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if `mask_headers` is set to `true` then the headers will be obscured with `******`.
        """
        return pulumi.get(self, "mask_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path to the page to run the check against. Will be combined with the host (specified within the MonitoredResource) and port to construct the full URL. If the provided path does not begin with `/`, a `/` will be prepended automatically. Optional (defaults to `/`).
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pingConfig")
    def ping_config(self) -> Optional['outputs.UptimeCheckConfigHttpCheckPingConfig']:
        """
        Contains information needed to add pings to an HTTP check.
        Structure is documented below.
        """
        return pulumi.get(self, "ping_config")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port to the page to run the check against. Will be combined with `host` (specified within the `monitored_resource`) and path to construct the full URL. Optional (defaults to 80 without SSL, or 443 with SSL).
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[_builtins.str]:
        """
        The HTTP request method to use for the check. If set to `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
        Default value is `GET`.
        Possible values are: `METHOD_UNSPECIFIED`, `GET`, `POST`.
        """
        return pulumi.get(self, "request_method")

    @_builtins.property
    @pulumi.getter(name="serviceAgentAuthentication")
    def service_agent_authentication(self) -> Optional['outputs.UptimeCheckConfigHttpCheckServiceAgentAuthentication']:
        """
        The authentication information using the Monitoring Service Agent. Optional when creating an HTTPS check; defaults to empty. Do not use with other authentication fields.
        Structure is documented below.
        """
        return pulumi.get(self, "service_agent_authentication")

    @_builtins.property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[_builtins.bool]:
        """
        If true, use HTTPS instead of HTTP to run the check.
        """
        return pulumi.get(self, "use_ssl")

    @_builtins.property
    @pulumi.getter(name="validateSsl")
    def validate_ssl(self) -> Optional[_builtins.bool]:
        """
        Boolean specifying whether to include SSL certificate validation as a part of the Uptime check. Only applies to checks where `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`, setting `validate_ssl` to `true` has no effect.
        """
        return pulumi.get(self, "validate_ssl")


@pulumi.output_type
class UptimeCheckConfigHttpCheckAcceptedResponseStatusCode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusClass":
            suggest = "status_class"
        elif key == "statusValue":
            suggest = "status_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigHttpCheckAcceptedResponseStatusCode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigHttpCheckAcceptedResponseStatusCode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigHttpCheckAcceptedResponseStatusCode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_class: Optional[_builtins.str] = None,
                 status_value: Optional[_builtins.int] = None):
        """
        :param _builtins.str status_class: A class of status codes to accept.
               Possible values are: `STATUS_CLASS_1XX`, `STATUS_CLASS_2XX`, `STATUS_CLASS_3XX`, `STATUS_CLASS_4XX`, `STATUS_CLASS_5XX`, `STATUS_CLASS_ANY`.
        :param _builtins.int status_value: A status code to accept.
        """
        if status_class is not None:
            pulumi.set(__self__, "status_class", status_class)
        if status_value is not None:
            pulumi.set(__self__, "status_value", status_value)

    @_builtins.property
    @pulumi.getter(name="statusClass")
    def status_class(self) -> Optional[_builtins.str]:
        """
        A class of status codes to accept.
        Possible values are: `STATUS_CLASS_1XX`, `STATUS_CLASS_2XX`, `STATUS_CLASS_3XX`, `STATUS_CLASS_4XX`, `STATUS_CLASS_5XX`, `STATUS_CLASS_ANY`.
        """
        return pulumi.get(self, "status_class")

    @_builtins.property
    @pulumi.getter(name="statusValue")
    def status_value(self) -> Optional[_builtins.int]:
        """
        A status code to accept.
        """
        return pulumi.get(self, "status_value")


@pulumi.output_type
class UptimeCheckConfigHttpCheckAuthInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordWoVersion":
            suggest = "password_wo_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigHttpCheckAuthInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigHttpCheckAuthInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigHttpCheckAuthInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 username: _builtins.str,
                 password: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str username: The username to authenticate.
        :param _builtins.str password: The password to authenticate.
        :param _builtins.str password_wo_version: The password write-only version.
        """
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username to authenticate.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password to authenticate.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.str]:
        """
        The password write-only version.
        """
        return pulumi.get(self, "password_wo_version")


@pulumi.output_type
class UptimeCheckConfigHttpCheckPingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pingsCount":
            suggest = "pings_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigHttpCheckPingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigHttpCheckPingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigHttpCheckPingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pings_count: _builtins.int):
        """
        :param _builtins.int pings_count: Number of ICMP pings. A maximum of 3 ICMP pings is currently supported.
        """
        pulumi.set(__self__, "pings_count", pings_count)

    @_builtins.property
    @pulumi.getter(name="pingsCount")
    def pings_count(self) -> _builtins.int:
        """
        Number of ICMP pings. A maximum of 3 ICMP pings is currently supported.
        """
        return pulumi.get(self, "pings_count")


@pulumi.output_type
class UptimeCheckConfigHttpCheckServiceAgentAuthentication(dict):
    def __init__(__self__, *,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of authentication to use.
               Possible values are: `SERVICE_AGENT_AUTHENTICATION_TYPE_UNSPECIFIED`, `OIDC_TOKEN`.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of authentication to use.
        Possible values are: `SERVICE_AGENT_AUTHENTICATION_TYPE_UNSPECIFIED`, `OIDC_TOKEN`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class UptimeCheckConfigMonitoredResource(dict):
    def __init__(__self__, *,
                 labels: Mapping[str, _builtins.str],
                 type: _builtins.str):
        """
        :param Mapping[str, _builtins.str] labels: Values for all of the labels listed in the associated monitored resource descriptor. For example, Compute Engine VM instances use the labels `project_id`, `instance_id`, and `zone`.
        :param _builtins.str type: The monitored resource type. This field must match the type field of a [`MonitoredResourceDescriptor`](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.monitoredResourceDescriptors#MonitoredResourceDescriptor) object. For example, the type of a Compute Engine VM instance is `gce_instance`. For a list of types, see [Monitoring resource types](https://cloud.google.com/monitoring/api/resources) and [Logging resource types](https://cloud.google.com/logging/docs/api/v2/resource-list).
        """
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Values for all of the labels listed in the associated monitored resource descriptor. For example, Compute Engine VM instances use the labels `project_id`, `instance_id`, and `zone`.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The monitored resource type. This field must match the type field of a [`MonitoredResourceDescriptor`](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.monitoredResourceDescriptors#MonitoredResourceDescriptor) object. For example, the type of a Compute Engine VM instance is `gce_instance`. For a list of types, see [Monitoring resource types](https://cloud.google.com/monitoring/api/resources) and [Logging resource types](https://cloud.google.com/logging/docs/api/v2/resource-list).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class UptimeCheckConfigResourceGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigResourceGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigResourceGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigResourceGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str group_id: The group of resources being monitored. Should be the `name` of a group
        :param _builtins.str resource_type: The resource type of the group members.
               Possible values are: `RESOURCE_TYPE_UNSPECIFIED`, `INSTANCE`, `AWS_ELB_LOAD_BALANCER`.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[_builtins.str]:
        """
        The group of resources being monitored. Should be the `name` of a group
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The resource type of the group members.
        Possible values are: `RESOURCE_TYPE_UNSPECIFIED`, `INSTANCE`, `AWS_ELB_LOAD_BALANCER`.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class UptimeCheckConfigSyntheticMonitor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudFunctionV2":
            suggest = "cloud_function_v2"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigSyntheticMonitor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigSyntheticMonitor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigSyntheticMonitor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_function_v2: 'outputs.UptimeCheckConfigSyntheticMonitorCloudFunctionV2'):
        """
        :param 'UptimeCheckConfigSyntheticMonitorCloudFunctionV2Args' cloud_function_v2: Target a Synthetic Monitor GCFv2 Instance
               Structure is documented below.
               
               
               <a name="nested_synthetic_monitor_cloud_function_v2"></a>The `cloud_function_v2` block supports:
        """
        pulumi.set(__self__, "cloud_function_v2", cloud_function_v2)

    @_builtins.property
    @pulumi.getter(name="cloudFunctionV2")
    def cloud_function_v2(self) -> 'outputs.UptimeCheckConfigSyntheticMonitorCloudFunctionV2':
        """
        Target a Synthetic Monitor GCFv2 Instance
        Structure is documented below.


        <a name="nested_synthetic_monitor_cloud_function_v2"></a>The `cloud_function_v2` block supports:
        """
        return pulumi.get(self, "cloud_function_v2")


@pulumi.output_type
class UptimeCheckConfigSyntheticMonitorCloudFunctionV2(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: A unique resource name for this UptimeCheckConfig. The format is `projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID]`.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique resource name for this UptimeCheckConfig. The format is `projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID]`.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class UptimeCheckConfigTcpCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pingConfig":
            suggest = "ping_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigTcpCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigTcpCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigTcpCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 ping_config: Optional['outputs.UptimeCheckConfigTcpCheckPingConfig'] = None):
        """
        :param _builtins.int port: The port to the page to run the check against. Will be combined with host (specified within the `monitored_resource`) to construct the full URL.
        :param 'UptimeCheckConfigTcpCheckPingConfigArgs' ping_config: Contains information needed to add pings to a TCP check.
               Structure is documented below.
        """
        pulumi.set(__self__, "port", port)
        if ping_config is not None:
            pulumi.set(__self__, "ping_config", ping_config)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port to the page to run the check against. Will be combined with host (specified within the `monitored_resource`) to construct the full URL.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="pingConfig")
    def ping_config(self) -> Optional['outputs.UptimeCheckConfigTcpCheckPingConfig']:
        """
        Contains information needed to add pings to a TCP check.
        Structure is documented below.
        """
        return pulumi.get(self, "ping_config")


@pulumi.output_type
class UptimeCheckConfigTcpCheckPingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pingsCount":
            suggest = "pings_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigTcpCheckPingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigTcpCheckPingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigTcpCheckPingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pings_count: _builtins.int):
        """
        :param _builtins.int pings_count: Number of ICMP pings. A maximum of 3 ICMP pings is currently supported.
        """
        pulumi.set(__self__, "pings_count", pings_count)

    @_builtins.property
    @pulumi.getter(name="pingsCount")
    def pings_count(self) -> _builtins.int:
        """
        Number of ICMP pings. A maximum of 3 ICMP pings is currently supported.
        """
        return pulumi.get(self, "pings_count")


@pulumi.output_type
class GetAppEngineServiceTelemetryResult(dict):
    def __init__(__self__, *,
                 resource_name: _builtins.str):
        """
        :param _builtins.str resource_name: The full name of the resource that defines this service.
               Formatted as described in
               https://cloud.google.com/apis/design/resource_names.
        """
        pulumi.set(__self__, "resource_name", resource_name)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> _builtins.str:
        """
        The full name of the resource that defines this service.
        Formatted as described in
        https://cloud.google.com/apis/design/resource_names.
        """
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class GetClusterIstioServiceTelemetryResult(dict):
    def __init__(__self__, *,
                 resource_name: _builtins.str):
        """
        :param _builtins.str resource_name: The full name of the resource that defines this service.
               Formatted as described in
               https://cloud.google.com/apis/design/resource_names.
        """
        pulumi.set(__self__, "resource_name", resource_name)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> _builtins.str:
        """
        The full name of the resource that defines this service.
        Formatted as described in
        https://cloud.google.com/apis/design/resource_names.
        """
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class GetIstioCanonicalServiceTelemetryResult(dict):
    def __init__(__self__, *,
                 resource_name: _builtins.str):
        """
        :param _builtins.str resource_name: The full name of the resource that defines this service.
               Formatted as described in
               https://cloud.google.com/apis/design/resource_names.
        """
        pulumi.set(__self__, "resource_name", resource_name)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> _builtins.str:
        """
        The full name of the resource that defines this service.
        Formatted as described in
        https://cloud.google.com/apis/design/resource_names.
        """
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class GetMeshIstioServiceTelemetryResult(dict):
    def __init__(__self__, *,
                 resource_name: _builtins.str):
        """
        :param _builtins.str resource_name: The full name of the resource that defines this service.
               Formatted as described in
               https://cloud.google.com/apis/design/resource_names.
        """
        pulumi.set(__self__, "resource_name", resource_name)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> _builtins.str:
        """
        The full name of the resource that defines this service.
        Formatted as described in
        https://cloud.google.com/apis/design/resource_names.
        """
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class GetNotificationChannelSensitiveLabelResult(dict):
    def __init__(__self__, *,
                 auth_token: _builtins.str,
                 password: _builtins.str,
                 service_key: _builtins.str):
        """
        :param _builtins.str auth_token: An authorization token for a notification channel. Channel types that support this field include: slack
        :param _builtins.str password: An password for a notification channel. Channel types that support this field include: webhook_basicauth
        :param _builtins.str service_key: An servicekey token for a notification channel. Channel types that support this field include: pagerduty
        """
        pulumi.set(__self__, "auth_token", auth_token)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "service_key", service_key)

    @_builtins.property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> _builtins.str:
        """
        An authorization token for a notification channel. Channel types that support this field include: slack
        """
        return pulumi.get(self, "auth_token")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        An password for a notification channel. Channel types that support this field include: webhook_basicauth
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> _builtins.str:
        """
        An servicekey token for a notification channel. Channel types that support this field include: pagerduty
        """
        return pulumi.get(self, "service_key")


@pulumi.output_type
class GetUptimeCheckIPsUptimeCheckIpResult(dict):
    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 location: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str ip_address: The IP address from which the Uptime check originates. This is a fully specified IP address
               (not an IP address range). Most IP addresses, as of this publication, are in IPv4 format; however, one should not
               rely on the IP addresses being in IPv4 format indefinitely, and should support interpreting this field in either
               IPv4 or IPv6 format.
        :param _builtins.str location: A more specific location within the region that typically encodes a particular city/town/metro
               (and its containing state/province or country) within the broader umbrella region category.
        :param _builtins.str region: A broad region category in which the IP address is located.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address from which the Uptime check originates. This is a fully specified IP address
        (not an IP address range). Most IP addresses, as of this publication, are in IPv4 format; however, one should not
        rely on the IP addresses being in IPv4 format indefinitely, and should support interpreting this field in either
        IPv4 or IPv6 format.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        A more specific location within the region that typically encodes a particular city/town/metro
        (and its containing state/province or country) within the broader umbrella region category.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        A broad region category in which the IP address is located.
        """
        return pulumi.get(self, "region")


