# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupVaultArgs', 'BackupVault']

@pulumi.input_type
class BackupVaultArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 backup_region: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_policy: Optional[pulumi.Input['BackupVaultBackupRetentionPolicyArgs']] = None,
                 backup_vault_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackupVault resource.
        :param pulumi.Input[_builtins.str] location: Location (region) of the backup vault.
        :param pulumi.Input[_builtins.str] backup_region: Region in which backup is stored.
        :param pulumi.Input['BackupVaultBackupRetentionPolicyArgs'] backup_retention_policy: Backup retention policy defining the retention of the backups.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] backup_vault_type: Type of the backup vault to be created. Default is IN_REGION.
               Possible values are: `BACKUP_VAULT_TYPE_UNSPECIFIED`, `IN_REGION`, `CROSS_REGION`.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource name of the backup vault. Needs to be unique per location.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        if backup_region is not None:
            pulumi.set(__self__, "backup_region", backup_region)
        if backup_retention_policy is not None:
            pulumi.set(__self__, "backup_retention_policy", backup_retention_policy)
        if backup_vault_type is not None:
            pulumi.set(__self__, "backup_vault_type", backup_vault_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Location (region) of the backup vault.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="backupRegion")
    def backup_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region in which backup is stored.
        """
        return pulumi.get(self, "backup_region")

    @backup_region.setter
    def backup_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_region", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPolicy")
    def backup_retention_policy(self) -> Optional[pulumi.Input['BackupVaultBackupRetentionPolicyArgs']]:
        """
        Backup retention policy defining the retention of the backups.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_retention_policy")

    @backup_retention_policy.setter
    def backup_retention_policy(self, value: Optional[pulumi.Input['BackupVaultBackupRetentionPolicyArgs']]):
        pulumi.set(self, "backup_retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="backupVaultType")
    def backup_vault_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the backup vault to be created. Default is IN_REGION.
        Possible values are: `BACKUP_VAULT_TYPE_UNSPECIFIED`, `IN_REGION`, `CROSS_REGION`.
        """
        return pulumi.get(self, "backup_vault_type")

    @backup_vault_type.setter
    def backup_vault_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_vault_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the backup vault. Needs to be unique per location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _BackupVaultState:
    def __init__(__self__, *,
                 backup_region: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_policy: Optional[pulumi.Input['BackupVaultBackupRetentionPolicyArgs']] = None,
                 backup_vault_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_backup_vault: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source_backup_vault: Optional[pulumi.Input[_builtins.str]] = None,
                 source_region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupVault resources.
        :param pulumi.Input[_builtins.str] backup_region: Region in which backup is stored.
        :param pulumi.Input['BackupVaultBackupRetentionPolicyArgs'] backup_retention_policy: Backup retention policy defining the retention of the backups.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] backup_vault_type: Type of the backup vault to be created. Default is IN_REGION.
               Possible values are: `BACKUP_VAULT_TYPE_UNSPECIFIED`, `IN_REGION`, `CROSS_REGION`.
        :param pulumi.Input[_builtins.str] create_time: Create time of the backup vault. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] destination_backup_vault: Name of the Backup vault created in backup region.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location (region) of the backup vault.
        :param pulumi.Input[_builtins.str] name: The resource name of the backup vault. Needs to be unique per location.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] source_backup_vault: Name of the Backup vault created in source region.
        :param pulumi.Input[_builtins.str] source_region: Region in which the backup vault is created.
        :param pulumi.Input[_builtins.str] state: The state of the Backup Vault.
        """
        if backup_region is not None:
            pulumi.set(__self__, "backup_region", backup_region)
        if backup_retention_policy is not None:
            pulumi.set(__self__, "backup_retention_policy", backup_retention_policy)
        if backup_vault_type is not None:
            pulumi.set(__self__, "backup_vault_type", backup_vault_type)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_backup_vault is not None:
            pulumi.set(__self__, "destination_backup_vault", destination_backup_vault)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if source_backup_vault is not None:
            pulumi.set(__self__, "source_backup_vault", source_backup_vault)
        if source_region is not None:
            pulumi.set(__self__, "source_region", source_region)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="backupRegion")
    def backup_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region in which backup is stored.
        """
        return pulumi.get(self, "backup_region")

    @backup_region.setter
    def backup_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_region", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPolicy")
    def backup_retention_policy(self) -> Optional[pulumi.Input['BackupVaultBackupRetentionPolicyArgs']]:
        """
        Backup retention policy defining the retention of the backups.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_retention_policy")

    @backup_retention_policy.setter
    def backup_retention_policy(self, value: Optional[pulumi.Input['BackupVaultBackupRetentionPolicyArgs']]):
        pulumi.set(self, "backup_retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="backupVaultType")
    def backup_vault_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the backup vault to be created. Default is IN_REGION.
        Possible values are: `BACKUP_VAULT_TYPE_UNSPECIFIED`, `IN_REGION`, `CROSS_REGION`.
        """
        return pulumi.get(self, "backup_vault_type")

    @backup_vault_type.setter
    def backup_vault_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_vault_type", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create time of the backup vault. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationBackupVault")
    def destination_backup_vault(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Backup vault created in backup region.
        """
        return pulumi.get(self, "destination_backup_vault")

    @destination_backup_vault.setter
    def destination_backup_vault(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_backup_vault", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location (region) of the backup vault.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the backup vault. Needs to be unique per location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="sourceBackupVault")
    def source_backup_vault(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Backup vault created in source region.
        """
        return pulumi.get(self, "source_backup_vault")

    @source_backup_vault.setter
    def source_backup_vault(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_backup_vault", value)

    @_builtins.property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region in which the backup vault is created.
        """
        return pulumi.get(self, "source_region")

    @source_region.setter
    def source_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_region", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the Backup Vault.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:netapp/backupVault:BackupVault")
class BackupVault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_region: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_policy: Optional[pulumi.Input[Union['BackupVaultBackupRetentionPolicyArgs', 'BackupVaultBackupRetentionPolicyArgsDict']]] = None,
                 backup_vault_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A backup vault is the location where backups are stored. You can only create one backup vault per region.
        A vault can hold multiple backups for multiple volumes in that region.

        To get more information about BackupVault, see:

        * [API documentation](https://cloud.google.com/netapp/volumes/docs/reference/rest/v1/projects.locations.backupVaults)
        * How-to Guides
            * [Documentation](https://cloud.google.com/netapp/volumes/docs/protect-data/about-volume-backups)

        ## Example Usage

        ### Netapp Backup Vault

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_backup_vault = gcp.netapp.BackupVault("test_backup_vault",
            name="test-backup-vault",
            location="us-west1",
            description="Terraform created vault",
            labels={
                "creator": "testuser",
            })
        ```

        ## Import

        BackupVault can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupVaults/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, BackupVault can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/backupVault:BackupVault default projects/{{project}}/locations/{{location}}/backupVaults/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/backupVault:BackupVault default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/backupVault:BackupVault default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_region: Region in which backup is stored.
        :param pulumi.Input[Union['BackupVaultBackupRetentionPolicyArgs', 'BackupVaultBackupRetentionPolicyArgsDict']] backup_retention_policy: Backup retention policy defining the retention of the backups.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] backup_vault_type: Type of the backup vault to be created. Default is IN_REGION.
               Possible values are: `BACKUP_VAULT_TYPE_UNSPECIFIED`, `IN_REGION`, `CROSS_REGION`.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location (region) of the backup vault.
        :param pulumi.Input[_builtins.str] name: The resource name of the backup vault. Needs to be unique per location.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupVaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A backup vault is the location where backups are stored. You can only create one backup vault per region.
        A vault can hold multiple backups for multiple volumes in that region.

        To get more information about BackupVault, see:

        * [API documentation](https://cloud.google.com/netapp/volumes/docs/reference/rest/v1/projects.locations.backupVaults)
        * How-to Guides
            * [Documentation](https://cloud.google.com/netapp/volumes/docs/protect-data/about-volume-backups)

        ## Example Usage

        ### Netapp Backup Vault

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_backup_vault = gcp.netapp.BackupVault("test_backup_vault",
            name="test-backup-vault",
            location="us-west1",
            description="Terraform created vault",
            labels={
                "creator": "testuser",
            })
        ```

        ## Import

        BackupVault can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupVaults/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, BackupVault can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/backupVault:BackupVault default projects/{{project}}/locations/{{location}}/backupVaults/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/backupVault:BackupVault default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/backupVault:BackupVault default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param BackupVaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupVaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_region: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_policy: Optional[pulumi.Input[Union['BackupVaultBackupRetentionPolicyArgs', 'BackupVaultBackupRetentionPolicyArgsDict']]] = None,
                 backup_vault_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupVaultArgs.__new__(BackupVaultArgs)

            __props__.__dict__["backup_region"] = backup_region
            __props__.__dict__["backup_retention_policy"] = backup_retention_policy
            __props__.__dict__["backup_vault_type"] = backup_vault_type
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["destination_backup_vault"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["source_backup_vault"] = None
            __props__.__dict__["source_region"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BackupVault, __self__).__init__(
            'gcp:netapp/backupVault:BackupVault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_region: Optional[pulumi.Input[_builtins.str]] = None,
            backup_retention_policy: Optional[pulumi.Input[Union['BackupVaultBackupRetentionPolicyArgs', 'BackupVaultBackupRetentionPolicyArgsDict']]] = None,
            backup_vault_type: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_backup_vault: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            source_backup_vault: Optional[pulumi.Input[_builtins.str]] = None,
            source_region: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupVault':
        """
        Get an existing BackupVault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_region: Region in which backup is stored.
        :param pulumi.Input[Union['BackupVaultBackupRetentionPolicyArgs', 'BackupVaultBackupRetentionPolicyArgsDict']] backup_retention_policy: Backup retention policy defining the retention of the backups.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] backup_vault_type: Type of the backup vault to be created. Default is IN_REGION.
               Possible values are: `BACKUP_VAULT_TYPE_UNSPECIFIED`, `IN_REGION`, `CROSS_REGION`.
        :param pulumi.Input[_builtins.str] create_time: Create time of the backup vault. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] destination_backup_vault: Name of the Backup vault created in backup region.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location (region) of the backup vault.
        :param pulumi.Input[_builtins.str] name: The resource name of the backup vault. Needs to be unique per location.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] source_backup_vault: Name of the Backup vault created in source region.
        :param pulumi.Input[_builtins.str] source_region: Region in which the backup vault is created.
        :param pulumi.Input[_builtins.str] state: The state of the Backup Vault.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupVaultState.__new__(_BackupVaultState)

        __props__.__dict__["backup_region"] = backup_region
        __props__.__dict__["backup_retention_policy"] = backup_retention_policy
        __props__.__dict__["backup_vault_type"] = backup_vault_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_backup_vault"] = destination_backup_vault
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["source_backup_vault"] = source_backup_vault
        __props__.__dict__["source_region"] = source_region
        __props__.__dict__["state"] = state
        return BackupVault(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupRegion")
    def backup_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Region in which backup is stored.
        """
        return pulumi.get(self, "backup_region")

    @_builtins.property
    @pulumi.getter(name="backupRetentionPolicy")
    def backup_retention_policy(self) -> pulumi.Output[Optional['outputs.BackupVaultBackupRetentionPolicy']]:
        """
        Backup retention policy defining the retention of the backups.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_retention_policy")

    @_builtins.property
    @pulumi.getter(name="backupVaultType")
    def backup_vault_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the backup vault to be created. Default is IN_REGION.
        Possible values are: `BACKUP_VAULT_TYPE_UNSPECIFIED`, `IN_REGION`, `CROSS_REGION`.
        """
        return pulumi.get(self, "backup_vault_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Create time of the backup vault. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationBackupVault")
    def destination_backup_vault(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Backup vault created in backup region.
        """
        return pulumi.get(self, "destination_backup_vault")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Location (region) of the backup vault.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the backup vault. Needs to be unique per location.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="sourceBackupVault")
    def source_backup_vault(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Backup vault created in source region.
        """
        return pulumi.get(self, "source_backup_vault")

    @_builtins.property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> pulumi.Output[_builtins.str]:
        """
        Region in which the backup vault is created.
        """
        return pulumi.get(self, "source_region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the Backup Vault.
        """
        return pulumi.get(self, "state")

