# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConnectivityTestRunResult',
    'AwaitableGetConnectivityTestRunResult',
    'get_connectivity_test_run',
    'get_connectivity_test_run_output',
]

@pulumi.output_type
class GetConnectivityTestRunResult:
    """
    A collection of values returned by getConnectivityTestRun.
    """
    def __init__(__self__, id=None, name=None, project=None, reachability_details=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if reachability_details and not isinstance(reachability_details, list):
            raise TypeError("Expected argument 'reachability_details' to be a list")
        pulumi.set(__self__, "reachability_details", reachability_details)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="reachabilityDetails")
    def reachability_details(self) -> Sequence['outputs.GetConnectivityTestRunReachabilityDetailResult']:
        """
        Connectivity test reachability details.
        Structure is documented below.
        """
        return pulumi.get(self, "reachability_details")


class AwaitableGetConnectivityTestRunResult(GetConnectivityTestRunResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectivityTestRunResult(
            id=self.id,
            name=self.name,
            project=self.project,
            reachability_details=self.reachability_details)


def get_connectivity_test_run(name: Optional[_builtins.str] = None,
                              project: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectivityTestRunResult:
    """
    !> This datasource triggers side effects on the target resource. It will take a long time to refresh (i.e. `pulumi preview` will take much longer than usual) and may modify the state of the parent resource or other copies of the resource copying the same parent.

    A connectivity test is a static analysis of your resource configurations
    that enables you to evaluate connectivity to and from Google Cloud
    resources in your Virtual Private Cloud (VPC) network. This data source allows
    you to trigger a rerun operation on a connectivity test and return the results.

    To get more information about connectivity tests, see:

    * [API documentation](https://cloud.google.com/network-intelligence-center/docs/reference/networkmanagement/rest/v1/projects.locations.global.connectivityTests/rerun)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/network-intelligence-center/docs)

    ## Example Usage

    ### Network Management Connectivity Test Run Instances

    ```python
    import pulumi
    import pulumi_gcp as gcp

    vpc = gcp.compute.Network("vpc", name="conn-test-net")
    debian9 = gcp.compute.get_image(family="debian-11",
        project="debian-cloud")
    source = gcp.compute.Instance("source",
        network_interfaces=[{
            "access_configs": [{}],
            "network": vpc.id,
        }],
        name="source-vm",
        machine_type="e2-medium",
        boot_disk={
            "initialize_params": {
                "image": debian9.id,
            },
        })
    destination = gcp.compute.Instance("destination",
        network_interfaces=[{
            "access_configs": [{}],
            "network": vpc.id,
        }],
        name="dest-vm",
        machine_type="e2-medium",
        boot_disk={
            "initialize_params": {
                "image": debian9.id,
            },
        })
    instance_test = gcp.networkmanagement.ConnectivityTest("instance-test",
        name="conn-test-instances",
        source={
            "instance": source.id,
        },
        destination={
            "instance": destination.id,
        },
        protocol="TCP",
        labels={
            "env": "test",
        })
    instance_test_run = gcp.networkmanagement.get_connectivity_test_run_output(name=instance_test.name)
    ```


    :param _builtins.str name: Unique name for the connectivity test.
           
           
           - - -
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:networkmanagement/getConnectivityTestRun:getConnectivityTestRun', __args__, opts=opts, typ=GetConnectivityTestRunResult).value

    return AwaitableGetConnectivityTestRunResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        reachability_details=pulumi.get(__ret__, 'reachability_details'))
def get_connectivity_test_run_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                     project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectivityTestRunResult]:
    """
    !> This datasource triggers side effects on the target resource. It will take a long time to refresh (i.e. `pulumi preview` will take much longer than usual) and may modify the state of the parent resource or other copies of the resource copying the same parent.

    A connectivity test is a static analysis of your resource configurations
    that enables you to evaluate connectivity to and from Google Cloud
    resources in your Virtual Private Cloud (VPC) network. This data source allows
    you to trigger a rerun operation on a connectivity test and return the results.

    To get more information about connectivity tests, see:

    * [API documentation](https://cloud.google.com/network-intelligence-center/docs/reference/networkmanagement/rest/v1/projects.locations.global.connectivityTests/rerun)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/network-intelligence-center/docs)

    ## Example Usage

    ### Network Management Connectivity Test Run Instances

    ```python
    import pulumi
    import pulumi_gcp as gcp

    vpc = gcp.compute.Network("vpc", name="conn-test-net")
    debian9 = gcp.compute.get_image(family="debian-11",
        project="debian-cloud")
    source = gcp.compute.Instance("source",
        network_interfaces=[{
            "access_configs": [{}],
            "network": vpc.id,
        }],
        name="source-vm",
        machine_type="e2-medium",
        boot_disk={
            "initialize_params": {
                "image": debian9.id,
            },
        })
    destination = gcp.compute.Instance("destination",
        network_interfaces=[{
            "access_configs": [{}],
            "network": vpc.id,
        }],
        name="dest-vm",
        machine_type="e2-medium",
        boot_disk={
            "initialize_params": {
                "image": debian9.id,
            },
        })
    instance_test = gcp.networkmanagement.ConnectivityTest("instance-test",
        name="conn-test-instances",
        source={
            "instance": source.id,
        },
        destination={
            "instance": destination.id,
        },
        protocol="TCP",
        labels={
            "env": "test",
        })
    instance_test_run = gcp.networkmanagement.get_connectivity_test_run_output(name=instance_test.name)
    ```


    :param _builtins.str name: Unique name for the connectivity test.
           
           
           - - -
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:networkmanagement/getConnectivityTestRun:getConnectivityTestRun', __args__, opts=opts, typ=GetConnectivityTestRunResult)
    return __ret__.apply(lambda __response__: GetConnectivityTestRunResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        reachability_details=pulumi.get(__response__, 'reachability_details')))
