# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FirewallEndpointAssociationArgs', 'FirewallEndpointAssociation']

@pulumi.input_type
class FirewallEndpointAssociationArgs:
    def __init__(__self__, *,
                 firewall_endpoint: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 network: pulumi.Input[_builtins.str],
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_inspection_policy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FirewallEndpointAssociation resource.
        :param pulumi.Input[_builtins.str] firewall_endpoint: The URL of the firewall endpoint that is being associated.
        :param pulumi.Input[_builtins.str] location: The location (zone) of the firewall endpoint association.
        :param pulumi.Input[_builtins.str] network: The URL of the network that is being associated.
        :param pulumi.Input[_builtins.bool] disabled: Whether the association is disabled. True indicates that traffic will not be intercepted.
               > **Note:** The API will reject the request if this value is set to true when creating the resource,
               otherwise on an update the association can be disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The name of the firewall endpoint association resource.
        :param pulumi.Input[_builtins.str] parent: The name of the parent this firewall endpoint association belongs to.
               Format: projects/{project_id}.
        :param pulumi.Input[_builtins.str] tls_inspection_policy: The URL of the TlsInspectionPolicy that is being associated.
        """
        pulumi.set(__self__, "firewall_endpoint", firewall_endpoint)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network", network)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if tls_inspection_policy is not None:
            pulumi.set(__self__, "tls_inspection_policy", tls_inspection_policy)

    @_builtins.property
    @pulumi.getter(name="firewallEndpoint")
    def firewall_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of the firewall endpoint that is being associated.
        """
        return pulumi.get(self, "firewall_endpoint")

    @firewall_endpoint.setter
    def firewall_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "firewall_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location (zone) of the firewall endpoint association.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of the network that is being associated.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the association is disabled. True indicates that traffic will not be intercepted.
        > **Note:** The API will reject the request if this value is set to true when creating the resource,
        otherwise on an update the association can be disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key/value label pairs to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the firewall endpoint association resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the parent this firewall endpoint association belongs to.
        Format: projects/{project_id}.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="tlsInspectionPolicy")
    def tls_inspection_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the TlsInspectionPolicy that is being associated.
        """
        return pulumi.get(self, "tls_inspection_policy")

    @tls_inspection_policy.setter
    def tls_inspection_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_inspection_policy", value)


@pulumi.input_type
class _FirewallEndpointAssociationState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 firewall_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_inspection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FirewallEndpointAssociation resources.
        :param pulumi.Input[_builtins.str] create_time: Time the firewall endpoint was created in UTC.
        :param pulumi.Input[_builtins.bool] disabled: Whether the association is disabled. True indicates that traffic will not be intercepted.
               > **Note:** The API will reject the request if this value is set to true when creating the resource,
               otherwise on an update the association can be disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] firewall_endpoint: The URL of the firewall endpoint that is being associated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location (zone) of the firewall endpoint association.
        :param pulumi.Input[_builtins.str] name: The name of the firewall endpoint association resource.
        :param pulumi.Input[_builtins.str] network: The URL of the network that is being associated.
        :param pulumi.Input[_builtins.str] parent: The name of the parent this firewall endpoint association belongs to.
               Format: projects/{project_id}.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Whether reconciling is in progress, recommended per https://google.aip.dev/128.
        :param pulumi.Input[_builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[_builtins.str] state: The current state of the endpoint.
        :param pulumi.Input[_builtins.str] tls_inspection_policy: The URL of the TlsInspectionPolicy that is being associated.
        :param pulumi.Input[_builtins.str] update_time: Time the firewall endpoint was updated in UTC.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if firewall_endpoint is not None:
            pulumi.set(__self__, "firewall_endpoint", firewall_endpoint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tls_inspection_policy is not None:
            pulumi.set(__self__, "tls_inspection_policy", tls_inspection_policy)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the firewall endpoint was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the association is disabled. True indicates that traffic will not be intercepted.
        > **Note:** The API will reject the request if this value is set to true when creating the resource,
        otherwise on an update the association can be disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="firewallEndpoint")
    def firewall_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the firewall endpoint that is being associated.
        """
        return pulumi.get(self, "firewall_endpoint")

    @firewall_endpoint.setter
    def firewall_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key/value label pairs to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location (zone) of the firewall endpoint association.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the firewall endpoint association resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the network that is being associated.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the parent this firewall endpoint association belongs to.
        Format: projects/{project_id}.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether reconciling is in progress, recommended per https://google.aip.dev/128.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the endpoint.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="tlsInspectionPolicy")
    def tls_inspection_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the TlsInspectionPolicy that is being associated.
        """
        return pulumi.get(self, "tls_inspection_policy")

    @tls_inspection_policy.setter
    def tls_inspection_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_inspection_policy", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the firewall endpoint was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networksecurity/firewallEndpointAssociation:FirewallEndpointAssociation")
class FirewallEndpointAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 firewall_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_inspection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Firewall endpoint association links a firewall endpoint to a VPC network in
        the same zone. After you define this association, Cloud Firewall forwards the
        zonal workload traffic in your VPC network that requires layer 7 inspection to
        the attached firewall endpoint.

        To get more information about FirewallEndpointAssociation, see:

        * [API documentation](https://cloud.google.com/firewall/docs/reference/network-security/rest/v1/projects.locations.firewallEndpointAssociations#FirewallEndpointAssociation)
        * How-to Guides
            * [Create and associate firewall endpoints](https://cloud.google.com/firewall/docs/configure-firewall-endpoints)
            * [Firewall endpoint overview](https://cloud.google.com/firewall/docs/about-firewall-endpoints)

        > **Warning:** If you are using User ADCs (Application Default Credentials) with this resource,
        you must specify a `billing_project_id` and set `user_project_override` to true
        in the provider configuration. Otherwise the ACM API will return a 403 error.
        Your account must have the `serviceusage.services.use` permission on the
        `billing_project_id` you defined.

        ## Example Usage

        ## Import

        FirewallEndpointAssociation can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/firewallEndpointAssociations/{{name}}`

        When using the `pulumi import` command, FirewallEndpointAssociation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/firewallEndpointAssociation:FirewallEndpointAssociation default {{parent}}/locations/{{location}}/firewallEndpointAssociations/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disabled: Whether the association is disabled. True indicates that traffic will not be intercepted.
               > **Note:** The API will reject the request if this value is set to true when creating the resource,
               otherwise on an update the association can be disabled.
        :param pulumi.Input[_builtins.str] firewall_endpoint: The URL of the firewall endpoint that is being associated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location (zone) of the firewall endpoint association.
        :param pulumi.Input[_builtins.str] name: The name of the firewall endpoint association resource.
        :param pulumi.Input[_builtins.str] network: The URL of the network that is being associated.
        :param pulumi.Input[_builtins.str] parent: The name of the parent this firewall endpoint association belongs to.
               Format: projects/{project_id}.
        :param pulumi.Input[_builtins.str] tls_inspection_policy: The URL of the TlsInspectionPolicy that is being associated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallEndpointAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Firewall endpoint association links a firewall endpoint to a VPC network in
        the same zone. After you define this association, Cloud Firewall forwards the
        zonal workload traffic in your VPC network that requires layer 7 inspection to
        the attached firewall endpoint.

        To get more information about FirewallEndpointAssociation, see:

        * [API documentation](https://cloud.google.com/firewall/docs/reference/network-security/rest/v1/projects.locations.firewallEndpointAssociations#FirewallEndpointAssociation)
        * How-to Guides
            * [Create and associate firewall endpoints](https://cloud.google.com/firewall/docs/configure-firewall-endpoints)
            * [Firewall endpoint overview](https://cloud.google.com/firewall/docs/about-firewall-endpoints)

        > **Warning:** If you are using User ADCs (Application Default Credentials) with this resource,
        you must specify a `billing_project_id` and set `user_project_override` to true
        in the provider configuration. Otherwise the ACM API will return a 403 error.
        Your account must have the `serviceusage.services.use` permission on the
        `billing_project_id` you defined.

        ## Example Usage

        ## Import

        FirewallEndpointAssociation can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/firewallEndpointAssociations/{{name}}`

        When using the `pulumi import` command, FirewallEndpointAssociation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/firewallEndpointAssociation:FirewallEndpointAssociation default {{parent}}/locations/{{location}}/firewallEndpointAssociations/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FirewallEndpointAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallEndpointAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 firewall_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_inspection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallEndpointAssociationArgs.__new__(FirewallEndpointAssociationArgs)

            __props__.__dict__["disabled"] = disabled
            if firewall_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_endpoint'")
            __props__.__dict__["firewall_endpoint"] = firewall_endpoint
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["parent"] = parent
            __props__.__dict__["tls_inspection_policy"] = tls_inspection_policy
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FirewallEndpointAssociation, __self__).__init__(
            'gcp:networksecurity/firewallEndpointAssociation:FirewallEndpointAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            firewall_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            tls_inspection_policy: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'FirewallEndpointAssociation':
        """
        Get an existing FirewallEndpointAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Time the firewall endpoint was created in UTC.
        :param pulumi.Input[_builtins.bool] disabled: Whether the association is disabled. True indicates that traffic will not be intercepted.
               > **Note:** The API will reject the request if this value is set to true when creating the resource,
               otherwise on an update the association can be disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] firewall_endpoint: The URL of the firewall endpoint that is being associated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location (zone) of the firewall endpoint association.
        :param pulumi.Input[_builtins.str] name: The name of the firewall endpoint association resource.
        :param pulumi.Input[_builtins.str] network: The URL of the network that is being associated.
        :param pulumi.Input[_builtins.str] parent: The name of the parent this firewall endpoint association belongs to.
               Format: projects/{project_id}.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Whether reconciling is in progress, recommended per https://google.aip.dev/128.
        :param pulumi.Input[_builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[_builtins.str] state: The current state of the endpoint.
        :param pulumi.Input[_builtins.str] tls_inspection_policy: The URL of the TlsInspectionPolicy that is being associated.
        :param pulumi.Input[_builtins.str] update_time: Time the firewall endpoint was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallEndpointAssociationState.__new__(_FirewallEndpointAssociationState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["firewall_endpoint"] = firewall_endpoint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["parent"] = parent
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["state"] = state
        __props__.__dict__["tls_inspection_policy"] = tls_inspection_policy
        __props__.__dict__["update_time"] = update_time
        return FirewallEndpointAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the firewall endpoint was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the association is disabled. True indicates that traffic will not be intercepted.
        > **Note:** The API will reject the request if this value is set to true when creating the resource,
        otherwise on an update the association can be disabled.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="firewallEndpoint")
    def firewall_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the firewall endpoint that is being associated.
        """
        return pulumi.get(self, "firewall_endpoint")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of key/value label pairs to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location (zone) of the firewall endpoint association.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the firewall endpoint association resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the network that is being associated.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the parent this firewall endpoint association belongs to.
        Format: projects/{project_id}.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether reconciling is in progress, recommended per https://google.aip.dev/128.
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the endpoint.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tlsInspectionPolicy")
    def tls_inspection_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL of the TlsInspectionPolicy that is being associated.
        """
        return pulumi.get(self, "tls_inspection_policy")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the firewall endpoint was updated in UTC.
        """
        return pulumi.get(self, "update_time")

