# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRegionalSecretResult',
    'AwaitableGetRegionalSecretResult',
    'get_regional_secret',
    'get_regional_secret_output',
]

@pulumi.output_type
class GetRegionalSecretResult:
    """
    A collection of values returned by getRegionalSecret.
    """
    def __init__(__self__, annotations=None, create_time=None, customer_managed_encryptions=None, deletion_protection=None, effective_annotations=None, effective_labels=None, expire_time=None, id=None, labels=None, location=None, name=None, project=None, pulumi_labels=None, rotations=None, secret_id=None, tags=None, topics=None, ttl=None, version_aliases=None, version_destroy_ttl=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if customer_managed_encryptions and not isinstance(customer_managed_encryptions, list):
            raise TypeError("Expected argument 'customer_managed_encryptions' to be a list")
        pulumi.set(__self__, "customer_managed_encryptions", customer_managed_encryptions)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if effective_annotations and not isinstance(effective_annotations, dict):
            raise TypeError("Expected argument 'effective_annotations' to be a dict")
        pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if expire_time and not isinstance(expire_time, str):
            raise TypeError("Expected argument 'expire_time' to be a str")
        pulumi.set(__self__, "expire_time", expire_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if rotations and not isinstance(rotations, list):
            raise TypeError("Expected argument 'rotations' to be a list")
        pulumi.set(__self__, "rotations", rotations)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if topics and not isinstance(topics, list):
            raise TypeError("Expected argument 'topics' to be a list")
        pulumi.set(__self__, "topics", topics)
        if ttl and not isinstance(ttl, str):
            raise TypeError("Expected argument 'ttl' to be a str")
        pulumi.set(__self__, "ttl", ttl)
        if version_aliases and not isinstance(version_aliases, dict):
            raise TypeError("Expected argument 'version_aliases' to be a dict")
        pulumi.set(__self__, "version_aliases", version_aliases)
        if version_destroy_ttl and not isinstance(version_destroy_ttl, str):
            raise TypeError("Expected argument 'version_destroy_ttl' to be a str")
        pulumi.set(__self__, "version_destroy_ttl", version_destroy_ttl)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customerManagedEncryptions")
    def customer_managed_encryptions(self) -> Sequence['outputs.GetRegionalSecretCustomerManagedEncryptionResult']:
        return pulumi.get(self, "customer_managed_encryptions")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def rotations(self) -> Sequence['outputs.GetRegionalSecretRotationResult']:
        return pulumi.get(self, "rotations")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def topics(self) -> Sequence['outputs.GetRegionalSecretTopicResult']:
        return pulumi.get(self, "topics")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.str:
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter(name="versionAliases")
    def version_aliases(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "version_aliases")

    @_builtins.property
    @pulumi.getter(name="versionDestroyTtl")
    def version_destroy_ttl(self) -> _builtins.str:
        return pulumi.get(self, "version_destroy_ttl")


class AwaitableGetRegionalSecretResult(GetRegionalSecretResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionalSecretResult(
            annotations=self.annotations,
            create_time=self.create_time,
            customer_managed_encryptions=self.customer_managed_encryptions,
            deletion_protection=self.deletion_protection,
            effective_annotations=self.effective_annotations,
            effective_labels=self.effective_labels,
            expire_time=self.expire_time,
            id=self.id,
            labels=self.labels,
            location=self.location,
            name=self.name,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            rotations=self.rotations,
            secret_id=self.secret_id,
            tags=self.tags,
            topics=self.topics,
            ttl=self.ttl,
            version_aliases=self.version_aliases,
            version_destroy_ttl=self.version_destroy_ttl)


def get_regional_secret(location: Optional[_builtins.str] = None,
                        project: Optional[_builtins.str] = None,
                        secret_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionalSecretResult:
    """
    Use this data source to get information about a Secret Manager Regional Secret

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    secret_datasource = gcp.secretmanager.get_regional_secret(secret_id="secretname",
        location="us-central1")
    ```


    :param _builtins.str location: The location of the regional secret. eg us-central1
    :param _builtins.str project: The ID of the project in which the resource belongs.
    :param _builtins.str secret_id: The name of the regional secret.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['secretId'] = secret_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:secretmanager/getRegionalSecret:getRegionalSecret', __args__, opts=opts, typ=GetRegionalSecretResult).value

    return AwaitableGetRegionalSecretResult(
        annotations=pulumi.get(__ret__, 'annotations'),
        create_time=pulumi.get(__ret__, 'create_time'),
        customer_managed_encryptions=pulumi.get(__ret__, 'customer_managed_encryptions'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        effective_annotations=pulumi.get(__ret__, 'effective_annotations'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        expire_time=pulumi.get(__ret__, 'expire_time'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        rotations=pulumi.get(__ret__, 'rotations'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        tags=pulumi.get(__ret__, 'tags'),
        topics=pulumi.get(__ret__, 'topics'),
        ttl=pulumi.get(__ret__, 'ttl'),
        version_aliases=pulumi.get(__ret__, 'version_aliases'),
        version_destroy_ttl=pulumi.get(__ret__, 'version_destroy_ttl'))
def get_regional_secret_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                               project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionalSecretResult]:
    """
    Use this data source to get information about a Secret Manager Regional Secret

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    secret_datasource = gcp.secretmanager.get_regional_secret(secret_id="secretname",
        location="us-central1")
    ```


    :param _builtins.str location: The location of the regional secret. eg us-central1
    :param _builtins.str project: The ID of the project in which the resource belongs.
    :param _builtins.str secret_id: The name of the regional secret.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['secretId'] = secret_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:secretmanager/getRegionalSecret:getRegionalSecret', __args__, opts=opts, typ=GetRegionalSecretResult)
    return __ret__.apply(lambda __response__: GetRegionalSecretResult(
        annotations=pulumi.get(__response__, 'annotations'),
        create_time=pulumi.get(__response__, 'create_time'),
        customer_managed_encryptions=pulumi.get(__response__, 'customer_managed_encryptions'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        effective_annotations=pulumi.get(__response__, 'effective_annotations'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        expire_time=pulumi.get(__response__, 'expire_time'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        rotations=pulumi.get(__response__, 'rotations'),
        secret_id=pulumi.get(__response__, 'secret_id'),
        tags=pulumi.get(__response__, 'tags'),
        topics=pulumi.get(__response__, 'topics'),
        ttl=pulumi.get(__response__, 'ttl'),
        version_aliases=pulumi.get(__response__, 'version_aliases'),
        version_destroy_ttl=pulumi.get(__response__, 'version_destroy_ttl')))
