# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationCustomModuleArgs', 'OrganizationCustomModule']

@pulumi.input_type
class OrganizationCustomModuleArgs:
    def __init__(__self__, *,
                 custom_config: pulumi.Input['OrganizationCustomModuleCustomConfigArgs'],
                 display_name: pulumi.Input[_builtins.str],
                 enablement_state: pulumi.Input[_builtins.str],
                 organization: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a OrganizationCustomModule resource.
        :param pulumi.Input['OrganizationCustomModuleCustomConfigArgs'] custom_config: The user specified custom configuration for the module.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Security Health Analytics custom module. This
               display name becomes the finding category for all findings that are
               returned by this custom module. The display name must be between 1 and
               128 characters, start with a lowercase letter, and contain alphanumeric
               characters or underscores only.
        :param pulumi.Input[_builtins.str] enablement_state: The enablement state of the custom module.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[_builtins.str] organization: Numerical ID of the parent organization.
        """
        pulumi.set(__self__, "custom_config", custom_config)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "enablement_state", enablement_state)
        pulumi.set(__self__, "organization", organization)

    @_builtins.property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> pulumi.Input['OrganizationCustomModuleCustomConfigArgs']:
        """
        The user specified custom configuration for the module.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_config")

    @custom_config.setter
    def custom_config(self, value: pulumi.Input['OrganizationCustomModuleCustomConfigArgs']):
        pulumi.set(self, "custom_config", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the Security Health Analytics custom module. This
        display name becomes the finding category for all findings that are
        returned by this custom module. The display name must be between 1 and
        128 characters, start with a lowercase letter, and contain alphanumeric
        characters or underscores only.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enablementState")
    def enablement_state(self) -> pulumi.Input[_builtins.str]:
        """
        The enablement state of the custom module.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "enablement_state")

    @enablement_state.setter
    def enablement_state(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "enablement_state", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input[_builtins.str]:
        """
        Numerical ID of the parent organization.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization", value)


@pulumi.input_type
class _OrganizationCustomModuleState:
    def __init__(__self__, *,
                 ancestor_module: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_config: Optional[pulumi.Input['OrganizationCustomModuleCustomConfigArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enablement_state: Optional[pulumi.Input[_builtins.str]] = None,
                 last_editor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationCustomModule resources.
        :param pulumi.Input[_builtins.str] ancestor_module: If empty, indicates that the custom module was created in the organization, folder,
               or project in which you are viewing the custom module. Otherwise, ancestor_module
               specifies the organization or folder from which the custom module is inherited.
        :param pulumi.Input['OrganizationCustomModuleCustomConfigArgs'] custom_config: The user specified custom configuration for the module.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Security Health Analytics custom module. This
               display name becomes the finding category for all findings that are
               returned by this custom module. The display name must be between 1 and
               128 characters, start with a lowercase letter, and contain alphanumeric
               characters or underscores only.
        :param pulumi.Input[_builtins.str] enablement_state: The enablement state of the custom module.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[_builtins.str] last_editor: The editor that last updated the custom module.
        :param pulumi.Input[_builtins.str] name: The resource name of the custom module. Its format is "organizations/{org_id}/securityHealthAnalyticsSettings/customModules/{customModule}".
               The id {customModule} is server-generated and is not user settable. It will be a numeric id containing 1-20 digits.
        :param pulumi.Input[_builtins.str] organization: Numerical ID of the parent organization.
        :param pulumi.Input[_builtins.str] update_time: The time at which the custom module was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
               up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if ancestor_module is not None:
            pulumi.set(__self__, "ancestor_module", ancestor_module)
        if custom_config is not None:
            pulumi.set(__self__, "custom_config", custom_config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enablement_state is not None:
            pulumi.set(__self__, "enablement_state", enablement_state)
        if last_editor is not None:
            pulumi.set(__self__, "last_editor", last_editor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="ancestorModule")
    def ancestor_module(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If empty, indicates that the custom module was created in the organization, folder,
        or project in which you are viewing the custom module. Otherwise, ancestor_module
        specifies the organization or folder from which the custom module is inherited.
        """
        return pulumi.get(self, "ancestor_module")

    @ancestor_module.setter
    def ancestor_module(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ancestor_module", value)

    @_builtins.property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> Optional[pulumi.Input['OrganizationCustomModuleCustomConfigArgs']]:
        """
        The user specified custom configuration for the module.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_config")

    @custom_config.setter
    def custom_config(self, value: Optional[pulumi.Input['OrganizationCustomModuleCustomConfigArgs']]):
        pulumi.set(self, "custom_config", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the Security Health Analytics custom module. This
        display name becomes the finding category for all findings that are
        returned by this custom module. The display name must be between 1 and
        128 characters, start with a lowercase letter, and contain alphanumeric
        characters or underscores only.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enablementState")
    def enablement_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enablement state of the custom module.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "enablement_state")

    @enablement_state.setter
    def enablement_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enablement_state", value)

    @_builtins.property
    @pulumi.getter(name="lastEditor")
    def last_editor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The editor that last updated the custom module.
        """
        return pulumi.get(self, "last_editor")

    @last_editor.setter
    def last_editor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_editor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the custom module. Its format is "organizations/{org_id}/securityHealthAnalyticsSettings/customModules/{customModule}".
        The id {customModule} is server-generated and is not user settable. It will be a numeric id containing 1-20 digits.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Numerical ID of the parent organization.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the custom module was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
        up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:securitycenter/organizationCustomModule:OrganizationCustomModule")
class OrganizationCustomModule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_config: Optional[pulumi.Input[Union['OrganizationCustomModuleCustomConfigArgs', 'OrganizationCustomModuleCustomConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enablement_state: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents an instance of a Security Health Analytics custom module, including
        its full module name, display name, enablement state, and last updated time.
        You can create a custom module at the organization, folder, or project level.
        Custom modules that you create at the organization or folder level are inherited
        by the child folders and projects.

        To get more information about OrganizationCustomModule, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v1/organizations.securityHealthAnalyticsSettings.customModules)
        * How-to Guides
            * [Overview of custom modules for Security Health Analytics](https://cloud.google.com/security-command-center/docs/custom-modules-sha-overview)

        ## Example Usage

        ### Scc Organization Custom Module Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.securitycenter.OrganizationCustomModule("example",
            organization="123456789",
            display_name="basic_custom_module",
            enablement_state="ENABLED",
            custom_config={
                "predicate": {
                    "expression": "resource.rotationPeriod > duration(\\"2592000s\\")",
                },
                "resource_selector": {
                    "resource_types": ["cloudkms.googleapis.com/CryptoKey"],
                },
                "description": "The rotation period of the identified cryptokey resource exceeds 30 days.",
                "recommendation": "Set the rotation period to at most 30 days.",
                "severity": "MEDIUM",
            })
        ```
        ### Scc Organization Custom Module Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.securitycenter.OrganizationCustomModule("example",
            organization="123456789",
            display_name="full_custom_module",
            enablement_state="ENABLED",
            custom_config={
                "predicate": {
                    "expression": "resource.rotationPeriod > duration(\\"2592000s\\")",
                    "title": "Purpose of the expression",
                    "description": "description of the expression",
                    "location": "location of the expression",
                },
                "custom_output": {
                    "properties": [{
                        "name": "duration",
                        "value_expression": {
                            "expression": "resource.rotationPeriod",
                            "title": "Purpose of the expression",
                            "description": "description of the expression",
                            "location": "location of the expression",
                        },
                    }],
                },
                "resource_selector": {
                    "resource_types": ["cloudkms.googleapis.com/CryptoKey"],
                },
                "severity": "LOW",
                "description": "Description of the custom module",
                "recommendation": "Steps to resolve violation",
            })
        ```

        ## Import

        OrganizationCustomModule can be imported using any of these accepted formats:

        * `organizations/{{organization}}/securityHealthAnalyticsSettings/customModules/{{name}}`

        * `{{organization}}/{{name}}`

        When using the `pulumi import` command, OrganizationCustomModule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/organizationCustomModule:OrganizationCustomModule default organizations/{{organization}}/securityHealthAnalyticsSettings/customModules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/organizationCustomModule:OrganizationCustomModule default {{organization}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OrganizationCustomModuleCustomConfigArgs', 'OrganizationCustomModuleCustomConfigArgsDict']] custom_config: The user specified custom configuration for the module.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Security Health Analytics custom module. This
               display name becomes the finding category for all findings that are
               returned by this custom module. The display name must be between 1 and
               128 characters, start with a lowercase letter, and contain alphanumeric
               characters or underscores only.
        :param pulumi.Input[_builtins.str] enablement_state: The enablement state of the custom module.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[_builtins.str] organization: Numerical ID of the parent organization.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationCustomModuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an instance of a Security Health Analytics custom module, including
        its full module name, display name, enablement state, and last updated time.
        You can create a custom module at the organization, folder, or project level.
        Custom modules that you create at the organization or folder level are inherited
        by the child folders and projects.

        To get more information about OrganizationCustomModule, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v1/organizations.securityHealthAnalyticsSettings.customModules)
        * How-to Guides
            * [Overview of custom modules for Security Health Analytics](https://cloud.google.com/security-command-center/docs/custom-modules-sha-overview)

        ## Example Usage

        ### Scc Organization Custom Module Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.securitycenter.OrganizationCustomModule("example",
            organization="123456789",
            display_name="basic_custom_module",
            enablement_state="ENABLED",
            custom_config={
                "predicate": {
                    "expression": "resource.rotationPeriod > duration(\\"2592000s\\")",
                },
                "resource_selector": {
                    "resource_types": ["cloudkms.googleapis.com/CryptoKey"],
                },
                "description": "The rotation period of the identified cryptokey resource exceeds 30 days.",
                "recommendation": "Set the rotation period to at most 30 days.",
                "severity": "MEDIUM",
            })
        ```
        ### Scc Organization Custom Module Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.securitycenter.OrganizationCustomModule("example",
            organization="123456789",
            display_name="full_custom_module",
            enablement_state="ENABLED",
            custom_config={
                "predicate": {
                    "expression": "resource.rotationPeriod > duration(\\"2592000s\\")",
                    "title": "Purpose of the expression",
                    "description": "description of the expression",
                    "location": "location of the expression",
                },
                "custom_output": {
                    "properties": [{
                        "name": "duration",
                        "value_expression": {
                            "expression": "resource.rotationPeriod",
                            "title": "Purpose of the expression",
                            "description": "description of the expression",
                            "location": "location of the expression",
                        },
                    }],
                },
                "resource_selector": {
                    "resource_types": ["cloudkms.googleapis.com/CryptoKey"],
                },
                "severity": "LOW",
                "description": "Description of the custom module",
                "recommendation": "Steps to resolve violation",
            })
        ```

        ## Import

        OrganizationCustomModule can be imported using any of these accepted formats:

        * `organizations/{{organization}}/securityHealthAnalyticsSettings/customModules/{{name}}`

        * `{{organization}}/{{name}}`

        When using the `pulumi import` command, OrganizationCustomModule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/organizationCustomModule:OrganizationCustomModule default organizations/{{organization}}/securityHealthAnalyticsSettings/customModules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/organizationCustomModule:OrganizationCustomModule default {{organization}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationCustomModuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationCustomModuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_config: Optional[pulumi.Input[Union['OrganizationCustomModuleCustomConfigArgs', 'OrganizationCustomModuleCustomConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enablement_state: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationCustomModuleArgs.__new__(OrganizationCustomModuleArgs)

            if custom_config is None and not opts.urn:
                raise TypeError("Missing required property 'custom_config'")
            __props__.__dict__["custom_config"] = custom_config
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if enablement_state is None and not opts.urn:
                raise TypeError("Missing required property 'enablement_state'")
            __props__.__dict__["enablement_state"] = enablement_state
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["ancestor_module"] = None
            __props__.__dict__["last_editor"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(OrganizationCustomModule, __self__).__init__(
            'gcp:securitycenter/organizationCustomModule:OrganizationCustomModule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ancestor_module: Optional[pulumi.Input[_builtins.str]] = None,
            custom_config: Optional[pulumi.Input[Union['OrganizationCustomModuleCustomConfigArgs', 'OrganizationCustomModuleCustomConfigArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enablement_state: Optional[pulumi.Input[_builtins.str]] = None,
            last_editor: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationCustomModule':
        """
        Get an existing OrganizationCustomModule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ancestor_module: If empty, indicates that the custom module was created in the organization, folder,
               or project in which you are viewing the custom module. Otherwise, ancestor_module
               specifies the organization or folder from which the custom module is inherited.
        :param pulumi.Input[Union['OrganizationCustomModuleCustomConfigArgs', 'OrganizationCustomModuleCustomConfigArgsDict']] custom_config: The user specified custom configuration for the module.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Security Health Analytics custom module. This
               display name becomes the finding category for all findings that are
               returned by this custom module. The display name must be between 1 and
               128 characters, start with a lowercase letter, and contain alphanumeric
               characters or underscores only.
        :param pulumi.Input[_builtins.str] enablement_state: The enablement state of the custom module.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[_builtins.str] last_editor: The editor that last updated the custom module.
        :param pulumi.Input[_builtins.str] name: The resource name of the custom module. Its format is "organizations/{org_id}/securityHealthAnalyticsSettings/customModules/{customModule}".
               The id {customModule} is server-generated and is not user settable. It will be a numeric id containing 1-20 digits.
        :param pulumi.Input[_builtins.str] organization: Numerical ID of the parent organization.
        :param pulumi.Input[_builtins.str] update_time: The time at which the custom module was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
               up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationCustomModuleState.__new__(_OrganizationCustomModuleState)

        __props__.__dict__["ancestor_module"] = ancestor_module
        __props__.__dict__["custom_config"] = custom_config
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enablement_state"] = enablement_state
        __props__.__dict__["last_editor"] = last_editor
        __props__.__dict__["name"] = name
        __props__.__dict__["organization"] = organization
        __props__.__dict__["update_time"] = update_time
        return OrganizationCustomModule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ancestorModule")
    def ancestor_module(self) -> pulumi.Output[_builtins.str]:
        """
        If empty, indicates that the custom module was created in the organization, folder,
        or project in which you are viewing the custom module. Otherwise, ancestor_module
        specifies the organization or folder from which the custom module is inherited.
        """
        return pulumi.get(self, "ancestor_module")

    @_builtins.property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> pulumi.Output['outputs.OrganizationCustomModuleCustomConfig']:
        """
        The user specified custom configuration for the module.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_config")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the Security Health Analytics custom module. This
        display name becomes the finding category for all findings that are
        returned by this custom module. The display name must be between 1 and
        128 characters, start with a lowercase letter, and contain alphanumeric
        characters or underscores only.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="enablementState")
    def enablement_state(self) -> pulumi.Output[_builtins.str]:
        """
        The enablement state of the custom module.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "enablement_state")

    @_builtins.property
    @pulumi.getter(name="lastEditor")
    def last_editor(self) -> pulumi.Output[_builtins.str]:
        """
        The editor that last updated the custom module.
        """
        return pulumi.get(self, "last_editor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the custom module. Its format is "organizations/{org_id}/securityHealthAnalyticsSettings/customModules/{customModule}".
        The id {customModule} is server-generated and is not user settable. It will be a numeric id containing 1-20 digits.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[_builtins.str]:
        """
        Numerical ID of the parent organization.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the custom module was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
        up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

