# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OwnerArgs', 'Owner']

@pulumi.input_type
class OwnerArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[_builtins.str],
                 web_resource_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a Owner resource.
        :param pulumi.Input[_builtins.str] email: The email of the user to be added as an owner.
               
               - - -
        :param pulumi.Input[_builtins.str] web_resource_id: The id of of the web resource to which the owner will be added, in the form `webResource/<resource_id>`,
               such as `webResource/https://www.example.com/`
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "web_resource_id", web_resource_id)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        The email of the user to be added as an owner.

        - - -
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="webResourceId")
    def web_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of of the web resource to which the owner will be added, in the form `webResource/<resource_id>`,
        such as `webResource/https://www.example.com/`
        """
        return pulumi.get(self, "web_resource_id")

    @web_resource_id.setter
    def web_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "web_resource_id", value)


@pulumi.input_type
class _OwnerState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 web_resource_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Owner resources.
        :param pulumi.Input[_builtins.str] email: The email of the user to be added as an owner.
               
               - - -
        :param pulumi.Input[_builtins.str] web_resource_id: The id of of the web resource to which the owner will be added, in the form `webResource/<resource_id>`,
               such as `webResource/https://www.example.com/`
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if web_resource_id is not None:
            pulumi.set(__self__, "web_resource_id", web_resource_id)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the user to be added as an owner.

        - - -
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="webResourceId")
    def web_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of of the web resource to which the owner will be added, in the form `webResource/<resource_id>`,
        such as `webResource/https://www.example.com/`
        """
        return pulumi.get(self, "web_resource_id")

    @web_resource_id.setter
    def web_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_resource_id", value)


@pulumi.type_token("gcp:siteverification/owner:Owner")
class Owner(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 web_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An owner is an additional user that may manage a verified web site in the
        [Google Search Console](https://www.google.com/webmasters/tools/). There
        are two types of web resource owners:

        * Verified owners, which are added to a web resource automatically when it
            is created (i.e., when the resource is verified). A verified owner is
            determined by the identity of the user requesting verification.
        * Additional owners, which can be added to the resource by verified owners.

        `siteverification.Owner` creates additional owners. If your web site
        was verified using the
        `siteverification.WebResource`
        resource then you (or the identity was used to create the resource, such as a
        service account) are already an owner.

        > **Note:** The email address of the owner must belong to a Google account,
        such as a Gmail account, a Google Workspace account, or a GCP service account.

        Working with site verification requires the `https://www.googleapis.com/auth/siteverification`
        authentication scope. See the
        Google Provider authentication documentation
        to learn how to configure additional scopes.

        To get more information about site owners, see:

        * [API documentation](https://developers.google.com/site-verification/v1)
        * How-to Guides
            * [Getting Started](https://developers.google.com/site-verification/v1/getting_started)

        ## Example Usage

        ### Site Verification Storage Bucket

        This example uses the `FILE` verification method to verify ownership of web site hosted
        in a Google Cloud Storage bucket. Ownership is proved by creating a file with a Google-provided
        value in a known location. The user applying this configuration will automatically be
        added as a verified owner, and the `siteverification.Owner` resource will add
        `user@example.com` as an additional owner.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="example-storage-bucket",
            location="US")
        token = gcp.siteverification.get_token_output(type="SITE",
            identifier=bucket.name.apply(lambda name: f"https://{name}.storage.googleapis.com/"),
            verification_method="FILE")
        object = gcp.storage.BucketObject("object",
            name=token.token,
            content=token.apply(lambda token: f"google-site-verification: {token.token}"),
            bucket=bucket.name)
        public_rule = gcp.storage.ObjectAccessControl("public_rule",
            bucket=bucket.name,
            object=object.name,
            role="READER",
            entity="allUsers")
        example = gcp.siteverification.WebResource("example",
            site={
                "type": token.type,
                "identifier": token.identifier,
            },
            verification_method=token.verification_method)
        example_owner = gcp.siteverification.Owner("example",
            web_resource_id=example.id,
            email="user@example.com")
        ```

        ## Import

        Owner can be imported using this format:

        * `webResource/{{web_resource_id}}/{{email}}`

        When using the `pulumi import` command, Site owners can be imported using the format above. For example:

        ```sh
        $ pulumi import gcp:siteverification/owner:Owner default webResource/{{web_resource_id}}/{{email}}
        ```

        verified owners is to delete the web resource itself.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] email: The email of the user to be added as an owner.
               
               - - -
        :param pulumi.Input[_builtins.str] web_resource_id: The id of of the web resource to which the owner will be added, in the form `webResource/<resource_id>`,
               such as `webResource/https://www.example.com/`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OwnerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An owner is an additional user that may manage a verified web site in the
        [Google Search Console](https://www.google.com/webmasters/tools/). There
        are two types of web resource owners:

        * Verified owners, which are added to a web resource automatically when it
            is created (i.e., when the resource is verified). A verified owner is
            determined by the identity of the user requesting verification.
        * Additional owners, which can be added to the resource by verified owners.

        `siteverification.Owner` creates additional owners. If your web site
        was verified using the
        `siteverification.WebResource`
        resource then you (or the identity was used to create the resource, such as a
        service account) are already an owner.

        > **Note:** The email address of the owner must belong to a Google account,
        such as a Gmail account, a Google Workspace account, or a GCP service account.

        Working with site verification requires the `https://www.googleapis.com/auth/siteverification`
        authentication scope. See the
        Google Provider authentication documentation
        to learn how to configure additional scopes.

        To get more information about site owners, see:

        * [API documentation](https://developers.google.com/site-verification/v1)
        * How-to Guides
            * [Getting Started](https://developers.google.com/site-verification/v1/getting_started)

        ## Example Usage

        ### Site Verification Storage Bucket

        This example uses the `FILE` verification method to verify ownership of web site hosted
        in a Google Cloud Storage bucket. Ownership is proved by creating a file with a Google-provided
        value in a known location. The user applying this configuration will automatically be
        added as a verified owner, and the `siteverification.Owner` resource will add
        `user@example.com` as an additional owner.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="example-storage-bucket",
            location="US")
        token = gcp.siteverification.get_token_output(type="SITE",
            identifier=bucket.name.apply(lambda name: f"https://{name}.storage.googleapis.com/"),
            verification_method="FILE")
        object = gcp.storage.BucketObject("object",
            name=token.token,
            content=token.apply(lambda token: f"google-site-verification: {token.token}"),
            bucket=bucket.name)
        public_rule = gcp.storage.ObjectAccessControl("public_rule",
            bucket=bucket.name,
            object=object.name,
            role="READER",
            entity="allUsers")
        example = gcp.siteverification.WebResource("example",
            site={
                "type": token.type,
                "identifier": token.identifier,
            },
            verification_method=token.verification_method)
        example_owner = gcp.siteverification.Owner("example",
            web_resource_id=example.id,
            email="user@example.com")
        ```

        ## Import

        Owner can be imported using this format:

        * `webResource/{{web_resource_id}}/{{email}}`

        When using the `pulumi import` command, Site owners can be imported using the format above. For example:

        ```sh
        $ pulumi import gcp:siteverification/owner:Owner default webResource/{{web_resource_id}}/{{email}}
        ```

        verified owners is to delete the web resource itself.

        :param str resource_name: The name of the resource.
        :param OwnerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OwnerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 web_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OwnerArgs.__new__(OwnerArgs)

            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if web_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'web_resource_id'")
            __props__.__dict__["web_resource_id"] = web_resource_id
        super(Owner, __self__).__init__(
            'gcp:siteverification/owner:Owner',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            web_resource_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Owner':
        """
        Get an existing Owner resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] email: The email of the user to be added as an owner.
               
               - - -
        :param pulumi.Input[_builtins.str] web_resource_id: The id of of the web resource to which the owner will be added, in the form `webResource/<resource_id>`,
               such as `webResource/https://www.example.com/`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OwnerState.__new__(_OwnerState)

        __props__.__dict__["email"] = email
        __props__.__dict__["web_resource_id"] = web_resource_id
        return Owner(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        The email of the user to be added as an owner.

        - - -
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="webResourceId")
    def web_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of of the web resource to which the owner will be added, in the form `webResource/<resource_id>`,
        such as `webResource/https://www.example.com/`
        """
        return pulumi.get(self, "web_resource_id")

