# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseInstanceArgs', 'DatabaseInstance']

@pulumi.input_type
class DatabaseInstanceArgs:
    def __init__(__self__, *,
                 database_version: pulumi.Input[_builtins.str],
                 backupdr_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 clone: Optional[pulumi.Input['DatabaseInstanceCloneArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 final_backup_description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 master_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_configuration: Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']] = None,
                 replica_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 replication_cluster: Optional[pulumi.Input['DatabaseInstanceReplicationClusterArgs']] = None,
                 restore_backup_context: Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']] = None,
                 root_password: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input['DatabaseInstanceSettingsArgs']] = None):
        """
        The set of arguments for constructing a DatabaseInstance resource.
        :param pulumi.Input[_builtins.str] database_version: The MySQL, PostgreSQL or
               SQL Server version to use. Supported values include `MYSQL_5_6`,
               `MYSQL_5_7`, `MYSQL_8_0`, `MYSQL_8_4`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
               `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `POSTGRES_16`, `POSTGRES_17`,
               `SQLSERVER_2017_STANDARD`, `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
               `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
               `SQLSERVER_2019_WEB`.
               [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
               includes an up-to-date reference of supported versions.
        :param pulumi.Input[_builtins.str] backupdr_backup: The name of the BackupDR backup to restore from.
        :param pulumi.Input['DatabaseInstanceCloneArgs'] clone: The context needed to create this instance as a clone of another instance. When this field is set during
               resource creation, this provider will attempt to clone another instance as indicated in the context. The
               configuration is detailed below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        :param pulumi.Input[_builtins.str] encryption_key_name: The full path to the encryption key used for the CMEK disk encryption.  Setting
               up disk encryption currently requires manual steps outside of this provider.
               The provided key must be in the same region as the SQL instance.  In order
               to use this feature, a special kind of service account must be created and
               granted permission on this key.  This step can currently only be done
               manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
               That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
               key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        :param pulumi.Input[_builtins.str] final_backup_description: The description of final backup. Only set this field when `final_backup_config.enabled` is true.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. See [API reference for SqlInstanceType](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/instances#SqlInstanceType) for supported values.
        :param pulumi.Input[_builtins.str] maintenance_version: The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        :param pulumi.Input[_builtins.str] master_instance_name: The name of the existing instance that will
               act as the master in the replication setup. Note, this requires the master to
               have `binary_log_enabled` set, as well as existing backups.
        :param pulumi.Input[_builtins.str] name: The name of the instance. If the name is left
               blank, the provider will randomly generate one when the instance is first
               created. This is done because after a name is used, it cannot be reused for
               up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        :param pulumi.Input[_builtins.int] node_count: For a read pool instance, the number of nodes in the read pool.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region the instance will sit in. If a region is not provided in the resource definition,
               the provider region will be used instead.
               
               - - -
        :param pulumi.Input['DatabaseInstanceReplicaConfigurationArgs'] replica_configuration: The configuration for replication. The
               configuration is detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replica_names: List of replica names. Can be updated.
        :param pulumi.Input['DatabaseInstanceReplicationClusterArgs'] replication_cluster: A primary instance and disaster recovery replica pair. Applicable to MySQL and PostgreSQL. This field can be set only after both the primary and replica are created.
        :param pulumi.Input['DatabaseInstanceRestoreBackupContextArgs'] restore_backup_context: The context needed to restore the database to a backup run. This field will
               cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
               **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
               block during resource creation/update will trigger the restore action after the resource is created/updated.
        :param pulumi.Input[_builtins.str] root_password: Initial root password. Can be updated. Required for MS SQL Server.
        :param pulumi.Input['DatabaseInstanceSettingsArgs'] settings: The settings to use for the database. The
               configuration is detailed below. Required if `clone` is not set.
        """
        pulumi.set(__self__, "database_version", database_version)
        if backupdr_backup is not None:
            pulumi.set(__self__, "backupdr_backup", backupdr_backup)
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if encryption_key_name is not None:
            pulumi.set(__self__, "encryption_key_name", encryption_key_name)
        if final_backup_description is not None:
            pulumi.set(__self__, "final_backup_description", final_backup_description)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if maintenance_version is not None:
            pulumi.set(__self__, "maintenance_version", maintenance_version)
        if master_instance_name is not None:
            pulumi.set(__self__, "master_instance_name", master_instance_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_configuration is not None:
            pulumi.set(__self__, "replica_configuration", replica_configuration)
        if replica_names is not None:
            pulumi.set(__self__, "replica_names", replica_names)
        if replication_cluster is not None:
            pulumi.set(__self__, "replication_cluster", replication_cluster)
        if restore_backup_context is not None:
            pulumi.set(__self__, "restore_backup_context", restore_backup_context)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Input[_builtins.str]:
        """
        The MySQL, PostgreSQL or
        SQL Server version to use. Supported values include `MYSQL_5_6`,
        `MYSQL_5_7`, `MYSQL_8_0`, `MYSQL_8_4`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
        `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `POSTGRES_16`, `POSTGRES_17`,
        `SQLSERVER_2017_STANDARD`, `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
        `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
        `SQLSERVER_2019_WEB`.
        [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
        includes an up-to-date reference of supported versions.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_version", value)

    @_builtins.property
    @pulumi.getter(name="backupdrBackup")
    def backupdr_backup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the BackupDR backup to restore from.
        """
        return pulumi.get(self, "backupdr_backup")

    @backupdr_backup.setter
    def backupdr_backup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backupdr_backup", value)

    @_builtins.property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input['DatabaseInstanceCloneArgs']]:
        """
        The context needed to create this instance as a clone of another instance. When this field is set during
        resource creation, this provider will attempt to clone another instance as indicated in the context. The
        configuration is detailed below.
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input['DatabaseInstanceCloneArgs']]):
        pulumi.set(self, "clone", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKeyName")
    def encryption_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full path to the encryption key used for the CMEK disk encryption.  Setting
        up disk encryption currently requires manual steps outside of this provider.
        The provided key must be in the same region as the SQL instance.  In order
        to use this feature, a special kind of service account must be created and
        granted permission on this key.  This step can currently only be done
        manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
        That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
        key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        """
        return pulumi.get(self, "encryption_key_name")

    @encryption_key_name.setter
    def encryption_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key_name", value)

    @_builtins.property
    @pulumi.getter(name="finalBackupDescription")
    def final_backup_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of final backup. Only set this field when `final_backup_config.enabled` is true.
        """
        return pulumi.get(self, "final_backup_description")

    @final_backup_description.setter
    def final_backup_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "final_backup_description", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the instance. See [API reference for SqlInstanceType](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/instances#SqlInstanceType) for supported values.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        """
        return pulumi.get(self, "maintenance_version")

    @maintenance_version.setter
    def maintenance_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_version", value)

    @_builtins.property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the existing instance that will
        act as the master in the replication setup. Note, this requires the master to
        have `binary_log_enabled` set, as well as existing backups.
        """
        return pulumi.get(self, "master_instance_name")

    @master_instance_name.setter
    def master_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_instance_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance. If the name is left
        blank, the provider will randomly generate one when the instance is first
        created. This is done because after a name is used, it cannot be reused for
        up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        For a read pool instance, the number of nodes in the read pool.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region the instance will sit in. If a region is not provided in the resource definition,
        the provider region will be used instead.

        - - -
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicaConfiguration")
    def replica_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']]:
        """
        The configuration for replication. The
        configuration is detailed below.
        """
        return pulumi.get(self, "replica_configuration")

    @replica_configuration.setter
    def replica_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']]):
        pulumi.set(self, "replica_configuration", value)

    @_builtins.property
    @pulumi.getter(name="replicaNames")
    def replica_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of replica names. Can be updated.
        """
        return pulumi.get(self, "replica_names")

    @replica_names.setter
    def replica_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "replica_names", value)

    @_builtins.property
    @pulumi.getter(name="replicationCluster")
    def replication_cluster(self) -> Optional[pulumi.Input['DatabaseInstanceReplicationClusterArgs']]:
        """
        A primary instance and disaster recovery replica pair. Applicable to MySQL and PostgreSQL. This field can be set only after both the primary and replica are created.
        """
        return pulumi.get(self, "replication_cluster")

    @replication_cluster.setter
    def replication_cluster(self, value: Optional[pulumi.Input['DatabaseInstanceReplicationClusterArgs']]):
        pulumi.set(self, "replication_cluster", value)

    @_builtins.property
    @pulumi.getter(name="restoreBackupContext")
    def restore_backup_context(self) -> Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']]:
        """
        The context needed to restore the database to a backup run. This field will
        cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
        **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
        block during resource creation/update will trigger the restore action after the resource is created/updated.
        """
        return pulumi.get(self, "restore_backup_context")

    @restore_backup_context.setter
    def restore_backup_context(self, value: Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']]):
        pulumi.set(self, "restore_backup_context", value)

    @_builtins.property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Initial root password. Can be updated. Required for MS SQL Server.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_password", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsArgs']]:
        """
        The settings to use for the database. The
        configuration is detailed below. Required if `clone` is not set.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class _DatabaseInstanceState:
    def __init__(__self__, *,
                 available_maintenance_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backupdr_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 clone: Optional[pulumi.Input['DatabaseInstanceCloneArgs']] = None,
                 connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_names: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceDnsNameArgs']]]] = None,
                 encryption_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 final_backup_description: Optional[pulumi.Input[_builtins.str]] = None,
                 first_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceIpAddressArgs']]]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 master_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 psc_service_attachment_link: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_configuration: Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']] = None,
                 replica_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 replication_cluster: Optional[pulumi.Input['DatabaseInstanceReplicationClusterArgs']] = None,
                 restore_backup_context: Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']] = None,
                 root_password: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 server_ca_certs: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceServerCaCertArgs']]]] = None,
                 service_account_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input['DatabaseInstanceSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering DatabaseInstance resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_maintenance_versions: The list of all maintenance versions applicable on the instance.
        :param pulumi.Input[_builtins.str] backupdr_backup: The name of the BackupDR backup to restore from.
        :param pulumi.Input['DatabaseInstanceCloneArgs'] clone: The context needed to create this instance as a clone of another instance. When this field is set during
               resource creation, this provider will attempt to clone another instance as indicated in the context. The
               configuration is detailed below.
        :param pulumi.Input[_builtins.str] connection_name: The connection name of the instance to be used in
               connection strings. For example, when connecting with [Cloud SQL Proxy](https://cloud.google.com/sql/docs/mysql/connect-admin-proxy).
        :param pulumi.Input[_builtins.str] database_version: The MySQL, PostgreSQL or
               SQL Server version to use. Supported values include `MYSQL_5_6`,
               `MYSQL_5_7`, `MYSQL_8_0`, `MYSQL_8_4`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
               `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `POSTGRES_16`, `POSTGRES_17`,
               `SQLSERVER_2017_STANDARD`, `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
               `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
               `SQLSERVER_2019_WEB`.
               [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
               includes an up-to-date reference of supported versions.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        :param pulumi.Input[_builtins.str] dns_name: The DNS name of the instance. See [Connect to an instance using Private Service Connect](https://cloud.google.com/sql/docs/mysql/configure-private-service-connect#view-summary-information-cloud-sql-instances-psc-enabled) for more details.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceDnsNameArgs']]] dns_names: The list of DNS names used by this instance. Different connection types for an instance may have different DNS names. DNS names can apply to an individual instance or a cluster of instances.
        :param pulumi.Input[_builtins.str] encryption_key_name: The full path to the encryption key used for the CMEK disk encryption.  Setting
               up disk encryption currently requires manual steps outside of this provider.
               The provided key must be in the same region as the SQL instance.  In order
               to use this feature, a special kind of service account must be created and
               granted permission on this key.  This step can currently only be done
               manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
               That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
               key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        :param pulumi.Input[_builtins.str] final_backup_description: The description of final backup. Only set this field when `final_backup_config.enabled` is true.
        :param pulumi.Input[_builtins.str] first_ip_address: The first IPv4 address of any type assigned.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. See [API reference for SqlInstanceType](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/instances#SqlInstanceType) for supported values.
        :param pulumi.Input[_builtins.str] maintenance_version: The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        :param pulumi.Input[_builtins.str] master_instance_name: The name of the existing instance that will
               act as the master in the replication setup. Note, this requires the master to
               have `binary_log_enabled` set, as well as existing backups.
        :param pulumi.Input[_builtins.str] name: The name of the instance. If the name is left
               blank, the provider will randomly generate one when the instance is first
               created. This is done because after a name is used, it cannot be reused for
               up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        :param pulumi.Input[_builtins.int] node_count: For a read pool instance, the number of nodes in the read pool.
        :param pulumi.Input[_builtins.str] private_ip_address: The first private (`PRIVATE`) IPv4 address assigned.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] psc_service_attachment_link: the URI that points to the service attachment of the instance.
        :param pulumi.Input[_builtins.str] public_ip_address: The first public (`PRIMARY`) IPv4 address assigned.
        :param pulumi.Input[_builtins.str] region: The region the instance will sit in. If a region is not provided in the resource definition,
               the provider region will be used instead.
               
               - - -
        :param pulumi.Input['DatabaseInstanceReplicaConfigurationArgs'] replica_configuration: The configuration for replication. The
               configuration is detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replica_names: List of replica names. Can be updated.
        :param pulumi.Input['DatabaseInstanceReplicationClusterArgs'] replication_cluster: A primary instance and disaster recovery replica pair. Applicable to MySQL and PostgreSQL. This field can be set only after both the primary and replica are created.
        :param pulumi.Input['DatabaseInstanceRestoreBackupContextArgs'] restore_backup_context: The context needed to restore the database to a backup run. This field will
               cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
               **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
               block during resource creation/update will trigger the restore action after the resource is created/updated.
        :param pulumi.Input[_builtins.str] root_password: Initial root password. Can be updated. Required for MS SQL Server.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.str] service_account_email_address: The service account email address assigned to the
               instance.
        :param pulumi.Input['DatabaseInstanceSettingsArgs'] settings: The settings to use for the database. The
               configuration is detailed below. Required if `clone` is not set.
        """
        if available_maintenance_versions is not None:
            pulumi.set(__self__, "available_maintenance_versions", available_maintenance_versions)
        if backupdr_backup is not None:
            pulumi.set(__self__, "backupdr_backup", backupdr_backup)
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if dns_names is not None:
            pulumi.set(__self__, "dns_names", dns_names)
        if encryption_key_name is not None:
            pulumi.set(__self__, "encryption_key_name", encryption_key_name)
        if final_backup_description is not None:
            pulumi.set(__self__, "final_backup_description", final_backup_description)
        if first_ip_address is not None:
            pulumi.set(__self__, "first_ip_address", first_ip_address)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if maintenance_version is not None:
            pulumi.set(__self__, "maintenance_version", maintenance_version)
        if master_instance_name is not None:
            pulumi.set(__self__, "master_instance_name", master_instance_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_service_attachment_link is not None:
            pulumi.set(__self__, "psc_service_attachment_link", psc_service_attachment_link)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_configuration is not None:
            pulumi.set(__self__, "replica_configuration", replica_configuration)
        if replica_names is not None:
            pulumi.set(__self__, "replica_names", replica_names)
        if replication_cluster is not None:
            pulumi.set(__self__, "replication_cluster", replication_cluster)
        if restore_backup_context is not None:
            pulumi.set(__self__, "restore_backup_context", restore_backup_context)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if server_ca_certs is not None:
            pulumi.set(__self__, "server_ca_certs", server_ca_certs)
        if service_account_email_address is not None:
            pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter(name="availableMaintenanceVersions")
    def available_maintenance_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of all maintenance versions applicable on the instance.
        """
        return pulumi.get(self, "available_maintenance_versions")

    @available_maintenance_versions.setter
    def available_maintenance_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_maintenance_versions", value)

    @_builtins.property
    @pulumi.getter(name="backupdrBackup")
    def backupdr_backup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the BackupDR backup to restore from.
        """
        return pulumi.get(self, "backupdr_backup")

    @backupdr_backup.setter
    def backupdr_backup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backupdr_backup", value)

    @_builtins.property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input['DatabaseInstanceCloneArgs']]:
        """
        The context needed to create this instance as a clone of another instance. When this field is set during
        resource creation, this provider will attempt to clone another instance as indicated in the context. The
        configuration is detailed below.
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input['DatabaseInstanceCloneArgs']]):
        pulumi.set(self, "clone", value)

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection name of the instance to be used in
        connection strings. For example, when connecting with [Cloud SQL Proxy](https://cloud.google.com/sql/docs/mysql/connect-admin-proxy).
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MySQL, PostgreSQL or
        SQL Server version to use. Supported values include `MYSQL_5_6`,
        `MYSQL_5_7`, `MYSQL_8_0`, `MYSQL_8_4`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
        `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `POSTGRES_16`, `POSTGRES_17`,
        `SQLSERVER_2017_STANDARD`, `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
        `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
        `SQLSERVER_2019_WEB`.
        [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
        includes an up-to-date reference of supported versions.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_version", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS name of the instance. See [Connect to an instance using Private Service Connect](https://cloud.google.com/sql/docs/mysql/configure-private-service-connect#view-summary-information-cloud-sql-instances-psc-enabled) for more details.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceDnsNameArgs']]]]:
        """
        The list of DNS names used by this instance. Different connection types for an instance may have different DNS names. DNS names can apply to an individual instance or a cluster of instances.
        """
        return pulumi.get(self, "dns_names")

    @dns_names.setter
    def dns_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceDnsNameArgs']]]]):
        pulumi.set(self, "dns_names", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKeyName")
    def encryption_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full path to the encryption key used for the CMEK disk encryption.  Setting
        up disk encryption currently requires manual steps outside of this provider.
        The provided key must be in the same region as the SQL instance.  In order
        to use this feature, a special kind of service account must be created and
        granted permission on this key.  This step can currently only be done
        manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
        That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
        key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        """
        return pulumi.get(self, "encryption_key_name")

    @encryption_key_name.setter
    def encryption_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key_name", value)

    @_builtins.property
    @pulumi.getter(name="finalBackupDescription")
    def final_backup_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of final backup. Only set this field when `final_backup_config.enabled` is true.
        """
        return pulumi.get(self, "final_backup_description")

    @final_backup_description.setter
    def final_backup_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "final_backup_description", value)

    @_builtins.property
    @pulumi.getter(name="firstIpAddress")
    def first_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first IPv4 address of any type assigned.
        """
        return pulumi.get(self, "first_ip_address")

    @first_ip_address.setter
    def first_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the instance. See [API reference for SqlInstanceType](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/instances#SqlInstanceType) for supported values.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceIpAddressArgs']]]]:
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceIpAddressArgs']]]]):
        pulumi.set(self, "ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        """
        return pulumi.get(self, "maintenance_version")

    @maintenance_version.setter
    def maintenance_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_version", value)

    @_builtins.property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the existing instance that will
        act as the master in the replication setup. Note, this requires the master to
        have `binary_log_enabled` set, as well as existing backups.
        """
        return pulumi.get(self, "master_instance_name")

    @master_instance_name.setter
    def master_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_instance_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance. If the name is left
        blank, the provider will randomly generate one when the instance is first
        created. This is done because after a name is used, it cannot be reused for
        up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        For a read pool instance, the number of nodes in the read pool.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first private (`PRIVATE`) IPv4 address assigned.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pscServiceAttachmentLink")
    def psc_service_attachment_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the URI that points to the service attachment of the instance.
        """
        return pulumi.get(self, "psc_service_attachment_link")

    @psc_service_attachment_link.setter
    def psc_service_attachment_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psc_service_attachment_link", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first public (`PRIMARY`) IPv4 address assigned.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region the instance will sit in. If a region is not provided in the resource definition,
        the provider region will be used instead.

        - - -
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicaConfiguration")
    def replica_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']]:
        """
        The configuration for replication. The
        configuration is detailed below.
        """
        return pulumi.get(self, "replica_configuration")

    @replica_configuration.setter
    def replica_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceReplicaConfigurationArgs']]):
        pulumi.set(self, "replica_configuration", value)

    @_builtins.property
    @pulumi.getter(name="replicaNames")
    def replica_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of replica names. Can be updated.
        """
        return pulumi.get(self, "replica_names")

    @replica_names.setter
    def replica_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "replica_names", value)

    @_builtins.property
    @pulumi.getter(name="replicationCluster")
    def replication_cluster(self) -> Optional[pulumi.Input['DatabaseInstanceReplicationClusterArgs']]:
        """
        A primary instance and disaster recovery replica pair. Applicable to MySQL and PostgreSQL. This field can be set only after both the primary and replica are created.
        """
        return pulumi.get(self, "replication_cluster")

    @replication_cluster.setter
    def replication_cluster(self, value: Optional[pulumi.Input['DatabaseInstanceReplicationClusterArgs']]):
        pulumi.set(self, "replication_cluster", value)

    @_builtins.property
    @pulumi.getter(name="restoreBackupContext")
    def restore_backup_context(self) -> Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']]:
        """
        The context needed to restore the database to a backup run. This field will
        cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
        **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
        block during resource creation/update will trigger the restore action after the resource is created/updated.
        """
        return pulumi.get(self, "restore_backup_context")

    @restore_backup_context.setter
    def restore_backup_context(self, value: Optional[pulumi.Input['DatabaseInstanceRestoreBackupContextArgs']]):
        pulumi.set(self, "restore_backup_context", value)

    @_builtins.property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Initial root password. Can be updated. Required for MS SQL Server.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_password", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceServerCaCertArgs']]]]:
        return pulumi.get(self, "server_ca_certs")

    @server_ca_certs.setter
    def server_ca_certs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceServerCaCertArgs']]]]):
        pulumi.set(self, "server_ca_certs", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account email address assigned to the
        instance.
        """
        return pulumi.get(self, "service_account_email_address")

    @service_account_email_address.setter
    def service_account_email_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email_address", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsArgs']]:
        """
        The settings to use for the database. The
        configuration is detailed below. Required if `clone` is not set.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.type_token("gcp:sql/databaseInstance:DatabaseInstance")
class DatabaseInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backupdr_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 clone: Optional[pulumi.Input[Union['DatabaseInstanceCloneArgs', 'DatabaseInstanceCloneArgsDict']]] = None,
                 database_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 final_backup_description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 master_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_configuration: Optional[pulumi.Input[Union['DatabaseInstanceReplicaConfigurationArgs', 'DatabaseInstanceReplicaConfigurationArgsDict']]] = None,
                 replica_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 replication_cluster: Optional[pulumi.Input[Union['DatabaseInstanceReplicationClusterArgs', 'DatabaseInstanceReplicationClusterArgsDict']]] = None,
                 restore_backup_context: Optional[pulumi.Input[Union['DatabaseInstanceRestoreBackupContextArgs', 'DatabaseInstanceRestoreBackupContextArgsDict']]] = None,
                 root_password: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['DatabaseInstanceSettingsArgs', 'DatabaseInstanceSettingsArgsDict']]] = None,
                 __props__=None):
        """
        Creates a new Google SQL Database Instance. For more information, see the [official documentation](https://cloud.google.com/sql/docs/mysql/create-instance),
        or the [JSON API](https://cloud.google.com/sql/docs/admin-api/v1beta4/instances).

        > **NOTE on `sql.DatabaseInstance`:** - Second-generation instances include a
        default 'root'@'%' user with no password. This user will be deleted by the provider on
        instance creation. You should use `sql.User` to define a custom user with
        a restricted host and strong password.

        > **Note**: On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi update` to write the field to state) in order to destroy an instance.
        It is recommended to not set this field (or set it to true) until you're ready to destroy the instance and its databases.

        ## Example Usage

        ### SQL Second Generation Instance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            name="main-instance",
            database_version="POSTGRES_15",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
            })
        ```

        ### Private IP Instance
        > **NOTE:** For private IP instance setup, note that the `sql.DatabaseInstance` does not actually interpolate values from `servicenetworking.Connection`. You must explicitly add a `depends_on`reference as shown below.

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        private_network = gcp.compute.Network("private_network", name="private-network")
        private_ip_address = gcp.compute.GlobalAddress("private_ip_address",
            name="private-ip-address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=private_network.id)
        private_vpc_connection = gcp.servicenetworking.Connection("private_vpc_connection",
            network=private_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_address.name])
        db_name_suffix = random.RandomId("db_name_suffix", byte_length=4)
        instance = gcp.sql.DatabaseInstance("instance",
            name=db_name_suffix.hex.apply(lambda hex: f"private-instance-{hex}"),
            region="us-central1",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "ipv4_enabled": False,
                    "private_network": private_network.self_link,
                    "enable_private_path_for_google_cloud_services": True,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[private_vpc_connection]))
        ```

        ### ENTERPRISE_PLUS Instance with data_cache_config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            name="enterprise-plus-main-instance",
            database_version="MYSQL_8_0_31",
            settings={
                "tier": "db-perf-optimized-N-2",
                "edition": "ENTERPRISE_PLUS",
                "data_cache_config": {
                    "data_cache_enabled": True,
                },
            })
        ```

        ### Cloud SQL Instance with PSC connectivity

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            name="psc-enabled-main-instance",
            database_version="MYSQL_8_0",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "psc_configs": [{
                        "psc_enabled": True,
                        "allowed_consumer_projects": ["allowed-consumer-project-name"],
                    }],
                    "ipv4_enabled": False,
                },
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "availability_type": "REGIONAL",
            })
        ```

        ### Cloud SQL Instance with PSC auto connections

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            name="psc-enabled-main-instance",
            database_version="MYSQL_8_0",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "psc_configs": [{
                        "psc_enabled": True,
                        "allowed_consumer_projects": ["allowed-consumer-project-name"],
                        "psc_auto_connections": [{
                            "consumer_network": "network-name",
                            "consumer_service_project_id": "project-id",
                        }],
                    }],
                    "ipv4_enabled": False,
                },
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "availability_type": "REGIONAL",
            })
        ```

        ### Cloud SQL Instance with PSC outbound

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            name="psc-enabled-main-instance",
            database_version="MYSQL_8_0",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "psc_configs": [{
                        "psc_enabled": True,
                        "allowed_consumer_projects": ["allowed-consumer-project-name"],
                        "network_attachment_uri": "network-attachment-uri",
                    }],
                    "ipv4_enabled": False,
                },
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "availability_type": "REGIONAL",
            })
        ```

        ## Switchover

        Users can perform a switchover on a replica by following the steps below.

          ~>**WARNING:** Failure to follow these steps can lead to data loss (You will be warned during plan stage). To prevent data loss during a switchover, please verify your plan with the checklist below.

        For a more in-depth walkthrough with example code, see the Switchover Guide

        ### Steps to Invoke Switchover

        MySQL/PostgreSQL: Create a cross-region, Enterprise Plus edition primary and replica pair, then set the value of primary's `replication_cluster.failover_dr_replica_name` as the replica.

        SQL Server: Create a `cascadable` replica in a different region from the primary (`cascadable_replica` is set to true in `replica_configuration`)

        #### Invoking switchover in the replica resource:
        1. Change instance_type from `READ_REPLICA_INSTANCE` to `CLOUD_SQL_INSTANCE`
        2. Remove `master_instance_name`
        3. (SQL Server) Remove `replica_configuration`
        4. Add current primary's name to the replica's `replica_names` list
        5. (MySQL/PostgreSQL) Add current primary's name to the replica's `replication_cluster.failover_dr_replica_name`.
        6. (MySQL/PostgreSQL) Adjust `backup_configuration`. See Switchover Guide for details.

        #### Updating the primary resource:
        1. Change `instance_type` from `CLOUD_SQL_INSTANCE` to `READ_REPLICA_INSTANCE`
        2. Set `master_instance_name` to the original replica (which will be primary after switchover)
        3. (SQL Server) Set `replica_configuration` and set `cascadable_replica` to `true`
        4. Remove original replica from `replica_names`
           * **NOTE**: Do **not** delete the replica_names field, even if it has no replicas remaining. Set replica_names = [ ] to indicate it having no replicas.
        5. (MySQL/PostgreSQL) Set `replication_cluster.failover_dr_replica_name` as the empty string.
        6. (MySQL/PostgreSQL) Adjust `backup_configuration`. See Switchover Guide for details.
        #### Plan and verify that:
        - `pulumi preview` outputs **"0 to add, 0 to destroy"**
        - `pulumi preview` does not say **"must be replaced"** for any resource
        - Every resource **"will be updated in-place"**
        - Only the 2 instances involved in switchover have planned changes
        - (Recommended) Use `deletion_protection` on instances as a safety measure

        ## Import

        Database instances can be imported using one of any of these accepted formats:

        * `projects/{{project}}/instances/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Database instances can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:sql/databaseInstance:DatabaseInstance default projects/{{project}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:sql/databaseInstance:DatabaseInstance default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:sql/databaseInstance:DatabaseInstance default {{name}}
        ```

        config and set on the server.

        When importing, double-check that your config has all the fields set that you expect- just seeing

        no diff isn't sufficient to know that your config could reproduce the imported resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backupdr_backup: The name of the BackupDR backup to restore from.
        :param pulumi.Input[Union['DatabaseInstanceCloneArgs', 'DatabaseInstanceCloneArgsDict']] clone: The context needed to create this instance as a clone of another instance. When this field is set during
               resource creation, this provider will attempt to clone another instance as indicated in the context. The
               configuration is detailed below.
        :param pulumi.Input[_builtins.str] database_version: The MySQL, PostgreSQL or
               SQL Server version to use. Supported values include `MYSQL_5_6`,
               `MYSQL_5_7`, `MYSQL_8_0`, `MYSQL_8_4`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
               `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `POSTGRES_16`, `POSTGRES_17`,
               `SQLSERVER_2017_STANDARD`, `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
               `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
               `SQLSERVER_2019_WEB`.
               [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
               includes an up-to-date reference of supported versions.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        :param pulumi.Input[_builtins.str] encryption_key_name: The full path to the encryption key used for the CMEK disk encryption.  Setting
               up disk encryption currently requires manual steps outside of this provider.
               The provided key must be in the same region as the SQL instance.  In order
               to use this feature, a special kind of service account must be created and
               granted permission on this key.  This step can currently only be done
               manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
               That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
               key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        :param pulumi.Input[_builtins.str] final_backup_description: The description of final backup. Only set this field when `final_backup_config.enabled` is true.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. See [API reference for SqlInstanceType](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/instances#SqlInstanceType) for supported values.
        :param pulumi.Input[_builtins.str] maintenance_version: The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        :param pulumi.Input[_builtins.str] master_instance_name: The name of the existing instance that will
               act as the master in the replication setup. Note, this requires the master to
               have `binary_log_enabled` set, as well as existing backups.
        :param pulumi.Input[_builtins.str] name: The name of the instance. If the name is left
               blank, the provider will randomly generate one when the instance is first
               created. This is done because after a name is used, it cannot be reused for
               up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        :param pulumi.Input[_builtins.int] node_count: For a read pool instance, the number of nodes in the read pool.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region the instance will sit in. If a region is not provided in the resource definition,
               the provider region will be used instead.
               
               - - -
        :param pulumi.Input[Union['DatabaseInstanceReplicaConfigurationArgs', 'DatabaseInstanceReplicaConfigurationArgsDict']] replica_configuration: The configuration for replication. The
               configuration is detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replica_names: List of replica names. Can be updated.
        :param pulumi.Input[Union['DatabaseInstanceReplicationClusterArgs', 'DatabaseInstanceReplicationClusterArgsDict']] replication_cluster: A primary instance and disaster recovery replica pair. Applicable to MySQL and PostgreSQL. This field can be set only after both the primary and replica are created.
        :param pulumi.Input[Union['DatabaseInstanceRestoreBackupContextArgs', 'DatabaseInstanceRestoreBackupContextArgsDict']] restore_backup_context: The context needed to restore the database to a backup run. This field will
               cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
               **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
               block during resource creation/update will trigger the restore action after the resource is created/updated.
        :param pulumi.Input[_builtins.str] root_password: Initial root password. Can be updated. Required for MS SQL Server.
        :param pulumi.Input[Union['DatabaseInstanceSettingsArgs', 'DatabaseInstanceSettingsArgsDict']] settings: The settings to use for the database. The
               configuration is detailed below. Required if `clone` is not set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Google SQL Database Instance. For more information, see the [official documentation](https://cloud.google.com/sql/docs/mysql/create-instance),
        or the [JSON API](https://cloud.google.com/sql/docs/admin-api/v1beta4/instances).

        > **NOTE on `sql.DatabaseInstance`:** - Second-generation instances include a
        default 'root'@'%' user with no password. This user will be deleted by the provider on
        instance creation. You should use `sql.User` to define a custom user with
        a restricted host and strong password.

        > **Note**: On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi update` to write the field to state) in order to destroy an instance.
        It is recommended to not set this field (or set it to true) until you're ready to destroy the instance and its databases.

        ## Example Usage

        ### SQL Second Generation Instance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            name="main-instance",
            database_version="POSTGRES_15",
            region="us-central1",
            settings={
                "tier": "db-f1-micro",
            })
        ```

        ### Private IP Instance
        > **NOTE:** For private IP instance setup, note that the `sql.DatabaseInstance` does not actually interpolate values from `servicenetworking.Connection`. You must explicitly add a `depends_on`reference as shown below.

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        private_network = gcp.compute.Network("private_network", name="private-network")
        private_ip_address = gcp.compute.GlobalAddress("private_ip_address",
            name="private-ip-address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=private_network.id)
        private_vpc_connection = gcp.servicenetworking.Connection("private_vpc_connection",
            network=private_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_address.name])
        db_name_suffix = random.RandomId("db_name_suffix", byte_length=4)
        instance = gcp.sql.DatabaseInstance("instance",
            name=db_name_suffix.hex.apply(lambda hex: f"private-instance-{hex}"),
            region="us-central1",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "ipv4_enabled": False,
                    "private_network": private_network.self_link,
                    "enable_private_path_for_google_cloud_services": True,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[private_vpc_connection]))
        ```

        ### ENTERPRISE_PLUS Instance with data_cache_config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            name="enterprise-plus-main-instance",
            database_version="MYSQL_8_0_31",
            settings={
                "tier": "db-perf-optimized-N-2",
                "edition": "ENTERPRISE_PLUS",
                "data_cache_config": {
                    "data_cache_enabled": True,
                },
            })
        ```

        ### Cloud SQL Instance with PSC connectivity

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            name="psc-enabled-main-instance",
            database_version="MYSQL_8_0",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "psc_configs": [{
                        "psc_enabled": True,
                        "allowed_consumer_projects": ["allowed-consumer-project-name"],
                    }],
                    "ipv4_enabled": False,
                },
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "availability_type": "REGIONAL",
            })
        ```

        ### Cloud SQL Instance with PSC auto connections

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            name="psc-enabled-main-instance",
            database_version="MYSQL_8_0",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "psc_configs": [{
                        "psc_enabled": True,
                        "allowed_consumer_projects": ["allowed-consumer-project-name"],
                        "psc_auto_connections": [{
                            "consumer_network": "network-name",
                            "consumer_service_project_id": "project-id",
                        }],
                    }],
                    "ipv4_enabled": False,
                },
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "availability_type": "REGIONAL",
            })
        ```

        ### Cloud SQL Instance with PSC outbound

        ```python
        import pulumi
        import pulumi_gcp as gcp

        main = gcp.sql.DatabaseInstance("main",
            name="psc-enabled-main-instance",
            database_version="MYSQL_8_0",
            settings={
                "tier": "db-f1-micro",
                "ip_configuration": {
                    "psc_configs": [{
                        "psc_enabled": True,
                        "allowed_consumer_projects": ["allowed-consumer-project-name"],
                        "network_attachment_uri": "network-attachment-uri",
                    }],
                    "ipv4_enabled": False,
                },
                "backup_configuration": {
                    "enabled": True,
                    "binary_log_enabled": True,
                },
                "availability_type": "REGIONAL",
            })
        ```

        ## Switchover

        Users can perform a switchover on a replica by following the steps below.

          ~>**WARNING:** Failure to follow these steps can lead to data loss (You will be warned during plan stage). To prevent data loss during a switchover, please verify your plan with the checklist below.

        For a more in-depth walkthrough with example code, see the Switchover Guide

        ### Steps to Invoke Switchover

        MySQL/PostgreSQL: Create a cross-region, Enterprise Plus edition primary and replica pair, then set the value of primary's `replication_cluster.failover_dr_replica_name` as the replica.

        SQL Server: Create a `cascadable` replica in a different region from the primary (`cascadable_replica` is set to true in `replica_configuration`)

        #### Invoking switchover in the replica resource:
        1. Change instance_type from `READ_REPLICA_INSTANCE` to `CLOUD_SQL_INSTANCE`
        2. Remove `master_instance_name`
        3. (SQL Server) Remove `replica_configuration`
        4. Add current primary's name to the replica's `replica_names` list
        5. (MySQL/PostgreSQL) Add current primary's name to the replica's `replication_cluster.failover_dr_replica_name`.
        6. (MySQL/PostgreSQL) Adjust `backup_configuration`. See Switchover Guide for details.

        #### Updating the primary resource:
        1. Change `instance_type` from `CLOUD_SQL_INSTANCE` to `READ_REPLICA_INSTANCE`
        2. Set `master_instance_name` to the original replica (which will be primary after switchover)
        3. (SQL Server) Set `replica_configuration` and set `cascadable_replica` to `true`
        4. Remove original replica from `replica_names`
           * **NOTE**: Do **not** delete the replica_names field, even if it has no replicas remaining. Set replica_names = [ ] to indicate it having no replicas.
        5. (MySQL/PostgreSQL) Set `replication_cluster.failover_dr_replica_name` as the empty string.
        6. (MySQL/PostgreSQL) Adjust `backup_configuration`. See Switchover Guide for details.
        #### Plan and verify that:
        - `pulumi preview` outputs **"0 to add, 0 to destroy"**
        - `pulumi preview` does not say **"must be replaced"** for any resource
        - Every resource **"will be updated in-place"**
        - Only the 2 instances involved in switchover have planned changes
        - (Recommended) Use `deletion_protection` on instances as a safety measure

        ## Import

        Database instances can be imported using one of any of these accepted formats:

        * `projects/{{project}}/instances/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Database instances can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:sql/databaseInstance:DatabaseInstance default projects/{{project}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:sql/databaseInstance:DatabaseInstance default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:sql/databaseInstance:DatabaseInstance default {{name}}
        ```

        config and set on the server.

        When importing, double-check that your config has all the fields set that you expect- just seeing

        no diff isn't sufficient to know that your config could reproduce the imported resource.

        :param str resource_name: The name of the resource.
        :param DatabaseInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backupdr_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 clone: Optional[pulumi.Input[Union['DatabaseInstanceCloneArgs', 'DatabaseInstanceCloneArgsDict']]] = None,
                 database_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 final_backup_description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 master_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_configuration: Optional[pulumi.Input[Union['DatabaseInstanceReplicaConfigurationArgs', 'DatabaseInstanceReplicaConfigurationArgsDict']]] = None,
                 replica_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 replication_cluster: Optional[pulumi.Input[Union['DatabaseInstanceReplicationClusterArgs', 'DatabaseInstanceReplicationClusterArgsDict']]] = None,
                 restore_backup_context: Optional[pulumi.Input[Union['DatabaseInstanceRestoreBackupContextArgs', 'DatabaseInstanceRestoreBackupContextArgsDict']]] = None,
                 root_password: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['DatabaseInstanceSettingsArgs', 'DatabaseInstanceSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseInstanceArgs.__new__(DatabaseInstanceArgs)

            __props__.__dict__["backupdr_backup"] = backupdr_backup
            __props__.__dict__["clone"] = clone
            if database_version is None and not opts.urn:
                raise TypeError("Missing required property 'database_version'")
            __props__.__dict__["database_version"] = database_version
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["encryption_key_name"] = encryption_key_name
            __props__.__dict__["final_backup_description"] = final_backup_description
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["maintenance_version"] = maintenance_version
            __props__.__dict__["master_instance_name"] = master_instance_name
            __props__.__dict__["name"] = name
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_configuration"] = None if replica_configuration is None else pulumi.Output.secret(replica_configuration)
            __props__.__dict__["replica_names"] = replica_names
            __props__.__dict__["replication_cluster"] = replication_cluster
            __props__.__dict__["restore_backup_context"] = restore_backup_context
            __props__.__dict__["root_password"] = None if root_password is None else pulumi.Output.secret(root_password)
            __props__.__dict__["settings"] = settings
            __props__.__dict__["available_maintenance_versions"] = None
            __props__.__dict__["connection_name"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["dns_names"] = None
            __props__.__dict__["first_ip_address"] = None
            __props__.__dict__["ip_addresses"] = None
            __props__.__dict__["private_ip_address"] = None
            __props__.__dict__["psc_service_attachment_link"] = None
            __props__.__dict__["public_ip_address"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["server_ca_certs"] = None
            __props__.__dict__["service_account_email_address"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["replicaConfiguration", "rootPassword", "serverCaCerts"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DatabaseInstance, __self__).__init__(
            'gcp:sql/databaseInstance:DatabaseInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            available_maintenance_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backupdr_backup: Optional[pulumi.Input[_builtins.str]] = None,
            clone: Optional[pulumi.Input[Union['DatabaseInstanceCloneArgs', 'DatabaseInstanceCloneArgsDict']]] = None,
            connection_name: Optional[pulumi.Input[_builtins.str]] = None,
            database_version: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            dns_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseInstanceDnsNameArgs', 'DatabaseInstanceDnsNameArgsDict']]]]] = None,
            encryption_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            final_backup_description: Optional[pulumi.Input[_builtins.str]] = None,
            first_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseInstanceIpAddressArgs', 'DatabaseInstanceIpAddressArgsDict']]]]] = None,
            maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
            master_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_count: Optional[pulumi.Input[_builtins.int]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            psc_service_attachment_link: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replica_configuration: Optional[pulumi.Input[Union['DatabaseInstanceReplicaConfigurationArgs', 'DatabaseInstanceReplicaConfigurationArgsDict']]] = None,
            replica_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            replication_cluster: Optional[pulumi.Input[Union['DatabaseInstanceReplicationClusterArgs', 'DatabaseInstanceReplicationClusterArgsDict']]] = None,
            restore_backup_context: Optional[pulumi.Input[Union['DatabaseInstanceRestoreBackupContextArgs', 'DatabaseInstanceRestoreBackupContextArgsDict']]] = None,
            root_password: Optional[pulumi.Input[_builtins.str]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            server_ca_certs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseInstanceServerCaCertArgs', 'DatabaseInstanceServerCaCertArgsDict']]]]] = None,
            service_account_email_address: Optional[pulumi.Input[_builtins.str]] = None,
            settings: Optional[pulumi.Input[Union['DatabaseInstanceSettingsArgs', 'DatabaseInstanceSettingsArgsDict']]] = None) -> 'DatabaseInstance':
        """
        Get an existing DatabaseInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_maintenance_versions: The list of all maintenance versions applicable on the instance.
        :param pulumi.Input[_builtins.str] backupdr_backup: The name of the BackupDR backup to restore from.
        :param pulumi.Input[Union['DatabaseInstanceCloneArgs', 'DatabaseInstanceCloneArgsDict']] clone: The context needed to create this instance as a clone of another instance. When this field is set during
               resource creation, this provider will attempt to clone another instance as indicated in the context. The
               configuration is detailed below.
        :param pulumi.Input[_builtins.str] connection_name: The connection name of the instance to be used in
               connection strings. For example, when connecting with [Cloud SQL Proxy](https://cloud.google.com/sql/docs/mysql/connect-admin-proxy).
        :param pulumi.Input[_builtins.str] database_version: The MySQL, PostgreSQL or
               SQL Server version to use. Supported values include `MYSQL_5_6`,
               `MYSQL_5_7`, `MYSQL_8_0`, `MYSQL_8_4`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
               `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `POSTGRES_16`, `POSTGRES_17`,
               `SQLSERVER_2017_STANDARD`, `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
               `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
               `SQLSERVER_2019_WEB`.
               [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
               includes an up-to-date reference of supported versions.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        :param pulumi.Input[_builtins.str] dns_name: The DNS name of the instance. See [Connect to an instance using Private Service Connect](https://cloud.google.com/sql/docs/mysql/configure-private-service-connect#view-summary-information-cloud-sql-instances-psc-enabled) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseInstanceDnsNameArgs', 'DatabaseInstanceDnsNameArgsDict']]]] dns_names: The list of DNS names used by this instance. Different connection types for an instance may have different DNS names. DNS names can apply to an individual instance or a cluster of instances.
        :param pulumi.Input[_builtins.str] encryption_key_name: The full path to the encryption key used for the CMEK disk encryption.  Setting
               up disk encryption currently requires manual steps outside of this provider.
               The provided key must be in the same region as the SQL instance.  In order
               to use this feature, a special kind of service account must be created and
               granted permission on this key.  This step can currently only be done
               manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
               That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
               key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        :param pulumi.Input[_builtins.str] final_backup_description: The description of final backup. Only set this field when `final_backup_config.enabled` is true.
        :param pulumi.Input[_builtins.str] first_ip_address: The first IPv4 address of any type assigned.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. See [API reference for SqlInstanceType](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/instances#SqlInstanceType) for supported values.
        :param pulumi.Input[_builtins.str] maintenance_version: The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        :param pulumi.Input[_builtins.str] master_instance_name: The name of the existing instance that will
               act as the master in the replication setup. Note, this requires the master to
               have `binary_log_enabled` set, as well as existing backups.
        :param pulumi.Input[_builtins.str] name: The name of the instance. If the name is left
               blank, the provider will randomly generate one when the instance is first
               created. This is done because after a name is used, it cannot be reused for
               up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        :param pulumi.Input[_builtins.int] node_count: For a read pool instance, the number of nodes in the read pool.
        :param pulumi.Input[_builtins.str] private_ip_address: The first private (`PRIVATE`) IPv4 address assigned.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] psc_service_attachment_link: the URI that points to the service attachment of the instance.
        :param pulumi.Input[_builtins.str] public_ip_address: The first public (`PRIMARY`) IPv4 address assigned.
        :param pulumi.Input[_builtins.str] region: The region the instance will sit in. If a region is not provided in the resource definition,
               the provider region will be used instead.
               
               - - -
        :param pulumi.Input[Union['DatabaseInstanceReplicaConfigurationArgs', 'DatabaseInstanceReplicaConfigurationArgsDict']] replica_configuration: The configuration for replication. The
               configuration is detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replica_names: List of replica names. Can be updated.
        :param pulumi.Input[Union['DatabaseInstanceReplicationClusterArgs', 'DatabaseInstanceReplicationClusterArgsDict']] replication_cluster: A primary instance and disaster recovery replica pair. Applicable to MySQL and PostgreSQL. This field can be set only after both the primary and replica are created.
        :param pulumi.Input[Union['DatabaseInstanceRestoreBackupContextArgs', 'DatabaseInstanceRestoreBackupContextArgsDict']] restore_backup_context: The context needed to restore the database to a backup run. This field will
               cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
               **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
               block during resource creation/update will trigger the restore action after the resource is created/updated.
        :param pulumi.Input[_builtins.str] root_password: Initial root password. Can be updated. Required for MS SQL Server.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.str] service_account_email_address: The service account email address assigned to the
               instance.
        :param pulumi.Input[Union['DatabaseInstanceSettingsArgs', 'DatabaseInstanceSettingsArgsDict']] settings: The settings to use for the database. The
               configuration is detailed below. Required if `clone` is not set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseInstanceState.__new__(_DatabaseInstanceState)

        __props__.__dict__["available_maintenance_versions"] = available_maintenance_versions
        __props__.__dict__["backupdr_backup"] = backupdr_backup
        __props__.__dict__["clone"] = clone
        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["database_version"] = database_version
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["dns_names"] = dns_names
        __props__.__dict__["encryption_key_name"] = encryption_key_name
        __props__.__dict__["final_backup_description"] = final_backup_description
        __props__.__dict__["first_ip_address"] = first_ip_address
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ip_addresses"] = ip_addresses
        __props__.__dict__["maintenance_version"] = maintenance_version
        __props__.__dict__["master_instance_name"] = master_instance_name
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_service_attachment_link"] = psc_service_attachment_link
        __props__.__dict__["public_ip_address"] = public_ip_address
        __props__.__dict__["region"] = region
        __props__.__dict__["replica_configuration"] = replica_configuration
        __props__.__dict__["replica_names"] = replica_names
        __props__.__dict__["replication_cluster"] = replication_cluster
        __props__.__dict__["restore_backup_context"] = restore_backup_context
        __props__.__dict__["root_password"] = root_password
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["server_ca_certs"] = server_ca_certs
        __props__.__dict__["service_account_email_address"] = service_account_email_address
        __props__.__dict__["settings"] = settings
        return DatabaseInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availableMaintenanceVersions")
    def available_maintenance_versions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of all maintenance versions applicable on the instance.
        """
        return pulumi.get(self, "available_maintenance_versions")

    @_builtins.property
    @pulumi.getter(name="backupdrBackup")
    def backupdr_backup(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the BackupDR backup to restore from.
        """
        return pulumi.get(self, "backupdr_backup")

    @_builtins.property
    @pulumi.getter
    def clone(self) -> pulumi.Output[Optional['outputs.DatabaseInstanceClone']]:
        """
        The context needed to create this instance as a clone of another instance. When this field is set during
        resource creation, this provider will attempt to clone another instance as indicated in the context. The
        configuration is detailed below.
        """
        return pulumi.get(self, "clone")

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[_builtins.str]:
        """
        The connection name of the instance to be used in
        connection strings. For example, when connecting with [Cloud SQL Proxy](https://cloud.google.com/sql/docs/mysql/connect-admin-proxy).
        """
        return pulumi.get(self, "connection_name")

    @_builtins.property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[_builtins.str]:
        """
        The MySQL, PostgreSQL or
        SQL Server version to use. Supported values include `MYSQL_5_6`,
        `MYSQL_5_7`, `MYSQL_8_0`, `MYSQL_8_4`, `POSTGRES_9_6`,`POSTGRES_10`, `POSTGRES_11`,
        `POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `POSTGRES_16`, `POSTGRES_17`,
        `SQLSERVER_2017_STANDARD`, `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.
        `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,
        `SQLSERVER_2019_WEB`.
        [Database Version Policies](https://cloud.google.com/sql/docs/db-versions)
        includes an up-to-date reference of supported versions.
        """
        return pulumi.get(self, "database_version")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `destroy` or `update` command that deletes the instance will fail. Defaults to `true`.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        The DNS name of the instance. See [Connect to an instance using Private Service Connect](https://cloud.google.com/sql/docs/mysql/configure-private-service-connect#view-summary-information-cloud-sql-instances-psc-enabled) for more details.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> pulumi.Output[Sequence['outputs.DatabaseInstanceDnsName']]:
        """
        The list of DNS names used by this instance. Different connection types for an instance may have different DNS names. DNS names can apply to an individual instance or a cluster of instances.
        """
        return pulumi.get(self, "dns_names")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyName")
    def encryption_key_name(self) -> pulumi.Output[_builtins.str]:
        """
        The full path to the encryption key used for the CMEK disk encryption.  Setting
        up disk encryption currently requires manual steps outside of this provider.
        The provided key must be in the same region as the SQL instance.  In order
        to use this feature, a special kind of service account must be created and
        granted permission on this key.  This step can currently only be done
        manually, please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#service-account).
        That service account needs the `Cloud KMS > Cloud KMS CryptoKey Encrypter/Decrypter` role on your
        key - please see [this step](https://cloud.google.com/sql/docs/mysql/configure-cmek#grantkey).
        """
        return pulumi.get(self, "encryption_key_name")

    @_builtins.property
    @pulumi.getter(name="finalBackupDescription")
    def final_backup_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of final backup. Only set this field when `final_backup_config.enabled` is true.
        """
        return pulumi.get(self, "final_backup_description")

    @_builtins.property
    @pulumi.getter(name="firstIpAddress")
    def first_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The first IPv4 address of any type assigned.
        """
        return pulumi.get(self, "first_ip_address")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the instance. See [API reference for SqlInstanceType](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/instances#SqlInstanceType) for supported values.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Output[Sequence['outputs.DatabaseInstanceIpAddress']]:
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> pulumi.Output[_builtins.str]:
        """
        The current software version on the instance. This attribute can not be set during creation. Refer to `available_maintenance_versions` attribute to see what `maintenance_version` are available for upgrade. When this attribute gets updated, it will cause an instance restart. Setting a `maintenance_version` value that is older than the current one on the instance will be ignored.
        """
        return pulumi.get(self, "maintenance_version")

    @_builtins.property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the existing instance that will
        act as the master in the replication setup. Note, this requires the master to
        have `binary_log_enabled` set, as well as existing backups.
        """
        return pulumi.get(self, "master_instance_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the instance. If the name is left
        blank, the provider will randomly generate one when the instance is first
        created. This is done because after a name is used, it cannot be reused for
        up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[_builtins.int]:
        """
        For a read pool instance, the number of nodes in the read pool.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The first private (`PRIVATE`) IPv4 address assigned.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pscServiceAttachmentLink")
    def psc_service_attachment_link(self) -> pulumi.Output[_builtins.str]:
        """
        the URI that points to the service attachment of the instance.
        """
        return pulumi.get(self, "psc_service_attachment_link")

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The first public (`PRIMARY`) IPv4 address assigned.
        """
        return pulumi.get(self, "public_ip_address")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region the instance will sit in. If a region is not provided in the resource definition,
        the provider region will be used instead.

        - - -
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicaConfiguration")
    def replica_configuration(self) -> pulumi.Output['outputs.DatabaseInstanceReplicaConfiguration']:
        """
        The configuration for replication. The
        configuration is detailed below.
        """
        return pulumi.get(self, "replica_configuration")

    @_builtins.property
    @pulumi.getter(name="replicaNames")
    def replica_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of replica names. Can be updated.
        """
        return pulumi.get(self, "replica_names")

    @_builtins.property
    @pulumi.getter(name="replicationCluster")
    def replication_cluster(self) -> pulumi.Output['outputs.DatabaseInstanceReplicationCluster']:
        """
        A primary instance and disaster recovery replica pair. Applicable to MySQL and PostgreSQL. This field can be set only after both the primary and replica are created.
        """
        return pulumi.get(self, "replication_cluster")

    @_builtins.property
    @pulumi.getter(name="restoreBackupContext")
    def restore_backup_context(self) -> pulumi.Output[Optional['outputs.DatabaseInstanceRestoreBackupContext']]:
        """
        The context needed to restore the database to a backup run. This field will
        cause the provider to trigger the database to restore from the backup run indicated. The configuration is detailed below.
        **NOTE:** Restoring from a backup is an imperative action and not recommended via this provider. Adding or modifying this
        block during resource creation/update will trigger the restore action after the resource is created/updated.
        """
        return pulumi.get(self, "restore_backup_context")

    @_builtins.property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Initial root password. Can be updated. Required for MS SQL Server.
        """
        return pulumi.get(self, "root_password")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> pulumi.Output[Sequence['outputs.DatabaseInstanceServerCaCert']]:
        return pulumi.get(self, "server_ca_certs")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> pulumi.Output[_builtins.str]:
        """
        The service account email address assigned to the
        instance.
        """
        return pulumi.get(self, "service_account_email_address")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> pulumi.Output['outputs.DatabaseInstanceSettings']:
        """
        The settings to use for the database. The
        configuration is detailed below. Required if `clone` is not set.
        """
        return pulumi.get(self, "settings")

