# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetV2AcceleratorTypesResult',
    'AwaitableGetV2AcceleratorTypesResult',
    'get_v2_accelerator_types',
    'get_v2_accelerator_types_output',
]

@pulumi.output_type
class GetV2AcceleratorTypesResult:
    """
    A collection of values returned by getV2AcceleratorTypes.
    """
    def __init__(__self__, id=None, project=None, types=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if types and not isinstance(types, list):
            raise TypeError("Expected argument 'types' to be a list")
        pulumi.set(__self__, "types", types)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def types(self) -> Sequence[_builtins.str]:
        """
        The list of accelerator types available for the given project and zone.
        """
        return pulumi.get(self, "types")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        return pulumi.get(self, "zone")


class AwaitableGetV2AcceleratorTypesResult(GetV2AcceleratorTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetV2AcceleratorTypesResult(
            id=self.id,
            project=self.project,
            types=self.types,
            zone=self.zone)


def get_v2_accelerator_types(project: Optional[_builtins.str] = None,
                             zone: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetV2AcceleratorTypesResult:
    """
    Get accelerator types available for a project. For more information see the [official documentation](https://cloud.google.com/tpu/docs/) and [API](https://cloud.google.com/tpu/docs/reference/rest/v2/projects.locations.acceleratorTypes).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.tpu.get_v2_accelerator_types()
    ```

    ### Configure Basic TPU VM With Available Type

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.tpu.get_v2_accelerator_types()
    available_get_v2_runtime_versions = gcp.tpu.get_v2_runtime_versions()
    tpu = gcp.tpu.V2Vm("tpu",
        name="test-tpu",
        zone="us-central1-b",
        runtime_version=available_get_v2_runtime_versions.versions[0],
        accelerator_type=available.types[0])
    ```


    :param _builtins.str project: The project to list types for. If it
           is not provided, the provider project is used.
    :param _builtins.str zone: The zone to list types for. If it
           is not provided, the provider zone is used.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:tpu/getV2AcceleratorTypes:getV2AcceleratorTypes', __args__, opts=opts, typ=GetV2AcceleratorTypesResult).value

    return AwaitableGetV2AcceleratorTypesResult(
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        types=pulumi.get(__ret__, 'types'),
        zone=pulumi.get(__ret__, 'zone'))
def get_v2_accelerator_types_output(project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetV2AcceleratorTypesResult]:
    """
    Get accelerator types available for a project. For more information see the [official documentation](https://cloud.google.com/tpu/docs/) and [API](https://cloud.google.com/tpu/docs/reference/rest/v2/projects.locations.acceleratorTypes).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.tpu.get_v2_accelerator_types()
    ```

    ### Configure Basic TPU VM With Available Type

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.tpu.get_v2_accelerator_types()
    available_get_v2_runtime_versions = gcp.tpu.get_v2_runtime_versions()
    tpu = gcp.tpu.V2Vm("tpu",
        name="test-tpu",
        zone="us-central1-b",
        runtime_version=available_get_v2_runtime_versions.versions[0],
        accelerator_type=available.types[0])
    ```


    :param _builtins.str project: The project to list types for. If it
           is not provided, the provider project is used.
    :param _builtins.str zone: The zone to list types for. If it
           is not provided, the provider zone is used.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:tpu/getV2AcceleratorTypes:getV2AcceleratorTypes', __args__, opts=opts, typ=GetV2AcceleratorTypesResult)
    return __ret__.apply(lambda __response__: GetV2AcceleratorTypesResult(
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        types=pulumi.get(__response__, 'types'),
        zone=pulumi.get(__response__, 'zone')))
