# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AiRagEngineConfigArgs', 'AiRagEngineConfig']

@pulumi.input_type
class AiRagEngineConfigArgs:
    def __init__(__self__, *,
                 rag_managed_db_config: pulumi.Input['AiRagEngineConfigRagManagedDbConfigArgs'],
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AiRagEngineConfig resource.
        :param pulumi.Input['AiRagEngineConfigRagManagedDbConfigArgs'] rag_managed_db_config: Required. The config of the RagManagedDb used by RagEngine.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of the RagEngineConfig. eg us-central1
        """
        pulumi.set(__self__, "rag_managed_db_config", rag_managed_db_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="ragManagedDbConfig")
    def rag_managed_db_config(self) -> pulumi.Input['AiRagEngineConfigRagManagedDbConfigArgs']:
        """
        Required. The config of the RagManagedDb used by RagEngine.
        Structure is documented below.
        """
        return pulumi.get(self, "rag_managed_db_config")

    @rag_managed_db_config.setter
    def rag_managed_db_config(self, value: pulumi.Input['AiRagEngineConfigRagManagedDbConfigArgs']):
        pulumi.set(self, "rag_managed_db_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the RagEngineConfig. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AiRagEngineConfigState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rag_managed_db_config: Optional[pulumi.Input['AiRagEngineConfigRagManagedDbConfigArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AiRagEngineConfig resources.
        :param pulumi.Input[_builtins.str] name: The resource name of the Dataset. This value is set by Google.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['AiRagEngineConfigRagManagedDbConfigArgs'] rag_managed_db_config: Required. The config of the RagManagedDb used by RagEngine.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] region: The region of the RagEngineConfig. eg us-central1
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rag_managed_db_config is not None:
            pulumi.set(__self__, "rag_managed_db_config", rag_managed_db_config)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the Dataset. This value is set by Google.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="ragManagedDbConfig")
    def rag_managed_db_config(self) -> Optional[pulumi.Input['AiRagEngineConfigRagManagedDbConfigArgs']]:
        """
        Required. The config of the RagManagedDb used by RagEngine.
        Structure is documented below.
        """
        return pulumi.get(self, "rag_managed_db_config")

    @rag_managed_db_config.setter
    def rag_managed_db_config(self, value: Optional[pulumi.Input['AiRagEngineConfigRagManagedDbConfigArgs']]):
        pulumi.set(self, "rag_managed_db_config", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the RagEngineConfig. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("gcp:vertex/aiRagEngineConfig:AiRagEngineConfig")
class AiRagEngineConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rag_managed_db_config: Optional[pulumi.Input[Union['AiRagEngineConfigRagManagedDbConfigArgs', 'AiRagEngineConfigRagManagedDbConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Vertex AI RAG Engine lets you scale your RagManagedDb instance based on your usage and performance requirements using a choice of two tiers, and optionally, lets you delete your Vertex AI RAG Engine data using a third tier. The tier is a project-level setting that's available in the RagEngineConfig resource that impacts all RAG corpora using RagManagedDb. The following tiers are available in RagEngineConfig: Basic, Scaled and Unprovisioned.

        To get more information about RagEngineConfig, see:

        * [API documentation](https://cloud.google.com/vertex-ai/generative-ai/docs/reference/rest/v1/RagEngineConfig)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vertex-ai/generative-ai/docs/rag-engine/understanding-ragmanageddb)

        ## Example Usage

        ## Import

        RagEngineConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/ragEngineConfig`

        * `{{project}}/{{region}}`

        * `{{region}}`

        When using the `pulumi import` command, RagEngineConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiRagEngineConfig:AiRagEngineConfig default projects/{{project}}/locations/{{region}}/ragEngineConfig
        ```

        ```sh
        $ pulumi import gcp:vertex/aiRagEngineConfig:AiRagEngineConfig default {{project}}/{{region}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiRagEngineConfig:AiRagEngineConfig default {{region}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AiRagEngineConfigRagManagedDbConfigArgs', 'AiRagEngineConfigRagManagedDbConfigArgsDict']] rag_managed_db_config: Required. The config of the RagManagedDb used by RagEngine.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] region: The region of the RagEngineConfig. eg us-central1
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiRagEngineConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Vertex AI RAG Engine lets you scale your RagManagedDb instance based on your usage and performance requirements using a choice of two tiers, and optionally, lets you delete your Vertex AI RAG Engine data using a third tier. The tier is a project-level setting that's available in the RagEngineConfig resource that impacts all RAG corpora using RagManagedDb. The following tiers are available in RagEngineConfig: Basic, Scaled and Unprovisioned.

        To get more information about RagEngineConfig, see:

        * [API documentation](https://cloud.google.com/vertex-ai/generative-ai/docs/reference/rest/v1/RagEngineConfig)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vertex-ai/generative-ai/docs/rag-engine/understanding-ragmanageddb)

        ## Example Usage

        ## Import

        RagEngineConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/ragEngineConfig`

        * `{{project}}/{{region}}`

        * `{{region}}`

        When using the `pulumi import` command, RagEngineConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiRagEngineConfig:AiRagEngineConfig default projects/{{project}}/locations/{{region}}/ragEngineConfig
        ```

        ```sh
        $ pulumi import gcp:vertex/aiRagEngineConfig:AiRagEngineConfig default {{project}}/{{region}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiRagEngineConfig:AiRagEngineConfig default {{region}}
        ```

        :param str resource_name: The name of the resource.
        :param AiRagEngineConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiRagEngineConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rag_managed_db_config: Optional[pulumi.Input[Union['AiRagEngineConfigRagManagedDbConfigArgs', 'AiRagEngineConfigRagManagedDbConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiRagEngineConfigArgs.__new__(AiRagEngineConfigArgs)

            __props__.__dict__["project"] = project
            if rag_managed_db_config is None and not opts.urn:
                raise TypeError("Missing required property 'rag_managed_db_config'")
            __props__.__dict__["rag_managed_db_config"] = rag_managed_db_config
            __props__.__dict__["region"] = region
            __props__.__dict__["name"] = None
        super(AiRagEngineConfig, __self__).__init__(
            'gcp:vertex/aiRagEngineConfig:AiRagEngineConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            rag_managed_db_config: Optional[pulumi.Input[Union['AiRagEngineConfigRagManagedDbConfigArgs', 'AiRagEngineConfigRagManagedDbConfigArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'AiRagEngineConfig':
        """
        Get an existing AiRagEngineConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The resource name of the Dataset. This value is set by Google.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AiRagEngineConfigRagManagedDbConfigArgs', 'AiRagEngineConfigRagManagedDbConfigArgsDict']] rag_managed_db_config: Required. The config of the RagManagedDb used by RagEngine.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] region: The region of the RagEngineConfig. eg us-central1
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AiRagEngineConfigState.__new__(_AiRagEngineConfigState)

        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["rag_managed_db_config"] = rag_managed_db_config
        __props__.__dict__["region"] = region
        return AiRagEngineConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the Dataset. This value is set by Google.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="ragManagedDbConfig")
    def rag_managed_db_config(self) -> pulumi.Output['outputs.AiRagEngineConfigRagManagedDbConfig']:
        """
        Required. The config of the RagManagedDb used by RagEngine.
        Structure is documented below.
        """
        return pulumi.get(self, "rag_managed_db_config")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the RagEngineConfig. eg us-central1
        """
        return pulumi.get(self, "region")

