# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectorArgs', 'Connector']

@pulumi.input_type
class ConnectorArgs:
    def __init__(__self__, *,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 max_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input['ConnectorSubnetArgs']] = None):
        """
        The set of arguments for constructing a Connector resource.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The range of internal addresses that follows RFC 4632 notation. Example: `10.132.0.0/28`.
        :param pulumi.Input[_builtins.str] machine_type: Machine type of VM Instance underlying connector. Default is e2-micro
        :param pulumi.Input[_builtins.int] max_instances: Maximum value of instances in autoscaling group underlying the connector. Value must be between 3 and 10, inclusive. Must be
               higher than the value specified by min_instances. Required alongside `min_instances` if not using `min_throughput`/`max_throughput`.
        :param pulumi.Input[_builtins.int] max_throughput: Maximum throughput of the connector in Mbps, must be greater than `min_throughput`. Default is 300. Refers to the expected throughput
               when using an e2-micro machine type. Value must be a multiple of 100 from 300 through 1000. Must be higher than the value specified by
               min_throughput. Only one of `max_throughput` and `max_instances` can be specified. The use of max_throughput is discouraged in favor of max_instances.
        :param pulumi.Input[_builtins.int] min_instances: Minimum value of instances in autoscaling group underlying the connector. Value must be between 2 and 9, inclusive. Must be
               lower than the value specified by max_instances. Required alongside `max_instances` if not using `min_throughput`/`max_throughput`.
        :param pulumi.Input[_builtins.int] min_throughput: Minimum throughput of the connector in Mbps. Default and min is 200. Refers to the expected throughput when using an e2-micro machine type.
               Value must be a multiple of 100 from 200 through 900. Must be lower than the value specified by max_throughput.
               Only one of `min_throughput` and `min_instances` can be specified. The use of min_throughput is discouraged in favor of min_instances.
        :param pulumi.Input[_builtins.str] name: The name of the resource (Max 25 characters).
        :param pulumi.Input[_builtins.str] network: Name or self_link of the VPC network. Required if `ip_cidr_range` is set.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the VPC Access connector resides. If it is not provided, the provider region is used.
        :param pulumi.Input['ConnectorSubnetArgs'] subnet: The subnet in which to house the connector
               Structure is documented below.
        """
        if ip_cidr_range is not None:
            pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if min_throughput is not None:
            pulumi.set(__self__, "min_throughput", min_throughput)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The range of internal addresses that follows RFC 4632 notation. Example: `10.132.0.0/28`.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_cidr_range", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Machine type of VM Instance underlying connector. Default is e2-micro
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum value of instances in autoscaling group underlying the connector. Value must be between 3 and 10, inclusive. Must be
        higher than the value specified by min_instances. Required alongside `min_instances` if not using `min_throughput`/`max_throughput`.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_instances", value)

    @_builtins.property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum throughput of the connector in Mbps, must be greater than `min_throughput`. Default is 300. Refers to the expected throughput
        when using an e2-micro machine type. Value must be a multiple of 100 from 300 through 1000. Must be higher than the value specified by
        min_throughput. Only one of `max_throughput` and `max_instances` can be specified. The use of max_throughput is discouraged in favor of max_instances.
        """
        return pulumi.get(self, "max_throughput")

    @max_throughput.setter
    def max_throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_throughput", value)

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum value of instances in autoscaling group underlying the connector. Value must be between 2 and 9, inclusive. Must be
        lower than the value specified by max_instances. Required alongside `max_instances` if not using `min_throughput`/`max_throughput`.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_instances", value)

    @_builtins.property
    @pulumi.getter(name="minThroughput")
    def min_throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum throughput of the connector in Mbps. Default and min is 200. Refers to the expected throughput when using an e2-micro machine type.
        Value must be a multiple of 100 from 200 through 900. Must be lower than the value specified by max_throughput.
        Only one of `min_throughput` and `min_instances` can be specified. The use of min_throughput is discouraged in favor of min_instances.
        """
        return pulumi.get(self, "min_throughput")

    @min_throughput.setter
    def min_throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_throughput", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource (Max 25 characters).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name or self_link of the VPC network. Required if `ip_cidr_range` is set.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where the VPC Access connector resides. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['ConnectorSubnetArgs']]:
        """
        The subnet in which to house the connector
        Structure is documented below.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['ConnectorSubnetArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class _ConnectorState:
    def __init__(__self__, *,
                 connected_projects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 max_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input['ConnectorSubnetArgs']] = None):
        """
        Input properties used for looking up and filtering Connector resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connected_projects: List of projects using the connector.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The range of internal addresses that follows RFC 4632 notation. Example: `10.132.0.0/28`.
        :param pulumi.Input[_builtins.str] machine_type: Machine type of VM Instance underlying connector. Default is e2-micro
        :param pulumi.Input[_builtins.int] max_instances: Maximum value of instances in autoscaling group underlying the connector. Value must be between 3 and 10, inclusive. Must be
               higher than the value specified by min_instances. Required alongside `min_instances` if not using `min_throughput`/`max_throughput`.
        :param pulumi.Input[_builtins.int] max_throughput: Maximum throughput of the connector in Mbps, must be greater than `min_throughput`. Default is 300. Refers to the expected throughput
               when using an e2-micro machine type. Value must be a multiple of 100 from 300 through 1000. Must be higher than the value specified by
               min_throughput. Only one of `max_throughput` and `max_instances` can be specified. The use of max_throughput is discouraged in favor of max_instances.
        :param pulumi.Input[_builtins.int] min_instances: Minimum value of instances in autoscaling group underlying the connector. Value must be between 2 and 9, inclusive. Must be
               lower than the value specified by max_instances. Required alongside `max_instances` if not using `min_throughput`/`max_throughput`.
        :param pulumi.Input[_builtins.int] min_throughput: Minimum throughput of the connector in Mbps. Default and min is 200. Refers to the expected throughput when using an e2-micro machine type.
               Value must be a multiple of 100 from 200 through 900. Must be lower than the value specified by max_throughput.
               Only one of `min_throughput` and `min_instances` can be specified. The use of min_throughput is discouraged in favor of min_instances.
        :param pulumi.Input[_builtins.str] name: The name of the resource (Max 25 characters).
        :param pulumi.Input[_builtins.str] network: Name or self_link of the VPC network. Required if `ip_cidr_range` is set.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the VPC Access connector resides. If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] self_link: The fully qualified name of this VPC connector
        :param pulumi.Input[_builtins.str] state: State of the VPC access connector.
        :param pulumi.Input['ConnectorSubnetArgs'] subnet: The subnet in which to house the connector
               Structure is documented below.
        """
        if connected_projects is not None:
            pulumi.set(__self__, "connected_projects", connected_projects)
        if ip_cidr_range is not None:
            pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if min_throughput is not None:
            pulumi.set(__self__, "min_throughput", min_throughput)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter(name="connectedProjects")
    def connected_projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of projects using the connector.
        """
        return pulumi.get(self, "connected_projects")

    @connected_projects.setter
    def connected_projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connected_projects", value)

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The range of internal addresses that follows RFC 4632 notation. Example: `10.132.0.0/28`.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_cidr_range", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Machine type of VM Instance underlying connector. Default is e2-micro
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum value of instances in autoscaling group underlying the connector. Value must be between 3 and 10, inclusive. Must be
        higher than the value specified by min_instances. Required alongside `min_instances` if not using `min_throughput`/`max_throughput`.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_instances", value)

    @_builtins.property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum throughput of the connector in Mbps, must be greater than `min_throughput`. Default is 300. Refers to the expected throughput
        when using an e2-micro machine type. Value must be a multiple of 100 from 300 through 1000. Must be higher than the value specified by
        min_throughput. Only one of `max_throughput` and `max_instances` can be specified. The use of max_throughput is discouraged in favor of max_instances.
        """
        return pulumi.get(self, "max_throughput")

    @max_throughput.setter
    def max_throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_throughput", value)

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum value of instances in autoscaling group underlying the connector. Value must be between 2 and 9, inclusive. Must be
        lower than the value specified by max_instances. Required alongside `max_instances` if not using `min_throughput`/`max_throughput`.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_instances", value)

    @_builtins.property
    @pulumi.getter(name="minThroughput")
    def min_throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum throughput of the connector in Mbps. Default and min is 200. Refers to the expected throughput when using an e2-micro machine type.
        Value must be a multiple of 100 from 200 through 900. Must be lower than the value specified by max_throughput.
        Only one of `min_throughput` and `min_instances` can be specified. The use of min_throughput is discouraged in favor of min_instances.
        """
        return pulumi.get(self, "min_throughput")

    @min_throughput.setter
    def min_throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_throughput", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource (Max 25 characters).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name or self_link of the VPC network. Required if `ip_cidr_range` is set.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where the VPC Access connector resides. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of this VPC connector
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the VPC access connector.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['ConnectorSubnetArgs']]:
        """
        The subnet in which to house the connector
        Structure is documented below.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['ConnectorSubnetArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.type_token("gcp:vpcaccess/connector:Connector")
class Connector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 max_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[Union['ConnectorSubnetArgs', 'ConnectorSubnetArgsDict']]] = None,
                 __props__=None):
        """
        Serverless VPC Access connector resource.

        To get more information about Connector, see:

        * [API documentation](https://cloud.google.com/vpc/docs/reference/vpcaccess/rest/v1/projects.locations.connectors)
        * How-to Guides
            * [Configuring Serverless VPC Access](https://cloud.google.com/vpc/docs/configure-serverless-vpc-access)

        ## Example Usage

        ### Vpc Access Connector

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connector = gcp.vpcaccess.Connector("connector",
            name="vpc-con",
            ip_cidr_range="10.8.0.0/28",
            network="default",
            min_instances=2,
            max_instances=3)
        ```
        ### Vpc Access Connector Shared Vpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Subnetwork("custom_test",
            name="vpc-con",
            ip_cidr_range="10.2.0.0/28",
            region="us-central1",
            network="default")
        connector = gcp.vpcaccess.Connector("connector",
            name="vpc-con",
            subnet={
                "name": custom_test.name,
            },
            machine_type="e2-standard-4",
            min_instances=2,
            max_instances=3)
        ```

        ## Import

        Connector can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/connectors/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Connector can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vpcaccess/connector:Connector default projects/{{project}}/locations/{{region}}/connectors/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vpcaccess/connector:Connector default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vpcaccess/connector:Connector default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vpcaccess/connector:Connector default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The range of internal addresses that follows RFC 4632 notation. Example: `10.132.0.0/28`.
        :param pulumi.Input[_builtins.str] machine_type: Machine type of VM Instance underlying connector. Default is e2-micro
        :param pulumi.Input[_builtins.int] max_instances: Maximum value of instances in autoscaling group underlying the connector. Value must be between 3 and 10, inclusive. Must be
               higher than the value specified by min_instances. Required alongside `min_instances` if not using `min_throughput`/`max_throughput`.
        :param pulumi.Input[_builtins.int] max_throughput: Maximum throughput of the connector in Mbps, must be greater than `min_throughput`. Default is 300. Refers to the expected throughput
               when using an e2-micro machine type. Value must be a multiple of 100 from 300 through 1000. Must be higher than the value specified by
               min_throughput. Only one of `max_throughput` and `max_instances` can be specified. The use of max_throughput is discouraged in favor of max_instances.
        :param pulumi.Input[_builtins.int] min_instances: Minimum value of instances in autoscaling group underlying the connector. Value must be between 2 and 9, inclusive. Must be
               lower than the value specified by max_instances. Required alongside `max_instances` if not using `min_throughput`/`max_throughput`.
        :param pulumi.Input[_builtins.int] min_throughput: Minimum throughput of the connector in Mbps. Default and min is 200. Refers to the expected throughput when using an e2-micro machine type.
               Value must be a multiple of 100 from 200 through 900. Must be lower than the value specified by max_throughput.
               Only one of `min_throughput` and `min_instances` can be specified. The use of min_throughput is discouraged in favor of min_instances.
        :param pulumi.Input[_builtins.str] name: The name of the resource (Max 25 characters).
        :param pulumi.Input[_builtins.str] network: Name or self_link of the VPC network. Required if `ip_cidr_range` is set.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the VPC Access connector resides. If it is not provided, the provider region is used.
        :param pulumi.Input[Union['ConnectorSubnetArgs', 'ConnectorSubnetArgsDict']] subnet: The subnet in which to house the connector
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ConnectorArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Serverless VPC Access connector resource.

        To get more information about Connector, see:

        * [API documentation](https://cloud.google.com/vpc/docs/reference/vpcaccess/rest/v1/projects.locations.connectors)
        * How-to Guides
            * [Configuring Serverless VPC Access](https://cloud.google.com/vpc/docs/configure-serverless-vpc-access)

        ## Example Usage

        ### Vpc Access Connector

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connector = gcp.vpcaccess.Connector("connector",
            name="vpc-con",
            ip_cidr_range="10.8.0.0/28",
            network="default",
            min_instances=2,
            max_instances=3)
        ```
        ### Vpc Access Connector Shared Vpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Subnetwork("custom_test",
            name="vpc-con",
            ip_cidr_range="10.2.0.0/28",
            region="us-central1",
            network="default")
        connector = gcp.vpcaccess.Connector("connector",
            name="vpc-con",
            subnet={
                "name": custom_test.name,
            },
            machine_type="e2-standard-4",
            min_instances=2,
            max_instances=3)
        ```

        ## Import

        Connector can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/connectors/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Connector can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vpcaccess/connector:Connector default projects/{{project}}/locations/{{region}}/connectors/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vpcaccess/connector:Connector default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vpcaccess/connector:Connector default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vpcaccess/connector:Connector default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 max_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[Union['ConnectorSubnetArgs', 'ConnectorSubnetArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorArgs.__new__(ConnectorArgs)

            __props__.__dict__["ip_cidr_range"] = ip_cidr_range
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["max_instances"] = max_instances
            __props__.__dict__["max_throughput"] = max_throughput
            __props__.__dict__["min_instances"] = min_instances
            __props__.__dict__["min_throughput"] = min_throughput
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["connected_projects"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["state"] = None
        super(Connector, __self__).__init__(
            'gcp:vpcaccess/connector:Connector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connected_projects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
            machine_type: Optional[pulumi.Input[_builtins.str]] = None,
            max_instances: Optional[pulumi.Input[_builtins.int]] = None,
            max_throughput: Optional[pulumi.Input[_builtins.int]] = None,
            min_instances: Optional[pulumi.Input[_builtins.int]] = None,
            min_throughput: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subnet: Optional[pulumi.Input[Union['ConnectorSubnetArgs', 'ConnectorSubnetArgsDict']]] = None) -> 'Connector':
        """
        Get an existing Connector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connected_projects: List of projects using the connector.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The range of internal addresses that follows RFC 4632 notation. Example: `10.132.0.0/28`.
        :param pulumi.Input[_builtins.str] machine_type: Machine type of VM Instance underlying connector. Default is e2-micro
        :param pulumi.Input[_builtins.int] max_instances: Maximum value of instances in autoscaling group underlying the connector. Value must be between 3 and 10, inclusive. Must be
               higher than the value specified by min_instances. Required alongside `min_instances` if not using `min_throughput`/`max_throughput`.
        :param pulumi.Input[_builtins.int] max_throughput: Maximum throughput of the connector in Mbps, must be greater than `min_throughput`. Default is 300. Refers to the expected throughput
               when using an e2-micro machine type. Value must be a multiple of 100 from 300 through 1000. Must be higher than the value specified by
               min_throughput. Only one of `max_throughput` and `max_instances` can be specified. The use of max_throughput is discouraged in favor of max_instances.
        :param pulumi.Input[_builtins.int] min_instances: Minimum value of instances in autoscaling group underlying the connector. Value must be between 2 and 9, inclusive. Must be
               lower than the value specified by max_instances. Required alongside `max_instances` if not using `min_throughput`/`max_throughput`.
        :param pulumi.Input[_builtins.int] min_throughput: Minimum throughput of the connector in Mbps. Default and min is 200. Refers to the expected throughput when using an e2-micro machine type.
               Value must be a multiple of 100 from 200 through 900. Must be lower than the value specified by max_throughput.
               Only one of `min_throughput` and `min_instances` can be specified. The use of min_throughput is discouraged in favor of min_instances.
        :param pulumi.Input[_builtins.str] name: The name of the resource (Max 25 characters).
        :param pulumi.Input[_builtins.str] network: Name or self_link of the VPC network. Required if `ip_cidr_range` is set.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the VPC Access connector resides. If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] self_link: The fully qualified name of this VPC connector
        :param pulumi.Input[_builtins.str] state: State of the VPC access connector.
        :param pulumi.Input[Union['ConnectorSubnetArgs', 'ConnectorSubnetArgsDict']] subnet: The subnet in which to house the connector
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectorState.__new__(_ConnectorState)

        __props__.__dict__["connected_projects"] = connected_projects
        __props__.__dict__["ip_cidr_range"] = ip_cidr_range
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["max_instances"] = max_instances
        __props__.__dict__["max_throughput"] = max_throughput
        __props__.__dict__["min_instances"] = min_instances
        __props__.__dict__["min_throughput"] = min_throughput
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet"] = subnet
        return Connector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectedProjects")
    def connected_projects(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of projects using the connector.
        """
        return pulumi.get(self, "connected_projects")

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The range of internal addresses that follows RFC 4632 notation. Example: `10.132.0.0/28`.
        """
        return pulumi.get(self, "ip_cidr_range")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Machine type of VM Instance underlying connector. Default is e2-micro
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum value of instances in autoscaling group underlying the connector. Value must be between 3 and 10, inclusive. Must be
        higher than the value specified by min_instances. Required alongside `min_instances` if not using `min_throughput`/`max_throughput`.
        """
        return pulumi.get(self, "max_instances")

    @_builtins.property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum throughput of the connector in Mbps, must be greater than `min_throughput`. Default is 300. Refers to the expected throughput
        when using an e2-micro machine type. Value must be a multiple of 100 from 300 through 1000. Must be higher than the value specified by
        min_throughput. Only one of `max_throughput` and `max_instances` can be specified. The use of max_throughput is discouraged in favor of max_instances.
        """
        return pulumi.get(self, "max_throughput")

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum value of instances in autoscaling group underlying the connector. Value must be between 2 and 9, inclusive. Must be
        lower than the value specified by max_instances. Required alongside `max_instances` if not using `min_throughput`/`max_throughput`.
        """
        return pulumi.get(self, "min_instances")

    @_builtins.property
    @pulumi.getter(name="minThroughput")
    def min_throughput(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum throughput of the connector in Mbps. Default and min is 200. Refers to the expected throughput when using an e2-micro machine type.
        Value must be a multiple of 100 from 200 through 900. Must be lower than the value specified by max_throughput.
        Only one of `min_throughput` and `min_instances` can be specified. The use of min_throughput is discouraged in favor of min_instances.
        """
        return pulumi.get(self, "min_throughput")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource (Max 25 characters).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        Name or self_link of the VPC network. Required if `ip_cidr_range` is set.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where the VPC Access connector resides. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of this VPC connector
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the VPC access connector.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[Optional['outputs.ConnectorSubnet']]:
        """
        The subnet in which to house the connector
        Structure is documented below.
        """
        return pulumi.get(self, "subnet")

