# Contribution Guidelines

**GaNDLF** is a package that is worked on by the MLCommons community in general - additional members from the community are welcome!

## Issues

- The easiest way to contribute is by reporting issues is through the [GitHub](https://github.com/mlcommons/GaNDLF/issues/new?assignees=&labels=&template=---bug-report.md&title=). 
- When reporting an issue, please ensure you fill out as much information from the templates as possible for us to debug and diagnose it.

## Feature Requests

- If you have a particular feature in mind, please submit it via the new Feature Request system via [GitHub](https://github.com/mlcommons/GaNDLF/issues/new?assignees=&labels=&template=---feature-request.md&title=). 
- More information on requests ➡️ better understanding of requirements ➡️ quicker action.

## Pull Requests

Thank you for your interest in contributing to **GaNDLF**! To make the process as smooth as possible, please follow these guidelines for speedy reviews and merges:

- Ensure your PR addresses an existing issue or feature request (if none exists, please open one so that it can be triaged by the admins).
- All parties that have commits to a PR should sign the [MLCommons CLA](https://forms.gle/Ew1KkBVpyeJDuRw67).
- Your PR should be initiated from a branch that either contains the issue number it fixes and/or contains as much top-level information as possible to help moderators review and merge it.
- The branch should be from a fork of GaNDLF.
- Include tests for the code changes in your PR. Please provide an explanation If code coverage gets reduced, which will help the review process.
- Update documentation for the added functionality (if any).
- Fill out PR template.
