'''
FilePath: /python-Sigilyph/sigilyph/core/symbols.py
Descripttion: 
Author: chenyixiang
version: 
Date: 2024-10-17 11:16:37
LastEditors: Yixiang Chen
LastEditTime: 2025-08-12 17:49:21
'''


'''
        Phoneme Example Translation
        ------- ------- -----------
        AA	odd     AA D
        AE	at	AE T
        AH	hut	HH AH T
        AO	ought	AO T
        AW	cow	K AW
        AY	hide	HH AY D
        B 	be	B IY
        CH	cheese	CH IY Z
        D 	dee	D IY
        DH	thee	DH IY
        EH	Ed	EH D
        ER	hurt	HH ER T
        EY	ate	EY T
        F 	fee	F IY
        G 	green	G R IY N
        HH	he	HH IY
        IH	it	IH T
        IY	eat	IY T
        JH	gee	JH IY
        K 	key	K IY
        L 	lee	L IY
        M 	me	M IY
        N 	knee	N IY
        NG	ping	P IH NG
        OW	oat	OW T
        OY	toy	T OY
        P 	pee	P IY
        R 	read	R IY D
        S 	sea	S IY
        SH	she	SH IY
        T 	tea	T IY
        TH	theta	TH EY T AH
        UH	hood	HH UH D
        UW	two	T UW
        V 	vee	V IY
        W 	we	W IY
        Y 	yield	Y IY L D
        Z 	zee	Z IY
        ZH	seizure	S IY ZH ER
'''

punctuation = ["!", "?", "…", ",", ".", "'", "-", "...", "....", '"', ':', '“', '”']

punc_map_ch = { 
    "：": ",",
    "；": ",",
    "，": ",",
    "。": ".",
    "！": "!",
    "？": "?",
    "\n": ".",
    "·": ",",
    "、": ",",
    "...": "…",
    "$": ".",
    "“": "'",
    "”": "'",
    '"': "'",
    "‘": "'",
    "’": "'",
    "（": "'",
    "）": "'",
    "(": "'",
    ")": "'",
    "《": "'",
    "》": "'",
    "【": "'",
    "】": "'",
    "[": "'",
    "]": "'",
    "—": "-",
    "～": "-",
    "~": "-",
    "「": "'",
    "」": "'",
    "+": ",",
}

base_phone_set = [
 '<pad>',
 '<bos>',
 '<eos>',
 '<eps>',
 '<sp>',
 'sil',
 'sil_0',
 'sil_1',
 'sil_2',
 'sil_3',
 'sil_4',
 'spn',
]

cn_phone_set = [
 'AA',
 'E1',
 'E2',
 'E3',
 'E4',
 'E5',
 'EE',
 'En1',
 'En2',
 'En3',
 'En4',
 'En5',
 'MM',
 'NN',
 'OO',
 'a1',
 'a2',
 'a3',
 'a4',
 'a5',
 'ai1',
 'ai2',
 'ai3',
 'ai4',
 'ai5',
 'an1',
 'an2',
 'an3',
 'an4',
 'an5',
 'ang1',
 'ang2',
 'ang3',
 'ang4',
 'ang5',
 'ao1',
 'ao2',
 'ao3',
 'ao4',
 'ao5',
 'b',
 'c',
 'ch',
 'd',
 'e1',
 'e2',
 'e3',
 'e4',
 'e5',
 'ei1',
 'ei2',
 'ei3',
 'ei4',
 'ei5',
 'en1',
 'en2',
 'en3',
 'en4',
 'en5',
 'eng1',
 'eng2',
 'eng3',
 'eng4',
 'eng5',
 'er1',
 'er2',
 'er3',
 'er4',
 'er5',
 'f',
 'g',
 'h',
 'i1',
 'i2',
 'i3',
 'i4',
 'i5',
 'ia1',
 'ia2',
 'ia3',
 'ia4',
 'ia5',
 'ian1',
 'ian2',
 'ian3',
 'ian4',
 'ian5',
 'iang1',
 'iang2',
 'iang3',
 'iang4',
 'iang5',
 'iao1',
 'iao2',
 'iao3',
 'iao4',
 'iao5',
 'ie1',
 'ie2',
 'ie3',
 'ie4',
 'ie5',
 'ii1',
 'ii2',
 'ii3',
 'ii4',
 'ii5',
 'in1',
 'in2',
 'in3',
 'in4',
 'in5',
 'ing1',
 'ing2',
 'ing3',
 'ing4',
 'ing5',
 'iong1',
 'iong2',
 'iong3',
 'iong4',
 'iong5',
 'ir1',
 'ir2',
 'ir3',
 'ir4',
 'ir5',
 'iu1',
 'iu2',
 'iu3',
 'iu4',
 'iu5',
 'j',
 'k',
 'l',
 'm',
 'm1',
 'm2',
 'm3',
 'm4',
 'm5',
 'n',
 'n1',
 'n2',
 'n3',
 'n4',
 'n5',
 'o1',
 'o2',
 'o3',
 'o4',
 'o5',
 'ong1',
 'ong2',
 'ong3',
 'ong4',
 'ong5',
 'ou1',
 'ou2',
 'ou3',
 'ou4',
 'ou5',
 'p',
 'q',
 'r',
 's',
 'sh',
 't',
 'u1',
 'u2',
 'u3',
 'u4',
 'u5',
 'ua1',
 'ua2',
 'ua3',
 'ua4',
 'ua5',
 'uai1',
 'uai2',
 'uai3',
 'uai4',
 'uai5',
 'uan1',
 'uan2',
 'uan3',
 'uan4',
 'uan5',
 'uang1',
 'uang2',
 'uang3',
 'uang4',
 'uang5',
 'ui1',
 'ui2',
 'ui3',
 'ui4',
 'ui5',
 'un1',
 'un2',
 'un3',
 'un4',
 'un5',
 'uo1',
 'uo2',
 'uo3',
 'uo4',
 'uo5',
 'v1',
 'v2',
 'v3',
 'v4',
 'v5',
 'van1',
 'van2',
 'van3',
 'van4',
 'van5',
 've1',
 've2',
 've3',
 've4',
 've5',
 'vn1',
 'vn2',
 'vn3',
 'vn4',
 'vn5',
 'w',
 'x',
 'y',
 'z',
 'zh']



cn_word2phone_dict = {'a1': ['AA', 'a1'], 'a2': ['AA', 'a2'], 'a3': ['AA', 'a3'], 'a4': ['AA', 'a4'], 'a5': ['AA', 'a5'], 'ai1': ['AA', 'ai1'], 'ai2': ['AA', 'ai2'], 'ai3': ['AA', 'ai3'], 'ai4': ['AA', 'ai4'], 'ai5': ['AA', 'ai5'], 'an1': ['AA', 'an1'], 'an2': ['AA', 'an2'], 'an3': ['AA', 'an3'], 'an4': ['AA', 'an4'], 'an5': ['AA', 'an5'], 'ang1': ['AA', 'ang1'], 'ang2': ['AA', 'ang2'], 'ang3': ['AA', 'ang3'], 'ang4': ['AA', 'ang4'], 'ang5': ['AA', 'ang5'], 'ao1': ['AA', 'ao1'], 'ao2': ['AA', 'ao2'], 'ao3': ['AA', 'ao3'], 'ao4': ['AA', 'ao4'], 'ao5': ['AA', 'ao5'], 
                      'ba1': ['b', 'a1'], 'ba2': ['b', 'a2'], 'ba3': ['b', 'a3'], 'ba4': ['b', 'a4'], 'ba5': ['b', 'a5'], 'bai1': ['b', 'ai1'], 'bai2': ['b', 'ai2'], 'bai3': ['b', 'ai3'], 'bai4': ['b', 'ai4'], 'bai5': ['b', 'ai5'], 'ban1': ['b', 'an1'], 'ban2': ['b', 'an2'], 'ban3': ['b', 'an3'], 'ban4': ['b', 'an4'], 'ban5': ['b', 'an5'], 'bang1': ['b', 'ang1'], 'bang2': ['b', 'ang2'], 'bang3': ['b', 'ang3'], 'bang4': ['b', 'ang4'], 'bang5': ['b', 'ang5'], 'bao1': ['b', 'ao1'], 'bao2': ['b', 'ao2'], 'bao3': ['b', 'ao3'], 'bao4': ['b', 'ao4'], 'bao5': ['b', 'ao5'], 'bei1': ['b', 'ei1'], 'bei2': ['b', 'ei2'], 'bei3': ['b', 'ei3'], 'bei4': ['b', 'ei4'], 'bei5': ['b', 'ei5'], 'ben1': ['b', 'en1'], 'ben2': ['b', 'en2'], 'ben3': ['b', 'en3'], 'ben4': ['b', 'en4'], 'ben5': ['b', 'en5'], 'beng1': ['b', 'eng1'], 'beng2': ['b', 'eng2'], 'beng3': ['b', 'eng3'], 'beng4': ['b', 'eng4'], 'beng5': ['b', 'eng5'], 'bi1': ['b', 'i1'], 'bi2': ['b', 'i2'], 'bi3': ['b', 'i3'], 'bi4': ['b', 'i4'], 'bi5': ['b', 'i5'], 'bian1': ['b', 'ian1'], 'bian2': ['b', 'ian2'], 'bian3': ['b', 'ian3'], 'bian4': ['b', 'ian4'], 'bian5': ['b', 'ian5'], 'biao1': ['b', 'iao1'], 'biao2': ['b', 'iao2'], 'biao3': ['b', 'iao3'], 'biao4': ['b', 'iao4'], 'biao5': ['b', 'iao5'], 'bie1': ['b', 'ie1'], 'bie2': ['b', 'ie2'], 'bie3': ['b', 'ie3'], 'bie4': ['b', 'ie4'], 'bie5': ['b', 'ie5'], 'bin1': ['b', 'in1'], 'bin2': ['b', 'in2'], 'bin3': ['b', 'in3'], 'bin4': ['b', 'in4'], 'bin5': ['b', 'in5'], 'bing1': ['b', 'ing1'], 'bing2': ['b', 'ing2'], 'bing3': ['b', 'ing3'], 'bing4': ['b', 'ing4'], 'bing5': ['b', 'ing5'], 'bo1': ['b', 'o1'], 'bo2': ['b', 'o2'], 'bo3': ['b', 'o3'], 'bo4': ['b', 'o4'], 'bo5': ['b', 'o5'], 'bu1': ['b', 'u1'], 'bu2': ['b', 'u2'], 'bu3': ['b', 'u3'], 'bu4': ['b', 'u4'], 'bu5': ['b', 'u5'], 
                      'ca1': ['c', 'a1'], 'ca2': ['c', 'a2'], 'ca3': ['c', 'a3'], 'ca4': ['c', 'a4'], 'ca5': ['c', 'a5'], 'cai1': ['c', 'ai1'], 'cai2': ['c', 'ai2'], 'cai3': ['c', 'ai3'], 'cai4': ['c', 'ai4'], 'cai5': ['c', 'ai5'], 'can1': ['c', 'an1'], 'can2': ['c', 'an2'], 'can3': ['c', 'an3'], 'can4': ['c', 'an4'], 'can5': ['c', 'an5'], 'cang1': ['c', 'ang1'], 'cang2': ['c', 'ang2'], 'cang3': ['c', 'ang3'], 'cang4': ['c', 'ang4'], 'cang5': ['c', 'ang5'], 'cao1': ['c', 'ao1'], 'cao2': ['c', 'ao2'], 'cao3': ['c', 'ao3'], 'cao4': ['c', 'ao4'], 'cao5': ['c', 'ao5'], 'ce1': ['c', 'e1'], 'ce2': ['c', 'e2'], 'ce3': ['c', 'e3'], 'ce4': ['c', 'e4'], 'ce5': ['c', 'e5'], 'cei1': ['c', 'ei1'], 'cei2': ['c', 'ei2'], 'cei3': ['c', 'ei3'], 'cei4': ['c', 'ei4'], 'cei5': ['c', 'ei5'], 'cen1': ['c', 'en1'], 'cen2': ['c', 'en2'], 'cen3': ['c', 'en3'], 'cen4': ['c', 'en4'], 'cen5': ['c', 'en5'], 'ceng1': ['c', 'eng1'], 'ceng2': ['c', 'eng2'], 'ceng3': ['c', 'eng3'], 'ceng4': ['c', 'eng4'], 'ceng5': ['c', 'eng5'], 'cha1': ['ch', 'a1'], 'cha2': ['ch', 'a2'], 'cha3': ['ch', 'a3'], 'cha4': ['ch', 'a4'], 'cha5': ['ch', 'a5'], 'chai1': ['ch', 'ai1'], 'chai2': ['ch', 'ai2'], 'chai3': ['ch', 'ai3'], 'chai4': ['ch', 'ai4'], 'chai5': ['ch', 'ai5'], 'chan1': ['ch', 'an1'], 'chan2': ['ch', 'an2'], 'chan3': ['ch', 'an3'], 'chan4': ['ch', 'an4'], 'chan5': ['ch', 'an5'], 'chang1': ['ch', 'ang1'], 'chang2': ['ch', 'ang2'], 'chang3': ['ch', 'ang3'], 'chang4': ['ch', 'ang4'], 'chang5': ['ch', 'ang5'], 'chao1': ['ch', 'ao1'], 'chao2': ['ch', 'ao2'], 'chao3': ['ch', 'ao3'], 'chao4': ['ch', 'ao4'], 'chao5': ['ch', 'ao5'], 'che1': ['ch', 'e1'], 'che2': ['ch', 'e2'], 'che3': ['ch', 'e3'], 'che4': ['ch', 'e4'], 'che5': ['ch', 'e5'], 'chen1': ['ch', 'en1'], 'chen2': ['ch', 'en2'], 'chen3': ['ch', 'en3'], 'chen4': ['ch', 'en4'], 'chen5': ['ch', 'en5'], 'cheng1': ['ch', 'eng1'], 'cheng2': ['ch', 'eng2'], 'cheng3': ['ch', 'eng3'], 'cheng4': ['ch', 'eng4'], 'cheng5': ['ch', 'eng5'], 'chi1': ['ch', 'ir1'], 'chi2': ['ch', 'ir2'], 'chi3': ['ch', 'ir3'], 'chi4': ['ch', 'ir4'], 'chi5': ['ch', 'ir5'], 'chong1': ['ch', 'ong1'], 'chong2': ['ch', 'ong2'], 'chong3': ['ch', 'ong3'], 'chong4': ['ch', 'ong4'], 'chong5': ['ch', 'ong5'], 'chou1': ['ch', 'ou1'], 'chou2': ['ch', 'ou2'], 'chou3': ['ch', 'ou3'], 'chou4': ['ch', 'ou4'], 'chou5': ['ch', 'ou5'], 'chu1': ['ch', 'u1'], 'chu2': ['ch', 'u2'], 'chu3': ['ch', 'u3'], 'chu4': ['ch', 'u4'], 'chu5': ['ch', 'u5'], 'chua1': ['ch', 'ua1'], 'chua2': ['ch', 'ua2'], 'chua3': ['ch', 'ua3'], 'chua4': ['ch', 'ua4'], 'chua5': ['ch', 'ua5'], 'chuai1': ['ch', 'uai1'], 'chuai2': ['ch', 'uai2'], 'chuai3': ['ch', 'uai3'], 'chuai4': ['ch', 'uai4'], 'chuai5': ['ch', 'uai5'], 'chuan1': ['ch', 'uan1'], 'chuan2': ['ch', 'uan2'], 'chuan3': ['ch', 'uan3'], 'chuan4': ['ch', 'uan4'], 'chuan5': ['ch', 'uan5'], 'chuang1': ['ch', 'uang1'], 'chuang2': ['ch', 'uang2'], 'chuang3': ['ch', 'uang3'], 'chuang4': ['ch', 'uang4'], 'chuang5': ['ch', 'uang5'], 'chui1': ['ch', 'ui1'], 'chui2': ['ch', 'ui2'], 'chui3': ['ch', 'ui3'], 'chui4': ['ch', 'ui4'], 'chui5': ['ch', 'ui5'], 'chun1': ['ch', 'un1'], 'chun2': ['ch', 'un2'], 'chun3': ['ch', 'un3'], 'chun4': ['ch', 'un4'], 'chun5': ['ch', 'un5'], 'chuo1': ['ch', 'uo1'], 'chuo2': ['ch', 'uo2'], 'chuo3': ['ch', 'uo3'], 'chuo4': ['ch', 'uo4'], 'chuo5': ['ch', 'uo5'], 'ci1': ['c', 'ii1'], 'ci2': ['c', 'ii2'], 'ci3': ['c', 'ii3'], 'ci4': ['c', 'ii4'], 'ci5': ['c', 'ii5'], 'cong1': ['c', 'ong1'], 'cong2': ['c', 'ong2'], 'cong3': ['c', 'ong3'], 'cong4': ['c', 'ong4'], 'cong5': ['c', 'ong5'], 'cou1': ['c', 'ou1'], 'cou2': ['c', 'ou2'], 'cou3': ['c', 'ou3'], 'cou4': ['c', 'ou4'], 'cou5': ['c', 'ou5'], 'cu1': ['c', 'u1'], 'cu2': ['c', 'u2'], 'cu3': ['c', 'u3'], 'cu4': ['c', 'u4'], 'cu5': ['c', 'u5'], 'cuan1': ['c', 'uan1'], 'cuan2': ['c', 'uan2'], 'cuan3': ['c', 'uan3'], 'cuan4': ['c', 'uan4'], 'cuan5': ['c', 'uan5'], 'cui1': ['c', 'ui1'], 'cui2': ['c', 'ui2'], 'cui3': ['c', 'ui3'], 'cui4': ['c', 'ui4'], 'cui5': ['c', 'ui5'], 'cun1': ['c', 'un1'], 'cun2': ['c', 'un2'], 'cun3': ['c', 'un3'], 'cun4': ['c', 'un4'], 'cun5': ['c', 'un5'], 'cuo1': ['c', 'uo1'], 'cuo2': ['c', 'uo2'], 'cuo3': ['c', 'uo3'], 'cuo4': ['c', 'uo4'], 'cuo5': ['c', 'uo5'], 
                      'da1': ['d', 'a1'], 'da2': ['d', 'a2'], 'da3': ['d', 'a3'], 'da4': ['d', 'a4'], 'da5': ['d', 'a5'], 'dai1': ['d', 'ai1'], 'dai2': ['d', 'ai2'], 'dai3': ['d', 'ai3'], 'dai4': ['d', 'ai4'], 'dai5': ['d', 'ai5'], 'dan1': ['d', 'an1'], 'dan2': ['d', 'an2'], 'dan3': ['d', 'an3'], 'dan4': ['d', 'an4'], 'dan5': ['d', 'an5'], 'dang1': ['d', 'ang1'], 'dang2': ['d', 'ang2'], 'dang3': ['d', 'ang3'], 'dang4': ['d', 'ang4'], 'dang5': ['d', 'ang5'], 'dao1': ['d', 'ao1'], 'dao2': ['d', 'ao2'], 'dao3': ['d', 'ao3'], 'dao4': ['d', 'ao4'], 'dao5': ['d', 'ao5'], 'de1': ['d', 'e1'], 'de2': ['d', 'e2'], 'de3': ['d', 'e3'], 'de4': ['d', 'e4'], 'de5': ['d', 'e5'], 'dei1': ['d', 'ei1'], 'dei2': ['d', 'ei2'], 'dei3': ['d', 'ei3'], 'dei4': ['d', 'ei4'], 'dei5': ['d', 'ei5'], 'den1': ['d', 'en1'], 'den2': ['d', 'en2'], 'den3': ['d', 'en3'], 'den4': ['d', 'en4'], 'den5': ['d', 'en5'], 'deng1': ['d', 'eng1'], 'deng2': ['d', 'eng2'], 'deng3': ['d', 'eng3'], 'deng4': ['d', 'eng4'], 'deng5': ['d', 'eng5'], 'di1': ['d', 'i1'], 'di2': ['d', 'i2'], 'di3': ['d', 'i3'], 'di4': ['d', 'i4'], 'di5': ['d', 'i5'], 'dia1': ['d', 'ia1'], 'dia2': ['d', 'ia2'], 'dia3': ['d', 'ia3'], 'dia4': ['d', 'ia4'], 'dia5': ['d', 'ia5'], 'dian1': ['d', 'ian1'], 'dian2': ['d', 'ian2'], 'dian3': ['d', 'ian3'], 'dian4': ['d', 'ian4'], 'dian5': ['d', 'ian5'], 'diao1': ['d', 'iao1'], 'diao2': ['d', 'iao2'], 'diao3': ['d', 'iao3'], 'diao4': ['d', 'iao4'], 'diao5': ['d', 'iao5'], 'die1': ['d', 'ie1'], 'die2': ['d', 'ie2'], 'die3': ['d', 'ie3'], 'die4': ['d', 'ie4'], 'die5': ['d', 'ie5'], 'ding1': ['d', 'ing1'], 'ding2': ['d', 'ing2'], 'ding3': ['d', 'ing3'], 'ding4': ['d', 'ing4'], 'ding5': ['d', 'ing5'], 'diu1': ['d', 'iu1'], 'diu2': ['d', 'iu2'], 'diu3': ['d', 'iu3'], 'diu4': ['d', 'iu4'], 'diu5': ['d', 'iu5'], 'dong1': ['d', 'ong1'], 'dong2': ['d', 'ong2'], 'dong3': ['d', 'ong3'], 'dong4': ['d', 'ong4'], 'dong5': ['d', 'ong5'], 'dou1': ['d', 'ou1'], 'dou2': ['d', 'ou2'], 'dou3': ['d', 'ou3'], 'dou4': ['d', 'ou4'], 'dou5': ['d', 'ou5'], 'du1': ['d', 'u1'], 'du2': ['d', 'u2'], 'du3': ['d', 'u3'], 'du4': ['d', 'u4'], 'du5': ['d', 'u5'], 'duan1': ['d', 'uan1'], 'duan2': ['d', 'uan2'], 'duan3': ['d', 'uan3'], 'duan4': ['d', 'uan4'], 'duan5': ['d', 'uan5'], 'dui1': ['d', 'ui1'], 'dui2': ['d', 'ui2'], 'dui3': ['d', 'ui3'], 'dui4': ['d', 'ui4'], 'dui5': ['d', 'ui5'], 'dun1': ['d', 'un1'], 'dun2': ['d', 'un2'], 'dun3': ['d', 'un3'], 'dun4': ['d', 'un4'], 'dun5': ['d', 'un5'], 'duo1': ['d', 'uo1'], 'duo2': ['d', 'uo2'], 'duo3': ['d', 'uo3'], 'duo4': ['d', 'uo4'], 'duo5': ['d', 'uo5'], 
                      'e1': ['EE', 'e1'], 'e2': ['EE', 'e2'], 'e3': ['EE', 'e3'], 'e4': ['EE', 'e4'], 'e5': ['EE', 'e5'], 'ei1': ['EE', 'ei1'], 'ei2': ['EE', 'ei2'], 'ei3': ['EE', 'ei3'], 'ei4': ['EE', 'ei4'], 'ei5': ['EE', 'ei5'], 'en1': ['EE', 'en1'], 'en2': ['EE', 'en2'], 'en3': ['EE', 'en3'], 'en4': ['EE', 'en4'], 'en5': ['EE', 'en5'], 'eng1': ['EE', 'eng1'], 'eng2': ['EE', 'eng2'], 'eng3': ['EE', 'eng3'], 'eng4': ['EE', 'eng4'], 'eng5': ['EE', 'eng5'], 'er1': ['EE', 'er1'], 'er2': ['EE', 'er2'], 'er3': ['EE', 'er3'], 'er4': ['EE', 'er4'], 'er5': ['EE', 'er5'], 
                      'fa1': ['f', 'a1'], 'fa2': ['f', 'a2'], 'fa3': ['f', 'a3'], 'fa4': ['f', 'a4'], 'fa5': ['f', 'a5'], 'fan1': ['f', 'an1'], 'fan2': ['f', 'an2'], 'fan3': ['f', 'an3'], 'fan4': ['f', 'an4'], 'fan5': ['f', 'an5'], 'fang1': ['f', 'ang1'], 'fang2': ['f', 'ang2'], 'fang3': ['f', 'ang3'], 'fang4': ['f', 'ang4'], 'fang5': ['f', 'ang5'], 'fei1': ['f', 'ei1'], 'fei2': ['f', 'ei2'], 'fei3': ['f', 'ei3'], 'fei4': ['f', 'ei4'], 'fei5': ['f', 'ei5'], 'fen1': ['f', 'en1'], 'fen2': ['f', 'en2'], 'fen3': ['f', 'en3'], 'fen4': ['f', 'en4'], 'fen5': ['f', 'en5'], 'feng1': ['f', 'eng1'], 'feng2': ['f', 'eng2'], 'feng3': ['f', 'eng3'], 'feng4': ['f', 'eng4'], 'feng5': ['f', 'eng5'], 'fo1': ['f', 'o1'], 'fo2': ['f', 'o2'], 'fo3': ['f', 'o3'], 'fo4': ['f', 'o4'], 'fo5': ['f', 'o5'], 'fou1': ['f', 'ou1'], 'fou2': ['f', 'ou2'], 'fou3': ['f', 'ou3'], 'fou4': ['f', 'ou4'], 'fou5': ['f', 'ou5'], 'fu1': ['f', 'u1'], 'fu2': ['f', 'u2'], 'fu3': ['f', 'u3'], 'fu4': ['f', 'u4'], 'fu5': ['f', 'u5'], 
                      'ga1': ['g', 'a1'], 'ga2': ['g', 'a2'], 'ga3': ['g', 'a3'], 'ga4': ['g', 'a4'], 'ga5': ['g', 'a5'], 'gai1': ['g', 'ai1'], 'gai2': ['g', 'ai2'], 'gai3': ['g', 'ai3'], 'gai4': ['g', 'ai4'], 'gai5': ['g', 'ai5'], 'gan1': ['g', 'an1'], 'gan2': ['g', 'an2'], 'gan3': ['g', 'an3'], 'gan4': ['g', 'an4'], 'gan5': ['g', 'an5'], 'gang1': ['g', 'ang1'], 'gang2': ['g', 'ang2'], 'gang3': ['g', 'ang3'], 'gang4': ['g', 'ang4'], 'gang5': ['g', 'ang5'], 'gao1': ['g', 'ao1'], 'gao2': ['g', 'ao2'], 'gao3': ['g', 'ao3'], 'gao4': ['g', 'ao4'], 'gao5': ['g', 'ao5'], 'ge1': ['g', 'e1'], 'ge2': ['g', 'e2'], 'ge3': ['g', 'e3'], 'ge4': ['g', 'e4'], 'ge5': ['g', 'e5'], 'gei1': ['g', 'ei1'], 'gei2': ['g', 'ei2'], 'gei3': ['g', 'ei3'], 'gei4': ['g', 'ei4'], 'gei5': ['g', 'ei5'], 'gen1': ['g', 'en1'], 'gen2': ['g', 'en2'], 'gen3': ['g', 'en3'], 'gen4': ['g', 'en4'], 'gen5': ['g', 'en5'], 'geng1': ['g', 'eng1'], 'geng2': ['g', 'eng2'], 'geng3': ['g', 'eng3'], 'geng4': ['g', 'eng4'], 'geng5': ['g', 'eng5'], 'gong1': ['g', 'ong1'], 'gong2': ['g', 'ong2'], 'gong3': ['g', 'ong3'], 'gong4': ['g', 'ong4'], 'gong5': ['g', 'ong5'], 'gou1': ['g', 'ou1'], 'gou2': ['g', 'ou2'], 'gou3': ['g', 'ou3'], 'gou4': ['g', 'ou4'], 'gou5': ['g', 'ou5'], 'gu1': ['g', 'u1'], 'gu2': ['g', 'u2'], 'gu3': ['g', 'u3'], 'gu4': ['g', 'u4'], 'gu5': ['g', 'u5'], 'gua1': ['g', 'ua1'], 'gua2': ['g', 'ua2'], 'gua3': ['g', 'ua3'], 'gua4': ['g', 'ua4'], 'gua5': ['g', 'ua5'], 'guai1': ['g', 'uai1'], 'guai2': ['g', 'uai2'], 'guai3': ['g', 'uai3'], 'guai4': ['g', 'uai4'], 'guai5': ['g', 'uai5'], 'guan1': ['g', 'uan1'], 'guan2': ['g', 'uan2'], 'guan3': ['g', 'uan3'], 'guan4': ['g', 'uan4'], 'guan5': ['g', 'uan5'], 'guang1': ['g', 'uang1'], 'guang2': ['g', 'uang2'], 'guang3': ['g', 'uang3'], 'guang4': ['g', 'uang4'], 'guang5': ['g', 'uang5'], 'gui1': ['g', 'ui1'], 'gui2': ['g', 'ui2'], 'gui3': ['g', 'ui3'], 'gui4': ['g', 'ui4'], 'gui5': ['g', 'ui5'], 'gun1': ['g', 'un1'], 'gun2': ['g', 'un2'], 'gun3': ['g', 'un3'], 'gun4': ['g', 'un4'], 'gun5': ['g', 'un5'], 'guo1': ['g', 'uo1'], 'guo2': ['g', 'uo2'], 'guo3': ['g', 'uo3'], 'guo4': ['g', 'uo4'], 'guo5': ['g', 'uo5'], 
                      'ha1': ['h', 'a1'], 'ha2': ['h', 'a2'], 'ha3': ['h', 'a3'], 'ha4': ['h', 'a4'], 'ha5': ['h', 'a5'], 'hai1': ['h', 'ai1'], 'hai2': ['h', 'ai2'], 'hai3': ['h', 'ai3'], 'hai4': ['h', 'ai4'], 'hai5': ['h', 'ai5'], 'han1': ['h', 'an1'], 'han2': ['h', 'an2'], 'han3': ['h', 'an3'], 'han4': ['h', 'an4'], 'han5': ['h', 'an5'], 'hang1': ['h', 'ang1'], 'hang2': ['h', 'ang2'], 'hang3': ['h', 'ang3'], 'hang4': ['h', 'ang4'], 'hang5': ['h', 'ang5'], 'hao1': ['h', 'ao1'], 'hao2': ['h', 'ao2'], 'hao3': ['h', 'ao3'], 'hao4': ['h', 'ao4'], 'hao5': ['h', 'ao5'], 'he1': ['h', 'e1'], 'he2': ['h', 'e2'], 'he3': ['h', 'e3'], 'he4': ['h', 'e4'], 'he5': ['h', 'e5'], 'hei1': ['h', 'ei1'], 'hei2': ['h', 'ei2'], 'hei3': ['h', 'ei3'], 'hei4': ['h', 'ei4'], 'hei5': ['h', 'ei5'], 'hen1': ['h', 'en1'], 'hen2': ['h', 'en2'], 'hen3': ['h', 'en3'], 'hen4': ['h', 'en4'], 'hen5': ['h', 'en5'], 'heng1': ['h', 'eng1'], 'heng2': ['h', 'eng2'], 'heng3': ['h', 'eng3'], 'heng4': ['h', 'eng4'], 'heng5': ['h', 'eng5'], 'hong1': ['h', 'ong1'], 'hong2': ['h', 'ong2'], 'hong3': ['h', 'ong3'], 'hong4': ['h', 'ong4'], 'hong5': ['h', 'ong5'], 'hou1': ['h', 'ou1'], 'hou2': ['h', 'ou2'], 'hou3': ['h', 'ou3'], 'hou4': ['h', 'ou4'], 'hou5': ['h', 'ou5'], 'hu1': ['h', 'u1'], 'hu2': ['h', 'u2'], 'hu3': ['h', 'u3'], 'hu4': ['h', 'u4'], 'hu5': ['h', 'u5'], 'hua1': ['h', 'ua1'], 'hua2': ['h', 'ua2'], 'hua3': ['h', 'ua3'], 'hua4': ['h', 'ua4'], 'hua5': ['h', 'ua5'], 'huai1': ['h', 'uai1'], 'huai2': ['h', 'uai2'], 'huai3': ['h', 'uai3'], 'huai4': ['h', 'uai4'], 'huai5': ['h', 'uai5'], 'huan1': ['h', 'uan1'], 'huan2': ['h', 'uan2'], 'huan3': ['h', 'uan3'], 'huan4': ['h', 'uan4'], 'huan5': ['h', 'uan5'], 'huang1': ['h', 'uang1'], 'huang2': ['h', 'uang2'], 'huang3': ['h', 'uang3'], 'huang4': ['h', 'uang4'], 'huang5': ['h', 'uang5'], 'hui1': ['h', 'ui1'], 'hui2': ['h', 'ui2'], 'hui3': ['h', 'ui3'], 'hui4': ['h', 'ui4'], 'hui5': ['h', 'ui5'], 'hun1': ['h', 'un1'], 'hun2': ['h', 'un2'], 'hun3': ['h', 'un3'], 'hun4': ['h', 'un4'], 'hun5': ['h', 'un5'], 'huo1': ['h', 'uo1'], 'huo2': ['h', 'uo2'], 'huo3': ['h', 'uo3'], 'huo4': ['h', 'uo4'], 'huo5': ['h', 'uo5'], 
                      'ji1': ['j', 'i1'], 'ji2': ['j', 'i2'], 'ji3': ['j', 'i3'], 'ji4': ['j', 'i4'], 'ji5': ['j', 'i5'], 'jia1': ['j', 'ia1'], 'jia2': ['j', 'ia2'], 'jia3': ['j', 'ia3'], 'jia4': ['j', 'ia4'], 'jia5': ['j', 'ia5'], 'jian1': ['j', 'ian1'], 'jian2': ['j', 'ian2'], 'jian3': ['j', 'ian3'], 'jian4': ['j', 'ian4'], 'jian5': ['j', 'ian5'], 'jiang1': ['j', 'iang1'], 'jiang2': ['j', 'iang2'], 'jiang3': ['j', 'iang3'], 'jiang4': ['j', 'iang4'], 'jiang5': ['j', 'iang5'], 'jiao1': ['j', 'iao1'], 'jiao2': ['j', 'iao2'], 'jiao3': ['j', 'iao3'], 'jiao4': ['j', 'iao4'], 'jiao5': ['j', 'iao5'], 'jie1': ['j', 'ie1'], 'jie2': ['j', 'ie2'], 'jie3': ['j', 'ie3'], 'jie4': ['j', 'ie4'], 'jie5': ['j', 'ie5'], 'jin1': ['j', 'in1'], 'jin2': ['j', 'in2'], 'jin3': ['j', 'in3'], 'jin4': ['j', 'in4'], 'jin5': ['j', 'in5'], 'jing1': ['j', 'ing1'], 'jing2': ['j', 'ing2'], 'jing3': ['j', 'ing3'], 'jing4': ['j', 'ing4'], 'jing5': ['j', 'ing5'], 'jiong1': ['j', 'iong1'], 'jiong2': ['j', 'iong2'], 'jiong3': ['j', 'iong3'], 'jiong4': ['j', 'iong4'], 'jiong5': ['j', 'iong5'], 'jiu1': ['j', 'iu1'], 'jiu2': ['j', 'iu2'], 'jiu3': ['j', 'iu3'], 'jiu4': ['j', 'iu4'], 'jiu5': ['j', 'iu5'], 'ju1': ['j', 'v1'], 'ju2': ['j', 'v2'], 'ju3': ['j', 'v3'], 'ju4': ['j', 'v4'], 'ju5': ['j', 'v5'], 'jv1': ['j', 'v1'], 'jv2': ['j', 'v2'], 'jv3': ['j', 'v3'], 'jv4': ['j', 'v4'], 'jv5': ['j', 'v5'], 'juan1': ['j', 'van1'], 'juan2': ['j', 'van2'], 'juan3': ['j', 'van3'], 'juan4': ['j', 'van4'], 'juan5': ['j', 'van5'], 'jvan1': ['j', 'van1'], 'jvan2': ['j', 'van2'], 'jvan3': ['j', 'van3'], 'jvan4': ['j', 'van4'], 'jvan5': ['j', 'van5'], 'jue1': ['j', 've1'], 'jue2': ['j', 've2'], 'jue3': ['j', 've3'], 'jue4': ['j', 've4'], 'jue5': ['j', 've5'], 'jve1': ['j', 've1'], 'jve2': ['j', 've2'], 'jve3': ['j', 've3'], 'jve4': ['j', 've4'], 'jve5': ['j', 've5'], 'jun1': ['j', 'vn1'], 'jun2': ['j', 'vn2'], 'jun3': ['j', 'vn3'], 'jun4': ['j', 'vn4'], 'jun5': ['j', 'vn5'], 'jvn1': ['j', 'vn1'], 'jvn2': ['j', 'vn2'], 'jvn3': ['j', 'vn3'], 'jvn4': ['j', 'vn4'], 'jvn5': ['j', 'vn5'], 
                      'ka1': ['k', 'a1'], 'ka2': ['k', 'a2'], 'ka3': ['k', 'a3'], 'ka4': ['k', 'a4'], 'ka5': ['k', 'a5'], 'kai1': ['k', 'ai1'], 'kai2': ['k', 'ai2'], 'kai3': ['k', 'ai3'], 'kai4': ['k', 'ai4'], 'kai5': ['k', 'ai5'], 'kan1': ['k', 'an1'], 'kan2': ['k', 'an2'], 'kan3': ['k', 'an3'], 'kan4': ['k', 'an4'], 'kan5': ['k', 'an5'], 'kang1': ['k', 'ang1'], 'kang2': ['k', 'ang2'], 'kang3': ['k', 'ang3'], 'kang4': ['k', 'ang4'], 'kang5': ['k', 'ang5'], 'kao1': ['k', 'ao1'], 'kao2': ['k', 'ao2'], 'kao3': ['k', 'ao3'], 'kao4': ['k', 'ao4'], 'kao5': ['k', 'ao5'], 'ke1': ['k', 'e1'], 'ke2': ['k', 'e2'], 'ke3': ['k', 'e3'], 'ke4': ['k', 'e4'], 'ke5': ['k', 'e5'], 'kei1': ['k', 'ei1'], 'kei2': ['k', 'ei2'], 'kei3': ['k', 'ei3'], 'kei4': ['k', 'ei4'], 'kei5': ['k', 'ei5'], 'ken1': ['k', 'en1'], 'ken2': ['k', 'en2'], 'ken3': ['k', 'en3'], 'ken4': ['k', 'en4'], 'ken5': ['k', 'en5'], 'keng1': ['k', 'eng1'], 'keng2': ['k', 'eng2'], 'keng3': ['k', 'eng3'], 'keng4': ['k', 'eng4'], 'keng5': ['k', 'eng5'], 'kong1': ['k', 'ong1'], 'kong2': ['k', 'ong2'], 'kong3': ['k', 'ong3'], 'kong4': ['k', 'ong4'], 'kong5': ['k', 'ong5'], 'kou1': ['k', 'ou1'], 'kou2': ['k', 'ou2'], 'kou3': ['k', 'ou3'], 'kou4': ['k', 'ou4'], 'kou5': ['k', 'ou5'], 'ku1': ['k', 'u1'], 'ku2': ['k', 'u2'], 'ku3': ['k', 'u3'], 'ku4': ['k', 'u4'], 'ku5': ['k', 'u5'], 'kua1': ['k', 'ua1'], 'kua2': ['k', 'ua2'], 'kua3': ['k', 'ua3'], 'kua4': ['k', 'ua4'], 'kua5': ['k', 'ua5'], 'kuai1': ['k', 'uai1'], 'kuai2': ['k', 'uai2'], 'kuai3': ['k', 'uai3'], 'kuai4': ['k', 'uai4'], 'kuai5': ['k', 'uai5'], 'kuan1': ['k', 'uan1'], 'kuan2': ['k', 'uan2'], 'kuan3': ['k', 'uan3'], 'kuan4': ['k', 'uan4'], 'kuan5': ['k', 'uan5'], 'kuang1': ['k', 'uang1'], 'kuang2': ['k', 'uang2'], 'kuang3': ['k', 'uang3'], 'kuang4': ['k', 'uang4'], 'kuang5': ['k', 'uang5'], 'kui1': ['k', 'ui1'], 'kui2': ['k', 'ui2'], 'kui3': ['k', 'ui3'], 'kui4': ['k', 'ui4'], 'kui5': ['k', 'ui5'], 'kun1': ['k', 'un1'], 'kun2': ['k', 'un2'], 'kun3': ['k', 'un3'], 'kun4': ['k', 'un4'], 'kun5': ['k', 'un5'], 'kuo1': ['k', 'uo1'], 'kuo2': ['k', 'uo2'], 'kuo3': ['k', 'uo3'], 'kuo4': ['k', 'uo4'], 'kuo5': ['k', 'uo5'], 
                      'la1': ['l', 'a1'], 'la2': ['l', 'a2'], 'la3': ['l', 'a3'], 'la4': ['l', 'a4'], 'la5': ['l', 'a5'], 'lai1': ['l', 'ai1'], 'lai2': ['l', 'ai2'], 'lai3': ['l', 'ai3'], 'lai4': ['l', 'ai4'], 'lai5': ['l', 'ai5'], 'lan1': ['l', 'an1'], 'lan2': ['l', 'an2'], 'lan3': ['l', 'an3'], 'lan4': ['l', 'an4'], 'lan5': ['l', 'an5'], 'lang1': ['l', 'ang1'], 'lang2': ['l', 'ang2'], 'lang3': ['l', 'ang3'], 'lang4': ['l', 'ang4'], 'lang5': ['l', 'ang5'], 'lao1': ['l', 'ao1'], 'lao2': ['l', 'ao2'], 'lao3': ['l', 'ao3'], 'lao4': ['l', 'ao4'], 'lao5': ['l', 'ao5'], 'le1': ['l', 'e1'], 'le2': ['l', 'e2'], 'le3': ['l', 'e3'], 'le4': ['l', 'e4'], 'le5': ['l', 'e5'], 'lei1': ['l', 'ei1'], 'lei2': ['l', 'ei2'], 'lei3': ['l', 'ei3'], 'lei4': ['l', 'ei4'], 'lei5': ['l', 'ei5'], 'leng1': ['l', 'eng1'], 'leng2': ['l', 'eng2'], 'leng3': ['l', 'eng3'], 'leng4': ['l', 'eng4'], 'leng5': ['l', 'eng5'], 'li1': ['l', 'i1'], 'li2': ['l', 'i2'], 'li3': ['l', 'i3'], 'li4': ['l', 'i4'], 'li5': ['l', 'i5'], 'lia1': ['l', 'ia1'], 'lia2': ['l', 'ia2'], 'lia3': ['l', 'ia3'], 'lia4': ['l', 'ia4'], 'lia5': ['l', 'ia5'], 'lian1': ['l', 'ian1'], 'lian2': ['l', 'ian2'], 'lian3': ['l', 'ian3'], 'lian4': ['l', 'ian4'], 'lian5': ['l', 'ian5'], 'liang1': ['l', 'iang1'], 'liang2': ['l', 'iang2'], 'liang3': ['l', 'iang3'], 'liang4': ['l', 'iang4'], 'liang5': ['l', 'iang5'], 'liao1': ['l', 'iao1'], 'liao2': ['l', 'iao2'], 'liao3': ['l', 'iao3'], 'liao4': ['l', 'iao4'], 'liao5': ['l', 'iao5'], 'lie1': ['l', 'ie1'], 'lie2': ['l', 'ie2'], 'lie3': ['l', 'ie3'], 'lie4': ['l', 'ie4'], 'lie5': ['l', 'ie5'], 'lin1': ['l', 'in1'], 'lin2': ['l', 'in2'], 'lin3': ['l', 'in3'], 'lin4': ['l', 'in4'], 'lin5': ['l', 'in5'], 'ling1': ['l', 'ing1'], 'ling2': ['l', 'ing2'], 'ling3': ['l', 'ing3'], 'ling4': ['l', 'ing4'], 'ling5': ['l', 'ing5'], 'liu1': ['l', 'iu1'], 'liu2': ['l', 'iu2'], 'liu3': ['l', 'iu3'], 'liu4': ['l', 'iu4'], 'liu5': ['l', 'iu5'], 'lo1': ['l', 'o1'], 'lo2': ['l', 'o2'], 'lo3': ['l', 'o3'], 'lo4': ['l', 'o4'], 'lo5': ['l', 'o5'], 'long1': ['l', 'ong1'], 'long2': ['l', 'ong2'], 'long3': ['l', 'ong3'], 'long4': ['l', 'ong4'], 'long5': ['l', 'ong5'], 'lou1': ['l', 'ou1'], 'lou2': ['l', 'ou2'], 'lou3': ['l', 'ou3'], 'lou4': ['l', 'ou4'], 'lou5': ['l', 'ou5'], 'lu1': ['l', 'u1'], 'lu2': ['l', 'u2'], 'lu3': ['l', 'u3'], 'lu4': ['l', 'u4'], 'lu5': ['l', 'u5'], 'luan1': ['l', 'uan1'], 'luan2': ['l', 'uan2'], 'luan3': ['l', 'uan3'], 'luan4': ['l', 'uan4'], 'luan5': ['l', 'uan5'], 'lue1': ['l', 've1'], 'lue2': ['l', 've2'], 'lue3': ['l', 've3'], 'lue4': ['l', 've4'], 'lue5': ['l', 've5'], 'lun1': ['l', 'un1'], 'lun2': ['l', 'un2'], 'lun3': ['l', 'un3'], 'lun4': ['l', 'un4'], 'lun5': ['l', 'un5'], 'luo1': ['l', 'uo1'], 'luo2': ['l', 'uo2'], 'luo3': ['l', 'uo3'], 'luo4': ['l', 'uo4'], 'luo5': ['l', 'uo5'], 'lv1': ['l', 'v1'], 'lv2': ['l', 'v2'], 'lv3': ['l', 'v3'], 'lv4': ['l', 'v4'], 'lv5': ['l', 'v5'], 'lve1': ['l', 've1'], 'lve2': ['l', 've2'], 'lve3': ['l', 've3'], 'lve4': ['l', 've4'], 'lve5': ['l', 've5'], 
                      'm1': ['MM', 'm1'], 'm2': ['MM', 'm2'], 'm3': ['MM', 'm3'], 'm4': ['MM', 'm4'], 'm5': ['MM', 'm5'], 'ma1': ['m', 'a1'], 'ma2': ['m', 'a2'], 'ma3': ['m', 'a3'], 'ma4': ['m', 'a4'], 'ma5': ['m', 'a5'], 'mai1': ['m', 'ai1'], 'mai2': ['m', 'ai2'], 'mai3': ['m', 'ai3'], 'mai4': ['m', 'ai4'], 'mai5': ['m', 'ai5'], 'man1': ['m', 'an1'], 'man2': ['m', 'an2'], 'man3': ['m', 'an3'], 'man4': ['m', 'an4'], 'man5': ['m', 'an5'], 'mang1': ['m', 'ang1'], 'mang2': ['m', 'ang2'], 'mang3': ['m', 'ang3'], 'mang4': ['m', 'ang4'], 'mang5': ['m', 'ang5'], 'mao1': ['m', 'ao1'], 'mao2': ['m', 'ao2'], 'mao3': ['m', 'ao3'], 'mao4': ['m', 'ao4'], 'mao5': ['m', 'ao5'], 'me1': ['m', 'e1'], 'me2': ['m', 'e2'], 'me3': ['m', 'e3'], 'me4': ['m', 'e4'], 'me5': ['m', 'e5'], 'mei1': ['m', 'ei1'], 'mei2': ['m', 'ei2'], 'mei3': ['m', 'ei3'], 'mei4': ['m', 'ei4'], 'mei5': ['m', 'ei5'], 'men1': ['m', 'en1'], 'men2': ['m', 'en2'], 'men3': ['m', 'en3'], 'men4': ['m', 'en4'], 'men5': ['m', 'en5'], 'meng1': ['m', 'eng1'], 'meng2': ['m', 'eng2'], 'meng3': ['m', 'eng3'], 'meng4': ['m', 'eng4'], 'meng5': ['m', 'eng5'], 'mi1': ['m', 'i1'], 'mi2': ['m', 'i2'], 'mi3': ['m', 'i3'], 'mi4': ['m', 'i4'], 'mi5': ['m', 'i5'], 'mian1': ['m', 'ian1'], 'mian2': ['m', 'ian2'], 'mian3': ['m', 'ian3'], 'mian4': ['m', 'ian4'], 'mian5': ['m', 'ian5'], 'miao1': ['m', 'iao1'], 'miao2': ['m', 'iao2'], 'miao3': ['m', 'iao3'], 'miao4': ['m', 'iao4'], 'miao5': ['m', 'iao5'], 'mie1': ['m', 'ie1'], 'mie2': ['m', 'ie2'], 'mie3': ['m', 'ie3'], 'mie4': ['m', 'ie4'], 'mie5': ['m', 'ie5'], 'min1': ['m', 'in1'], 'min2': ['m', 'in2'], 'min3': ['m', 'in3'], 'min4': ['m', 'in4'], 'min5': ['m', 'in5'], 'ming1': ['m', 'ing1'], 'ming2': ['m', 'ing2'], 'ming3': ['m', 'ing3'], 'ming4': ['m', 'ing4'], 'ming5': ['m', 'ing5'], 'miu1': ['m', 'iu1'], 'miu2': ['m', 'iu2'], 'miu3': ['m', 'iu3'], 'miu4': ['m', 'iu4'], 'miu5': ['m', 'iu5'], 'mo1': ['m', 'o1'], 'mo2': ['m', 'o2'], 'mo3': ['m', 'o3'], 'mo4': ['m', 'o4'], 'mo5': ['m', 'o5'], 'mou1': ['m', 'ou1'], 'mou2': ['m', 'ou2'], 'mou3': ['m', 'ou3'], 'mou4': ['m', 'ou4'], 'mou5': ['m', 'ou5'], 'mu1': ['m', 'u1'], 'mu2': ['m', 'u2'], 'mu3': ['m', 'u3'], 'mu4': ['m', 'u4'], 'mu5': ['m', 'u5'], 
                      'n1': ['NN', 'n1'], 'n2': ['NN', 'n2'], 'n3': ['NN', 'n3'], 'n4': ['NN', 'n4'], 'n5': ['NN', 'n5'], 'na1': ['n', 'a1'], 'na2': ['n', 'a2'], 'na3': ['n', 'a3'], 'na4': ['n', 'a4'], 'na5': ['n', 'a5'], 'nai1': ['n', 'ai1'], 'nai2': ['n', 'ai2'], 'nai3': ['n', 'ai3'], 'nai4': ['n', 'ai4'], 'nai5': ['n', 'ai5'], 'nan1': ['n', 'an1'], 'nan2': ['n', 'an2'], 'nan3': ['n', 'an3'], 'nan4': ['n', 'an4'], 'nan5': ['n', 'an5'], 'nang1': ['n', 'ang1'], 'nang2': ['n', 'ang2'], 'nang3': ['n', 'ang3'], 'nang4': ['n', 'ang4'], 'nang5': ['n', 'ang5'], 'nao1': ['n', 'ao1'], 'nao2': ['n', 'ao2'], 'nao3': ['n', 'ao3'], 'nao4': ['n', 'ao4'], 'nao5': ['n', 'ao5'], 'ne1': ['n', 'e1'], 'ne2': ['n', 'e2'], 'ne3': ['n', 'e3'], 'ne4': ['n', 'e4'], 'ne5': ['n', 'e5'], 'nei1': ['n', 'ei1'], 'nei2': ['n', 'ei2'], 'nei3': ['n', 'ei3'], 'nei4': ['n', 'ei4'], 'nei5': ['n', 'ei5'], 'nen1': ['n', 'en1'], 'nen2': ['n', 'en2'], 'nen3': ['n', 'en3'], 'nen4': ['n', 'en4'], 'nen5': ['n', 'en5'], 'neng1': ['n', 'eng1'], 'neng2': ['n', 'eng2'], 'neng3': ['n', 'eng3'], 'neng4': ['n', 'eng4'], 'neng5': ['n', 'eng5'], 'ni1': ['n', 'i1'], 'ni2': ['n', 'i2'], 'ni3': ['n', 'i3'], 'ni4': ['n', 'i4'], 'ni5': ['n', 'i5'], 'nian1': ['n', 'ian1'], 'nian2': ['n', 'ian2'], 'nian3': ['n', 'ian3'], 'nian4': ['n', 'ian4'], 'nian5': ['n', 'ian5'], 'niang1': ['n', 'iang1'], 'niang2': ['n', 'iang2'], 'niang3': ['n', 'iang3'], 'niang4': ['n', 'iang4'], 'niang5': ['n', 'iang5'], 'niao1': ['n', 'iao1'], 'niao2': ['n', 'iao2'], 'niao3': ['n', 'iao3'], 'niao4': ['n', 'iao4'], 'niao5': ['n', 'iao5'], 'nie1': ['n', 'ie1'], 'nie2': ['n', 'ie2'], 'nie3': ['n', 'ie3'], 'nie4': ['n', 'ie4'], 'nie5': ['n', 'ie5'], 'nin1': ['n', 'in1'], 'nin2': ['n', 'in2'], 'nin3': ['n', 'in3'], 'nin4': ['n', 'in4'], 'nin5': ['n', 'in5'], 'ning1': ['n', 'ing1'], 'ning2': ['n', 'ing2'], 'ning3': ['n', 'ing3'], 'ning4': ['n', 'ing4'], 'ning5': ['n', 'ing5'], 'niu1': ['n', 'iu1'], 'niu2': ['n', 'iu2'], 'niu3': ['n', 'iu3'], 'niu4': ['n', 'iu4'], 'niu5': ['n', 'iu5'], 'nong1': ['n', 'ong1'], 'nong2': ['n', 'ong2'], 'nong3': ['n', 'ong3'], 'nong4': ['n', 'ong4'], 'nong5': ['n', 'ong5'], 'nou1': ['n', 'ou1'], 'nou2': ['n', 'ou2'], 'nou3': ['n', 'ou3'], 'nou4': ['n', 'ou4'], 'nou5': ['n', 'ou5'], 'nu1': ['n', 'u1'], 'nu2': ['n', 'u2'], 'nu3': ['n', 'u3'], 'nu4': ['n', 'u4'], 'nu5': ['n', 'u5'], 'nuan1': ['n', 'uan1'], 'nuan2': ['n', 'uan2'], 'nuan3': ['n', 'uan3'], 'nuan4': ['n', 'uan4'], 'nuan5': ['n', 'uan5'], 'nun1': ['n', 'un1'], 'nun2': ['n', 'un2'], 'nun3': ['n', 'un3'], 'nun4': ['n', 'un4'], 'nun5': ['n', 'un5'], 'nuo1': ['n', 'uo1'], 'nuo2': ['n', 'uo2'], 'nuo3': ['n', 'uo3'], 'nuo4': ['n', 'uo4'], 'nuo5': ['n', 'uo5'], 'nv1': ['n', 'v1'], 'nv2': ['n', 'v2'], 'nv3': ['n', 'v3'], 'nv4': ['n', 'v4'], 'nv5': ['n', 'v5'], 'nve1': ['n', 've1'], 'nve2': ['n', 've2'], 'nve3': ['n', 've3'], 'nve4': ['n', 've4'], 'nve5': ['n', 've5'], 
                      'o1': ['OO', 'o1'], 'o2': ['OO', 'o2'], 'o3': ['OO', 'o3'], 'o4': ['OO', 'o4'], 'o5': ['OO', 'o5'], 'ou1': ['OO', 'ou1'], 'ou2': ['OO', 'ou2'], 'ou3': ['OO', 'ou3'], 'ou4': ['OO', 'ou4'], 'ou5': ['OO', 'ou5'], 
                      'pa1': ['p', 'a1'], 'pa2': ['p', 'a2'], 'pa3': ['p', 'a3'], 'pa4': ['p', 'a4'], 'pa5': ['p', 'a5'], 'pai1': ['p', 'ai1'], 'pai2': ['p', 'ai2'], 'pai3': ['p', 'ai3'], 'pai4': ['p', 'ai4'], 'pai5': ['p', 'ai5'], 'pan1': ['p', 'an1'], 'pan2': ['p', 'an2'], 'pan3': ['p', 'an3'], 'pan4': ['p', 'an4'], 'pan5': ['p', 'an5'], 'pang1': ['p', 'ang1'], 'pang2': ['p', 'ang2'], 'pang3': ['p', 'ang3'], 'pang4': ['p', 'ang4'], 'pang5': ['p', 'ang5'], 'pao1': ['p', 'ao1'], 'pao2': ['p', 'ao2'], 'pao3': ['p', 'ao3'], 'pao4': ['p', 'ao4'], 'pao5': ['p', 'ao5'], 'pei1': ['p', 'ei1'], 'pei2': ['p', 'ei2'], 'pei3': ['p', 'ei3'], 'pei4': ['p', 'ei4'], 'pei5': ['p', 'ei5'], 'pen1': ['p', 'en1'], 'pen2': ['p', 'en2'], 'pen3': ['p', 'en3'], 'pen4': ['p', 'en4'], 'pen5': ['p', 'en5'], 'peng1': ['p', 'eng1'], 'peng2': ['p', 'eng2'], 'peng3': ['p', 'eng3'], 'peng4': ['p', 'eng4'], 'peng5': ['p', 'eng5'], 'pi1': ['p', 'i1'], 'pi2': ['p', 'i2'], 'pi3': ['p', 'i3'], 'pi4': ['p', 'i4'], 'pi5': ['p', 'i5'], 'pian1': ['p', 'ian1'], 'pian2': ['p', 'ian2'], 'pian3': ['p', 'ian3'], 'pian4': ['p', 'ian4'], 'pian5': ['p', 'ian5'], 'piao1': ['p', 'iao1'], 'piao2': ['p', 'iao2'], 'piao3': ['p', 'iao3'], 'piao4': ['p', 'iao4'], 'piao5': ['p', 'iao5'], 'pie1': ['p', 'ie1'], 'pie2': ['p', 'ie2'], 'pie3': ['p', 'ie3'], 'pie4': ['p', 'ie4'], 'pie5': ['p', 'ie5'], 'pin1': ['p', 'in1'], 'pin2': ['p', 'in2'], 'pin3': ['p', 'in3'], 'pin4': ['p', 'in4'], 'pin5': ['p', 'in5'], 'ping1': ['p', 'ing1'], 'ping2': ['p', 'ing2'], 'ping3': ['p', 'ing3'], 'ping4': ['p', 'ing4'], 'ping5': ['p', 'ing5'], 'po1': ['p', 'o1'], 'po2': ['p', 'o2'], 'po3': ['p', 'o3'], 'po4': ['p', 'o4'], 'po5': ['p', 'o5'], 'pou1': ['p', 'ou1'], 'pou2': ['p', 'ou2'], 'pou3': ['p', 'ou3'], 'pou4': ['p', 'ou4'], 'pou5': ['p', 'ou5'], 'pu1': ['p', 'u1'], 'pu2': ['p', 'u2'], 'pu3': ['p', 'u3'], 'pu4': ['p', 'u4'], 'pu5': ['p', 'u5'], 
                      'qi1': ['q', 'i1'], 'qi2': ['q', 'i2'], 'qi3': ['q', 'i3'], 'qi4': ['q', 'i4'], 'qi5': ['q', 'i5'], 'qia1': ['q', 'ia1'], 'qia2': ['q', 'ia2'], 'qia3': ['q', 'ia3'], 'qia4': ['q', 'ia4'], 'qia5': ['q', 'ia5'], 'qian1': ['q', 'ian1'], 'qian2': ['q', 'ian2'], 'qian3': ['q', 'ian3'], 'qian4': ['q', 'ian4'], 'qian5': ['q', 'ian5'], 'qiang1': ['q', 'iang1'], 'qiang2': ['q', 'iang2'], 'qiang3': ['q', 'iang3'], 'qiang4': ['q', 'iang4'], 'qiang5': ['q', 'iang5'], 'qiao1': ['q', 'iao1'], 'qiao2': ['q', 'iao2'], 'qiao3': ['q', 'iao3'], 'qiao4': ['q', 'iao4'], 'qiao5': ['q', 'iao5'], 'qie1': ['q', 'ie1'], 'qie2': ['q', 'ie2'], 'qie3': ['q', 'ie3'], 'qie4': ['q', 'ie4'], 'qie5': ['q', 'ie5'], 'qin1': ['q', 'in1'], 'qin2': ['q', 'in2'], 'qin3': ['q', 'in3'], 'qin4': ['q', 'in4'], 'qin5': ['q', 'in5'], 'qing1': ['q', 'ing1'], 'qing2': ['q', 'ing2'], 'qing3': ['q', 'ing3'], 'qing4': ['q', 'ing4'], 'qing5': ['q', 'ing5'], 'qiong1': ['q', 'iong1'], 'qiong2': ['q', 'iong2'], 'qiong3': ['q', 'iong3'], 'qiong4': ['q', 'iong4'], 'qiong5': ['q', 'iong5'], 'qiu1': ['q', 'iu1'], 'qiu2': ['q', 'iu2'], 'qiu3': ['q', 'iu3'], 'qiu4': ['q', 'iu4'], 'qiu5': ['q', 'iu5'], 'qu1': ['q', 'v1'], 'qu2': ['q', 'v2'], 'qu3': ['q', 'v3'], 'qu4': ['q', 'v4'], 'qu5': ['q', 'v5'], 'qv1': ['q', 'v1'], 'qv2': ['q', 'v2'], 'qv3': ['q', 'v3'], 'qv4': ['q', 'v4'], 'qv5': ['q', 'v5'], 'quan1': ['q', 'van1'], 'quan2': ['q', 'van2'], 'quan3': ['q', 'van3'], 'quan4': ['q', 'van4'], 'quan5': ['q', 'van5'], 'qvan1': ['q', 'van1'], 'qvan2': ['q', 'van2'], 'qvan3': ['q', 'van3'], 'qvan4': ['q', 'van4'], 'qvan5': ['q', 'van5'], 'que1': ['q', 've1'], 'que2': ['q', 've2'], 'que3': ['q', 've3'], 'que4': ['q', 've4'], 'que5': ['q', 've5'], 'qve1': ['q', 've1'], 'qve2': ['q', 've2'], 'qve3': ['q', 've3'], 'qve4': ['q', 've4'], 'qve5': ['q', 've5'], 'qun1': ['q', 'vn1'], 'qun2': ['q', 'vn2'], 'qun3': ['q', 'vn3'], 'qun4': ['q', 'vn4'], 'qun5': ['q', 'vn5'], 'qvn1': ['q', 'vn1'], 'qvn2': ['q', 'vn2'], 'qvn3': ['q', 'vn3'], 'qvn4': ['q', 'vn4'], 'qvn5': ['q', 'vn5'], 
                      'r1': ['e1', 'r'], 'r2': ['e2', 'r'], 'r3': ['e3', 'r'], 'r4': ['e4', 'r'], 'r5': ['e5', 'r'], 'ran1': ['r', 'an1'], 'ran2': ['r', 'an2'], 'ran3': ['r', 'an3'], 'ran4': ['r', 'an4'], 'ran5': ['r', 'an5'], 'rang1': ['r', 'ang1'], 'rang2': ['r', 'ang2'], 'rang3': ['r', 'ang3'], 'rang4': ['r', 'ang4'], 'rang5': ['r', 'ang5'], 'rao1': ['r', 'ao1'], 'rao2': ['r', 'ao2'], 'rao3': ['r', 'ao3'], 'rao4': ['r', 'ao4'], 'rao5': ['r', 'ao5'], 're1': ['r', 'e1'], 're2': ['r', 'e2'], 're3': ['r', 'e3'], 're4': ['r', 'e4'], 're5': ['r', 'e5'], 'ren1': ['r', 'en1'], 'ren2': ['r', 'en2'], 'ren3': ['r', 'en3'], 'ren4': ['r', 'en4'], 'ren5': ['r', 'en5'], 'reng1': ['r', 'eng1'], 'reng2': ['r', 'eng2'], 'reng3': ['r', 'eng3'], 'reng4': ['r', 'eng4'], 'reng5': ['r', 'eng5'], 'ri1': ['r', 'ir1'], 'ri2': ['r', 'ir2'], 'ri3': ['r', 'ir3'], 'ri4': ['r', 'ir4'], 'ri5': ['r', 'ir5'], 'rong1': ['r', 'ong1'], 'rong2': ['r', 'ong2'], 'rong3': ['r', 'ong3'], 'rong4': ['r', 'ong4'], 'rong5': ['r', 'ong5'], 'rou1': ['r', 'ou1'], 'rou2': ['r', 'ou2'], 'rou3': ['r', 'ou3'], 'rou4': ['r', 'ou4'], 'rou5': ['r', 'ou5'], 'ru1': ['r', 'u1'], 'ru2': ['r', 'u2'], 'ru3': ['r', 'u3'], 'ru4': ['r', 'u4'], 'ru5': ['r', 'u5'], 'rua1': ['r', 'ua1'], 'rua2': ['r', 'ua2'], 'rua3': ['r', 'ua3'], 'rua4': ['r', 'ua4'], 'rua5': ['r', 'ua5'], 'ruan1': ['r', 'uan1'], 'ruan2': ['r', 'uan2'], 'ruan3': ['r', 'uan3'], 'ruan4': ['r', 'uan4'], 'ruan5': ['r', 'uan5'], 'rui1': ['r', 'ui1'], 'rui2': ['r', 'ui2'], 'rui3': ['r', 'ui3'], 'rui4': ['r', 'ui4'], 'rui5': ['r', 'ui5'], 'run1': ['r', 'un1'], 'run2': ['r', 'un2'], 'run3': ['r', 'un3'], 'run4': ['r', 'un4'], 'run5': ['r', 'un5'], 'ruo1': ['r', 'uo1'], 'ruo2': ['r', 'uo2'], 'ruo3': ['r', 'uo3'], 'ruo4': ['r', 'uo4'], 'ruo5': ['r', 'uo5'], 
                      'sa1': ['s', 'a1'], 'sa2': ['s', 'a2'], 'sa3': ['s', 'a3'], 'sa4': ['s', 'a4'], 'sa5': ['s', 'a5'], 'sai1': ['s', 'ai1'], 'sai2': ['s', 'ai2'], 'sai3': ['s', 'ai3'], 'sai4': ['s', 'ai4'], 'sai5': ['s', 'ai5'], 'san1': ['s', 'an1'], 'san2': ['s', 'an2'], 'san3': ['s', 'an3'], 'san4': ['s', 'an4'], 'san5': ['s', 'an5'], 'sang1': ['s', 'ang1'], 'sang2': ['s', 'ang2'], 'sang3': ['s', 'ang3'], 'sang4': ['s', 'ang4'], 'sang5': ['s', 'ang5'], 'sao1': ['s', 'ao1'], 'sao2': ['s', 'ao2'], 'sao3': ['s', 'ao3'], 'sao4': ['s', 'ao4'], 'sao5': ['s', 'ao5'], 'se1': ['s', 'e1'], 'se2': ['s', 'e2'], 'se3': ['s', 'e3'], 'se4': ['s', 'e4'], 'se5': ['s', 'e5'], 'sen1': ['s', 'en1'], 'sen2': ['s', 'en2'], 'sen3': ['s', 'en3'], 'sen4': ['s', 'en4'], 'sen5': ['s', 'en5'], 'seng1': ['s', 'eng1'], 'seng2': ['s', 'eng2'], 'seng3': ['s', 'eng3'], 'seng4': ['s', 'eng4'], 'seng5': ['s', 'eng5'], 'sha1': ['sh', 'a1'], 'sha2': ['sh', 'a2'], 'sha3': ['sh', 'a3'], 'sha4': ['sh', 'a4'], 'sha5': ['sh', 'a5'], 'shai1': ['sh', 'ai1'], 'shai2': ['sh', 'ai2'], 'shai3': ['sh', 'ai3'], 'shai4': ['sh', 'ai4'], 'shai5': ['sh', 'ai5'], 'shan1': ['sh', 'an1'], 'shan2': ['sh', 'an2'], 'shan3': ['sh', 'an3'], 'shan4': ['sh', 'an4'], 'shan5': ['sh', 'an5'], 'shang1': ['sh', 'ang1'], 'shang2': ['sh', 'ang2'], 'shang3': ['sh', 'ang3'], 'shang4': ['sh', 'ang4'], 'shang5': ['sh', 'ang5'], 'shao1': ['sh', 'ao1'], 'shao2': ['sh', 'ao2'], 'shao3': ['sh', 'ao3'], 'shao4': ['sh', 'ao4'], 'shao5': ['sh', 'ao5'], 'she1': ['sh', 'e1'], 'she2': ['sh', 'e2'], 'she3': ['sh', 'e3'], 'she4': ['sh', 'e4'], 'she5': ['sh', 'e5'], 'shei1': ['sh', 'ei1'], 'shei2': ['sh', 'ei2'], 'shei3': ['sh', 'ei3'], 'shei4': ['sh', 'ei4'], 'shei5': ['sh', 'ei5'], 'shen1': ['sh', 'en1'], 'shen2': ['sh', 'en2'], 'shen3': ['sh', 'en3'], 'shen4': ['sh', 'en4'], 'shen5': ['sh', 'en5'], 'sheng1': ['sh', 'eng1'], 'sheng2': ['sh', 'eng2'], 'sheng3': ['sh', 'eng3'], 'sheng4': ['sh', 'eng4'], 'sheng5': ['sh', 'eng5'], 'shi1': ['sh', 'ir1'], 'shi2': ['sh', 'ir2'], 'shi3': ['sh', 'ir3'], 'shi4': ['sh', 'ir4'], 'shi5': ['sh', 'ir5'], 'shou1': ['sh', 'ou1'], 'shou2': ['sh', 'ou2'], 'shou3': ['sh', 'ou3'], 'shou4': ['sh', 'ou4'], 'shou5': ['sh', 'ou5'], 'shu1': ['sh', 'u1'], 'shu2': ['sh', 'u2'], 'shu3': ['sh', 'u3'], 'shu4': ['sh', 'u4'], 'shu5': ['sh', 'u5'], 'shua1': ['sh', 'ua1'], 'shua2': ['sh', 'ua2'], 'shua3': ['sh', 'ua3'], 'shua4': ['sh', 'ua4'], 'shua5': ['sh', 'ua5'], 'shuai1': ['sh', 'uai1'], 'shuai2': ['sh', 'uai2'], 'shuai3': ['sh', 'uai3'], 'shuai4': ['sh', 'uai4'], 'shuai5': ['sh', 'uai5'], 'shuan1': ['sh', 'uan1'], 'shuan2': ['sh', 'uan2'], 'shuan3': ['sh', 'uan3'], 'shuan4': ['sh', 'uan4'], 'shuan5': ['sh', 'uan5'], 'shuang1': ['sh', 'uang1'], 'shuang2': ['sh', 'uang2'], 'shuang3': ['sh', 'uang3'], 'shuang4': ['sh', 'uang4'], 'shuang5': ['sh', 'uang5'], 'shui1': ['sh', 'ui1'], 'shui2': ['sh', 'ui2'], 'shui3': ['sh', 'ui3'], 'shui4': ['sh', 'ui4'], 'shui5': ['sh', 'ui5'], 'shun1': ['sh', 'un1'], 'shun2': ['sh', 'un2'], 'shun3': ['sh', 'un3'], 'shun4': ['sh', 'un4'], 'shun5': ['sh', 'un5'], 'shuo1': ['sh', 'uo1'], 'shuo2': ['sh', 'uo2'], 'shuo3': ['sh', 'uo3'], 'shuo4': ['sh', 'uo4'], 'shuo5': ['sh', 'uo5'], 'si1': ['s', 'ii1'], 'si2': ['s', 'ii2'], 'si3': ['s', 'ii3'], 'si4': ['s', 'ii4'], 'si5': ['s', 'ii5'], 'song1': ['s', 'ong1'], 'song2': ['s', 'ong2'], 'song3': ['s', 'ong3'], 'song4': ['s', 'ong4'], 'song5': ['s', 'ong5'], 'sou1': ['s', 'ou1'], 'sou2': ['s', 'ou2'], 'sou3': ['s', 'ou3'], 'sou4': ['s', 'ou4'], 'sou5': ['s', 'ou5'], 'su1': ['s', 'u1'], 'su2': ['s', 'u2'], 'su3': ['s', 'u3'], 'su4': ['s', 'u4'], 'su5': ['s', 'u5'], 'suan1': ['s', 'uan1'], 'suan2': ['s', 'uan2'], 'suan3': ['s', 'uan3'], 'suan4': ['s', 'uan4'], 'suan5': ['s', 'uan5'], 'sui1': ['s', 'ui1'], 'sui2': ['s', 'ui2'], 'sui3': ['s', 'ui3'], 'sui4': ['s', 'ui4'], 'sui5': ['s', 'ui5'], 'sun1': ['s', 'un1'], 'sun2': ['s', 'un2'], 'sun3': ['s', 'un3'], 'sun4': ['s', 'un4'], 'sun5': ['s', 'un5'], 'suo1': ['s', 'uo1'], 'suo2': ['s', 'uo2'], 'suo3': ['s', 'uo3'], 'suo4': ['s', 'uo4'], 'suo5': ['s', 'uo5'], 
                      'ta1': ['t', 'a1'], 'ta2': ['t', 'a2'], 'ta3': ['t', 'a3'], 'ta4': ['t', 'a4'], 'ta5': ['t', 'a5'], 'tai1': ['t', 'ai1'], 'tai2': ['t', 'ai2'], 'tai3': ['t', 'ai3'], 'tai4': ['t', 'ai4'], 'tai5': ['t', 'ai5'], 'tan1': ['t', 'an1'], 'tan2': ['t', 'an2'], 'tan3': ['t', 'an3'], 'tan4': ['t', 'an4'], 'tan5': ['t', 'an5'], 'tang1': ['t', 'ang1'], 'tang2': ['t', 'ang2'], 'tang3': ['t', 'ang3'], 'tang4': ['t', 'ang4'], 'tang5': ['t', 'ang5'], 'tao1': ['t', 'ao1'], 'tao2': ['t', 'ao2'], 'tao3': ['t', 'ao3'], 'tao4': ['t', 'ao4'], 'tao5': ['t', 'ao5'], 'te1': ['t', 'e1'], 'te2': ['t', 'e2'], 'te3': ['t', 'e3'], 'te4': ['t', 'e4'], 'te5': ['t', 'e5'], 'tei1': ['t', 'ei1'], 'tei2': ['t', 'ei2'], 'tei3': ['t', 'ei3'], 'tei4': ['t', 'ei4'], 'tei5': ['t', 'ei5'], 'teng1': ['t', 'eng1'], 'teng2': ['t', 'eng2'], 'teng3': ['t', 'eng3'], 'teng4': ['t', 'eng4'], 'teng5': ['t', 'eng5'], 'ti1': ['t', 'i1'], 'ti2': ['t', 'i2'], 'ti3': ['t', 'i3'], 'ti4': ['t', 'i4'], 'ti5': ['t', 'i5'], 'tian1': ['t', 'ian1'], 'tian2': ['t', 'ian2'], 'tian3': ['t', 'ian3'], 'tian4': ['t', 'ian4'], 'tian5': ['t', 'ian5'], 'tiao1': ['t', 'iao1'], 'tiao2': ['t', 'iao2'], 'tiao3': ['t', 'iao3'], 'tiao4': ['t', 'iao4'], 'tiao5': ['t', 'iao5'], 'tie1': ['t', 'ie1'], 'tie2': ['t', 'ie2'], 'tie3': ['t', 'ie3'], 'tie4': ['t', 'ie4'], 'tie5': ['t', 'ie5'], 'ting1': ['t', 'ing1'], 'ting2': ['t', 'ing2'], 'ting3': ['t', 'ing3'], 'ting4': ['t', 'ing4'], 'ting5': ['t', 'ing5'], 'tong1': ['t', 'ong1'], 'tong2': ['t', 'ong2'], 'tong3': ['t', 'ong3'], 'tong4': ['t', 'ong4'], 'tong5': ['t', 'ong5'], 'tou1': ['t', 'ou1'], 'tou2': ['t', 'ou2'], 'tou3': ['t', 'ou3'], 'tou4': ['t', 'ou4'], 'tou5': ['t', 'ou5'], 'tu1': ['t', 'u1'], 'tu2': ['t', 'u2'], 'tu3': ['t', 'u3'], 'tu4': ['t', 'u4'], 'tu5': ['t', 'u5'], 'tuan1': ['t', 'uan1'], 'tuan2': ['t', 'uan2'], 'tuan3': ['t', 'uan3'], 'tuan4': ['t', 'uan4'], 'tuan5': ['t', 'uan5'], 'tui1': ['t', 'ui1'], 'tui2': ['t', 'ui2'], 'tui3': ['t', 'ui3'], 'tui4': ['t', 'ui4'], 'tui5': ['t', 'ui5'], 'tun1': ['t', 'un1'], 'tun2': ['t', 'un2'], 'tun3': ['t', 'un3'], 'tun4': ['t', 'un4'], 'tun5': ['t', 'un5'], 'tuo1': ['t', 'uo1'], 'tuo2': ['t', 'uo2'], 'tuo3': ['t', 'uo3'], 'tuo4': ['t', 'uo4'], 'tuo5': ['t', 'uo5'], 
                      'wa1': ['w', 'a1'], 'wa2': ['w', 'a2'], 'wa3': ['w', 'a3'], 'wa4': ['w', 'a4'], 'wa5': ['w', 'a5'], 'wai1': ['w', 'ai1'], 'wai2': ['w', 'ai2'], 'wai3': ['w', 'ai3'], 'wai4': ['w', 'ai4'], 'wai5': ['w', 'ai5'], 'wan1': ['w', 'an1'], 'wan2': ['w', 'an2'], 'wan3': ['w', 'an3'], 'wan4': ['w', 'an4'], 'wan5': ['w', 'an5'], 'wang1': ['w', 'ang1'], 'wang2': ['w', 'ang2'], 'wang3': ['w', 'ang3'], 'wang4': ['w', 'ang4'], 'wang5': ['w', 'ang5'], 'wei1': ['w', 'ei1'], 'wei2': ['w', 'ei2'], 'wei3': ['w', 'ei3'], 'wei4': ['w', 'ei4'], 'wei5': ['w', 'ei5'], 'wen1': ['w', 'en1'], 'wen2': ['w', 'en2'], 'wen3': ['w', 'en3'], 'wen4': ['w', 'en4'], 'wen5': ['w', 'en5'], 'weng1': ['w', 'eng1'], 'weng2': ['w', 'eng2'], 'weng3': ['w', 'eng3'], 'weng4': ['w', 'eng4'], 'weng5': ['w', 'eng5'], 'wo1': ['w', 'o1'], 'wo2': ['w', 'o2'], 'wo3': ['w', 'o3'], 'wo4': ['w', 'o4'], 'wo5': ['w', 'o5'], 'wu1': ['w', 'u1'], 'wu2': ['w', 'u2'], 'wu3': ['w', 'u3'], 'wu4': ['w', 'u4'], 'wu5': ['w', 'u5'], 
                      'xi1': ['x', 'i1'], 'xi2': ['x', 'i2'], 'xi3': ['x', 'i3'], 'xi4': ['x', 'i4'], 'xi5': ['x', 'i5'], 'xia1': ['x', 'ia1'], 'xia2': ['x', 'ia2'], 'xia3': ['x', 'ia3'], 'xia4': ['x', 'ia4'], 'xia5': ['x', 'ia5'], 'xian1': ['x', 'ian1'], 'xian2': ['x', 'ian2'], 'xian3': ['x', 'ian3'], 'xian4': ['x', 'ian4'], 'xian5': ['x', 'ian5'], 'xiang1': ['x', 'iang1'], 'xiang2': ['x', 'iang2'], 'xiang3': ['x', 'iang3'], 'xiang4': ['x', 'iang4'], 'xiang5': ['x', 'iang5'], 'xiao1': ['x', 'iao1'], 'xiao2': ['x', 'iao2'], 'xiao3': ['x', 'iao3'], 'xiao4': ['x', 'iao4'], 'xiao5': ['x', 'iao5'], 'xie1': ['x', 'ie1'], 'xie2': ['x', 'ie2'], 'xie3': ['x', 'ie3'], 'xie4': ['x', 'ie4'], 'xie5': ['x', 'ie5'], 'xin1': ['x', 'in1'], 'xin2': ['x', 'in2'], 'xin3': ['x', 'in3'], 'xin4': ['x', 'in4'], 'xin5': ['x', 'in5'], 'xing1': ['x', 'ing1'], 'xing2': ['x', 'ing2'], 'xing3': ['x', 'ing3'], 'xing4': ['x', 'ing4'], 'xing5': ['x', 'ing5'], 'xiong1': ['x', 'iong1'], 'xiong2': ['x', 'iong2'], 'xiong3': ['x', 'iong3'], 'xiong4': ['x', 'iong4'], 'xiong5': ['x', 'iong5'], 'xiu1': ['x', 'iu1'], 'xiu2': ['x', 'iu2'], 'xiu3': ['x', 'iu3'], 'xiu4': ['x', 'iu4'], 'xiu5': ['x', 'iu5'], 'xu1': ['x', 'v1'], 'xu2': ['x', 'v2'], 'xu3': ['x', 'v3'], 'xu4': ['x', 'v4'], 'xu5': ['x', 'v5'], 'xv1': ['x', 'v1'], 'xv2': ['x', 'v2'], 'xv3': ['x', 'v3'], 'xv4': ['x', 'v4'], 'xv5': ['x', 'v5'], 'xuan1': ['x', 'van1'], 'xuan2': ['x', 'van2'], 'xuan3': ['x', 'van3'], 'xuan4': ['x', 'van4'], 'xuan5': ['x', 'van5'], 'xvan1': ['x', 'van1'], 'xvan2': ['x', 'van2'], 'xvan3': ['x', 'van3'], 'xvan4': ['x', 'van4'], 'xvan5': ['x', 'van5'], 'xue1': ['x', 've1'], 'xue2': ['x', 've2'], 'xue3': ['x', 've3'], 'xue4': ['x', 've4'], 'xue5': ['x', 've5'], 'xve1': ['x', 've1'], 'xve2': ['x', 've2'], 'xve3': ['x', 've3'], 'xve4': ['x', 've4'], 'xve5': ['x', 've5'], 'xun1': ['x', 'vn1'], 'xun2': ['x', 'vn2'], 'xun3': ['x', 'vn3'], 'xun4': ['x', 'vn4'], 'xun5': ['x', 'vn5'], 'xvn1': ['x', 'vn1'], 'xvn2': ['x', 'vn2'], 'xvn3': ['x', 'vn3'], 'xvn4': ['x', 'vn4'], 'xvn5': ['x', 'vn5'], 
                      'ya1': ['y', 'a1'], 'ya2': ['y', 'a2'], 'ya3': ['y', 'a3'], 'ya4': ['y', 'a4'], 'ya5': ['y', 'a5'], 'yan1': ['y', 'En1'], 'yan2': ['y', 'En2'], 'yan3': ['y', 'En3'], 'yan4': ['y', 'En4'], 'yan5': ['y', 'En5'], 'yang1': ['y', 'ang1'], 'yang2': ['y', 'ang2'], 'yang3': ['y', 'ang3'], 'yang4': ['y', 'ang4'], 'yang5': ['y', 'ang5'], 'yao1': ['y', 'ao1'], 'yao2': ['y', 'ao2'], 'yao3': ['y', 'ao3'], 'yao4': ['y', 'ao4'], 'yao5': ['y', 'ao5'], 'ye1': ['y', 'E1'], 'ye2': ['y', 'E2'], 'ye3': ['y', 'E3'], 'ye4': ['y', 'E4'], 'ye5': ['y', 'E5'], 'yi1': ['y', 'i1'], 'yi2': ['y', 'i2'], 'yi3': ['y', 'i3'], 'yi4': ['y', 'i4'], 'yi5': ['y', 'i5'], 'yin1': ['y', 'in1'], 'yin2': ['y', 'in2'], 'yin3': ['y', 'in3'], 'yin4': ['y', 'in4'], 'yin5': ['y', 'in5'], 'ying1': ['y', 'ing1'], 'ying2': ['y', 'ing2'], 'ying3': ['y', 'ing3'], 'ying4': ['y', 'ing4'], 'ying5': ['y', 'ing5'], 'yo1': ['y', 'o1'], 'yo2': ['y', 'o2'], 'yo3': ['y', 'o3'], 'yo4': ['y', 'o4'], 'yo5': ['y', 'o5'], 'yong1': ['y', 'ong1'], 'yong2': ['y', 'ong2'], 'yong3': ['y', 'ong3'], 'yong4': ['y', 'ong4'], 'yong5': ['y', 'ong5'], 'you1': ['y', 'ou1'], 'you2': ['y', 'ou2'], 'you3': ['y', 'ou3'], 'you4': ['y', 'ou4'], 'you5': ['y', 'ou5'], 'yu1': ['y', 'v1'], 'yu2': ['y', 'v2'], 'yu3': ['y', 'v3'], 'yu4': ['y', 'v4'], 'yu5': ['y', 'v5'], 'yv1': ['y', 'v1'], 'yv2': ['y', 'v2'], 'yv3': ['y', 'v3'], 'yv4': ['y', 'v4'], 'yv5': ['y', 'v5'], 'yuan1': ['y', 'van1'], 'yuan2': ['y', 'van2'], 'yuan3': ['y', 'van3'], 'yuan4': ['y', 'van4'], 'yuan5': ['y', 'van5'], 'yvan1': ['y', 'van1'], 'yvan2': ['y', 'van2'], 'yvan3': ['y', 'van3'], 'yvan4': ['y', 'van4'], 'yvan5': ['y', 'van5'], 'yue1': ['y', 've1'], 'yue2': ['y', 've2'], 'yue3': ['y', 've3'], 'yue4': ['y', 've4'], 'yue5': ['y', 've5'], 'yve1': ['y', 've1'], 'yve2': ['y', 've2'], 'yve3': ['y', 've3'], 'yve4': ['y', 've4'], 'yve5': ['y', 've5'], 'yun1': ['y', 'vn1'], 'yun2': ['y', 'vn2'], 'yun3': ['y', 'vn3'], 'yun4': ['y', 'vn4'], 'yun5': ['y', 'vn5'], 'yvn1': ['y', 'vn1'], 'yvn2': ['y', 'vn2'], 'yvn3': ['y', 'vn3'], 'yvn4': ['y', 'vn4'], 'yvn5': ['y', 'vn5'], 
                      'za1': ['z', 'a1'], 'za2': ['z', 'a2'], 'za3': ['z', 'a3'], 'za4': ['z', 'a4'], 'za5': ['z', 'a5'], 'zai1': ['z', 'ai1'], 'zai2': ['z', 'ai2'], 'zai3': ['z', 'ai3'], 'zai4': ['z', 'ai4'], 'zai5': ['z', 'ai5'], 'zan1': ['z', 'an1'], 'zan2': ['z', 'an2'], 'zan3': ['z', 'an3'], 'zan4': ['z', 'an4'], 'zan5': ['z', 'an5'], 'zang1': ['z', 'ang1'], 'zang2': ['z', 'ang2'], 'zang3': ['z', 'ang3'], 'zang4': ['z', 'ang4'], 'zang5': ['z', 'ang5'], 'zao1': ['z', 'ao1'], 'zao2': ['z', 'ao2'], 'zao3': ['z', 'ao3'], 'zao4': ['z', 'ao4'], 'zao5': ['z', 'ao5'], 'ze1': ['z', 'e1'], 'ze2': ['z', 'e2'], 'ze3': ['z', 'e3'], 'ze4': ['z', 'e4'], 'ze5': ['z', 'e5'], 'zei1': ['z', 'ei1'], 'zei2': ['z', 'ei2'], 'zei3': ['z', 'ei3'], 'zei4': ['z', 'ei4'], 'zei5': ['z', 'ei5'], 'zen1': ['z', 'en1'], 'zen2': ['z', 'en2'], 'zen3': ['z', 'en3'], 'zen4': ['z', 'en4'], 'zen5': ['z', 'en5'], 'zeng1': ['z', 'eng1'], 'zeng2': ['z', 'eng2'], 'zeng3': ['z', 'eng3'], 'zeng4': ['z', 'eng4'], 'zeng5': ['z', 'eng5'], 'zha1': ['zh', 'a1'], 'zha2': ['zh', 'a2'], 'zha3': ['zh', 'a3'], 'zha4': ['zh', 'a4'], 'zha5': ['zh', 'a5'], 'zhai1': ['zh', 'ai1'], 'zhai2': ['zh', 'ai2'], 'zhai3': ['zh', 'ai3'], 'zhai4': ['zh', 'ai4'], 'zhai5': ['zh', 'ai5'], 'zhan1': ['zh', 'an1'], 'zhan2': ['zh', 'an2'], 'zhan3': ['zh', 'an3'], 'zhan4': ['zh', 'an4'], 'zhan5': ['zh', 'an5'], 'zhang1': ['zh', 'ang1'], 'zhang2': ['zh', 'ang2'], 'zhang3': ['zh', 'ang3'], 'zhang4': ['zh', 'ang4'], 'zhang5': ['zh', 'ang5'], 'zhao1': ['zh', 'ao1'], 'zhao2': ['zh', 'ao2'], 'zhao3': ['zh', 'ao3'], 'zhao4': ['zh', 'ao4'], 'zhao5': ['zh', 'ao5'], 'zhe1': ['zh', 'e1'], 'zhe2': ['zh', 'e2'], 'zhe3': ['zh', 'e3'], 'zhe4': ['zh', 'e4'], 'zhe5': ['zh', 'e5'], 'zhei1': ['zh', 'ei1'], 'zhei2': ['zh', 'ei2'], 'zhei3': ['zh', 'ei3'], 'zhei4': ['zh', 'ei4'], 'zhei5': ['zh', 'ei5'], 'zhen1': ['zh', 'en1'], 'zhen2': ['zh', 'en2'], 'zhen3': ['zh', 'en3'], 'zhen4': ['zh', 'en4'], 'zhen5': ['zh', 'en5'], 'zheng1': ['zh', 'eng1'], 'zheng2': ['zh', 'eng2'], 'zheng3': ['zh', 'eng3'], 'zheng4': ['zh', 'eng4'], 'zheng5': ['zh', 'eng5'], 'zhi1': ['zh', 'ir1'], 'zhi2': ['zh', 'ir2'], 'zhi3': ['zh', 'ir3'], 'zhi4': ['zh', 'ir4'], 'zhi5': ['zh', 'ir5'], 'zhong1': ['zh', 'ong1'], 'zhong2': ['zh', 'ong2'], 'zhong3': ['zh', 'ong3'], 'zhong4': ['zh', 'ong4'], 'zhong5': ['zh', 'ong5'], 'zhou1': ['zh', 'ou1'], 'zhou2': ['zh', 'ou2'], 'zhou3': ['zh', 'ou3'], 'zhou4': ['zh', 'ou4'], 'zhou5': ['zh', 'ou5'], 'zhu1': ['zh', 'u1'], 'zhu2': ['zh', 'u2'], 'zhu3': ['zh', 'u3'], 'zhu4': ['zh', 'u4'], 'zhu5': ['zh', 'u5'], 'zhua1': ['zh', 'ua1'], 'zhua2': ['zh', 'ua2'], 'zhua3': ['zh', 'ua3'], 'zhua4': ['zh', 'ua4'], 'zhua5': ['zh', 'ua5'], 'zhuai1': ['zh', 'uai1'], 'zhuai2': ['zh', 'uai2'], 'zhuai3': ['zh', 'uai3'], 'zhuai4': ['zh', 'uai4'], 'zhuai5': ['zh', 'uai5'], 'zhuan1': ['zh', 'uan1'], 'zhuan2': ['zh', 'uan2'], 'zhuan3': ['zh', 'uan3'], 'zhuan4': ['zh', 'uan4'], 'zhuan5': ['zh', 'uan5'], 'zhuang1': ['zh', 'uang1'], 'zhuang2': ['zh', 'uang2'], 'zhuang3': ['zh', 'uang3'], 'zhuang4': ['zh', 'uang4'], 'zhuang5': ['zh', 'uang5'], 'zhui1': ['zh', 'ui1'], 'zhui2': ['zh', 'ui2'], 'zhui3': ['zh', 'ui3'], 'zhui4': ['zh', 'ui4'], 'zhui5': ['zh', 'ui5'], 'zhun1': ['zh', 'un1'], 'zhun2': ['zh', 'un2'], 'zhun3': ['zh', 'un3'], 'zhun4': ['zh', 'un4'], 'zhun5': ['zh', 'un5'], 'zhuo1': ['zh', 'uo1'], 'zhuo2': ['zh', 'uo2'], 'zhuo3': ['zh', 'uo3'], 'zhuo4': ['zh', 'uo4'], 'zhuo5': ['zh', 'uo5'], 'zi1': ['z', 'ii1'], 'zi2': ['z', 'ii2'], 'zi3': ['z', 'ii3'], 'zi4': ['z', 'ii4'], 'zi5': ['z', 'ii5'], 'zong1': ['z', 'ong1'], 'zong2': ['z', 'ong2'], 'zong3': ['z', 'ong3'], 'zong4': ['z', 'ong4'], 'zong5': ['z', 'ong5'], 'zou1': ['z', 'ou1'], 'zou2': ['z', 'ou2'], 'zou3': ['z', 'ou3'], 'zou4': ['z', 'ou4'], 'zou5': ['z', 'ou5'], 'zu1': ['z', 'u1'], 'zu2': ['z', 'u2'], 'zu3': ['z', 'u3'], 'zu4': ['z', 'u4'], 'zu5': ['z', 'u5'], 'zuan1': ['z', 'uan1'], 'zuan2': ['z', 'uan2'], 'zuan3': ['z', 'uan3'], 'zuan4': ['z', 'uan4'], 'zuan5': ['z', 'uan5'], 'zui1': ['z', 'ui1'], 'zui2': ['z', 'ui2'], 'zui3': ['z', 'ui3'], 'zui4': ['z', 'ui4'], 'zui5': ['z', 'ui5'], 'zun1': ['z', 'un1'], 'zun2': ['z', 'un2'], 'zun3': ['z', 'un3'], 'zun4': ['z', 'un4'], 'zun5': ['z', 'un5'], 'zuo1': ['z', 'uo1'], 'zuo2': ['z', 'uo2'], 'zuo3': ['z', 'uo3'], 'zuo4': ['z', 'uo4'], 'zuo5': ['z', 'uo5']}


en_phone_set = [
    "AH0",
    "S",
    "AH1",
    "EY2",
    "AE2",
    "EH0",
    "OW2",
    "UH0",
    "NG",
    "B",
    "G",
    "AY0",
    "M",
    "AA0",
    "F",
    "AO0",
    "ER2",
    "UH1",
    "IY1",
    "AH2",
    "DH",
    "IY0",
    "EY1",
    "IH0",
    "K",
    "N",
    "W",
    "IY2",
    "T",
    "AA1",
    "ER1",
    "EH2",
    "OY0",
    "UH2",
    "UW1",
    "Z",
    "AW2",
    "AW1",
    "V",
    "UW2",
    "AA2",
    "ER",
    "AW0",
    "UW0",
    "R",
    "OW1",
    "EH1",
    "ZH",
    "AE0",
    "IH2",
    "IH",
    "Y",
    "JH",
    "P",
    "AY1",
    "EY0",
    "OY2",
    "TH",
    "HH",
    "D",
    "ER0",
    "CH",
    "AO1",
    "AE1",
    "AO2",
    "OY1",
    "AY2",
    "IH1",
    "OW0",
    "L",
    "SH",
]

all_phone_set = [] + sorted(set(base_phone_set)) + sorted(set(cn_phone_set)) + sorted(set(en_phone_set))
all_phone_dict = {xx:idx for idx, xx in enumerate(all_phone_set)}
