# Generated by Django 2.2.16 on 2020-10-03 16:17

from django.db import migrations, models
import django.db.models.deletion
import django_lifecycle.mixins
import uuid


def migrate_deprecated(apps, schema_editor):
    Collection = apps.get_model('ansible', 'Collection')
    AnsibleCollectionDeprecated = apps.get_model('ansible', 'AnsibleCollectionDeprecated')
    RepositoryVersion = apps.get_model('core', 'RepositoryVersion')
    for collection in Collection.objects.filter(deprecated=True):
        for cv in collection.versions.all():
            for repository_content in cv.version_memberships.all():
                version_removed_kwarg = {}
                if repository_content.version_removed:
                    version_removed_kwarg['number__lte'] = repository_content.version_removed.number
                for repository_version in RepositoryVersion.objects.filter(
                        repository=repository_content.repository,
                        number__gte=repository_content.version_added.number,
                        **version_removed_kwarg):
                    AnsibleCollectionDeprecated.objects.get_or_create(
                        collection=collection, repository_version=repository_version
                    )


class Migration(migrations.Migration):

    dependencies = [
        ('ansible', '0025_increase_collection_version_version_size'),
    ]

    operations = [
        migrations.CreateModel(
            name='AnsibleCollectionDeprecated',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('collection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ansible.Collection')),
                ('repository_version', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='collection_memberships', to='core.RepositoryVersion')),
            ],
            options={
                'unique_together': {('collection', 'repository_version')},
            },
            bases=(django_lifecycle.mixins.LifecycleModelMixin, models.Model),
        ),
        migrations.RunPython(migrate_deprecated, elidable=True),
        migrations.RemoveField(
            model_name='collection',
            name='deprecated',
        ),
    ]
