# Generated by Django 3.2.19 on 2023-06-01 18:41

from django.db import migrations, models
from semantic_version import Version


def parse_versions(apps, *args, **kwargs):
    CollectionVersion = apps.get_model('ansible', 'CollectionVersion')

    to_update = []
    fields = ["version_major", "version_minor", "version_patch", "version_prerelease"]
    for cv in CollectionVersion.objects.all().only("version"):
        v = Version(cv.version)

        cv.version_major = v.major
        cv.version_minor = v.minor
        cv.version_patch = v.patch
        cv.version_prerelease = ".".join(v.prerelease)

        to_update.append(cv)

        if len(to_update) > 1000:
            CollectionVersion.objects.bulk_update(to_update, fields)
            to_update = []

    CollectionVersion.objects.bulk_update(to_update, fields)


class Migration(migrations.Migration):

    dependencies = [
        ('ansible', '0053_collectiondownloadcount'),
    ]

    operations = [
        migrations.AddField(
            model_name='collectionversion',
            name='version_major',
            field=models.IntegerField(default=0),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='collectionversion',
            name='version_minor',
            field=models.IntegerField(default=0),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='collectionversion',
            name='version_patch',
            field=models.IntegerField(default=0),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='collectionversion',
            name='version_prerelease',
            field=models.CharField(default='', max_length=128),
            preserve_default=False,
        ),
        migrations.RunPython(
            code=parse_versions,
            reverse_code=migrations.RunPython.noop,
            elidable=True,
        ),
        migrations.AlterField(
            model_name="collectiondownloadcount",
            name="name",
            field=models.CharField(db_index=True, editable=False, max_length=64),
        ),
        migrations.AlterField(
            model_name="collectiondownloadcount",
            name="namespace",
            field=models.CharField(db_index=True, editable=False, max_length=64),
        ),
    ]
