# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0] - 2025-10-14

### Added
- Initial release of InternetSpeedTest Python CLI
- Support for LibreSpeed protocol compatibility
- Command-line interface with multiple output formats (simple, JSON, CSV)
- Python library API for programmatic usage
- Download and upload speed testing
- Ping and jitter measurements
- Custom server list support
- Progress indicators with clean visual feedback
- Comprehensive documentation and examples
- Compatible with internetspeedtest.net and other LibreSpeed servers

### Features
- 🚀 Fast and accurate speed testing using LibreSpeed protocol
- 📊 Download and upload speed measurements  
- 🏓 Ping and jitter measurements
- 🌐 Compatible with internetspeedtest.net and other LibreSpeed servers
- 📝 Multiple output formats (simple, JSON, CSV)
- 🔧 Customizable test parameters
- 🐍 Pure Python implementation (no dependencies on Go binaries)
- 🎨 Clean progress indicators and user experience
- 📚 Comprehensive documentation and examples

### Technical Details
- Python 3.7+ support
- LibreSpeed protocol implementation
- Multi-threaded testing for optimal performance
- Clean progress visualization with proper cleanup
- Robust error handling and timeout management
- Extensible server selection algorithms