# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventOrchestrationGlobalCacheVariableArgs', 'EventOrchestrationGlobalCacheVariable']

@pulumi.input_type
class EventOrchestrationGlobalCacheVariableArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input['EventOrchestrationGlobalCacheVariableConfigurationArgs'],
                 event_orchestration: pulumi.Input[builtins.str],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['EventOrchestrationGlobalCacheVariableConditionArgs']]]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EventOrchestrationGlobalCacheVariable resource.
        :param pulumi.Input['EventOrchestrationGlobalCacheVariableConfigurationArgs'] configuration: A configuration object to define what and how values will be stored in the Cache Variable.
        :param pulumi.Input[builtins.str] event_orchestration: ID of the Global Event Orchestration to which this Cache Variable belongs.
        :param pulumi.Input[Sequence[pulumi.Input['EventOrchestrationGlobalCacheVariableConditionArgs']]] conditions: Conditions to be evaluated in order to determine whether or not to update the Cache Variable's stored value. This attribute can only be used when `configuration.0.type` is `recent_value` or `trigger_event_count`.
        :param pulumi.Input[builtins.bool] disabled: Indicates whether the Cache Variable is disabled and would therefore not be evaluated.
        :param pulumi.Input[builtins.str] name: Name of the Cache Variable associated with the Global Event Orchestration.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "event_orchestration", event_orchestration)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input['EventOrchestrationGlobalCacheVariableConfigurationArgs']:
        """
        A configuration object to define what and how values will be stored in the Cache Variable.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input['EventOrchestrationGlobalCacheVariableConfigurationArgs']):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="eventOrchestration")
    def event_orchestration(self) -> pulumi.Input[builtins.str]:
        """
        ID of the Global Event Orchestration to which this Cache Variable belongs.
        """
        return pulumi.get(self, "event_orchestration")

    @event_orchestration.setter
    def event_orchestration(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "event_orchestration", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventOrchestrationGlobalCacheVariableConditionArgs']]]]:
        """
        Conditions to be evaluated in order to determine whether or not to update the Cache Variable's stored value. This attribute can only be used when `configuration.0.type` is `recent_value` or `trigger_event_count`.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventOrchestrationGlobalCacheVariableConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the Cache Variable is disabled and would therefore not be evaluated.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Cache Variable associated with the Global Event Orchestration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _EventOrchestrationGlobalCacheVariableState:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['EventOrchestrationGlobalCacheVariableConditionArgs']]]] = None,
                 configuration: Optional[pulumi.Input['EventOrchestrationGlobalCacheVariableConfigurationArgs']] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_orchestration: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EventOrchestrationGlobalCacheVariable resources.
        :param pulumi.Input[Sequence[pulumi.Input['EventOrchestrationGlobalCacheVariableConditionArgs']]] conditions: Conditions to be evaluated in order to determine whether or not to update the Cache Variable's stored value. This attribute can only be used when `configuration.0.type` is `recent_value` or `trigger_event_count`.
        :param pulumi.Input['EventOrchestrationGlobalCacheVariableConfigurationArgs'] configuration: A configuration object to define what and how values will be stored in the Cache Variable.
        :param pulumi.Input[builtins.bool] disabled: Indicates whether the Cache Variable is disabled and would therefore not be evaluated.
        :param pulumi.Input[builtins.str] event_orchestration: ID of the Global Event Orchestration to which this Cache Variable belongs.
        :param pulumi.Input[builtins.str] name: Name of the Cache Variable associated with the Global Event Orchestration.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if event_orchestration is not None:
            pulumi.set(__self__, "event_orchestration", event_orchestration)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventOrchestrationGlobalCacheVariableConditionArgs']]]]:
        """
        Conditions to be evaluated in order to determine whether or not to update the Cache Variable's stored value. This attribute can only be used when `configuration.0.type` is `recent_value` or `trigger_event_count`.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventOrchestrationGlobalCacheVariableConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['EventOrchestrationGlobalCacheVariableConfigurationArgs']]:
        """
        A configuration object to define what and how values will be stored in the Cache Variable.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['EventOrchestrationGlobalCacheVariableConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the Cache Variable is disabled and would therefore not be evaluated.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="eventOrchestration")
    def event_orchestration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the Global Event Orchestration to which this Cache Variable belongs.
        """
        return pulumi.get(self, "event_orchestration")

    @event_orchestration.setter
    def event_orchestration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_orchestration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Cache Variable associated with the Global Event Orchestration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("pagerduty:index/eventOrchestrationGlobalCacheVariable:EventOrchestrationGlobalCacheVariable")
class EventOrchestrationGlobalCacheVariable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventOrchestrationGlobalCacheVariableConditionArgs', 'EventOrchestrationGlobalCacheVariableConditionArgsDict']]]]] = None,
                 configuration: Optional[pulumi.Input[Union['EventOrchestrationGlobalCacheVariableConfigurationArgs', 'EventOrchestrationGlobalCacheVariableConfigurationArgsDict']]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_orchestration: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A [Cache Variable](https://support.pagerduty.com/docs/event-orchestration-variables) can be created on a Global Event Orchestration, in order to temporarily store event data to be referenced later within the Global Event Orchestration

        ## Import

        Cache Variables can be imported using colon-separated IDs, which is the combination of the Global Event Orchestration ID followed by the Cache Variable ID, e.g.

        ```sh
        $ pulumi import pagerduty:index/eventOrchestrationGlobalCacheVariable:EventOrchestrationGlobalCacheVariable cache_variable 5e7110bf-0ee7-429e-9724-34ed1fe15ac3:138ed254-3444-44ad-8cc7-701d69def439
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventOrchestrationGlobalCacheVariableConditionArgs', 'EventOrchestrationGlobalCacheVariableConditionArgsDict']]]] conditions: Conditions to be evaluated in order to determine whether or not to update the Cache Variable's stored value. This attribute can only be used when `configuration.0.type` is `recent_value` or `trigger_event_count`.
        :param pulumi.Input[Union['EventOrchestrationGlobalCacheVariableConfigurationArgs', 'EventOrchestrationGlobalCacheVariableConfigurationArgsDict']] configuration: A configuration object to define what and how values will be stored in the Cache Variable.
        :param pulumi.Input[builtins.bool] disabled: Indicates whether the Cache Variable is disabled and would therefore not be evaluated.
        :param pulumi.Input[builtins.str] event_orchestration: ID of the Global Event Orchestration to which this Cache Variable belongs.
        :param pulumi.Input[builtins.str] name: Name of the Cache Variable associated with the Global Event Orchestration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventOrchestrationGlobalCacheVariableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A [Cache Variable](https://support.pagerduty.com/docs/event-orchestration-variables) can be created on a Global Event Orchestration, in order to temporarily store event data to be referenced later within the Global Event Orchestration

        ## Import

        Cache Variables can be imported using colon-separated IDs, which is the combination of the Global Event Orchestration ID followed by the Cache Variable ID, e.g.

        ```sh
        $ pulumi import pagerduty:index/eventOrchestrationGlobalCacheVariable:EventOrchestrationGlobalCacheVariable cache_variable 5e7110bf-0ee7-429e-9724-34ed1fe15ac3:138ed254-3444-44ad-8cc7-701d69def439
        ```

        :param str resource_name: The name of the resource.
        :param EventOrchestrationGlobalCacheVariableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventOrchestrationGlobalCacheVariableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventOrchestrationGlobalCacheVariableConditionArgs', 'EventOrchestrationGlobalCacheVariableConditionArgsDict']]]]] = None,
                 configuration: Optional[pulumi.Input[Union['EventOrchestrationGlobalCacheVariableConfigurationArgs', 'EventOrchestrationGlobalCacheVariableConfigurationArgsDict']]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_orchestration: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventOrchestrationGlobalCacheVariableArgs.__new__(EventOrchestrationGlobalCacheVariableArgs)

            __props__.__dict__["conditions"] = conditions
            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["disabled"] = disabled
            if event_orchestration is None and not opts.urn:
                raise TypeError("Missing required property 'event_orchestration'")
            __props__.__dict__["event_orchestration"] = event_orchestration
            __props__.__dict__["name"] = name
        super(EventOrchestrationGlobalCacheVariable, __self__).__init__(
            'pagerduty:index/eventOrchestrationGlobalCacheVariable:EventOrchestrationGlobalCacheVariable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventOrchestrationGlobalCacheVariableConditionArgs', 'EventOrchestrationGlobalCacheVariableConditionArgsDict']]]]] = None,
            configuration: Optional[pulumi.Input[Union['EventOrchestrationGlobalCacheVariableConfigurationArgs', 'EventOrchestrationGlobalCacheVariableConfigurationArgsDict']]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            event_orchestration: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'EventOrchestrationGlobalCacheVariable':
        """
        Get an existing EventOrchestrationGlobalCacheVariable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventOrchestrationGlobalCacheVariableConditionArgs', 'EventOrchestrationGlobalCacheVariableConditionArgsDict']]]] conditions: Conditions to be evaluated in order to determine whether or not to update the Cache Variable's stored value. This attribute can only be used when `configuration.0.type` is `recent_value` or `trigger_event_count`.
        :param pulumi.Input[Union['EventOrchestrationGlobalCacheVariableConfigurationArgs', 'EventOrchestrationGlobalCacheVariableConfigurationArgsDict']] configuration: A configuration object to define what and how values will be stored in the Cache Variable.
        :param pulumi.Input[builtins.bool] disabled: Indicates whether the Cache Variable is disabled and would therefore not be evaluated.
        :param pulumi.Input[builtins.str] event_orchestration: ID of the Global Event Orchestration to which this Cache Variable belongs.
        :param pulumi.Input[builtins.str] name: Name of the Cache Variable associated with the Global Event Orchestration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventOrchestrationGlobalCacheVariableState.__new__(_EventOrchestrationGlobalCacheVariableState)

        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["event_orchestration"] = event_orchestration
        __props__.__dict__["name"] = name
        return EventOrchestrationGlobalCacheVariable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.EventOrchestrationGlobalCacheVariableCondition']]]:
        """
        Conditions to be evaluated in order to determine whether or not to update the Cache Variable's stored value. This attribute can only be used when `configuration.0.type` is `recent_value` or `trigger_event_count`.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.EventOrchestrationGlobalCacheVariableConfiguration']:
        """
        A configuration object to define what and how values will be stored in the Cache Variable.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the Cache Variable is disabled and would therefore not be evaluated.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="eventOrchestration")
    def event_orchestration(self) -> pulumi.Output[builtins.str]:
        """
        ID of the Global Event Orchestration to which this Cache Variable belongs.
        """
        return pulumi.get(self, "event_orchestration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Cache Variable associated with the Global Event Orchestration.
        """
        return pulumi.get(self, "name")

