# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAlertGroupingSettingResult',
    'AwaitableGetAlertGroupingSettingResult',
    'get_alert_grouping_setting',
    'get_alert_grouping_setting_output',
]

@pulumi.output_type
class GetAlertGroupingSettingResult:
    """
    A collection of values returned by getAlertGroupingSetting.
    """
    def __init__(__self__, config=None, description=None, id=None, name=None, services=None, type=None):
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def config(self) -> Optional['outputs.GetAlertGroupingSettingConfigResult']:
        """
        The values for the configuration setup for this setting.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description of this alert grouping setting.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the found alert grouping setting.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The short name of the found alert grouping setting.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def services(self) -> Sequence[builtins.str]:
        """
        A list of string containing the IDs of services associated with this setting.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of object. The value returned will be one of `content_based`, `content_based_intelligent`, `intelligent` or `time`.
        """
        return pulumi.get(self, "type")


class AwaitableGetAlertGroupingSettingResult(GetAlertGroupingSettingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertGroupingSettingResult(
            config=self.config,
            description=self.description,
            id=self.id,
            name=self.name,
            services=self.services,
            type=self.type)


def get_alert_grouping_setting(config: Optional[Union['GetAlertGroupingSettingConfigArgs', 'GetAlertGroupingSettingConfigArgsDict']] = None,
                               name: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertGroupingSettingResult:
    """
    Use this data source to get information about a specific [alert grouping setting](https://developer.pagerduty.com/api-reference/9b5a6c8d7379b-get-an-alert-grouping-setting).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    example = pagerduty.get_alert_grouping_setting(name="My example setting")
    ```


    :param Union['GetAlertGroupingSettingConfigArgs', 'GetAlertGroupingSettingConfigArgsDict'] config: The values for the configuration setup for this setting.
    :param builtins.str name: The name to use to find an alert grouping setting in the PagerDuty API.
    """
    __args__ = dict()
    __args__['config'] = config
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getAlertGroupingSetting:getAlertGroupingSetting', __args__, opts=opts, typ=GetAlertGroupingSettingResult).value

    return AwaitableGetAlertGroupingSettingResult(
        config=pulumi.get(__ret__, 'config'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        services=pulumi.get(__ret__, 'services'),
        type=pulumi.get(__ret__, 'type'))
def get_alert_grouping_setting_output(config: Optional[pulumi.Input[Optional[Union['GetAlertGroupingSettingConfigArgs', 'GetAlertGroupingSettingConfigArgsDict']]]] = None,
                                      name: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlertGroupingSettingResult]:
    """
    Use this data source to get information about a specific [alert grouping setting](https://developer.pagerduty.com/api-reference/9b5a6c8d7379b-get-an-alert-grouping-setting).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    example = pagerduty.get_alert_grouping_setting(name="My example setting")
    ```


    :param Union['GetAlertGroupingSettingConfigArgs', 'GetAlertGroupingSettingConfigArgsDict'] config: The values for the configuration setup for this setting.
    :param builtins.str name: The name to use to find an alert grouping setting in the PagerDuty API.
    """
    __args__ = dict()
    __args__['config'] = config
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getAlertGroupingSetting:getAlertGroupingSetting', __args__, opts=opts, typ=GetAlertGroupingSettingResult)
    return __ret__.apply(lambda __response__: GetAlertGroupingSettingResult(
        config=pulumi.get(__response__, 'config'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        services=pulumi.get(__response__, 'services'),
        type=pulumi.get(__response__, 'type')))
