# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEventOrchestrationServiceCacheVariableResult',
    'AwaitableGetEventOrchestrationServiceCacheVariableResult',
    'get_event_orchestration_service_cache_variable',
    'get_event_orchestration_service_cache_variable_output',
]

@pulumi.output_type
class GetEventOrchestrationServiceCacheVariableResult:
    """
    A collection of values returned by getEventOrchestrationServiceCacheVariable.
    """
    def __init__(__self__, conditions=None, configurations=None, disabled=None, id=None, name=None, service=None):
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if configurations and not isinstance(configurations, list):
            raise TypeError("Expected argument 'configurations' to be a list")
        pulumi.set(__self__, "configurations", configurations)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if service and not isinstance(service, str):
            raise TypeError("Expected argument 'service' to be a str")
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetEventOrchestrationServiceCacheVariableConditionResult']:
        """
        Conditions to be evaluated in order to determine whether or not to update the Cache Variable's stored value. This attribute can only be used when `configuration.0.type` is `recent_value` or `trigger_event_count`.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetEventOrchestrationServiceCacheVariableConfigurationResult']:
        """
        A configuration object to define what and how values will be stored in the Cache Variable.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter
    def disabled(self) -> builtins.bool:
        """
        Indicates whether the Cache Variable is disabled and would therefore not be evaluated.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> builtins.str:
        return pulumi.get(self, "service")


class AwaitableGetEventOrchestrationServiceCacheVariableResult(GetEventOrchestrationServiceCacheVariableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventOrchestrationServiceCacheVariableResult(
            conditions=self.conditions,
            configurations=self.configurations,
            disabled=self.disabled,
            id=self.id,
            name=self.name,
            service=self.service)


def get_event_orchestration_service_cache_variable(id: Optional[builtins.str] = None,
                                                   name: Optional[builtins.str] = None,
                                                   service: Optional[builtins.str] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventOrchestrationServiceCacheVariableResult:
    """
    Use this data source to get information about a specific [Cache Variable](https://support.pagerduty.com/docs/event-orchestration-variables) for a Service Event Orchestration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    engineering = pagerduty.Team("engineering", name="Engineering")
    example = pagerduty.User("example",
        name="Earline Greenholt",
        email="125.greenholt.earline@graham.name",
        teams=[engineering.id])
    example_escalation_policy = pagerduty.EscalationPolicy("example",
        name="Engineering Escalation Policy",
        num_loops=2,
        rules=[{
            "escalation_delay_in_minutes": 10,
            "targets": [{
                "type": "user",
                "id": example.id,
            }],
        }])
    service = pagerduty.Service("service",
        name="My Web App",
        auto_resolve_timeout="14400",
        acknowledgement_timeout="600",
        escalation_policy=example_escalation_policy.id,
        alert_creation="create_alerts_and_incidents")
    cache_variable = pagerduty.get_event_orchestration_service_cache_variable_output(service=service.id,
        name="example_cache_variable")
    ```


    :param builtins.str id: ID of the Cache Variable associated with the Service Event Orchestration. Specify either `id` or `name`. If both are specified `id` takes precedence.
    :param builtins.str name: Name of the Cache Variable associated with the Service Event Orchestration. Specify either `id` or `name`. If both are specified `id` takes precedence.
    :param builtins.str service: ID of the Service Event Orchestration to which this Cache Variable belongs.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['service'] = service
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getEventOrchestrationServiceCacheVariable:getEventOrchestrationServiceCacheVariable', __args__, opts=opts, typ=GetEventOrchestrationServiceCacheVariableResult).value

    return AwaitableGetEventOrchestrationServiceCacheVariableResult(
        conditions=pulumi.get(__ret__, 'conditions'),
        configurations=pulumi.get(__ret__, 'configurations'),
        disabled=pulumi.get(__ret__, 'disabled'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        service=pulumi.get(__ret__, 'service'))
def get_event_orchestration_service_cache_variable_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                          name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                          service: Optional[pulumi.Input[builtins.str]] = None,
                                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEventOrchestrationServiceCacheVariableResult]:
    """
    Use this data source to get information about a specific [Cache Variable](https://support.pagerduty.com/docs/event-orchestration-variables) for a Service Event Orchestration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    engineering = pagerduty.Team("engineering", name="Engineering")
    example = pagerduty.User("example",
        name="Earline Greenholt",
        email="125.greenholt.earline@graham.name",
        teams=[engineering.id])
    example_escalation_policy = pagerduty.EscalationPolicy("example",
        name="Engineering Escalation Policy",
        num_loops=2,
        rules=[{
            "escalation_delay_in_minutes": 10,
            "targets": [{
                "type": "user",
                "id": example.id,
            }],
        }])
    service = pagerduty.Service("service",
        name="My Web App",
        auto_resolve_timeout="14400",
        acknowledgement_timeout="600",
        escalation_policy=example_escalation_policy.id,
        alert_creation="create_alerts_and_incidents")
    cache_variable = pagerduty.get_event_orchestration_service_cache_variable_output(service=service.id,
        name="example_cache_variable")
    ```


    :param builtins.str id: ID of the Cache Variable associated with the Service Event Orchestration. Specify either `id` or `name`. If both are specified `id` takes precedence.
    :param builtins.str name: Name of the Cache Variable associated with the Service Event Orchestration. Specify either `id` or `name`. If both are specified `id` takes precedence.
    :param builtins.str service: ID of the Service Event Orchestration to which this Cache Variable belongs.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['service'] = service
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getEventOrchestrationServiceCacheVariable:getEventOrchestrationServiceCacheVariable', __args__, opts=opts, typ=GetEventOrchestrationServiceCacheVariableResult)
    return __ret__.apply(lambda __response__: GetEventOrchestrationServiceCacheVariableResult(
        conditions=pulumi.get(__response__, 'conditions'),
        configurations=pulumi.get(__response__, 'configurations'),
        disabled=pulumi.get(__response__, 'disabled'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        service=pulumi.get(__response__, 'service')))
