# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    """
    A collection of values returned by getService.
    """
    def __init__(__self__, acknowledgement_timeout=None, alert_creation=None, auto_resolve_timeout=None, description=None, escalation_policy=None, id=None, name=None, teams=None, type=None):
        if acknowledgement_timeout and not isinstance(acknowledgement_timeout, int):
            raise TypeError("Expected argument 'acknowledgement_timeout' to be a int")
        pulumi.set(__self__, "acknowledgement_timeout", acknowledgement_timeout)
        if alert_creation and not isinstance(alert_creation, str):
            raise TypeError("Expected argument 'alert_creation' to be a str")
        pulumi.set(__self__, "alert_creation", alert_creation)
        if auto_resolve_timeout and not isinstance(auto_resolve_timeout, int):
            raise TypeError("Expected argument 'auto_resolve_timeout' to be a int")
        pulumi.set(__self__, "auto_resolve_timeout", auto_resolve_timeout)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if escalation_policy and not isinstance(escalation_policy, str):
            raise TypeError("Expected argument 'escalation_policy' to be a str")
        pulumi.set(__self__, "escalation_policy", escalation_policy)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if teams and not isinstance(teams, list):
            raise TypeError("Expected argument 'teams' to be a list")
        pulumi.set(__self__, "teams", teams)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="acknowledgementTimeout")
    def acknowledgement_timeout(self) -> builtins.int:
        """
        Time in seconds that an incident changes to the Triggered State after being Acknowledged. Value is null if the feature is disabled. Value must not be negative. Setting this field to 0, null (or unset) will disable the feature.
        """
        return pulumi.get(self, "acknowledgement_timeout")

    @property
    @pulumi.getter(name="alertCreation")
    def alert_creation(self) -> builtins.str:
        """
        Whether a service creates only incidents, or both alerts and incidents. A service must create alerts in order to enable incident merging.
        """
        return pulumi.get(self, "alert_creation")

    @property
    @pulumi.getter(name="autoResolveTimeout")
    def auto_resolve_timeout(self) -> builtins.int:
        """
        Time in seconds that an incident is automatically resolved if left open for that long. Value is null if the feature is disabled. Value must not be negative. Setting this field to 0, null (or unset) will disable the feature.
        """
        return pulumi.get(self, "auto_resolve_timeout")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The user-provided description of the service.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="escalationPolicy")
    def escalation_policy(self) -> builtins.str:
        """
        The escalation policy associated with this service.
        """
        return pulumi.get(self, "escalation_policy")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the found service.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The short name of the found service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def teams(self) -> Sequence['outputs.GetServiceTeamResult']:
        """
        The set of teams associated with the service.
        """
        return pulumi.get(self, "teams")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of object. The value returned will be `service`. Can be used for passing to a service dependency.
        """
        return pulumi.get(self, "type")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            acknowledgement_timeout=self.acknowledgement_timeout,
            alert_creation=self.alert_creation,
            auto_resolve_timeout=self.auto_resolve_timeout,
            description=self.description,
            escalation_policy=self.escalation_policy,
            id=self.id,
            name=self.name,
            teams=self.teams,
            type=self.type)


def get_service(name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    Use this data source to get information about a specific [service](https://api-reference.pagerduty.com/#!/Services/get_services).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    example = pagerduty.get_service(name="My Service")
    datadog = pagerduty.get_vendor(name="Datadog")
    example_service_integration = pagerduty.ServiceIntegration("example",
        name="Datadog Integration",
        vendor=datadog.id,
        service=example.id,
        type="generic_events_api_inbound_integration")
    ```


    :param builtins.str name: The service name to use to find a service in the PagerDuty API.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getService:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        acknowledgement_timeout=pulumi.get(__ret__, 'acknowledgement_timeout'),
        alert_creation=pulumi.get(__ret__, 'alert_creation'),
        auto_resolve_timeout=pulumi.get(__ret__, 'auto_resolve_timeout'),
        description=pulumi.get(__ret__, 'description'),
        escalation_policy=pulumi.get(__ret__, 'escalation_policy'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        teams=pulumi.get(__ret__, 'teams'),
        type=pulumi.get(__ret__, 'type'))
def get_service_output(name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    Use this data source to get information about a specific [service](https://api-reference.pagerduty.com/#!/Services/get_services).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    example = pagerduty.get_service(name="My Service")
    datadog = pagerduty.get_vendor(name="Datadog")
    example_service_integration = pagerduty.ServiceIntegration("example",
        name="Datadog Integration",
        vendor=datadog.id,
        service=example.id,
        type="generic_events_api_inbound_integration")
    ```


    :param builtins.str name: The service name to use to find a service in the PagerDuty API.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getService:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        acknowledgement_timeout=pulumi.get(__response__, 'acknowledgement_timeout'),
        alert_creation=pulumi.get(__response__, 'alert_creation'),
        auto_resolve_timeout=pulumi.get(__response__, 'auto_resolve_timeout'),
        description=pulumi.get(__response__, 'description'),
        escalation_policy=pulumi.get(__response__, 'escalation_policy'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        teams=pulumi.get(__response__, 'teams'),
        type=pulumi.get(__response__, 'type')))
