# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStandardsResult',
    'AwaitableGetStandardsResult',
    'get_standards',
    'get_standards_output',
]

@pulumi.output_type
class GetStandardsResult:
    """
    A collection of values returned by getStandards.
    """
    def __init__(__self__, id=None, resource_type=None, standards=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if standards and not isinstance(standards, list):
            raise TypeError("Expected argument 'standards' to be a list")
        pulumi.set(__self__, "standards", standards)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[builtins.str]:
        """
        Specifies the type of resource to which the standard applies.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def standards(self) -> Sequence['outputs.GetStandardsStandardResult']:
        """
        The list of standards defined.
        """
        return pulumi.get(self, "standards")


class AwaitableGetStandardsResult(GetStandardsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStandardsResult(
            id=self.id,
            resource_type=self.resource_type,
            standards=self.standards)


def get_standards(resource_type: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStandardsResult:
    """
    Use this data source to get information about the [standards](https://developer.pagerduty.com/api-reference/dbed9a0ff9355-list-standards) applicable to
    the PagerDuty account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    standards = pagerduty.get_standards()
    ```


    :param builtins.str resource_type: Filter by `resource_type` the received standards. Allowed values are `technical_service`.
    """
    __args__ = dict()
    __args__['resourceType'] = resource_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getStandards:getStandards', __args__, opts=opts, typ=GetStandardsResult).value

    return AwaitableGetStandardsResult(
        id=pulumi.get(__ret__, 'id'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        standards=pulumi.get(__ret__, 'standards'))
def get_standards_output(resource_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStandardsResult]:
    """
    Use this data source to get information about the [standards](https://developer.pagerduty.com/api-reference/dbed9a0ff9355-list-standards) applicable to
    the PagerDuty account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    standards = pagerduty.get_standards()
    ```


    :param builtins.str resource_type: Filter by `resource_type` the received standards. Allowed values are `technical_service`.
    """
    __args__ = dict()
    __args__['resourceType'] = resource_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getStandards:getStandards', __args__, opts=opts, typ=GetStandardsResult)
    return __ret__.apply(lambda __response__: GetStandardsResult(
        id=pulumi.get(__response__, 'id'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        standards=pulumi.get(__response__, 'standards')))
